/*This REXX script requires OS/2 with the Y2K fixes for REXX*/
'@echo off'
say
say "RENF.CMD by Marko Zarkovic, Ottawa Canada, 2000"
say "RENF.CMD renames a file using the date attributes to form a unique name"
say "using the 8.3 naming rule. The file extension is preserved."

/*functions to load+++++++++++++++++++++++++++++*/ 
call RxFuncAdd 'SysFileTree', 'RexxUtil', 'SysFileTree'

/*variables to set+++++++++++++++++++++++++++++*/


/*variables to leave alone+++++++++++++++++++++++++++++*/
parse arg fname

/*main ++++++++++++++++++++++++++++++++++++++*/
Say
if fname = '' then do
 say "Syntax: RENF filename.nnn"
 exit
end
say
say "Searching for" fname "..."
rc=SysFileTree(fname, fstr, TFL)

if fstr.0 = 0 then signal QuickEnd
else say Found

say fstr.1
parse var fstr.1 ye '-' mo '-' da ' ' ho ':' mi ':' se fstr.1
parse var fname part1 '.' part2

ti = (ho*60) + mi

call MkName
call fnametest

ren fname newnam
say fname "has been renamed to" newnam

say
say "Here's what the name means:"
say "The first three digits are the year expressed in hexadecimal." 
say "The next letter is the month, where A=1, B=2 ..." 
say "The next is the day: letters A..Z for 1..26 and 1..5 for 27..31." 
say "Last is the ordinal minute of the day, expressed in hexadecimal."
say "(There are 1440 minutes in a day.)"
say

exit

/*^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^*/
/* Start of SR ++++++++++++++++++++++++++++++++*/
/* end of SR -------------------------------------*/


/* Start of SR ++++++++++++++++++++++++++++++++*/
QuickEnd:
say "I can't find the file."
exit
/* end of SR -------------------------------------*/


/* Start of SR ++++++++++++++++++++++++++++++++*/
fnametest:
UID = 0
do while UID = 0
 rc=SysFileTree(newnam, fstr, TF)
 if fstr.0 = 0 then do
  say "A unique name has been found."
  UID = 1
 end
 else do
  say "There is another file with the intended name."
  say "Trying to find a unique new name."
  ti = ti +1
  xti = d2x(ti)
  newnam = ye || mo || da || xti || '.' || part2
 end
end
return

/* end of SR -------------------------------------*/


/* Start of SR ++++++++++++++++++++++++++++++++*/
MkName:
select
when mo = 01 then mo = a
when mo = 02 then mo = b
when mo = 03 then mo = c
when mo = 04 then mo = d
when mo = 05 then mo = e
when mo = 06 then mo = f
when mo = 07 then mo = g
when mo = 08 then mo = h
when mo = 09 then mo = i
when mo = 10 then mo = j
when mo = 11 then mo = k
when mo = 12 then mo = l
otherwise mo = mo
end


select
when da = 01 then da = a
when da = 02 then da = b
when da = 03 then da = c
when da = 04 then da = d
when da = 05 then da = e
when da = 06 then da = f
when da = 07 then da = g
when da = 08 then da = h
when da = 09 then da = i
when da = 10 then da = j
when da = 11 then da = k
when da = 12 then da = l
when da = 13 then da = m
when da = 14 then da = n
when da = 15 then da = o
when da = 16 then da = p
when da = 17 then da = q
when da = 18 then da = r
when da = 19 then da = s
when da = 20 then da = t
when da = 21 then da = u
when da = 22 then da = v
when da = 23 then da = w
when da = 24 then da = x
when da = 25 then da = y
when da = 26 then da = z
when da = 27 then da = 1
when da = 28 then da = 2
when da = 29 then da = 3
when da = 30 then da = 4
when da = 31 then da = 5
otherwise da = da
end

ye = d2x(ye)
xti = d2x(ti)

newnam = ye || mo || da || xti || '.' || part2

return

/* end of SR -------------------------------------*/
