#define INCL_DOS
#include <os2.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>

typedef struct
{
   char * jpg_name;
   char * jpg_string;
   int jpg_len;
} JPG;
typedef JPG * PJPG;

void load (PJPG [], char *, USHORT *);

main ()
{
   int indx;

   HDIR hdir = 0xFFFF;
   FILEFINDBUF findbuf;
   USHORT usSearchCount = 1, num_jpgs = 0, curr_jpg = 0, comp_jpg;
   PJPG * pjpg;

   printf ("Loading");

   if (DosFindFirst ("*.JPG", &hdir, FILE_NORMAL,
                     &findbuf, sizeof (findbuf),
                     &usSearchCount, 0L) != 0)
   {
      printf ("\nNo .JPG files found\n");
      return 96;
   }
   do num_jpgs++;
   while (DosFindNext (hdir,
                       &findbuf,
                       sizeof (findbuf),
                       &usSearchCount) == 0);
   printf (" %d JPGs; please wait...\n", num_jpgs);

   pjpg = (PJPG *) malloc ((num_jpgs) * sizeof (PJPG));

   usSearchCount = 1;
   DosFindFirst ("*.JPG", &hdir, FILE_NORMAL,
                 &findbuf, sizeof (findbuf),
                 &usSearchCount, 0L);

   do load (pjpg, findbuf.achName, &curr_jpg);
   while (DosFindNext (hdir,
                       &findbuf,
                       sizeof (findbuf),
                       &usSearchCount) == 0);

   printf ("Comparing JPGs...\n");

   for (curr_jpg = 0; curr_jpg < num_jpgs; curr_jpg++)
      for (comp_jpg = curr_jpg + 1; comp_jpg < num_jpgs; comp_jpg++)
         if (pjpg [curr_jpg]->jpg_len == pjpg [comp_jpg]->jpg_len)
         {
            for (indx = 0; indx < pjpg [curr_jpg]->jpg_len; indx++)
            {
               if (pjpg [curr_jpg]->jpg_string [indx] != pjpg [comp_jpg]->jpg_string [indx])
               {
                  indx = -1;
                  break;
               }
            }
            if (indx > 0)
               printf ("%s matches %s\n",
                       pjpg [curr_jpg]->jpg_name,
                       pjpg [comp_jpg]->jpg_name);
         }

   return 0;
}


void load (PJPG pjpg [], char * filename, USHORT * curr_jpg)
{
   char * s;
   int count;
   FILE *filenum;

   pjpg [*curr_jpg] = (PJPG) malloc (sizeof (JPG));

   pjpg [*curr_jpg]->jpg_name = (char *) malloc ((1 + strlen (filename)) * sizeof (char));
   strcpy (pjpg [*curr_jpg]->jpg_name, filename);

   filenum = fopen (filename, "r+b");
   if (filenum == NULL)
   {
      printf ("Cannot open %s\n", filename);
      exit (99);
   }
   pjpg [*curr_jpg]->jpg_len = filelength (fileno (filenum));

   if ((pjpg [*curr_jpg]->jpg_string = (char *) malloc ((1 + pjpg [*curr_jpg]->jpg_len) * sizeof (char))) == NULL)
   {
      printf ("Cannot allocate space\n");
      exit (98);
   }
   count = fread (pjpg [*curr_jpg]->jpg_string, sizeof (char), pjpg [*curr_jpg]->jpg_len, filenum);
   fclose (filenum);

   (*curr_jpg)++;
}
