/* VisPro/REXX */

call RxFuncAdd 'VpLoadFuncs', 'VpRexx', 'VpLoadFuncs'
call VpLoadFuncs

parse source . . _VPMacroName
_VPAppHandle = VpInit(_VPMacroName)
drop _VPMacroName
if _VPAppHandle='' then exit
_VPAppReturn = 0

/* Open first form */
Parse arg topic
_VPMainWindow = VpOpenForm('', 256, topic)
if _VPMainWindow='' then do
   call VpMessageBox 0,'VisPro/REXX','Unable to open Main form.  Verify that there is a Main form, that it has an id of 256, and that the form has controls within it.'
   signal _VPAppExit
end

do until ( _VPEventCall=='')
   _VPEventCall = VpGetMsg(_VPAppHandle)
   Interpret _VpEventCall
end
/* Terminate application */
_VPAppExit:
call VpQuit _VPAppHandle
return _VPAppReturn


/* ##261_1000.0 */
261_1000.0: /* Event  WP, Clicked/selected */
Arg window self



/* Get button state WP Radio Button */
Flag = VpIsSelected(window,'WP')
/* Get index of first selected item LAUNCH List Box */
Index=VpGetIndex(window,'LAUNCH','SELECTED',0)
Application_SelectFlag = 1
App_Num = 1
File_Category = "WP"
Total_Apps = Setup.Application.File_Category.NName.0
IF Flag = 1 & Index > 0 THEN DO
	CALL SELAPP
	Application_SelectFlag = 0
END	/*Ends "IF Flag = 1 & Index > 0 THEN DO" Section*/

return

/* ##261_1001.0 */
261_1001.0: /* Event  N_ED, Clicked/selected */
Arg window self



/* Get button state N_ED Radio Button */
Flag = VpIsSelected(window,'N_ED')
/* Is item showing? APP1 Radio Button */
IsShowingFlag=VpItem(window,'APP1','ISSHOWING')
IF Flag = 1 THEN DO
	SELECT
		WHEN Application_SelectFlag = 0 THEN DO
			Application_SelectFlag = 2
			File_Category = "N_ED"
			Total_Apps = Setup.Application.File_Category.NName.0
			CALL MULTAPPS
		END	/*Ends "WHEN Application_SelectFlag = 0 THEN DO" Section*/

		WHEN IsShowingFlag = 1 THEN DO
			Application_SelectFlag = 0
			RC = .Timing~Delay(0.01)
			/* Uncheck the item N_ED Radio Button */
			CALL VpSelect window,'N_ED',0
			/* Check the item  AUTO Radio Button */
			CALL VpSelect window,'AUTO',1
			CALL AUTOLNCH
			/* Check the item  MANUAL Radio Button */
			CALL VpSelect window,'MANUAL',1
			CALL MANLNCH
		END	/*Ends "WHEN IsShowingFlag = 1 THEN DO" Section*/

		OTHERWISE NOP
	END	/*Ends "SELECT" Section*/
END	/*Ends "IF Flag = 1 THEN DO" Section*/
return

/* ##261_1002.0 */
261_1002.0: /* Event  R_ED, Clicked/selected */
Arg window self



/* Get button state R_ED Radio Button */
Flag = VpIsSelected(window,'R_ED')
/* Is item showing? APP1 Radio Button */
IsShowingFlag=VpItem(window,'APP1','ISSHOWING')
IF Flag = 1 THEN DO
	SELECT
		WHEN Application_SelectFlag = 0 THEN DO
			Application_SelectFlag = 3
			File_Category = "R_ED"
			Total_Apps = Setup.Application.File_Category.NName.0
			CALL MULTAPPS
		END	/*Ends "WHEN Application_SelectFlag = 0 THEN DO" Section*/

		WHEN IsShowingFlag = 1 THEN DO
			Application_SelectFlag = 0
			RC = .Timing~Delay(0.01)
			/* Uncheck the item R_ED Radio Button */
			CALL VpSelect window,'R_ED',0
			/* Check the item  AUTO Radio Button */
			CALL VpSelect window,'AUTO',1
			CALL AUTOLNCH
			/* Check the item  MANUAL Radio Button */
			CALL VpSelect window,'MANUAL',1
			CALL MANLNCH
		END	/*Ends "WHEN IsShowingFlag = 1 THEN DO" Section*/

		OTHERWISE NOP
	END	/*Ends "SELECT" Section*/
END	/*Ends "IF Flag = 1 THEN DO" Section*/
return

/* ##261_1003.0 */
261_1003.0: /* Event Cancel  1003, Clicked/selected */
Arg window self



Cancel = "CANCELLED"
CALL VpNotify window,Cancel
CALL VpWindow window,'CLOSE'
LaunchFormID = ""
return

/* ##261_1004.0 */
261_1004.0: /* Event  L_ED, Clicked/selected */
Arg window self



/* Get button state L_ED Radio Button */
Flag = VpIsSelected(window,'L_ED')
/* Get index of first selected item LAUNCH List Box */
Index=VpGetIndex(window,'LAUNCH','SELECTED',0)
Application_SelectFlag = 1
App_Num = 1
File_Category = "L_ED"
Total_Apps = Setup.Application.File_Category.NName.0
IF Flag = 1 & Index > 0 THEN DO
	CALL SELAPP
	Application_SelectFlag = 0
END	/*Ends "IF Flag = 1 & Index > 0 THEN DO" Section*/
return

/* ##261_1005.0 */
261_1005.0: /* Event  R_R, Clicked/selected */
Arg window self



/* Get button state R_R Radio Button */
Flag = VpIsSelected(window,'R_R')
/* Is item showing? APP1 Radio Button */
IsShowingFlag=VpItem(window,'APP1','ISSHOWING')
IF Flag = 1 THEN DO
	SELECT
		WHEN Application_SelectFlag = 0 THEN DO
			Application_SelectFlag = 5
			File_Category = "R_R"
			Total_Apps = Setup.Application.File_Category.NName.0
			CALL MULTAPPS
		END	/*Ends "WHEN Application_SelectFlag = 0 THEN DO" Section*/

		WHEN IsShowingFlag = 1 THEN DO
			Application_SelectFlag = 0
			RC = .Timing~Delay(0.01)
			/* Uncheck the item R_R Radio Button */
			CALL VpSelect window,'R_R',0
			/* Check the item  AUTO Radio Button */
			CALL VpSelect window,'AUTO',1
			CALL AUTOLNCH
			/* Check the item  MANUAL Radio Button */
			CALL VpSelect window,'MANUAL',1
			CALL MANLNCH
		END	/*Ends "WHEN IsShowingFlag = 1 THEN DO" Section*/

		OTHERWISE NOP
	END	/*Ends "SELECT" Section*/
END	/*Ends "IF Flag = 1 THEN DO" Section*/
return

/* ##261_1006.0 */
261_1006.0: /* Event List Box LAUNCH, Clicked/selected */
Arg window self



Auto_to_ManualFlag = 0
File_SelectFlag = 1
/* Get button state AUTO Radio Button */
AutoFlag = VpIsSelected(window,'AUTO')
/* Get button state MANUAL Radio Button */
ManualFlag = VpIsSelected(window,'MANUAL')
/* Get index of first selected item LAUNCH List Box */
Index=VpGetIndex(window,'LAUNCH','SELECTED',0)
SELECT
	WHEN AutoFlag = 1 & Index > 0 THEN DO
		SELECT
			WHEN File_Association.Index.1 \= "" THEN CALL FLAUNCH

			OTHERWISE DO
				Instruction = "Sorry, SEEK cannot find any application associated with this file! Please wait!"
				/* Set item value INSTRUCT Text */
				CALL VpSetItemValue window,'INSTRUCT',Instruction
				RC = .Timing~Delay(3.0)
				AutoFlag = 0
				Auto_to_ManualFlag = 1
				/* Uncheck the item AUTO Radio Button */
				CALL VpSelect window,'AUTO',0
				/* Check the item  MANUAL Radio Button */
				CALL VpSelect window,'MANUAL',1
				CALL MANLNCH
				Instruction = "Please manually launch the file by selecting the application."
				/* Set item value INSTRUCT Text */
				CALL VpSetItemValue window,'INSTRUCT',Instruction
			END	/*Ends "OTHERWISE DO" section*/
		END	/*Ends "SELECT" Section*/
	END	/*Ends "WHEN AutoFlag = 1 & Index > 0 THEN DO" Section*/

	WHEN ManualFlag = 1 & Index > 0 THEN DO
		SELECT
			WHEN Application_SelectFlag = 1 THEN DO
				CALL SELAPP
				CALL UNCKAPPS
				IF Auto_to_ManualFlag = 1 THEN DO
					Auto_to_ManualFlag = 0
					CALL AUTOLNCH
				END	/*Ends "IF Auto_to_ManualFlag = 1 THEN DO" Section*/
				Application_SelectFlag = 0
			END	/*Ends "WHEN Application_SelectFlag = 1 THEN DO" Section*/

			OTHERWISE DO
				Instruction = "You have selected a file. Now, manually launch it by selecting the application."
				/* Set item value INSTRUCT Text */
				CALL VpSetItemValue window,'INSTRUCT',Instruction
			END	/*Ends "OTHERWISE DO" Section*/
		END	/*Ends "SELECT" Section*/
	END	/*Ends "WHEN ManualFlag = 1 & Index > 0 THEN DO" Section*/

	OTHERWISE NOP
END	/*Ends "SELECT" Section*/
return

/* ##261_1007.0 */
261_1007.0: /* Event  SS, Clicked/selected */
Arg window self



/* Get button state SS Radio Button */
Flag = VpIsSelected(window,'SS')
/* Get index of first selected item LAUNCH List Box */
Index=VpGetIndex(window,'LAUNCH','SELECTED',0)
Application_SelectFlag = 1
App_Num = 1
File_Category = "SS"
Total_Apps = Setup.Application.File_Category.NName.0
IF Flag = 1 & Index > 0 THEN DO
	CALL SELAPP
	Application_SelectFlag = 0
END	/*Ends "IF Flag = 1 & Index > 0 THEN DO" Section*/
return

/* ##261_1008.0 */
261_1008.0: /* Event  FIN, Clicked/selected */
Arg window self



/* Get button state FIN Radio Button */
Flag = VpIsSelected(window,'FIN')
/* Get index of first selected item LAUNCH List Box */
Index=VpGetIndex(window,'LAUNCH','SELECTED',0)
Application_SelectFlag = 1
App_Num = 1
File_Category = "FIN"
Total_Apps = Setup.Application.File_Category.NName.0
IF Flag = 1 & Index > 0 THEN DO
	CALL SELAPP
	Application_SelectFlag = 0
END	/*Ends "IF Flag = 1 & Index > 0 THEN DO" Section*/
return

/* ##261_1009.0 */
261_1009.0: /* Event  WB, Clicked/selected */
Arg window self



/* Get button state WB Radio Button */
Flag = VpIsSelected(window,'WB')
/* Is item showing? APP1 Radio Button */
IsShowingFlag=VpItem(window,'APP1','ISSHOWING')
IF Flag = 1 THEN DO
	SELECT
		WHEN Application_SelectFlag = 0 THEN DO
			Application_SelectFlag = 8
			File_Category = "WB"
			Total_Apps = Setup.Application.File_Category.NName.0
			CALL MULTAPPS
		END	/*Ends "WHEN Application_SelectFlag = 0 THEN DO" Section*/

		WHEN IsShowingFlag = 1 THEN DO
			Application_SelectFlag = 0
			RC = .Timing~Delay(0.01)
			/* Uncheck the item WB Radio Button */
			CALL VpSelect window,'WB',0
			/* Check the item  AUTO Radio Button */
			CALL VpSelect window,'AUTO',1
			CALL AUTOLNCH
			/* Check the item  MANUAL Radio Button */
			CALL VpSelect window,'MANUAL',1
			CALL MANLNCH
		END	/*Ends "WHEN IsShowingFlag = 1 THEN DO" Section*/

		OTHERWISE NOP
	END	/*Ends "SELECT" Section*/
END	/*Ends "IF Flag = 1 THEN DO" Section*/
return

/* ##261_1010.0 */
261_1010.0: /* Event  PDF, Clicked/selected */
Arg window self



/* Get button state PDF Radio Button */
Flag = VpIsSelected(window,'PDF')
/* Is item showing? APP1 Radio Button */
IsShowingFlag=VpItem(window,'APP1','ISSHOWING')
IF Flag = 1 THEN DO
	SELECT
		WHEN Application_SelectFlag = 0 THEN DO
			Application_SelectFlag = 9
			File_Category = "PDF"
			Total_Apps = Setup.Application.File_Category.NName.0
			CALL MULTAPPS
		END	/*Ends "WHEN Application_SelectFlag = 0 THEN DO" Section*/

		WHEN IsShowingFlag = 1 THEN DO
			Application_SelectFlag = 0
			RC = .Timing~Delay(0.01)
			/* Uncheck the item PDF Radio Button */
			CALL VpSelect window,'PDF',0
			/* Check the item  AUTO Radio Button */
			CALL VpSelect window,'AUTO',1
			CALL AUTOLNCH
			/* Check the item  MANUAL Radio Button */
			CALL VpSelect window,'MANUAL',1
			CALL MANLNCH
		END	/*Ends "WHEN IsShowingFlag = 1 THEN DO" Section*/

		OTHERWISE NOP
	END	/*Ends "SELECT" Section*/
END	/*Ends "IF Flag = 1 THEN DO" Section*/
return

/* ##261_1011.0 */
261_1011.0: /* Event  PS, Clicked/selected */
Arg window self



/* Get button state PS Radio Button */
Flag = VpIsSelected(window,'PS')
/* Get index of first selected item LAUNCH List Box */
Index=VpGetIndex(window,'LAUNCH','SELECTED',0)
Application_SelectFlag = 1
App_Num = 1
File_Category = "PS"
Total_Apps = Setup.Application.File_Category.NName.0
IF Flag = 1 & Index > 0 THEN DO
	CALL SELAPP
	Application_SelectFlag = 0
END	/*Ends "IF Flag = 1 & Index > 0 THEN DO" Section*/
return

/* ##261_1012.0 */
261_1012.0: /* Event  GRAPHICS, Clicked/selected */
Arg window self



/* Get button state GRAPHICS Radio Button */
Flag = VpIsSelected(window,'GRAPHICS')
/* Get index of first selected item LAUNCH List Box */
Index=VpGetIndex(window,'LAUNCH','SELECTED',0)
Application_SelectFlag = 1
App_Num = 1
File_Category = "GRAPHICS"
Total_Apps = Setup.Application.File_Category.NName.0
IF Flag = 1 & Index > 0 THEN DO
	CALL SELAPP
	Application_SelectFlag = 0
END	/*Ends "IF Flag = 1 & Index > 0 THEN DO" Section*/
return

/* ##261_1013.0 */
261_1013.0: /* Event  DRAFTING, Clicked/selected */
Arg window self



/* Get button state DRAFTING Radio Button */
Flag = VpIsSelected(window,'DRAFTING')
/* Get index of first selected item LAUNCH List Box */
Index=VpGetIndex(window,'LAUNCH','SELECTED',0)
Application_SelectFlag = 1
App_Num = 1
File_Category = "DRAFTING"
Total_Apps = Setup.Application.File_Category.NName.0
IF Flag = 1 & Index > 0 THEN DO
	CALL SELAPP
	Application_SelectFlag = 0
END	/*Ends "IF Flag = 1 & Index > 0 THEN DO" Section*/
return

/* ##261_1014.0 */
261_1014.0: /* Event  USER_DEFINED, Clicked/selected */
Arg window self



/* Get button state USER_DEFINED Radio Button */
Flag = VpIsSelected(window,'USER_DEFINED')
/* Is item showing? APP1 Radio Button */
IsShowingFlag=VpItem(window,'APP1','ISSHOWING')
IF Flag = 1 THEN DO
	SELECT
		WHEN Application_SelectFlag = 0 THEN DO
			Application_SelectFlag = 13
			File_Category = "USER_DEFINED"
			Total_Apps = Setup.Application.File_Category.NName.0
			CALL MULTAPPS
		END	/*Ends "WHEN Application_SelectFlag = 0 THEN DO" Section*/

		WHEN IsShowingFlag = 1 THEN DO
			Application_SelectFlag = 0
			RC = .Timing~Delay(0.01)
			/* Uncheck the item USER_DEFINED Radio Button */
			CALL VpSelect window,'USER_DEFINED',0
			/* Check the item  AUTO Radio Button */
			CALL VpSelect window,'AUTO',1
			CALL AUTOLNCH
			/* Check the item  MANUAL Radio Button */
			CALL VpSelect window,'MANUAL',1
			CALL MANLNCH
		END	/*Ends "WHEN IsShowingFlag = 1 THEN DO" Section*/

		OTHERWISE NOP
	END	/*Ends "SELECT" Section*/
END	/*Ends "IF Flag = 1 THEN DO" Section*/
return

/* ##261_1015.0 */
261_1015.0: /* Event Automated AUTO, Clicked/selected */
Arg window self



CALL AUTOLNCH
return

/* ##261_1016.0 */
261_1016.0: /* Event Manual MANUAL, Clicked/selected */
Arg window self



CALL MANLNCH
return

/* ##261_1019.0 */
261_1019.0: /* Event  APP1, Clicked/selected */
Arg window self



/* Get button state APP1 Radio Button */
Flag = VpIsSelected(window,'APP1')
/* Get index of first selected item LAUNCH List Box */
Index=VpGetIndex(window,'LAUNCH','SELECTED',0)
Application_SelectFlag = 1
App_Num = 1
IF Flag = 1 & Index > 0 THEN DO
	CALL SELAPP
	Application_SelectFlag = 0
END	/*Ends "IF Flag = 1 & Index > 0 THEN DO" Section*/

return

/* ##261_1020.0 */
261_1020.0: /* Event  APP2, Clicked/selected */
Arg window self



/* Get button state APP2 Radio Button */
Flag = VpIsSelected(window,'APP2')
/* Get index of first selected item LAUNCH List Box */
Index=VpGetIndex(window,'LAUNCH','SELECTED',0)
Application_SelectFlag = 1
App_Num = 2
IF Flag = 1 & Index > 0 THEN DO
	CALL SELAPP
	Application_SelectFlag = 0
END	/*Ends "IF Flag = 1 & Index > 0 THEN DO" Section*/
return

/* ##261_1021.0 */
261_1021.0: /* Event  APP3, Clicked/selected */
Arg window self



/* Get button state APP3 Radio Button */
Flag = VpIsSelected(window,'APP3')
/* Get index of first selected item LAUNCH List Box */
Index=VpGetIndex(window,'LAUNCH','SELECTED',0)
Application_SelectFlag = 1
App_Num = 3
IF Flag = 1 & Index > 0 THEN DO
	CALL SELAPP
	Application_SelectFlag = 0
END	/*Ends "IF Flag = 1 & Index > 0 THEN DO" Section*/
return

/* ##261_1022.0 */
261_1022.0: /* Event  APP4, Clicked/selected */
Arg window self



/* Get button state APP4 Radio Button */
Flag = VpIsSelected(window,'APP4')
/* Get index of first selected item LAUNCH List Box */
Index=VpGetIndex(window,'LAUNCH','SELECTED',0)
Application_SelectFlag = 1
App_Num = 4
IF Flag = 1 & Index > 0 THEN DO
	CALL SELAPP
	Application_SelectFlag = 0
END	/*Ends "IF Flag = 1 & Index > 0 THEN DO" Section*/
return

/* ##261_1023.0 */
261_1023.0: /* Event  APP5, Clicked/selected */
Arg window self



/* Get button state APP5 Radio Button */
Flag = VpIsSelected(window,'APP5')
/* Get index of first selected item LAUNCH List Box */
Index=VpGetIndex(window,'LAUNCH','SELECTED',0)
Application_SelectFlag = 1
App_Num = 5
IF Flag = 1 & Index > 0 THEN DO
	CALL SELAPP
	Application_SelectFlag = 0
END	/*Ends "IF Flag = 1 & Index > 0 THEN DO" Section*/
return

/* ##261_1024.0 */
261_1024.0: /* Event  APP6, Clicked/selected */
Arg window self



/* Get button state APP6 Radio Button */
Flag = VpIsSelected(window,'APP6')
/* Get index of first selected item LAUNCH List Box */
Index=VpGetIndex(window,'LAUNCH','SELECTED',0)
Application_SelectFlag = 1
App_Num = 6
IF Flag = 1 & Index > 0 THEN DO
	CALL SELAPP
	Application_SelectFlag = 0
END	/*Ends "IF Flag = 1 & Index > 0 THEN DO" Section*/
return

/* ##261_1025.0 */
261_1025.0: /* Event  APP7, Clicked/selected */
Arg window self



/* Get button state APP7 Radio Button */
Flag = VpIsSelected(window,'APP7')
/* Get index of first selected item LAUNCH List Box */
Index=VpGetIndex(window,'LAUNCH','SELECTED',0)
Application_SelectFlag = 1
App_Num = 7
IF Flag = 1 & Index > 0 THEN DO
	CALL SELAPP
	Application_SelectFlag = 0
END	/*Ends "IF Flag = 1 & Index > 0 THEN DO" Section*/
return

/* ##261_1026.0 */
261_1026.0: /* Event  APP8, Clicked/selected */
Arg window self



/* Get button state APP8 Radio Button */
Flag = VpIsSelected(window,'APP8')
/* Get index of first selected item LAUNCH List Box */
Index=VpGetIndex(window,'LAUNCH','SELECTED',0)
Application_SelectFlag = 1
App_Num = 8
IF Flag = 1 & Index > 0 THEN DO
	CALL SELAPP
	Application_SelectFlag = 0
END	/*Ends "IF Flag = 1 & Index > 0 THEN DO" Section*/
return

/* ##261_1027.0 */
261_1027.0: /* Event  APP9, Clicked/selected */
Arg window self



/* Get button state APP9 Radio Button */
Flag = VpIsSelected(window,'APP9')
/* Get index of first selected item LAUNCH List Box */
Index=VpGetIndex(window,'LAUNCH','SELECTED',0)
Application_SelectFlag = 1
App_Num = 9
IF Flag = 1 & Index > 0 THEN DO
	CALL SELAPP
	Application_SelectFlag = 0
END	/*Ends "IF Flag = 1 & Index > 0 THEN DO" Section*/
return

/* ##261_1028.0 */
261_1028.0: /* Event  APP10, Clicked/selected */
Arg window self



/* Get button state APP10 Radio Button */
Flag = VpIsSelected(window,'APP10')
/* Get index of first selected item LAUNCH List Box */
Index=VpGetIndex(window,'LAUNCH','SELECTED',0)
Application_SelectFlag = 1
App_Num = 10
IF Flag = 1 & Index > 0 THEN DO
	CALL SELAPP
	Application_SelectFlag = 0
END	/*Ends "IF Flag = 1 & Index > 0 THEN DO" Section*/
return

/* ##261_1029.0 */
261_1029.0: /* Event  APP11, Clicked/selected */
Arg window self



/* Get button state APP11 Radio Button */
Flag = VpIsSelected(window,'APP11')
/* Get index of first selected item LAUNCH List Box */
Index=VpGetIndex(window,'LAUNCH','SELECTED',0)
Application_SelectFlag = 1
App_Num = 11
IF Flag = 1 & Index > 0 THEN DO
	CALL SELAPP
	Application_SelectFlag = 0
END	/*Ends "IF Flag = 1 & Index > 0 THEN DO" Section*/
return

/* ##261_1030.0 */
261_1030.0: /* Event  APP12, Clicked/selected */
Arg window self



/* Get button state APP12 Radio Button */
Flag = VpIsSelected(window,'APP12')
/* Get index of first selected item LAUNCH List Box */
Index=VpGetIndex(window,'LAUNCH','SELECTED',0)
Application_SelectFlag = 1
App_Num = 12
IF Flag = 1 & Index > 0 THEN DO
	CALL SELAPP
	Application_SelectFlag = 0
END	/*Ends "IF Flag = 1 & Index > 0 THEN DO" Section*/
return

/* ##261_1031.0 */
261_1031.0: /* Event  APP13, Clicked/selected */
Arg window self



/* Get button state APP13 Radio Button */
Flag = VpIsSelected(window,'APP13')
/* Get index of first selected item LAUNCH List Box */
Index=VpGetIndex(window,'LAUNCH','SELECTED',0)
Application_SelectFlag = 1
App_Num = 13
IF Flag = 1 & Index > 0 THEN DO
	CALL SELAPP
	Application_SelectFlag = 0
END	/*Ends "IF Flag = 1 & Index > 0 THEN DO" Section*/
return

/* ##261_1032.0 */
261_1032.0: /* Event  APP14, Clicked/selected */
Arg window self



/* Get button state APP14 Radio Button */
Flag = VpIsSelected(window,'APP14')
/* Get index of first selected item LAUNCH List Box */
Index=VpGetIndex(window,'LAUNCH','SELECTED',0)
Application_SelectFlag = 1
App_Num = 14
IF Flag = 1 & Index > 0 THEN DO
	CALL SELAPP
	Application_SelectFlag = 0
END	/*Ends "IF Flag = 1 & Index > 0 THEN DO" Section*/
return

/* ##261_1033.0 */
261_1033.0: /* Event  APP15, Clicked/selected */
Arg window self



/* Get button state APP15 Radio Button */
Flag = VpIsSelected(window,'APP15')
/* Get index of first selected item LAUNCH List Box */
Index=VpGetIndex(window,'LAUNCH','SELECTED',0)
Application_SelectFlag = 1
App_Num = 15
IF Flag = 1 & Index > 0 THEN DO
	CALL SELAPP
	Application_SelectFlag = 0
END	/*Ends "IF Flag = 1 & Index > 0 THEN DO" Section*/
return

/* ##261_1034.0 */
261_1034.0: /* Event  APP16, Clicked/selected */
Arg window self



/* Get button state APP16 Radio Button */
Flag = VpIsSelected(window,'APP16')
/* Get index of first selected item LAUNCH List Box */
Index=VpGetIndex(window,'LAUNCH','SELECTED',0)
Application_SelectFlag = 1
App_Num = 16
IF Flag = 1 & Index > 0 THEN DO
	CALL SELAPP
	Application_SelectFlag = 0
END	/*Ends "IF Flag = 1 & Index > 0 THEN DO" Section*/
return

/* ##261_1035.0 */
261_1035.0: /* Event  APP17, Clicked/selected */
Arg window self



/* Get button state APP17 Radio Button */
Flag = VpIsSelected(window,'APP17')
/* Get index of first selected item LAUNCH List Box */
Index=VpGetIndex(window,'LAUNCH','SELECTED',0)
Application_SelectFlag = 1
App_Num = 17
IF Flag = 1 & Index > 0 THEN DO
	CALL SELAPP
	Application_SelectFlag = 0
END	/*Ends "IF Flag = 1 & Index > 0 THEN DO" Section*/
return

/* ##261_1036.0 */
261_1036.0: /* Event  APP18, Clicked/selected */
Arg window self



/* Get button state APP18 Radio Button */
Flag = VpIsSelected(window,'APP18')
/* Get index of first selected item LAUNCH List Box */
Index=VpGetIndex(window,'LAUNCH','SELECTED',0)
Application_SelectFlag = 1
App_Num = 18
IF Flag = 1 & Index > 0 THEN DO
	CALL SELAPP
	Application_SelectFlag = 0
END	/*Ends "IF Flag = 1 & Index > 0 THEN DO" Section*/
return

/* ##261_1037.0 */
261_1037.0: /* Event  APP19, Clicked/selected */
Arg window self



/* Get button state APP19 Radio Button */
Flag = VpIsSelected(window,'APP19')
/* Get index of first selected item LAUNCH List Box */
Index=VpGetIndex(window,'LAUNCH','SELECTED',0)
Application_SelectFlag = 1
App_Num = 19
IF Flag = 1 & Index > 0 THEN DO
	CALL SELAPP
	Application_SelectFlag = 0
END	/*Ends "IF Flag = 1 & Index > 0 THEN DO" Section*/
return

/* ##261_1038.0 */
261_1038.0: /* Event  APP20, Clicked/selected */
Arg window self



/* Get button state APP20 Radio Button */
Flag = VpIsSelected(window,'APP20')
/* Get index of first selected item LAUNCH List Box */
Index=VpGetIndex(window,'LAUNCH','SELECTED',0)
Application_SelectFlag = 1
App_Num = 20
IF Flag = 1 & Index > 0 THEN DO
	CALL SELAPP
	Application_SelectFlag = 0
END	/*Ends "IF Flag = 1 & Index > 0 THEN DO" Section*/
return

/* ##261_Form.1 */
261_Form.1: /* Event Form events, Opened */
Arg window 



/*Begin getting the original positions and sizes of the LAUNCH form and all its controls*/
xy=VpWindow(window,'GETSIZE')
PARSE VAR xy xSSize_WinOrigin ySSize_WinOrigin
xy=VpWindow(window,'GETPOS')
PARSE VAR xy xPPos_WinOrigin yPPos_WinOrigin

/* Get item position INSTRUCT Text */
xy=VpItem(window,'INSTRUCT','ITEMPOS')
PARSE VAR xy xPPosINSTRUCTOrigin yPPosINSTRUCTOrigin
/* Get item size INSTRUCT Text */
xy=VpItem(window,'INSTRUCT','ITEMSIZE')
PARSE VAR xy xSSizeINSTRUCTOrigin ySSizeINSTRUCTOrigin

/* Get item position LAUNCH List Box */
xy=VpItem(window,'LAUNCH','ITEMPOS')
PARSE VAR xy xPPosLAUNCHOrigin yPPosLAUNCHOrigin
/* Get item size LAUNCH List Box */
xy=VpItem(window,'LAUNCH','ITEMSIZE')
PARSE VAR xy xSSizeLAUNCHOrigin ySSizeLAUNCHOrigin

/* Get item position AUTO Radio Button */
xy=VpItem(window,'AUTO','ITEMPOS')
PARSE VAR xy xPPosAUTOOrigin yPPosAUTOOrigin
/* Get item size AUTO Radio Button */
xy=VpItem(window,'AUTO','ITEMSIZE')
PARSE VAR xy xSSizeAUTOOrigin ySSizeAUTOOrigin

/* Get item position MANUAL Radio Button */
xy=VpItem(window,'MANUAL','ITEMPOS')
PARSE VAR xy xPPosMANUALOrigin yPPosMANUALOrigin
/* Get item size MANUAL Radio Button */
xy=VpItem(window,'MANUAL','ITEMSIZE')
PARSE VAR xy xSSizeMANUALOrigin ySSizeMANUALOrigin

/* Get item position LAUNCHBOX Group Box */
xy=VpItem(window,'LAUNCHBOX','ITEMPOS')
PARSE VAR xy xPPosLAUNCHBOXOrigin yPPosLAUNCHBOXOrigin
/* Get item size LAUNCHBOX Group Box */
xy=VpItem(window,'LAUNCHBOX','ITEMSIZE')
PARSE VAR xy xSSizeLAUNCHBOXOrigin ySSizeLAUNCHBOXOrigin

/* Get item position WP Radio Button */
xy=VpItem(window,'WP','ITEMPOS')
PARSE VAR xy xPPosWPOrigin yPPosWPOrigin
/* Get item size WP Radio Button */
xy=VpItem(window,'WP','ITEMSIZE')
PARSE VAR xy xSSizeWPOrigin ySSizeWPOrigin

/* Get item position N_ED Radio Button */
xy=VpItem(window,'N_ED','ITEMPOS')
PARSE VAR xy xPPosN_EDOrigin yPPosN_EDOrigin
/* Get item size N_ED Radio Button */
xy=VpItem(window,'N_ED','ITEMSIZE')
PARSE VAR xy xSSizeN_EDOrigin ySSizeN_EDOrigin

/* Get item position R_ED Radio Button */
xy=VpItem(window,'R_ED','ITEMPOS')
PARSE VAR xy xPPosR_EDOrigin yPPosR_EDOrigin
/* Get item size R_ED Radio Button */
xy=VpItem(window,'R_ED','ITEMSIZE')
PARSE VAR xy xSSizeR_EDOrigin ySSizeR_EDOrigin

/* Get item position L_ED Radio Button */
xy=VpItem(window,'L_ED','ITEMPOS')
PARSE VAR xy xPPosL_EDOrigin yPPosL_EDOrigin
/* Get item size L_ED Radio Button */
xy=VpItem(window,'L_ED','ITEMSIZE')
PARSE VAR xy xSSizeL_EDOrigin ySSizeL_EDOrigin

/* Get item position R_R Radio Button */
xy=VpItem(window,'R_R','ITEMPOS')
PARSE VAR xy xPPosR_ROrigin yPPosR_ROrigin
/* Get item size R_R Radio Button */
xy=VpItem(window,'R_R','ITEMSIZE')
PARSE VAR xy xSSizeR_ROrigin ySSizeR_ROrigin

/* Get item position SS Radio Button */
xy=VpItem(window,'SS','ITEMPOS')
PARSE VAR xy xPPosSSOrigin yPPosSSOrigin
/* Get item size SS Radio Button */
xy=VpItem(window,'SS','ITEMSIZE')
PARSE VAR xy xSSizeSSOrigin ySSizeSSOrigin

/* Get item position FIN Radio Button */
xy=VpItem(window,'FIN','ITEMPOS')
PARSE VAR xy xPPosFINOrigin yPPosFINOrigin
/* Get item size FIN Radio Button */
xy=VpItem(window,'FIN','ITEMSIZE')
PARSE VAR xy xSSizeFINOrigin ySSizeFINOrigin

/* Get item position WB Radio Button */
xy=VpItem(window,'WB','ITEMPOS')
PARSE VAR xy xPPosWBOrigin yPPosWBOrigin
/* Get item size WB Radio Button */
xy=VpItem(window,'WB','ITEMSIZE')
PARSE VAR xy xSSizeWBOrigin ySSizeWBOrigin

/* Get item position PDF Radio Button */
xy=VpItem(window,'PDF','ITEMPOS')
PARSE VAR xy xPPosPDFOrigin yPPosPDFOrigin
/* Get item size PDF Radio Button */
xy=VpItem(window,'PDF','ITEMSIZE')
PARSE VAR xy xSSizePDFOrigin ySSizePDFOrigin

/* Get item position PS Radio Button */
xy=VpItem(window,'PS','ITEMPOS')
PARSE VAR xy xPPosPSOrigin yPPosPSOrigin
/* Get item size PS Radio Button */
xy=VpItem(window,'PS','ITEMSIZE')
PARSE VAR xy xSSizePSOrigin ySSizePSOrigin

/* Get item position GRAPHICS Radio Button */
xy=VpItem(window,'GRAPHICS','ITEMPOS')
PARSE VAR xy xPPosGRAPHICSOrigin yPPosGRAPHICSOrigin
/* Get item size GRAPHICS Radio Button */
xy=VpItem(window,'GRAPHICS','ITEMSIZE')
PARSE VAR xy xSSizeGRAPHICSOrigin ySSizeGRAPHICSOrigin

/* Get item position DRAFTING Radio Button */
xy=VpItem(window,'DRAFTING','ITEMPOS')
PARSE VAR xy xPPosDRAFTINGOrigin yPPosDRAFTINGOrigin
/* Get item size DRAFTING Radio Button */
xy=VpItem(window,'DRAFTING','ITEMSIZE')
PARSE VAR xy xSSizeDRAFTINGOrigin ySSizeDRAFTINGOrigin

/* Get item position USER_DEFINED Radio Button */
xy=VpItem(window,'USER_DEFINED','ITEMPOS')
PARSE VAR xy xPPosUSER_DEFINEDOrigin yPPosUSER_DEFINEDOrigin
/* Get item size USER_DEFINED Radio Button */
xy=VpItem(window,'USER_DEFINED','ITEMSIZE')
PARSE VAR xy xSSizeUSER_DEFINEDOrigin ySSizeUSER_DEFINEDOrigin

/*Begin geting the positions and sizes of the APP1 through APP20 Radio buttons*/
DO I = 1 TO 20 BY 1
	Radio_Button = "APP"I
	xy=VpItem(window,Radio_Button,'ITEMPOS')
	PARSE VAR xy x y
	Assignment1 = "xPPos"Radio_Button"Origin = x"
	Assignment2 = "yPPos"Radio_Button"Origin = y"
	INTERPRET Assignment1
	INTERPRET Assignment2
	xy=VpItem(window,Radio_Button,'ITEMSIZE')
	PARSE VAR xy x y
	Assignment1 = "xSSize"Radio_Button"Origin = x"
	Assignment2 = "ySSize"Radio_Button"Origin = y"
	INTERPRET Assignment1
	INTERPRET Assignment2
END I	/*Ends "DO I = 1 TO 20 BY 1" Section*/
/*End getting the original positions and sizes of the LAUNCH form and all its controls*/



/*Begin setting the positions and sizes of the LAUNCH form and all its controls*/
/* Check the item MANUAL Radio Button */
CALL VpSelect window,'MANUAL',1
CALL MANLNCH
/* Check the item  AUTO Radio Button */
CALL VpSelect window,'AUTO',1
CALL AUTOLNCH
/*End setting the positions and sizes of the LAUNCH form and all its controls*/



/*Begin listing all of the files, by filename in the LAUNCH List Box*/
/* Delete all items LAUNCH List Box */
CALL VpDeleteItem window,'LAUNCH','ALL'
Launch_FileName. = ""
DO J = 1 TO OtherServicesFilePath.0 BY 1
	/*Begin specifying the path and filename of the binary file to read*/
	FilePathToRead = OtherServicesFilePath.J
	Remainder = FilePathToRead
	Data = Remainder
	DO UNTIL Remainder = ""
		PARSE VAR Data First "\" Remainder
		Data = Remainder
	END	/*Ends "DO UNTIL Remainder = """ Section*/
	Launch_FileName.J = First
	/*End specifying the path and filename of the binary file to read*/
END J	/*Ends "DO J = 1 TO OtherServicesFilePath.0 BY 1" Section*/
Launch_FileName.0 = OtherServicesFilePath.0/*


Begin adding the filenames to the LISTFILES List Box*/
SELECT
	WHEN Launch_FileName.0 > 0 THEN DO
		/* Add items from list LAUNCH List Box */
		index=VpAddItem(window, 'LAUNCH', 'LIST', 'Launch_FileName.')
		NOP
	END	/*Ends "WHEN Launch_FileName.0 > 0 THEN DO" Section*/

	OTHERWISE NOP
END	/*Ends "SELECT" Section*/
/*End listing all of the files, by filename in the LAUNCH List Box*/



/*Begin finding the file association, if any, for the listed files*/
CALL SCANEA
File_Association. = .DTTOOLS~FIND_FILE_ASSOCIATIONS(Setup., OtherServicesFilePath., ScanFilePathResults., ScanLineResults., Command_Processor_Path)
Application_SelectFlag = 0
File_SelectFlag = 0
/*End finding the file association, if any, for the listed files*/

return

/* ##256_1000.0 */
256_1000.0: /* Event Drive1 DRIVE1RADIOBUTTON, Clicked/selected */
Arg window self
DO I = 1  TO MaxDriveNumber BY 1
	SubjectDrive = "DRIVE"I"RADIOBUTTON"
	/* Get button state SubjectDrive Radio Button */
	AssignVariable = "Drive"I"RadioButtonFlag = "VpIsSelected(window,SubjectDrive)
	INTERPRET(AssignVariable)
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
FileName = VpGetItemValue(window,'FILENAME')



IF Drive1RadioButtonFlag = 1 THEN DO
	SelectType = "Single"
	IF Drive1Message \= "" THEN DO
		Title = "REMOVABLE MEDIA DRIVE WARNING!"
		response=VpMessageBox(window,Title,Drive1Message,'OKCNCL')
		IF response = "OK" THEN DO
			UpLevel = "Go up to The Opening Dialog"
			Directory = Drive1"\*.*"
			Path = Drive1
		END	/*Ends "IF response = "OK" THEN DO" Section*/

		ELSE 
		/* Uncheck the item DRIVE1RADIOBUTTON Radio Button */
		CALL VpSelect window,'DRIVE1RADIOBUTTON',0
	END	/*Ends "IF Drive1Message \= "" THEN DO" Section*/

	ELSE DO
		UpLevel = "Go up to The Opening Dialog"
		Directory = Drive1"\*.*"
		Path = Drive1
	END	/*Ends "ELSE DO" Section*/
END	/*Ends "IF Drive1RadioButtonFlag = 1 THEN DO" Section*/



Total = 0
DO I = 1  TO MaxDriveNumber BY 1
	AssignVariable = "SubjectFlag = Drive"I"RadioButtonFlag"
	INTERPRET(AssignVariable)
	Total = Total + SubjectFlag
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
CALL SEEKENDS
return

/* ##256_1001.0 */
256_1001.0: /* Event Drive2 DRIVE2RADIOBUTTON, Clicked/selected */
Arg window self
DO I = 1  TO MaxDriveNumber BY 1
	SubjectDrive = "DRIVE"I"RADIOBUTTON"
	/* Get button state SubjectDrive Radio Button */
	AssignVariable = "Drive"I"RadioButtonFlag = "VpIsSelected(window,SubjectDrive)
	INTERPRET(AssignVariable)
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
FileName = VpGetItemValue(window,'FILENAME')



IF Drive2RadioButtonFlag = 1 THEN DO
	SelectType = "Single"
	IF Drive2Message \= "" THEN DO
		Title = "REMOVABLE MEDIA DRIVE WARNING!"
		response=VpMessageBox(window,Title,Drive2Message,'OKCNCL')
		IF response = "OK" THEN DO
			UpLevel = "Go up to The Opening Dialog"
			Directory = Drive2"\*.*"
			Path = Drive2
		END	/*Ends "IF response = "OK" THEN DO" Section*/

		ELSE 
		/* Uncheck the item DRIVE2RADIOBUTTON Radio Button */
		CALL VpSelect window,'DRIVE2RADIOBUTTON',0
	END	/*Ends "IF Drive2Message \= "" THEN DO" Section*/

	ELSE DO
		UpLevel = "Go up to The Opening Dialog"
		Directory = Drive2"\*.*"
		Path = Drive2
	END	/*Ends "ELSE DO" Section*/
END	/*Ends "IF Drive2RadioButtonFlag = 1 THEN DO" Section*/



Total = 0
DO I = 1  TO MaxDriveNumber BY 1
	AssignVariable = "SubjectFlag = Drive"I"RadioButtonFlag"
	INTERPRET(AssignVariable)
	Total = Total + SubjectFlag
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
CALL SEEKENDS
return

/* ##256_1002.0 */
256_1002.0: /* Event Drive3 DRIVE3RADIOBUTTON, Clicked/selected */
Arg window self
DO I = 1  TO MaxDriveNumber BY 1
	SubjectDrive = "DRIVE"I"RADIOBUTTON"
	/* Get button state SubjectDrive Radio Button */
	AssignVariable = "Drive"I"RadioButtonFlag = "VpIsSelected(window,SubjectDrive)
	INTERPRET(AssignVariable)
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
FileName = VpGetItemValue(window,'FILENAME')



IF Drive3RadioButtonFlag = 1 THEN DO
	SelectType = "Single"
	IF Drive3Message \= "" THEN DO
		Title = "REMOVABLE MEDIA DRIVE WARNING!"
		response=VpMessageBox(window,Title,Drive3Message,'OKCNCL')
		IF response = "OK" THEN DO
			UpLevel = "Go up to The Opening Dialog"
			Directory = Drive3"\*.*"
			Path = Drive3
		END	/*Ends "IF response = "OK" THEN DO" Section*/

		ELSE 
		/* Uncheck the item DRIVE3RADIOBUTTON Radio Button */
		CALL VpSelect window,'DRIVE3RADIOBUTTON',0
	END	/*Ends "IF Drive3Message \= "" THEN DO" Section*/

	ELSE DO
		UpLevel = "Go up to The Opening Dialog"
		Directory = Drive3"\*.*"
		Path = Drive3
	END	/*Ends "ELSE DO" Section*/
END	/*Ends "IF Drive3RadioButtonFlag = 1 THEN DO" Section*/



Total = 0
DO I = 1  TO MaxDriveNumber BY 1
	AssignVariable = "SubjectFlag = Drive"I"RadioButtonFlag"
	INTERPRET(AssignVariable)
	Total = Total + SubjectFlag
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
CALL SEEKENDS
return

/* ##256_1003.0 */
256_1003.0: /* Event Drive4 DRIVE4RADIOBUTTON, Clicked/selected */
Arg window self
DO I = 1  TO MaxDriveNumber BY 1
	SubjectDrive = "DRIVE"I"RADIOBUTTON"
	/* Get button state SubjectDrive Radio Button */
	AssignVariable = "Drive"I"RadioButtonFlag = "VpIsSelected(window,SubjectDrive)
	INTERPRET(AssignVariable)
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
FileName = VpGetItemValue(window,'FILENAME')



IF Drive4RadioButtonFlag = 1 THEN DO
	SelectType = "Single"
	IF Drive4Message \= "" THEN DO
		Title = "REMOVABLE MEDIA DRIVE WARNING!"
		response=VpMessageBox(window,Title,Drive4Message,'OKCNCL')
		IF response = "OK" THEN DO
			UpLevel = "Go up to The Opening Dialog"
			Directory = Drive4"\*.*"
			Path = Drive4
		END	/*Ends "IF response = "OK" THEN DO" Section*/

		ELSE 
		/* Uncheck the item DRIVE4RADIOBUTTON Radio Button */
		CALL VpSelect window,'DRIVE4RADIOBUTTON',0
	END	/*Ends "IF Drive4Message \= "" THEN DO" Section*/

	ELSE DO
		UpLevel = "Go up to The Opening Dialog"
		Directory = Drive4"\*.*"
		Path = Drive4
	END	/*Ends "ELSE DO" Section*/
END	/*Ends "IF Drive4RadioButtonFlag = 1 THEN DO" Section*/



Total = 0
DO I = 1  TO MaxDriveNumber BY 1
	AssignVariable = "SubjectFlag = Drive"I"RadioButtonFlag"
	INTERPRET(AssignVariable)
	Total = Total + SubjectFlag
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
CALL SEEKENDS
return

/* ##256_1004.0 */
256_1004.0: /* Event Drive5 DRIVE5RADIOBUTTON, Clicked/selected */
Arg window self
DO I = 1  TO MaxDriveNumber BY 1
	SubjectDrive = "DRIVE"I"RADIOBUTTON"
	/* Get button state SubjectDrive Radio Button */
	AssignVariable = "Drive"I"RadioButtonFlag = "VpIsSelected(window,SubjectDrive)
	INTERPRET(AssignVariable)
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
FileName = VpGetItemValue(window,'FILENAME')



IF Drive5RadioButtonFlag = 1 THEN DO
	SelectType = "Single"
	IF Drive5Message \= "" THEN DO
		Title = "REMOVABLE MEDIA DRIVE WARNING!"
		response=VpMessageBox(window,Title,Drive5Message,'OKCNCL')
		IF response = "OK" THEN DO
			UpLevel = "Go up to The Opening Dialog"
			Directory = Drive5"\*.*"
			Path = Drive5
		END	/*Ends "IF response = "OK" THEN DO" Section*/

		ELSE 
		/* Uncheck the item DRIVE5RADIOBUTTON Radio Button */
		CALL VpSelect window,'DRIVE5RADIOBUTTON',0
	END	/*Ends "IF Drive5Message \= "" THEN DO" Section*/

	ELSE DO
		UpLevel = "Go up to The Opening Dialog"
		Directory = Drive5"\*.*"
		Path = Drive5
	END	/*Ends "ELSE DO" Section*/
END	/*Ends "IF Drive5RadioButtonFlag = 1 THEN DO" Section*/



Total = 0
DO I = 1  TO MaxDriveNumber BY 1
	AssignVariable = "SubjectFlag = Drive"I"RadioButtonFlag"
	INTERPRET(AssignVariable)
	Total = Total + SubjectFlag
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
CALL SEEKENDS
return

/* ##256_1005.0 */
256_1005.0: /* Event Drive6 DRIVE6RADIOBUTTON, Clicked/selected */
Arg window self
DO I = 1  TO MaxDriveNumber BY 1
	SubjectDrive = "DRIVE"I"RADIOBUTTON"
	/* Get button state SubjectDrive Radio Button */
	AssignVariable = "Drive"I"RadioButtonFlag = "VpIsSelected(window,SubjectDrive)
	INTERPRET(AssignVariable)
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
FileName = VpGetItemValue(window,'FILENAME')



IF Drive6RadioButtonFlag = 1 THEN DO
	SelectType = "Single"
	IF Drive6Message \= "" THEN DO
		Title = "REMOVABLE MEDIA DRIVE WARNING!"
		response=VpMessageBox(window,Title,Drive6Message,'OKCNCL')
		IF response = "OK" THEN DO
			UpLevel = "Go up to The Opening Dialog"
			Directory = Drive6"\*.*"
			Path = Drive6
		END	/*Ends "IF response = "OK" THEN DO" Section*/

		ELSE 
		/* Uncheck the item DRIVE6RADIOBUTTON Radio Button */
		CALL VpSelect window,'DRIVE6RADIOBUTTON',0
	END	/*Ends "IF Drive6Message \= "" THEN DO" Section*/

	ELSE DO
		UpLevel = "Go up to The Opening Dialog"
		Directory = Drive6"\*.*"
		Path = Drive6
	END	/*Ends "ELSE DO" Section*/
END	/*Ends "IF Drive6RadioButtonFlag = 1 THEN DO" Section*/



Total = 0
DO I = 1  TO MaxDriveNumber BY 1
	AssignVariable = "SubjectFlag = Drive"I"RadioButtonFlag"
	INTERPRET(AssignVariable)
	Total = Total + SubjectFlag
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
CALL SEEKENDS
return

/* ##256_1006.0 */
256_1006.0: /* Event Drive1 DRIVE1CHECKBOX, Clicked/selected */
Arg window self
DO I = 1  TO MaxDriveNumber BY 1
	SubjectDrive = "DRIVE"I"CHECKBOX"
	/* Get button state SubjectDrive Check Box */
	AssignVariable = "Drive"I"CheckBoxFlag = "VpIsSelected(window,SubjectDrive)
	INTERPRET(AssignVariable)
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
FileName = VpGetItemValue(window,'FILENAME')



IF Drive1CheckBoxFlag = 1 THEN DO
	SelectType = "Multiple"
	IF Drive1Message \= "" THEN DO
		Title = "REMOVABLE MEDIA DRIVE WARNING!"
		response=VpMessageBox(window,Title,Drive1Message,'OKCNCL')
		IF response = "OK" THEN DO
			UpLevel = "Go up to The Opening Dialog"
			Directory = Drive1"\*.*"
			Path = Drive1
		END	/*Ends "IF response = "OK" THEN DO" Section*/
	END	/*Ends "IF Drive1Message \= "" THEN DO" Section*/
	ELSE response = "OK"
	
	IF response = "OK" THEN DO
		J = 0
		Directories. = ""
		Paths. = ""
		UpLevel = "Go up to The Opening Dialog"
		DO I = 1  TO MaxDriveNumber BY 1
			SubjectDrive = "DRIVE"I"CHECKBOX"
			AssignVariable = "SubjectFlag = "VpIsSelected(window,SubjectDrive)
			INTERPRET(AssignVariable)
			IF SubjectFlag = 1 THEN DO
				J = J + 1
				AssignVariable = "SSubjectDrive = Drive"I
				INTERPRET(AssignVariable)
				Directories.J = SSubjectDrive"\*.*"
				Paths.J = SSubjectDrive
			END	/*Ends "IF SubjectFlag = 1 THEN DO" Section*/
		END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
		Paths.0 = J
	END	/*Ends "IF response = "OK" THEN DO" Section*/

	ELSE 
	/* Uncheck the item DRIVE1CHECKBOX Radio Button */
	CALL VpSelect window,'DRIVE1CHECKBOX',0
END	/*Ends "IF Drive1CheckBoxFlag = 1 THEN DO" Section*/



Total = 0
DO I = 1  TO MaxDriveNumber BY 1
	AssignVariable = "SubjectFlag = Drive"I"CheckBoxFlag"
	INTERPRET(AssignVariable)
	Total = Total + SubjectFlag
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
CALL SEEKENDS
return

/* ##256_1007.0 */
256_1007.0: /* Event Drive2 DRIVE2CHECKBOX, Clicked/selected */
Arg window self
DO I = 1  TO MaxDriveNumber BY 1
	SubjectDrive = "DRIVE"I"CHECKBOX"
	/* Get button state SubjectDrive Check Box */
	AssignVariable = "Drive"I"CheckBoxFlag = "VpIsSelected(window,SubjectDrive)
	INTERPRET(AssignVariable)
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
FileName = VpGetItemValue(window,'FILENAME')



IF Drive2CheckBoxFlag = 1 THEN DO
	SelectType = "Multiple"
	IF Drive2Message \= "" THEN DO
		Title = "REMOVABLE MEDIA DRIVE WARNING!"
		response=VpMessageBox(window,Title,Drive2Message,'OKCNCL')
		IF response = "OK" THEN DO
			UpLevel = "Go up to The Opening Dialog"
			Directory = Drive2"\*.*"
			Path = Drive2
		END	/*Ends "IF response = "OK" THEN DO" Section*/
	END	/*Ends "IF Drive2Message \= "" THEN DO" Section*/
	ELSE response = "OK"
	
	IF response = "OK" THEN DO
		J = 0
		Directories. = ""
		Paths. = ""
		UpLevel = "Go up to The Opening Dialog"
		DO I = 1  TO MaxDriveNumber BY 1
			SubjectDrive = "DRIVE"I"CHECKBOX"
			AssignVariable = "SubjectFlag = "VpIsSelected(window,SubjectDrive)
			INTERPRET(AssignVariable)
			IF SubjectFlag = 1 THEN DO
				J = J + 1
				AssignVariable = "SSubjectDrive = Drive"I
				INTERPRET(AssignVariable)
				Directories.J = SSubjectDrive"\*.*"
				Paths.J = SSubjectDrive
			END	/*Ends "IF SubjectFlag = 1 THEN DO" Section*/
		END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
		Paths.0 = J
	END	/*Ends "IF response = "OK" THEN DO" Section*/

	ELSE 
	/* Uncheck the item DRIVE2CHECKBOX Radio Button */
	CALL VpSelect window,'DRIVE2CHECKBOX',0
END	/*Ends "IF Drive2CheckBoxFlag = 1 THEN DO" Section*/



Total = 0
DO I = 1  TO MaxDriveNumber BY 1
	AssignVariable = "SubjectFlag = Drive"I"CheckBoxFlag"
	INTERPRET(AssignVariable)
	Total = Total + SubjectFlag
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
CALL SEEKENDS
return

/* ##256_1008.0 */
256_1008.0: /* Event Drive3 DRIVE3CHECKBOX, Clicked/selected */
Arg window self
DO I = 1  TO MaxDriveNumber BY 1
	SubjectDrive = "DRIVE"I"CHECKBOX"
	/* Get button state SubjectDrive Check Box */
	AssignVariable = "Drive"I"CheckBoxFlag = "VpIsSelected(window,SubjectDrive)
	INTERPRET(AssignVariable)
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
FileName = VpGetItemValue(window,'FILENAME')



IF Drive3CheckBoxFlag = 1 THEN DO
	SelectType = "Multiple"
	IF Drive3Message \= "" THEN DO
		Title = "REMOVABLE MEDIA DRIVE WARNING!"
		response=VpMessageBox(window,Title,Drive3Message,'OKCNCL')
		IF response = "OK" THEN DO
			UpLevel = "Go up to The Opening Dialog"
			Directory = Drive3"\*.*"
			Path = Drive3
		END	/*Ends "IF response = "OK" THEN DO" Section*/
	END	/*Ends "IF Drive3Message \= "" THEN DO" Section*/
	ELSE response = "OK"
	
	IF response = "OK" THEN DO
		J = 0
		Directories. = ""
		Paths. = ""
		UpLevel = "Go up to The Opening Dialog"
		DO I = 1  TO MaxDriveNumber BY 1
			SubjectDrive = "DRIVE"I"CHECKBOX"
			AssignVariable = "SubjectFlag = "VpIsSelected(window,SubjectDrive)
			INTERPRET(AssignVariable)
			IF SubjectFlag = 1 THEN DO
				J = J + 1
				AssignVariable = "SSubjectDrive = Drive"I
				INTERPRET(AssignVariable)
				Directories.J = SSubjectDrive"\*.*"
				Paths.J = SSubjectDrive
			END	/*Ends "IF SubjectFlag = 1 THEN DO" Section*/
		END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
		Paths.0 = J
	END	/*Ends "IF response = "OK" THEN DO" Section*/

	ELSE 
	/* Uncheck the item DRIVE3CHECKBOX Radio Button */
	CALL VpSelect window,'DRIVE3CHECKBOX',0
END	/*Ends "IF Drive3CheckBoxFlag = 1 THEN DO" Section*/



Total = 0
DO I = 1  TO MaxDriveNumber BY 1
	AssignVariable = "SubjectFlag = Drive"I"CheckBoxFlag"
	INTERPRET(AssignVariable)
	Total = Total + SubjectFlag
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
CALL SEEKENDS
return

/* ##256_1009.0 */
256_1009.0: /* Event Drive4 DRIVE4CHECKBOX, Clicked/selected */
Arg window self
DO I = 1  TO MaxDriveNumber BY 1
	SubjectDrive = "DRIVE"I"CHECKBOX"
	/* Get button state SubjectDrive Check Box */
	AssignVariable = "Drive"I"CheckBoxFlag = "VpIsSelected(window,SubjectDrive)
	INTERPRET(AssignVariable)
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
FileName = VpGetItemValue(window,'FILENAME')



IF Drive4CheckBoxFlag = 1 THEN DO
	SelectType = "Multiple"
	IF Drive4Message \= "" THEN DO
		Title = "REMOVABLE MEDIA DRIVE WARNING!"
		response=VpMessageBox(window,Title,Drive4Message,'OKCNCL')
		IF response = "OK" THEN DO
			UpLevel = "Go up to The Opening Dialog"
			Directory = Drive4"\*.*"
			Path = Drive4
		END	/*Ends "IF response = "OK" THEN DO" Section*/
	END	/*Ends "IF Drive4Message \= "" THEN DO" Section*/
	ELSE response = "OK"
	
	IF response = "OK" THEN DO
		J = 0
		Directories. = ""
		Paths. = ""
		UpLevel = "Go up to The Opening Dialog"
		DO I = 1  TO MaxDriveNumber BY 1
			SubjectDrive = "DRIVE"I"CHECKBOX"
			AssignVariable = "SubjectFlag = "VpIsSelected(window,SubjectDrive)
			INTERPRET(AssignVariable)
			IF SubjectFlag = 1 THEN DO
				J = J + 1
				AssignVariable = "SSubjectDrive = Drive"I
				INTERPRET(AssignVariable)
				Directories.J = SSubjectDrive"\*.*"
				Paths.J = SSubjectDrive
			END	/*Ends "IF SubjectFlag = 1 THEN DO" Section*/
		END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
		Paths.0 = J
	END	/*Ends "IF response = "OK" THEN DO" Section*/

	ELSE 
	/* Uncheck the item DRIVE4CHECKBOX Radio Button */
	CALL VpSelect window,'DRIVE4CHECKBOX',0
END	/*Ends "IF Drive4CheckBoxFlag = 1 THEN DO" Section*/



Total = 0
DO I = 1  TO MaxDriveNumber BY 1
	AssignVariable = "SubjectFlag = Drive"I"CheckBoxFlag"
	INTERPRET(AssignVariable)
	Total = Total + SubjectFlag
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
CALL SEEKENDS
return

/* ##256_1010.0 */
256_1010.0: /* Event Drive5 DRIVE5CHECKBOX, Clicked/selected */
Arg window self
DO I = 1  TO MaxDriveNumber BY 1
	SubjectDrive = "DRIVE"I"CHECKBOX"
	/* Get button state SubjectDrive Check Box */
	AssignVariable = "Drive"I"CheckBoxFlag = "VpIsSelected(window,SubjectDrive)
	INTERPRET(AssignVariable)
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
FileName = VpGetItemValue(window,'FILENAME')



IF Drive5CheckBoxFlag = 1 THEN DO
	SelectType = "Multiple"
	IF Drive5Message \= "" THEN DO
		Title = "REMOVABLE MEDIA DRIVE WARNING!"
		response=VpMessageBox(window,Title,Drive5Message,'OKCNCL')
		IF response = "OK" THEN DO
			UpLevel = "Go up to The Opening Dialog"
			Directory = Drive5"\*.*"
			Path = Drive5
		END	/*Ends "IF response = "OK" THEN DO" Section*/
	END	/*Ends "IF Drive5Message \= "" THEN DO" Section*/
	ELSE response = "OK"
	
	IF response = "OK" THEN DO
		J = 0
		Directories. = ""
		Paths. = ""
		UpLevel = "Go up to The Opening Dialog"
		DO I = 1  TO MaxDriveNumber BY 1
			SubjectDrive = "DRIVE"I"CHECKBOX"
			AssignVariable = "SubjectFlag = "VpIsSelected(window,SubjectDrive)
			INTERPRET(AssignVariable)
			IF SubjectFlag = 1 THEN DO
				J = J + 1
				AssignVariable = "SSubjectDrive = Drive"I
				INTERPRET(AssignVariable)
				Directories.J = SSubjectDrive"\*.*"
				Paths.J = SSubjectDrive
			END	/*Ends "IF SubjectFlag = 1 THEN DO" Section*/
		END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
		Paths.0 = J
	END	/*Ends "IF response = "OK" THEN DO" Section*/

	ELSE 
	/* Uncheck the item DRIVE5CHECKBOX Radio Button */
	CALL VpSelect window,'DRIVE5CHECKBOX',0
END	/*Ends "IF Drive5CheckBoxFlag = 1 THEN DO" Section*/



Total = 0
DO I = 1  TO MaxDriveNumber BY 1
	AssignVariable = "SubjectFlag = Drive"I"CheckBoxFlag"
	INTERPRET(AssignVariable)
	Total = Total + SubjectFlag
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
CALL SEEKENDS
return

/* ##256_1011.0 */
256_1011.0: /* Event Drive6 DRIVE6CHECKBOX, Clicked/selected */
Arg window self
DO I = 1  TO MaxDriveNumber BY 1
	SubjectDrive = "DRIVE"I"CHECKBOX"
	/* Get button state SubjectDrive Check Box */
	AssignVariable = "Drive"I"CheckBoxFlag = "VpIsSelected(window,SubjectDrive)
	INTERPRET(AssignVariable)
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
FileName = VpGetItemValue(window,'FILENAME')



IF Drive6CheckBoxFlag = 1 THEN DO
	SelectType = "Multiple"
	IF Drive6Message \= "" THEN DO
		Title = "REMOVABLE MEDIA DRIVE WARNING!"
		response=VpMessageBox(window,Title,Drive6Message,'OKCNCL')
		IF response = "OK" THEN DO
			UpLevel = "Go up to The Opening Dialog"
			Directory = Drive6"\*.*"
			Path = Drive6
		END	/*Ends "IF response = "OK" THEN DO" Section*/
	END	/*Ends "IF Drive6Message \= "" THEN DO" Section*/
	ELSE response = "OK"

	IF response = "OK" THEN DO
		J = 0
		Directories. = ""
		Paths. = ""
		UpLevel = "Go up to The Opening Dialog"
		DO I = 1  TO MaxDriveNumber BY 1
			SubjectDrive = "DRIVE"I"CHECKBOX"
			AssignVariable = "SubjectFlag = "VpIsSelected(window,SubjectDrive)
			INTERPRET(AssignVariable)
			IF SubjectFlag = 1 THEN DO
				J = J + 1
				AssignVariable = "SSubjectDrive = Drive"I
				INTERPRET(AssignVariable)
				Directories.J = SSubjectDrive"\*.*"
				Paths.J = SSubjectDrive
			END	/*Ends "IF SubjectFlag = 1 THEN DO" Section*/
		END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
		Paths.0 = J
	END	/*Ends "IF response = "OK" THEN DO" Section*/

	ELSE 
	/* Uncheck the item DRIVE6CHECKBOX Radio Button */
	CALL VpSelect window,'DRIVE6CHECKBOX',0
END	/*Ends "IF Drive6CheckBoxFlag = 1 THEN DO" Section*/



Total = 0
DO I = 1  TO MaxDriveNumber BY 1
	AssignVariable = "SubjectFlag = Drive"I"CheckBoxFlag"
	INTERPRET(AssignVariable)
	Total = Total + SubjectFlag
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
CALL SEEKENDS
return

/* ##256_1012.0 */
256_1012.0: /* Event Select one drive or a subdirecto SELECTONERADIOBUTTON, Clicked/selected */
Arg window self



/* Get button state SELECTONERADIOBUTTON Radio Button */
SelectOneFlag = VpIsSelected(window,'SELECTONERADIOBUTTON')
IF SelectOneFlag = 1 THEN DO
	/* Uncheck the item SELECTMULTIPLERADIOBUTTON Radio Button */
	CALL VpSelect window,'SELECTMULTIPLERADIOBUTTON',0
	/*Begin unchecking, disabling and hiding the drive checkboxes*/
	DO I = 1 TO MaxDriveNumber BY 1
		SubjectDrive = "DRIVE"I"CHECKBOX"
		/* Disable item SubjectDrive Check Box */
		CALL VpItem window,SubjectDrive,'DISABLE'
		/* Hide itemSubjectDrive Check Box */
		CALL VpItem window,SubjectDrive,'HIDE'
		/* Uncheck the item SubjectDrive Check Box */
		CALL VpSelect window,SubjectDrive,0
	END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
	SelectMultipleFlag = 0
	Drives_Selection_Label = "Select one drive:"
	/* Set item value DRIVESSELECTIONLABEL Text */
	CALL VpSetItemValue window,'DRIVESSELECTIONLABEL',Drives_Selection_Label
	/* Set item position/size DRIVESSELECTIONLABEL Text */
	CALL VpItem window,'DRIVESSELECTIONLABEL','SETITEMPOS',Label_xPosition,Label_yPosition,Label_xsize1,Label_ysize
	/* Disable item DRIVESSELECTIONLABEL Text */
	CALL VpItem window,'DRIVESSELECTIONLABEL','DISABLE'
	/* Enable item DRIVESSELECTIONLABEL Text */
	CALL VpItem window,'DRIVESSELECTIONLABEL','ENABLE'	
	/*End unchecking disabling and hiding the drive checkboxes*/


	/*Begin enabling and showing the drive radio buttons and unchecking them*/
	DO I = 1  TO MaxDriveNumber BY 1
		SubjectDrive = "DRIVE"I"RADIOBUTTON"
		SELECT
			WHEN I = 1 THEN SSubjectDrive = "A:"

			OTHERWISE DO
				J = I - 1
				SSubjectDrive = DDrive.J
			END	/*Ends "OTHERWISE DO" Section*/
		END	/*Ends "SELECT" Section*/
		IF SSubjectDrive \= "" THEN DO
			/* Enable item SubjectDrive Radio Button */
			CALL VpItem window,SubjectDrive,'ENABLE'
			/* Show item SubjectDrive Radio Button */
			CALL VpItem window,SubjectDrive,'SHOW'
			/* Uncheck the item SubjectDrive Radio Button */
			CALL VpSelect window,SubjectDrive,0
			/* Set item value SubjectDrive Radio Button */
			CALL VpSetItemValue window,SubjectDrive,SSubjectDrive
		END	/*Ends "IF SSubjectDrive \= "" THEN DO" Section*/
	END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
	/*End enabling and showing the drive radio buttons and unchecking them*/


	/*Begin enabling and unchecking and the "NO" radio button and enabling and checking and the "YES" radio button for recursive searches*/
	/* Enable item NO Radio Button */
	CALL VpItem window,'NO','ENABLE'
	/* Uncheck the item NO Radio Button */
	CALL VpSelect window,'NO',0
	/* Enable item YES Radio Button */
	CALL VpItem window,'YES','ENABLE'
	/* Check the item  YES Radio Button */
	CALL VpSelect window,'YES',1
	/*End enabling and unchecking  the "NO" radio button and enabling and checking  the "YES" radio button for recursive searches*/
END	/*Ends "IF SelectOneFlag = 1 THEN DO" Section*/
CALL SEEKENDS
return

/* ##256_1013.0 */
256_1013.0: /* Event Select one or more drives and al SELECTMULTIPLERADIOBUTTON, Clicked/selected */
Arg window self



/* Get button state SELECTMULTIPLERADIOBUTTON Radio Button */
SelectMultipleFlag = VpIsSelected(window,'SELECTMULTIPLERADIOBUTTON')
IF SelectMultipleFlag = 1 THEN DO
	/* Uncheck the item SELECTONERADIOBUTTON Radio Button */
	CALL VpSelect window,'SELECTONERADIOBUTTON',0	
	DO I = 1  TO MaxDriveNumber BY 1
		SubjectDrive = "DRIVE"I"RADIOBUTTON"
		/*Begin disabling and hiding the drive radio buttons and unchecking them*/
		/* Disable item SubjectDrive Radio Button */
		CALL VpItem window,SubjectDrive,'DISABLE'
		/* Hide item SubjectDrive Radio Button */
		CALL VpItem window,SubjectDrive,'HIDE'
		/* Uncheck the item SubjectDrive Radio Button */
		CALL VpSelect window,SubjectDrive,0
	END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
	SelectOneFlag = 0
	Drives_Selection_Label = "Select one or more drives:"
	/* Set item value DRIVESSELECTIONLABEL Text */
	CALL VpSetItemValue window,'DRIVESSELECTIONLABEL',Drives_Selection_Label
	/* Set item position/size DRIVESSELECTIONLABEL Text */
	CALL VpItem window,'DRIVESSELECTIONLABEL','SETITEMPOS',Label_xPosition,Label_yPosition,Label_xsize,Label_ysize
	/* Disable item DRIVESSELECTIONLABEL Text */
	CALL VpItem window,'DRIVESSELECTIONLABEL','DISABLE'
	/* Enable item DRIVESSELECTIONLABEL Text */
	CALL VpItem window,'DRIVESSELECTIONLABEL','ENABLE'	
	/*End disabling and hiding the drive radio buttons and unchecking them*/


	/*Begin unchecking, enabling and showing the drive checkboxes*/
	DO I = 1  TO MaxDriveNumber BY 1
		SubjectDrive = "DRIVE"I"CHECKBOX"
		SELECT
			WHEN I = 1 THEN SSubjectDrive = "A:"

			OTHERWISE DO
				J = I - 1
				SSubjectDrive = DDrive.J
			END	/*Ends "OTHERWISE DO" Section*/
		END	/*Ends "SELECT" Section*/
		IF SSubjectDrive \= "" THEN DO
			/* Enable item SubjectDrive Check Box */
			CALL VpItem window,SubjectDrive,'ENABLE'
			/* Show item SubjectDrive Check Box */
			CALL VpItem window,SubjectDrive,'SHOW'
			/* Uncheck the item SubjectDrive Check Box */
			CALL VpSelect window,SubjectDrive,0
			/* Set item value SubjectDrive Check Box */
			CALL VpSetItemValue window,SubjectDrive,SSubjectDrive
		END	/*Ends "IF SSubjectDrive \= "" THEN DO" Section*/
	END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
	/*End unchecking enabling and showing the drive checkboxes*/


	/*Begin unchecking and disabling the "NO" radio button and checking and disabling the "YES" radio button for recursive searches*/
	/* Uncheck the item NO Radio Button */
	CALL VpSelect window,'NO',0
	/* Disable item NO Radio Button */
	CALL VpItem window,'NO','DISABLE'
	/* Check the item  YES Radio Button */
	CALL VpSelect window,'YES',1
	/* Disable item YES Radio Button */
	CALL VpItem window,'YES','DISABLE'
	/*End unchecking  and disabling the "NO" radio button and checking  and disabling the "YES" radio button for recursive searches*/
END	/*Ends "IF SelectMultipleFlag = 1 THEN DO" Section*/
CALL SEEKENDS
return

/* ##256_1015.0 */
256_1015.0: /* Event Continue CONTINUE, Clicked/selected */
Arg window self



/* Open the form Drive2"OS2\APPS\Seek\SubdirectoryList" */
SubdirectoryListFormID = VpOpenForm(window, 257, 'topic name')
return

/* ##256_1016.0 */
256_1016.0: /* Event Cancel CANCEL, Clicked/selected */
Arg window self
/*Begin deregistering the REXX Utility, REXX Library and REXXEA functions*/
IF REXXUtilityFlag \= 0 THEN CALL SysDropFuncs
IF Setup.Use_REXXLIB = "YES" & REXXLibraryFlag \= 0 THEN CALL REXXLIBDEREGISTER
IF Setup.Use_REXXEA = "YES" & REXXEAFlag \= 0 THEN RC = RxFuncDrop(FetchEA)
/*End deregistering the REXX Utility, REXX Library and REXXEA functions*/
CALL VpWindow window,'CLOSE'
return

/* ##256_1017.3 */
256_1017.3: /* Event  FILENAME, Changed */
Arg window self



CALL SEEKENDS
return

/* ##256_1019.0 */
256_1019.0: /* Event FileName FILENAMESEARCH, Clicked/selected */
Arg window self



FileNameSearchFlag = ""
YesRecursiveFlag = ""
NoRecursiveFlag = ""

/* Get button state FILENAMESEARCH Radio Button */
FileNameSearchFlag = VpIsSelected(window,'FILENAMESEARCH')
/* Get button state YES Radio Button */
YesRecursiveFlag = VpIsSelected(window,'YES')
/* Get button state NO Radio Button */
NoRecursiveFlag = VpIsSelected(window,'NO')

SELECT
	WHEN FileNameSearchFlag = 1 THEN DO
		IF YesRecursiveFlag = 1 THEN SysFileTreeOption = "FS"
		IF NoRecursiveFlag = 1 THEN SysFileTreeOption = "F"
		IF SubdirectoryListFormID \= "" THEN DO
			/* Uncheck the item OTHERSERVICESRADIOBUTTON Radio Button */
			CALL VpSelect SubdirectoryListFormID,'OTHERSERVICESRADIOBUTTON',0
			/* Enable item OTHERSERVICESRADIOBUTTON Radio Button */
			CALL VpItem SubdirectoryListFormID,'OTHERSERVICESRADIOBUTTON','ENABLE'
		END	/*Ends "IF SubdirectoryListFormID \= "" THEN DO" Section*/
		/*Begin setting the text for the SEARCHSTRINGLABEL Label*/
		SearchStringLabelText = "Enter the search string for the desired file, or files:"
		/* Set item value SEARCHSTRINGLABEL Text */
		CALL VpSetItemValue window,'SEARCHSTRINGLABEL',SearchStringLabelText
		/*Begin setting the text for the SEARCHSTRINGLABEL Label*/
	END	/*Ends "WHEN FileNameSearchFlag = 1 THEN DO" Section*/

	OTHERWISE NOP
END	/*Ends "SELECT" Section*/
return

/* ##256_1020.0 */
256_1020.0: /* Event Directory Name DIRECTORYNAMESEARCH, Clicked/selected */
Arg window self



DirectorySearchFlag = ""
YesRecursiveFlag = ""
NoRecursiveFlag = ""

/* Get button state DIRECTORYNAMESEARCH Radio Button */
DirectorySearchFlag = VpIsSelected(window,'DIRECTORYNAMESEARCH')
/* Get button state YES Radio Button */
YesRecursiveFlag = VpIsSelected(window,'YES')
/* Get button state NO Radio Button */
NoRecursiveFlag = VpIsSelected(window,'NO')

SELECT
	WHEN DirectorySearchFlag = 1 THEN DO
		IF YesRecursiveFlag = 1 THEN SysFileTreeOption = "DS"
		IF NoRecursiveFlag = 1 THEN SysFileTreeOption = "D"
		IF SubdirectoryListFormID \= "" THEN DO
			/* Uncheck the item OTHERSERVICESRADIOBUTTON Radio Button */
			CALL VpSelect SubdirectoryListFormID,'OTHERSERVICESRADIOBUTTON',0
			/* Disable item OTHERSERVICESRADIOBUTTON Radio Button */
			CALL VpItem SubdirectoryListFormID,'OTHERSERVICESRADIOBUTTON','DISABLE'
		END	/*Ends "IF SubdirectoryListFormID \= "" THEN DO" Section*/
		/*Begin setting the text for the SEARCHSTRINGLABEL Label*/
		SearchStringLabelText = "Enter the search string for the desired directory, or directories:"
		/* Set item value SEARCHSTRINGLABEL Text */
		CALL VpSetItemValue window,'SEARCHSTRINGLABEL',SearchStringLabelText
		/*Begin setting the text for the SEARCHSTRINGLABEL Label*/
	END	/*Ends "WHEN DirectorySearchFlag = 1 THEN DO" Section*/

	OTHERWISE NOP
END	/*Ends "SELECT" Section*/
return

/* ##256_1022.0 */
256_1022.0: /* Event Drive7 DRIVE7RADIOBUTTON, Clicked/selected */
Arg window self
DO I = 1  TO MaxDriveNumber BY 1
	SubjectDrive = "DRIVE"I"RADIOBUTTON"
	/* Get button state SubjectDrive Radio Button */
	AssignVariable = "Drive"I"RadioButtonFlag = "VpIsSelected(window,SubjectDrive)
	INTERPRET(AssignVariable)
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
FileName = VpGetItemValue(window,'FILENAME')



IF Drive7RadioButtonFlag = 1 THEN DO
	SelectType = "Single"
	IF Drive7Message \= "" THEN DO
		Title = "REMOVABLE MEDIA DRIVE WARNING!"
		response=VpMessageBox(window,Title,Drive7Message,'OKCNCL')
		IF response = "OK" THEN DO
			UpLevel = "Go up to The Opening Dialog"
			Directory = Drive7"\*.*"
			Path = Drive7
		END	/*Ends "IF response = "OK" THEN DO" Section*/

		ELSE 
		/* Uncheck the item DRIVE7RADIOBUTTON Radio Button */
		CALL VpSelect window,'DRIVE7RADIOBUTTON',0
	END	/*Ends "IF Drive7Message \= "" THEN DO" Section*/

	ELSE DO
		UpLevel = "Go up to The Opening Dialog"
		Directory = Drive7"\*.*"
		Path = Drive7
	END	/*Ends "ELSE DO" Section*/
END	/*Ends "IF Drive7RadioButtonFlag = 1 THEN DO" Section*/



Total = 0
DO I = 1  TO MaxDriveNumber BY 1
	AssignVariable = "SubjectFlag = Drive"I"RadioButtonFlag"
	INTERPRET(AssignVariable)
	Total = Total + SubjectFlag
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
CALL SEEKENDS
return

/* ##256_1023.0 */
256_1023.0: /* Event Drive8 DRIVE8RADIOBUTTON, Clicked/selected */
Arg window self
DO I = 1  TO MaxDriveNumber BY 1
	SubjectDrive = "DRIVE"I"RADIOBUTTON"
	/* Get button state SubjectDrive Radio Button */
	AssignVariable = "Drive"I"RadioButtonFlag = "VpIsSelected(window,SubjectDrive)
	INTERPRET(AssignVariable)
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
FileName = VpGetItemValue(window,'FILENAME')



IF Drive8RadioButtonFlag = 1 THEN DO
	SelectType = "Single"
	IF Drive8Message \= "" THEN DO
		Title = "REMOVABLE MEDIA DRIVE WARNING!"
		response=VpMessageBox(window,Title,Drive8Message,'OKCNCL')
		IF response = "OK" THEN DO
			UpLevel = "Go up to The Opening Dialog"
			Directory = Drive8"\*.*"
			Path = Drive8
		END	/*Ends "IF response = "OK" THEN DO" Section*/

		ELSE 
		/* Uncheck the item DRIVE8RADIOBUTTON Radio Button */
		CALL VpSelect window,'DRIVE8RADIOBUTTON',0
	END	/*Ends "IF Drive8Message \= "" THEN DO" Section*/

	ELSE DO
		UpLevel = "Go up to The Opening Dialog"
		Directory = Drive8"\*.*"
		Path = Drive8
	END	/*Ends "ELSE DO" Section*/
END	/*Ends "IF Drive8RadioButtonFlag = 1 THEN DO" Section*/



Total = 0
DO I = 1  TO MaxDriveNumber BY 1
	AssignVariable = "SubjectFlag = Drive"I"RadioButtonFlag"
	INTERPRET(AssignVariable)
	Total = Total + SubjectFlag
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
CALL SEEKENDS
return

/* ##256_1024.0 */
256_1024.0: /* Event Drive9 DRIVE9RADIOBUTTON, Clicked/selected */
Arg window self
DO I = 1  TO MaxDriveNumber BY 1
	SubjectDrive = "DRIVE"I"RADIOBUTTON"
	/* Get button state SubjectDrive Radio Button */
	AssignVariable = "Drive"I"RadioButtonFlag = "VpIsSelected(window,SubjectDrive)
	INTERPRET(AssignVariable)
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
FileName = VpGetItemValue(window,'FILENAME')



IF Drive9RadioButtonFlag = 1 THEN DO
	SelectType = "Single"
	IF Drive9Message \= "" THEN DO
		Title = "REMOVABLE MEDIA DRIVE WARNING!"
		response=VpMessageBox(window,Title,Drive9Message,'OKCNCL')
		IF response = "OK" THEN DO
			UpLevel = "Go up to The Opening Dialog"
			Directory = Drive9"\*.*"
			Path = Drive9
		END	/*Ends "IF response = "OK" THEN DO" Section*/

		ELSE 
		/* Uncheck the item DRIVE9RADIOBUTTON Radio Button */
		CALL VpSelect window,'DRIVE9RADIOBUTTON',0
	END	/*Ends "IF Drive9Message \= "" THEN DO" Section*/

	ELSE DO
		UpLevel = "Go up to The Opening Dialog"
		Directory = Drive9"\*.*"
		Path = Drive9
	END	/*Ends "ELSE DO" Section*/
END	/*Ends "IF Drive9RadioButtonFlag = 1 THEN DO" Section*/



Total = 0
DO I = 1  TO MaxDriveNumber BY 1
	AssignVariable = "SubjectFlag = Drive"I"RadioButtonFlag"
	INTERPRET(AssignVariable)
	Total = Total + SubjectFlag
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
CALL SEEKENDS
return

/* ##256_1025.0 */
256_1025.0: /* Event Drive10 DRIVE10RADIOBUTTON, Clicked/selected */
Arg window self
DO I = 1  TO MaxDriveNumber BY 1
	SubjectDrive = "DRIVE"I"RADIOBUTTON"
	/* Get button state SubjectDrive Radio Button */
	AssignVariable = "Drive"I"RadioButtonFlag = "VpIsSelected(window,SubjectDrive)
	INTERPRET(AssignVariable)
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
FileName = VpGetItemValue(window,'FILENAME')



IF Drive10RadioButtonFlag = 1 THEN DO
	SelectType = "Single"
	IF Drive10Message \= "" THEN DO
		Title = "REMOVABLE MEDIA DRIVE WARNING!"
		response=VpMessageBox(window,Title,Drive10Message,'OKCNCL')
		IF response = "OK" THEN DO
			UpLevel = "Go up to The Opening Dialog"
			Directory = Drive10"\*.*"
			Path = Drive10
		END	/*Ends "IF response = "OK" THEN DO" Section*/

		ELSE 
		/* Uncheck the item DRIVE10RADIOBUTTON Radio Button */
		CALL VpSelect window,'DRIVE10RADIOBUTTON',0
	END	/*Ends "IF Drive10Message \= "" THEN DO" Section*/

	ELSE DO
		UpLevel = "Go up to The Opening Dialog"
		Directory = Drive10"\*.*"
		Path = Drive10
	END	/*Ends "ELSE DO" Section*/
END	/*Ends "IF Drive10RadioButtonFlag = 1 THEN DO" Section*/



Total = 0
DO I = 1  TO MaxDriveNumber BY 1
	AssignVariable = "SubjectFlag = Drive"I"RadioButtonFlag"
	INTERPRET(AssignVariable)
	Total = Total + SubjectFlag
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
CALL SEEKENDS
return

/* ##256_1026.0 */
256_1026.0: /* Event Drive7 DRIVE7CHECKBOX, Clicked/selected */
Arg window self
DO I = 1  TO MaxDriveNumber BY 1
	SubjectDrive = "DRIVE"I"CHECKBOX"
	/* Get button state SubjectDrive Check Box */
	AssignVariable = "Drive"I"CheckBoxFlag = "VpIsSelected(window,SubjectDrive)
	INTERPRET(AssignVariable)
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
FileName = VpGetItemValue(window,'FILENAME')



IF Drive7CheckBoxFlag = 1 THEN DO
	SelectType = "Multiple"
	IF Drive7Message \= "" THEN DO
		Title = "REMOVABLE MEDIA DRIVE WARNING!"
		response=VpMessageBox(window,Title,Drive7Message,'OKCNCL')
		IF response = "OK" THEN DO
			UpLevel = "Go up to The Opening Dialog"
			Directory = Drive7"\*.*"
			Path = Drive7
		END	/*Ends "IF response = "OK" THEN DO" Section*/
	END	/*Ends "IF Drive7Message \= "" THEN DO" Section*/
	ELSE response = "OK"
	
	IF response = "OK" THEN DO
		J = 0
		Directories. = ""
		Paths. = ""
		UpLevel = "Go up to The Opening Dialog"
		DO I = 1  TO MaxDriveNumber BY 1
			SubjectDrive = "DRIVE"I"CHECKBOX"
			AssignVariable = "SubjectFlag = "VpIsSelected(window,SubjectDrive)
			INTERPRET(AssignVariable)
			IF SubjectFlag = 1 THEN DO
				J = J + 1
				AssignVariable = "SSubjectDrive = Drive"I
				INTERPRET(AssignVariable)
				Directories.J = SSubjectDrive"\*.*"
				Paths.J = SSubjectDrive
			END	/*Ends "IF SubjectFlag = 1 THEN DO" Section*/
		END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
		Paths.0 = J
	END	/*Ends "IF response = "OK" THEN DO" Section*/

	ELSE 
	/* Uncheck the item DRIVE7CHECKBOX Radio Button */
	CALL VpSelect window,'DRIVE7CHECKBOX',0
END	/*Ends "IF Drive7CheckBoxFlag = 1 THEN DO" Section*/



Total = 0
DO I = 1  TO MaxDriveNumber BY 1
	AssignVariable = "SubjectFlag = Drive"I"CheckBoxFlag"
	INTERPRET(AssignVariable)
	Total = Total + SubjectFlag
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
CALL SEEKENDS
return

/* ##256_1027.0 */
256_1027.0: /* Event Drive8 DRIVE8CHECKBOX, Clicked/selected */
Arg window self
DO I = 1  TO MaxDriveNumber BY 1
	SubjectDrive = "DRIVE"I"CHECKBOX"
	/* Get button state SubjectDrive Check Box */
	AssignVariable = "Drive"I"CheckBoxFlag = "VpIsSelected(window,SubjectDrive)
	INTERPRET(AssignVariable)
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
FileName = VpGetItemValue(window,'FILENAME')



IF Drive8CheckBoxFlag = 1 THEN DO
	SelectType = "Multiple"
	IF Drive8Message \= "" THEN DO
		Title = "REMOVABLE MEDIA DRIVE WARNING!"
		response=VpMessageBox(window,Title,Drive8Message,'OKCNCL')
		IF response = "OK" THEN DO
			UpLevel = "Go up to The Opening Dialog"
			Directory = Drive8"\*.*"
			Path = Drive8
		END	/*Ends "IF response = "OK" THEN DO" Section*/
	END	/*Ends "IF Drive8Message \= "" THEN DO" Section*/
	ELSE response = "OK"
	
	IF response = "OK" THEN DO
		J = 0
		Directories. = ""
		Paths. = ""
		UpLevel = "Go up to The Opening Dialog"
		DO I = 1  TO MaxDriveNumber BY 1
			SubjectDrive = "DRIVE"I"CHECKBOX"
			AssignVariable = "SubjectFlag = "VpIsSelected(window,SubjectDrive)
			INTERPRET(AssignVariable)
			IF SubjectFlag = 1 THEN DO
				J = J + 1
				AssignVariable = "SSubjectDrive = Drive"I
				INTERPRET(AssignVariable)
				Directories.J = SSubjectDrive"\*.*"
				Paths.J = SSubjectDrive
			END	/*Ends "IF SubjectFlag = 1 THEN DO" Section*/
		END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
		Paths.0 = J
	END	/*Ends "IF response = "OK" THEN DO" Section*/

	ELSE 
	/* Uncheck the item DRIVE8CHECKBOX Radio Button */
	CALL VpSelect window,'DRIVE8CHECKBOX',0
END	/*Ends "IF Drive8CheckBoxFlag = 1 THEN DO" Section*/



Total = 0
DO I = 1  TO MaxDriveNumber BY 1
	AssignVariable = "SubjectFlag = Drive"I"CheckBoxFlag"
	INTERPRET(AssignVariable)
	Total = Total + SubjectFlag
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
CALL SEEKENDS
return

/* ##256_1028.0 */
256_1028.0: /* Event Drive9 DRIVE9CHECKBOX, Clicked/selected */
Arg window self
DO I = 1  TO MaxDriveNumber BY 1
	SubjectDrive = "DRIVE"I"CHECKBOX"
	/* Get button state SubjectDrive Check Box */
	AssignVariable = "Drive"I"CheckBoxFlag = "VpIsSelected(window,SubjectDrive)
	INTERPRET(AssignVariable)
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
FileName = VpGetItemValue(window,'FILENAME')



IF Drive9CheckBoxFlag = 1 THEN DO
	SelectType = "Multiple"
	IF Drive9Message \= "" THEN DO
		Title = "REMOVABLE MEDIA DRIVE WARNING!"
		response=VpMessageBox(window,Title,Drive9Message,'OKCNCL')
		IF response = "OK" THEN DO
			UpLevel = "Go up to The Opening Dialog"
			Directory = Drive9"\*.*"
			Path = Drive9
		END	/*Ends "IF response = "OK" THEN DO" Section*/
	END	/*Ends "IF Drive9Message \= "" THEN DO" Section*/
	ELSE response = "OK"
	
	IF response = "OK" THEN DO
		J = 0
		Directories. = ""
		Paths. = ""
		UpLevel = "Go up to The Opening Dialog"
		DO I = 1  TO MaxDriveNumber BY 1
			SubjectDrive = "DRIVE"I"CHECKBOX"
			AssignVariable = "SubjectFlag = "VpIsSelected(window,SubjectDrive)
			INTERPRET(AssignVariable)
			IF SubjectFlag = 1 THEN DO
				J = J + 1
				AssignVariable = "SSubjectDrive = Drive"I
				INTERPRET(AssignVariable)
				Directories.J = SSubjectDrive"\*.*"
				Paths.J = SSubjectDrive
			END	/*Ends "IF SubjectFlag = 1 THEN DO" Section*/
		END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
		Paths.0 = J
	END	/*Ends "IF response = "OK" THEN DO" Section*/

	ELSE 
	/* Uncheck the item DRIVE9CHECKBOX Radio Button */
	CALL VpSelect window,'DRIVE9CHECKBOX',0
END	/*Ends "IF Drive9CheckBoxFlag = 1 THEN DO" Section*/



Total = 0
DO I = 1  TO MaxDriveNumber BY 1
	AssignVariable = "SubjectFlag = Drive"I"CheckBoxFlag"
	INTERPRET(AssignVariable)
	Total = Total + SubjectFlag
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
CALL SEEKENDS
return

/* ##256_1029.0 */
256_1029.0: /* Event Drive10 DRIVE10CHECKBOX, Clicked/selected */
Arg window self
DO I = 1  TO MaxDriveNumber BY 1
	SubjectDrive = "DRIVE"I"CHECKBOX"
	/* Get button state SubjectDrive Check Box */
	AssignVariable = "Drive"I"CheckBoxFlag = "VpIsSelected(window,SubjectDrive)
	INTERPRET(AssignVariable)
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
FileName = VpGetItemValue(window,'FILENAME')



IF Drive10CheckBoxFlag = 1 THEN DO
	SelectType = "Multiple"
	IF Drive10Message \= "" THEN DO
		Title = "REMOVABLE MEDIA DRIVE WARNING!"
		response=VpMessageBox(window,Title,Drive10Message,'OKCNCL')
		IF response = "OK" THEN DO
			UpLevel = "Go up to The Opening Dialog"
			Directory = Drive10"\*.*"
			Path = Drive10
		END	/*Ends "IF response = "OK" THEN DO" Section*/
	END	/*Ends "IF Drive10Message \= "" THEN DO" Section*/
	ELSE response = "OK"
	
	IF response = "OK" THEN DO
		J = 0
		Directories. = ""
		Paths. = ""
		UpLevel = "Go up to The Opening Dialog"
		DO I = 1  TO MaxDriveNumber BY 1
			SubjectDrive = "DRIVE"I"CHECKBOX"
			AssignVariable = "SubjectFlag = "VpIsSelected(window,SubjectDrive)
			INTERPRET(AssignVariable)
			IF SubjectFlag = 1 THEN DO
				J = J + 1
				AssignVariable = "SSubjectDrive = Drive"I
				INTERPRET(AssignVariable)
				Directories.J = SSubjectDrive"\*.*"
				Paths.J = SSubjectDrive
			END	/*Ends "IF SubjectFlag = 1 THEN DO" Section*/
		END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
		Paths.0 = J
	END	/*Ends "IF response = "OK" THEN DO" Section*/

	ELSE 
	/* Uncheck the item DRIVE10CHECKBOX Radio Button */
	CALL VpSelect window,'DRIVE10CHECKBOX',0
END	/*Ends "IF Drive10CheckBoxFlag = 1 THEN DO" Section*/



Total = 0
DO I = 1  TO MaxDriveNumber BY 1
	AssignVariable = "SubjectFlag = Drive"I"CheckBoxFlag"
	INTERPRET(AssignVariable)
	Total = Total + SubjectFlag
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
CALL SEEKENDS
return

/* ##256_1030.0 */
256_1030.0: /* Event  DRIVE11RADIOBUTTON, Clicked/selected */
Arg window self
DO I = 1  TO MaxDriveNumber BY 1
	SubjectDrive = "DRIVE"I"RADIOBUTTON"
	/* Get button state SubjectDrive Radio Button */
	AssignVariable = "Drive"I"RadioButtonFlag = "VpIsSelected(window,SubjectDrive)
	INTERPRET(AssignVariable)
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
FileName = VpGetItemValue(window,'FILENAME')



IF Drive11RadioButtonFlag = 1 THEN DO
	SelectType = "Single"
	IF Drive11Message \= "" THEN DO
		Title = "REMOVABLE MEDIA DRIVE WARNING!"
		response=VpMessageBox(window,Title,Drive11Message,'OKCNCL')
		IF response = "OK" THEN DO
			UpLevel = "Go up to The Opening Dialog"
			Directory = Drive11"\*.*"
			Path = Drive11
		END	/*Ends "IF response = "OK" THEN DO" Section*/

		ELSE 
		/* Uncheck the item Drive11RADIOBUTTON Radio Button */
		CALL VpSelect window,'Drive11RADIOBUTTON',0
	END	/*Ends "IF Drive11Message \= "" THEN DO" Section*/

	ELSE DO
		UpLevel = "Go up to The Opening Dialog"
		Directory = Drive11"\*.*"
		Path = Drive11
	END	/*Ends "ELSE DO" Section*/
END	/*Ends "IF Drive11RadioButtonFlag = 1 THEN DO" Section*/



Total = 0
DO I = 1  TO MaxDriveNumber BY 1
	AssignVariable = "SubjectFlag = Drive"I"RadioButtonFlag"
	INTERPRET(AssignVariable)
	Total = Total + SubjectFlag
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
CALL SEEKENDS
return

/* ##256_1031.0 */
256_1031.0: /* Event  DRIVE12RADIOBUTTON, Clicked/selected */
Arg window self
DO I = 1  TO MaxDriveNumber BY 1
	SubjectDrive = "DRIVE"I"RADIOBUTTON"
	/* Get button state SubjectDrive Radio Button */
	AssignVariable = "Drive"I"RadioButtonFlag = "VpIsSelected(window,SubjectDrive)
	INTERPRET(AssignVariable)
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
FileName = VpGetItemValue(window,'FILENAME')



IF Drive12RadioButtonFlag = 1 THEN DO
	SelectType = "Single"
	IF Drive12Message \= "" THEN DO
		Title = "REMOVABLE MEDIA DRIVE WARNING!"
		response=VpMessageBox(window,Title,Drive12Message,'OKCNCL')
		IF response = "OK" THEN DO
			UpLevel = "Go up to The Opening Dialog"
			Directory = Drive12"\*.*"
			Path = Drive12
		END	/*Ends "IF response = "OK" THEN DO" Section*/

		ELSE 
		/* Uncheck the item Drive12RADIOBUTTON Radio Button */
		CALL VpSelect window,'Drive12RADIOBUTTON',0
	END	/*Ends "IF Drive12Message \= "" THEN DO" Section*/

	ELSE DO
		UpLevel = "Go up to The Opening Dialog"
		Directory = Drive12"\*.*"
		Path = Drive12
	END	/*Ends "ELSE DO" Section*/
END	/*Ends "IF Drive12RadioButtonFlag = 1 THEN DO" Section*/



Total = 0
DO I = 1  TO MaxDriveNumber BY 1
	AssignVariable = "SubjectFlag = Drive"I"RadioButtonFlag"
	INTERPRET(AssignVariable)
	Total = Total + SubjectFlag
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
CALL SEEKENDS
return

/* ##256_1032.0 */
256_1032.0: /* Event  DRIVE13RADIOBUTTON, Clicked/selected */
Arg window self
DO I = 1  TO MaxDriveNumber BY 1
	SubjectDrive = "DRIVE"I"RADIOBUTTON"
	/* Get button state SubjectDrive Radio Button */
	AssignVariable = "Drive"I"RadioButtonFlag = "VpIsSelected(window,SubjectDrive)
	INTERPRET(AssignVariable)
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
FileName = VpGetItemValue(window,'FILENAME')



IF Drive13RadioButtonFlag = 1 THEN DO
	SelectType = "Single"
	IF Drive13Message \= "" THEN DO
		Title = "REMOVABLE MEDIA DRIVE WARNING!"
		response=VpMessageBox(window,Title,Drive13Message,'OKCNCL')
		IF response = "OK" THEN DO
			UpLevel = "Go up to The Opening Dialog"
			Directory = Drive13"\*.*"
			Path = Drive13
		END	/*Ends "IF response = "OK" THEN DO" Section*/

		ELSE 
		/* Uncheck the item Drive13RADIOBUTTON Radio Button */
		CALL VpSelect window,'Drive13RADIOBUTTON',0
	END	/*Ends "IF Drive13Message \= "" THEN DO" Section*/

	ELSE DO
		UpLevel = "Go up to The Opening Dialog"
		Directory = Drive13"\*.*"
		Path = Drive13
	END	/*Ends "ELSE DO" Section*/
END	/*Ends "IF Drive13RadioButtonFlag = 1 THEN DO" Section*/



Total = 0
DO I = 1  TO MaxDriveNumber BY 1
	AssignVariable = "SubjectFlag = Drive"I"RadioButtonFlag"
	INTERPRET(AssignVariable)
	Total = Total + SubjectFlag
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
CALL SEEKENDS
return

/* ##256_1033.0 */
256_1033.0: /* Event  DRIVE14RADIOBUTTON, Clicked/selected */
Arg window self
DO I = 1  TO MaxDriveNumber BY 1
	SubjectDrive = "DRIVE"I"RADIOBUTTON"
	/* Get button state SubjectDrive Radio Button */
	AssignVariable = "Drive"I"RadioButtonFlag = "VpIsSelected(window,SubjectDrive)
	INTERPRET(AssignVariable)
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
FileName = VpGetItemValue(window,'FILENAME')



IF Drive14RadioButtonFlag = 1 THEN DO
	SelectType = "Single"
	IF Drive14Message \= "" THEN DO
		Title = "REMOVABLE MEDIA DRIVE WARNING!"
		response=VpMessageBox(window,Title,Drive14Message,'OKCNCL')
		IF response = "OK" THEN DO
			UpLevel = "Go up to The Opening Dialog"
			Directory = Drive14"\*.*"
			Path = Drive14
		END	/*Ends "IF response = "OK" THEN DO" Section*/

		ELSE 
		/* Uncheck the item Drive14RADIOBUTTON Radio Button */
		CALL VpSelect window,'Drive14RADIOBUTTON',0
	END	/*Ends "IF Drive14Message \= "" THEN DO" Section*/

	ELSE DO
		UpLevel = "Go up to The Opening Dialog"
		Directory = Drive14"\*.*"
		Path = Drive14
	END	/*Ends "ELSE DO" Section*/
END	/*Ends "IF Drive14RadioButtonFlag = 1 THEN DO" Section*/



Total = 0
DO I = 1  TO MaxDriveNumber BY 1
	AssignVariable = "SubjectFlag = Drive"I"RadioButtonFlag"
	INTERPRET(AssignVariable)
	Total = Total + SubjectFlag
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
CALL SEEKENDS
return

/* ##256_1034.0 */
256_1034.0: /* Event  DRIVE11CHECKBOX, Clicked/selected */
Arg window self
DO I = 1  TO MaxDriveNumber BY 1
	SubjectDrive = "DRIVE"I"CHECKBOX"
	/* Get button state SubjectDrive Check Box */
	AssignVariable = "Drive"I"CheckBoxFlag = "VpIsSelected(window,SubjectDrive)
	INTERPRET(AssignVariable)
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
FileName = VpGetItemValue(window,'FILENAME')



IF Drive11CheckBoxFlag = 1 THEN DO
	SelectType = "Multiple"
	IF Drive11Message \= "" THEN DO
		Title = "REMOVABLE MEDIA DRIVE WARNING!"
		response=VpMessageBox(window,Title,Drive11Message,'OKCNCL')
		IF response = "OK" THEN DO
			UpLevel = "Go up to The Opening Dialog"
			Directory = Drive11"\*.*"
			Path = Drive11
		END	/*Ends "IF response = "OK" THEN DO" Section*/
	END	/*Ends "IF Drive11Message \= "" THEN DO" Section*/
	ELSE response = "OK"
	
	IF response = "OK" THEN DO
		J = 0
		Directories. = ""
		Paths. = ""
		UpLevel = "Go up to The Opening Dialog"
		DO I = 1  TO MaxDriveNumber BY 1
			SubjectDrive = "DRIVE"I"CHECKBOX"
			AssignVariable = "SubjectFlag = "VpIsSelected(window,SubjectDrive)
			INTERPRET(AssignVariable)
			IF SubjectFlag = 1 THEN DO
				J = J + 1
				AssignVariable = "SSubjectDrive = Drive"I
				INTERPRET(AssignVariable)
				Directories.J = SSubjectDrive"\*.*"
				Paths.J = SSubjectDrive
			END	/*Ends "IF SubjectFlag = 1 THEN DO" Section*/
		END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
		Paths.0 = J
	END	/*Ends "IF response = "OK" THEN DO" Section*/

	ELSE 
	/* Uncheck the item Drive11CHECKBOX Radio Button */
	CALL VpSelect window,'Drive11CHECKBOX',0
END	/*Ends "IF Drive11CheckBoxFlag = 1 THEN DO" Section*/



Total = 0
DO I = 1  TO MaxDriveNumber BY 1
	AssignVariable = "SubjectFlag = Drive"I"CheckBoxFlag"
	INTERPRET(AssignVariable)
	Total = Total + SubjectFlag
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
CALL SEEKENDS
return

/* ##256_1035.0 */
256_1035.0: /* Event  DRIVE12CHECKBOX, Clicked/selected */
Arg window self
DO I = 1  TO MaxDriveNumber BY 1
	SubjectDrive = "DRIVE"I"CHECKBOX"
	/* Get button state SubjectDrive Check Box */
	AssignVariable = "Drive"I"CheckBoxFlag = "VpIsSelected(window,SubjectDrive)
	INTERPRET(AssignVariable)
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
FileName = VpGetItemValue(window,'FILENAME')



IF Drive12CheckBoxFlag = 1 THEN DO
	SelectType = "Multiple"
	IF Drive12Message \= "" THEN DO
		Title = "REMOVABLE MEDIA DRIVE WARNING!"
		response=VpMessageBox(window,Title,Drive12Message,'OKCNCL')
		IF response = "OK" THEN DO
			UpLevel = "Go up to The Opening Dialog"
			Directory = Drive12"\*.*"
			Path = Drive12
		END	/*Ends "IF response = "OK" THEN DO" Section*/
	END	/*Ends "IF Drive12Message \= "" THEN DO" Section*/
	ELSE response = "OK"
	
	IF response = "OK" THEN DO
		J = 0
		Directories. = ""
		Paths. = ""
		UpLevel = "Go up to The Opening Dialog"
		DO I = 1  TO MaxDriveNumber BY 1
			SubjectDrive = "DRIVE"I"CHECKBOX"
			AssignVariable = "SubjectFlag = "VpIsSelected(window,SubjectDrive)
			INTERPRET(AssignVariable)
			IF SubjectFlag = 1 THEN DO
				J = J + 1
				AssignVariable = "SSubjectDrive = Drive"I
				INTERPRET(AssignVariable)
				Directories.J = SSubjectDrive"\*.*"
				Paths.J = SSubjectDrive
			END	/*Ends "IF SubjectFlag = 1 THEN DO" Section*/
		END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
		Paths.0 = J
	END	/*Ends "IF response = "OK" THEN DO" Section*/

	ELSE 
	/* Uncheck the item Drive12CHECKBOX Radio Button */
	CALL VpSelect window,'Drive12CHECKBOX',0
END	/*Ends "IF Drive12CheckBoxFlag = 1 THEN DO" Section*/



Total = 0
DO I = 1  TO MaxDriveNumber BY 1
	AssignVariable = "SubjectFlag = Drive"I"CheckBoxFlag"
	INTERPRET(AssignVariable)
	Total = Total + SubjectFlag
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
CALL SEEKENDS
return

/* ##256_1036.0 */
256_1036.0: /* Event  DRIVE13CHECKBOX, Clicked/selected */
Arg window self
DO I = 1  TO MaxDriveNumber BY 1
	SubjectDrive = "DRIVE"I"CHECKBOX"
	/* Get button state SubjectDrive Check Box */
	AssignVariable = "Drive"I"CheckBoxFlag = "VpIsSelected(window,SubjectDrive)
	INTERPRET(AssignVariable)
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
FileName = VpGetItemValue(window,'FILENAME')



IF Drive13CheckBoxFlag = 1 THEN DO
	SelectType = "Multiple"
	IF Drive13Message \= "" THEN DO
		Title = "REMOVABLE MEDIA DRIVE WARNING!"
		response=VpMessageBox(window,Title,Drive13Message,'OKCNCL')
		IF response = "OK" THEN DO
			UpLevel = "Go up to The Opening Dialog"
			Directory = Drive13"\*.*"
			Path = Drive13
		END	/*Ends "IF response = "OK" THEN DO" Section*/
	END	/*Ends "IF Drive13Message \= "" THEN DO" Section*/
	ELSE response = "OK"
	
	IF response = "OK" THEN DO
		J = 0
		Directories. = ""
		Paths. = ""
		UpLevel = "Go up to The Opening Dialog"
		DO I = 1  TO MaxDriveNumber BY 1
			SubjectDrive = "DRIVE"I"CHECKBOX"
			AssignVariable = "SubjectFlag = "VpIsSelected(window,SubjectDrive)
			INTERPRET(AssignVariable)
			IF SubjectFlag = 1 THEN DO
				J = J + 1
				AssignVariable = "SSubjectDrive = Drive"I
				INTERPRET(AssignVariable)
				Directories.J = SSubjectDrive"\*.*"
				Paths.J = SSubjectDrive
			END	/*Ends "IF SubjectFlag = 1 THEN DO" Section*/
		END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
		Paths.0 = J
	END	/*Ends "IF response = "OK" THEN DO" Section*/

	ELSE 
	/* Uncheck the item Drive13CHECKBOX Radio Button */
	CALL VpSelect window,'Drive13CHECKBOX',0
END	/*Ends "IF Drive13CheckBoxFlag = 1 THEN DO" Section*/



Total = 0
DO I = 1  TO MaxDriveNumber BY 1
	AssignVariable = "SubjectFlag = Drive"I"CheckBoxFlag"
	INTERPRET(AssignVariable)
	Total = Total + SubjectFlag
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
CALL SEEKENDS
return

/* ##256_1037.0 */
256_1037.0: /* Event  DRIVE14CHECKBOX, Clicked/selected */
Arg window self
DO I = 1  TO MaxDriveNumber BY 1
	SubjectDrive = "DRIVE"I"CHECKBOX"
	/* Get button state SubjectDrive Check Box */
	AssignVariable = "Drive"I"CheckBoxFlag = "VpIsSelected(window,SubjectDrive)
	INTERPRET(AssignVariable)
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
FileName = VpGetItemValue(window,'FILENAME')



IF Drive14CheckBoxFlag = 1 THEN DO
	SelectType = "Multiple"
	IF Drive14Message \= "" THEN DO
		Title = "REMOVABLE MEDIA DRIVE WARNING!"
		response=VpMessageBox(window,Title,Drive14Message,'OKCNCL')
		IF response = "OK" THEN DO
			UpLevel = "Go up to The Opening Dialog"
			Directory = Drive14"\*.*"
			Path = Drive14
		END	/*Ends "IF response = "OK" THEN DO" Section*/
	END	/*Ends "IF Drive14Message \= "" THEN DO" Section*/
	ELSE response = "OK"
	
	IF response = "OK" THEN DO
		J = 0
		Directories. = ""
		Paths. = ""
		UpLevel = "Go up to The Opening Dialog"
		DO I = 1  TO MaxDriveNumber BY 1
			SubjectDrive = "DRIVE"I"CHECKBOX"
			AssignVariable = "SubjectFlag = "VpIsSelected(window,SubjectDrive)
			INTERPRET(AssignVariable)
			IF SubjectFlag = 1 THEN DO
				J = J + 1
				AssignVariable = "SSubjectDrive = Drive"I
				INTERPRET(AssignVariable)
				Directories.J = SSubjectDrive"\*.*"
				Paths.J = SSubjectDrive
			END	/*Ends "IF SubjectFlag = 1 THEN DO" Section*/
		END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
		Paths.0 = J
	END	/*Ends "IF response = "OK" THEN DO" Section*/

	ELSE 
	/* Uncheck the item Drive14CHECKBOX Radio Button */
	CALL VpSelect window,'Drive14CHECKBOX',0
END	/*Ends "IF Drive14CheckBoxFlag = 1 THEN DO" Section*/



Total = 0
DO I = 1  TO MaxDriveNumber BY 1
	AssignVariable = "SubjectFlag = Drive"I"CheckBoxFlag"
	INTERPRET(AssignVariable)
	Total = Total + SubjectFlag
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
CALL SEEKENDS
return

/* ##256_1038.0 */
256_1038.0: /* Event  DRIVE15RADIOBUTTON, Clicked/selected */
Arg window self
DO I = 1  TO MaxDriveNumber BY 1
	SubjectDrive = "DRIVE"I"RADIOBUTTON"
	/* Get button state SubjectDrive Radio Button */
	AssignVariable = "Drive"I"RadioButtonFlag = "VpIsSelected(window,SubjectDrive)
	INTERPRET(AssignVariable)
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
FileName = VpGetItemValue(window,'FILENAME')



IF Drive15RadioButtonFlag = 1 THEN DO
	SelectType = "Single"
	IF Drive15Message \= "" THEN DO
		Title = "REMOVABLE MEDIA DRIVE WARNING!"
		response=VpMessageBox(window,Title,Drive15Message,'OKCNCL')
		IF response = "OK" THEN DO
			UpLevel = "Go up to The Opening Dialog"
			Directory = Drive15"\*.*"
			Path = Drive15
		END	/*Ends "IF response = "OK" THEN DO" Section*/

		ELSE 
		/* Uncheck the item Drive15RADIOBUTTON Radio Button */
		CALL VpSelect window,'Drive15RADIOBUTTON',0
	END	/*Ends "IF Drive15Message \= "" THEN DO" Section*/

	ELSE DO
		UpLevel = "Go up to The Opening Dialog"
		Directory = Drive15"\*.*"
		Path = Drive15
	END	/*Ends "ELSE DO" Section*/
END	/*Ends "IF Drive15RadioButtonFlag = 1 THEN DO" Section*/



Total = 0
DO I = 1  TO MaxDriveNumber BY 1
	AssignVariable = "SubjectFlag = Drive"I"RadioButtonFlag"
	INTERPRET(AssignVariable)
	Total = Total + SubjectFlag
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
CALL SEEKENDS
return

/* ##256_1039.0 */
256_1039.0: /* Event  DRIVE16RADIOBUTTON, Clicked/selected */
Arg window self
DO I = 1  TO MaxDriveNumber BY 1
	SubjectDrive = "DRIVE"I"RADIOBUTTON"
	/* Get button state SubjectDrive Radio Button */
	AssignVariable = "Drive"I"RadioButtonFlag = "VpIsSelected(window,SubjectDrive)
	INTERPRET(AssignVariable)
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
FileName = VpGetItemValue(window,'FILENAME')



IF Drive16RadioButtonFlag = 1 THEN DO
	SelectType = "Single"
	IF Drive16Message \= "" THEN DO
		Title = "REMOVABLE MEDIA DRIVE WARNING!"
		response=VpMessageBox(window,Title,Drive16Message,'OKCNCL')
		IF response = "OK" THEN DO
			UpLevel = "Go up to The Opening Dialog"
			Directory = Drive16"\*.*"
			Path = Drive16
		END	/*Ends "IF response = "OK" THEN DO" Section*/

		ELSE 
		/* Uncheck the item Drive16RADIOBUTTON Radio Button */
		CALL VpSelect window,'Drive16RADIOBUTTON',0
	END	/*Ends "IF Drive16Message \= "" THEN DO" Section*/

	ELSE DO
		UpLevel = "Go up to The Opening Dialog"
		Directory = Drive16"\*.*"
		Path = Drive16
	END	/*Ends "ELSE DO" Section*/
END	/*Ends "IF Drive16RadioButtonFlag = 1 THEN DO" Section*/



Total = 0
DO I = 1  TO MaxDriveNumber BY 1
	AssignVariable = "SubjectFlag = Drive"I"RadioButtonFlag"
	INTERPRET(AssignVariable)
	Total = Total + SubjectFlag
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
CALL SEEKENDS
return

/* ##256_1040.0 */
256_1040.0: /* Event  DRIVE17RADIOBUTTON, Clicked/selected */
Arg window self
DO I = 1  TO MaxDriveNumber BY 1
	SubjectDrive = "DRIVE"I"RADIOBUTTON"
	/* Get button state SubjectDrive Radio Button */
	AssignVariable = "Drive"I"RadioButtonFlag = "VpIsSelected(window,SubjectDrive)
	INTERPRET(AssignVariable)
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
FileName = VpGetItemValue(window,'FILENAME')



IF Drive17RadioButtonFlag = 1 THEN DO
	SelectType = "Single"
	IF Drive17Message \= "" THEN DO
		Title = "REMOVABLE MEDIA DRIVE WARNING!"
		response=VpMessageBox(window,Title,Drive17Message,'OKCNCL')
		IF response = "OK" THEN DO
			UpLevel = "Go up to The Opening Dialog"
			Directory = Drive17"\*.*"
			Path = Drive17
		END	/*Ends "IF response = "OK" THEN DO" Section*/

		ELSE 
		/* Uncheck the item Drive17RADIOBUTTON Radio Button */
		CALL VpSelect window,'Drive17RADIOBUTTON',0
	END	/*Ends "IF Drive17Message \= "" THEN DO" Section*/

	ELSE DO
		UpLevel = "Go up to The Opening Dialog"
		Directory = Drive17"\*.*"
		Path = Drive17
	END	/*Ends "ELSE DO" Section*/
END	/*Ends "IF Drive17RadioButtonFlag = 1 THEN DO" Section*/



Total = 0
DO I = 1  TO MaxDriveNumber BY 1
	AssignVariable = "SubjectFlag = Drive"I"RadioButtonFlag"
	INTERPRET(AssignVariable)
	Total = Total + SubjectFlag
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
CALL SEEKENDS
return

/* ##256_1041.0 */
256_1041.0: /* Event  DRIVE18RADIOBUTTON, Clicked/selected */
Arg window self
DO I = 1  TO MaxDriveNumber BY 1
	SubjectDrive = "DRIVE"I"RADIOBUTTON"
	/* Get button state SubjectDrive Radio Button */
	AssignVariable = "Drive"I"RadioButtonFlag = "VpIsSelected(window,SubjectDrive)
	INTERPRET(AssignVariable)
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
FileName = VpGetItemValue(window,'FILENAME')



IF Drive18RadioButtonFlag = 1 THEN DO
	SelectType = "Single"
	IF Drive18Message \= "" THEN DO
		Title = "REMOVABLE MEDIA DRIVE WARNING!"
		response=VpMessageBox(window,Title,Drive18Message,'OKCNCL')
		IF response = "OK" THEN DO
			UpLevel = "Go up to The Opening Dialog"
			Directory = Drive18"\*.*"
			Path = Drive18
		END	/*Ends "IF response = "OK" THEN DO" Section*/

		ELSE 
		/* Uncheck the item Drive18RADIOBUTTON Radio Button */
		CALL VpSelect window,'Drive18RADIOBUTTON',0
	END	/*Ends "IF Drive18Message \= "" THEN DO" Section*/

	ELSE DO
		UpLevel = "Go up to The Opening Dialog"
		Directory = Drive18"\*.*"
		Path = Drive18
	END	/*Ends "ELSE DO" Section*/
END	/*Ends "IF Drive18RadioButtonFlag = 1 THEN DO" Section*/



Total = 0
DO I = 1  TO MaxDriveNumber BY 1
	AssignVariable = "SubjectFlag = Drive"I"RadioButtonFlag"
	INTERPRET(AssignVariable)
	Total = Total + SubjectFlag
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
CALL SEEKENDS
return

/* ##256_1042.0 */
256_1042.0: /* Event  DRIVE19RADIOBUTTON, Clicked/selected */
Arg window self
DO I = 1  TO MaxDriveNumber BY 1
	SubjectDrive = "DRIVE"I"RADIOBUTTON"
	/* Get button state SubjectDrive Radio Button */
	AssignVariable = "Drive"I"RadioButtonFlag = "VpIsSelected(window,SubjectDrive)
	INTERPRET(AssignVariable)
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
FileName = VpGetItemValue(window,'FILENAME')



IF Drive19RadioButtonFlag = 1 THEN DO
	SelectType = "Single"
	IF Drive19Message \= "" THEN DO
		Title = "REMOVABLE MEDIA DRIVE WARNING!"
		response=VpMessageBox(window,Title,Drive19Message,'OKCNCL')
		IF response = "OK" THEN DO
			UpLevel = "Go up to The Opening Dialog"
			Directory = Drive19"\*.*"
			Path = Drive19
		END	/*Ends "IF response = "OK" THEN DO" Section*/

		ELSE 
		/* Uncheck the item Drive19RADIOBUTTON Radio Button */
		CALL VpSelect window,'Drive19RADIOBUTTON',0
	END	/*Ends "IF Drive19Message \= "" THEN DO" Section*/

	ELSE DO
		UpLevel = "Go up to The Opening Dialog"
		Directory = Drive19"\*.*"
		Path = Drive19
	END	/*Ends "ELSE DO" Section*/
END	/*Ends "IF Drive19RadioButtonFlag = 1 THEN DO" Section*/



Total = 0
DO I = 1  TO MaxDriveNumber BY 1
	AssignVariable = "SubjectFlag = Drive"I"RadioButtonFlag"
	INTERPRET(AssignVariable)
	Total = Total + SubjectFlag
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
CALL SEEKENDS
return

/* ##256_1043.0 */
256_1043.0: /* Event  DRIVE20RADIOBUTTON, Clicked/selected */
Arg window self
DO I = 1  TO MaxDriveNumber BY 1
	SubjectDrive = "DRIVE"I"RADIOBUTTON"
	/* Get button state SubjectDrive Radio Button */
	AssignVariable = "Drive"I"RadioButtonFlag = "VpIsSelected(window,SubjectDrive)
	INTERPRET(AssignVariable)
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
FileName = VpGetItemValue(window,'FILENAME')



IF Drive20RadioButtonFlag = 1 THEN DO
	SelectType = "Single"
	IF Drive20Message \= "" THEN DO
		Title = "REMOVABLE MEDIA DRIVE WARNING!"
		response=VpMessageBox(window,Title,Drive20Message,'OKCNCL')
		IF response = "OK" THEN DO
			UpLevel = "Go up to The Opening Dialog"
			Directory = Drive20"\*.*"
			Path = Drive20
		END	/*Ends "IF response = "OK" THEN DO" Section*/

		ELSE 
		/* Uncheck the item Drive20RADIOBUTTON Radio Button */
		CALL VpSelect window,'Drive20RADIOBUTTON',0
	END	/*Ends "IF Drive20Message \= "" THEN DO" Section*/

	ELSE DO
		UpLevel = "Go up to The Opening Dialog"
		Directory = Drive20"\*.*"
		Path = Drive20
	END	/*Ends "ELSE DO" Section*/
END	/*Ends "IF Drive20RadioButtonFlag = 1 THEN DO" Section*/



Total = 0
DO I = 1  TO MaxDriveNumber BY 1
	AssignVariable = "SubjectFlag = Drive"I"RadioButtonFlag"
	INTERPRET(AssignVariable)
	Total = Total + SubjectFlag
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
CALL SEEKENDS
return

/* ##256_1044.0 */
256_1044.0: /* Event  DRIVE21RADIOBUTTON, Clicked/selected */
Arg window self
DO I = 1  TO MaxDriveNumber BY 1
	SubjectDrive = "DRIVE"I"RADIOBUTTON"
	/* Get button state SubjectDrive Radio Button */
	AssignVariable = "Drive"I"RadioButtonFlag = "VpIsSelected(window,SubjectDrive)
	INTERPRET(AssignVariable)
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
FileName = VpGetItemValue(window,'FILENAME')



IF Drive21RadioButtonFlag = 1 THEN DO
	SelectType = "Single"
	IF Drive21Message \= "" THEN DO
		Title = "REMOVABLE MEDIA DRIVE WARNING!"
		response=VpMessageBox(window,Title,Drive21Message,'OKCNCL')
		IF response = "OK" THEN DO
			UpLevel = "Go up to The Opening Dialog"
			Directory = Drive21"\*.*"
			Path = Drive21
		END	/*Ends "IF response = "OK" THEN DO" Section*/

		ELSE 
		/* Uncheck the item Drive21RADIOBUTTON Radio Button */
		CALL VpSelect window,'Drive21RADIOBUTTON',0
	END	/*Ends "IF Drive21Message \= "" THEN DO" Section*/

	ELSE DO
		UpLevel = "Go up to The Opening Dialog"
		Directory = Drive21"\*.*"
		Path = Drive21
	END	/*Ends "ELSE DO" Section*/
END	/*Ends "IF Drive21RadioButtonFlag = 1 THEN DO" Section*/



Total = 0
DO I = 1  TO MaxDriveNumber BY 1
	AssignVariable = "SubjectFlag = Drive"I"RadioButtonFlag"
	INTERPRET(AssignVariable)
	Total = Total + SubjectFlag
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
CALL SEEKENDS
return

/* ##256_1045.0 */
256_1045.0: /* Event  DRIVE22RADIOBUTTON, Clicked/selected */
Arg window self
DO I = 1  TO MaxDriveNumber BY 1
	SubjectDrive = "DRIVE"I"RADIOBUTTON"
	/* Get button state SubjectDrive Radio Button */
	AssignVariable = "Drive"I"RadioButtonFlag = "VpIsSelected(window,SubjectDrive)
	INTERPRET(AssignVariable)
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
FileName = VpGetItemValue(window,'FILENAME')



IF Drive22RadioButtonFlag = 1 THEN DO
	SelectType = "Single"
	IF Drive22Message \= "" THEN DO
		Title = "REMOVABLE MEDIA DRIVE WARNING!"
		response=VpMessageBox(window,Title,Drive22Message,'OKCNCL')
		IF response = "OK" THEN DO
			UpLevel = "Go up to The Opening Dialog"
			Directory = Drive22"\*.*"
			Path = Drive22
		END	/*Ends "IF response = "OK" THEN DO" Section*/

		ELSE 
		/* Uncheck the item Drive22RADIOBUTTON Radio Button */
		CALL VpSelect window,'Drive22RADIOBUTTON',0
	END	/*Ends "IF Drive22Message \= "" THEN DO" Section*/

	ELSE DO
		UpLevel = "Go up to The Opening Dialog"
		Directory = Drive22"\*.*"
		Path = Drive22
	END	/*Ends "ELSE DO" Section*/
END	/*Ends "IF Drive22RadioButtonFlag = 1 THEN DO" Section*/



Total = 0
DO I = 1  TO MaxDriveNumber BY 1
	AssignVariable = "SubjectFlag = Drive"I"RadioButtonFlag"
	INTERPRET(AssignVariable)
	Total = Total + SubjectFlag
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
CALL SEEKENDS
return

/* ##256_1046.0 */
256_1046.0: /* Event  DRIVE23RADIOBUTTON, Clicked/selected */
Arg window self
DO I = 1  TO MaxDriveNumber BY 1
	SubjectDrive = "DRIVE"I"RADIOBUTTON"
	/* Get button state SubjectDrive Radio Button */
	AssignVariable = "Drive"I"RadioButtonFlag = "VpIsSelected(window,SubjectDrive)
	INTERPRET(AssignVariable)
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
FileName = VpGetItemValue(window,'FILENAME')



IF Drive23RadioButtonFlag = 1 THEN DO
	SelectType = "Single"
	IF Drive23Message \= "" THEN DO
		Title = "REMOVABLE MEDIA DRIVE WARNING!"
		response=VpMessageBox(window,Title,Drive23Message,'OKCNCL')
		IF response = "OK" THEN DO
			UpLevel = "Go up to The Opening Dialog"
			Directory = Drive23"\*.*"
			Path = Drive23
		END	/*Ends "IF response = "OK" THEN DO" Section*/

		ELSE 
		/* Uncheck the item Drive23RADIOBUTTON Radio Button */
		CALL VpSelect window,'Drive23RADIOBUTTON',0
	END	/*Ends "IF Drive23Message \= "" THEN DO" Section*/

	ELSE DO
		UpLevel = "Go up to The Opening Dialog"
		Directory = Drive23"\*.*"
		Path = Drive23
	END	/*Ends "ELSE DO" Section*/
END	/*Ends "IF Drive23RadioButtonFlag = 1 THEN DO" Section*/



Total = 0
DO I = 1  TO MaxDriveNumber BY 1
	AssignVariable = "SubjectFlag = Drive"I"RadioButtonFlag"
	INTERPRET(AssignVariable)
	Total = Total + SubjectFlag
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
CALL SEEKENDS
return

/* ##256_1047.0 */
256_1047.0: /* Event  DRIVE24RADIOBUTTON, Clicked/selected */
Arg window self
DO I = 1  TO MaxDriveNumber BY 1
	SubjectDrive = "DRIVE"I"RADIOBUTTON"
	/* Get button state SubjectDrive Radio Button */
	AssignVariable = "Drive"I"RadioButtonFlag = "VpIsSelected(window,SubjectDrive)
	INTERPRET(AssignVariable)
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
FileName = VpGetItemValue(window,'FILENAME')



IF Drive24RadioButtonFlag = 1 THEN DO
	SelectType = "Single"
	IF Drive24Message \= "" THEN DO
		Title = "REMOVABLE MEDIA DRIVE WARNING!"
		response=VpMessageBox(window,Title,Drive24Message,'OKCNCL')
		IF response = "OK" THEN DO
			UpLevel = "Go up to The Opening Dialog"
			Directory = Drive24"\*.*"
			Path = Drive24
		END	/*Ends "IF response = "OK" THEN DO" Section*/

		ELSE 
		/* Uncheck the item Drive24RADIOBUTTON Radio Button */
		CALL VpSelect window,'Drive24RADIOBUTTON',0
	END	/*Ends "IF Drive24Message \= "" THEN DO" Section*/

	ELSE DO
		UpLevel = "Go up to The Opening Dialog"
		Directory = Drive24"\*.*"
		Path = Drive24
	END	/*Ends "ELSE DO" Section*/
END	/*Ends "IF Drive24RadioButtonFlag = 1 THEN DO" Section*/



Total = 0
DO I = 1  TO MaxDriveNumber BY 1
	AssignVariable = "SubjectFlag = Drive"I"RadioButtonFlag"
	INTERPRET(AssignVariable)
	Total = Total + SubjectFlag
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
CALL SEEKENDS
return

/* ##256_1048.0 */
256_1048.0: /* Event  DRIVE25RADIOBUTTON, Clicked/selected */
Arg window self
DO I = 1  TO MaxDriveNumber BY 1
	SubjectDrive = "DRIVE"I"RADIOBUTTON"
	/* Get button state SubjectDrive Radio Button */
	AssignVariable = "Drive"I"RadioButtonFlag = "VpIsSelected(window,SubjectDrive)
	INTERPRET(AssignVariable)
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
FileName = VpGetItemValue(window,'FILENAME')



IF Drive25RadioButtonFlag = 1 THEN DO
	SelectType = "Single"
	IF Drive25Message \= "" THEN DO
		Title = "REMOVABLE MEDIA DRIVE WARNING!"
		response=VpMessageBox(window,Title,Drive25Message,'OKCNCL')
		IF response = "OK" THEN DO
			UpLevel = "Go up to The Opening Dialog"
			Directory = Drive25"\*.*"
			Path = Drive25
		END	/*Ends "IF response = "OK" THEN DO" Section*/

		ELSE 
		/* Uncheck the item Drive25RADIOBUTTON Radio Button */
		CALL VpSelect window,'Drive25RADIOBUTTON',0
	END	/*Ends "IF Drive25Message \= "" THEN DO" Section*/

	ELSE DO
		UpLevel = "Go up to The Opening Dialog"
		Directory = Drive25"\*.*"
		Path = Drive25
	END	/*Ends "ELSE DO" Section*/
END	/*Ends "IF Drive25RadioButtonFlag = 1 THEN DO" Section*/



Total = 0
DO I = 1  TO MaxDriveNumber BY 1
	AssignVariable = "SubjectFlag = Drive"I"RadioButtonFlag"
	INTERPRET(AssignVariable)
	Total = Total + SubjectFlag
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
CALL SEEKENDS
return

/* ##256_1049.0 */
256_1049.0: /* Event  DRIVE26RADIOBUTTON, Clicked/selected */
Arg window self
DO I = 1  TO MaxDriveNumber BY 1
	SubjectDrive = "DRIVE"I"RADIOBUTTON"
	/* Get button state SubjectDrive Radio Button */
	AssignVariable = "Drive"I"RadioButtonFlag = "VpIsSelected(window,SubjectDrive)
	INTERPRET(AssignVariable)
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
FileName = VpGetItemValue(window,'FILENAME')



IF Drive26RadioButtonFlag = 1 THEN DO
	SelectType = "Single"
	IF Drive26Message \= "" THEN DO
		Title = "REMOVABLE MEDIA DRIVE WARNING!"
		response=VpMessageBox(window,Title,Drive26Message,'OKCNCL')
		IF response = "OK" THEN DO
			UpLevel = "Go up to The Opening Dialog"
			Directory = Drive26"\*.*"
			Path = Drive26
		END	/*Ends "IF response = "OK" THEN DO" Section*/

		ELSE 
		/* Uncheck the item Drive26RADIOBUTTON Radio Button */
		CALL VpSelect window,'Drive26RADIOBUTTON',0
	END	/*Ends "IF Drive26Message \= "" THEN DO" Section*/

	ELSE DO
		UpLevel = "Go up to The Opening Dialog"
		Directory = Drive26"\*.*"
		Path = Drive26
	END	/*Ends "ELSE DO" Section*/
END	/*Ends "IF Drive26RadioButtonFlag = 1 THEN DO" Section*/



Total = 0
DO I = 1  TO MaxDriveNumber BY 1
	AssignVariable = "SubjectFlag = Drive"I"RadioButtonFlag"
	INTERPRET(AssignVariable)
	Total = Total + SubjectFlag
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
CALL SEEKENDS
return

/* ##256_1050.0 */
256_1050.0: /* Event  DRIVE15CHECKBOX, Clicked/selected */
Arg window self
DO I = 1  TO MaxDriveNumber BY 1
	SubjectDrive = "DRIVE"I"CHECKBOX"
	/* Get button state SubjectDrive Check Box */
	AssignVariable = "Drive"I"CheckBoxFlag = "VpIsSelected(window,SubjectDrive)
	INTERPRET(AssignVariable)
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
FileName = VpGetItemValue(window,'FILENAME')



IF Drive15CheckBoxFlag = 1 THEN DO
	SelectType = "Multiple"
	IF Drive15Message \= "" THEN DO
		Title = "REMOVABLE MEDIA DRIVE WARNING!"
		response=VpMessageBox(window,Title,Drive15Message,'OKCNCL')
		IF response = "OK" THEN DO
			UpLevel = "Go up to The Opening Dialog"
			Directory = Drive15"\*.*"
			Path = Drive15
		END	/*Ends "IF response = "OK" THEN DO" Section*/
	END	/*Ends "IF Drive15Message \= "" THEN DO" Section*/
	ELSE response = "OK"
	
	IF response = "OK" THEN DO
		J = 0
		Directories. = ""
		Paths. = ""
		UpLevel = "Go up to The Opening Dialog"
		DO I = 1  TO MaxDriveNumber BY 1
			SubjectDrive = "DRIVE"I"CHECKBOX"
			AssignVariable = "SubjectFlag = "VpIsSelected(window,SubjectDrive)
			INTERPRET(AssignVariable)
			IF SubjectFlag = 1 THEN DO
				J = J + 1
				AssignVariable = "SSubjectDrive = Drive"I
				INTERPRET(AssignVariable)
				Directories.J = SSubjectDrive"\*.*"
				Paths.J = SSubjectDrive
			END	/*Ends "IF SubjectFlag = 1 THEN DO" Section*/
		END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
		Paths.0 = J
	END	/*Ends "IF response = "OK" THEN DO" Section*/

	ELSE 
	/* Uncheck the item Drive15CHECKBOX Radio Button */
	CALL VpSelect window,'Drive15CHECKBOX',0
END	/*Ends "IF Drive15CheckBoxFlag = 1 THEN DO" Section*/



Total = 0
DO I = 1  TO MaxDriveNumber BY 1
	AssignVariable = "SubjectFlag = Drive"I"CheckBoxFlag"
	INTERPRET(AssignVariable)
	Total = Total + SubjectFlag
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
CALL SEEKENDS
return

/* ##256_1051.0 */
256_1051.0: /* Event  DRIVE16CHECKBOX, Clicked/selected */
Arg window self
DO I = 1  TO MaxDriveNumber BY 1
	SubjectDrive = "DRIVE"I"CHECKBOX"
	/* Get button state SubjectDrive Check Box */
	AssignVariable = "Drive"I"CheckBoxFlag = "VpIsSelected(window,SubjectDrive)
	INTERPRET(AssignVariable)
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
FileName = VpGetItemValue(window,'FILENAME')



IF Drive16CheckBoxFlag = 1 THEN DO
	SelectType = "Multiple"
	IF Drive16Message \= "" THEN DO
		Title = "REMOVABLE MEDIA DRIVE WARNING!"
		response=VpMessageBox(window,Title,Drive16Message,'OKCNCL')
		IF response = "OK" THEN DO
			UpLevel = "Go up to The Opening Dialog"
			Directory = Drive16"\*.*"
			Path = Drive16
		END	/*Ends "IF response = "OK" THEN DO" Section*/
	END	/*Ends "IF Drive16Message \= "" THEN DO" Section*/
	ELSE response = "OK"
	
	IF response = "OK" THEN DO
		J = 0
		Directories. = ""
		Paths. = ""
		UpLevel = "Go up to The Opening Dialog"
		DO I = 1  TO MaxDriveNumber BY 1
			SubjectDrive = "DRIVE"I"CHECKBOX"
			AssignVariable = "SubjectFlag = "VpIsSelected(window,SubjectDrive)
			INTERPRET(AssignVariable)
			IF SubjectFlag = 1 THEN DO
				J = J + 1
				AssignVariable = "SSubjectDrive = Drive"I
				INTERPRET(AssignVariable)
				Directories.J = SSubjectDrive"\*.*"
				Paths.J = SSubjectDrive
			END	/*Ends "IF SubjectFlag = 1 THEN DO" Section*/
		END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
		Paths.0 = J
	END	/*Ends "IF response = "OK" THEN DO" Section*/

	ELSE 
	/* Uncheck the item Drive16CHECKBOX Radio Button */
	CALL VpSelect window,'Drive16CHECKBOX',0
END	/*Ends "IF Drive16CheckBoxFlag = 1 THEN DO" Section*/



Total = 0
DO I = 1  TO MaxDriveNumber BY 1
	AssignVariable = "SubjectFlag = Drive"I"CheckBoxFlag"
	INTERPRET(AssignVariable)
	Total = Total + SubjectFlag
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
CALL SEEKENDS
return

/* ##256_1052.0 */
256_1052.0: /* Event  DRIVE17CHECKBOX, Clicked/selected */
Arg window self
DO I = 1  TO MaxDriveNumber BY 1
	SubjectDrive = "DRIVE"I"CHECKBOX"
	/* Get button state SubjectDrive Check Box */
	AssignVariable = "Drive"I"CheckBoxFlag = "VpIsSelected(window,SubjectDrive)
	INTERPRET(AssignVariable)
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
FileName = VpGetItemValue(window,'FILENAME')



IF Drive17CheckBoxFlag = 1 THEN DO
	SelectType = "Multiple"
	IF Drive17Message \= "" THEN DO
		Title = "REMOVABLE MEDIA DRIVE WARNING!"
		response=VpMessageBox(window,Title,Drive17Message,'OKCNCL')
		IF response = "OK" THEN DO
			UpLevel = "Go up to The Opening Dialog"
			Directory = Drive17"\*.*"
			Path = Drive17
		END	/*Ends "IF response = "OK" THEN DO" Section*/
	END	/*Ends "IF Drive17Message \= "" THEN DO" Section*/
	ELSE response = "OK"
	
	IF response = "OK" THEN DO
		J = 0
		Directories. = ""
		Paths. = ""
		UpLevel = "Go up to The Opening Dialog"
		DO I = 1  TO MaxDriveNumber BY 1
			SubjectDrive = "DRIVE"I"CHECKBOX"
			AssignVariable = "SubjectFlag = "VpIsSelected(window,SubjectDrive)
			INTERPRET(AssignVariable)
			IF SubjectFlag = 1 THEN DO
				J = J + 1
				AssignVariable = "SSubjectDrive = Drive"I
				INTERPRET(AssignVariable)
				Directories.J = SSubjectDrive"\*.*"
				Paths.J = SSubjectDrive
			END	/*Ends "IF SubjectFlag = 1 THEN DO" Section*/
		END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
		Paths.0 = J
	END	/*Ends "IF response = "OK" THEN DO" Section*/

	ELSE 
	/* Uncheck the item Drive17CHECKBOX Radio Button */
	CALL VpSelect window,'Drive17CHECKBOX',0
END	/*Ends "IF Drive17CheckBoxFlag = 1 THEN DO" Section*/



Total = 0
DO I = 1  TO MaxDriveNumber BY 1
	AssignVariable = "SubjectFlag = Drive"I"CheckBoxFlag"
	INTERPRET(AssignVariable)
	Total = Total + SubjectFlag
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
CALL SEEKENDS
return

/* ##256_1053.0 */
256_1053.0: /* Event  DRIVE18CHECKBOX, Clicked/selected */
Arg window self
DO I = 1  TO MaxDriveNumber BY 1
	SubjectDrive = "DRIVE"I"CHECKBOX"
	/* Get button state SubjectDrive Check Box */
	AssignVariable = "Drive"I"CheckBoxFlag = "VpIsSelected(window,SubjectDrive)
	INTERPRET(AssignVariable)
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
FileName = VpGetItemValue(window,'FILENAME')



IF Drive18CheckBoxFlag = 1 THEN DO
	SelectType = "Multiple"
	IF Drive18Message \= "" THEN DO
		Title = "REMOVABLE MEDIA DRIVE WARNING!"
		response=VpMessageBox(window,Title,Drive18Message,'OKCNCL')
		IF response = "OK" THEN DO
			UpLevel = "Go up to The Opening Dialog"
			Directory = Drive18"\*.*"
			Path = Drive18
		END	/*Ends "IF response = "OK" THEN DO" Section*/
	END	/*Ends "IF Drive18Message \= "" THEN DO" Section*/
	ELSE response = "OK"
	
	IF response = "OK" THEN DO
		J = 0
		Directories. = ""
		Paths. = ""
		UpLevel = "Go up to The Opening Dialog"
		DO I = 1  TO MaxDriveNumber BY 1
			SubjectDrive = "DRIVE"I"CHECKBOX"
			AssignVariable = "SubjectFlag = "VpIsSelected(window,SubjectDrive)
			INTERPRET(AssignVariable)
			IF SubjectFlag = 1 THEN DO
				J = J + 1
				AssignVariable = "SSubjectDrive = Drive"I
				INTERPRET(AssignVariable)
				Directories.J = SSubjectDrive"\*.*"
				Paths.J = SSubjectDrive
			END	/*Ends "IF SubjectFlag = 1 THEN DO" Section*/
		END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
		Paths.0 = J
	END	/*Ends "IF response = "OK" THEN DO" Section*/

	ELSE 
	/* Uncheck the item Drive18CHECKBOX Radio Button */
	CALL VpSelect window,'Drive18CHECKBOX',0
END	/*Ends "IF Drive18CheckBoxFlag = 1 THEN DO" Section*/



Total = 0
DO I = 1  TO MaxDriveNumber BY 1
	AssignVariable = "SubjectFlag = Drive"I"CheckBoxFlag"
	INTERPRET(AssignVariable)
	Total = Total + SubjectFlag
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
CALL SEEKENDS
return

/* ##256_1054.0 */
256_1054.0: /* Event  DRIVE19CHECKBOX, Clicked/selected */
Arg window self
DO I = 1  TO MaxDriveNumber BY 1
	SubjectDrive = "DRIVE"I"CHECKBOX"
	/* Get button state SubjectDrive Check Box */
	AssignVariable = "Drive"I"CheckBoxFlag = "VpIsSelected(window,SubjectDrive)
	INTERPRET(AssignVariable)
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
FileName = VpGetItemValue(window,'FILENAME')



IF Drive19CheckBoxFlag = 1 THEN DO
	SelectType = "Multiple"
	IF Drive19Message \= "" THEN DO
		Title = "REMOVABLE MEDIA DRIVE WARNING!"
		response=VpMessageBox(window,Title,Drive19Message,'OKCNCL')
		IF response = "OK" THEN DO
			UpLevel = "Go up to The Opening Dialog"
			Directory = Drive19"\*.*"
			Path = Drive19
		END	/*Ends "IF response = "OK" THEN DO" Section*/
	END	/*Ends "IF Drive19Message \= "" THEN DO" Section*/
	ELSE response = "OK"
	
	IF response = "OK" THEN DO
		J = 0
		Directories. = ""
		Paths. = ""
		UpLevel = "Go up to The Opening Dialog"
		DO I = 1  TO MaxDriveNumber BY 1
			SubjectDrive = "DRIVE"I"CHECKBOX"
			AssignVariable = "SubjectFlag = "VpIsSelected(window,SubjectDrive)
			INTERPRET(AssignVariable)
			IF SubjectFlag = 1 THEN DO
				J = J + 1
				AssignVariable = "SSubjectDrive = Drive"I
				INTERPRET(AssignVariable)
				Directories.J = SSubjectDrive"\*.*"
				Paths.J = SSubjectDrive
			END	/*Ends "IF SubjectFlag = 1 THEN DO" Section*/
		END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
		Paths.0 = J
	END	/*Ends "IF response = "OK" THEN DO" Section*/

	ELSE 
	/* Uncheck the item Drive19CHECKBOX Radio Button */
	CALL VpSelect window,'Drive19CHECKBOX',0
END	/*Ends "IF Drive19CheckBoxFlag = 1 THEN DO" Section*/



Total = 0
DO I = 1  TO MaxDriveNumber BY 1
	AssignVariable = "SubjectFlag = Drive"I"CheckBoxFlag"
	INTERPRET(AssignVariable)
	Total = Total + SubjectFlag
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
CALL SEEKENDS
return

/* ##256_1055.0 */
256_1055.0: /* Event  DRIVE20CHECKBOX, Clicked/selected */
Arg window self
DO I = 1  TO MaxDriveNumber BY 1
	SubjectDrive = "DRIVE"I"CHECKBOX"
	/* Get button state SubjectDrive Check Box */
	AssignVariable = "Drive"I"CheckBoxFlag = "VpIsSelected(window,SubjectDrive)
	INTERPRET(AssignVariable)
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
FileName = VpGetItemValue(window,'FILENAME')



IF Drive20CheckBoxFlag = 1 THEN DO
	SelectType = "Multiple"
	IF Drive20Message \= "" THEN DO
		Title = "REMOVABLE MEDIA DRIVE WARNING!"
		response=VpMessageBox(window,Title,Drive20Message,'OKCNCL')
		IF response = "OK" THEN DO
			UpLevel = "Go up to The Opening Dialog"
			Directory = Drive20"\*.*"
			Path = Drive20
		END	/*Ends "IF response = "OK" THEN DO" Section*/
	END	/*Ends "IF Drive20Message \= "" THEN DO" Section*/
	ELSE response = "OK"
	
	IF response = "OK" THEN DO
		J = 0
		Directories. = ""
		Paths. = ""
		UpLevel = "Go up to The Opening Dialog"
		DO I = 1  TO MaxDriveNumber BY 1
			SubjectDrive = "DRIVE"I"CHECKBOX"
			AssignVariable = "SubjectFlag = "VpIsSelected(window,SubjectDrive)
			INTERPRET(AssignVariable)
			IF SubjectFlag = 1 THEN DO
				J = J + 1
				AssignVariable = "SSubjectDrive = Drive"I
				INTERPRET(AssignVariable)
				Directories.J = SSubjectDrive"\*.*"
				Paths.J = SSubjectDrive
			END	/*Ends "IF SubjectFlag = 1 THEN DO" Section*/
		END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
		Paths.0 = J
	END	/*Ends "IF response = "OK" THEN DO" Section*/

	ELSE 
	/* Uncheck the item Drive20CHECKBOX Radio Button */
	CALL VpSelect window,'Drive20CHECKBOX',0
END	/*Ends "IF Drive20CheckBoxFlag = 1 THEN DO" Section*/



Total = 0
DO I = 1  TO MaxDriveNumber BY 1
	AssignVariable = "SubjectFlag = Drive"I"CheckBoxFlag"
	INTERPRET(AssignVariable)
	Total = Total + SubjectFlag
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
CALL SEEKENDS
return

/* ##256_1056.0 */
256_1056.0: /* Event  DRIVE21CHECKBOX, Clicked/selected */
Arg window self
DO I = 1  TO MaxDriveNumber BY 1
	SubjectDrive = "DRIVE"I"CHECKBOX"
	/* Get button state SubjectDrive Check Box */
	AssignVariable = "Drive"I"CheckBoxFlag = "VpIsSelected(window,SubjectDrive)
	INTERPRET(AssignVariable)
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
FileName = VpGetItemValue(window,'FILENAME')



IF Drive21CheckBoxFlag = 1 THEN DO
	SelectType = "Multiple"
	IF Drive21Message \= "" THEN DO
		Title = "REMOVABLE MEDIA DRIVE WARNING!"
		response=VpMessageBox(window,Title,Drive21Message,'OKCNCL')
		IF response = "OK" THEN DO
			UpLevel = "Go up to The Opening Dialog"
			Directory = Drive21"\*.*"
			Path = Drive21
		END	/*Ends "IF response = "OK" THEN DO" Section*/
	END	/*Ends "IF Drive21Message \= "" THEN DO" Section*/
	ELSE response = "OK"
	
	IF response = "OK" THEN DO
		J = 0
		Directories. = ""
		Paths. = ""
		UpLevel = "Go up to The Opening Dialog"
		DO I = 1  TO MaxDriveNumber BY 1
			SubjectDrive = "DRIVE"I"CHECKBOX"
			AssignVariable = "SubjectFlag = "VpIsSelected(window,SubjectDrive)
			INTERPRET(AssignVariable)
			IF SubjectFlag = 1 THEN DO
				J = J + 1
				AssignVariable = "SSubjectDrive = Drive"I
				INTERPRET(AssignVariable)
				Directories.J = SSubjectDrive"\*.*"
				Paths.J = SSubjectDrive
			END	/*Ends "IF SubjectFlag = 1 THEN DO" Section*/
		END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
		Paths.0 = J
	END	/*Ends "IF response = "OK" THEN DO" Section*/

	ELSE 
	/* Uncheck the item Drive21CHECKBOX Radio Button */
	CALL VpSelect window,'Drive21CHECKBOX',0
END	/*Ends "IF Drive21CheckBoxFlag = 1 THEN DO" Section*/



Total = 0
DO I = 1  TO MaxDriveNumber BY 1
	AssignVariable = "SubjectFlag = Drive"I"CheckBoxFlag"
	INTERPRET(AssignVariable)
	Total = Total + SubjectFlag
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
CALL SEEKENDS
return

/* ##256_1057.0 */
256_1057.0: /* Event  DRIVE22CHECKBOX, Clicked/selected */
Arg window self
DO I = 1  TO MaxDriveNumber BY 1
	SubjectDrive = "DRIVE"I"CHECKBOX"
	/* Get button state SubjectDrive Check Box */
	AssignVariable = "Drive"I"CheckBoxFlag = "VpIsSelected(window,SubjectDrive)
	INTERPRET(AssignVariable)
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
FileName = VpGetItemValue(window,'FILENAME')



IF Drive22CheckBoxFlag = 1 THEN DO
	SelectType = "Multiple"
	IF Drive22Message \= "" THEN DO
		Title = "REMOVABLE MEDIA DRIVE WARNING!"
		response=VpMessageBox(window,Title,Drive22Message,'OKCNCL')
		IF response = "OK" THEN DO
			UpLevel = "Go up to The Opening Dialog"
			Directory = Drive22"\*.*"
			Path = Drive22
		END	/*Ends "IF response = "OK" THEN DO" Section*/
	END	/*Ends "IF Drive22Message \= "" THEN DO" Section*/
	ELSE response = "OK"
	
	IF response = "OK" THEN DO
		J = 0
		Directories. = ""
		Paths. = ""
		UpLevel = "Go up to The Opening Dialog"
		DO I = 1  TO MaxDriveNumber BY 1
			SubjectDrive = "DRIVE"I"CHECKBOX"
			AssignVariable = "SubjectFlag = "VpIsSelected(window,SubjectDrive)
			INTERPRET(AssignVariable)
			IF SubjectFlag = 1 THEN DO
				J = J + 1
				AssignVariable = "SSubjectDrive = Drive"I
				INTERPRET(AssignVariable)
				Directories.J = SSubjectDrive"\*.*"
				Paths.J = SSubjectDrive
			END	/*Ends "IF SubjectFlag = 1 THEN DO" Section*/
		END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
		Paths.0 = J
	END	/*Ends "IF response = "OK" THEN DO" Section*/

	ELSE 
	/* Uncheck the item Drive22CHECKBOX Radio Button */
	CALL VpSelect window,'Drive22CHECKBOX',0
END	/*Ends "IF Drive22CheckBoxFlag = 1 THEN DO" Section*/



Total = 0
DO I = 1  TO MaxDriveNumber BY 1
	AssignVariable = "SubjectFlag = Drive"I"CheckBoxFlag"
	INTERPRET(AssignVariable)
	Total = Total + SubjectFlag
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
CALL SEEKENDS
return

/* ##256_1058.0 */
256_1058.0: /* Event  DRIVE23CHECKBOX, Clicked/selected */
Arg window self
DO I = 1  TO MaxDriveNumber BY 1
	SubjectDrive = "DRIVE"I"CHECKBOX"
	/* Get button state SubjectDrive Check Box */
	AssignVariable = "Drive"I"CheckBoxFlag = "VpIsSelected(window,SubjectDrive)
	INTERPRET(AssignVariable)
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
FileName = VpGetItemValue(window,'FILENAME')



IF Drive23CheckBoxFlag = 1 THEN DO
	SelectType = "Multiple"
	IF Drive23Message \= "" THEN DO
		Title = "REMOVABLE MEDIA DRIVE WARNING!"
		response=VpMessageBox(window,Title,Drive23Message,'OKCNCL')
		IF response = "OK" THEN DO
			UpLevel = "Go up to The Opening Dialog"
			Directory = Drive23"\*.*"
			Path = Drive23
		END	/*Ends "IF response = "OK" THEN DO" Section*/
	END	/*Ends "IF Drive23Message \= "" THEN DO" Section*/
	ELSE response = "OK"
	
	IF response = "OK" THEN DO
		J = 0
		Directories. = ""
		Paths. = ""
		UpLevel = "Go up to The Opening Dialog"
		DO I = 1  TO MaxDriveNumber BY 1
			SubjectDrive = "DRIVE"I"CHECKBOX"
			AssignVariable = "SubjectFlag = "VpIsSelected(window,SubjectDrive)
			INTERPRET(AssignVariable)
			IF SubjectFlag = 1 THEN DO
				J = J + 1
				AssignVariable = "SSubjectDrive = Drive"I
				INTERPRET(AssignVariable)
				Directories.J = SSubjectDrive"\*.*"
				Paths.J = SSubjectDrive
			END	/*Ends "IF SubjectFlag = 1 THEN DO" Section*/
		END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
		Paths.0 = J
	END	/*Ends "IF response = "OK" THEN DO" Section*/

	ELSE 
	/* Uncheck the item Drive23CHECKBOX Radio Button */
	CALL VpSelect window,'Drive23CHECKBOX',0
END	/*Ends "IF Drive23CheckBoxFlag = 1 THEN DO" Section*/



Total = 0
DO I = 1  TO MaxDriveNumber BY 1
	AssignVariable = "SubjectFlag = Drive"I"CheckBoxFlag"
	INTERPRET(AssignVariable)
	Total = Total + SubjectFlag
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
CALL SEEKENDS
return

/* ##256_1059.0 */
256_1059.0: /* Event  DRIVE24CHECKBOX, Clicked/selected */
Arg window self
DO I = 1  TO MaxDriveNumber BY 1
	SubjectDrive = "DRIVE"I"CHECKBOX"
	/* Get button state SubjectDrive Check Box */
	AssignVariable = "Drive"I"CheckBoxFlag = "VpIsSelected(window,SubjectDrive)
	INTERPRET(AssignVariable)
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
FileName = VpGetItemValue(window,'FILENAME')



IF Drive24CheckBoxFlag = 1 THEN DO
	SelectType = "Multiple"
	IF Drive24Message \= "" THEN DO
		Title = "REMOVABLE MEDIA DRIVE WARNING!"
		response=VpMessageBox(window,Title,Drive24Message,'OKCNCL')
		IF response = "OK" THEN DO
			UpLevel = "Go up to The Opening Dialog"
			Directory = Drive24"\*.*"
			Path = Drive24
		END	/*Ends "IF response = "OK" THEN DO" Section*/
	END	/*Ends "IF Drive24Message \= "" THEN DO" Section*/
	ELSE response = "OK"
	
	IF response = "OK" THEN DO
		J = 0
		Directories. = ""
		Paths. = ""
		UpLevel = "Go up to The Opening Dialog"
		DO I = 1  TO MaxDriveNumber BY 1
			SubjectDrive = "DRIVE"I"CHECKBOX"
			AssignVariable = "SubjectFlag = "VpIsSelected(window,SubjectDrive)
			INTERPRET(AssignVariable)
			IF SubjectFlag = 1 THEN DO
				J = J + 1
				AssignVariable = "SSubjectDrive = Drive"I
				INTERPRET(AssignVariable)
				Directories.J = SSubjectDrive"\*.*"
				Paths.J = SSubjectDrive
			END	/*Ends "IF SubjectFlag = 1 THEN DO" Section*/
		END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
		Paths.0 = J
	END	/*Ends "IF response = "OK" THEN DO" Section*/

	ELSE 
	/* Uncheck the item Drive24CHECKBOX Radio Button */
	CALL VpSelect window,'Drive24CHECKBOX',0
END	/*Ends "IF Drive24CheckBoxFlag = 1 THEN DO" Section*/



Total = 0
DO I = 1  TO MaxDriveNumber BY 1
	AssignVariable = "SubjectFlag = Drive"I"CheckBoxFlag"
	INTERPRET(AssignVariable)
	Total = Total + SubjectFlag
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
CALL SEEKENDS
return

/* ##256_1060.0 */
256_1060.0: /* Event  DRIVE25CHECKBOX, Clicked/selected */
Arg window self
DO I = 1  TO MaxDriveNumber BY 1
	SubjectDrive = "DRIVE"I"CHECKBOX"
	/* Get button state SubjectDrive Check Box */
	AssignVariable = "Drive"I"CheckBoxFlag = "VpIsSelected(window,SubjectDrive)
	INTERPRET(AssignVariable)
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
FileName = VpGetItemValue(window,'FILENAME')



IF Drive25CheckBoxFlag = 1 THEN DO
	SelectType = "Multiple"
	IF Drive25Message \= "" THEN DO
		Title = "REMOVABLE MEDIA DRIVE WARNING!"
		response=VpMessageBox(window,Title,Drive25Message,'OKCNCL')
		IF response = "OK" THEN DO
			UpLevel = "Go up to The Opening Dialog"
			Directory = Drive25"\*.*"
			Path = Drive25
		END	/*Ends "IF response = "OK" THEN DO" Section*/
	END	/*Ends "IF Drive25Message \= "" THEN DO" Section*/
	ELSE response = "OK"
	
	IF response = "OK" THEN DO
		J = 0
		Directories. = ""
		Paths. = ""
		UpLevel = "Go up to The Opening Dialog"
		DO I = 1  TO MaxDriveNumber BY 1
			SubjectDrive = "DRIVE"I"CHECKBOX"
			AssignVariable = "SubjectFlag = "VpIsSelected(window,SubjectDrive)
			INTERPRET(AssignVariable)
			IF SubjectFlag = 1 THEN DO
				J = J + 1
				AssignVariable = "SSubjectDrive = Drive"I
				INTERPRET(AssignVariable)
				Directories.J = SSubjectDrive"\*.*"
				Paths.J = SSubjectDrive
			END	/*Ends "IF SubjectFlag = 1 THEN DO" Section*/
		END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
		Paths.0 = J
	END	/*Ends "IF response = "OK" THEN DO" Section*/

	ELSE 
	/* Uncheck the item Drive25CHECKBOX Radio Button */
	CALL VpSelect window,'Drive25CHECKBOX',0
END	/*Ends "IF Drive25CheckBoxFlag = 1 THEN DO" Section*/



Total = 0
DO I = 1  TO MaxDriveNumber BY 1
	AssignVariable = "SubjectFlag = Drive"I"CheckBoxFlag"
	INTERPRET(AssignVariable)
	Total = Total + SubjectFlag
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
CALL SEEKENDS
return

/* ##256_1061.0 */
256_1061.0: /* Event  DRIVE26CHECKBOX, Clicked/selected */
Arg window self
DO I = 1  TO MaxDriveNumber BY 1
	SubjectDrive = "DRIVE"I"CHECKBOX"
	/* Get button state SubjectDrive Check Box */
	AssignVariable = "Drive"I"CheckBoxFlag = "VpIsSelected(window,SubjectDrive)
	INTERPRET(AssignVariable)
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
FileName = VpGetItemValue(window,'FILENAME')



IF Drive26CheckBoxFlag = 1 THEN DO
	SelectType = "Multiple"
	IF Drive26Message \= "" THEN DO
		Title = "REMOVABLE MEDIA DRIVE WARNING!"
		response=VpMessageBox(window,Title,Drive26Message,'OKCNCL')
		IF response = "OK" THEN DO
			UpLevel = "Go up to The Opening Dialog"
			Directory = Drive26"\*.*"
			Path = Drive26
		END	/*Ends "IF response = "OK" THEN DO" Section*/
	END	/*Ends "IF Drive26Message \= "" THEN DO" Section*/
	ELSE response = "OK"
	
	IF response = "OK" THEN DO
		J = 0
		Directories. = ""
		Paths. = ""
		UpLevel = "Go up to The Opening Dialog"
		DO I = 1  TO MaxDriveNumber BY 1
			SubjectDrive = "DRIVE"I"CHECKBOX"
			AssignVariable = "SubjectFlag = "VpIsSelected(window,SubjectDrive)
			INTERPRET(AssignVariable)
			IF SubjectFlag = 1 THEN DO
				J = J + 1
				AssignVariable = "SSubjectDrive = Drive"I
				INTERPRET(AssignVariable)
				Directories.J = SSubjectDrive"\*.*"
				Paths.J = SSubjectDrive
			END	/*Ends "IF SubjectFlag = 1 THEN DO" Section*/
		END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
		Paths.0 = J
	END	/*Ends "IF response = "OK" THEN DO" Section*/

	ELSE 
	/* Uncheck the item Drive26CHECKBOX Radio Button */
	CALL VpSelect window,'Drive26CHECKBOX',0
END	/*Ends "IF Drive26CheckBoxFlag = 1 THEN DO" Section*/



Total = 0
DO I = 1  TO MaxDriveNumber BY 1
	AssignVariable = "SubjectFlag = Drive"I"CheckBoxFlag"
	INTERPRET(AssignVariable)
	Total = Total + SubjectFlag
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
CALL SEEKENDS
return

/* ##256_1063.0 */
256_1063.0: /* Event Perform additional presorting on PRESORT, Clicked/selected */
Arg window self



/*Begin determining what data to presort*/
PerformPreSortFlag = 1
/* Open the form C:\Development\REXX\VisProREXX\PROJECTS\Seek\Presort */
PresortFormID = VpOpenForm(window, 260, 'topic name')
/*End determining what data to presort*/
return

/* ##256_1064.0 */
256_1064.0: /* Event Yes YES, Clicked/selected */
Arg window self



YesRecursiveFlag = ""
NoRecursiveFlag = ""
FileNameSearchFlag = ""
DirectorySearchFlag = ""

/* Get button state YES Radio Button */
YesRecursiveFlag = VpIsSelected(window,'YES')
/* Get button state NO Radio Button */
NoRecursiveFlag = VpIsSelected(window,'NO')
/* Get button state FILENAMESEARCH Radio Button */
FileNameSearchFlag = VpIsSelected(window,'FILENAMESEARCH')
/* Get button state DIRECTORYNAMESEARCH Radio Button */
DirectorySearchFlag = VpIsSelected(window,'DIRECTORYNAMESEARCH')

SELECT
	WHEN YesRecursiveFlag = 1 & FileNameSearchFlag = 1 THEN SysFileTreeOption = "FS"
	WHEN YesRecursiveFlag = 1 & DirectorySearchFlag = 1 THEN SysFileTreeOption = "DS"
	WHEN NoRecursiveFlag = 1 & FileNameSearchFlag = 1 THEN SysFileTreeOption = "F"
	WHEN NoRecursiveFlag = 1 & DirectorySearchFlag = 1 THEN SysFileTreeOption = "D"
	OTHERWISE NOP
END	/*Ends "SELECT" Section*/
return

/* ##256_1065.0 */
256_1065.0: /* Event No NO, Clicked/selected */
Arg window self



YesRecursiveFlag = ""
NoRecursiveFlag = ""
FileNameSearchFlag = ""
DirectorySearchFlag = ""

/* Get button state YES Radio Button */
YesRecursiveFlag = VpIsSelected(window,'YES')
/* Get button state NO Radio Button */
NoRecursiveFlag = VpIsSelected(window,'NO')
/* Get button state FILENAMESEARCH Radio Button */
FileNameSearchFlag = VpIsSelected(window,'FILENAMESEARCH')
/* Get button state DIRECTORYNAMESEARCH Radio Button */
DirectorySearchFlag = VpIsSelected(window,'DIRECTORYNAMESEARCH')

SELECT
	WHEN YesRecursiveFlag = 1 & FileNameSearchFlag = 1 THEN SysFileTreeOption = "FS"
	WHEN YesRecursiveFlag = 1 & DirectorySearchFlag = 1 THEN SysFileTreeOption = "DS"
	WHEN NoRecursiveFlag = 1 & FileNameSearchFlag = 1 THEN SysFileTreeOption = "F"
	WHEN NoRecursiveFlag = 1 & DirectorySearchFlag = 1 THEN SysFileTreeOption = "D"
	OTHERWISE NOP
END	/*Ends "SELECT" Section*/
return

/* ##256_Form.1 */
256_Form.1: /* Event Form events, Opened */
Arg window



OPENMAINDIALOG:
SortFlag = 0	/*Flag used to bypass some of the code in the SORT called procedure, if appropriate*/
DateSortAscendingFlag = 0
DateSortDescendingFlag = 0
TimeSortAscendingFlag = 0
TimeSortDescendingFlag = 0
SizeSortAscendingFlag = 0
SizeSortDescendingFlag = 0
FilePathSortAscendingFlag = 0
FilePathSortDescendingFlag = 0
FileNameSortAscendingFlag = 0
FileNameSortDescendingFlag = 0
Launch_Unlock = 0
SelectType = "Single"
Canceled_LockoutFlag = 0



IF ListType = "Files" THEN SIGNAL OPENDIALOG
/*Begin registering the REXX Utility functions*/
REXXUtilityFlag = RXFUNCQUERY("SYSLOADFUNCS")
IF REXXUtilityFlag \= 0 THEN DO
	CALL RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
	CALL SysLoadFuncs
END	/*Ends "IF REXXUtilityFlag \= 0 THEN DO" Section*/
/*End registering the REXX Utility functions*/



MaxDriveNumber = 26
/*Begin finding the File Spec information on this program, RUN.EXE, and assigning its value to the value, ProgramLocation, here in this program*/
BootDrive = SysBootDrive()
PARSE SOURCE OperatingSystem HowCalled FileSpec
ProgramLocation = ""
FileSpecPortion = FileSpec
DO UNTIL FileSpecPortion = ""
	PARSE Var FileSpecPortion FirstPart "\" SecondPart
	SELECT
		WHEN ProgramLocation = "" & SecondPart \= "" THEN ProgramLocation = FirstPart
		WHEN ProgramLocation \= "" & SecondPart \= "" THEN ProgramLocation = ProgramLocation"\"FirstPart
		OTHERWISE NOP
	END	/*Ends "SELECT" Section*/
	FileSpecPortion = SecondPart
END	/*Ends "DO UNTIL FileSpecPortion = """ Section*/
/*End finding the File Spec information on this program, RUN.EXE, and assigning its value to the value, ProgramLocation, here in this program*/



/*Begin finding the installed, or recognized drive information*/
/*Begin reading the CONFIG.SYS file and optaining the last reserved drive letter*/
ConfigFile = BootDrive"\CONFIG.SYS"
ConfigFileLine. = ""
J = 0
DO WHILE LINES(ConfigFile)
	J = J + 1
	ConfigFileLine.J = LINEIN(ConfigFile)
END	/*Ends "DO WHILE LINES(ConfigFile)" Section*/
ConfigFileLine.0 = J
RC = LINEOUT(ConfigFile)

LastReservedDriveLetter = ""
LastReservedDriveNumber = ""
Leave_Flag = 0
DO J = 1 TO ConfigFileLine.0 BY 1
	IF TRANSLATE(LEFT(ConfigFileLine.J, 18)) = "RESERVEDRIVELETTER" THEN DO
		FirstPortion = ""
		LastReservedDriveLetter = ""
		PARSE VAR ConfigFileLine.J FirstPortion "=" LastReservedDriveLetter
		LastReservedDriveLetter = TRANSLATE(LastReservedDriveLetter)
		LastReservedDriveNumber = C2D(LastReservedDriveLetter)
		Leave_Flag = Leave_Flag + 1
	END	/*Ends "IF TRANSLATE(LEFT(ConfigFileLine.J, 18)) = "RESERVEDRIVELETTER" THEN DO" Section*/

	IF TRANSLATE(LEFT(ConfigFileLine.J, 13)) = "SET OS2_SHELL" THEN DO
		PARSE VAR ConfigFileLine.J FirstPortion "=" Command_Processor_Path
		Leave_Flag = Leave_Flag + 1
	END	/*Ends "IF TRANSLATE(LEFT(ConfigFileLine.J, 13)) = "SET OS2_SHELL" THEN DO" Section*/
	IF Leave_Flag = 2 THEN LEAVE J
END J	/*Ends "DO J = 1 TO ConfigFileLine.0 BY 1" Section*/
/*End reading the CONFIG.SYS file and optaining the last reserved drive letter*/


DDrive. = ""
FFileSystem. = ""
Map = SYSDRIVEMAP(, "USED")
J = 0
DO UNTIL Map = ""
	J = J + 1
	PARSE VAR Map First Remainder
	DDrive.J = First
	TestDriveNumber = C2D(TRANSLATE(LEFT(DDrive.J, 1)))
	Map = Remainder
	FileSystem = TRANSLATE(SYSFILESYSTEMTYPE(DDrive.J))
	SELECT
		WHEN FileSystem = "FAT" | FileSystem = "HPFS" | FileSystem = "JFS" | FileSystem = "NTFS" | FileSystem = "CDFS" | FileSystem = "UDF" | FileSystem = "CDWFS" THEN FFileSystem.J = FileSystem
		WHEN DATATYPE(LastReservedDriveNumber) = "NUM" & TestDriveNumber > LastReservedDriveNumber THEN FFileSystem.J = "CDFS"
		OTHERWISE FFileSystem.J = ""
	END	/*Ends "SELECT" Section*/
END	/*Ends "DO UNTIL Map = """ Section*/
DDrive.0 = J
/*End finding the installed, or recognized drive information*/




/*Begin reading the setup options for SEEK*/
Message. = .DTTOOLS~STEM_INIT("")
Setup. = .DTTOOLS~STEM_INIT("")
RC = .DTTOOLS~GET_SETUP(ProgramLocation"\SETUP\", Command_Processor_Path, Setup., Message.)
IF RC = 1 THEN SIGNAL ERRORMESSAGE
IF Setup.Application.WP.NName.0 > 0 THEN Launch_Unlock = Launch_Unlock + 1
IF Setup.Application.N_ED.NName.0  > 0 THEN Launch_Unlock = Launch_Unlock + 1
IF Setup.Application.R_ED.NName.0 > 0 THEN Launch_Unlock = Launch_Unlock + 1
IF Setup.Application.L_ED.NName.0 > 0 THEN Launch_Unlock = Launch_Unlock + 1
IF Setup.Application.R_R.NName.0 > 0 THEN Launch_Unlock = Launch_Unlock + 1
IF Setup.Application.SS.NName.0 > 0 THEN Launch_Unlock = Launch_Unlock + 1
IF Setup.Application.FIN.NName.0 > 0 THEN Launch_Unlock = Launch_Unlock + 1
IF Setup.Application.WB.NName.0 > 0 THEN Launch_Unlock = Launch_Unlock + 1
IF Setup.Application.PDF.NName.0 > 0 THEN Launch_Unlock = Launch_Unlock + 1
IF Setup.Application.PS.NName.0 > 0 THEN Launch_Unlock = Launch_Unlock + 1
IF Setup.Application.Graphics.NName.0 > 0 THEN Launch_Unlock = Launch_Unlock + 1
IF Setup.Application.Drafting.NName.0 > 0 THEN Launch_Unlock = Launch_Unlock + 1
IF Setup.Application.User_Defined.NName.0 > 0 THEN Launch_Unlock = Launch_Unlock + 1
/*End reading the setup options for SEEK*/



/*Begin registering the REXX Library functions, if Setup.Use_REXXLIB = "YES"*/
IF Setup.Use_REXXLIB = "YES" THEN DO
	REXXLibraryFlag = RXFUNCQUERY("REXXLIBREGISTER")
	IF REXXLibraryFlag \= 0 THEN DO
		CALL RXFUNCADD "REXXLIBREGISTER", "REXXLIB", "REXXLIBREGISTER"
		CALL REXXLIBREGISTER
	END	/*Ends "IF REXXLibraryFlag \= 0 THEN DO" Section*/
END	/*Ends "IF Setup.Use_REXXLIB = "YES" THEN DO" Section*/
/*End registering the REXX Library functions, if Setup.Use_REXXLIB = "YES"*/



/*Begin registering the REXXEA functions, if Setup.Use_REXXEA = "YES"*/
IF Setup.Use_REXXEA = "YES" THEN DO
	REXXEAFlag = RXFUNCQUERY("REXXEAREGISTER")
	IF REXXEAFlag \= 0 THEN DO
		CALL RxFuncAdd "FetchEA", "RexxEA", "FetchEA"
		CALL FetchEA
	END	/*Ends "IF REXXEAFlag \= 0 THEN DO" Section*/
END	/*Ends "IF Setup.Use_REXXEA = "YES" THEN DO" Section*/
/*End registering the REXXEA functions, if Setup.Use_REXXEA = "YES"*/



CONTINUEOPENMAINDIALOG:
ListType = "Directories"
/*Begin checking the SelectOneRadioButton and unchecking the SelectMultipleRadioButton*/
/* Check the item  SELECTONERADIOBUTTON Radio Button */
CALL VpSelect window,'SELECTONERADIOBUTTON',1
SelectOneFlag = 1
/* Uncheck the item SELECTMULTIPLERADIOBUTTON Radio Button */
CALL VpSelect window,'SELECTMULTIPLERADIOBUTTON',0
SelectMultipleFlag = 0
/*End checking the SelectOneRadioButton and unchecking the SelectMultipleRadioButton*/



/*Begin disabling, hiding and unchecking the drive checkboxes*/
DO I = 1 TO MaxDriveNumber BY 1
	SubjectDrive = "DRIVE"I"CHECKBOX"
	/* Disable item SubjectDrive Check Box */
	CALL VpItem window,SubjectDrive,'DISABLE'
	/* Hide item SubjectDrive Check Box */
	CALL VpItem window,SubjectDrive,'HIDE'
	/* Uncheck the item SubjectDrive Check Box */
	CALL VpSelect window,SubjectDrive,0
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
/*End disabling, hiding and unchecking the drive checkboxes*/



/*Begin enabling and showing the drive radio buttons and unchecking them*/
DO I = 1  TO MaxDriveNumber BY 1
	SubjectDrive = "DRIVE"I"RADIOBUTTON"
	Apos_Character = '"'
	SELECT
		WHEN I = 1 THEN DO
			SSubjectDrive = "A:"
			Drive1 = "A:"
			Drive1Message = "You have selected the A:\*.* drive. Please verify that a diskette is in the drive bay before continuing. Press "Apos_Character"OK"Apos_Character" to continue with this selection. Press "Apos_Character"Cancel"Apos_Character" to discontinue."
		END	/*Ends "WHEN I = 1 THEN DO" Section*/

		OTHERWISE DO
			J = I - 1
			AssignVariable = "Drive"I" = DDrive.J"
			INTERPRET(AssignVariable)
			SSubjectDrive = DDrive.J
			SELECT
				WHEN FFileSystem.J = "HPFS" | FFileSystem.J = "JFS" | FFileSystem.J = "FAT" | FFileSystem.J = "NTFS" THEN DO
					AssignVariable = 'Drive'I'Message = ""'
					INTERPRET(AssignVariable)
				END	/*Ends "WHEN FFileSystem.J = "HPFS" | FFileSystem.J = "JFS" | FFileSystem.J = "FAT" | FFileSystem.J = "NTFS" THEN DO" Section*/

				WHEN FFileSystem.J = "CDFS" | FFileSystem.J = "UDF" | FFileSystem.J = "CDWFS" THEN DO
					AssignVariable = "Drive"I"Message = 'You have selected the "DDrive.J"\*.* drive. Please verify that a CD is in the drive bay before continuing. Press "Apos_Character"OK"Apos_Character" to continue with this selection. Press "Apos_Character"Cancel"Apos_Character" to discontinue.'"
					INTERPRET(AssignVariable)
				END	/*Ends "WHEN FFileSystem.J = "CDFS" | FFileSystem.J = "UDF" | FFileSystem.J = "CDWFS" THEN DO" Section*/

				WHEN FFileSystem.J = "" THEN DO
					AssignVariable = "Drive"I"Message = 'You have selected the "DDrive.J"\*.* drive. It has an unknown filesystem. Please verify that the drive is ready to go before continuing. Press "Apos_Character"OK"Apos_Character" to continue with this selection. Press "Apos_Character"Cancel"Apos_Character" to discontinue.'"
					INTERPRET(AssignVariable)
				END	/*Ends "WHEN FFileSystem.J = "" THEN DO" Section*/

				OTHERWISE NOP
			END	/*Ends "SELECT" Section*/
		END	/*Ends "OTHERWISE DO" Section*/
	END	/*Ends "SELECT" Section*/
	IF SSubjectDrive \= "" THEN DO
		/* Enable item SubjectDrive Radio Button */
		CALL VpItem window,SubjectDrive,'ENABLE'
		/* Show item SubjectDrive Radio Button */
		CALL VpItem window,SubjectDrive,'SHOW'
		/* Uncheck the item SubjectDrive Radio Button */
		CALL VpSelect window,SubjectDrive,0
		/* Set item value SubjectDrive Radio Button */
		CALL VpSetItemValue window,SubjectDrive,SSubjectDrive
	END	/*Ends "IF SSubjectDrive \= "" THEN DO" Section*/

	ELSE DO
		/* Disable item SubjectDrive Radio Button */
		CALL VpItem window,SubjectDrive,'DISABLE'
		/* Hide item SubjectDrive Radio Button */
		CALL VpItem window,SubjectDrive,'HIDE'
		/* Uncheck the item SubjectDrive Radio Button */
		CALL VpSelect window,SubjectDrive,0
	END	/*Ends "ELSE DO" Section*/
END I	/*Ends "IF SSSubjectDrive \= "" THEN DO" Section*/
/*End enabling and showing the drive radio buttons and unchecking them*/



/*Begin setting the x-size of the DRIVESSELECTIONGROUP Group Box*/
NumberOfDrives = DDrive.0 + 1
/* Get item size DRIVESSELECTIONGROUP Group Box */
/* Get item position DRIVESSELECTIONGROUP Group Box */
xy=VpItem(window,'DRIVESSELECTIONGROUP','ITEMPOS')
PARSE VAR xy x y
Box_xPosition = x
Box_yPosition = y
xy=VpItem(window,'DRIVESSELECTIONGROUP','ITEMSIZE')
PARSE VAR xy x y
Box_xSize = x
Box_ySize = y
IF Another = "" THEN DO
	SELECT
		WHEN NumberOfDrives < 13 THEN Box_xxSize = Box_xSize*NumberOfDrives/13
		OTHERWISE Box_xxSize = Box_xSize
	END	/*Ends "SELECT" Section*/
END	/*Ends "IF Another = "" THEN DO" Section*/
/* Set item position/size DRIVESSELECTIONGROUP Group Box */
CALL VpItem window,'DRIVESSELECTIONGROUP','SETITEMPOS',Box_xPosition,Box_yPosition,Box_xxSize,Box_ySize
/*End setting the x-size of the DRIVESSELECTIONGROUP Group Box*/



/*Begin setting the DRIVESSELECTLABEL label text*/
IF Another = "" THEN DO
	/* Get item position DRIVESSELECTIONLABEL Text */
	xy=VpItem(window,'DRIVESSELECTIONLABEL','ITEMPOS')
	PARSE VAR xy x y
	Label_xPosition = x
	Label_yPosition = y
	/* Get item size DRIVESSELECTIONLABEL Text */
	xy=VpItem(window,'DRIVESSELECTIONLABEL','ITEMSIZE')
	PARSE VAR xy x y
	Label_xSize = x
	Label_xSize1 = 0.64*Label_xSize
	Label_ySize = y
END	/*Ends "IF Another = "" THEN DO" Section*/
Drives_Selection_Label = "Select one drive:"
/* Set item value DRIVESSELECTIONLABEL Text */
CALL VpSetItemValue window,'DRIVESSELECTIONLABEL',Drives_Selection_Label
/* Set item position/size DRIVESSELECTIONLABEL Text */
CALL VpItem window,'DRIVESSELECTIONLABEL','SETITEMPOS',Label_xPosition,Label_yPosition,Label_xsize1,Label_ysize
/*End setting the DRIVESSELECTLABEL label text*/



/*Begin checking the FILENAMESEARCH radio button and unchecking the DIRECTORYNAMESEARCH radio button*/
/* Uncheck the item DIRECTORYNAMESEARCH Radio Button */
CALL VpSelect window,'DIRECTORYNAMESEARCH',0
/* Check the item  FILENAMESEARCH Radio Button */
CALL VpSelect window,'FILENAMESEARCH',1
/*End checking the FILENAMESEARCH radio button and unchecking the DIRECTORYNAMESEARCH radio button*/



/*Begin checking the YES (recursive directory search) radio button and unchecking the NO radio button*/
/* Check the item  YES Radio Button */
CALL VpSelect window,'YES',1
/* Uncheck the item NO Radio Button */
CALL VpSelect window,'NO',0
SysFileTreeOption = "FS"
/*End checking the YES (recursive directory search) radio button and unchecking the NO radio button*/



/*Begin setting the text for the SEARCHSTRINGLABEL Label*/
SearchStringLabelText = "Enter the search string for the desired file, or files:"
/* Set item value SEARCHSTRINGLABEL Text */
CALL VpSetItemValue window,'SEARCHSTRINGLABEL',SearchStringLabelText
/*Begin setting the text for the SEARCHSTRINGLABEL Label*/



/*Begin unchecking the PRESORT Radio Button*/
/* Uncheck the item PRESORT Radio Button */
CALL VpSelect window,'PRESORT',0
/*End unchecking the PRESORT Radio Button*/



/*Begin disabling the CONTINUE push button and giving the FILENAME entry field the focus*/
/* Set item value CONTINUE Push Button */
CALL VpSetItemValue window,'CONTINUE',"Continue"
/* Disable item CONTINUE Push Button */
CALL VpItem window,'CONTINUE','DISABLE'
/* Set item value FILENAME Entry Field */
CALL VpSetItemValue window,'FILENAME',""
/* Give item focus FILENAME Entry Field */
CALL VpItem window,'FILENAME','FOCUS'
/*End disabling the CONTINUE push button and giving the FILENAME entry field the focus*/



/* Disable item MESSAGELISTBOX List Box */
CALL VpItem window,'MESSAGELISTBOX','DISABLE'
/* Hide item MESSAGELISTBOX List Box */
CALL VpItem window,'MESSAGELISTBOX','HIDE'



ENDOFOPENMAINDIALOG:
SecondDialog = "NO"
SubdirectoryListFormID = ""
SecondaryMessage = ""
Another = ""
CancelPresort = ""
SIGNAL ENDMAINFORM



ERRORMESSAGE:
/*Begin setting up the "Main" form to display a message, when there is an error*/
/* Disable item SELECTONERADIOBUTTON Radio Button */
CALL VpItem window,'SELECTONERADIOBUTTON','DISABLE'
/* Hide item SELECTONERADIOBUTTON Radio Button */
CALL VpItem window,'SELECTONERADIOBUTTON','HIDE'
/* Disable item SELECTMULTIPLERADIOBUTTON Radio Button */
CALL VpItem window,'SELECTMULTIPLERADIOBUTTON','DISABLE'
/* Hide item SELECTMULTIPLERADIOBUTTON Radio Button */
CALL VpItem window,'SELECTMULTIPLERADIOBUTTON','HIDE'

/* Disable item ONEORMOREGROUPBOX Group Box */
CALL VpItem window,'ONEORMOREGROUPBOX','DISABLE'
/* Hide item ONEORMOREGROUPBOX Group Box */
CALL VpItem window,'ONEORMOREGROUPBOX','HIDE'

/* Disable item DRIVESSELECTIONGROUP Group Box */
CALL VpItem window,'DRIVESSELECTIONGROUP','DISABLE'
/* Hide item DRIVESSELECTIONGROUP Group Box */
CALL VpItem window,'DRIVESSELECTIONGROUP','HIDE'

/* Uncheck the item SELECTONERADIOBUTTON Radio Button */
CALL VpSelect window,'SELECTONERADIOBUTTON',0
DO I = 1  TO MaxDriveNumber BY 1
	SubjectDrive = "DRIVE"I"RADIOBUTTON"
	/*Begin disabling and hiding the drive radio buttons and unchecking them*/
	/* Disable item SubjectDrive Radio Button */
	CALL VpItem window,SubjectDrive,'DISABLE'
	/* Hide item SubjectDrive Radio Button */
	CALL VpItem window,SubjectDrive,'HIDE'
	/* Uncheck the item SubjectDrive Radio Button */
	CALL VpSelect window,SubjectDrive,0
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
/* Uncheck the item SELECTMULTIPLERADIOBUTTON Radio Button */
CALL VpSelect window,'SELECTMULTIPLERADIOBUTTON',0
DO I = 1 TO MaxDriveNumber BY 1
	SubjectDrive = "DRIVE"I"CHECKBOX"
	/* Disable item SubjectDrive Check Box */
	CALL VpItem window,SubjectDrive,'DISABLE'
	/* Hide itemSubjectDrive Check Box */
	CALL VpItem window,SubjectDrive,'HIDE'
	/* Uncheck the item SubjectDrive Check Box */
	CALL VpSelect window,SubjectDrive,0
END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/

/* Disable item SEARCHTYPEGROUP Group Box */
CALL VpItem window,'SEARCHTYPEGROUP','DISABLE'
/* Hide item SEARCHTYPEGROUP Group Box */
CALL VpItem window,'SEARCHTYPEGROUP','HIDE'
/* Disable item FILENAMESEARCH Radio Button */
CALL VpItem window,'FILENAMESEARCH','DISABLE'
/* Hide item FILENAMESEARCH Radio Button */
CALL VpItem window,'FILENAMESEARCH','HIDE'
/* Disable item DIRECTORYNAMESEARCH Radio Button */
CALL VpItem window,'DIRECTORYNAMESEARCH','DISABLE'
/* Hide item DIRECTORYNAMESEARCH Radio Button */
CALL VpItem window,'DIRECTORYNAMESEARCH','HIDE'

/* Disable item RECURSIVESEARCHGROUP Group Box */
CALL VpItem window,'RECURSIVESEARCHGROUP','DISABLE'
/* Hide item RECURSIVESEARCHGROUP Group Box */
CALL VpItem window,'RECURSIVESEARCHGROUP','HIDE'
/* Disable item YES Radio Button */
CALL VpItem window,'YES','DISABLE'
/* Hide item YES Radio Button */
CALL VpItem window,'YES','HIDE'
/* Disable item NO Radio Button */
CALL VpItem window,'NO','DISABLE'
/* Hide item NO Radio Button */
CALL VpItem window,'NO','HIDE'

/* Disable item FILENAME Entry Field */
CALL VpItem window,'FILENAME','DISABLE'
/* Hide item FILENAME Entry Field */
CALL VpItem window,'FILENAME','HIDE'

/* Disable item PRESORT Radio Button */
CALL VpItem window,'PRESORT','DISABLE'
/* Hide item PRESORT Radio Button */
CALL VpItem window,'PRESORT','HIDE'

/* Disable item CONTINUE Push Button */
CALL VpItem window,'CONTINUE','DISABLE'
/* Hide item CONTINUE Push Button */
CALL VpItem window,'CONTINUE','HIDE'

DO I = 1 TO Message.[0] BY 1
	/* Add item to end MESSAGELISTBOX List Box */
	Index = VpAddItem(window, 'MESSAGELISTBOX', 'END', Message.[I])
END I	/*Ends "DO I = 1 TO Message.[0] BY 1" Section*/
/*End setting up the "Main" form to display a message, when there is an error*/



ENDMAINFORM:
return

/* ##256_Form.4 */
256_Form.4: /* Event Form events, Secondary Notify */
Arg window SecondaryMessage



SELECT
	WHEN SecondaryMessage = "CANCELLED" | SecondaryMessage = "END PROGRAM" THEN DO
		/*Begin deregistering the REXX Utility, REXX Library and REXXEA functions*/
		IF REXXUtilityFlag \= 0 THEN CALL SysDropFuncs
		IF Setup.Use_REXXLIB = "YES" & REXXLibraryFlag \= 0 THEN CALL REXXLIBDEREGISTER
		IF Setup.Use_REXXEA = "YES" & REXXEAFlag \= 0 THEN RC = RxFuncDrop(FetchEA)
		/*End deregistering the REXX Utility, REXX Library and REXXEA functions*/
		CALL VpWindow window,'CLOSE'
END	/*Ends "WHEN SecondaryMessage = "CANCELLED" | SecondaryMessage = "END PROGRAM" THEN DO" Section*/

	WHEN SecondaryMessage = "ANOTHER" THEN DO
		CALL VpWindow window,'ACTIVATE'
		SIGNAL CONTINUEOPENMAINDIALOG
	END	/*Ends "WHEN SecondaryMessage = "ANOTHER" THEN DO" Section*/

	WHEN SecondaryMessage = "CANCELPRESORT" THEN DO
		/* Uncheck the item PRESORT Radio Button */
		CALL VpSelect window,'PRESORT',0
		PerformPreSortFlag = 0
		SIGNAL ENDOFOPENMAINDIALOG
	END	/*Ends "WHEN SecondaryMessage = "CANCELPRESORT" THEN DO" Section*/

	WHEN SecondaryMessage = "CONTINUEPRESORT" THEN DO
		PerformPreSortFlag = 1
		SIGNAL ENDOFOPENMAINDIALOG
	END	/*Ends "WHEN SecondaryMessage = "CONTINUEPRESORT" THEN DO" Section*/


	OTHERWISE NOP
END	/*Ends "SELECT" Section*/
return

/* ##258_1000.0 */
258_1000.0: /* Event Launch the file(s) LAUNCHFILESRADIOBUTTON, Clicked/selected */
Arg window self



/* Get button state LAUNCHFILESRADIOBUTTON Radio Button */
LaunchFlag = VpIsSelected(window,'LAUNCHFILESRADIOBUTTON')
IF LaunchFlag = 1 THEN
/* Open the form Drive2"OS2\APPS\Seek\SubdirectoryList" */
LaunchFormID = VpOpenForm(window, 261, 'topic name')
return

/* ##258_1001.0 */
258_1001.0: /* Event Search for a text string in the  SEARCHFORSTRINGRADIOBUTTON, Clicked/selected */
Arg window self



/* Get button state SEARCHFORSTRINGRADIOBUTTON Radio Button */
TextSearchFlag = VpIsSelected(window,'SEARCHFORSTRINGRADIOBUTTON')
/* Get item value SEARCHSTRING Entry Field */
SearchString = VpGetItemValue(window,'SEARCHSTRING')



/*Begin configuring the dialogs after clicking the SEARCHFORSTRINGRADIOBUTTON radio button*/
SELECT
	WHEN TextSearchFlag = 1 & SearchString \= "" THEN DO
		/* Uncheck the item SEARCHFORSTRINGRADIOBUTTON Radio Button */
		CALL VpSelect window,'SEARCHFORSTRINGRADIOBUTTON',0
		SelectedOtherServices = "SCANTEXT"
		/* Open the form C:\OS2\APPS\Seek\ScanText */
		value=VpOpenForm(window, 259, 'topic name')
	END	/*Ends "WHEN TextSearchFlag = 1 & SearchString \= "" THEN DO" Section*/

	WHEN TextSearchFlag = 1 & SearchString = "" THEN DO
		/* Uncheck the item SEARCHFORSTRINGRADIOBUTTON Radio Button */
		CALL VpSelect window,'SEARCHFORSTRINGRADIOBUTTON',0
		Text = "Enter the search text string, first"
		/* Set item value SEARCHFORSTRINGRADIOBUTTON Radio Button */
		CALL VpSetItemValue window,'SEARCHFORSTRINGRADIOBUTTON',Text
		CALL SysSleep 3
		Text = "Search for a text string in the file(s)"
		/* Set item value SEARCHFORSTRINGRADIOBUTTON Radio Button */
		CALL VpSetItemValue window,'SEARCHFORSTRINGRADIOBUTTON',Text
		/* Give item focus SEARCHSTRING Entry Field */
		CALL VpItem window,'SEARCHSTRING','FOCUS'		
	END	/*Ends "WHEN TextSearchFlag = 1 & SearchString = "" THEN DO" Section*/

	OTHERWISE NOP
END
/*End configuring the dialogs after clicking the SEARCHFORSTRINGRADIOBUTTON radio button*/
return

/* ##258_1003.0 */
258_1003.0: /* Event Get the file(s) extended attribu EXTENDEDATTRIBUTERADIOBUTTON, Clicked/selected */
Arg window self



/* Get button state EXTENDEDATTRIBUTERADIOBUTTON Radio Button */
EASearchFlag = VpIsSelected(window,'EXTENDEDATTRIBUTERADIOBUTTON')



/*Begin configuring the dialogs after clicking the EXTENDEDATTRIBUTERADIOBUTTON radio button*/
SELECT
	WHEN EASearchFlag = 1 THEN DO
		/* Uncheck the item EXTENDEDATTRIBUTERADIOBUTTON Radio Button */
		CALL VpSelect window,'EXTENDEDATTRIBUTERADIOBUTTON',0
		SelectedOtherServices = "SCANEA"
		/* Open the form C:\OS2\APPS\Seek\ScanText */
		value=VpOpenForm(window, 259, 'topic name')
	END	/*Ends "WHEN EASearchFlag = 1 THEN DO" Section*/

	OTHERWISE NOP
END
/*End configuring the dialogs after clicking the EXTENDEDATTRIBUTERADIOBUTTON radio button*/
return

/* ##258_1005.0 */
258_1005.0: /* Event Cancel other services CANCELOTHERSERVICES, Clicked/selected */
Arg window self



/* Get button state CANCELOTHERSERVICES Radio Button */
CancelServicesFlag = VpIsSelected(window,'CANCELOTHERSERVICES')
IF CancelServicesFlag = 1 THEN DO
	Cancel = "CANCELSERVICES"
	CALL VpNotify window,Cancel
	CALL VpWindow window,'CLOSE'
	/* Uncheck the item CANCELOTHERSERVICES Radio Button */
	CALL VpSelect window,'CANCELOTHERSERVICES',0	
END	/*Ends "IF CancelServicesFlag = 1 THEN DO" Section*/
return

/* ##258_1008.0 */
258_1008.0: /* Event End Program ENDPROGRAM, Clicked/selected */
Arg window self



EndProgram = "END PROGRAM"
CALL VpNotify window,EndProgram
CALL VpWindow window,'CLOSE'
return

/* ##258_1009.0 */
258_1009.0: /* Event Do Another DOANOTHER, Clicked/selected */
Arg window self



Another = "ANOTHER"
CALL VpNotify window,Another
CALL VpWindow window,'CLOSE'
return

/* ##258_1010.0 */
258_1010.0: /* Event  COPYTOCLIPBOARDRADIOBUTTON, Clicked/selected */
Arg window self



/* Get button state COPYTOCLIPBOARDRADIOBUTTON Radio Button */
StateFlag = VpIsSelected(window,'COPYTOCLIPBOARDRADIOBUTTON')
IF StateFlag = 1 & OtherServicesFileDirectory.0 > 0 THEN DO
SELECT
	WHEN OtherServicesFileDirectory.0 = 1 THEN DO
		Clipboard = OtherServicesFileDirectory.1
		CALL VpWindow window,'SETCLIPBOARD','TEXT',Clipboard
	END	/*Ends "WHEN OtherServicesFileDirectory.0 = 1 THEN DO" Section*/

	WHEN OtherServicesFileDirectory.0 > 1 THEN DO
		NewLineCount = 1
		NewLine = CHARIN(ProgramLocation"\SubProcs\ADDLINE",,NewLineCount)
		RC = LINEOUT(ProgramLocation"\SubProcs\ADDLINE")
		Clipboard = ""
		End = OtherServicesFileDirectory.0 - 1
		DO J = 1 TO End BY 1
			Clipboard = Clipboard||OtherServicesFileDirectory.J||NewLine
		END J	/*Ends "DO J = 1 TO End BY 1" Section*/
		Clipboard = Clipboard||OtherServicesFileDirectory.J
		CALL VpWindow window,'SETCLIPBOARD','TEXT',Clipboard
	END	/*Ends "WHEN OtherServicesFileDirectory.0 > 1 THEN DO" Section*/

	OTHERWISE NOP
END	/*Ends "SELECT" Section*/


SELECT
	WHEN SysFileTreeOption = "FS" | SysFileTreeOption = "F" THEN DO
		CopyToClipBoardRadioButtonText = "The selected file tree data has been copied to the clipboard"
		/* Set item value COPYTOCLIPBOARDRADIOBUTTON Radio Button */
		CALL VpSetItemValue window,'COPYTOCLIPBOARDRADIOBUTTON',CopyToClipBoardRadioButtonText
		RC = .Timing~Delay(2.0)
		CopyToClipBoardRadioButtonText = "Copy the selected file tree data to the clipboard"
		/* Set item value COPYTOCLIPBOARDRADIOBUTTON Radio Button */
		CALL VpSetItemValue window,'COPYTOCLIPBOARDRADIOBUTTON',CopyToClipBoardRadioButtonText
	END	/*Ends "WHEN SysFileTreeOption = "FS" | SysFileTreeOption = "F" THEN DO" Section*/

	WHEN SysFileTreeOption = "DS" | SysFileTreeOption = "D" THEN DO
		CopyToClipBoardRadioButtonText = "The selected directory tree data has been copied to the clipboard"
		/* Set item value COPYTOCLIPBOARDRADIOBUTTON Radio Button */
		CALL VpSetItemValue window,'COPYTOCLIPBOARDRADIOBUTTON',CopyToClipBoardRadioButtonText
		RC = .Timing~Delay(2.0)
		CopyToClipBoardRadioButtonText = "Copy the selected directory tree data to the clipboard"
		/* Set item value COPYTOCLIPBOARDRADIOBUTTON Radio Button */
		CALL VpSetItemValue window,'COPYTOCLIPBOARDRADIOBUTTON',CopyToClipBoardRadioButtonText
	END	/*Ends "WHEN SysFileTreeOption = "DS" | SysFileTreeOption = "D" THEN DO" Section*/

	OTHERWISE NOP
END	/*Ends "SELECT" Section*/

/* Uncheck the item COPYTOCLIPBOARDRADIOBUTTON Radio Button */
CALL VpSelect window,'COPYTOCLIPBOARDRADIOBUTTON',0
END	/*Ends "IF StateFlag = 1 & OtherServicesFileDirectory.0 > 0 THEN DO" Section*/
return

/* ##258_1011.0 */
258_1011.0: /* Event Compare two (2) text files COMPARETEXTFILES, Clicked/selected */
Arg window self



/* Get button state COMPARETEXTFILESRADIOBUTTON Radio Button */
FileCompareFlag = VpIsSelected(window,'COMPARETEXTFILESRADIOBUTTON')



/*Begin configuring the dialogs after clicking the COMPARETEXTFILESRADIOBUTTON radio button*/
SELECT
	WHEN FileCompareFlag = 1 THEN DO
		/* Uncheck the item COMPARETEXTFILESRADIOBUTTON Radio Button */
		CALL VpSelect window,'COMPARETEXTFILESRADIOBUTTON',0
		SelectedOtherServices = "COMPAREFILES"
		/* Open the form C:\OS2\APPS\Seek\ScanText */
		value=VpOpenForm(window, 259, 'topic name')
	END	/*Ends "WHEN TFileCompareFlag = 1 THEN DO" Section*/

	OTHERWISE NOP
END
/*End configuring the dialogs after clicking the COMPARETEXTFILESRADIOBUTTON radio button*/
return

/* ##258_Form.1 */
258_Form.1: /* Event Form events, Opened */
Arg window 



OPENOTHERSERVICESDIALOG:
/* Uncheck the item LAUNCHFILESRADIOBUTTON Radio Button */
CALL VpSelect window,'LAUNCHFILESRADIOBUTTON',0
/* Uncheck the item LAUNCHFILESRADIOBUTTON Radio Button */
CALL VpSelect window,'LAUNCHFILESRADIOBUTTON',0
/* Uncheck the item SEARCHFORSTRINGRADIOBUTTON Radio Button */
CALL VpSelect window,'SEARCHFORSTRINGRADIOBUTTON',0
/* Uncheck the item PRINTFILESRADIOBUTTON Radio Button */
CALL VpSelect window,'PRINTFILESRADIOBUTTON',0
/* Uncheck the item EXTENDEDATTRIBUTERADIOBUTTON Radio Button */
CALL VpSelect window,'EXTENDEDATTRIBUTERADIOBUTTON',0
/* Uncheck the item COMPARETEXTFILESRADIOBUTTON Radio Button */
CALL VpSelect window,'COMPARETEXTFILESRADIOBUTTON',0
/* Uncheck the item COPYTOCLIPBOARDRADIOBUTTON Radio Button */
CALL VpSelect window,'COPYTOCLIPBOARDRADIOBUTTON',0
/* Uncheck the item CANCELOTHERSERVICES Radio Button */
CALL VpSelect window,'CANCELOTHERSERVICES',0
/* Give item focus SEARCHSTRING Entry Field */
CALL VpItem window,'SEARCHSTRING','FOCUS'
SelectedOtherServices = ""
SELECT
	WHEN SysFileTreeOption = "FS" | SysFileTreeOption = "F" THEN DO
		SELECT
			WHEN Launch_Unlock > 0 THEN DO
				/* Disable item LAUNCHMESSAGE Text */
				CALL VpItem window,'LAUNCHMESSAGE','DISABLE'
				/* Hide item LAUNCHMESSAGE Text */
				CALL VpItem window,'LAUNCHMESSAGE','HIDE'
				/* Enable item LAUNCHFILESRADIOBUTTON Radio Button */
				CALL VpItem window,'LAUNCHFILESRADIOBUTTON','ENABLE'
				/* Show item LAUNCHFILESRADIOBUTTON Radio Button */
				CALL VpItem window,'LAUNCHFILESRADIOBUTTON','SHOW'
			END	/*Ends "WHEN Launch_Unlock > 0 THEN DO" Section*/

			WHEN Launch_Unlock = 0 THEN DO
				/* Disable item LAUNCHFILESRADIOBUTTON Radio Button */
				CALL VpItem window,'LAUNCHFILESRADIOBUTTON','DISABLE'
				LaunchMessage = "File launch NOT operative; no file associations established in the SETUP file!"
				/* Set item value LAUNCHMESSAGE Text */
				CALL VpSetItemValue window,'LAUNCHMESSAGE',LaunchMessage
			END	/*Ends "WHEN Launch_Unlock = 0 THEN DO" Section*/

			OTHERWISE NOP
		END	/*Ends "SELECT" Section*/
		/* Enable item SEARCHFORSTRINGRADIOBUTTON Radio Button */
		CALL VpItem window,'SEARCHFORSTRINGRADIOBUTTON','ENABLE'
		/* Show item SEARCHFORSTRINGRADIOBUTTON Radio Button */
		CALL VpItem window,'SEARCHFORSTRINGRADIOBUTTON','SHOW'
		/* Enable item SEARCHSTRING Entry Field */
		CALL VpItem window,'SEARCHSTRING','ENABLE'
		/* Show item SEARCHSTRING Entry Field */
		CALL VpItem window,'SEARCHSTRING','SHOW'
		/* Enable item PRINTFILESRADIOBUTTON Radio Button */
		CALL VpItem window,'PRINTFILESRADIOBUTTON','ENABLE'
		/* Show item PRINTFILESRADIOBUTTON Radio Button */
		CALL VpItem window,'PRINTFILESRADIOBUTTON','SHOW'
		/* Enable item EXTENDEDATTRIBUTERADIOBUTTON Radio Button */
		CALL VpItem window,'EXTENDEDATTRIBUTERADIOBUTTON','ENABLE'
		/* Show item EXTENDEDATTRIBUTERADIOBUTTON Radio Button */
		CALL VpItem window,'EXTENDEDATTRIBUTERADIOBUTTON','SHOW'

		CopyToClipBoardRadioButtonText = "Copy the selected file tree data to the clipboard"
	END	/*Ends "WHEN SysFileTreeOption = "FS" | SysFileTreeOption = "F" THEN DO" Section*/

	WHEN SysFileTreeOption = "DS" | SysFileTreeOption = "D" THEN DO
		/* Disable item LAUNCHFILESRADIOBUTTON Radio Button */
		CALL VpItem window,'LAUNCHFILESRADIOBUTTON','DISABLE'
		/* Hide item LAUNCHFILESRADIOBUTTON Radio Button */
		CALL VpItem window,'LAUNCHFILESRADIOBUTTON','HIDE'
		/* Disable item SEARCHFORSTRINGRADIOBUTTON Radio Button */
		CALL VpItem window,'SEARCHFORSTRINGRADIOBUTTON','DISABLE'
		/* Hide item SEARCHFORSTRINGRADIOBUTTON Radio Button */
		CALL VpItem window,'SEARCHFORSTRINGRADIOBUTTON','HIDE'
		/* Disable item SEARCHSTRINGLABEL Text */
		CALL VpItem window,'SEARCHSTRINGLABEL','DISABLE'
		/* Hide item SEARCHSTRINGLABEL Text */
		CALL VpItem window,'SEARCHSTRINGLABEL','HIDE'
		/* Disable item SEARCHSTRING Entry Field */
		CALL VpItem window,'SEARCHSTRING','DISABLE'
		/* Hide item SEARCHSTRING Entry Field */
		CALL VpItem window,'SEARCHSTRING','HIDE'
		/* Disable item PRINTFILESRADIOBUTTON Radio Button */
		CALL VpItem window,'PRINTFILESRADIOBUTTON','DISABLE'
		/* Hide item PRINTFILESRADIOBUTTON Radio Button */
		CALL VpItem window,'PRINTFILESRADIOBUTTON','HIDE'
		/* Disable item COMPARETEXTFILESRADIOBUTTON Radio Button */
		CALL VpItem window,'COMPARETEXTFILESRADIOBUTTON','DISABLE'
		/* Hide item COMPARETEXTFILESRADIOBUTTON Radio Button */
		CALL VpItem window,'COMPARETEXTFILESRADIOBUTTON','HIDE'
		/* Enable item EXTENDEDATTRIBUTERADIOBUTTON Radio Button */
		CALL VpItem window,'EXTENDEDATTRIBUTERADIOBUTTON','ENABLE'
		/* Show item EXTENDEDATTRIBUTERADIOBUTTON Radio Button */
		CALL VpItem window,'EXTENDEDATTRIBUTERADIOBUTTON','SHOW'

		CopyToClipBoardRadioButtonText = "Copy the selected directory tree data to the clipboard"
	END	/*Ends "WHEN SysFileTreeOption = "DS" | SysFileTreeOption = "D" THEN DO" Section*/

	OTHERWISE NOP
END	/*Ends "SELECT" Section*/
SELECT
	WHEN OtherServicesFilePath.0 > 1 THEN
	/* Enable item COMPARETEXTFILESRADIOBUTTON Radio Button */
	CALL VpItem window,'COMPARETEXTFILESRADIOBUTTON','ENABLE'

	OTHERWISE
	/* Disable item COMPARETEXTFILESRADIOBUTTON Radio Button */
	CALL VpItem window,'COMPARETEXTFILESRADIOBUTTON','DISABLE'
END	/*Ends "SELECT" Section*/
/* Set item value COPYTOCLIPBOARDRADIOBUTTON Radio Button */
CALL VpSetItemValue window,'COPYTOCLIPBOARDRADIOBUTTON',CopyToClipBoardRadioButtonText
ENDOFOPENOTHERSERVICESDIALOG:
return

/* ##258_Form.4 */
258_Form.4: /* Event Form events, Secondary Notify */
Arg window message



SELECT
	WHEN Another = "ANOTHER" THEN DO
		CALL VpNotify window,Another
		CALL VpWindow window,'CLOSE'
	END	/*Ends "WHEN Another = "ANOTHER" THEN DO" Section*/

	WHEN EndProgram = "END PROGRAM" THEN DO
		CALL VpNotify window,EndProgram
		CALL VpWindow window,'CLOSE'
	END	/*Ends "WHEN EndProgram = "END PROGRAM" THEN DO" Section*/

	WHEN SecondaryMessage = "CANCELTEXTSCAN" THEN DO
		NOP
		SIGNAL ENDOFOPENOTHERSERVICESDIALOG
	END	/*Ends "WHEN SecondaryMessage = "CANCELTEXTSCAN" THEN DO" THEN DO" Section*/

	OTHERWISE NOP
END	/*Ends "SELECT" Section*/
return

/* ##260_1000.0 */
260_1000.0: /* Event  DATECHECKBOX, Clicked/selected */
Arg window self



/* Get button state DATECHECKBOX Check Box */
DateCheckBoxFlag = VpIsSelected(window,'DATECHECKBOX')
SELECT
	WHEN DateCheckBoxFlag = 1 THEN DO
		/* Set item value MINMONTH Spin Button */
		CALL VpSetItemValue window,'MINMONTH',TodayMonth
		/* Set item value MINDAY Spin Button */
		CALL VpSetItemValue window,'MINDAY',TodayDay
		/* Set item value MINYEAR Spin Button */
		CALL VpSetItemValue window,'MINYEAR',TodayYear
		/* Show item MINMONTH Spin Button */
		CALL VpItem window,'MINMONTH','SHOW'
		/* Show item MINDAY Spin Button */
		CALL VpItem window,'MINDAY','SHOW'
		/* Show item MINYEAR Spin Button */
		CALL VpItem window,'MINYEAR','SHOW'

		MinMonth = TodayMonth
		MinDay = TodayDay
		MinYear = TodayYear
		MinDate = MinYear||MinMonth||MinDay
		MinDateSerialNumber = DATE("B", MinDate, "S")

		/* Set item value MAXMONTH Spin Button */
		CALL VpSetItemValue window,'MAXMONTH',TodayMonth
		/* Set item value MAXDAY Spin Button */
		CALL VpSetItemValue window,'MAXDAY',TodayDay
		/* Set item value MAXYEAR Spin Button */
		CALL VpSetItemValue window,'MAXYEAR',TodayYear
		/* Show item MAXMONTH Spin Button */
		CALL VpItem window,'MAXMONTH','SHOW'
		/* Show item MAXDAY Spin Button */
		CALL VpItem window,'MAXDAY','SHOW'
		/* Show item MAXYEAR Spin Button */
		CALL VpItem window,'MAXYEAR','SHOW'

		MaxMonth = TodayMonth
		MaxDay = TodayDay
		MaxYear = TodayYear
		MaxDate = MaxYear||MaxMonth||MaxDay
		MaxDateSerialNumber = DATE("B", MaxDate, "S")

		/* Enable item CONTINUE Push Button */
		CALL VpItem window,'CONTINUE','ENABLE'		
	END	/*Ends "WHEN DateCheckBoxFlag = 1 THEN DO" Section*/

	WHEN DateCheckBoxFlag = 0 THEN DO
		/* Set item value MINMONTH Spin Button */
		CALL VpSetItemValue window,'MINMONTH',TodayMonth
		/* Set item value MINDAY Spin Button */
		CALL VpSetItemValue window,'MINDAY',TodayDay
		/* Set item value MINYEAR Spin Button */
		CALL VpSetItemValue window,'MINYEAR',TodayYear
		/* Hide item MINMONTH Spin Button */
		CALL VpItem window,'MINMONTH','HIDE'
		/* Hide item MINDAY Spin Button */
		CALL VpItem window,'MINDAY','HIDE'
		/* Hide item MINYEAR Spin Button */
		CALL VpItem window,'MINYEAR','HIDE'

		/* Set item value MAXMONTH Spin Button */
		CALL VpSetItemValue window,'MAXMONTH',TodayMonth
		/* Set item value MAXDAY Spin Button */
		CALL VpSetItemValue window,'MAXDAY',TodayDay
		/* Set item value MAXYEAR Spin Button */
		CALL VpSetItemValue window,'MAXYEAR',TodayYear
		/* Hide item MAXMONTH Spin Button */
		CALL VpItem window,'MAXMONTH','HIDE'
		/* Hide item MAXDAY Spin Button */
		CALL VpItem window,'MAXDAY','HIDE'
		/* Hide item MAXYEAR Spin Button */
		CALL VpItem window,'MAXYEAR','HIDE'

		/* Get button state SIZECHECKBOX Check Box */
		SizeCheckBoxFlag = VpIsSelected(window,'SIZECHECKBOX')
		/* Get button state TIMECHECKBOX Check Box */
		TimeCheckBoxFlag = VpIsSelected(window,'TIMECHECKBOX')
		/* Get button state ATTRIBUTESCHECKBOX Check Box */
		AttributesCheckBoxFlag = VpIsSelected(window,'ATTRIBUTESCHECKBOX')
		IF SizeCheckBoxFlag = 0 & TimeCheckBoxFlag = 0 & AttributesCheckBoxFlag = 0 THEN
		/* Disable item CONTINUE Push Button */
		CALL VpItem window,'CONTINUE','DISABLE'
	END	/*Ends "WHEN DateCheckBoxFlag = 0 THEN DO" Section*/

	OTHERWISE NOP
END	/*Ends "SELECT" Section*/
return

/* ##260_1001.0 */
260_1001.0: /* Event File size (BYTES) SIZECHECKBOX, Clicked/selected */
Arg window self



/* Get button state SIZECHECKBOX Check Box */
SizeCheckBoxFlag = VpIsSelected(window,'SIZECHECKBOX')
SELECT
	WHEN SizeCheckBoxFlag = 1 THEN DO
		/* Show item MINSIZE Entry Field */
		CALL VpItem window,'MINSIZE','SHOW'
		/* Show item MAXSIZE Entry Field */
		CALL VpItem window,'MAXSIZE','SHOW'
		/* Set item value MINSIZE Entry Field */
		CALL VpSetItemValue window,'MINSIZE',0
		/* Set item value MAXSIZE Entry Field */
		CALL VpSetItemValue window,'MAXSIZE',0
		MinFileSize_PresentValue = 0
		MaxFileSize_PresentValue = 0
		/* Enable item CONTINUE Push Button */
		CALL VpItem window,'CONTINUE','ENABLE'
	END	/*Ends "WHEN SizeCheckBoxFlag = 1 THEN DO" Section*/

	WHEN SizeCheckBoxFlag = 0 THEN DO
		/* Set item value MINSIZE Entry Field */
		CALL VpSetItemValue window,'MINSIZE',""
		/* Set item value MAXSIZE Entry Field */
		CALL VpSetItemValue window,'MAXSIZE',""
		/* Hide item MINSIZE Entry Field */
		CALL VpItem window,'MINSIZE','HIDE'
		/* Hide item MAXSIZE Entry Field */
		CALL VpItem window,'MAXSIZE','HIDE'
		
		/* Get button state DATECHECKBOX Check Box */
		DateCheckBoxFlag = VpIsSelected(window,'DATECHECKBOX')
		/* Get button state TIMECHECKBOX Check Box */
		TimeCheckBoxFlag = VpIsSelected(window,'TIMECHECKBOX')
		/* Get button state ATTRIBUTESCHECKBOX Check Box */
		AttributesCheckBoxFlag = VpIsSelected(window,'ATTRIBUTESCHECKBOX')
		IF DateCheckBoxFlag = 0 & TimeCheckBoxFlag = 0 & AttributesCheckBoxFlag = 0 THEN
		/* Disable item CONTINUE Push Button */
		CALL VpItem window,'CONTINUE','DISABLE'	
	END	/*Ends "WHEN SizeCheckBoxFlag = 0 THEN DO" Section*/

	OTHERWISE NOP
END	/*Ends "" Section*/
return

/* ##260_1002.0 */
260_1002.0: /* Event  TIMECHECKBOX, Clicked/selected */
Arg window self



/* Get button state TIMECHECKBOX Check Box */
TimeCheckBoxFlag = VpIsSelected(window,'TIMECHECKBOX')
SELECT
	WHEN TimeCheckBoxFlag = 1 THEN DO
		/* Show item MINHOURS Spin Button */
		CALL VpItem window,'MINHOURS','SHOW'
		/* Show item MINMINUTES Spin Button */
		CALL VpItem window,'MINMINUTES','SHOW'
		/* Show item MINSECONDS Spin Button */
		CALL VpItem window,'MINSECONDS','SHOW'
		/* Show item MAXHOURS Spin Button */
		CALL VpItem window,'MAXHOURS','SHOW'
		/* Show item MAXMINUTES Spin Button */
		CALL VpItem window,'MAXMINUTES','SHOW'
		/* Show item MAXSECONDS Spin Button */
		CALL VpItem window,'MAXSECONDS','SHOW'
		IF Setup.Presort_Time_Format = "HH MM SS AMPM" THEN DO
			/* Show item MINAMPM Spin Button */
			CALL VpItem window,'MINAMPM','SHOW'
			/* Show item MINAMPMENTRY Entry Field */
			CALL VpItem window,'MINAMPMENTRY','SHOW'
			/* Show item MAXAMPM Spin Button */
			CALL VpItem window,'MAXAMPM','SHOW'
			/* Show item MAXAMPMENTRY Entry Field */
			CALL VpItem window,'MAXAMPMENTRY','SHOW'
		END	/*Ends "" Section*/
		/* Enable item CONTINUE Push Button */
		CALL VpItem window,'CONTINUE','ENABLE'
	END	/*Ends "WHEN TimeCheckBoxFlag = 1 THEN DO" Section*/

	WHEN TimeCheckBoxFlag = 0 THEN DO
		/* Hide item MINHOURS Spin Button */
		CALL VpItem window,'MINHOURS','HIDE'
		/* Hide item MINMINUTES Spin Button */
		CALL VpItem window,'MINMINUTES','HIDE'
		/* Hide item MINSECONDS Spin Button */
		CALL VpItem window,'MINSECONDS','HIDE'
		/* Hide item MINAMPM Spin Button */
		CALL VpItem window,'MINAMPM','HIDE'
		/* Hide item MINAMPMENTRY Entry Field */
		CALL VpItem window,'MINAMPMENTRY','HIDE'
		/* Hide item MAXHOURS Spin Button */
		CALL VpItem window,'MAXHOURS','HIDE'
		/* Hide item MAXMINUTES Spin Button */
		CALL VpItem window,'MAXMINUTES','HIDE'
		/* Hide item MAXSECONDS Spin Button */
		CALL VpItem window,'MAXSECONDS','HIDE'
		/* Hide item MAXAMPM Spin Button */
		CALL VpItem window,'MAXAMPM','HIDE'
		/* Hide item MAXAMPMENTRY Entry Field */
		CALL VpItem window,'MAXAMPMENTRY','HIDE'

		/* Get button state SIZECHECKBOX Check Box */
		SizeCheckBoxFlag = VpIsSelected(window,'SIZECHECKBOX')
		/* Get button state DATECHECKBOX Check Box */
		DateCheckBoxFlag = VpIsSelected(window,'DATECHECKBOX')
		/* Get button state ATTRIBUTESCHECKBOX Check Box */
		AttributesCheckBoxFlag = VpIsSelected(window,'ATTRIBUTESCHECKBOX')
		IF SizeCheckBoxFlag = 0 & DateCheckBoxFlag = 0 & AttributesCheckBoxFlag = 0 THEN
		/* Disable item CONTINUE Push Button */
		CALL VpItem window,'CONTINUE','DISABLE'	
	END	/*Ends "WHEN TimeCheckBoxFlag = 0 THEN DO" Section*/

	OTHERWISE NOP
END	/*Ends "SELECT" Section*/
return

/* ##260_1003.0 */
260_1003.0: /* Event Attributes ATTRIBUTESCHECKBOX, Clicked/selected */
Arg window self



/* Get button state ATTRIBUTESCHECKBOX Check Box */
AttributesCheckBoxFlag = VpIsSelected(window,'ATTRIBUTESCHECKBOX')
SELECT
	WHEN AttributesCheckBoxFlag = 1 THEN DO
		AttributesMask = "-----"
		/* Show item ATTRIBUTES Entry Field */
		CALL VpItem window,'ATTRIBUTES','SHOW'
		/* Set item value ATTRIBUTES Entry Field */
		CALL VpSetItemValue window,'ATTRIBUTES',AttributesMask

		/* Show item SETARCHIVE Radio Button */
		CALL VpItem window,'SETARCHIVE','SHOW'
		/* Show item CLEARARCHIVE Radio Button */
		CALL VpItem window,'CLEARARCHIVE','SHOW'
		/* Show item SETDIRECTORY Radio Button */
		CALL VpItem window,'SETDIRECTORY','SHOW'
		/* Show item CLEARDIRECTORY Radio Button */
		CALL VpItem window,'CLEARDIRECTORY','SHOW'
		/* Show item SETHIDDEN Radio Button */
		CALL VpItem window,'SETHIDDEN','SHOW'
		/* Show item CLEARHIDDEN Radio Button */
		CALL VpItem window,'CLEARHIDDEN','SHOW'
		/* Show item SETREADONLY Radio Button */
		CALL VpItem window,'SETREADONLY','SHOW'
		/* Show item CLEARREADONLY Radio Button */
		CALL VpItem window,'CLEARREADONLY','SHOW'
		/* Show item SETSYSTEM Radio Button */
		CALL VpItem window,'SETSYSTEM','SHOW'
		/* Show item CLEARSYSTEM Radio Button */
		CALL VpItem window,'CLEARSYSTEM','SHOW'

		/* Set item value ATTRIBUTES Entry Field */
		CALL VpSetItemValue window,'ATTRIBUTES',AttributesMask
		/* Uncheck the item SETARCHIVE Radio Button */
		CALL VpSelect window,'SETARCHIVE',0
		/* Uncheck the item CLEARARCHIVE Radio Button */
		CALL VpSelect window,'CLEARARCHIVE',0
		/* Uncheck the item SETDIRECTORY Radio Button */
		CALL VpSelect window,'SETDIRECTORY',0
		/* Uncheck the item CLEARDIRECTORY Radio Button */
		CALL VpSelect window,'CLEARDIRECTORY',0
		/* Uncheck the item SETHIDDEN Radio Button */
		CALL VpSelect window,'SETHIDDEN',0
		/* Uncheck the item CLEARHIDDEN Radio Button */
		CALL VpSelect window,'CLEARHIDDEN',0
		/* Uncheck the item SETREADONLY Radio Button */
		CALL VpSelect window,'SETREADONLY',0
		/* Uncheck the item CLEARREADONLY Radio Button */
		CALL VpSelect window,'CLEARREADONLY',0
		/* Uncheck the item SETSYSTEM Radio Button */
		CALL VpSelect window,'SETSYSTEM',0
		/* Uncheck the item CLEARSYSTEM Radio Button */
		CALL VpSelect window,'CLEARSYSTEM',0
		/* Enable item CONTINUE Push Button */
		CALL VpItem window,'CONTINUE','ENABLE'
	END	/*Ends "WHEN AttributesCheckBoxFlag = 1 THEN DO" Section*/

	WHEN AttributesCheckBoxFlag = 0 THEN DO
		/* Set item value ATTRIBUTES Entry Field */
		CALL VpSetItemValue window,'ATTRIBUTES',AttributesMask
		/* Uncheck the item SETARCHIVE Radio Button */
		CALL VpSelect window,'SETARCHIVE',0
		/* Uncheck the item CLEARARCHIVE Radio Button */
		CALL VpSelect window,'CLEARARCHIVE',0
		/* Uncheck the item SETDIRECTORY Radio Button */
		CALL VpSelect window,'SETDIRECTORY',0
		/* Uncheck the item CLEARDIRECTORY Radio Button */
		CALL VpSelect window,'CLEARDIRECTORY',0
		/* Uncheck the item SETHIDDEN Radio Button */
		CALL VpSelect window,'SETHIDDEN',0
		/* Uncheck the item CLEARHIDDEN Radio Button */
		CALL VpSelect window,'CLEARHIDDEN',0
		/* Uncheck the item SETREADONLY Radio Button */
		CALL VpSelect window,'SETREADONLY',0
		/* Uncheck the item CLEARREADONLY Radio Button */
		CALL VpSelect window,'CLEARREADONLY',0
		/* Uncheck the item SETSYSTEM Radio Button */
		CALL VpSelect window,'SETSYSTEM',0
		/* Uncheck the item CLEARSYSTEM Radio Button */
		CALL VpSelect window,'CLEARSYSTEM',0

		/* Hide item ATTRIBUTES Entry Field */
		CALL VpItem window,'ATTRIBUTES','HIDE'
		/* Hide item SETARCHIVE Radio Button */
		CALL VpItem window,'SETARCHIVE','HIDE'
		/* Hide item CLEARARCHIVE Radio Button */
		CALL VpItem window,'CLEARARCHIVE','HIDE'
		/* Hide item SETDIRECTORY Radio Button */
		CALL VpItem window,'SETDIRECTORY','HIDE'
		/* Hide item CLEARDIRECTORY Radio Button */
		CALL VpItem window,'CLEARDIRECTORY','HIDE'
		/* Hide item SETHIDDEN Radio Button */
		CALL VpItem window,'SETHIDDEN','HIDE'
		/* Hide item CLEARHIDDEN Radio Button */
		CALL VpItem window,'CLEARHIDDEN','HIDE'
		/* Hide item SETREADONLY Radio Button */
		CALL VpItem window,'SETREADONLY','HIDE'
		/* Hide item CLEARREADONLY Radio Button */
		CALL VpItem window,'CLEARREADONLY','HIDE'
		/* Hide item SETSYSTEM Radio Button */
		CALL VpItem window,'SETSYSTEM','HIDE'
		/* Hide item CLEARSYSTEM Radio Button */
		CALL VpItem window,'CLEARSYSTEM','HIDE'

		/* Get button state SIZECHECKBOX Check Box */
		SizeCheckBoxFlag = VpIsSelected(window,'SIZECHECKBOX')
		/* Get button state DATECHECKBOX Check Box */
		DateCheckBoxFlag = VpIsSelected(window,'DATECHECKBOX')
		/* Get button state TIMECHECKBOX Check Box */
		TimeCheckBoxFlag = VpIsSelected(window,'TIMECHECKBOX')
		IF SizeCheckBoxFlag = 0 & DateCheckBoxFlag = 0 & TimeCheckBoxFlag = 0 THEN
		/* Disable item CONTINUE Push Button */
		CALL VpItem window,'CONTINUE','DISABLE'
	END	/*Ends "WHEN AttributesCheckBoxFlag = 0 THEN DO" Section*/

	OTHERWISE NOP
END	/*Ends "SELECT" Section*/
return

/* ##260_1004.3 */
260_1004.3: /* Event Spin Button MINMONTH, Changed */
Arg window self



/*Begin resetting the day value, if necessary*/
/* Get item value MINMONTH Spin Button */
MinMonth = RIGHT(VpGetItemValue(window,'MINMONTH'), 2)
/* Get item value MINDAY Spin Button */
MinDay = RIGHT(VpGetItemValue(window,'MINDAY'), 2)
/* Get item value MINYEAR Spin Button */
MinYear = VpGetItemValue(window,'MINYEAR')
LeapTest1 = MinYear//4
LeapTest2 = MinYear//100
LeapTest3 = MinYear//400
SELECT
	WHEN MinMonth = 1 | MinMonth = 01 THEN MaxMonthDay = 31

	WHEN MinMonth = 2 | MinMonth = 02 THEN DO
		SELECT
			WHEN LeapTest1 \= 0 THEN MaxMonthDay = 28
			WHEN LeapTest1 = 0 & LeapTest2 \= 0 THEN MaxMonthDay = 29
			WHEN LeapTest3 = 0 THEN MaxMonthDay = 29
			WHEN LeapTest1 = 0 & LeapTest2 = 0 THEN MaxMonthDay = 28
			OTHERWISE NOP
		END	/*Ends "SELECT" Section*/
	END	/*End "WHEN MinMonth = 2 | MinMonth = 02 THEN DO" Section*/

	WHEN MinMonth = 3 | MinMonth = 03 THEN MaxMonthDay = 31
	WHEN MinMonth = 4 | MinMonth = 04 THEN MaxMonthDay = 30
	WHEN MinMonth = 5 | MinMonth = 05 THEN MaxMonthDay = 31
	WHEN MinMonth = 6 | MinMonth = 06 THEN MaxMonthDay = 30
	WHEN MinMonth = 7 | MinMonth = 07 THEN MaxMonthDay = 31
	WHEN MinMonth = 8 | MinMonth = 08 THEN MaxMonthDay = 31
	WHEN MinMonth = 9 | MinMonth = 09 THEN MaxMonthDay = 30
	WHEN MinMonth = 10 THEN MaxMonthDay = 31
	WHEN MinMonth = 11 THEN MaxMonthDay = 30
	WHEN MinMonth = 12 THEN MaxMonthDay = 31
	OTHERWISE NOP
END	/*End "SELECT" Section*/
IF MinDay > MaxMonthDay THEN CALL VpSetItemValue window,'MINDAY',MaxMonthDay
/*End resetting the day value, if necessary*/



/*Begin resetting the MAXMONTH, MAXDAY and/ MAXYEAR values, if necessary*/
CALL REMAXDTE
/*End resetting the MAXMONTH, MAXDAY and/ MAXYEAR values, if necessary*/

return

/* ##260_1006.0 */
260_1006.0: /* Event Set Archive SETARCHIVE, Clicked/selected */
Arg window self



/*Begin resetting the AttributeMask*/
CALL REATTBMK
/*End resetting the AttributeMask*/
return

/* ##260_1007.0 */
260_1007.0: /* Event Clear Archive CLEARARCHIVE, Clicked/selected */
Arg window self



/*Begin resetting the AttributeMask*/
CALL REATTBMK
/*End resetting the AttributeMask*/
return

/* ##260_1008.0 */
260_1008.0: /* Event Set Directory SETDIRECTORY, Clicked/selected */
Arg window self



/*Begin resetting the AttributeMask*/
CALL REATTBMK
/*End resetting the AttributeMask*/
return

/* ##260_1009.0 */
260_1009.0: /* Event Clear Directory CLEARDIRECTORY, Clicked/selected */
Arg window self



/*Begin resetting the AttributeMask*/
CALL REATTBMK
/*End resetting the AttributeMask*/
return

/* ##260_1010.0 */
260_1010.0: /* Event Set Hidden SETHIDDEN, Clicked/selected */
Arg window self



/*Begin resetting the AttributeMask*/
CALL REATTBMK
/*End resetting the AttributeMask*/
return

/* ##260_1011.0 */
260_1011.0: /* Event Clear Hidden CLEARHIDDEN, Clicked/selected */
Arg window self



/*Begin resetting the AttributeMask*/
CALL REATTBMK
/*End resetting the AttributeMask*/
return

/* ##260_1012.0 */
260_1012.0: /* Event Set Read Only SETREADONLY, Clicked/selected */
Arg window self



/*Begin resetting the AttributeMask*/
CALL REATTBMK
/*End resetting the AttributeMask*/
return

/* ##260_1013.0 */
260_1013.0: /* Event Clear Read Only CLEARREADONLY, Clicked/selected */
Arg window self



/*Begin resetting the AttributeMask*/
CALL REATTBMK
/*End resetting the AttributeMask*/
return

/* ##260_1014.0 */
260_1014.0: /* Event Set System SETSYSTEM, Clicked/selected */
Arg window self



/*Begin resetting the AttributeMask*/
CALL REATTBMK
/*End resetting the AttributeMask*/
return

/* ##260_1015.0 */
260_1015.0: /* Event Continue CONTINUE, Clicked/selected */
Arg window self



ContinuePresort = "CONTINUEPRESORT"
CALL VpNotify window,ContinuePresort
CALL VpWindow window,'CLOSE'
return

/* ##260_1016.0 */
260_1016.0: /* Event Cancel Presort CANCEL, Clicked/selected */
Arg window self



CancelPresort = "CANCELPRESORT"
CALL VpNotify window,CancelPresort
CALL VpWindow window,'CLOSE'
return

/* ##260_1017.0 */
260_1017.0: /* Event Clear System CLEARSYSTEM, Clicked/selected */
Arg window self



/*Begin resetting the AttributeMask*/
CALL REATTBMK
/*End resetting the AttributeMask*/
return

/* ##260_1018.3 */
260_1018.3: /* Event Spin Button MINDAY, Changed */
Arg window self



/*Begin resetting the day value, if necessary*/
/* Get item value MINMONTH Spin Button */
MinMonth = RIGHT(VpGetItemValue(window,'MINMONTH'), 2)
/* Get item value MINDAY Spin Button */
MinDay = RIGHT(VpGetItemValue(window,'MINDAY'), 2)
/* Get item value MINYEAR Spin Button */
MinYear = VpGetItemValue(window,'MINYEAR')
LeapTest1 = MinYear//4
LeapTest2 = MinYear//100
LeapTest3 = MinYear//400
SELECT
	WHEN MinMonth = 1 | MinMonth = 01 THEN MaxMonthDay = 31

	WHEN MinMonth = 2 | MinMonth = 02 THEN DO
		SELECT
			WHEN LeapTest1 \= 0 THEN MaxMonthDay = 28
			WHEN LeapTest1 = 0 & LeapTest2 \= 0 THEN MaxMonthDay = 29
			WHEN LeapTest3 = 0 THEN MaxMonthDay = 29
			WHEN LeapTest1 = 0 & LeapTest2 = 0 THEN MaxMonthDay = 28
			OTHERWISE NOP
		END	/*Ends "SELECT" Section*/
	END	/*End "WHEN MinMonth = 2 | MinMonth = 02 THEN DO" Section*/

	WHEN MinMonth = 3 | MinMonth = 03 THEN MaxMonthDay = 31
	WHEN MinMonth = 4 | MinMonth = 04 THEN MaxMonthDay = 30
	WHEN MinMonth = 5 | MinMonth = 05 THEN MaxMonthDay = 31
	WHEN MinMonth = 6 | MinMonth = 06 THEN MaxMonthDay = 30
	WHEN MinMonth = 7 | MinMonth = 07 THEN MaxMonthDay = 31
	WHEN MinMonth = 8 | MinMonth = 08 THEN MaxMonthDay = 31
	WHEN MinMonth = 9 | MinMonth = 09 THEN MaxMonthDay = 30
	WHEN MinMonth = 10 THEN MaxMonthDay = 31
	WHEN MinMonth = 11 THEN MaxMonthDay = 30
	WHEN MinMonth = 12 THEN MaxMonthDay = 31
	OTHERWISE NOP
END	/*End "SELECT" Section*/
IF MinDay > MaxMonthDay THEN CALL VpSetItemValue window,'MINDAY',MaxMonthDay
/*End resetting the day value, if necessary*/



/*Begin resetting the MAXMONTH, MAXDAY and/ MAXYEAR values, if necessary*/
CALL REMAXDTE
/*End resetting the MAXMONTH, MAXDAY and/ MAXYEAR values, if necessary*/

return

/* ##260_1019.3 */
260_1019.3: /* Event Spin Button MINYEAR, Changed */
Arg window self



/*Begin resetting the day value, if necessary*/
/* Get item value MINMONTH Spin Button */
MinMonth = RIGHT(VpGetItemValue(window,'MINMONTH'), 2)
/* Get item value MINDAY Spin Button */
MinDay = RIGHT(VpGetItemValue(window,'MINDAY'), 2)
/* Get item value MINYEAR Spin Button */
MinYear = VpGetItemValue(window,'MINYEAR')
LeapTest1 = MinYear//4
LeapTest2 = MinYear//100
LeapTest3 = MinYear//400
SELECT
	WHEN MinMonth = 1 | MinMonth = 01 THEN MaxMonthDay = 31

	WHEN MinMonth = 2 | MinMonth = 02 THEN DO
		SELECT
			WHEN LeapTest1 \= 0 THEN MaxMonthDay = 28
			WHEN LeapTest1 = 0 & LeapTest2 \= 0 THEN MaxMonthDay = 29
			WHEN LeapTest3 = 0 THEN MaxMonthDay = 29
			WHEN LeapTest1 = 0 & LeapTest2 = 0 THEN MaxMonthDay = 28
			OTHERWISE NOP
		END	/*Ends "SELECT" Section*/
	END	/*End "WHEN MinMonth = 2 | MinMonth = 02 THEN DO" Section*/

	WHEN MinMonth = 3 | MinMonth = 03 THEN MaxMonthDay = 31
	WHEN MinMonth = 4 | MinMonth = 04 THEN MaxMonthDay = 30
	WHEN MinMonth = 5 | MinMonth = 05 THEN MaxMonthDay = 31
	WHEN MinMonth = 6 | MinMonth = 06 THEN MaxMonthDay = 30
	WHEN MinMonth = 7 | MinMonth = 07 THEN MaxMonthDay = 31
	WHEN MinMonth = 8 | MinMonth = 08 THEN MaxMonthDay = 31
	WHEN MinMonth = 9 | MinMonth = 09 THEN MaxMonthDay = 30
	WHEN MinMonth = 10 THEN MaxMonthDay = 31
	WHEN MinMonth = 11 THEN MaxMonthDay = 30
	WHEN MinMonth = 12 THEN MaxMonthDay = 31
	OTHERWISE NOP
END	/*End "SELECT" Section*/
IF MinDay > MaxMonthDay THEN CALL VpSetItemValue window,'MINDAY',MaxMonthDay
/*End resetting the day value, if necessary*/



/*Begin resetting the MAXMONTH, MAXDAY and/ MAXYEAR values, if necessary*/
CALL REMAXDTE
/*End resetting the MAXMONTH, MAXDAY and/ MAXYEAR values, if necessary*/

return

/* ##260_1020.3 */
260_1020.3: /* Event Spin Button MAXYEAR, Changed */
Arg window self



/*Begin resetting the day value, if necessary*/
/* Get item value MAXMONTH Spin Button */
MaxMonth = RIGHT(VpGetItemValue(window,'MAXMONTH'), 2)
/* Get item value MAXDAY Spin Button */
MaxDay = RIGHT(VpGetItemValue(window,'MAXDAY'), 2)
/* Get item value MAXYEAR Spin Button */
MaxYear = VpGetItemValue(window,'MAXYEAR')
LeapTest1 = MaxYear//4
LeapTest2 = MaxYear//100
LeapTest3 = MaxYear//400
SELECT
	WHEN MaxMonth = 1 | MaxMonth = 01 THEN MaxMonthDay = 31

	WHEN MaxMonth = 2 | MaxMonth = 02 THEN DO
		SELECT
			WHEN LeapTest1 \= 0 THEN MaxMonthDay = 28
			WHEN LeapTest1 = 0 & LeapTest2 \= 0 THEN MaxMonthDay = 29
			WHEN LeapTest3 = 0 THEN MaxMonthDay = 29
			WHEN LeapTest1 = 0 & LeapTest2 = 0 THEN MaxMonthDay = 28
			OTHERWISE NOP
		END	/*Ends "SELECT" Section*/
	END	/*End "WHEN MaxMonth = 2 | MaxMonth = 02 THEN DO" Section*/

	WHEN MaxMonth = 3 | MaxMonth = 03 THEN MaxMonthDay = 31
	WHEN MaxMonth = 4 | MaxMonth = 04 THEN MaxMonthDay = 30
	WHEN MaxMonth = 5 | MaxMonth = 05 THEN MaxMonthDay = 31
	WHEN MaxMonth = 6 | MaxMonth = 06 THEN MaxMonthDay = 30
	WHEN MaxMonth = 7 | MaxMonth = 07 THEN MaxMonthDay = 31
	WHEN MaxMonth = 8 | MaxMonth = 08 THEN MaxMonthDay = 31
	WHEN MaxMonth = 9 | MaxMonth = 09 THEN MaxMonthDay = 30
	WHEN MaxMonth = 10 THEN MaxMonthDay = 31
	WHEN MaxMonth = 11 THEN MaxMonthDay = 30
	WHEN MaxMonth = 12 THEN MaxMonthDay = 31
	OTHERWISE NOP
END	/*End "SELECT" Section*/
IF MaxDay > MaxMonthDay THEN CALL VpSetItemValue window,'MAXDAY',MaxMonthDay
/*End resetting the day value, if necessary*/



/*Begin resetting the MINMONTH, MINDAY and/ MINYEAR values, if necessary*/
CALL REMINDTE
/*End resetting the MINMONTH, MINDAY and/ MINYEAR values, if necessary*/

return

/* ##260_1021.3 */
260_1021.3: /* Event Spin Button MAXDAY, Changed */
Arg window self



/*Begin resetting the day value, if necessary*/
/* Get item value MAXMONTH Spin Button */
MaxMonth = RIGHT(VpGetItemValue(window,'MAXMONTH'), 2)
/* Get item value MAXDAY Spin Button */
MaxDay = RIGHT(VpGetItemValue(window,'MAXDAY'), 2)
/* Get item value MAXYEAR Spin Button */
MaxYear = VpGetItemValue(window,'MAXYEAR')
LeapTest1 = MaxYear//4
LeapTest2 = MaxYear//100
LeapTest3 = MaxYear//400
SELECT
	WHEN MaxMonth = 1 | MaxMonth = 01 THEN MaxMonthDay = 31

	WHEN MaxMonth = 2 | MaxMonth = 02 THEN DO
		SELECT
			WHEN LeapTest1 \= 0 THEN MaxMonthDay = 28
			WHEN LeapTest1 = 0 & LeapTest2 \= 0 THEN MaxMonthDay = 29
			WHEN LeapTest3 = 0 THEN MaxMonthDay = 29
			WHEN LeapTest1 = 0 & LeapTest2 = 0 THEN MaxMonthDay = 28
			OTHERWISE NOP
		END	/*Ends "SELECT" Section*/
	END	/*End "WHEN MaxMonth = 2 | MaxMonth = 02 THEN DO" Section*/

	WHEN MaxMonth = 3 | MaxMonth = 03 THEN MaxMonthDay = 31
	WHEN MaxMonth = 4 | MaxMonth = 04 THEN MaxMonthDay = 30
	WHEN MaxMonth = 5 | MaxMonth = 05 THEN MaxMonthDay = 31
	WHEN MaxMonth = 6 | MaxMonth = 06 THEN MaxMonthDay = 30
	WHEN MaxMonth = 7 | MaxMonth = 07 THEN MaxMonthDay = 31
	WHEN MaxMonth = 8 | MaxMonth = 08 THEN MaxMonthDay = 31
	WHEN MaxMonth = 9 | MaxMonth = 09 THEN MaxMonthDay = 30
	WHEN MaxMonth = 10 THEN MaxMonthDay = 31
	WHEN MaxMonth = 11 THEN MaxMonthDay = 30
	WHEN MaxMonth = 12 THEN MaxMonthDay = 31
	OTHERWISE NOP
END	/*End "SELECT" Section*/
IF MaxDay > MaxMonthDay THEN CALL VpSetItemValue window,'MAXDAY',MaxMonthDay
/*End resetting the day value, if necessary*/



/*Begin resetting the MINMONTH, MINDAY and/ MINYEAR values, if necessary*/
CALL REMINDTE
/*End resetting the MINMONTH, MINDAY and/ MINYEAR values, if necessary*/

return

/* ##260_1022.3 */
260_1022.3: /* Event Spin Button MAXMONTH, Changed */
Arg window self



/*Begin resetting the day value, if necessary*/
/* Get item value MAXMONTH Spin Button */
MaxMonth = RIGHT(VpGetItemValue(window,'MAXMONTH'), 2)
/* Get item value MAXDAY Spin Button */
MaxDay = RIGHT(VpGetItemValue(window,'MAXDAY'), 2)
/* Get item value MAXYEAR Spin Button */
MaxYear = VpGetItemValue(window,'MAXYEAR')
LeapTest1 = MaxYear//4
LeapTest2 = MaxYear//100
LeapTest3 = MaxYear//400
SELECT
	WHEN MaxMonth = 1 | MaxMonth = 01 THEN MaxMonthDay = 31

	WHEN MaxMonth = 2 | MaxMonth = 02 THEN DO
		SELECT
			WHEN LeapTest1 \= 0 THEN MaxMonthDay = 28
			WHEN LeapTest1 = 0 & LeapTest2 \= 0 THEN MaxMonthDay = 29
			WHEN LeapTest3 = 0 THEN MaxMonthDay = 29
			WHEN LeapTest1 = 0 & LeapTest2 = 0 THEN MaxMonthDay = 28
			OTHERWISE NOP
		END	/*Ends "SELECT" Section*/
	END	/*End "WHEN MaxMonth = 2 | MaxMonth = 02 THEN DO" Section*/

	WHEN MaxMonth = 3 | MaxMonth = 03 THEN MaxMonthDay = 31
	WHEN MaxMonth = 4 | MaxMonth = 04 THEN MaxMonthDay = 30
	WHEN MaxMonth = 5 | MaxMonth = 05 THEN MaxMonthDay = 31
	WHEN MaxMonth = 6 | MaxMonth = 06 THEN MaxMonthDay = 30
	WHEN MaxMonth = 7 | MaxMonth = 07 THEN MaxMonthDay = 31
	WHEN MaxMonth = 8 | MaxMonth = 08 THEN MaxMonthDay = 31
	WHEN MaxMonth = 9 | MaxMonth = 09 THEN MaxMonthDay = 30
	WHEN MaxMonth = 10 THEN MaxMonthDay = 31
	WHEN MaxMonth = 11 THEN MaxMonthDay = 30
	WHEN MaxMonth = 12 THEN MaxMonthDay = 31
	OTHERWISE NOP
END	/*End "SELECT" Section*/
IF MaxDay > MaxMonthDay THEN CALL VpSetItemValue window,'MAXDAY',MaxMonthDay
/*End resetting the day value, if necessary*/



/*Begin resetting the MINMONTH, MINDAY and/ MINYEAR values, if necessary*/
CALL REMINDTE
/*End resetting the MINMONTH, MINDAY and/ MINYEAR values, if necessary*/

return

/* ##260_1025.3 */
260_1025.3: /* Event Spin Button MINHOURS, Changed */
Arg window self



/*Begin resetting the MaxHours, MaxMinutes, MaxSeconds, MaxAMPM, if required*/
CHANGEMINHOURS:
/* Get item value MINHOURS Spin Button */
MinHours = VpGetItemValue(window,'MINHOURS')
/* Get item value MINMINUTES Spin Button */
MinMinutes = VpGetItemValue(window,'MINMINUTES')
/* Get item value MINSECONDS Spin Button */
MinSeconds = VpGetItemValue(window,'MINSECONDS')
IF Setup.Presort_Time_Format = "HH MM SS AMPM" THEN DO
	/* Get item value MINAMPM Spin Button */
	MinAMPM = VpGetItemValue(window,'MINAMPM')

	SELECT
		WHEN PriorMinAMPM = 1 & PriorMinHours = 11 & MinHours = 12 & MinMinutes = 0 & MinSeconds = 0 THEN MinAMPM = 2
		WHEN PriorMinAMPM = 1 & PriorMinHours = 12 & MinHours = 11 THEN MinAMPM = 2
		WHEN PriorMinAMPM = 2 & PriorMinHours = 11 & MinHours = 12 & MinMinutes = 0 & MinSeconds = 0 THEN MinAMPM = 1
		WHEN PriorMinAMPM = 2 & PriorMinHours = 12 & MinHours = 11 THEN MinAMPM = 1
		OTHERWISE MinAMPM = PriorMinAMPM
	END	/*Ends "SELECT" Section*/

	SELECT
		WHEN MinAMPM = 1 THEN MinAMPMEntry = "AM"
		WHEN MinAMPM = 2 THEN MinAMPMEntry = "PM"
		OTHERWISE NOP
	END	/*Ends "SELECT" Section*/

	/* Set item value MINAMPM Spin Button */
	CALL VpSetItemValue window,'MINAMPM',MinAMPM
	/* Set item value MINAMPMENTRY Entry Field */
	CALL VpSetItemValue window,'MINAMPMENTRY',MinAMPMEntry
END	/*Ends "IF Setup.Presort_Time_Format = "HH MM SS AMPM" THEN DO" Section*/
IF MinTime_Semaphore = 1 | MinTime_Semaphore = 2 THEN RETURN
CALL REMAXTME
PriorMinHours = MinHours
PriorMinAMPM = MinAMPM
PriorMinAMPMEntry = MinAMPMEntry
/*End resetting the MaxHours, MaxMinutes, MaxSeconds, MaxAMPM, if required*/
return

/* ##260_1026.3 */
260_1026.3: /* Event Spin Button MINMINUTES, Changed */
Arg window self



/*Begin resetting the MaxHours, MaxMinutes, MaxSeconds, MaxAMPM, if required*/
CHANGEMINMINUTES:
PriorMinTime_Semaphore = 0
/* Get item value MINMINUTES Spin Button */
MinMinutes = VpGetItemValue(window,'MINMINUTES')
/* Get item value MINHOURS Spin Button */
MinHours = VpGetItemValue(window,'MINHOURS')
SELECT
	WHEN MinMinutes = 0 & PriorMinMinutes = 59 THEN DO
		SELECT
			WHEN Setup.Presort_Time_Format = "HH MM SS AMPM" THEN DO
				MinHours = (MinHours + 1)//13
				IF MinHours = 0 THEN MinHours = 1
			END	/*Ends "WHEN Setup.Presort_Time_Format = "HH MM SS AMPM" THEN DO" Section*/

			WHEN Setup.Presort_Time_Format = "HH MM SS" THEN MinHours = (MinHours + 1)//24

			OTHERWISE NOP
		END	/*Ends "SELECT" Section*/
		PriorMinTime_Semaphore = MinTime_Semaphore
		MinTime_Semaphore = 2
		/* Set item value MINHOURS Spin Button */
		CALL VpSetItemValue window,'MINHOURS',MinHours
		CALL CHANGEMINHOURS
	END	/*Ends "WHEN MinMinutes = 0 & PriorMinMinutes = 59 THEN DO" Section*/

	WHEN MinMinutes = 59 & PriorMinMinutes = 0 THEN DO
		MinHours = MinHours - 1
		IF Setup.Presort_Time_Format = "HH MM SS AMPM" & MinHours = 0 THEN MinHours = 12
		IF Setup.Presort_Time_Format = "HH MM SS" & MinHours < 0 THEN MinHours = 23
		PriorMinTime_Semaphore = MinTime_Semaphore
		MinTime_Semaphore = 2
		/* Set item value MINHOURS Spin Button */
		CALL VpSetItemValue window,'MINHOURS',MinHours
		CALL CHANGEMINHOURS
	END	/*Ends "WHEN MinMinutes = 59 & PriorMinMinutes = 0 THEN DO" Section*/
		
	OTHERWISE NOP
END	/*Ends "SELECT" Section*/
IF PriorMinTime_Semaphore = 1 THEN RETURN
CALL REMAXTME
PriorMinAMPM = MinAMPM
PriorMinAMPMEntry = MinAMPMEntry
PriorMinHours = MinHours
PriorMinMinutes = MinMinutes
MinTime_Semaphore = 0
/*End resetting the MaxHours, MaxMinutes, MaxSeconds, MaxAMPM, if required*/
return

/* ##260_1027.3 */
260_1027.3: /* Event Spin Button MINSECONDS, Changed */
Arg window self



/*Begin resetting the MaxHours, MaxMinutes, MaxSeconds, MaxAMPM, if required*/
/* Get item value MINSECONDS Spin Button */
MinSeconds = VpGetItemValue(window,'MINSECONDS')
/* Get item value MINMINUTES Spin Button */
MinMinutes = VpGetItemValue(window,'MINMINUTES')
SELECT
	WHEN MinSeconds = 0 & PriorMinSeconds = 59 THEN DO
		MinMinutes = (MinMinutes + 1)//60
		MinTime_Semaphore = 1
		/* Set item value MINMINUTES Spin Button */
		CALL VpSetItemValue window,'MINMINUTES',MinMinutes
		CALL CHANGEMINMINUTES
	END	/*Ends "WHEN MinSeconds = 0 & PriorMinSeconds = 59 THEN DO" Section*/

	WHEN MinSeconds = 59 & PriorMinSeconds = 0 THEN DO
		IF MinMinutes > 0 THEN MinMinutes = MinMinutes - 1
		ELSE MinMinutes = 59
		MinTime_Semaphore = 1
		/* Set item value MINMINUTES Spin Button */
		CALL VpSetItemValue window,'MINMINUTES',MinMinutes
		CALL CHANGEMINMINUTES
	END	/*Ends "WHEN MinSeconds = 59 & PriorMinSeconds = 0 THEN DO" Section*/
		
	OTHERWISE NOP
END	/*Ends "SELECT" Section*/
CALL REMAXTME
PriorMinAMPM = MinAMPM
PriorMinAMPMEntry = MinAMPMEntry
PriorMinHours = MinHours
PriorMinMinutes = MinMinutes
PriorMinSeconds = MinSeconds
MinTime_Semaphore = 0
/*End resetting the MaxHours, MaxMinutes, MaxSeconds, MaxAMPM, if required*/
return

/* ##260_1028.3 */
260_1028.3: /* Event Spin Button MAXHOURS, Changed */
Arg window self



/*Begin resetting the MinHours, MinMinutes, MinSeconds, MinAMPM, if required*/
CHANGEMAXHOURS:
/* Get item value MAXHOURS Spin Button */
MaxHours = VpGetItemValue(window,'MAXHOURS')
/* Get item value MAXMINUTES Spin Button */
MaxMinutes = VpGetItemValue(window,'MAXMINUTES')
/* Get item value MAXSECONDS Spin Button */
MaxSeconds = VpGetItemValue(window,'MAXSECONDS')
IF Setup.Presort_Time_Format = "HH MM SS AMPM" THEN DO
	/* Get item value MAXAMPM Spin Button */
	MaxAMPM = VpGetItemValue(window,'MAXAMPM')

	SELECT
		WHEN PriorMaxAMPM = 1 & PriorMaxHours = 11 & MaxHours = 12 & MaxMinutes = 0 & MaxSeconds = 0 THEN MaxAMPM = 2
		WHEN PriorMaxAMPM = 1 & PriorMaxHours = 12 & MaxHours = 11 THEN MaxAMPM = 2
		WHEN PriorMaxAMPM = 2 & PriorMaxHours = 11 & MaxHours = 12 & MaxMinutes = 0 & MaxSeconds = 0 THEN MaxAMPM = 1
		WHEN PriorMaxAMPM = 2 & PriorMaxHours = 12 & MaxHours = 11 THEN MaxAMPM = 1
		OTHERWISE MaxAMPM = PriorMaxAMPM
	END	/*Ends "SELECT" Section*/

	SELECT
		WHEN MaxAMPM = 1 THEN MaxAMPMEntry = "AM"
		WHEN MaxAMPM = 2 THEN MaxAMPMEntry = "PM"
		OTHERWISE NOP
	END	/*Ends "SELECT" Section*/

	/* Set item value MAXAMPM Spin Button */
	CALL VpSetItemValue window,'MAXAMPM',MaxAMPM
	/* Set item value MAXAMPMENTRY Entry Field */
	CALL VpSetItemValue window,'MAXAMPMENTRY',MaxAMPMEntry
END	/*Ends "IF Setup.Presort_Time_Format = "HH MM SS AMPM" THEN DO" Section*/
IF MaxTime_Semaphore = 1 | MinTime_Semaphore = 2 THEN RETURN
CALL REMINTME
PriorMaxHours = MaxHours
PriorMaxAMPM = MaxAMPM
PriorMaxAMPMEntry = MaxAMPMEntry
/*End resetting the MinHours, MinMinutes, MinSeconds, MinAMPM, if required*/
return

/* ##260_1029.3 */
260_1029.3: /* Event Spin Button MAXMINUTES, Changed */
Arg window self



/*Begin resetting the MinHours, MinMinutes, MinSeconds, MinAMPM, if required*/
CHANGEMAXMINUTES:
PriorMaxTime_Semaphore = 0
/* Get item value MAXMINUTES Spin Button */
MaxMinutes = VpGetItemValue(window,'MAXMINUTES')
/* Get item value MAXHOURS Spin Button */
MaxHours = VpGetItemValue(window,'MAXHOURS')
SELECT
	WHEN MaxMinutes = 0 & PriorMaxMinutes = 59 THEN DO
		SELECT
			WHEN Setup.Presort_Time_Format = "HH MM SS AMPM" THEN DO
				MaxHours = (MaxHours + 1)//13
				IF MaxHours = 0 THEN MaxHours = 1
			END	/*Ends "WHEN Setup.Presort_Time_Format = "HH MM SS AMPM" THEN DO" Section*/

			WHEN Setup.Presort_Time_Format = "HH MM SS" THEN MaxHours = (MaxHours + 1)//24

			OTHERWISE NOP
		END	/*Ends "SELECT" Section*/
		PriorMaxTime_Semaphore = MaxTime_Semaphore
		MaxTime_Semaphore = 2
		/* Set item value MAXHOURS Spin Button */
		CALL VpSetItemValue window,'MAXHOURS',MaxHours
		CALL CHANGEMAXHOURS
	END	/*Ends "WHEN MaxMinutes = 0 & PriorMaxMinutes = 59 THEN DO" Section*/

	WHEN MaxMinutes = 59 & PriorMaxMinutes = 0 THEN DO
		MaxHours = MaxHours - 1
		IF Setup.Presort_Time_Format = "HH MM SS AMPM" & MaxHours = 0 THEN MaxHours = 12
		IF Setup.Presort_Time_Format = "HH MM SS" & MaxHours < 0 THEN MaxHours = 23
		PriorMaxTime_Semaphore = MaxTime_Semaphore
		MaxTime_Semaphore = 2
		/* Set item value MAXHOURS Spin Button */
		CALL VpSetItemValue window,'MAXHOURS',MaxHours
		CALL CHANGEMAXHOURS
	END	/*Ends "WHEN MaxMinutes = 59 & PriorMaxMinutes = 0 THEN DO" Section*/
		
	OTHERWISE NOP
END	/*Ends "SELECT" Section*/
IF PriorMaxTime_Semaphore = 1 THEN RETURN
CALL REMINTME
PriorMaxAMPM = MaxAMPM
PriorMaxAMPMEntry = MaxAMPMEntry
PriorMaxHours = MaxHours
PriorMaxMinutes = MaxMinutes
MaxTime_Semaphore = 0
/*End resetting the MinHours, MinMinutes, MinSeconds, MinAMPM, if required*/
return

/* ##260_1030.3 */
260_1030.3: /* Event Spin Button MAXSECONDS, Changed */
Arg window self



/*Begin resetting the MinHours, MinMinutes, MinSeconds, MinAMPM, if required*/
/* Get item value MAXSECONDS Spin Button */
MaxSeconds = VpGetItemValue(window,'MAXSECONDS')
/* Get item value MAXMINUTES Spin Button */
MaxMinutes = VpGetItemValue(window,'MAXMINUTES')
SELECT
	WHEN MaxSeconds = 0 & PriorMaxSeconds = 59 THEN DO
		MaxMinutes = (MaxMinutes + 1)//60
		MaxTime_Semaphore = 1
		/* Set item value MAXMINUTES Spin Button */
		CALL VpSetItemValue window,'MAXMINUTES',MaxMinutes
		CALL CHANGEMAXMINUTES
	END	/*Ends "WHEN MaxSeconds = 0 & PriorMaxSeconds = 59 THEN DO" Section*/

	WHEN MaxSeconds = 59 & PriorMaxSeconds = 0 THEN DO
		IF MaxMinutes > 0 THEN MaxMinutes = MaxMinutes - 1
		ELSE MaxMinutes = 59
		MaxTime_Semaphore = 1
		/* Set item value MAXMINUTES Spin Button */
		CALL VpSetItemValue window,'MAXMINUTES',MaxMinutes
		CALL CHANGEMAXMINUTES
	END	/*Ends "WHEN MaxSeconds = 59 & PriorMaxSeconds = 0 THEN DO" Section*/
		
	OTHERWISE NOP
END	/*Ends "SELECT" Section*/
CALL REMINTME
PriorMaxAMPM = MaxAMPM
PriorMaxAMPMEntry = MaxAMPMEntry
PriorMaxHours = MaxHours
PriorMaxMinutes = MaxMinutes
PriorMaxSeconds = MaxSeconds
MaxTime_Semaphore = 0
/*End resetting the MinHours, MinMinutes, MinSeconds, MinAMPM, if required*/
return

/* ##260_1031.3 */
260_1031.3: /* Event Spin Button MINAMPM, Changed */
Arg window self



/* Get item value MINAMPM Spin Button */
MinAMPM = VpGetItemValue(window,'MINAMPM')

SELECT
	WHEN MinAMPM = 1 THEN
	/* Set item value MINAMPMENTRY Entry Field */
	CALL VpSetItemValue window,'MINAMPMENTRY',"AM"
	

	WHEN MinAMPM = 2 THEN
	/* Set item value MINAMPMENTRY Entry Field */
	CALL VpSetItemValue window,'MINAMPMENTRY',"PM"

	OTHERWISE NOP
END	/*Ends "SELECT" Section*/



/*Begin resetting the MaxHours, MaxMinutes, MaxSeconds, MaxAMPM, if required*/
CALL REMAXTME
/*End resetting the MaxHours, MaxMinutes, MaxSeconds, MaxAMPM, if required*/
return

/* ##260_1032.3 */
260_1032.3: /* Event Spin Button MAXAMPM, Changed */
Arg window self



/* Get item value MAXAMPM Spin Button */
MaxAMPM = VpGetItemValue(window,'MAXAMPM')

SELECT
	WHEN MaxAMPM = 1 THEN
	/* Set item value MAXAMPMENTRY Entry Field */
	CALL VpSetItemValue window,'MAXAMPMENTRY',"AM"
	

	WHEN MaxAMPM = 2 THEN
	/* Set item value MAXAMPMENTRY Entry Field */
	CALL VpSetItemValue window,'MAXAMPMENTRY',"PM"

	OTHERWISE NOP
END	/*Ends "SELECT" Section*/



/*Begin resetting the MinHours, MinMinutes, MinSeconds, MinAMPM, if required*/
CALL REMINTME
/*End resetting the MinHours, MinMinutes, MinSeconds, MinAMPM, if required*/
return

/* ##260_1042.3 */
260_1042.3: /* Event  MINSIZE, Changed */
Arg window self



/* Get item value MINSIZE Entry Field */
MinFileSize = VpGetItemValue(window,'MINSIZE')
/* Get item value MAXSIZE Entry Field */
MaxFileSize = VpGetItemValue(window,'MAXSIZE')

SELECT
	WHEN DATATYPE(MinFileSize) = "NUM" & MinFileSize >= 0 THEN DO
		MinFileSize_PresentValue = MinFileSize
		IF MaxFileSize = "" | MaxFileSize < MinFileSize THEN
		/* Set item value MAXSIZE Entry Field */
		CALL VpSetItemValue window,'MAXSIZE',MinFileSize
	END	/*Ends "WHEN DATATYPE(MinFileSize) = "NUM" & MinFileSize >= 0 THEN DO" Section*/

	WHEN DATATYPE(MinFileSize) \= "NUM" & SizeCheckBoxFlag = 1 THEN DO
		Title = "IMPROPER DATA INPUT"
		WarningMessage1 = "Sorry, you must enter a non-negative number for the minimum file size."
		WarningMessage2 = " Please reenter an acceptable value."
		WarningMessage = WarningMessage1||WarningMessage2
		response=VpMessageBox(window,Title,WarningMessage)
		/* Set item value MINSIZE Entry Field */
		CALL VpSetItemValue window,'MINSIZE',MinFileSize_PresentValue
	END	/*Ends "WHEN DATATYPE(MinFileSize) \= "NUM" & SizeCheckBoxFlag = 1 THEN DO" Section*/	

	OTHERWISE NOP
END	/*Ends "SELECT" Section*/
return

/* ##260_1043.3 */
260_1043.3: /* Event  MAXSIZE, Changed */
Arg window self



/* Get item value MINSIZE Entry Field */
MinFileSize = VpGetItemValue(window,'MINSIZE')
/* Get item value MAXSIZE Entry Field */
MaxFileSize = VpGetItemValue(window,'MAXSIZE')

SELECT
	WHEN DATATYPE(MaxFileSize) = "NUM" & MaxFileSize >= 0 THEN DO
		MaxFileSize_PresentValue = MaxFileSize
		IF MaxFileSize = "" | MaxFileSize < MinFileSize THEN
		/* Set item value MAXSIZE Entry Field */
		CALL VpSetItemValue window,'MAXSIZE',MinFileSize
	END	/*Ends "WHEN DATATYPE(MaxFileSize) = "NUM" & MaxFileSize >= 0 THEN DO" Section*/

	WHEN DATATYPE(MaxFileSize) \= "NUM" & SizeCheckBoxFlag = 1 THEN DO
		Title = "IMPROPER DATA INPUT"
		WarningMessage1 = "Sorry, you must enter a non-negative number for the minimum file size."
		WarningMessage2 = " Please reenter an acceptable value."
		WarningMessage = WarningMessage1||WarningMessage2
		response=VpMessageBox(window,Title,WarningMessage)
		/* Set item value MAXSIZE Entry Field */
		CALL VpSetItemValue window,'MAXSIZE',MaxFileSize_PresentValue
	END	/*Ends "WHEN DATATYPE(MaxFileSize) \= "NUM" & SizeCheckBoxFlag = 1 THEN DO" Section*/

	OTHERWISE NOP
END	/*Ends "SELECT" Section*/
return

/* ##260_Form.1 */
260_Form.1: /* Event Form events, Opened */
Arg window



/*Begin geting today's day, month and year*/
Today = DATE()
TodaySorted = DATE("S", Today, "N")
TodayYear = SUBSTR(TodaySorted, 1, 4)
TodayMonth = SUBSTR(TodaySorted, 5, 2)
TodayDay = SUBSTR(TodaySorted, 7, 2)
/*End geting today's day, month and year*/



/*Begin getting the present time in hours, minutes and second*/
PresentTime = TIME()
PresentHours = SUBSTR(PresentTime, 1, 2)
PresentMinutes = SUBSTR(PresentTime, 4, 2)
PresentSeconds = SUBSTR(PresentTime, 7, 2)
PresentAMPM = ""
/*End getting the present time in hours, minutes and second*/



/*Begin setting the file size objects*/
/* Uncheck the item SIZECHECKBOX Check Box */
CALL VpSelect window,'SIZECHECKBOX',0

SELECT
	WHEN FileNameSearchFlag = 1 THEN CALL VpItem window,'SIZECHECKBOX','ENABLE'	
	WHEN DirectorySearchFlag = 1 THEN CALL VpItem window,'SIZECHECKBOX','DISABLE'
	OTHERWISE NOP
END	/*Ends "SELECT" Section*/

/* Hide item MINSIZE Entry Field */
CALL VpItem window,'MINSIZE','HIDE'
/* Hide item MAXSIZE Entry Field */
CALL VpItem window,'MAXSIZE','HIDE'
/*End setting the file size objects*/



/*Begin getting the positions and sizes of the day, month and year Spin Buttons*/
/* Get item position MINMONTH Spin Button */
xy=VpItem(window,'MINMONTH','ITEMPOS')
PARSE VAR xy MINMONTHxPosition MINMONTHyPosition
/* Get item size MINMONTH Spin Button */
xy=VpItem(window,'MINMONTH','ITEMSIZE')
PARSE VAR xy MINMONTHxSize MINMONTHySize
/* Get item position MINDAY Spin Button */
xy=VpItem(window,'MINDAY','ITEMPOS')
PARSE VAR xy MINDAYxPosition MINDAYyPosition
/* Get item size MINDAY Spin Button */
xy=VpItem(window,'MINDAY','ITEMSIZE')
PARSE VAR xy MINDAYxSize MINDAYySize
/* Get item position MINYEAR Spin Button */
xy=VpItem(window,'MINYEAR','ITEMPOS')
PARSE VAR xy MINYEARxPosition MINYEARyPosition
/* Get item size MINYEAR Spin Button */
xy=VpItem(window,'MINYEAR','ITEMSIZE')
PARSE VAR xy MINYEARxSize MINYEARySize
MINDelta1 = (MINDAYxPosition - MINMONTHxPosition - MINMONTHxSize)
MINDelta2 = (MINYEARxPosition - MINDAYxPosition - MINDAYxSize)

/* Get item position MAXMONTH Spin Button */
xy=VpItem(window,'MAXMONTH','ITEMPOS')
PARSE VAR xy MAXMONTHxPosition MAXMONTHyPosition
/* Get item size MAXMONTH Spin Button */
xy=VpItem(window,'MAXMONTH','ITEMSIZE')
PARSE VAR xy MAXMONTHxSize MAXMONTHySize
/* Get item position MAXDAY Spin Button */
xy=VpItem(window,'MAXDAY','ITEMPOS')
PARSE VAR xy MAXDAYxPosition MAXDAYyPosition
/* Get item size MAXDAY Spin Button */
xy=VpItem(window,'MAXDAY','ITEMSIZE')
PARSE VAR xy MAXDAYxSize MAXDAYySize
/* Get item position MAXYEAR Spin Button */
xy=VpItem(window,'MAXYEAR','ITEMPOS')
PARSE VAR xy MAXYEARxPosition MAXYEARyPosition
/* Get item size MAXYEAR Spin Button */
xy=VpItem(window,'MAXYEAR','ITEMSIZE')
PARSE VAR xy MAXYEARxSize MAXYEARySize
MAXDelta1 = (MAXDAYxPosition - MAXMONTHxPosition - MAXMONTHxSize)
MAXDelta2 = (MAXYEARxPosition - MAXDAYxPosition - MAXDAYxSize)
/*End getting the positions and sizes of the day, month and year Spin Buttons*/



/*Begin getting the positions and sizes of the MINIMUMTIMETEXT and MAXIMUMTIMETEXT labels*/
/* Get item position MINIMUMTIMETEXT Text */
xy=VpItem(window,'MINIMUMTIMETEXT','ITEMPOS')
PARSE VAR xy MINIMUMTIMETEXTxPosition MINIMUMTIMETEXTyPosition
/* Get item size MINIMUMTIMETEXT Text */
xy=VpItem(window,'MINIMUMTIMETEXT','ITEMSIZE')
PARSE VAR xy MINIMUMTIMETEXTxSize MINIMUMTIMETEXTySize

/* Get item position MAXIMUMTIMETEXT Text */
xy=VpItem(window,'MAXIMUMTIMETEXT','ITEMPOS')
PARSE VAR xy MAXIMUMTIMETEXTxPosition MAXIMUMTIMETEXTyPosition
/* Get item size MAXIMUMTIMETEXT Text */
xy=VpItem(window,'MAXIMUMTIMETEXT','ITEMSIZE')
PARSE VAR xy MAXIMUMTIMETEXTxSize MAXIMUMTIMETEXTySize

/* Get item size MINAMPM Spin Button */
xy=VpItem(window,'MINAMPM','ITEMSIZE')
PARSE VAR xy MINAMPMxSize MINAMPMySize
/* Get item size MAXAMPM Spin Button */
xy=VpItem(window,'MAXAMPM','ITEMSIZE')
PARSE VAR xy MAXAMPMxSize MAXAMPMySize
/*End getting the positions and sizes of the MINIMUMTIMETEXT and MAXIMUMTIMETEXT labels*/



/*Begin setting the positions of the day, month and year Spin Buttons*/
SELECT
	WHEN Setup.Presort_Date_Format = "MM DD YYYY" THEN DO
		DateCheckBoxText = "Create or Save Date (MM DD YYYY)"
		/* Set item value DATECHECKBOX Check Box */
		CALL VpSetItemValue window,'DATECHECKBOX',DateCheckBoxText		
	END	/*Ends "WHEN Setup.Presort_Date_Format = "MM DD YYYY" THEN DO" Section*/

	WHEN Setup.Presort_Date_Format = "DD MM YYYY" THEN DO
		DateCheckBoxText = "Create or Save Date (DD MM YYYY)"
		CALL VpSetItemValue window,'DATECHECKBOX',DateCheckBoxText
		/* Set item position/size MINDAY Spin Button */
		CALL VpItem window,'MINDAY','SETITEMPOS',MINMONTHxPosition,MINDAYyPosition,MINDAYxSize,MINDAYySize
		/* Set item position/size MINMONTH Spin Button */
		CALL VpItem window,'MINMONTH','SETITEMPOS',MINDAYxPosition,MINMONTHyPosition,MINMONTHxSize,MINMONTHySize
		/* Set item position/size MAXDAY Spin Button */
		CALL VpItem window,'MAXDAY','SETITEMPOS',MAXMONTHxPosition,MAXDAYyPosition,MAXDAYxSize,MAXDAYySize
		/* Set item position/size MAXMONTH Spin Button */
		CALL VpItem window,'MAXMONTH','SETITEMPOS',MAXDAYxPosition,MAXMONTHyPosition,MAXMONTHxSize,MAXMONTHySize
	END	/*Ends "WHEN Setup.Presort_Date_Format = "DD MM YYYY" THEN DO" Section*/

	WHEN Setup.Presort_Date_Format = "YYYY MM DD" THEN DO
		DateCheckBoxText = "Create or Save Date (YYYY MM DD)"
		CALL VpSetItemValue window,'DATECHECKBOX',DateCheckBoxText
		/* Set item position/size MINYEAR Spin Button */
		CALL VpItem window,'MINYEAR','SETITEMPOS',MINMONTHxPosition,MINYEARyPosition,MINYEARxSize,MINYEARySize
		/* Set item position/size MINMONTH Spin Button */
		CALL VpItem window,'MINMONTH','SETITEMPOS',(MINMONTHxPosition + MINYEARxSize + MINDelta1),MINMONTHyPosition,MINMONTHxSize,MINMONTHySize
		/* Set item position/size MINDAY Spin Button */
		CALL VpItem window,'MINDAY','SETITEMPOS',(MINMONTHxPosition + MINYEARxSize + MINDelta1 + MINMONTHxSize + MINDelta2),MINDAYyPosition,MINDAYxSize,MINDAYySize
		/* Set item position/size MAXYEAR Spin Button */
		CALL VpItem window,'MAXYEAR','SETITEMPOS',MAXMONTHxPosition,MAXYEARyPosition,MAXYEARxSize,MAXYEARySize
		/* Set item position/size MAXMONTH Spin Button */
		CALL VpItem window,'MAXMONTH','SETITEMPOS',(MAXMONTHxPosition + MAXYEARxSize + MAXDelta1),MAXMONTHyPosition,MAXMONTHxSize,MAXMONTHySize
		/* Set item position/size MAXDAY Spin Button */
		CALL VpItem window,'MAXDAY','SETITEMPOS',(MAXMONTHxPosition + MAXYEARxSize + MAXDelta1 + MAXMONTHxSize + MAXDelta2),MAXDAYyPosition,MAXDAYxSize,MAXDAYySize
	END	/*Ends "WHEN Setup.Presort_Date_Format = "YYYY MM DD" THEN DO" Section*/

	OTHERWISE NOP
END	/*Ends "SELECT" Section*/



/*Begin setting the text for the TIMECHECKBOX and the ranges for the hours, minutes and seconds Spin Boxes*/
SELECT
	WHEN Setup.Presort_Time_Format = "HH MM SS AMPM" THEN DO
		TimeCheckBoxText = "Create or Save Time (HH MM SS AM/PM)"
		/* Set item value TIMECHECKBOX Check Box */
		CALL VpSetItemValue window,'TIMECHECKBOX',TimeCheckBoxText
		/* Set range MINHOURS Spin Button */
		CALL VpSetRange window,'MINHOURS',1,12  /* Set spin button range*/
		/* Set range MAXHOURS Spin Button */
		CALL VpSetRange window,'MAXHOURS',1,12  /* Set spin button range*/
		/* Set range MINAMPM Spin Button */
		CALL VpSetRange window,'MINAMPM',1,2   /*Set spin button range*/
		/* Set range MAXAMPM Spin Button */
		CALL VpSetRange window,'MAXAMPM',1,2   /*Set spin button range*/
		IF PresentHours > 12 THEN DO
			PresentHours = (PresentHours - 12)
			PresentAMPM = "PM"
		END	/*Ends "IF PresentHours > 12 THEN DO" Section*/
		ELSE PresentAMPM = "AM"
		IF PresentHours = 0 THEN PresentHours = 12
	END	/*Ends "WHEN Setup.Presort_Time_Format = "HH MM SS AMPM" THEN DO" Section*/

	WHEN Setup.Presort_Time_Format = "HH MM SS" THEN DO
		TimeCheckBoxText = "Create or Save Time (HH MM SS)"
		/* Set item value TIMECHECKBOX Check Box */
		CALL VpSetItemValue window,'TIMECHECKBOX',TimeCheckBoxText
		/* Set range MINHOURS Spin Button */
		CALL VpSetRange window,'MINHOURS',0,23  /* Set spin button range*/
		/* Set range MAXHOURS Spin Button */
		CALL VpSetRange window,'MAXHOURS',0,23  /* Set spin button range*/
		/* Hide item MINAMPM Spin Button */
		CALL VpItem window,'MINAMPM','HIDE'
		/* Hide item MAXAMPM Spin Button */
		CALL VpItem window,'MAXAMPM','HIDE'
		/* Hide item MINAMPMENTRY Entry Field */
		CALL VpItem window,'MINAMPMENTRY','HIDE'
		/* Hide item MAXAMPMENTRY Entry Field */
		CALL VpItem window,'MAXAMPMENTRY','HIDE'
		/* Set item position/size MINIMUMTIMETEXT Text */
		CALL VpItem window,'MINIMUMTIMETEXT','SETITEMPOS',(MINIMUMTIMETEXTxPosition - MINAMPMxSize/2),MINIMUMTIMETEXTyPosition,MINIMUMTIMETEXTxSize,MINIMUMTIMETEXTySize
		/* Set item position/size MAXIMUMTIMETEXT Text */
		CALL VpItem window,'MAXIMUMTIMETEXT','SETITEMPOS',(MAXIMUMTIMETEXTxPosition - MAXAMPMxSize/2),MAXIMUMTIMETEXTyPosition,MAXIMUMTIMETEXTxSize,MAXIMUMTIMETEXTySize
	END	/*Ends "WHEN Setup.Presort_Time_Format = "HH MM SS" THEN DO" Section*/

	OTHERWISE NOP
END	/*Ends "SELECT" Section*/
/* Set range MINMINUTES Spin Button */
CALL VpSetRange window,'MINMINUTES',0,59  /* Set spin button range*/
/* Set range MINSECONDS Spin Button */
CALL VpSetRange window,'MINSECONDS',0,59  /* Set spin button range*/
/* Set range MAXMINUTES Spin Button */
CALL VpSetRange window,'MAXMINUTES',0,59  /* Set spin button range*/
/* Set range MAXSECONDS Spin Button */
CALL VpSetRange window,'MAXSECONDS',0,59  /* Set spin button range*/
/*End setting the text for the TIMECHECKBOX and the ranges for the hours, minutes and seconds Spin Boxes*/



/*Begin setting the ranges for the month, day and year Spin Buttons*/
/* Set range MINMONTH Spin Button */
CALL VpSetRange window,'MINMONTH',1,12  /* Set spin button range*/
/* Set range MINDAY Spin Button */
CALL VpSetRange window,'MINDAY',1,31  /* Set spin button range*/
/* Set range MINYEAR Spin Button */
CALL VpSetRange window,'MINYEAR',0,10000  /* Set spin button range*/
/* Set range MAXMONTH Spin Button */
CALL VpSetRange window,'MAXMONTH',1,12  /* Set spin button range*/
/* Set range MAXDAY Spin Button */
CALL VpSetRange window,'MAXDAY',1,31  /* Set spin button range*/
/* Set range MAXYEAR Spin Button */
CALL VpSetRange window,'MAXYEAR',0,10000  /* Set spin button range*/
/*Begin setting the ranges for the month, day and year Spin Buttons*/



/*Begin unchecking the DATECHECKBOX and hiding the month, day and year Spin Buttons*/
/* Uncheck the item DATECHECKBOX Check Box */
CALL VpSelect window,'DATECHECKBOX',0

/* Set item value MINMONTH Spin Button */
CALL VpSetItemValue window,'MINMONTH',TodayMonth
/* Set item value MINDAY Spin Button */
CALL VpSetItemValue window,'MINDAY',TodayDay
/* Set item value MINYEAR Spin Button */
CALL VpSetItemValue window,'MINYEAR',TodayYear
/* Hide item MINMONTH Spin Button */
CALL VpItem window,'MINMONTH','HIDE'
/* Hide item MINDAY Spin Button */
CALL VpItem window,'MINDAY','HIDE'
/* Hide item MINYEAR Spin Button */
CALL VpItem window,'MINYEAR','HIDE'

/* Set item value MAXMONTH Spin Button */
CALL VpSetItemValue window,'MAXMONTH',TodayMonth
/* Set item value MAXDAY Spin Button */
CALL VpSetItemValue window,'MAXDAY',TodayDay
/* Set item value MAXYEAR Spin Button */
CALL VpSetItemValue window,'MAXYEAR',TodayYear
/* Hide item MAXMONTH Spin Button */
CALL VpItem window,'MAXMONTH','HIDE'
/* Hide item MAXDAY Spin Button */
CALL VpItem window,'MAXDAY','HIDE'
/* Hide item MAXYEAR Spin Button */
CALL VpItem window,'MAXYEAR','HIDE'
/*End unchecking the DATECHECKBOX and hiding the month, day and year Spin Buttons*/



/*Begin unchecking the TIMECHECKBOX and hiding the hours, minutes, seconds and AMPM Spin Buttons*/
/* Uncheck the item TIMECHECKBOX Check Box */
CALL VpSelect window,'TIMECHECKBOX',0

/* Set item value MINHOURS Spin Button */
CALL VpSetItemValue window,'MINHOURS',PresentHours
PriorMinHours = PresentHours
/* Set item value MINMINUTES Spin Button */
CALL VpSetItemValue window,'MINMINUTES',PresentMinutes
PriorMinMinutes = PresentMinutes
/* Set item value MINSECONDS Spin Button */
CALL VpSetItemValue window,'MINSECONDS',PresentSeconds
PriorMinSeconds = PresentSeconds
IF PresentAMPM = "AM" THEN DO
	PriorMinAMPM = 1
	PriorMinAMPMEntry = "AM"
END	/*Ends "IF PresentAMPM = "AM" THEN DO" Section*/
ELSE DO
	PriorMinAMPM = 2
	PriorMinAMPMEntry = "PM"
END	/*Ends "ELSE DO" Section*/

/* Set item value MAXHOURS Spin Button */
CALL VpSetItemValue window,'MAXHOURS',PresentHours
PriorMaxHours = PresntHours
/* Set item value MAXMAXUTES Spin Button */
CALL VpSetItemValue window,'MAXMINUTES',PresentMinutes
PriorMaxMinutes = PresentMinutes
/* Set item value MAXSECONDS Spin Button */
CALL VpSetItemValue window,'MAXSECONDS',PresentSeconds
PriorMaxSeconds = PresentSeconds
IF PresentAMPM = "AM" THEN DO
	PriorMaxAMPM = 1
	PriorMaxAMPMEntry = "AM"
END	/*Ends "IF PresentAMPM = "AM" THEN DO" Section*/
ELSE DO
	PriorMaxAMPM = 2
	PriorMaxAMPMEntry = "PM"
END	/*Ends "ELSE DO" Section*/

IF Setup.Presort_Time_Format = "HH MM SS AMPM" THEN DO
	SELECT
		WHEN PresentAMPM = "AM" THEN DO
			/* Set item value MINAMPM Spin Button */
			Setvalue = 1
			CALL VpSetItemValue window,'MINAMPM',Setvalue
			/* Set item value MAXAMPM Spin Button */
			CALL VpSetItemValue window,'MAXAMPM',1
			/* Set item value MINAMPMENTRY Entry Field */
			CALL VpSetItemValue window,'MINAMPMENTRY',"AM"
			/* Set item value MAXAMPMENTRY Entry Field */
			CALL VpSetItemValue window,'MAXAMPMENTRY',"AM"
		END	/*Ends "WHEN PresentAMPM = "AM" THEN DO" Section*/

		WHEN PresentAMPM = "PM" THEN DO
			/* Set item value MINAMPM Spin Button */
			CALL VpSetItemValue window,'MINAMPM',2
			/* Set item value MAXAMPM Spin Button */
			CALL VpSetItemValue window,'MAXAMPM',2
			/* Set item value MINAMPMENTRY Entry Field */
			CALL VpSetItemValue window,'MINAMPMENTRY',"PM"
			/* Set item value MAXAMPMENTRY Entry Field */
			CALL VpSetItemValue window,'MAXAMPMENTRY',"PM"
		END	/*Ends "WHEN PresentAMPM = "PM" THEN DO" Section*/

		OTHERWISE NOP
	END	/*Ends "SELECT" Section*/
END	/*Ends "IF Setup.Presort_Time_Format = "HH MM SS AMPM" THEN DO" Section*/

/* Hide item MINHOURS Spin Button */
CALL VpItem window,'MINHOURS','HIDE'
/* Hide item MINMINUTES Spin Button */
CALL VpItem window,'MINMINUTES','HIDE'
/* Hide item MINSECONDS Spin Button */
CALL VpItem window,'MINSECONDS','HIDE'
/* Hide item MINAMPM Spin Button */
CALL VpItem window,'MINAMPM','HIDE'
/* Hide item MINAMPMENTRY Entry Field */
CALL VpItem window,'MINAMPMENTRY','HIDE'

/* Hide item MAXHOURS Spin Button */
CALL VpItem window,'MAXHOURS','HIDE'
/* Hide item MAXMINUTES Spin Button */
CALL VpItem window,'MAXMINUTES','HIDE'
/* Hide item MAXSECONDS Spin Button */
CALL VpItem window,'MAXSECONDS','HIDE'
/* Hide item MAXAMPM Spin Button */
CALL VpItem window,'MAXAMPM','HIDE'
/* Hide item MAXAMPMENTRY Entry Field */
CALL VpItem window,'MAXAMPMENTRY','HIDE'
/*End unchecking the TIMECHECKBOX and hiding the hours, minutes, seconds and AMPM Spin Buttons*/



/*Begin unchecking the Attributes checkbox and hiding all the attribute objects*/
/* Set item value ATTRIBUTES Entry Field */
CALL VpSetItemValue window,'ATTRIBUTES',AttributesMask
/* Uncheck the item SETARCHIVE Radio Button */
CALL VpSelect window,'SETARCHIVE',0
/* Uncheck the item CLEARARCHIVE Radio Button */
CALL VpSelect window,'CLEARARCHIVE',0
/* Uncheck the item SETDIRECTORY Radio Button */
CALL VpSelect window,'SETDIRECTORY',0
/* Uncheck the item CLEARDIRECTORY Radio Button */
CALL VpSelect window,'CLEARDIRECTORY',0
/* Uncheck the item SETHIDDEN Radio Button */
CALL VpSelect window,'SETHIDDEN',0
/* Uncheck the item CLEARHIDDEN Radio Button */
CALL VpSelect window,'CLEARHIDDEN',0
/* Uncheck the item SETREADONLY Radio Button */
CALL VpSelect window,'SETREADONLY',0
/* Uncheck the item CLEARREADONLY Radio Button */
CALL VpSelect window,'CLEARREADONLY',0
/* Uncheck the item SETSYSTEM Radio Button */
CALL VpSelect window,'SETSYSTEM',0
/* Uncheck the item CLEARSYSTEM Radio Button */
CALL VpSelect window,'CLEARSYSTEM',0

/* Hide item ATTRIBUTES Entry Field */
CALL VpItem window,'ATTRIBUTES','HIDE'
/* Hide item SETARCHIVE Radio Button */
CALL VpItem window,'SETARCHIVE','HIDE'
/* Hide item CLEARARCHIVE Radio Button */
CALL VpItem window,'CLEARARCHIVE','HIDE'
/* Hide item SETDIRECTORY Radio Button */
CALL VpItem window,'SETDIRECTORY','HIDE'
/* Hide item CLEARDIRECTORY Radio Button */
CALL VpItem window,'CLEARDIRECTORY','HIDE'
/* Hide item SETHIDDEN Radio Button */
CALL VpItem window,'SETHIDDEN','HIDE'
/* Hide item CLEARHIDDEN Radio Button */
CALL VpItem window,'CLEARHIDDEN','HIDE'
/* Hide item SETREADONLY Radio Button */
CALL VpItem window,'SETREADONLY','HIDE'
/* Hide item CLEARREADONLY Radio Button */
CALL VpItem window,'CLEARREADONLY','HIDE'
/* Hide item SETSYSTEM Radio Button */
CALL VpItem window,'SETSYSTEM','HIDE'
/* Hide item CLEARSYSTEM Radio Button */
CALL VpItem window,'CLEARSYSTEM','HIDE'
/*End unchecking the Attributes checkbox and hiding all the attribute objects*/



/* Disable item CONTINUE Push Button */
CALL VpItem window,'CONTINUE','DISABLE'
MinTime_Semaphore = 0
MaxTime_Semaphore = 1
return

/* ##259_1001.0 */
259_1001.0: /* Event Show from one file at a time (se SELECTONEFILE, Clicked/selected */
Arg window self



/* Get button state SELECTONEFILE Radio Button */
Flag = VpIsSelected(window,'SELECTONEFILE')



SELECT
	WHEN Flag = 1 THEN DO
		/*Begin unchecking all items in the RESULTINGFILELIST List Box, if this is the initial selection of the SELECTONEFILE radio button*/
		IF SelectOneFileFlag = 0 THEN DO
			/* Unselect all items RESULTINGFILELIST List Box */
			CALL VpSelect window,'RESULTINGFILELIST','ALL',0
			Index = 0
		END	/*Ends "IF SelectOneFileFlag = 0 THEN DO" Section*/
		/*End unchecking all items in the RESULTINGFILELIST List Box*/

		ELSE DO
			/* Get index of first selected item RESULTINGFILELIST List Box */
			Index=VpGetIndex(window,'RESULTINGFILELIST','SELECTED',0)
			/* Unselect all items RESULTINGFILELIST List Box */
			CALL VpSelect window,'RESULTINGFILELIST','ALL',0
		END	/*Ends "ELSE DO" Section*/


		/*Begin selecting the next file in the RESULTINGFILELIST List Box, if this is the initial selection of the SELECTONEFILE radio button*/
		SELECT
			WHEN Index = 0 | Index < ScanFilePathResults.0 THEN Index = Index + 1

			WHEN Index = ScanFilePathResults.0 THEN Index = 1

			OTHERWISE NOP
		END	/*Ends "SELECT" Section*/

		/* Select item RESULTINGFILELIST List Box */
		CALL VpSelect window,'RESULTINGFILELIST',Index,1
		/*End selecting the next file in the RESULTINGFILELIST List Box*/

		/*Begin showing the lines in the selected resulting file that contain the search text*/
		/* Delete all items SCANRESULTS List Box */
		CALL VpDeleteItem window,'SCANRESULTS','ALL'
		M = Index

		SELECT
			WHEN SelectedOtherServices = "SCANTEXT" & ScanLineResults.M.0 = 1 THEN
			FirstLine = "The "FileType.M" file, "ScanFileNameResults.M", has "ScanLineResults.M.0" occurrence of the desired text (below):"

			WHEN SelectedOtherServices = "SCANTEXT" & ScanLineResults.M.0 > 1 THEN
			FirstLine = "The "FileType.M" file, "ScanFileNameResults.M", has "ScanLineResults.M.0" occurrences of the desired text (below):"

			WHEN SelectedOtherServices = "SCANEA" THEN
			FirstLine = "The file, "ScanFileNameResults.M", has one or more extended attributes:"

			OTHERWISE NOP
		END	/*Ends "SELECT" Section*/

		SELECT
			WHEN SelectedOtherServices = "SCANTEXT" | SelectedOtherServices = "SCANEA" THEN DO
				/* Add an item at beginning SCANRESULTS List Box */
				IndexItem=VpAddItem(window, 'SCANRESULTS', 'BEGIN', FirstLine)
				DO N = 1 TO ScanLineResults.M.0 BY 1
					/* Add an item after an item SCANRESULTS List Box */
					IndexItem=VpAddItem(window, 'SCANRESULTS', IndexItem, ScanLineResults.M.N)
				END	/*Ends "DO N = 1 TO ScanLineResults.M.0 BY 1" Section*/
				/*End showing the lines in the selected resulting file that contain the search text*/
			END	/*Ends "WHEN SelectedOtherServices = "SCANTEXT" | SelectedOtherServices = "SCANEA" THEN DO" Section*/

			WHEN SelectedOtherServices = "COMPAREFILES" THEN DO
				/* Add an item at beginning SCANRESULTS List Box */
				IndexItem=VpAddItem(window, 'SCANRESULTS', 'BEGIN', ScanLineResults.M.1)
				DO N = 2 TO ScanLineResults.M.0 BY 1
					/* Add an item after an item SCANRESULTS List Box */
					IndexItem=VpAddItem(window, 'SCANRESULTS', IndexItem, ScanLineResults.M.N)
				END	/*Ends "DO N = 2 TO ScanLineResults.M.0 BY 1" Section*/
				/*End showing the lines in the selected files that do not compare*/
			END	/*Ends "WHEN SelectedOtherServices = "COMPAREFILES" THEN DO" Section*/

			OTHERWISE NOP
		END	/*Ends "SELECT" Section*/

		/*Begin setting the SelectOneFileFlag variable*/
		SelectOneFileFlag = 1
		/*End setting the SelectOneFileFlag variable*/
	END	/*Ends "WHEN Flag = 1 THEN DO" Section*/

	OTHERWISE NOP
END	/*Ends "SELECT" Section*/
return

/* ##259_1002.0 */
259_1002.0: /* Event Show all of it (select all the f SELECTALLFILES, Clicked/selected */
Arg window self



/*Begin deselecting all the search text matching lines shown int the SCANRESULTS List Box, if any*/
/* Unselect all items SCANRESULTS List Box */
CALL VpSelect window,'SCANRESULTS','ALL',0
/*End deselecting all the search text matching lines shown int the SCANRESULTS List Box, if any*/



/*Begin selecting all of the files in the RESULTINGFILELIST List Box*/
/* Select all items RESULTINGFILELIST List Box */
CALL VpSelect window,'RESULTINGFILELIST','ALL',1
/*End selecting all of the files in the RESULTINGFILELIST List Box*/



/*Begin showing the lines in each resulting file that contain the search text*/
/* Uncheck the item SELECTALLFILES Radio Button */
CALL VpSelect window,'SELECTALLFILES',0
LineFiller = " ****    ****    ****    ****"
DO M = 1 TO ScanFilePathResults.0 BY 1
	SELECT
		WHEN SelectedOtherServices = "SCANTEXT" & ScanLineResults.M.0 = 1 THEN
		FirstLine = "The "FileType.M" file, "ScanFileNameResults.M", has "ScanLineResults.M.0" occurrence of the desired text (below):"

		WHEN SelectedOtherServices = "SCANTEXT" & ScanLineResults.M.0 > 1 THEN
		FirstLine = "The "FileType.M" file, "ScanFileNameResults.M", has "ScanLineResults.M.0" occurrences of the desired text (below):"

		WHEN SelectedOtherServices = "SCANEA" THEN
		FirstLine = "The file, "ScanFileNameResults.M", has one or more extended attributes:"

		OTHERWISE NOP
	END	/*Ends "SELECT" Section*/


	SELECT
		WHEN M = 1 THEN DO
			SELECT
				WHEN SelectedOtherServices = "SCANTEXT" | SelectedOtherServices = "SCANEA" THEN DO
					IndexItem=VpAddItem(window, 'SCANRESULTS', 'BEGIN', FirstLine)
					IF ScanLineResults.M.0 > 0 THEN DO
						DO N = 1 TO ScanLineResults.M.0 BY 1
							/* Add an item after an item SCANRESULTS List Box */
							IndexItem=VpAddItem(window, 'SCANRESULTS', IndexItem, ScanLineResults.M.N)
						END N	/*Ends "DO N = 1 TO ScanLineResults.M.0 BY 1" Section*/
					END	/*Ends "IF ScanLineResults.M.0 > 0 THEN DO" Section*/
				END	/*Ends "WHEN SelectedOtherServices = "SCANTEXT" | SelectedOtherServices = "SCANEA" THEN DO" Section*/

				WHEN SelectedOtherServices = "COMPAREFILES" THEN DO
					IndexItem=VpAddItem(window, 'SCANRESULTS', 'BEGIN', ScanLineResults.M.1)
					IF ScanLineResults.M.0 > 0 THEN DO
						DO N = 2 TO ScanLineResults.M.0 BY 1
							/* Add an item after an item SCANRESULTS List Box */
							IndexItem=VpAddItem(window, 'SCANRESULTS', IndexItem, ScanLineResults.M.N)
						END N	/*Ends "DO N = 1 TO ScanLineResults.M.0 BY 1" Section*/
					END	/*Ends "IF ScanLineResults.M.0 > 0 THEN DO" Section*/

				END	/*Ends "WHEN SelectedOtherServices = "COMPAREFILES" THEN DO" Section*/

				OTHERWISE NOP
			END	/*Ends "SELECT" Section*/
		END	/*Ends "WHEN M = 1 THEN DO" Section*/


		OTHERWISE DO
			/*Begin adding 2 blank lines + the FirstLine text at the beginning of the results of each file for all files after the first one*/
			IndexItem=VpAddItem(window, 'SCANRESULTS', IndexItem, LineFiller)
			IndexItem=VpAddItem(window, 'SCANRESULTS', IndexItem, LineFiller)
			SELECT
				WHEN SelectedOtherServices = "SCANTEXT" | SelectedOtherServices = "SCANEA" THEN DO
					IndexItem=VpAddItem(window, 'SCANRESULTS', IndexItem, FirstLine)
					NextIndex = 1
				END	/*Ends "WHEN SelectedOtherServices = "SCANTEXT" | SelectedOtherServices = "SCANEA" THEN DO" Section*/

				WHEN SelectedOtherServices = "COMPAREFILES" THEN DO
					IndexItem=VpAddItem(window, 'SCANRESULTS', IndexItem, ScanLineResults.M.1)
					NextIndex = 2
				END	/*Ends "WHEN SelectedOtherServices = "COMPAREFILES" THEN DO" Section*/
					
				OTHERWISE NOP
			END	/*Ends "SELECT" Section*/
			/*End adding 2 blank lines + the FirstLine text at the beginning of the results of each file for all files after the first one*/

			DO N = NextIndex TO ScanLineResults.M.0 BY 1
				IndexItem=VpAddItem(window, 'SCANRESULTS', IndexItem, ScanLineResults.M.N)
			END N	/*Ends "DO N = 1 TO ScanLineResults.M.0 BY 1" Section*/
		END	/*Ends "OTHERWISE DO" Section*/
	END	/*Ends "SELECT" Section*/
END M	/*Ends DO M = 1 to ScanLineResults.M.0 BY 1*/
/*End showing the lines in each resulting file that contain the search text*/



/*Begin setting the SelectOneFileFlag variable*/
SelectOneFileFlag = 0
/*End setting the SelectOneFileFlag variable*/
return

/* ##259_1003.0 */
259_1003.0: /* Event Show nothing (deselect all the f DESELECTALLFILES, Clicked/selected */
Arg window self



/*Begin deselecting all files in the RESULTINGFILELIST List Box and deleting all search matching text in the SCANRESULTS List Box*/
/* Unselect all items RESULTINGFILELIST List Box */
CALL VpSelect window,'RESULTINGFILELIST','ALL',0
/* Delete all items SCANRESULTS List Box */
CALL VpDeleteItem window,'SCANRESULTS','ALL'
/*End deselecting all files in the RESULTINGFILELIST List Box and deleting all search matching text in the SCANRESULTS List Box*/



/*Begin setting the SelectOneFileFlag variable and unchecking radio buttons*/
SelectOneFileFlag = 0
/* Uncheck the item SELECTONEFILE Radio Button */
CALL VpSelect window,'SELECTONEFILE',0
/* Uncheck the item DESELECTALLFILES Radio Button */
CALL VpSelect window,'DESELECTALLFILES',0
/*End setting the SelectOneFileFlag variable and unchecking radio buttons*/
return

/* ##259_1005.0 */
259_1005.0: /* Event Return to the "Other Services" D RETURNRADIOBUTTON, Clicked/selected */
Arg window self



/* Get button state RETURNRADIOBUTTON Radio Button */
CancelTextScanFlag = VpIsSelected(window,'RETURNRADIOBUTTON')
IF CancelTextScanFlag = 1 THEN DO
	/* Uncheck the item RETURNRADIOBUTTON Radio Button */
	CALL VpSelect window,'RETURNRADIOBUTTON',0
	Cancel = "CANCELTEXTSCAN"
	CALL VpNotify window,Cancel
	CALL VpWindow window,'CLOSE'
END	/*Ends "IF CancelServicesFlag = 1 THEN DO" Section*/
return

/* ##259_1006.0 */
259_1006.0: /* Event List Box RESULTINGFILELIST, Clicked/selected */
Arg window self



/*Begin determining whether or not the SELECTONEFILE radio button was clicked and what to do about it*/
ResultingFileListCycleFlag = ResultingFileListCycleFlag + 1
/* Get button state SELECTONEFILE Radio Button */
Flag = VpIsSelected(window,'SELECTONEFILE')
SELECT
	WHEN Flag = 1 & ResultingFileListCycleFlag < 2 THEN DO
		/* Uncheck the item SELECTONEFILE Radio Button */
		CALL VpSelect window,'SELECTONEFILE',0
		SIGNAL ENDRESULTINGFILELIST
	END	/*Ends "WHEN Flag = 1 & ResultingFileListCycleFlag < 2 THEN DO" Section*/

	WHEN ResultingFileListCycleFlag = 2 THEN DO
		/* Uncheck the item SELECTONEFILE Radio Button */
		CALL VpSelect window,'SELECTONEFILE',0
		ResultingFileListCycleFlag = 0
		SIGNAL ENDRESULTINGFILELIST
	END	/*Ends "WHEN ResultingFileListCycleFlag = 2 THEN DO" Section*/

	OTHERWISE ResultingFileListCycleFlag = 0
END	/*Ends "SELECT" Section*/
/*End determining whether or not the SELECTONEFILE radio button was clicked and what to do about it*/



/*Begin finding the indices of all the selected files in the RESULTINGFILELIST List Box*/
/* Get indexes of all selected items RESULTINGFILELIST List Box */
CALL VpGetIndex window,'RESULTINGFILELIST','ALLSELECTED','INDEXES.'
Index. = ""
IF INDEXES.0 > 0 THEN DO
	DO J = 0 TO INDEXES.0 BY 1
		Index.J = INDEXES.J
	END J	/*Ends "DO J = 0 TO INDEXES.0 BY 1" Section*/
END	/*Ends "IF INDEXES.0 > 0 THEN DO" Section*/
ELSE Index.0 = INDEXES.0
/*End finding the indices of all the selected files in the RESULTINGFILELIST List Box*/



/*Begin showing the lines in the selected files that contain the search text*/
/* Delete all items SCANRESULTS List Box */
CALL VpDeleteItem window,'SCANRESULTS','ALL'
LineFiller = " ****    ****    ****    ****"

SELECT
	WHEN Index.0 > 0 THEN DO
		DO M = 1 TO Index.0 BY 1
			J = Index.M
			SELECT
				WHEN SelectedOtherServices = "SCANTEXT" & ScanLineResults.J.0 = 1 THEN
				FirstLine = "The "FileType.J" file, "ScanFileNameResults.J", has "ScanLineResults.J.0" occurrence of the desired text (below):"

				WHEN SelectedOtherServices = "SCANTEXT" & ScanLineResults.J.0 > 1 THEN
				FirstLine = "The "FileType.J" file, "ScanFileNameResults.J", has "ScanLineResults.J.0" occurrences of the desired text (below):"

				WHEN SelectedOtherServices = "SCANEA" THEN
				FirstLine = "The file, "ScanFileNameResults.J", has the one or more extended attributes:"

				OTHERWISE NOP
			END	/*Ends "SELECT" Section*/

			/* Add an item at beginning SCANRESULTS List Box */
			IF M > 1 THEN DO
				/*Begin adding 2 blank lines + the FirstLine text at the beginning of the results of each file for all files after the first one*/
				IndexItem=VpAddItem(window, 'SCANRESULTS', IndexItem, LineFiller)
				IndexItem=VpAddItem(window, 'SCANRESULTS', IndexItem, LineFiller)
				IndexItem=VpAddItem(window, 'SCANRESULTS', IndexItem, FirstLine)
			END	/*Ends "IF M > 1 THEN DO" Section*/
			ELSE DO
				IndexItem=VpAddItem(window, 'SCANRESULTS', 'BEGIN', FirstLine)
				NOP
			END	/*Ends "ELSE DO" Section*/
			/*End adding 2 blank lines + the FirstLine text at the beginning of the results of each file for all files after the first one*/

			DO N = 1 TO ScanLineResults.J.0 BY 1
				/* Add an item after an item SCANRESULTS List Box */
				IndexItem=VpAddItem(window, 'SCANRESULTS', IndexItem, ScanLineResults.J.N)
			END	/*Ends "DO N = 1 TO ScanLineResults.J.0 BY 1" Section*/
		END	/*Ends "DO M = 1 TO Index.0 BY 1" Section*/
	END	/*Ends "WHEN Index.0 > 0 THEN DO" Section*/

	OTHERWISE NOP
END	/*Ends "SELECT" Section*/
/*End showing the lines in the selected files that contain the search text*/



/*Begin setting the SelectOneFileFlag variable*/
SelectOneFileFlag = 0
ENDRESULTINGFILELIST:
/*End setting the SelectOneFileFlag variable*/
return

/* ##259_1008.0 */
259_1008.0: /* Event Do Another DOANOTHER, Clicked/selected */
Arg window self



Another = "ANOTHER"
CALL VpNotify window,Another
CALL VpWindow window,'CLOSE'
return

/* ##259_1009.0 */
259_1009.0: /* Event End Program ENDPROGRAM, Clicked/selected */
Arg window self



EndProgram = "END PROGRAM"
CALL VpNotify window,EndProgram
CALL VpWindow window,'CLOSE'
return

/* ##259_1010.0 */
259_1010.0: /* Event Copy the resulting file tree dat COPYTOCLIPBOARDRADIOBUTTON, Clicked/selected */
Arg window self



/* Get button state COPYTOCLIPBOARDRADIOBUTTON Radio Button */
StateFlag = VpIsSelected(window,'COPYTOCLIPBOARDRADIOBUTTON')
IF StateFlag = 1 & ScanFilePathResults.0 > 0 THEN DO
SELECT
	WHEN ScanFilePathResults.0 = 1 THEN DO
		Clipboard = ScanSysFileTreeResults.1
		CALL VpWindow window,'SETCLIPBOARD','TEXT',Clipboard
	END	/*Ends "WHEN ScanFilePathResults.0 = 1 THEN DO" Section*/

	WHEN ScanFilePathResults.0 > 1 THEN DO
		NewLineCount = 1
		NewLine = CHARIN(ProgramLocation"\SubProcs\ADDLINE",,NewLineCount)
		RC = LINEOUT(ProgramLocation"\SubProcs\ADDLINE")
		Clipboard = ""
		End = ScanFilePathResults.0 - 1
		DO J = 1 TO End BY 1
			Clipboard = Clipboard||ScanSysFileTreeResults.J||NewLine
		END J	/*Ends "DO J = 1 TO End BY 1" Section*/
		Clipboard = Clipboard||ScanSysFileTreeResults.J
		CALL VpWindow window,'SETCLIPBOARD','TEXT',Clipboard
	END	/*Ends "WHEN ScanFilePathResults.0 > 1 THEN DO" Section*/

	OTHERWISE NOP
END	/*Ends "SELECT" Section*/


CopyToClipBoardRadioButtonText = "The resulting file tree data has been copied to the clipboard"
/* Set item value COPYTOCLIPBOARDRADIOBUTTON Radio Button */
CALL VpSetItemValue window,'COPYTOCLIPBOARDRADIOBUTTON',CopyToClipBoardRadioButtonText
RC = .Timing~Delay(2.0)
CopyToClipBoardRadioButtonText = "Copy the resulting file tree data to the clipboard"
/* Set item value COPYTOCLIPBOARDRADIOBUTTON Radio Button */
CALL VpSetItemValue window,'COPYTOCLIPBOARDRADIOBUTTON',CopyToClipBoardRadioButtonText

/* Uncheck the item COPYTOCLIPBOARDRADIOBUTTON Radio Button */
CALL VpSelect window,'COPYTOCLIPBOARDRADIOBUTTON',0
END	/*Ends "IF StateFlag = 1 & ScanFilePathResults.0 > 0 THEN DO" Section*/
return

/* ##259_Form.1 */
259_Form.1: /* Event Form events, Opened */
Arg window




/*Begin getting the initial positions and sizes of the RESULTINGFILELIST and SCANRESULTS List Boxes*/
/* Get item position RESULTINGFILELIST List Box */
xy=VpItem(window,'RESULTINGFILELIST','ITEMPOS')
PARSE VAR xy x y
ResultingFileList_xPosition = x
ResultingFileList_yPosition = y
/* Get item size RESULTINGFILELIST List Box */
xy=VpItem(window,'RESULTINGFILELIST','ITEMSIZE')
PARSE VAR xy x y
ResultingFileList_xSize = x
ResultingFileList_ySize = y


/* Get item position SCANRESULTS List Box */
xy=VpItem(window,'SCANRESULTS','ITEMPOS')
PARSE VAR xy x y
ScanResults_xPosition = x
ScanResults_yPosition = y
/* Get item size SCANRESULTS List Box */
xy=VpItem(window,'SCANRESULTS','ITEMSIZE')
PARSE VAR xy x y
ScanResults_xSize = x
ScanResults_ySize = y
/*End getting the initial positions and sizes of the RESULTINGFILELIST and SCANRESULTS List Boxes*/



/*Begin establishing the inital set up of the Text Scan Dialog*/
/* Uncheck the item RETURNRADIOBUTTON Radio Button */
CALL VpSelect window,'RETURNRADIOBUTTON',0
/* Uncheck the item SELECTONEFILE Radio Button */
CALL VpSelect window,'SELECTONEFILE',0
/* Uncheck the item SELECTALLFILES Radio Button */
CALL VpSelect window,'SELECTALLFILES',0
/* Uncheck the item DESELECTALLFILES Radio Button */
CALL VpSelect window,'DESELECTALLFILES',0
/* Uncheck the item COPYTOCLIPBOARDRADIOBUTTON Radio Button */
CALL VpSelect window,'COPYTOCLIPBOARDRADIOBUTTON',0

/* Delete all items RESULTINGFILELIST List Box */
CALL VpDeleteItem window,'RESULTINGFILELIST','ALL'
/* Delete all items SCANRESULTS List Box */
CALL VpDeleteItem window,'SCANRESULTS','ALL'
/* Enable item DOANOTHER Push Button */
/* Show item DOANOTHER Push Button */
CALL VpItem window,'DOANOTHER','SHOW'
CALL VpItem window,'DOANOTHER','ENABLE'
/* Enable item ENDPROGRAM Push Button */
CALL VpItem window,'ENDPROGRAM','ENABLE'
/* Show item ENDPROGRAM Push Button */
CALL VpItem window,'ENDPROGRAM','SHOW'
/*End establishing the inital set up of the Text Scan Dialog*/



/*Begin setting the SelectOneFileFlag variable*/
SelectOneFileFlag = 0
/*End setting the SelectOneFileFlag variable*/



/*Begin performing the desired, or selected, other service*/
SELECT
	WHEN SelectedOtherServices = "SCANTEXT" THEN CALL SCANTEXT
	WHEN SelectedOtherServices = "SCANEA" THEN CALL SCANEA
	WHEN SelectedOtherServices = "COMPAREFILES" THEN CALL COMPFILE
	OTHERWISE NOP
END	/*Ends "SELECT" Section*/
/*End performing the desired, or selected, other service*/



/*Begin entering the positive scan results, if any, into the RESULTINGFILELIST list box*/
SELECT
	WHEN ScanFilePathResults.0 > 0 THEN DO
		/* Add an item at beginning RESULTINGFILELIST List Box */
		index=VpAddItem(window, 'RESULTINGFILELIST', 'BEGIN', ScanFilePathResults.1)
		IF ScanFilePathResults.0 > 1 THEN DO
			DO M = 2 TO ScanFilePathResults.0 BY 1
				Index = M - 1
				/* Add an item after an item RESULTINGFILELIST List Box */
				Index=VpAddItem(window, 'RESULTINGFILELIST', Index, ScanFilePathResults.M)
			END M	/*End "DO M = 2 TO ScanFilePathResults.0 BY 1" Section*/

			SELECT
				WHEN SelectedOtherServices = "SCANTEXT" THEN
				FileResultsText = "The following "ScanFilePathResults.0" files contain the desired string text:"

				WHEN SelectedOtherServices = "SCANEA" THEN
				FileResultsText = "The following "ScanFilePathResults.0" files contain extended attributes:"

				WHEN SelectedOtherServices = "COMPAREFILES" THEN DO
					IF ScanFilePathResults.0 = 1 THEN FileResultsText = "The following "ScanFilePathResults.0" text file comparison is made:"
					ELSE FileResultsText = "The following "ScanFilePathResults.0" text file comparisons are made:"
				END	/*Ends "WHEN SelectedOtherServices = "COMPAREFILES" THEN DO" Section*/

				OTHERWISE NOP
			END	/*Ends "SELECT" Section*/
		END	/*End "IF ScanFilePathResults.0 > 1 THEN DO" Section*/

		ELSE DO
			SELECT
				WHEN SelectedOtherServices = "SCANTEXT" THEN
				FileResultsText = "The following file contains the desired string text:"

				WHEN SelectedOtherServices = "SCANEA" THEN
				FileResultsText = "The following file contains extended attributes:"

				WHEN SelectedOtherServices = "COMPAREFILES" THEN DO
					NumberOfFileComparisons = 2*ScanFilePathResults.0
					FileResultsText = "The following "NumberOfFileComparisons" text files contain differences:"
				END	/*Ends "WHEN SelectedOtherServices = "COMPAREFILES" THEN DO" Section*/

				OTHERWISE NOP
			END	/*Ends "SELECT" Section*/
		END	/*Ends "ELSE DO" Section*/
	ResultingFileListCycleFlag = 0
	END	/*Ends "WHEN ScanFilePathResults.0 > 0 THEN DO" Section*/

	OTHERWISE DO
		SELECT
			WHEN SelectedOtherServices = "SCANTEXT" THEN
			FileResultsText = "There are no files that contain the desired string text."

			WHEN SelectedOtherServices = "SCANEA" THEN
			FileResultsText = "There are no extended attributes in the selected file(s)"

			WHEN SelectedOtherServices = "COMPAREFILES" THEN
				FileResultsText = "Sorry, you selected at most only one (1) text file. There are no comparisons to be made!"

			OTHERWISE NOP
		END	/*Ends "SELECT" Section*/
	END	/*Ends "OTHERWISE DO" Section*/
END	/*End "SELECT" Section*/




/* Set item position/size FILERESULTSTEXT Text */
CALL VpSetItemValue window,'FILERESULTSTEXT',FileResultsText
/*End entering the positive scan results, if any, into the RESULTINGFILELIST list box*/
return

/* ##257_1000.16 */
257_1000.16: /* Event List Box LISTSUBDIRECTORIES, Mouse button 1 double click */
Arg window self



/* Get item value LISTSUBDIRECTORIES List Box */
PreviousLevel = Directory
Directory = VpGetItemValue(window,'LISTSUBDIRECTORIES')
Directory = Directory"\*.*"
IF Directory \= PreviousLevel THEN DO
	PARSE VAR Directory Path "\*.*" Remainder
	RC_LIST_SIZE = ""			
	CALL LISTDOWN
	IF SubdirectoryResults.[0] > 32000 THEN DO
		RC_LIST_SIZE = .IO~DIRECTORY_LIST_SIZE(SubdirectoryResults.[0])
		SIGNAL ENDGOUP
	END	/*End "IF SubdirectoryResults.[0] > 32000 THEN DO" Section*/
END	/*Ends "IF Directory \= PreviousLevel THEN DO" Section*/
UpLevel = "Go up to "PreviousLevel
/* Set item value GOUP Radio Button */
CALL VpSetItemValue window,'GOUP',UpLevel
ENDLISTSUBDIRECTORIES:
SELECT
	WHEN RC_LIST_SIZE = "OK" THEN DO
		Another = "ANOTHER"
		CALL VpNotify window,Another
		CALL VpWindow window,'CLOSE'
	END	/*Ends "WHEN RC_LIST_SIZE = "OK" THEN DO" Section*/

	WHEN RC_LIST_SIZE = "CANCEL" THEN DO
		Cancel = "CANCELLED"
		CALL VpNotify window,Cancel
		CALL VpWindow window,'CLOSE'
		END	/*Ends "WHEN RC = "CANCEL" THEN DO" Section*/

	OTHERWISE NOP
END	/*Ends "SELECT" Section*/
return

/* ##257_1002.0 */
257_1002.0: /* Event  GOUP, Clicked/selected */
Arg window self



PreviousDirectory = Directory
/* Get button state GOUP Radio Button */
GOUPFlag = VpIsSelected(window,'GOUP')
/* Get item value GOUP Radio Button */
UpLevel = VpGetItemValue(window,'GOUP')
IF GOUPFlag = 1 THEN DO
	SELECT
		WHEN UpLevel = "Go up to The Opening Dialog" THEN DO
			CALL VpWindow window,'CLOSE'
			NOP
		END	/*End "WHEN UpLevel = "Go up to The Opening Dialog" THEN DO" Section*/

		OTHERWISE DO
			Data = UpLevel
			PARSE VAR Data FirstPart "Go up to " Directory
			PARSE VAR Directory Path "\*.*" Remainder
			RC_LIST_SIZE = ""			
			CALL LISTDOWN
			IF SubdirectoryResults.[0] > 32000 THEN DO
				RC_LIST_SIZE = .IO~DIRECTORY_LIST_SIZE(SubdirectoryResults.[0])
				SIGNAL ENDGOUP
			END	/*End "IF SubdirectoryResults.[0] > 32000 THEN DO" Section*/
		END	/*End "OTHERWISE DO" Section*/
	END	/*End "SELECT" Section*/
END	/*End "IF GOUPFlag = 1 THEN DO" Section*/



/* Uncheck the item GOUP Radio Button */
CALL VpSelect window,'GOUP',0



/*Begin establishing the text for the GOUP radio button*/
SELECT
	WHEN Directory = Drive1"\*.*" THEN UpLevel = "Go up to The Opening Dialog"
	WHEN Directory = Drive2"\*.*" THEN UpLevel = "Go up to The Opening Dialog"
	WHEN Directory = Drive3"\*.*" THEN UpLevel = "Go up to The Opening Dialog"
	WHEN Directory = Drive4"\*.*" THEN UpLevel = "Go up to The Opening Dialog"
	WHEN Directory = Drive5"\*.*" THEN UpLevel = "Go up to The Opening Dialog"
	WHEN Directory = Drive6"\*.*" THEN UpLevel = "Go up to The Opening Dialog"

	OTHERWISE DO
		PARSE VAR Directory Remainder "\*.*" TheRest
		Remainder = Remainder"\"
		Counter = 0
		DO UNTIL Remainder = ""
			Counter = Counter + 1
			InputVariable = Remainder
			PARSE VAR InputVariable Portion.Counter "\" Remainder
		END	/*Ends "DO UNTIL Remainder = """ Section*/
		
		Counter = Counter - 1
		UpLevel = ""
		DO J = 1 TO Counter BY 1
			UpLevel = UpLevel||Portion.J"\"
		END J	/*Ends "DO J = 1 TO Counter BY 1" Section*/
	END	/*Ends "OTHERWISE DO" Section*/
	UpLevel = "Go up to "UpLevel"*.*"
END	/*Ends "SELECT" Section*/


/* Set item value GOUP Radio Button */
CALL VpSetItemValue window,'GOUP',UpLevel
/*End establishing the text for the GOUP radio button*/
ENDGOUP:
SELECT
	WHEN RC_LIST_SIZE = "OK" & Canceled_LockoutFlag = 0 THEN DO
		Canceled_LockoutFlag = 1
		Another = "ANOTHER"
		CALL VpNotify window,Another
		CALL VpWindow window,'CLOSE'
	END	/*Ends "WHEN RC_LIST_SIZE = "OK" & Canceled_LockoutFlag = 0 THEN DO" Section*/

	WHEN RC_LIST_SIZE = "CANCEL" & Canceled_LockoutFlag = 0 THEN DO
		Canceled_LockoutFlag = 1
		Cancel = "CANCELLED"
		CALL VpNotify window,Cancel
		CALL VpWindow window,'CLOSE'
		END	/*Ends "WHEN RC = "CANCEL" & Canceled_LockoutFlag = 0 THEN DO" Section*/

	OTHERWISE NOP
END	/*Ends "SELECT" Section*/
return

/* ##257_1003.0 */
257_1003.0: /* Event Cancel CCANCEL, Clicked/selected */
Arg window self



Cancel = "CANCELLED"
CALL VpNotify window,Cancel
CALL VpWindow window,'CLOSE'
SubdirectoryListFormID = ""
return

/* ##257_1004.0 */
257_1004.0: /* Event Seek Files SEEK, Clicked/selected */
Arg window self


SELECT
	/*This button is used to find files under SelectType = "Single"*/
	WHEN ListType = "Directories" THEN DO
		/* Enable item SELECTDOWN Radio Button */
		CALL VpItem window,'SELECTDOWN','ENABLE'
		/* Show item SELECTDOWN Radio Button */
		CALL VpItem window,'SELECTDOWN','SHOW'
		/* Enable item SELECTUP Radio Button */
		CALL VpItem window,'SELECTUP','ENABLE'
		/* Show item SELECTUP Radio Button */
		CALL VpItem window,'SELECTUP','SHOW'
		/* Enable item SELECTALL Radio Button */
		CALL VpItem window,'SELECTALL','ENABLE'
		/* Show item SELECTALL Radio Button */
		CALL VpItem window,'SELECTALL','SHOW'
		/* Enable item DESELECTDOWN Radio Button */
		CALL VpItem window,'DESELECTDOWN','ENABLE'
		/* Show item DESELECTDOWN Radio Button */
		CALL VpItem window,'DESELECTDOWN','SHOW'
		/* Enable item DESELECTUP Radio Button */
		CALL VpItem window,'DESELECTUP','ENABLE'
		/* Show item DESELECTUP Radio Button */
		CALL VpItem window,'DESELECTUP','SHOW'
		/* Enable item DESELECTALL Radio Button */
		CALL VpItem window,'DESELECTALL','ENABLE'
		/* Show item DESELECTALL Radio Button */
		CALL VpItem window,'DESELECTALL','SHOW'
		/* Enable item SELECTFILESGROUPBOX Group Box */
		CALL VpItem window,'SELECTFILESGROUPBOX','ENABLE'
		/* Show item SELECTFILESGROUPBOX Group Box */
		CALL VpItem window,'SELECTFILESGROUPBOX','SHOW'
		/* Enable item DATESORT Radio Button */
		CALL VpItem window,'DATESORT','ENABLE'
		/* Show item DATESORT Radio Button */
		CALL VpItem window,'DATESORT','SHOW'
		/* Enable item TIMESORT Radio Button */
		CALL VpItem window,'TIMESORT','ENABLE'
		/* Show item TIMESORT Radio Button */
		CALL VpItem window,'TIMESORT','SHOW'
		/* Enable item SIZESORT Radio Button */
		CALL VpItem window,'SIZESORT','ENABLE'
		/* Show item SIZESORT Radio Button */
		CALL VpItem window,'SIZESORT','SHOW'
		/* Enable item PATHSORT Radio Button */
		CALL VpItem window,'PATHSORT','ENABLE'
		/* Show item PATHSORT Radio Button */
		CALL VpItem window,'PATHSORT','SHOW'
		/* Enable item FILENAMESORT Radio Button */
		CALL VpItem window,'FILENAMESORT','ENABLE'
		/* Show item FILENAMESORT Radio Button */
		CALL VpItem window,'FILENAMESORT','SHOW'
		/* Enable item SORTGROUPBOX Group Box */
		CALL VpItem window,'SORTGROUPBOX','ENABLE'
		/* Show item SORTGROUPBOX Group Box */
		CALL VpItem window,'SORTGROUPBOX','SHOW'
		/* Uncheck the item DATESORT Radio Button */
		CALL VpSelect window,'DATESORT',0
		/* Uncheck the item TIMESORT Radio Button */
		CALL VpSelect window,'TIMESORT',0
		/* Uncheck the item SIZESORT Radio Button */
		CALL VpSelect window,'SIZESORT',0
		/* Uncheck the item PATHSORT Radio Button */
		CALL VpSelect window,'PATHSORT',0
		/* Uncheck the item FILENAMESORT Radio Button */
		CALL VpSelect window,'FILENAMESORT',0

		/* Enable item ASCENDING Radio Button */
		CALL VpItem window,'ASCENDING','ENABLE'
		/* Show item ASCENDING Radio Button */
		CALL VpItem window,'ASCENDING','SHOW'
		/* Check the item  ASCENDING Radio Button */
		CALL VpSelect window,'ASCENDING',1
		/* Enable item DESCENDING Radio Button */
		CALL VpItem window,'DESCENDING','ENABLE'
		/* Show item DESCENDING Radio Button */
		CALL VpItem window,'DESCENDING','SHOW'
		/* Uncheck the item DESCENDING Radio Button */
		CALL VpSelect window,'DESCENDING',0
		/* Enable item SORTORDER Group Box */
		CALL VpItem window,'SORTORDER','ENABLE'
		/* Show item SORTORDER Group Box */
		CALL VpItem window,'SORTORDER','SHOW'


		/* Enable item SELECTFILESGROUPBOXTEXT Text */
		CALL VpItem window,'SELECTFILESGROUPBOXTEXT','ENABLE'
		/* Show item SELECTFILESGROUPBOXTEXT Text */
		CALL VpItem window,'SELECTFILESGROUPBOXTEXT','SHOW'
		/* Enable item SORTGROUPBOXTEXT Group Box */
		CALL VpItem window,'SORTGROUPBOXTEXT','ENABLE'
		/* Show item SORTGROUPBOXTEXT Group Box */
		CALL VpItem window,'SORTGROUPBOXTEXT','SHOW'


		SELECT
			WHEN SysFileTreeOption = "FS" | SysFileTreeOption = "F" THEN DO
				SelectFilesGroupBoxText = "Select files options:"
				SortGroupBoxText = "File sort options:"
				/* Set item value SELECTFILESGROUPBOXTEXT Text */
				CALL VpSetItemValue window,'SELECTFILESGROUPBOXTEXT',SelectFilesGroupBoxText
				/* Set item value SORTGROUPBOXTEXT Text */
				CALL VpSetItemValue window,'SORTGROUPBOXTEXT',SortGroupBoxText
			END	/*Ends "WHEN SysFileTreeOption = "FS" | SysFileTreeOption = "F" THEN DO" Section*/

			WHEN SysFileTreeOption = "DS" | SysFileTreeOption = "D" THEN DO
				SelectFilesGroupBoxText = "Select directories options:"
				SortGroupBoxText = "Directory sort options:"
				/* Set item value SELECTFILESGROUPBOXTEXT Text */
				CALL VpSetItemValue window,'SELECTFILESGROUPBOXTEXT',SelectFilesGroupBoxText
				/* Set item value SORTGROUPBOXTEXT Text */
				CALL VpSetItemValue window,'SORTGROUPBOXTEXT',SortGroupBoxText
			END	/*Ends "WHEN SysFileTreeOption = "FS" | SysFileTreeOption = "D" THEN DO" Section*/

			OTHERWISE NOP
		END	/*Ends "SELECT" Section*/


		PreviousSortOrder = "A"

		DesiredFiles. = ""
		SearchPath = Path"\"FileName
		RC = SYSFILETREE(SearchPath,"DesiredFiles",SysFileTreeOption)
		IF PerformPreSortFlag = 1 THEN CALL PRESORTT
		RC_LIST_SIZE = ""			
		IF DesiredFiles.[0] > 32000 THEN DO
			RC_LIST_SIZE = .IO~FILE_LIST_SIZE(DesiredFiles.[0])
			SIGNAL ENDSEEKBUTTON
		END	/*End "IF DesiredFiles.[0] > 32000 THEN DO" Section*/
		CALL LSTFILES
	END	/*Ends "WHEN ListType = "Directories" THEN DO" Section*/
	/*This button is used to find files under SelectType = "Single"*/


	WHEN ListType = "Files" THEN DO
		Another = "ANOTHER"
		CALL VpNotify window,Another
		CALL VpWindow window,'CLOSE'
		SubdirectoryListFormID = ""
	END	/*Ends "WHEN ListType = "Files" THEN DO" Section*/

	OTHERWISE NOP
END	/*Ends "SELECT" Section*/
ENDSEEKBUTTON:
SELECT
	WHEN RC_LIST_SIZE = "OK" & Canceled_LockoutFlag = 0 THEN DO
		Canceled_LockoutFlag = 1
		Another = "ANOTHER"
		CALL VpNotify window,Another
		CALL VpWindow window,'CLOSE'
	END	/*Ends "WHEN RC_LIST_SIZE = "OK" & Canceled_LockoutFlag = 0 THEN DO" Section*/

	WHEN RC_LIST_SIZE = "CANCEL" & Canceled_LockoutFlag = 0 THEN DO
		Canceled_LockoutFlag = 1
		Cancel = "CANCELLED"
		CALL VpNotify window,Cancel
		CALL VpWindow window,'CLOSE'
		END	/*Ends "WHEN RC = "CANCEL" & Canceled_LockoutFlag = 0 THEN DO" Section*/

	OTHERWISE NOP
END	/*Ends "SELECT" Section*/
return

/* ##257_1006.0 */
257_1006.0: /* Event List Box LISTFILES, Clicked/selected */
Arg window self



IF RadioButtonSelect = "YES" THEN SIGNAL ENDMOUSESELECT
SELECT
	WHEN SelectedIndices.0 > 0 THEN DO
		/* Get indexes of all selected items LISTFILES List Box */
		CALL VpGetIndex window,'LISTFILES','ALLSELECTED','INDEXES.'
		NewSelectedIndices. = ""
		DO J = 0 TO INDEXES.0 BY 1
			NewSelectedIndices.J = INDEXES.J
		END J	/*Ends "DO J = 0 TO INDEXES.0 BY 1" Section*/

		SELECT
			WHEN NewSelectedIndices.0 > SelectedIndices.0 THEN DO
				DO J = 1 TO NewSelectedIndices.0 BY 1
					Match = "NO"
					K = 0
					DO UNTIL Match = "YES" | K = SelectedIndices.0
						K = K + 1
						IF NewSelectedIndices.J = SelectedIndices.K THEN Match = "YES"
					END	/*Ends "DO UNTIL Match = "YES" | K = SelectedIndices.0" Section*/

					IF Match = "NO" THEN DO
						HighLightRow1 = NewSelectedIndices.J
						HighLightRow2 = NewSelectedIndices.J
						LEAVE J
					END	/*Ends "IF Match = "NO" THEN DO" Section*/
				END J	/*Ends "DO J = 1 TO NewSelectedIndices.0 BY 1" Section*/
			END	/*Ends "WHEN NewSelectedIndices.0 > SelectedIndices.0 THEN DO" Section*/

			WHEN NewSelectedIndices.0 < SelectedIndices.0 THEN DO
				ManualDeselect = "YES"
				DO J = 1 TO SelectedIndices.0 BY 1
					Match = "NO"
					K = 0
					DO UNTIL Match = "YES" | K = NewSelectedIndices.0
						K = K + 1
						IF SelectedIndices.J = NewSelectedIndices.K THEN Match = "YES"
					END	/*Ends "DO UNTIL Match = "YES" | K = NewSelectedIndices.0" Section*/

					IF Match = "NO" THEN DO
						DeHighLightRow1 = SelectedIndices.J
						DeHighLightRow2 = SelectedIndices.J
						LEAVE J
					END	/*Ends "IF Match = "NO" THEN DO" Section*/
				END J	/*Ends "DO J = 1 TO SelectedIndices.0 BY 1" Section*/
			END	/*Ends "WHEN NewSelectedIndices.0 < SelectedIndices.0 THEN DO" Section*/

			OTHERWISE NOP
		END	/*Ends "SELECT" Section*/
	END	/*Ends "WHEN SelectedIndices.0 > 0 THEN DO" Section*/

	OTHERWISE DO
		/* Get index of first selected item LISTFILES List Box */
		Index = VpGetIndex(window,'LISTFILES','SELECTED',0)
		SelectedIndices.0 = 1
		SelectedIndices.1 = Index
		HighLightRow1 = SelectedIndices.1
		HighLightRow2 = SelectedIndices.1
	END	/*Ends "OTHERWISE DO (no items are previously selected)" Section*/
END	/*Ends "SELECT" Section*/
ENDMOUSESELECT:
RadioButtonSelect = "NO"
return

/* ##257_1006.16 */
257_1006.16: /* Event List Box LISTFILES, Mouse button 1 double click */
Arg window self



/* Get indexes of all selected items LISTFILES List Box */
CALL VpGetIndex window,'LISTFILES','ALLSELECTED','INDEXES.'
OtherServicesFileDirectory. = ""
OtherServicesFilePath. = ""
/* Get indexes of all selected items LISTFILES List Box */
CALL VpGetIndex window,'LISTFILES','ALLSELECTED','INDEXES.'
IF INDEXES.0 > 0 THEN DO
	DO J = 1 TO INDEXES.0 BY 1
		Index = INDEXES.J
		/* Get item value at index LISTFILES List Box */
		Data=VpGetItemValue(window,'LISTFILES',Index)
		OtherServicesFileDirectory.J = Data
		Data = STRIP(Data,"B")
		DO M = 1 TO 4 BY 1
			PARSE VAR Data First Remainder
			Data = STRIP(Remainder,"B")
		END M	/*Ends "DO M = 1 TO 4 BY 1" Section*/
		OtherServicesFilePath.J = STRIP(Remainder,"B")
	END J	/*Ends "DO J = 1 TO INDEXES.0 BY 1" Section*/

	OtherServicesFilePath.0 = INDEXES.0
	OtherServicesFileDirectory.0 = INDEXES.0

	/* Open the form C:\OS2\APPS\Seek\OtherServices */
	value=VpOpenForm(window, 258, 'topic name')
END	/*Ends "IF INDEXES.0 > 0 THEN DO" Section*/
return

/* ##257_1008.0 */
257_1008.0: /* Event By Date DATESORT, Clicked/selected */
Arg window self



SortType = "Sort by Date"
/* Get button state ASCENDING Radio Button */
ASortOrderFlag = VpIsSelected(window,'ASCENDING')
/* Get button state DESCENDING Radio Button */
DSortOrderFlag = VpIsSelected(window,'DESCENDING')
SELECT
	WHEN ASortOrderFlag = 1 THEN SortOrder = "A"
	WHEN DSortOrderFlag = 1 THEN SortOrder = "D"
	OTHERWISE SortOrder = "A"
END
CALL SORT
return

/* ##257_1009.0 */
257_1009.0: /* Event By Time TIMESORT, Clicked/selected */
Arg window self



SortType = "Sort by Time"
/* Get button state ASCENDING Radio Button */
ASortOrderFlag = VpIsSelected(window,'ASCENDING')
/* Get button state DESCENDING Radio Button */
DSortOrderFlag = VpIsSelected(window,'DESCENDING')
SELECT
	WHEN ASortOrderFlag = 1 THEN SortOrder = "A"
	WHEN DSortOrderFlag = 1 THEN SortOrder = "D"
	OTHERWISE SortOrder = "A"
END
CALL SORT
return

/* ##257_1010.0 */
257_1010.0: /* Event By Size SIZESORT, Clicked/selected */
Arg window self



SortType = "Sort by File Size"
/* Get button state ASCENDING Radio Button */
ASortOrderFlag = VpIsSelected(window,'ASCENDING')
/* Get button state DESCENDING Radio Button */
DSortOrderFlag = VpIsSelected(window,'DESCENDING')
SELECT
	WHEN ASortOrderFlag = 1 THEN SortOrder = "A"
	WHEN DSortOrderFlag = 1 THEN SortOrder = "D"
	OTHERWISE SortOrder = "A"
END
CALL SORT
return

/* ##257_1011.0 */
257_1011.0: /* Event By Path (Directory and File Name PATHSORT, Clicked/selected */
Arg window self



SortType = "Sort by File Path"
/* Get button state ASCENDING Radio Button */
ASortOrderFlag = VpIsSelected(window,'ASCENDING')
/* Get button state DESCENDING Radio Button */
DSortOrderFlag = VpIsSelected(window,'DESCENDING')
SELECT
	WHEN ASortOrderFlag = 1 THEN SortOrder = "A"
	WHEN DSortOrderFlag = 1 THEN SortOrder = "D"
	OTHERWISE SortOrder = "A"
END
CALL SORT
return

/* ##257_1012.0 */
257_1012.0: /* Event By File Name FILENAMESORT, Clicked/selected */
Arg window self



SortType = "Sort by FileName"
/* Get button state ASCENDING Radio Button */
ASortOrderFlag = VpIsSelected(window,'ASCENDING')
/* Get button state DESCENDING Radio Button */
DSortOrderFlag = VpIsSelected(window,'DESCENDING')
SELECT
	WHEN ASortOrderFlag = 1 THEN SortOrder = "A"
	WHEN DSortOrderFlag = 1 THEN SortOrder = "D"
	OTHERWISE SortOrder = "A"
END
CALL SORT
return

/* ##257_1014.0 */
257_1014.0: /* Event Ascending ASCENDING, Clicked/selected */
Arg window self
/* Get button state DATESORT Radio Button */
DateSortFlag = VpIsSelected(window,'DATESORT')
/* Get button state TIMESORT Radio Button */
TimeSortFlag = VpIsSelected(window,'TIMESORT')
/* Get button state SIZESORT Radio Button */
SizeSortFlag = VpIsSelected(window,'SIZESORT')
/* Get button state PATHSORT Radio Button */
PathSortflag = VpIsSelected(window,'PATHSORT')
/* Get button state FILENAMESORT Radio Button */
FileNameSortFlag = VpIsSelected(window,'FILENAMESORT')



/* Get button state ASCENDING Radio Button */
AscentingOrderFlag = VpIsSelected(window,'ASCENDING')
SortFlag = DateSortFlag + TimeSortFlag + SizeSortFlag + PathSortflag + FileNameSortFlag
IF AscentingOrderFlag = 1 THEN SortOrder = "A"
IF SortOrder \= PreviousSortOrder & SortFlag > 0 THEN DO
	CALL SORT
	PreviousSortOrder = "A"
END	/*Ends "IF SortOrder \= PreviousSortOrder & SortFlag > 0 THEN DO" Section*/


return

/* ##257_1015.0 */
257_1015.0: /* Event Descending DESCENDING, Clicked/selected */
Arg window self
/* Get button state DATESORT Radio Button */
DateSortFlag = VpIsSelected(window,'DATESORT')
/* Get button state TIMESORT Radio Button */
TimeSortFlag = VpIsSelected(window,'TIMESORT')
/* Get button state SIZESORT Radio Button */
SizeSortFlag = VpIsSelected(window,'SIZESORT')
/* Get button state PATHSORT Radio Button */
PathSortflag = VpIsSelected(window,'PATHSORT')
/* Get button state FILENAMESORT Radio Button */
FileNameSortFlag = VpIsSelected(window,'FILENAMESORT')



/* Get button state DESCENDING Radio Button */
DescentingOrderFlag = VpIsSelected(window,'DESCENDING')
SortFlag = DateSortFlag + TimeSortFlag + SizeSortFlag + PathSortflag + FileNameSortFlag
IF DescentingOrderFlag = 1 THEN SortOrder = "D"
IF SortOrder \= PreviousSortOrder & SortFlag > 0 THEN DO
	CALL SORT
	PreviousSortOrder = "D"
END	/*Ends "IF SortOrder \= PreviousSortOrder & SortFlag > 0 THEN DO" Section*/
return

/* ##257_1017.0 */
257_1017.0: /* Event Highlight desired files for othe OTHERSERVICESRADIOBUTTON, Clicked/selected */
Arg window self



/* Get button state OTHERSERVICESRADIOBUTTON Radio Button */
OtherServicesFlag = VpIsSelected(window,'OTHERSERVICESRADIOBUTTON')
IF OtherServicesFlag = 1 THEN DO
	OtherServicesFileDirectory. = ""
	OtherServicesFilePath. = ""
	/* Get indexes of all selected items LISTFILES List Box */
	CALL VpGetIndex window,'LISTFILES','ALLSELECTED','INDEXES.'
	IF INDEXES.0 > 0 THEN DO
		DO J = 1 TO INDEXES.0 BY 1
			Index = INDEXES.J
			/* Get item value at index LISTFILES List Box */
			Data=VpGetItemValue(window,'LISTFILES',Index)
			OtherServicesFileDirectory.J = Data
			Data = STRIP(Data,"B")
			DO M = 1 TO 4 BY 1
				PARSE VAR Data First Remainder
				Data = STRIP(Remainder,"B")
			END M	/*Ends "DO M = 1 TO 4 BY 1" Section*/
			OtherServicesFilePath.J = STRIP(Remainder,"B")
		END J	/*Ends "DO J = 1 TO INDEXES.0 BY 1" Section*/

		OtherServicesFilePath.0 = INDEXES.0
		OtherServicesFileDirectory.0 = INDEXES.0
		/* Uncheck the item OTHERSERVICESRADIOBUTTON Radio Button */
		CALL VpSelect window,'OTHERSERVICESRADIOBUTTON',0
		/* Open the form C:\OS2\APPS\Seek\OtherServices */
		value=VpOpenForm(window, 258, 'topic name')
	END	/*Ends "IF INDEXES.0 > 0 THEN DO" Section*/

	ELSE DO
		IF SysFileTreeOption = "FS" | SysFileTreeOption = "F" THEN Text = "Select, or highlight, one or more of the above files, first, before clicking this radio button"
		IF SysFileTreeOption = "DS" | SysFileTreeOption = "D" THEN Text = "Select, or highlight, one or more of the above directories, first, before clicking this radio button"
		/* Set item value OTHERSERVICESRADIOBUTTON Radio Button */
		CALL VpSetItemValue window,'OTHERSERVICESRADIOBUTTON',Text
		CALL SysSleep 3
		IF SysFileTreeOption = "FS" | SysFileTreeOption = "F" THEN Text = "Highlight the files desired for other services. Double click to initiate, or press this radio button"
		IF SysFileTreeOption = "DS" | SysFileTreeOption = "D" THEN Text = "Highlight the directories desired for other services. Double click to initiate, or press this radio button"
		/* Uncheck the item OTHERSERVICESRADIOBUTTON Radio Button */
		/* Set item value OTHERSERVICESRADIOBUTTON Radio Button */
		CALL VpSetItemValue window,'OTHERSERVICESRADIOBUTTON',Text
		CALL VpSelect window,'OTHERSERVICESRADIOBUTTON',0
	END	/*Ends "ELSE DO" Section*/
END	/*Ends "IF OtherServicesFlag = 1 THEN DO" Section*/
return

/* ##257_1018.0 */
257_1018.0: /* Event Select down and one at a time SELECTDOWN, Clicked/selected */
Arg window self



/*Begin getting the indices of all the selected items*/
RadioButtonSelect = "YES"
/* Get indexes of all selected items LISTFILES List Box */
CALL VpGetIndex window,'LISTFILES','ALLSELECTED','INDEXES.'
SelectedIndices. = ""
DO J = 0 TO INDEXES.0 BY 1
	SelectedIndices.J = INDEXES.J
END J	/*Ends "DO J = 0 TO INDEXES.0 BY 1" Section*/
/*End getting the indices of all the selected items*/



/*Begin selecting the "correct" next file on the list*/
/*Begin finding the row number of the next file to select on the list*/
IF SelectedIndices.0 = DesiredFiles.0 THEN SIGNAL ENDSELECTDOWN
IF HighLightRow1 = DesiredFiles.0 THEN HighLightRow1 = 1
SELECT
	WHEN SelectedIndices.0 = 0 THEN HighLightRow1 = 1

	OTHERWISE DO
		DO J = 1 TO SelectedIndices.0 BY 1
			IF HighLightRow1 = SelectedIndices.J THEN HighLightRow1 = HighLightRow1 + 1
		END J	/*Ends "DO J = 1 TO SelectedIndices.0 BY 1" Section*/
	END	/*Ends "OTHERWISE DO" Section*/
END	/*Ends "SELECT" Section*/
/*End finding the row number of the next file to select on the list*/

/*Begin selecting the next file*/
SELECT
	WHEN SelectedIndices.0 < DesiredFiles.0 & HighLightRow1 <= DesiredFiles.0 THEN
	/* Select item LISTFILES List Box */
	CALL VpSelect window,'LISTFILES',HighLightRow1,1

	OTHERWISE NOP
END	/*Ends "SELECT" Section*/
/*End selecting the next file*/
/*End selecting the "correct" next file from the list*/



/*Begin getting the indices of all the selected items*/
/* Get indexes of all selected items LISTFILES List Box */
CALL VpGetIndex window,'LISTFILES','ALLSELECTED','INDEXES.'
SelectedIndices. = ""
DO J = 0 TO INDEXES.0 BY 1
	SelectedIndices.J = INDEXES.J
END J	/*Ends "DO J = 0 TO INDEXES.0 BY 1" Section*/
/*End getting the indices of all the selected items*/



ENDSELECTDOWN:
/* Uncheck the item SELECTDOWN Radio Button */
CALL VpSelect window,'SELECTDOWN',0
RC = .Timing~Delay(0.25)
/* Get button state SELECTDOWN Radio Button */
Flag = VpIsSelected(window,'SELECTDOWN')
IF Flag = 1 THEN DO
	Count = 0
	DO UNTIL Flag = 0 | Count = 10
		Count = Count + 1
		/* Uncheck the item SELECTDOWN Radio Button */
		CALL VpSelect window,'SELECTDOWN',0
		/* Get button state SELECTDOWN Radio Button */
		Flag = VpIsSelected(window,'SELECTDOWN')	
	END	/*Ends "DO UNTIL Flag = 0 | Count = 10" Section*/
END	/*Ends "IF Flag = 1 THEN DO" Section*/
return

/* ##257_1019.0 */
257_1019.0: /* Event Select up and one at a time SELECTUP, Clicked/selected */
Arg window self



/*Begin getting the indices of all the selected items*/
RadioButtonSelect = "YES"
/* Get indexes of all selected items LISTFILES List Box */
CALL VpGetIndex window,'LISTFILES','ALLSELECTED','INDEXES.'
SelectedIndices. = ""
DO J = 0 TO INDEXES.0 BY 1
	SelectedIndices.J = INDEXES.J
END J	/*Ends "DO J = 0 TO INDEXES.0 BY 1" Section*/
/*End getting the indices of all the selected items*/



/*Begin selecting the "correct" next file on the list*/
/*Begin finding the row number of the next file to select on the list*/
IF SelectedIndices.0 = DesiredFiles.0 THEN SIGNAL ENDSELECTUP
IF HighLightRow2 = 1 THEN HighLightRow2 = DesiredFiles.0
SELECT
	WHEN SelectedIndices.0 = 0 THEN HighLightRow2 = DesiredFiles.0

	OTHERWISE DO
		DO J = SelectedIndices.0 TO 1 BY -1
			IF HighLightRow2 = SelectedIndices.J THEN HighLightRow2 = HighLightRow2 - 1
		END J	/*Ends "DO J = SelectedIndices.0 TO 1 BY -1" Section*/
	END	/*Ends "OTHERWISE DO" Section*/
END	/*Ends "SELECT" Section*/
/*End finding the row number of the next file to select on the list*/

/*Begin selecting the next file*/
SELECT
	WHEN SelectedIndices.0 < DesiredFiles.0 & HighLightRow2 >= 1 THEN
	/* Select item LISTFILES List Box */
	CALL VpSelect window,'LISTFILES',HighLightRow2,1

	OTHERWISE NOP
END	/*Ends "SELECT" Section*/
/*End selecting the next file*/
/*End selecting the "correct" next file from the list*/



/*Begin getting the indices of all the selected items*/
/* Get indexes of all selected items LISTFILES List Box */
ENDSELECTUP:
CALL VpGetIndex window,'LISTFILES','ALLSELECTED','INDEXES.'
SelectedIndices. = ""
DO J = 0 TO INDEXES.0 BY 1
	SelectedIndices.J = INDEXES.J
END J	/*Ends "DO J = 0 TO INDEXES.0 BY 1" Section*/
/*End getting the indices of all the selected items*/



ENDSELECTUP:
/* Uncheck the item SELECTUP Radio Button */
CALL VpSelect window,'SELECTUP',0
/* Get button state SELECTUP Radio Button */
RC = .Timing~Delay(0.25)
Flag = VpIsSelected(window,'SELECTUP')
IF Flag = 1 THEN DO
	Count = 0
	DO UNTIL Flag = 0 | Count = 10
		Count = Count + 1
		/* Uncheck the item SELECTUP Radio Button */
		CALL VpSelect window,'SELECTUP',0
		/* Get button state SELECTUP Radio Button */
		Flag = VpIsSelected(window,'SELECTUP')	
	END	/*Ends "DO UNTIL Flag = 0 | Count = 10" Section*/
END	/*Ends "IF Flag = 1 THEN DO" Section*/
return

/* ##257_1020.0 */
257_1020.0: /* Event Select all SELECTALL, Clicked/selected */
Arg window self



/*Begin setting the new values for DeHighLightRow1 and DeHighLightRow2*/
RadioButtonSelect = "YES"
DeHighLightRow1 = 1
DeHighLightRow2 = DesiredFiles.0
/*End setting the new values for DeHighLightRow1 and DeHighLightRow2*/



/*Begin getting the indices of all the selected items*/
/* Get indexes of all selected items LISTFILES List Box */
CALL VpGetIndex window,'LISTFILES','ALLSELECTED','INDEXES.'
SelectedIndices. = ""
DO J = 0 TO INDEXES.0 BY 1
	SelectedIndices.J = INDEXES.J
END J	/*Ends "DO J = 0 TO INDEXES.0 BY 1" Section*/
/*End getting the indices of all the selected items*/



IF SelectedIndices.0 = DesiredFiles.0 THEN SIGNAL ENDSELECTALL



/*Begin selecting all items*/
/* Select all items LISTFILES List Box */
CALL VpSelect window,'LISTFILES','ALL',1
/*End selecting all items*/



ENDSELECTALL:
/* Uncheck the item SELECTALL Radio Button */
CALL VpSelect window,'SELECTALL',0
RC = .Timing~Delay(0.25)
Flag = VpIsSelected(window,'SELECTALL')
IF Flag = 1 THEN DO
	Count = 0
	DO UNTIL Flag = 0 | Count = 10
		Count = Count + 1
		/* Uncheck the item SELECTALL Radio Button */
		CALL VpSelect window,'SELECTALL',0
		/* Get button state SELECTALL Radio Button */
		Flag = VpIsSelected(window,'SELECTALL')	
	END	/*Ends "DO UNTIL Flag = 0 | Count = 10" Section*/
END	/*Ends "IF Flag = 1 THEN DO" Section*/
return

/* ##257_1021.0 */
257_1021.0: /* Event Deselect down and one at a time DESELECTDOWN, Clicked/selected */
Arg window self



/*Begin getting the indices of all the deselected items*/
RadioButtonSelect = "YES"
/* Get indexes of all deselected items LISTFILES List Box */
CALL VpGetIndex window,'LISTFILES','ALLSELECTED','INDEXES.'
SelectedIndices. = ""
DO J = 0 TO INDEXES.0 BY 1
	SelectedIndices.J = INDEXES.J
END J	/*Ends "DO J = 0 TO INDEXES.0 BY 1" Section*/


SELECT
	WHEN SelectedIndices.0 = DesiredFiles.0 THEN DO
		DeSelectedIndices.0 = 0
		DeSelectedIndices.1 = 0
	END

	OTHERWISE DO
		K = 1
		L = 0
		M = SelectedIndices.0
		FirstRow = SelectedIndices.K
		LastRow = SelectedIndices.M
		DO J = 1 TO DesiredFiles.0 BY 1
			SELECT
				WHEN J < FirstRow | J > LastRow THEN DO
					L = L + 1
					DeSelectedIndices.L = J
				END	/*Ends "WHEN J < FirstRow | J > LastRow THEN DO" Section*/

				WHEN J = FirstRow THEN DO
					K = K + 1
					IF K <= M THEN FirstRow = SelectedIndices.K
				END

				OTHERWISE NOP
			END	/*Ends "SELECT" Section*/
		END J	/*Ends "DO J = 1 TO DesiredFiles.0 BY 1" Section*/
		DeSelectedIndices.0 = L
	END	/*Ends "OTHERWISE DO" Section*/
END	/*Ends "SELECT" Section*/
/*End getting the indices of all the deselected items*/



/*Begin deselecting the "correct" next file on the list*/
/*Begin finding the row number of the next file to deselect on the list*/
IF DeSelectedIndices.0 = DesiredFiles.0 THEN SIGNAL ENDDESELECTDOWN
IF DeHighLightRow1 = DesiredFiles.0 THEN DeHighLightRow1 = 1
SELECT
	WHEN DeSelectedIndices.0 = 0 THEN DeHighLightRow1 = 1

	OTHERWISE DO
		DO J = 1 TO DeSelectedIndices.0 BY 1
			IF DeHighLightRow1 = DeSelectedIndices.J THEN DeHighLightRow1 = DeHighLightRow1 + 1
		END J	/*Ends "DO J = 1 TO DeSelectedIndices.0 BY 1" Section*/
	END	/*Ends "OTHERWISE DO" Section*/
END	/*Ends "SELECT" Section*/

/*Begin deselecting the next file*/
SELECT
	WHEN DeSelectedIndices.0 < DesiredFiles.0 & DeHighLightRow1 <= DesiredFiles.0 THEN
	/* Select item LISTFILES List Box */
	CALL VpSelect window,'LISTFILES',DeHighLightRow1,0

	OTHERWISE NOP
END	/*Ends "SELECT" Section*/
/*End deselecting the next file*/
/*End deselecting the "correct" next file on the list*/






/*Begin getting the indices of all the selected items*/
/* Get indexes of all selected items LISTFILES List Box */
CALL VpGetIndex window,'LISTFILES','ALLSELECTED','INDEXES.'
SelectedIndices. = ""
DO J = 0 TO INDEXES.0 BY 1
	SelectedIndices.J = INDEXES.J
END J	/*Ends "DO J = 0 TO INDEXES.0 BY 1" Section*/
/*End getting the indices of all the selected items*/



ENDDESELECTDOWN:
/* Uncheck the item DESELECTDOWN Radio Button */
CALL VpSelect window,'DESELECTDOWN',0
RC = .Timing~Delay(0.25)
Flag = VpIsSelected(window,'DESELECTDOWN')
IF Flag = 1 THEN DO
	Count = 0
	DO UNTIL Flag = 0 | Count = 10
		Count = Count + 1
		/* Uncheck the item DESELECTDOWN Radio Button */
		CALL VpSelect window,'DESELECTDOWN',0
		/* Get button state DESELECTDOWN Radio Button */
		Flag = VpIsSelected(window,'DESELECTDOWN')	
	END	/*Ends "DO UNTIL Flag = 0 | Count = 10" Section*/
END	/*Ends "IF Flag = 1 THEN DO" Section*/
return

/* ##257_1022.0 */
257_1022.0: /* Event Deselect up and one at a time DESELECTUP, Clicked/selected */
Arg window self



/*Begin getting the indices of all the deselected items*/
RadioButtonSelect = "YES"
/* Get indexes of all deselected items LISTFILES List Box */
CALL VpGetIndex window,'LISTFILES','ALLSELECTED','INDEXES.'
SelectedIndices. = ""
DO J = 0 TO INDEXES.0 BY 1
	SelectedIndices.J = INDEXES.J
END J	/*Ends "DO J = 0 TO INDEXES.0 BY 1" Section*/


SELECT
	WHEN SelectedIndices.0 = DesiredFiles.0 THEN DO
		DeSelectedIndices.0 = 0
		DeSelectedIndices.1 = 0
	END

	OTHERWISE DO
		K = 1
		L = 0
		M = SelectedIndices.0
		FirstRow = SelectedIndices.K
		LastRow = SelectedIndices.M
		DO J = 1 TO DesiredFiles.0 BY 1
			SELECT
				WHEN J < FirstRow | J > LastRow THEN DO
					L = L + 1
					DeSelectedIndices.L = J
				END	/*Ends "WHEN J < FirstRow | J > LastRow THEN DO" Section*/

				WHEN J = FirstRow THEN DO
					K = K + 1
					IF K <= M THEN FirstRow = SelectedIndices.K
				END

				OTHERWISE NOP
			END	/*Ends "SELECT" Section*/
		END J	/*Ends "DO J = 1 TO DesiredFiles.0 BY 1" Section*/
		DeSelectedIndices.0 = L
	END	/*Ends "OTHERWISE DO" Section*/
END	/*Ends "SELECT" Section*/
/*End getting the indices of all the deselected items*/



/*Begin deselecting the "correct" next file on the list*/
/*Begin finding the row number of the next file to deselect on the list*/
IF DeSelectedIndices.0 = DesiredFiles.0 THEN SIGNAL ENDDESELECTUP
IF DeHighLightRow2 = 1 THEN DeHighLightRow2 = DesiredFiles.0
SELECT
	WHEN DeSelectedIndices.0 = 0 THEN DeHighLightRow2 = DesiredFiles.0

	OTHERWISE DO
		DO J = DeSelectedIndices.0 TO 1 BY -1
			IF DeHighLightRow2 = DeSelectedIndices.J THEN DeHighLightRow2 = DeHighLightRow2 - 1
		END J	/*Ends "DO J = DeSelectedIndices.0 TO 1 BY -1" Section*/
	END	/*Ends "OTHERWISE DO" Section*/
END	/*Ends "SELECT" Section*/

/*Begin deselecting the next file*/
SELECT
	WHEN DeSelectedIndices.0 < DesiredFiles.0 & DeHighLightRow2 >= 1 THEN
	/* Select item LISTFILES List Box */
	CALL VpSelect window,'LISTFILES',DeHighLightRow2,0

	OTHERWISE NOP
END	/*Ends "SELECT" Section*/
/*End deselecting the next file*/
/*End deselecting the "correct" next file on the list*/






/*Begin getting the indices of all the selected items*/
/* Get indexes of all selected items LISTFILES List Box */
CALL VpGetIndex window,'LISTFILES','ALLSELECTED','INDEXES.'
SelectedIndices. = ""
DO J = 0 TO INDEXES.0 BY 1
	SelectedIndices.J = INDEXES.J
END J	/*Ends "DO J = 0 TO INDEXES.0 BY 1" Section*/
/*End getting the indices of all the selected items*/



ENDDESELECTUP:
/* Uncheck the item DESELECTUP Radio Button */
CALL VpSelect window,'DESELECTUP',0
RC = .Timing~Delay(0.25)
Flag = VpIsSelected(window,'DESELECTUP')
IF Flag = 1 THEN DO
	Count = 0
	DO UNTIL Flag = 0 | Count = 10
		Count = Count + 1
		/* Uncheck the item DESELECTUP Radio Button */
		CALL VpSelect window,'DESELECTUP',0
		/* Get button state DESELECTUP Radio Button */
		Flag = VpIsSelected(window,'DESELECTUP')	
	END	/*Ends "DO UNTIL Flag = 0 | Count = 10" Section*/
END	/*Ends "IF Flag = 1 THEN DO" Section*/
return

/* ##257_1023.0 */
257_1023.0: /* Event Deselect all DESELECTALL, Clicked/selected */
Arg window self



/*Begin setting the new values for HighLightRow1 and HighLightRow2*/
RadioButtonSelect = "YES"
HighLightRow1 = 1
HighLightRow2 = DesiredFiles.0
/*End setting the new values for HighLightRow1 and HighLightRow2*/



/*Begin getting the indices of all the selected items*/
/* Get indexes of all selected items LISTFILES List Box */
CALL VpGetIndex window,'LISTFILES','ALLSELECTED','INDEXES.'
SelectedIndices. = ""
DO J = 0 TO INDEXES.0 BY 1
	SelectedIndices.J = INDEXES.J
END J	/*Ends "DO J = 0 TO INDEXES.0 BY 1" Section*/
/*End getting the indices of all the selected items*/



IF SelectedIndices.0 = 0 THEN SIGNAL ENDDESELECTALL



/*Begin deselecting all items*/
/* Select all items LISTFILES List Box */
CALL VpSelect window,'LISTFILES','ALL',0
/*End deselecting all items*/



ENDDESELECTALL:
/* Uncheck the item DESELECTALL Radio Button */
CALL VpSelect window,'DESELECTALL',0
RC = .Timing~Delay(0.25)
Flag = VpIsSelected(window,'DESELECTALL')
IF Flag = 1 THEN DO
	Count = 0
	DO UNTIL Flag = 0 | Count = 10
		Count = Count + 1
		/* Uncheck the item DESELECTALL Radio Button */
		CALL VpSelect window,'DESELECTALL',0
		/* Get button state DESELECTALL Radio Button */
		Flag = VpIsSelected(window,'DESELECTALL')	
	END	/*Ends "DO UNTIL Flag = 0 | Count = 10" Section*/
END	/*Ends "IF Flag = 1 THEN DO" Section*/
return

/* ##257_Form.1 */
257_Form.1: /* Event Form events, Opened */
Arg window 



OPENSUBDIRECTORYLISTDIALOG:
CALL VpWindow window,'ACTIVATE'
Cancel = "NO"
SecondDialog = "YES"
/* Uncheck the item GOUP Radio Button */
CALL VpSelect window,'GOUP',0



/*Begin getting the initial position and size of the LISTSUBDIRECTORIES List Box*/
/* Get item position LISTSUBDIRECTORIES List Box */
xy=VpItem(window,'LISTSUBDIRECTORIES','ITEMPOS')
PARSE VAR xy x y
ListSubdirectories_xPosition = x
ListSubdirectories_yPosition = y
/* Get item size LISTSUBDIRECTORIES List Box */
xy=VpItem(window,'LISTSUBDIRECTORIES','ITEMSIZE')
PARSE VAR xy x y
ListSubdirectories_xSize = x
ListSubdirectories_ySize = y
/*End getting the initial position and size of the LISTSUBDIRECTORIES List Box*/



/*Begin getting the initial position and size of the LISTFILES list box*/
/* Delete all items LISTFILES List Box */
/* Get item position LISTFILES List Box */
xy=VpItem(window,'LISTFILES','ITEMPOS')
PARSE VAR xy x y
ListFiles_xPosition = x
ListFiles_yPosition = y
/* Get item size LISTFILES List Box */
xy=VpItem(window,'LISTFILES','ITEMSIZE')
PARSE VAR xy x y
ListFiles_xSize = x
ListFiles_ySize = y
/*End getting the initial position and size of the LISTFILES list box*/



/*Begin configurig the SubDirectoryList form for the "Single" or "Multiple" selection choice*/
SELECT
	WHEN SelectType = "Single" THEN DO
		/* Disable item SELECTDOWN Radio Button */
		CALL VpItem window,'SELECTDOWN','DISABLE'
		/* Hide item SELECTDOWN Radio Button */
		CALL VpItem window,'SELECTDOWN','HIDE'
		/* Disable item SELECTUP Radio Button */
		CALL VpItem window,'SELECTUP','DISABLE'
		/* Hide item SELECTUP Radio Button */
		CALL VpItem window,'SELECTUP','HIDE'
		/* Disable item SELECTALL Radio Button */
		CALL VpItem window,'SELECTALL','DISABLE'
		/* Hide item SELECTALL Radio Button */
		CALL VpItem window,'SELECTALL','HIDE'
		/* Disable item DESELECTDOWN Radio Button */
		CALL VpItem window,'DESELECTDOWN','DISABLE'
		/* Hide item DESELECTDOWN Radio Button */
		CALL VpItem window,'DESELECTDOWN','HIDE'
		/* Disable item DESELECTUP Radio Button */
		CALL VpItem window,'DESELECTUP','DISABLE'
		/* Hide item DESELECTUP Radio Button */
		CALL VpItem window,'DESELECTUP','HIDE'
		/* Disable item DESELECTALL Radio Button */
		CALL VpItem window,'DESELECTALL','DISABLE'
		/* Hide item DESELECTALL Radio Button */
		CALL VpItem window,'DESELECTALL','HIDE'
		/* Disable item SELECTFILESGROUPBOXTEXT Text */
		CALL VpItem window,'SELECTFILESGROUPBOXTEXT','DISABLE'
		/* Hide item SELECTFILESGROUPBOXTEXT Text */
		CALL VpItem window,'SELECTFILESGROUPBOXTEXT','HIDE'
		/* Disable item SELECTFILESGROUPBOX Group Box */
		CALL VpItem window,'SELECTFILESGROUPBOX','DISABLE'
		/* Hide item SELECTFILESGROUPBOX Group Box */
		CALL VpItem window,'SELECTFILESGROUPBOX','HIDE'
		/* Disable item DATESORT Radio Button */
		CALL VpItem window,'DATESORT','DISABLE'
		/* Hide item DATESORT Radio Button */
		CALL VpItem window,'DATESORT','HIDE'
		/* Disable item TIMESORT Radio Button */
		CALL VpItem window,'TIMESORT','DISABLE'
		/* Hide item TIMESORT Radio Button */
		CALL VpItem window,'TIMESORT','HIDE'
		/* Disable item SIZESORT Radio Button */
		CALL VpItem window,'SIZESORT','DISABLE'
		/* Hide item SIZESORT Radio Button */
		CALL VpItem window,'SIZESORT','HIDE'
		/* Disable item PATHSORT Radio Button */
		CALL VpItem window,'PATHSORT','DISABLE'
		/* Hide item PATHSORT Radio Button */
		CALL VpItem window,'PATHSORT','HIDE'
		/* Disable item FILENAMESORT Radio Button */
		CALL VpItem window,'FILENAMESORT','DISABLE'
		/* Hide item FILENAMESORT Radio Button */
		CALL VpItem window,'FILENAMESORT','HIDE'
		/* Disable item SORTGROUPBOXTEXT Text */
		CALL VpItem window,'SORTGROUPBOXTEXT','DISABLE'
		/* Hide item SORTGROUPBOXTEXT Text */
		CALL VpItem window,'SORTGROUPBOXTEXT','HIDE'
		/* Disable item SORTGROUPBOX Group Box */
		CALL VpItem window,'SORTGROUPBOX','DISABLE'
		/* Hide item SORTGROUPBOX Group Box */
		CALL VpItem window,'SORTGROUPBOX','HIDE'
		/* Uncheck the item DATESORT Radio Button */
		CALL VpSelect window,'DATESORT',0
		/* Uncheck the item TIMESORT Radio Button */
		CALL VpSelect window,'TIMESORT',0
		/* Uncheck the item SIZESORT Radio Button */
		CALL VpSelect window,'SIZESORT',0
		/* Uncheck the item PATHSORT Radio Button */
		CALL VpSelect window,'PATHSORT',0
		/* Uncheck the item FILENAMESORT Radio Button */
		CALL VpSelect window,'FILENAMESORT',0

		/* Disable item ASCENDING Radio Button */
		CALL VpItem window,'ASCENDING','DISABLE'
		/* Hide item ASCENDING Radio Button */
		CALL VpItem window,'ASCENDING','HIDE'
		/* Disable item DESCENDING Radio Button */
		CALL VpItem window,'DESCENDING','DISABLE'
		/* Hide item DESCENDING Radio Button */
		CALL VpItem window,'DESCENDING','HIDE'
		/* Disable item SORTORDER Group Box */
		CALL VpItem window,'SORTORDER','DISABLE'
		/* Hide item SORTORDER Group Box */
		CALL VpItem window,'SORTORDER','HIDE'
		/* Uncheck the item ASCENDING Radio Button */
		CALL VpSelect window,'ASCENDING',0
		/* Uncheck the item DESCENDING Radio Button */
		CALL VpSelect window,'DESCENDING',0
		RC_LIST_SIZE = ""			
		CALL LISTDOWN
		IF SubdirectoryResults.[0] > 32000 THEN DO
			RC_LIST_SIZE = .IO~DIRECTORY_LIST_SIZE(SubdirectoryResults.[0])
			SIGNAL ENDOFOPENSUBDIRECTORYLISTDIALOG
		END	/*End "IF SubdirectoryResults.[0] > 32000 THEN DO" Section*/
	END	/*Ends "WHEN SelectType = "Single" THEN DO" Section*/

	WHEN SelectType = "Multiple" THEN DO
		DesiredFiles. = ""
		Index = 0
		/* Enable item SELECTDOWN Radio Button */
		CALL VpItem window,'SELECTDOWN','ENABLE'
		/* Show item SELECTDOWN Radio Button */
		CALL VpItem window,'SELECTDOWN','SHOW'
		/* Enable item SELECTUP Radio Button */
		CALL VpItem window,'SELECTUP','ENABLE'
		/* Show item SELECTUP Radio Button */
		CALL VpItem window,'SELECTUP','SHOW'
		/* Enable item SELECTALL Radio Button */
		CALL VpItem window,'SELECTALL','ENABLE'
		/* Show item SELECTALL Radio Button */
		CALL VpItem window,'SELECTALL','SHOW'
		/* Enable item DESELECTDOWN Radio Button */
		CALL VpItem window,'DESELECTDOWN','ENABLE'
		/* Show item DESELECTDOWN Radio Button */
		CALL VpItem window,'DESELECTDOWN','SHOW'
		/* Enable item DESELECTUP Radio Button */
		CALL VpItem window,'DESELECTUP','ENABLE'
		/* Show item DESELECTUP Radio Button */
		CALL VpItem window,'DESELECTUP','SHOW'
		/* Enable item DESELECTALL Radio Button */
		CALL VpItem window,'DESELECTALL','ENABLE'
		/* Show item DESELECTALL Radio Button */
		CALL VpItem window,'DESELECTALL','SHOW'
		/* Enable item SELECTFILESGROUPBOXTEXT Text */
		CALL VpItem window,'SELECTFILESGROUPBOXTEXT','ENABLE'
		/* Show item SELECTFILESGROUPBOXTEXT Text */
		CALL VpItem window,'SELECTFILESGROUPBOXTEXT','SHOW'
		/* Enable item SELECTFILESGROUPBOX Group Box */
		CALL VpItem window,'SELECTFILESGROUPBOX','ENABLE'
		/* Show item SELECTFILESGROUPBOX Group Box */
		CALL VpItem window,'SELECTFILESGROUPBOX','SHOW'
		/* Enable item DATESORT Radio Button */
		CALL VpItem window,'DATESORT','ENABLE'
		/* Show item DATESORT Radio Button */
		CALL VpItem window,'DATESORT','SHOW'
		/* Enable item TIMESORT Radio Button */
		CALL VpItem window,'TIMESORT','ENABLE'
		/* Show item TIMESORT Radio Button */
		CALL VpItem window,'TIMESORT','SHOW'
		/* Enable item SIZESORT Radio Button */
		CALL VpItem window,'SIZESORT','ENABLE'
		/* Show item SIZESORT Radio Button */
		CALL VpItem window,'SIZESORT','SHOW'
		/* Enable item PATHSORT Radio Button */
		CALL VpItem window,'PATHSORT','ENABLE'
		/* Show item PATHSORT Radio Button */
		CALL VpItem window,'PATHSORT','SHOW'
		/* Enable item FILENAMESORT Radio Button */
		CALL VpItem window,'FILENAMESORT','ENABLE'
		/* Show item FILENAMESORT Radio Button */
		CALL VpItem window,'FILENAMESORT','SHOW'
		/* Enable item SORTGROUPBOXTEXT Text */
		CALL VpItem window,'SORTGROUPBOXTEXT','ENABLE'
		/* Show item SORTGROUPBOXTEXT Text */
		CALL VpItem window,'SORTGROUPBOXTEXT','SHOW'
		/* Enable item SORTGROUPBOX Group Box */
		CALL VpItem window,'SORTGROUPBOX','ENABLE'
		/* Show item SORTGROUPBOX Group Box */
		CALL VpItem window,'SORTGROUPBOX','SHOW'
		/* Uncheck the item DATESORT Radio Button */
		CALL VpSelect window,'DATESORT',0
		/* Uncheck the item TIMESORT Radio Button */
		CALL VpSelect window,'TIMESORT',0
		/* Uncheck the item SIZESORT Radio Button */
		CALL VpSelect window,'SIZESORT',0
		/* Uncheck the item PATHSORT Radio Button */
		CALL VpSelect window,'PATHSORT',0
		/* Uncheck the item FILENAMESORT Radio Button */
		CALL VpSelect window,'FILENAMESORT',0

		/* Enable item ASCENDING Radio Button */
		CALL VpItem window,'ASCENDING','ENABLE'
		/* Show item ASCENDING Radio Button */
		CALL VpItem window,'ASCENDING','SHOW'
		/* Check the item  ASCENDING Radio Button */
		CALL VpSelect window,'ASCENDING',1
		/* Enable item DESCENDING Radio Button */
		CALL VpItem window,'DESCENDING','ENABLE'
		/* Show item DESCENDING Radio Button */
		CALL VpItem window,'DESCENDING','SHOW'
		/* Uncheck the item DESCENDING Radio Button */
		CALL VpSelect window,'DESCENDING',0
		/* Enable item SORTORDER Group Box */
		CALL VpItem window,'SORTORDER','ENABLE'
		/* Show item SORTORDER Group Box */
		CALL VpItem window,'SORTORDER','SHOW'
		PreviousSortOrder = "A"

		Index = Index + 1
		DesiredFiles.0 = 0
		L = 0
		DO J = 1 TO Paths.0 BY 1
			SearchPath = Paths.J"\"FileName
			RC = SYSFILETREE(SearchPath,"MultipleDesiredFiles",SysFileTreeOption)
			IF MultipleDesiredFiles.0 > 0 THEN DO
				DO K = 1 TO MultipleDesiredFiles.0
					L = L + 1
					DesiredFiles.L = MultipleDesiredFiles.K
				END K	/*Ends "DO K = 1 TO MultipleDesiredFiles.0" Section*/
				DesiredFiles.0 = DesiredFiles.0 + MultipleDesiredFiles.0
			END	/*Ends "IF MultipleDesiredFiles.0 > 0 THEN DO" Section*/
		END J	/*Ends "DO J = 1 TO Paths.0 BY 1" Section*/
		IF PerformPreSortFlag = 1 THEN CALL PRESORTT
		RC_LIST_SIZE = ""			
		IF DesiredFiles.[0] > 32000 THEN DO
			RC_LIST_SIZE = .IO~FILE_LIST_SIZE(DesiredFiles.[0])
			SIGNAL ENDOFOPENSUBDIRECTORYLISTDIALOG
		END	/*End "IF DesiredFiles.[0] > 32000 THEN DO" Section*/
		CALL LSTFILES

		SELECT
			WHEN SysFileTreeOption = "FS" | SysFileTreeOption = "F" THEN DO
				SelectFilesGroupBoxText = "Select files options:"
				SortGroupBoxText = "File sort options:"
				/* Set item value SELECTFILESGROUPBOXTEXT Text */
				CALL VpSetItemValue window,'SELECTFILESGROUPBOXTEXT',SelectFilesGroupBoxText
				/* Set item value SORTGROUPBOXTEXT Text */
				CALL VpSetItemValue window,'SORTGROUPBOXTEXT',SortGroupBoxText
			END	/*Ends "WHEN SysFileTreeOption = "FS" | SysFileTreeOption = "F" THEN DO" Section*/

			WHEN SysFileTreeOption = "DS" | SysFileTreeOption = "D" THEN DO
				SelectFilesGroupBoxText = "Select directories options:"
				SortGroupBoxText = "Directory sort options:"
				/* Set item value SELECTFILESGROUPBOXTEXT Text */
				CALL VpSetItemValue window,'SELECTFILESGROUPBOXTEXT',SelectFilesGroupBoxText
				/* Set item value SORTGROUPBOXTEXT Text */
				CALL VpSetItemValue window,'SORTGROUPBOXTEXT',SortGroupBoxText
			END	/*Ends "WHEN SysFileTreeOption = "FS" | SysFileTreeOption = "D" THEN DO" Section*/

			OTHERWISE NOP
		END	/*Ends "SELECT" Section*/
	END	/*Ends "WHEN SelectType = "Multiple" THEN DO" Section*/

	OTHERWISE NOP
END	/*Ends "SELECT" Section*/
/*End configurig the SubDirectoryList form for the "Single" or "Multiple" selection choice*/



/*Begin setting the SEEK button and the OTHERSERVICESRADIOBUTTON radio button*/
SELECT
	WHEN SelectOneFlag = 1 THEN DO
		/*Begin disabling and hiding the OTHERSERVICESRADIOBUTTON radio button*/
		/* Disable item OTHERSERVICESRADIOBUTTON Radio Button */
		CALL VpItem window,'OTHERSERVICESRADIOBUTTON','DISABLE'
		/* Hide item OTHERSERVICESRADIOBUTTON Radio Button */
		CALL VpItem window,'OTHERSERVICESRADIOBUTTON','HIDE'
		/*End disabling and hiding the OTHERSERVICESRADIOBUTTON radio button*/
		/*End setting the SEEK button and the OTHERSERVICESRADIOBUTTON radio button*/

		IF SysFileTreeOption = "FS" | SysFileTreeOption = "F" THEN
		CALL VpSetItemValue window,'SEEK',"Seek Files"
		ELSE
		CALL VpSetItemValue window,'SEEK',"Seek Dirs"
	END	/*Ends "WHEN SelectOneFlag = 1 THEN DO" Section*/

	WHEN SelectMultipleFlag = 1 THEN
	CALL VpSetItemValue window,'SEEK',"Do Another"

	OTHERWISE NOP
END	/*Ends "SELECT" Section*/
/*End setting the SEEK button and the OTHERSERVICESRADIOBUTTON radio button*/
ENDOFOPENSUBDIRECTORYLISTDIALOG:
SELECT
	WHEN RC_LIST_SIZE = "OK" & Canceled_LockoutFlag = 0 THEN DO
		Canceled_LockoutFlag = 1
		Another = "ANOTHER"
		CALL VpNotify window,Another
		CALL VpWindow window,'CLOSE'
	END	/*Ends "WHEN RC_LIST_SIZE = "OK" & Canceled_LockoutFlag = 0 THEN DO" Section*/

	WHEN RC_LIST_SIZE = "CANCEL" & Canceled_LockoutFlag = 0 THEN DO
		Canceled_LockoutFlag = 1
		Cancel = "CANCELLED"
		CALL VpNotify window,Cancel
		CALL VpWindow window,'CLOSE'
		END	/*Ends "WHEN RC = "CANCEL" & Canceled_LockoutFlag = 0 THEN DO" Section*/

	OTHERWISE NOP
END	/*Ends "SELECT" Section*/
return

/* ##257_Form.2 */
257_Form.2: /* Event Form events, Closed */
Arg window 
CALL VpNotify window,'Cancel'
return

/* ##257_Form.4 */
257_Form.4: /* Event Form events, Secondary Notify */
Arg window message



SELECT
	WHEN Another = "ANOTHER" THEN DO
		CALL VpNotify window,Another
		CALL VpWindow window,'CLOSE'
	END	/*Ends "WHEN Another = "ANOTHER" THEN DO" Section*/

	WHEN EndProgram = "END PROGRAM" THEN DO
		CALL VpNotify window,EndProgram
		CALL VpWindow window,'CLOSE'
	END	/*Ends "WHEN EndProgram = "END PROGRAM" THEN DO" Section*/

	WHEN SecondaryMessage = "CANCELSERVICES" THEN DO
		NOP
		SIGNAL ENDOFOPENSUBDIRECTORYLISTDIALOG
	END	/*Ends "WHEN SecondaryMessage = "CANCELSERVICES" THEN DO" Section*/

	OTHERWISE NOP
END	/*Ends "SELECT" Section*/
return

/* ##SUB_ADDLINE */
ADDLINE: 

return

/* ##SUB_AUTOLNCH */
AUTOLNCH: /*Sets the positions of various controls on the LAUNCH form, when the AUTO control is selected*/



/* Get button state AUTO Radio Button */
AutoFlag = VpIsSelected(window,'AUTO')
IF AutoFlag = 1 THEN DO
/*Begin setting the positions and sizes of the LAUNCH form and all its controls*/
	xPPosition = 60
	yPPosition = 95
	xSSize = 500
	ySSize = 20

	DO I = 1 TO 20 BY 1
		Radio_Button = "APP"I
		/* Set item value Radio_Button Radio Button */
		CALL VpSetItemValue window,Radio_Button,""
		/* Disable item Radio_Button Radio Button */
		CALL VpItem window,Radio_Button,'DISABLE'
		/* Hide item Radio_Button Radio Button */
		CALL VpItem window,Radio_Button,'HIDE'
		/* Set item position/size Radio_Button Radio Button */
		CALL VpItem window,Radio_Button,'SETITEMPOS',xPPosition,yPPosition,xSSize,ySSize		
	END I	/*Ends "DO I = 1 TO 20 BY 1" Section*/

	/* Set item value USER_DEFINED Radio Button */
	CALL VpSetItemValue window,'USER_DEFINED',""
	/* Disable item USER_DEFINED Radio Button */
	CALL VpItem window,'USER_DEFINED','DISABLE'
	/* Hide item USER_DEFINED Radio Button */
	CALL VpItem window,'USER_DEFINED','HIDE'
	/* Set item position/size USER_DEFINED Radio Button */
	CALL VpItem window,'USER_DEFINED','SETITEMPOS',xPPosition,yPPosition,xSSize,ySSize
	
	/* Set item value DRAFTING Radio Button */
	CALL VpSetItemValue window,'DRAFTING',""
	/* Disable item DRAFTING Radio Button */
	CALL VpItem window,'DRAFTING','DISABLE'
	/* Hide item DRAFTING Radio Button */
	CALL VpItem window,'DRAFTING','HIDE'
	/* Set item position/size DRAFTING Radio Button */
	CALL VpItem window,'DRAFTING','SETITEMPOS',xPPosition,yPPosition,xSSize,ySSize

	/* Set item value GRAPHICS Radio Button */
	CALL VpSetItemValue window,'GRAPHICS',""
	/* Disable item GRAPHICS Radio Button */
	CALL VpItem window,'GRAPHICS','DISABLE'
	/* Hide item GRAPHICS Radio Button */
	CALL VpItem window,'GRAPHICS','HIDE'
	/* Set item position/size GRAPHICS Radio Button */
	CALL VpItem window,'GRAPHICS','SETITEMPOS',xPPosition,yPPosition,xSSize,ySSize

	/* Set item value PS Radio Button */
	CALL VpSetItemValue window,'PS',""
	/* Disable item PS Radio Button */
	CALL VpItem window,'PS','DISABLE'
	/* Hide item PS Radio Button */
	CALL VpItem window,'PS','HIDE'
	/* Set item position/size PS Radio Button */
	CALL VpItem window,'PS','SETITEMPOS',xPPosition,yPPosition,xSSize,ySSize

	/* Set item value PDF Radio Button */
	CALL VpSetItemValue window,'PDF',""
	/* Disable item PDF Radio Button */
	CALL VpItem window,'PDF','DISABLE'
	/* Hide item PDF Radio Button */
	CALL VpItem window,'PDF','HIDE'
	/* Set item position/size PDF Radio Button */
	CALL VpItem window,'PDF','SETITEMPOS',xPPosition,yPPosition,xSSize,ySSize

	/* Set item value WB Radio Button */
	CALL VpSetItemValue window,'WB',""
	/* Disable item WB Radio Button */
	CALL VpItem window,'WB','DISABLE'
	/* Hide item WB Radio Button */
	CALL VpItem window,'WB','HIDE'
	/* Set item position/size WB Radio Button */
	CALL VpItem window,'WB','SETITEMPOS',xPPosition,yPPosition,xSSize,ySSize

	/* Set item value FIN Radio Button */
	CALL VpSetItemValue window,'FIN',""
	/* Disable item FIN Radio Button */
	CALL VpItem window,'FIN','DISABLE'
	/* Hide item FIN Radio Button */
	CALL VpItem window,'FIN','HIDE'
	/* Set item position/size FIN Radio Button */
	CALL VpItem window,'FIN','SETITEMPOS',xPPosition,yPPosition,xSSize,ySSize

	/* Set item value SS Radio Button */
	CALL VpSetItemValue window,'SS',""
	/* Disable item SS Radio Button */
	CALL VpItem window,'SS','DISABLE'
	/* Hide item SS Radio Button */
	CALL VpItem window,'SS','HIDE'
	/* Set item position/size SS Radio Button */
	CALL VpItem window,'SS','SETITEMPOS',xPPosition,yPPosition,xSSize,ySSize

	/* Set item value R_R Radio Button */
	CALL VpSetItemValue window,'R_R',""
	/* Disable item R_R Radio Button */
	CALL VpItem window,'R_R','DISABLE'
	/* Hide item R_R Radio Button */
	CALL VpItem window,'R_R','HIDE'
	/* Set item position/size R_R Radio Button */
	CALL VpItem window,'R_R','SETITEMPOS',xPPosition,yPPosition,xSSize,ySSize

	/* Set item value L_ED Radio Button */
	CALL VpSetItemValue window,'L_ED',""
	/* Disable item L_ED Radio Button */
	CALL VpItem window,'L_ED','DISABLE'
	/* Hide item L_ED Radio Button */
	CALL VpItem window,'L_ED','HIDE'
	/* Set item position/size L_ED Radio Button */
	CALL VpItem window,'L_ED','SETITEMPOS',xPPosition,yPPosition,xSSize,ySSize

	/* Set item value R_ED Radio Button */
	CALL VpSetItemValue window,'R_ED',""
	/* Disable item R_ED Radio Button */
	CALL VpItem window,'R_ED','DISABLE'
	/* Hide item R_ED Radio Button */
	CALL VpItem window,'R_ED','HIDE'
	/* Set item position/size R_ED Radio Button */
	CALL VpItem window,'R_ED','SETITEMPOS',xPPosition,yPPosition,xSSize,ySSize

	/* Set item value N_ED Radio Button */
	CALL VpSetItemValue window,'N_ED',""
	/* Disable item N_ED Radio Button */
	CALL VpItem window,'N_ED','DISABLE'
	/* Hide item N_ED Radio Button */
	CALL VpItem window,'N_ED','HIDE'
	/* Set item position/size N_ED Radio Button */
	CALL VpItem window,'N_ED','SETITEMPOS',xPPosition,yPPosition,xSSize,ySSize

	/* Set item value WP Radio Button */
	CALL VpSetItemValue window,'WP',""
	/* Disable item WP Radio Button */
	CALL VpItem window,'WP','DISABLE'
	/* Hide item WP Radio Button */
	CALL VpItem window,'WP','HIDE'
	/* Set item position/size WP Radio Button */
	CALL VpItem window,'WP','SETITEMPOS',xPPosition,yPPosition,xSSize,ySSize

	/* Set item position/size MANUAL Radio Button */
	CALL VpItem window,'MANUAL','SETITEMPOS',760,243,116,20

	/* Set item position/size AUTO Radio Button */
	CALL VpItem window,'AUTO','SETITEMPOS',760,280,116,20

	/* Set item position/size LAUNCHBOX Group Box */
	CALL VpItem window,'LAUNCHBOX','SETITEMPOS',740,225,162,108

	/* Set item position/size LAUNCH List Box */
	CALL VpItem window,'LAUNCH','SETITEMPOS',39,159,660,198

	/* Set item position/size INSTRUCT Text */
	CALL VpItem window,'INSTRUCT','SETITEMPOS',40,365,872,20
	Instruction = "Highlight (single click on) the desired filename to automatically launch."
	/* Set item value INSTRUCT Text */
	CALL VpSetItemValue window,'INSTRUCT',Instruction

	xSSize_Win = xSSize_WinOrigin
	ySSize_Win = ySSize_WinOrigin - 480
	CALL VpWindow window,'SETPOS', xPPos_WinOrigin, xPPos_WinOrigin, xSSize_Win, ySSize_Win
/*End setting the positions and sizes of the LAUNCH form and all its controls*/
END	/*Ends "IF AutoFlag = 1 THEN DO" Section*/
RETURN

/* ##SUB_COMPFILE */
COMPFILE: /*Subprocedure to compare the lines in a selected set of text files*/



/*Begin reading in each selected file-line by-line*/
M = 0
ReadFileLine. = ""
ReadFilePath. = ""
ReadFileName. = ""
ReadFileTree. = ""
ScanLineResults. = ""
ScanFilePathResults. = ""
ScanFileNameResults. = ""
ScanSysFileTreeResults. = ""
FileType. = ""
DO J = 1 TO OtherServicesFilePath.0 BY 1
	/*Begin reading in the lines in each file*/
	CALL ON ERROR NAME BINARY	/*Go to the BINARY routine, if an error occurs, using LINEIN*/
	ScanPath = OtherServicesFilePath.J
	K = 0
	M = M + 1
	BinaryFlag = 0
	DO WHILE Lines(ScanPath)
		K = K + 1
		ReadFileLine.M.K = LINEIN(ScanPath)
	END

	SELECT
		WHEN BinaryFlag = 0 THEN DO
			ReadFilePath.M = ScanPath
			ReadFileTree.M = OtherServicesFileDirectory.J
			Remainder = ReadFilePath.M
			Data = Remainder
			DO UNTIL Remainder = ""
				PARSE VAR Data First "\" Remainder
				Data = Remainder				
			END	/*Ends "DO UNTIL Remainder = """ Section*/
			ReadFileName.M = First
			ReadFileLine.M.0 = K
			FileType.M = "ASCII"
			RC = LineOut(ScanPath)
		END	/*Ends "WHEN BinaryFlag = 0 THEN DO" Section*/

		OTHERWISE NOP
	END	/*Ends "SELECT" Section*/
END J	/*End "DO J = 1 TO OtherServicesFilePath.0 BY 1" Section*/
ReadFileLine.0 = M
/*End reading in each selected file line-by-line*/



/*Begin comparing the lines of each file, two (2) files at a time*/
R = 0
StopValue = (ReadFileLine.0 - 1)
DO J = 1 TO StopValue BY 1
	SELECT
		WHEN FileType.J = "ASCII" THEN DO
			StartValue = J + 1
			DO K = StartValue TO ReadFileLine.0 BY 1
				R = R + 1
				S = 0
				IF FileType.K = "binary" THEN ITERATE
				Question = "FALSE"	/*Question = "FALSE", when there are no line-by-line comparison differences in the forward comparison of two (2) files*/
				Question1 = "FALSE"	/*Question1 = "FALSE", when there are no line-by-line comparison differences in this now forward comparison of the two (2) files*/
				DO L = 1 TO ReadFileLine.J.0 BY 1
					Question2 = "FALSE"	/*Question2 = "FALSE", when the line to compare do not commpare, or equal, any line in the compare to file*/
					LineToCompare = TRANSLATE(ReadFileLine.J.L)
					M = 0
					DO UNTIL M = ReadFileLine.K.0 | Question2 = "TRUE"
						M = M + 1
						IF LineToCompare = TRANSLATE(ReadFileLine.K.M) THEN Question2 = "TRUE"
					END	/*Ends "DO UNTIL M = ReadFileLine.K.0 | Question2 = "TRUE"" Section*/

					SELECT
						WHEN Question2 = "TRUE" THEN NOP

						WHEN Question2 = "FALSE" & Question1 = "FALSE" THEN DO
							Question = "TRUE"
							Question1 = "TRUE"
							S = S + 1
							ScanFilePathResults.R = '"'ReadFileName.J'" and "'ReadFileName.K'"'
							ScanLineResults.R.S = '*** The following line(s) in "'ReadFileName.J'" do not compare to any line in "'ReadFileName.K'" (excludes capitalization differences) ***'
							S = S + 1
							CALL SPACEIT
							ScanLineResults.R.S = "L"L":"RequiredSpace||ReadFileLine.J.L
						END	/*Ends "WHEN Question2 = "FALSE" & Question1 = "FALSE" THEN DO" Section*/

						WHEN Question2 = "FALSE" & Question1 = "TRUE" THEN DO
							S = S + 1
							CALL SPACEIT
							ScanLineResults.R.S = "L"L":"RequiredSpace||ReadFileLine.J.L
						END	/*Ends "WHEN Question2 = "FALSE" & Question1 = "TRUE" THEN DO" Section*/

						OTHERWISE NOP
					END	/*Ends "SELECT" Section*/
				END L	/*Ends "DO L = 1 TO ReadFileLine.J.0 BY 1" Section*/


				Question1 = "FALSE"	/*Question1 = "FALSE", when there are no line-by-line comparison differences in this now reverse comparison the two (2) files*/
				DO L = 1 TO ReadFileLine.K.0 BY 1
					Question2 = "FALSE"	/*Question2 = "FALSE", when the line to compare does not commpare, or equal, any line in the compare to file*/
					LineToCompare = TRANSLATE(ReadFileLine.K.L)
					M = 0
					DO UNTIL M = ReadFileLine.J.0 | Question2 = "TRUE"
						M = M + 1
						IF LineToCompare = TRANSLATE(ReadFileLine.J.M) THEN Question2 = "TRUE"
					END	/*Ends "DO UNTIL M = ReadFileLine.K.0 | Question2 = "TRUE"" Section*/

					SELECT
						WHEN Question2 = "TRUE" THEN NOP

						WHEN Question2 = "FALSE" & Question1 = "FALSE" THEN DO
							Question1 = "TRUE"
							SELECT
								WHEN Question = "FALSE" THEN
								ScanFilePathResults.R = '"'ReadFileName.J'" and "'ReadFileName.K'"'

								OTHERWISE DO
									S = S + 1
									ScanLineResults.R.S = "     "
								END	/*Ends "OTHERWISE DO" Section*/
							END	/*Ends "SELECT" Section*/
							S = S + 1
							ScanLineResults.R.S = '*** The following line(s) in "'ReadFileName.K'" do not compare to any line in "'ReadFileName.J'" (excludes capitalization differences) ***'
							S = S + 1
							CALL SPACEIT
							ScanLineResults.R.S = "L"L":"RequiredSpace||ReadFileLine.K.L
						END	/*Ends "WHEN Question2 = "FALSE" & Question1 = "FALSE" THEN DO" Section*/

						WHEN Question2 = "FALSE" & Question1 = "TRUE" THEN DO
							S = S + 1
							CALL SPACEIT
							ScanLineResults.R.S = "L"L":"RequiredSpace||ReadFileLine.K.L
						END	/*Ends "WHEN Question2 = "FALSE" & Question1 = "TRUE" THEN DO" Section*/

						OTHERWISE NOP
					END	/*Ends "SELECT" Section*/
				END L	/*Ends "DO L = 1 TO ReadFileLine.K.0 BY 1" Section*/
				ScanLineResults.R.0 = S
				IF ScanLineResults.R.0 = 0 THEN DO
					ScanFilePathResults.R = '"'ReadFileName.J'" and "'ReadFileName.K'"'
					S = S + 1
					ScanLineResults.R.S = 'There are no differences between "'ReadFileName.J'" and "'ReadFileName.K'"'
					ScanLineResults.R.0 = S
				END
			END K	/*Ends "DO K = StartValue TO ReadFileLine.0 BY 1" Section*/
		END	/*Ends "WHEN FileType.M = "ASCII" THEN DO" Section*/

		WHEN FileType.J = "binary" THEN DO
			ScanFilePathResults.R = '"'ReadFileName.J'" and nothing else'
			S = S + 1
			ScanLineResults.R.S = 'Sorry! "'ReadFileName.J'" appears to be a binary file.'
		END	/*Ends "WHEN FileType.M = "binary" THEN DO" Section*/

		OTHERWISE NOP
	END	/*Ends "SELECT" Section*/
END J	/*Ends "DO J = 1 TO StopValue BY 1" Section*/
ScanLineResults.0 = R
ScanFilePathResults.0 = R
RETURN









/*Begin the error trap coding for binary files*/
BINARY:
BinaryFlag = 1
FileType.M = "binary"
RETURN
/*End the error trap coding for binary files*/









/*Begin setting the RequiredSpace variable*/
SPACEIT:
NumberOfDigits = LENGTH(L)
SELECT
	WHEN NumberOfDigits = 1 THEN RequiredSpace = "      "
	WHEN NumberOfDigits = 2 THEN RequiredSpace = "     "
	WHEN NumberOfDigits = 3 THEN RequiredSpace = "    "
	WHEN NumberOfDigits = 4 THEN RequiredSpace = "   "
	WHEN NumberOfDigits = 5 THEN RequiredSpace = "  "
	WHEN NumberOfDigits = 6 THEN RequiredSpace = " "
	OTHERWISE NOP
END	/*Ends "SELECT" Section*/
RETURN
/*End setting the RequiredSpace variable*/

return

/* ##SUB_FLAUNCH */
FLAUNCH: /*Launches a selected file into an application*/



/*Begin launching the selected file*/
Current_Directory = DIRECTORY()
ChangeDir = DIRECTORY(File_Association.Index.2)
IF Setup.Application.File_Category.PPath.App_Num = Command_Processor_Path THEN DO
	REXXCommand = "CALL "File_Association.Index.1
	INTERPRET REXXCommand
END	/*Ends "IF Setup.Application.File_Category.PPath.App_Num = Command_Processor_Path THEN DO" Section*/
ELSE DO
	CommandLine = 'START 'File_Association.Index.1' "'OtherServicesFilePath.Index'"'
	INTERPRET "CommandLine"
END	/*Ends "ELSE DO" Section*/
/*End launching the selected file*/



/*Begin removing that file from the various stem variables and from the LAUNCH List Box*/
IF Index < Launch_FileName.0 THEN DO
	DO I = Index TO (Launch_FileName.0 - 1) BY 1
		J = I + 1
		Launch_FileName.I = Launch_FileName.J
		File_Association.I.1 = File_Association.J.1
		File_Association.I.2 = File_Association.J.2
		OtherServicesFilePath.I = OtherServicesFilePath.J
	END I	/*Ends "DO I = Index TO (Launch_FileName.0 - 1) BY 1" Section*/
END	/*Ends "IF Index < Launch_FileName.0 THEN DO" Section*/
I = Launch_FileName.0
Launch_FileName.I = ""
File_Association.I.1 = ""
File_Association.I.2 = ""
OtherServicesFilePath.I = ""
Launch_FileName.0 = Launch_FileName.0 - 1
File_Association.0.0 = File_Association.0.0 - 1
OtherServicesFilePath.0 = OtherServicesFilePath.0 - 1
Current_Directory = DIRECTORY(Current_Directory)
/* Delete a list item LAUNCH List Box */
CALL VpDeleteItem window,'LAUNCH',Index
File_SelectFlag = 0
/* Unselect all items LAUNCH List Box */
CALL VpSelect window,'LAUNCH','ALL',0
Index = 0
/*End removing that file from the various stem variables and from the LAUNCH List Box*/
RETURN

/* ##SUB_LISTDOWN */
LISTDOWN: /*Creates a list of the subdirectories of a given, selected, directory, and a separate list of the files in that directory*/



/*Begin clearing the LISTSUBDIRECTORIES list box, setting its initial position and size and enabling and showing it*/
/* Delete all items LISTSUBDIRECTORIES List Box */
CALL VpDeleteItem window,'LISTSUBDIRECTORIES','ALL'
/* Set item position/size LISTSUBDIRECTORIES List Box */
CALL VpItem window,'LISTSUBDIRECTORIES','SETITEMPOS',ListSubdirectories_xPosition,200,ListSubdirectories_xSize,128
/* Enable item LISTSUBDIRECTORIES List Box */
CALL VpItem window,'LISTSUBDIRECTORIES','ENABLE'
/* Show item LISTSUBDIRECTORIES List Box */
CALL VpItem window,'LISTSUBDIRECTORIES','SHOW'
/*End clearing the LISTSUBDIRECTORIES list box, setting its initial position and size and enabling and showing it*/



/*Begin enabling and showing the LISTSUBDIRECTORIESLABEL label*/
/* Enable item LISTSUBDIRECTORIESLABEL Text */
CALL VpItem window,'LISTSUBDIRECTORIESLABEL','ENABLE'
/* Show item LISTSUBDIRECTORIESLABEL Text */
CALL VpItem window,'LISTSUBDIRECTORIESLABEL','SHOW'
/*End enabling and showing the LISTSUBDIRECTORIESLABEL label*/



/*Begin clearing the LISTFILES list box, setting its initial position and size and disabling and hiding it*/
/* Delete all items LISTFILES List Box */
CALL VpDeleteItem window,'LISTFILES','ALL'
/* Set item position/size LISTFILES List Box */
CALL VpItem window,'LISTFILES','SETITEMPOS',ListFiles_xPosition,200,ListFiles_xSize,128
/* Disable item LISTFILES List Box */
CALL VpItem window,'LISTFILES','DISABLE'
/* Hide item LISTFILES List Box */
CALL VpItem window,'LISTFILES','HIDE'
/*End clearing the LISTFILES list box, setting its initial position and size and disabling and hiding it*/



/*Begin disabling and hiding the LISTFILESLABEL label*/
/* Disable item LISTFILESLABEL Text */
CALL VpItem window,'LISTFILESLABEL','DISABLE'
/* Hide item LISTFILESLABEL Text */
CALL VpItem window,'LISTFILESLABEL','HIDE'
/*End disabling and hiding the LISTFILESLABEL label*/



/*Begin disabling and hiding the OTHERSERVICESRADIOBUTTON radio button*/
/* Set item value OTHERSERVICESRADIOBUTTON Radio Button */
CALL VpSetItemValue window,'OTHERSERVICESRADIOBUTTON',value
/* Disable item OTHERSERVICESRADIOBUTTON Radio Button */
CALL VpItem window,'OTHERSERVICESRADIOBUTTON','DISABLE'
/* Hide item OTHERSERVICESRADIOBUTTON Radio Button */
CALL VpItem window,'OTHERSERVICESRADIOBUTTON','HIDE'
/*End disabling and hiding the OTHERSERVICESRADIOBUTTON radio button*/



/*Begin finding all directories directly under the selected directory, using the REXX Utilities SYSFILETREE() function*/
SubdirectoryResults. = ""
DirectorySearchRC = SYSFILETREE(Directory,"SubdirectoryResults","DO")
IF SubdirectoryResults.[0] > 32000 THEN SIGNAL ENDLISTDOWN	/*Safety valve to prevent SEEK from listing more than 32,000 directories (maximum size of a VisProREXX list is something slightly less than 33,000)*/
/*End finding all directories directly under the selected directory, using the REXX Utilities SYSFILETREE() function*/



/*Begin constructing the text for the LISTSUBDIRECTORIES Label*/
LengthOfPath = LENGTH(Path)
SELECT
	WHEN LengthOfPath <= 10 THEN PathText = Path"\"

	OTHERWISE DO	/*This section is to abbreviate the text for the labels because the path is too long (has too many letters)*/
		PARSE VAR Path First "\" Second "\" Remainder
		InputVariable = Remainder

		Counter = 0
		DO UNTIL Remainder = ""
			Counter = Counter + 1
			PARSE VAR InputVariable Firstpart "\" Remainder
			InputVariable = Remainder
		END	/*Ends "DO UNTIL Remainder = """ Section*/
		Counter = Counter - 1

		Last = Firstpart
		LengthOfLast = LENGTH(Last)
		IF LengthOfLast > 10 THEN DO
			Last = LEFT(Last,10)
			Last = Last"...,"
		END	/*Ends "IF LengthOfLast > 10 THEN DO" Section*/

		IF Counter > 0 THEN PathText = First"\"Second"\ ..., \"Last"\"
		ELSE PathText = Path"\"
	END	/*Ends "OTHERWISE DO" Section*/
END	/*Ends "SELECT" Section*/


SELECT
	WHEN SubdirectoryResults.0 > 0 THEN ListSubdirectoriesLabelText = PathText" subdirectories. Double click to select one of them."

	OTHERWISE ListSubdirectoriesLabelText = PathText" subdirectories (there are none)."
END	/*Ends "SELECT" Section*/
/*End constructing the text for the LISTSUBDIRECTORIES Label*/



/*Begin constructing the text for the SEEKTEXT Label*/
SELECT
	WHEN SysFileTreeOption = "FS" | SysFileTreeOption = "F" THEN
	SeekText = "Press the 'Seek Files' button to scan for the desired file(s) in the '"PathText"' directory."

	WHEN SysFileTreeOption = "DS" | SysFileTreeOption = "D" THEN
	SeekText = "Press the 'Seek Dirs' button to scan for the desired directory(s) in the '"PathText"' directory."

	OTHERWISE NOP
END	/*Ends "SELECT" Section*/
/*End constructing the text for the SEEKTEXT Label*/



/*Begin calculating the ySize of the LISTSUBDIRECTORIES List Box*/
/*Begin calculating the yPosition of the LISTSUBDIRECTORIESLABEL label*/
SELECT
	WHEN SubdirectoryResults.0 < 7 THEN ListSubdirectoriesySize = 134

	WHEN SubdirectoryResults.0 > 6 & SubdirectoryResults.0 < 20 THEN DO
		Delta = SubdirectoryResults.0 - 6
		ListSubdirectoriesySize = 48 + 8*Delta
		ListSubdirectoriesySize = ListSubdirectoriesySize*2.8%1
	END	/*Ends "WHEN SubdirectoryResults.0 > 6 & SubdirectoryResults.0 < 20 THEN DO" Section*/

	OTHERWISE ListSubdirectoriesySize = 600

END	/*Ends "SELECT" Section*/
/*End calculating the ySize of the LISTSUBDIRECTORIES List Box*/
ListSubdirectoriesyPosition = 200
ListSubdirectoriesLabelyPosition = 3 + ListSubdirectoriesyPosition + ListSubdirectoriesySize
/*End calculating the yPosition of the LISTSUBDIRECTORIESLABEL label*/
/*End calculating the ySize of the LISTSUBDIRECTORIES List Box*/



/*Begin setting the yPosition of the LISTSUBDIRECTORIESLABEL Label and the ySize of the LISTSUBDIRECTORIES list box*/
/* Set item position/size LISTSUBDIRECTORIESLABEL Text */
ListSubdirectoriesLabelxPosition = 50
ListSubdirectoriesLabelxSize = ListSubdirectories_xSize + (ListSubdirectories_xPosition - ListSubdirectoriesLabelxPosition)
CALL VpItem window,'LISTSUBDIRECTORIESLABEL','SETITEMPOS',ListSubdirectoriesLabelxPosition,ListSubdirectoriesLabelyPosition,ListSubdirectoriesLabelxSize,22
/* Set item position/size LISTSUBDIRECTORIES List Box */
CALL VpItem window,'LISTSUBDIRECTORIES','SETITEMPOS',ListSubdirectories_xPosition,200,ListSubdirectories_xSize,ListSubdirectoriesySize
/*End setting the yPosition of the LISTSUBDIRECTORIESLABEL Label and the ySize of the LISTSUBDIRECTORIES list box*/



/*Begin sizing, setting the position and adding the text to the SEEKTEXT Label*/
/* Set item position/size SEEKTEXT Text */
SeekTextxPosition = 50
SeekTextxSize = ListSubdirectories_xSize + (ListSubdirectories_xPosition - SeekTextxPosition)
CALL VpItem window,'SEEKTEXT','SETITEMPOS',SeekTextxPosition,160,SeekTextxSize,22
/* Set item value SEEKTEXT Text */
CALL VpSetItemValue window,'SEEKTEXT',SeekText
/*End sizing, setting the position and adding the text to the SEEKTEXT Label*/



/*Begin adding the text to the LISTSUBDIRECTORIESLABEL Label*/
/* Set item value LISTSUBDIRECTORIESLABEL Text */
CALL VpSetItemValue window,'LISTSUBDIRECTORIESLABEL',ListSubdirectoriesLabelText
/*End adding the text to the LISTSUBDIRECTORIESLABEL Label*/



/*Begin adding the text and setting the size and position of the GOUP radio button*/
/* Set item value GOUP Radio Button */
CALL VpSetItemValue window,'GOUP',UpLevel
/* Set item position/size GOUP Radio Button */
GOUPxPosition = 74
GOUPyPosition = ListSubdirectoriesLabelyPosition + 30
GOUPxSize = ListSubdirectories_xSize + (ListSubdirectories_xPosition - GOUPxPosition)
CALL VpItem window,'GOUP','SETITEMPOS',GOUPxPosition,GOUPyPosition,GOUPxSize,22
/*End adding the text and setting the size and position of the GOUP radio button*/



/*Begin adding the subdirectory names to the LISTSUBDIRECTORIES List Box*/
SELECT
	WHEN SubdirectoryResults.0 > 0 THEN DO
		DO J = 1 TO SubdirectoryResults.0 BY 1
			/* Add item sorted ascending LISTSUBDIRECTORIES List Box */
			index=VpAddItem(window, 'LISTSUBDIRECTORIES','ASCENDING',SubdirectoryResults.J)
		END J	/*Ends "DO J = 1 TO SubdirectoryResults.0 BY 1" Section*/
	END	/*Ends "WHEN SubdirectoryResults.0 > 0 THEN DO" Section*/

	OTHERWISE NOP
END	/*Ends "SELECT" Section*/
/*End adding the subdirectory names to the LISTSUBDIRECTORIES List Box*/



/*Begin enabling and showing the SEEK and CCANCEL push buttons*/
/* Enable item SEEK Push Button */
CALL VpItem window,'SEEK','ENABLE'
/* Show item SEEK Push Button */
CALL VpItem window,'SEEK','SHOW'
/* Enable item CCANCEL Push Button */
CALL VpItem window,'CCANCEL','ENABLE'
/* Show item CCANCEL Push Button */
CALL VpItem window,'CCANCEL','SHOW'
/*End enabling and showing the SEEK and CCANCEL push buttons*/
ENDLISTDOWN:
RETURN
/* ##SUB_LSTFILES */
LSTFILES: /*Creates a list of files matching the search criteria*/



/*Begin clearing the LISTSUBDIRECTORIES list box, setting its initial position and size and disabling and hiding it*/
/* Delete all items LISTSUBDIRECTORIES List Box */
CALL VpDeleteItem window,'LISTSUBDIRECTORIES','ALL'
/* Set item position/size LISTSUBDIRECTORIES List Box */
CALL VpItem window,'LISTSUBDIRECTORIES','SETITEMPOS',ListSubdirectories_xPosition,200,ListSubdirectories_xSize,128
/* Disable item LISTSUBDIRECTORIES List Box */
CALL VpItem window,'LISTSUBDIRECTORIES','DISABLE'
/* Hide item LISTSUBDIRECTORIES List Box */
CALL VpItem window,'LISTSUBDIRECTORIES','HIDE'
/*End clearing the LISTSUBDIRECTORIES list box, setting its initial position and size and disabling and hiding it*/



/*Begin disabling and hiding the LISTSUBDIRECTORIESLABEL label*/
/* Disable item LISTSUBDIRECTORIESLABEL Text */
CALL VpItem window,'LISTSUBDIRECTORIESLABEL','DISABLE'
/* Hide item LISTSUBDIRECTORIESLABEL Text */
CALL VpItem window,'LISTSUBDIRECTORIESLABEL','HIDE'
/*End disabling and hiding the LISTSUBDIRECTORIESLABEL label*/



/*Begin clearing the LISTFILES list box, setting its initial position and size and enabling and showing it*/
SELECT
	WHEN SelectType = "Single" THEN DO
		/* Delete all items LISTFILES List Box */
		CALL VpDeleteItem window,'LISTFILES','ALL'
		/* Set item position/size LISTFILES List Box */
		CALL VpItem window,'LISTFILES','SETITEMPOS',ListFiles_xPosition,200,ListFiles_xSize,128
		/* Enable item LISTFILES List Box */
		CALL VpItem window,'LISTFILES','ENABLE'
		/* Show item LISTFILES List Box */
		CALL VpItem window,'LISTFILES','SHOW'
	END	/*Ends "WHEN SelectType = "Single" THEN DO" Section*/

	WHEN SelectType = "Multiple" & Index = 1 THEN DO
		TotalDesiredFiles = 0
		/* Delete all items LISTFILES List Box */
		CALL VpDeleteItem window,'LISTFILES','ALL'
		/* Set item position/size LISTFILES List Box */
		CALL VpItem window,'LISTFILES','SETITEMPOS',ListFiles_xPosition,200,ListFiles_xSize,128
		/* Enable item LISTFILES List Box */
		CALL VpItem window,'LISTFILES','ENABLE'
		/* Show item LISTFILES List Box */
		CALL VpItem window,'LISTFILES','SHOW'
	END	/*Ends "WHEN SelectType = "Multiple" & Index = 1 THEN DO" Section*/

	OTHERWISE NOP
END	/*Ends "SELECT" Section*/
/*End clearing the LISTFILES list box, setting its initial position and size and enabling and showing it*/



/*Begin enabling and showing the LISTFILESLABEL label*/
/* Enable item LISTFILESLABEL Text */
CALL VpItem window,'LISTFILESLABEL','ENABLE'
/* Show item LISTFILESLABEL Text */
CALL VpItem window,'LISTFILESLABEL','SHOW'
/*End enabling and showing the LISTFILESLABEL label*/



/*Begin constructing the text for the LISTFILES Label*/
SELECT
	WHEN DesiredFiles.0 = 1 & (SysFileTreeOption = "FS" | SysFileTreeOption = "F") THEN SearchType = "file"

	WHEN DesiredFiles.0 = 1 & (SysFileTreeOption = "DS" | SysFileTreeOption = "D") THEN SearchType = "directory"

	WHEN SysFileTreeOption = "FS" | SysFileTreeOption = "F" THEN SearchType = "files"

	WHEN SysFileTreeOption = "DS" | SysFileTreeOption = "D" THEN SearchType = "directories"

	OTHERWISE NOP	
END


SELECT
	WHEN SelectType = "Single" THEN DO
		SELECT
			WHEN DesiredFiles.0 > 1 THEN ListFilesLabelText = "The following "DesiredFiles.0" "SearchType" match the search criteria:"

			WHEN DesiredFiles.0 = 1 THEN ListFilesLabelText = "The following "DesiredFiles.0" "SearchType" matches the search criteria:"

			WHEN DesiredFiles.0 = 0 THEN ListFilesLabelText = "There are no "SearchType" that match the search criteria."

			OTHERWISE NOP
		END	/*Ends "SELECT" Section*/
	END	/*Ends "WHEN SelectType = "Single" THEN DO" Section*/

	WHEN SelectType = "Multiple" THEN DO
		TotalDesiredFiles = TotalDesiredFiles + DesiredFiles.0
		SELECT
			WHEN TotalDesiredFiles > 0 THEN ListFilesLabelText = "The following "TotalDesiredFiles" "SearchType" match the search criteria:"

			WHEN TotalDesiredFiles = 0 THEN ListFilesLabelText = "There are no "SearchType" that match the search criteria."

			OTHERWISE NOP
		END	/*Ends "SELECT" Section*/
	END	/*Ends "WHEN SelectType = "Multiple" THEN DO" Section*/

	OTHERWISE NOP
END	/*Ends "SELECT" Section*/
/*End constructing the text for the LISTFILES Label*/



/*Begin calculating the ySize of the LISTFILES List Box*/
/*Begin calculating the yPosition of the LISTFILESLABEL label*/
SELECT
	WHEN SelectType = "Single" THEN DO
		SELECT
			WHEN DesiredFiles.0 < 7 THEN ListFilesySize = 134

			WHEN DesiredFiles.0 > 6 & DesiredFiles.0 < 20 THEN DO
				Delta = DesiredFiles.0 - 6
				ListFilesySize = 48 + 8*Delta
				ListFilesySize = ListFilesySize*2.8%1
			END	/*Ends "DesiredFiles.0 > 6 & DesiredFiles.0 < 20 THEN DO" Section*/

			OTHERWISE ListFilesySize = 510
		END	/*Ends "SELECT" Section*/
	END	/*Ends "WHEN SelectType = "Single" THEN DO" Section*/

	WHEN SelectType = "Multiple" THEN DO
		SELECT
			WHEN TotalDesiredFiles < 7 THEN ListFilesySize = 134

			WHEN TotalDesiredFiles > 6 & TotalDesiredFiles < 20 THEN DO
				Delta = TotalDesiredFiles - 6
				ListFilesySize = 48 + 8*Delta
				ListFilesySize = ListFilesySize*2.8%1
			END	/*Ends "TotalDesiredFiles > 6 & TotalDesiredFiles < 20 THEN DO" Section*/

			OTHERWISE ListFilesySize = 510
		END	/*Ends "SELECT" Section*/
	END	/*Ends "WHEN SelectType = "Multiple" THEN DO" Section*/

	OTHERWISE NOP
END	/*Ends "SELECT" Section*/
/*End calculating the ySize of the LISTFILES List Box*/
ListFilesyPosition = 362
ListFilesLabelyPosition = 3 + ListFilesyPosition + ListFilesySize
/*End calculating the yPosition of the LISTFILESLABEL label*/
/*End calculating the ySize of the LISTFILES List Box*/



/*Begin setting the yPosition of the LISTFILESLABEL Label and the ySize of the LISTFILES list box*/
/* Set item position/size LISTFILESLABEL Text */
ListSubdirectoriesLabelxPosition = 50
ListSubdirectoriesLabelxSize = ListSubdirectories_xSize + (ListSubdirectories_xPosition - ListSubdirectoriesLabelxPosition)
CALL VpItem window,'LISTFILESLABEL','SETITEMPOS',ListSubdirectoriesLabelxPosition,ListFilesLabelyPosition,ListSubdirectoriesLabelxSize,22
/* Set item position/size LISTFILES List Box */
CALL VpItem window,'LISTFILES','SETITEMPOS',ListFiles_xPosition,ListFilesyPosition,ListFiles_xSize,ListFilesySize
/*End setting the yPosition of the LISTFILESLABEL Label and the ySize of the LISTFILES list box*/



/*Begin clearing, disabling and hiding the SEEKTEXT Label*/
/* Set item value SEEKTEXT Text */
CALL VpSetItemValue window,'SEEKTEXT',""
/* Disable item SEEKTEXT Text */
CALL VpItem window,'SEEKTEXT','DISABLE'
/* Hide item SEEKTEXT Text */
CALL VpItem window,'SEEKTEXT','HIDE'
/*End clearing, disabling and hiding the SEEKTEXT Label*/



/*Begin enabling, showing and setting the value of the OTHERSERVICESRADIOBUTTON radio button*/
/* Enable item OTHERSERVICESRADIOBUTTON Radio Button */
CALL VpItem window,'OTHERSERVICESRADIOBUTTON','ENABLE'
/* Show item OTHERSERVICESRADIOBUTTON Radio Button */
CALL VpItem window,'OTHERSERVICESRADIOBUTTON','SHOW'
	
IF SysFileTreeOption = "FS" | SysFileTreeOption = "F" THEN OtherServicesText = "Highlight the files desired for other services. Double click to initiate, or press this radio button."
IF SysFileTreeOption = "DS" | SysFileTreeOption = "D" THEN OtherServicesText = "Highlight the directories desired for other services. Double click to initiate, or press this radio button."

/* Set item value OTHERSERVICESRADIOBUTTON Radio Button */
CALL VpSetItemValue window,'OTHERSERVICESRADIOBUTTON',OtherServicesText
/*End enabling, showing and setting the value of the OTHERSERVICESRADIOBUTTON radio button*/



/*Begin adding the text to the LISTFILESLABEL Label*/
/* Set item value LISTFILESLABEL Text */
CALL VpSetItemValue window,'LISTFILESLABEL',ListFilesLabelText
/*End adding the text to the LISTFILESLABEL Label*/



/*Begin setting the size and position of the GOUP radio button and then disabling and hiding it*/
/* Set item value GOUP Radio Button */
CALL VpSetItemValue window,'GOUP',UpLevel
/* Set item position/size GOUP Radio Button */
GOUPxPosition = 74
ListSubdirectoriesyPosition = 200
ListSubdirectoriesySize = 128
ListSubdirectoriesLabelyPosition = 3 + ListSubdirectoriesyPosition + ListSubdirectoriesySize
GOUPyPosition = ListSubdirectoriesLabelyPosition + 30
GOUPxSize = ListSubdirectories_xSize + (ListSubdirectories_xPosition - GOUPxPosition)
CALL VpItem window,'GOUP','SETITEMPOS',GOUPxPosition,GOUPyPosition,GOUPxSize,22
/* Disable item GOUP Radio Button */
CALL VpItem window,'GOUP','DISABLE'
/* Hide item GOUP Radio Button */
CALL VpItem window,'GOUP','HIDE'
/*End hiding and setting the size and position of the GOUP radio button and then disabling and hiding it*/



/*Begin adding the filenames to the LISTFILES List Box*/
SELECT
	WHEN DesiredFiles.0 > 0 THEN DO
		/* Add items from list LISTFILES List Box */
		index=VpAddItem(window, 'LISTFILES', 'LIST', 'DesiredFiles.')
		NOP
	END	/*Ends "WHEN DesiredFiles.0 > 0 THEN DO" Section*/

	OTHERWISE NOP
END	/*Ends "SELECT" Section*/
SelectedIndices.0 = 0
RadioButtonSelect = "NO"
ManualDeSelect = "NO"
HighLightRow1 = 1
HighLightRow2 = DesiredFiles.0
DeHighLightRow1 = 1
DeHighLightRow2 = DesiredFiles.0
/*End adding the filenames to the LISTFILES List Box*/



/*Begin enabling and showing the SEEK and CCANCEL push buttons and setting the text on the SEEK and CCANCEL push button*/
/* Enable item SEEK Push Button */
CALL VpItem window,'SEEK','ENABLE'
/* Show item SEEK Push Button */
CALL VpItem window,'SEEK','SHOW'
/* Set item value SEEK Push Button */
CALL VpSetItemValue window,'SEEK',"Do Another"
/* Enable item CCANCEL Push Button */
CALL VpItem window,'CCANCEL','ENABLE'
/* Show item CCANCEL Push Button */
CALL VpItem window,'CCANCEL','SHOW'
/* Set item value CCANCEL Push Button */
CALL VpSetItemValue window,'CCANCEL',"End Program"
/*End enabling and showing the SEEK and CCANCEL push buttons and setting the text on the SEEK and CCANCEL push buttons*/



/*Begin setting the variable, ListType, to "Files"*/
ListType = "Files"
/*End setting the variable, ListType, to "Files"*/
RETURN
/* ##SUB_MANLNCH */
MANLNCH: /*Sets the positions of various controls on the LAUNCH form, when the MANUAL control is selected*/



/* Get button state MANUAL Radio Button */
ManualFlag = VpIsSelected(window,'MANUAL')
IF ManualFlag = 1 THEN DO
/*Begin setting the positions and sizes of the LAUNCH form and all its controls to their original positions and sizes*/
	xy=VpWindow(window,'GETSIZE')
	PARSE VAR xy x ySSize_Win
	yPPos_Win_Man = yPPos_WinOrigin - Launch_Unlock*29
	ySSize_Win_Man = ySSize_Win + Launch_Unlock*40
	CALL VpWindow window,'SETPOS', xPPos_WinOrigin, yPPos_Win_Man, xSSize_Win, ySSize_Win_Man

	/* Get item position INSTRUCT Text */
	xy=VpItem(window,'INSTRUCT','ITEMPOS')
	PARSE VAR xy xPPos yPPos
	/* Get item size INSTRUCT Text */
	xy=VpItem(window,'INSTRUCT','ITEMSIZE')
	PARSE VAR xy xSSize ySSize
	yPPos = yPPos + Launch_Unlock*40
	/* Set item position/size INSTRUCT Text */
	CALL VpItem window,'INSTRUCT','SETITEMPOS',xPPos,yPPos,xSSize,ySSize
	Instruction = "Highlight (single click on) the desired filename. Next, select the application to launch."
	/* Set item value INSTRUCT Text */
	CALL VpSetItemValue window,'INSTRUCT',Instruction

	/* Get item position LAUNCH List Box */
	xy=VpItem(window,'LAUNCH','ITEMPOS')
	PARSE VAR xy xPPos yPPos
	/* Get item size LAUNCH List Box */
	xy=VpItem(window,'LAUNCH','ITEMSIZE')
	PARSE VAR xy xSSize ySSize
	yPPos = yPPos + Launch_Unlock*40
	/* Set item position/size LAUNCH List Box */
	CALL VpItem window,'LAUNCH','SETITEMPOS',xPPos,yPPos,xSSize,ySSize

	/* Get item position AUTO List Box */
	xy=VpItem(window,'AUTO','ITEMPOS')
	PARSE VAR xy xPPos yPPos
	/* Get item size AUTO List Box */
	xy=VpItem(window,'AUTO','ITEMSIZE')
	PARSE VAR xy xSSize ySSize
	yPPos = yPPos + Launch_Unlock*40
	/* Set item position/size AUTO List Box */
	CALL VpItem window,'AUTO','SETITEMPOS',xPPos,yPPos,xSSize,ySSize
	/* Set item value AUTO Radio Button */
	CALL VpSetItemValue window,'AUTO',"Automated"

	/* Get item position MANUAL List Box */
	xy=VpItem(window,'MANUAL','ITEMPOS')
	PARSE VAR xy xPPos yPPos
	/* Get item size MANUAL List Box */
	xy=VpItem(window,'MANUAL','ITEMSIZE')
	PARSE VAR xy xSSize ySSize
	yPPos = yPPos + Launch_Unlock*40
	/* Set item position/size MANUAL List Box */
	CALL VpItem window,'MANUAL','SETITEMPOS',xPPos,yPPos,xSSize,ySSize
	/* Set item value MANUAL Radio Button */
	CALL VpSetItemValue window,'MANUAL',"Manual"

	/* Get item position LAUNCHBOX List Box */
	xy=VpItem(window,'LAUNCHBOX','ITEMPOS')
	PARSE VAR xy xPPos yPPos
	/* Get item size LAUNCHBOX List Box */
	xy=VpItem(window,'LAUNCHBOX','ITEMSIZE')
	PARSE VAR xy xSSize ySSize
	yPPos = yPPos + Launch_Unlock*40
	/* Set item position/size LAUNCHBOX List Box */
	CALL VpItem window,'LAUNCHBOX','SETITEMPOS',xPPos,yPPos,xSSize,ySSize

	Count = Launch_Unlock + 1
	xPPosition = 60
	yPPosition = 95
	xSSize = 600
	ySSize = 20

	IF Setup.Application.WP.NName.0 > 0 THEN DO
		Count = Count - 1
		yPPositionNew = yPPosition + Count*40
		/* Set item position/size WP Radio Button */
		CALL VpItem window,'WP','SETITEMPOS',xPPosition,yPPositionNew,xSSize,ySSize
		/* Show item WP Radio Button */
		CALL VpItem window,'WP','SHOW'
		/* Enable item WP Radio Button */
		CALL VpItem window,'WP','ENABLE'
		/* Set item value WP Radio Button */
		CALL VpSetItemValue window,'WP',Setup.Application.WP.NName.1
	END	/*Ends "IF Setup.Application.WP.NName.0 > 0 THEN DO" Section*/

	IF Setup.Application.N_ED.NName.0 > 0 THEN DO
		Count = Count - 1
		yPPositionNew = yPPosition + Count*40
		/* Set item position/size N_ED Radio Button */
		CALL VpItem window,'N_ED','SETITEMPOS',xPPosition,yPPositionNew,xSSize,ySSize
		/* Show item N_ED Radio Button */
		CALL VpItem window,'N_ED','SHOW'
		/* Enable item N_ED Radio Button */
		CALL VpItem window,'N_ED','ENABLE'
		/* Set item value N_ED Radio Button */
		CALL VpSetItemValue window,'N_ED',"Text Editors:"
	END	/*Ends "IF Setup.Application.N_ED.NName.0 > 0 THEN DO" Section*/

	IF Setup.Application.R_ED.NName.0 > 0 THEN DO
		Count = Count - 1
		yPPositionNew = yPPosition + Count*40
		/* Set item position/size R_ED Radio Button */
		CALL VpItem window,'R_ED','SETITEMPOS',xPPosition,yPPositionNew,xSSize,ySSize
		/* Show item R_ED Radio Button */
		CALL VpItem window,'R_ED','SHOW'
		/* Enable item R_ED Radio Button */
		CALL VpItem window,'R_ED','ENABLE'
		/* Set item value R_ED Radio Button */
		CALL VpSetItemValue window,'R_ED',"REXX Editors:"
	END	/*Ends "IF Setup.Application.R_ED.NName.0 > 0 THEN DO" Section*/

	IF Setup.Application.L_ED.NName.0 > 0 THEN DO
		Count = Count - 1
		yPPositionNew = yPPosition + Count*40
		/* Set item position/size L_ED Radio Button */
		CALL VpItem window,'L_ED','SETITEMPOS',xPPosition,yPPositionNew,xSSize,ySSize
		/* Show item L_ED Radio Button */
		CALL VpItem window,'L_ED','SHOW'
		/* Enable item L_ED Radio Button */
		CALL VpItem window,'L_ED','ENABLE'
		/* Set item value L_ED Radio Button */
		CALL VpSetItemValue window,'L_ED',Setup.Application.L_ED.NName.1" (Latex editor)"
	END	/*Ends "IF Setup.Application.L_ED.NName.0 > 0 THEN DO" Section*/

	IF Setup.Application.R_R.NName.0 > 0 THEN DO
		Count = Count - 1
		yPPositionNew = yPPosition + Count*40
		/* Set item position/size R_R Radio Button */
		CALL VpItem window,'R_R','SETITEMPOS',xPPosition,yPPositionNew,xSSize,ySSize
		/* Show item R_R Radio Button */
		CALL VpItem window,'R_R','SHOW'
		/* Enable item R_R Radio Button */
		CALL VpItem window,'R_R','ENABLE'
		/* Set item value R_R Radio Button */
		CALL VpSetItemValue window,'R_R',"REXX Execution Applications:"
	END	/*Ends "IF Setup.Application.R_R.NName.0 > 0 THEN DO" Section*/

	IF Setup.Application.SS.NName.0 > 0 THEN DO
		Count = Count - 1
		yPPositionNew = yPPosition + Count*40
		/* Set item position/size SS Radio Button */
		CALL VpItem window,'SS','SETITEMPOS',xPPosition,yPPositionNew,xSSize,ySSize
		/* Show item SS Radio Button */
		CALL VpItem window,'SS','SHOW'
		/* Enable item SS Radio Button */
		CALL VpItem window,'SS','ENABLE'
		/* Set item value SS Radio Button */
		CALL VpSetItemValue window,'SS',Setup.Application.SS.NName.1
	END	/*Ends "IF Setup.Application.SS.NName.0 > 0 THEN DO" Section*/

	IF Setup.Application.FIN.NName.0 > 0 THEN DO
		Count = Count - 1
		yPPositionNew = yPPosition + Count*40
		/* Set item position/size FIN Radio Button */
		CALL VpItem window,'FIN','SETITEMPOS',xPPosition,yPPositionNew,xSSize,ySSize
		/* Show item FIN Radio Button */
		CALL VpItem window,'FIN','SHOW'
		/* Enable item FIN Radio Button */
		CALL VpItem window,'FIN','ENABLE'
		/* Set item value FIN Radio Button */
		CALL VpSetItemValue window,'FIN',Setup.Application.FIN.NName.1" Finance"
	END	/*Ends "IF Setup.Application.FIN.NName.0 > 0 THEN DO" Section*/

	IF Setup.Application.WB.NName.0 > 0 THEN DO
		Count = Count - 1
		yPPositionNew = yPPosition + Count*40
		/* Set item position/size WB Radio Button */
		CALL VpItem window,'WB','SETITEMPOS',xPPosition,yPPositionNew,xSSize,ySSize
		/* Show item WB Radio Button */
		CALL VpItem window,'WB','SHOW'
		/* Enable item WB Radio Button */
		CALL VpItem window,'WB','ENABLE'
		/* Set item value WB Radio Button */
		CALL VpSetItemValue window,'WB',"Web Browsers:"
	END	/*Ends "IF Setup.Application.WB.NName.0 > 0 THEN DO" Section*/

	IF Setup.Application.PDF.NName.0 > 0 THEN DO
		Count = Count - 1
		yPPositionNew = yPPosition + Count*40
		/* Set item position/size PDF Radio Button */
		CALL VpItem window,'PDF','SETITEMPOS',xPPosition,yPPositionNew,xSSize,ySSize
		/* Show item PDF Radio Button */
		CALL VpItem window,'PDF','SHOW'
		/* Enable item PDF Radio Button */
		CALL VpItem window,'PDF','ENABLE'
		/* Set item value PDF Radio Button */
		CALL VpSetItemValue window,'PDF',"PDF Readers:"
	END	/*Ends "IF Setup.Application.PDF.NName.0 > 0 THEN DO" Section*/

	IF Setup.Application.PS.NName.0 > 0 THEN DO
		Count = Count - 1
		yPPositionNew = yPPosition + Count*40
		/* Set item position/size PS Radio Button */
		CALL VpItem window,'PS','SETITEMPOS',xPPosition,yPPositionNew,xSSize,ySSize
		/* Show item PS Radio Button */
		CALL VpItem window,'PS','SHOW'
		/* Enable item PS Radio Button */
		CALL VpItem window,'PS','ENABLE'
		/* Set item value PS Radio Button */
		CALL VpSetItemValue window,'PS',"PS and EPS Readers:"
	END	/*Ends "IF Setup.Application.PS.NName.0 > 0 THEN DO" Section*/

	IF Setup.Application.Graphics.NName.0 > 0 THEN DO
		Count = Count - 1
		yPPositionNew = yPPosition + Count*40
		/* Set item position/size GRAPHICS Radio Button */
		CALL VpItem window,'GRAPHICS','SETITEMPOS',xPPosition,yPPositionNew,xSSize,ySSize
		/* Show item GRAPHICS Radio Button */
		CALL VpItem window,'GRAPHICS','SHOW'
		/* Enable item GRAPHICS Radio Button */
		CALL VpItem window,'GRAPHICS','ENABLE'
		/* Set item value GRAPHICS Radio Button */
		CALL VpSetItemValue window,'GRAPHICS',Setup.Application.Graphics.NName.1
	END	/*Ends "IF Setup.Application.Graphics.NName.0 > 0 THEN DO" Section*/

	IF Setup.Application.Drafting.NName.0 > 0 THEN DO
		Count = Count - 1
		yPPositionNew = yPPosition + Count*40
		/* Set item position/size DRAFTING Radio Button */
		CALL VpItem window,'DRAFTING','SETITEMPOS',xPPosition,yPPositionNew,xSSize,ySSize
		/* Show item DRAFTING Radio Button */
		CALL VpItem window,'DRAFTING','SHOW'
		/* Enable item DRAFTING Radio Button */
		CALL VpItem window,'DRAFTING','ENABLE'
		/* Set item value DRAFTING Radio Button */
		CALL VpSetItemValue window,'DRAFTING',Setup.Application.Drafting.NName.1
	END	/*Ends "IF Setup.Application.Drafting.NName.0 > 0 THEN DO" Section*/

	IF Setup.Application.User_Defined.NName.0 > 0 THEN DO
		Count = Count - 1
		yPPositionNew = yPPosition + Count*40
		/* Set item position/size USER_DEFINED Radio Button */
		CALL VpItem window,'USER_DEFINED','SETITEMPOS',xPPosition,yPPositionNew,xSSize,ySSize
		/* Show item USER_DEFINED Radio Button */
		CALL VpItem window,'USER_DEFINED','SHOW'
		/* Enable item USER_DEFINED Radio Button */
		CALL VpItem window,'USER_DEFINED','ENABLE'
		/* Set item value USER_DEFINED Radio Button */
		CALL VpSetItemValue window,'USER_DEFINED',"User Defined Applications:"
	END	/*Ends "IF Setup.Application.User_Defined.NName.0 > 0 THEN DO" Section*/

	/* Hide item AUTO Radio Button */
	CALL VpItem window,'AUTO','HIDE'
	/* Show item AUTO Radio Button */
	CALL VpItem window,'AUTO','SHOW'
	/* Hide item MANUAL Radio Button */
	CALL VpItem window,'MANUAL','HIDE'
	/* Show item MANUAL Radio Button */
	CALL VpItem window,'MANUAL','SHOW'

	Mult_AppsFlag = 0
/*End setting the positions and sizes of the LAUNCH form and all its controls to their original positions and sizes*/
END	/*Ends "IF ManualFlag = 1" Section*/
RETURN

/* ##SUB_MULTAPPS */
MULTAPPS: /*Sets the positions of various Radio Button controls on the LAUNCH form, when a Radio Button control is selected, that has 2 or more associated applications*/



/* Get button state MANUAL Radio Button */
ManualFlag = VpIsSelected(window,'MANUAL')
IF ManualFlag = 1 THEN DO
	CALL VpSelect window,'AUTO',1
	CALL AUTOLNCH

	/*Begin setting the positions and sizes of the LAUNCH form and all its controls to their original positions and sizes*/
	xy=VpWindow(window,'GETSIZE')
	PARSE VAR xy x ySSize_Win
	yPPos_Win_Man = yPPos_WinOrigin - Total_Apps*29
	ySSize_Win_Man = ySSize_Win + Total_Apps*30
	CALL VpWindow window,'SETPOS', xPPos_WinOrigin, yPPos_Win_Man, xSSize_Win, ySSize_Win_Man

	/* Get item position INSTRUCT Text */
	xy=VpItem(window,'INSTRUCT','ITEMPOS')
	PARSE VAR xy xPPos yPPos
	/* Get item size INSTRUCT Text */
	xy=VpItem(window,'INSTRUCT','ITEMSIZE')
	PARSE VAR xy xSSize ySSize
	yPPos = yPPos + Total_Apps*30
	/* Set item position/size INSTRUCT Text */
	CALL VpItem window,'INSTRUCT','SETITEMPOS',xPPos,yPPos,xSSize,ySSize
	Instruction = "Highlight (single click on) the desired filename. Next, select the application to launch."
	/* Set item value INSTRUCT Text */
	CALL VpSetItemValue window,'INSTRUCT',Instruction

	/* Get item position LAUNCH List Box */
	xy=VpItem(window,'LAUNCH','ITEMPOS')
	PARSE VAR xy xPPos yPPos
	/* Get item size LAUNCH List Box */
	xy=VpItem(window,'LAUNCH','ITEMSIZE')
	PARSE VAR xy xSSize ySSize
	yPPos = yPPos + Total_Apps*30
	/* Set item position/size LAUNCH List Box */
	CALL VpItem window,'LAUNCH','SETITEMPOS',xPPos,yPPos,xSSize,ySSize

	/* Get item position AUTO List Box */
	xy=VpItem(window,'AUTO','ITEMPOS')
	PARSE VAR xy xPPos yPPos
	/* Get item size AUTO List Box */
	xy=VpItem(window,'AUTO','ITEMSIZE')
	PARSE VAR xy xSSize ySSize
	yPPos = yPPos + Total_Apps*30
	/* Set item position/size AUTO List Box */
	CALL VpItem window,'AUTO','SETITEMPOS',xPPos,yPPos,xSSize,ySSize
	/* Set item value AUTO Radio Button */
	CALL VpSetItemValue window,'AUTO',"Automated"

	/* Get item position MANUAL List Box */
	xy=VpItem(window,'MANUAL','ITEMPOS')
	PARSE VAR xy xPPos yPPos
	/* Get item size MANUAL List Box */
	xy=VpItem(window,'MANUAL','ITEMSIZE')
	PARSE VAR xy xSSize ySSize
	yPPos = yPPos + Total_Apps*30
	/* Set item position/size MANUAL List Box */
	CALL VpItem window,'MANUAL','SETITEMPOS',xPPos,yPPos,xSSize,ySSize
	/* Set item value MANUAL Radio Button */
	CALL VpSetItemValue window,'MANUAL',"Manual"

	/* Get item position LAUNCHBOX List Box */
	xy=VpItem(window,'LAUNCHBOX','ITEMPOS')
	PARSE VAR xy xPPos yPPos
	/* Get item size LAUNCHBOX List Box */
	xy=VpItem(window,'LAUNCHBOX','ITEMSIZE')
	PARSE VAR xy xSSize ySSize
	yPPos = yPPos + Total_Apps*30
	/* Set item position/size LAUNCHBOX List Box */
	CALL VpItem window,'LAUNCHBOX','SETITEMPOS',xPPos,yPPos,xSSize,ySSize

	xPPosition = 60
	yPPosition = 95
	xSSize = 600
	ySSize = 20

	IF Setup.Application.WP.NName.0 > 0 & Application_SelectFlag = 1 THEN DO
		yPPositionNew = yPPosition + Total_Apps*30
		/* Set item position/size WP Radio Button */
		CALL VpItem window,'WP','SETITEMPOS',xPPosition,yPPositionNew,xSSize,ySSize
		/* Show item WP Radio Button */
		CALL VpItem window,'WP','SHOW'
		/* Enable item WP Radio Button */
		CALL VpItem window,'WP','ENABLE'
		/* Set item value WP Radio Button */
		CALL VpSetItemValue window,'WP',Setup.Application.WP.NName.1
		CALL MULT_APP_POSITIONS
		/* Uncheck the item WP Radio Button */
		CALL VpSelect window,'WP',0
	END	/*Ends "IF Setup.Application.WP.NName.0 > 0 & Application_SelectFlag = 1 THEN DO" Section*/

	IF Setup.Application.N_ED.NName.0 > 0 & Application_SelectFlag = 2 THEN DO
		yPPositionNew = yPPosition + Total_Apps*30
		/* Set item position/size N_ED Radio Button */
		CALL VpItem window,'N_ED','SETITEMPOS',xPPosition,yPPositionNew,xSSize,ySSize
		/* Show item N_ED Radio Button */
		CALL VpItem window,'N_ED','SHOW'
		/* Enable item N_ED Radio Button */
		CALL VpItem window,'N_ED','ENABLE'
		/* Set item value N_ED Radio Button */
		CALL VpSetItemValue window,'N_ED',"Text Editors:"
		CALL MULT_APP_POSITIONS
		/* Uncheck the item N_ED Radio Button */
		CALL VpSelect window,'N_ED',0
	END	/*Ends "IF Setup.Application.N_ED.NName.0 > 0 & Application_SelectFlag = 2 THEN DO" Section*/

	IF Setup.Application.R_ED.NName.0 > 0 & Application_SelectFlag = 3 THEN DO
		yPPositionNew = yPPosition + Total_Apps*30
		/* Set item position/size R_ED Radio Button */
		CALL VpItem window,'R_ED','SETITEMPOS',xPPosition,yPPositionNew,xSSize,ySSize
		/* Show item R_ED Radio Button */
		CALL VpItem window,'R_ED','SHOW'
		/* Enable item R_ED Radio Button */
		CALL VpItem window,'R_ED','ENABLE'
		/* Set item value R_ED Radio Button */
		CALL VpSetItemValue window,'R_ED',"REXX Editors:"
		CALL MULT_APP_POSITIONS
		/* Uncheck the item R_ED Radio Button */
		CALL VpSelect window,'R_ED',0
	END	/*Ends "IF Setup.Application.R_ED.NName.0 > 0 & Application_SelectFlag = 3 THEN DO" Section*/

	IF Setup.Application.L_ED.NName.0 > 0 & Application_SelectFlag = 4 THEN DO
		yPPositionNew = yPPosition + Total_Apps*30
		/* Set item position/size L_ED Radio Button */
		CALL VpItem window,'L_ED','SETITEMPOS',xPPosition,yPPositionNew,xSSize,ySSize
		/* Show item L_ED Radio Button */
		CALL VpItem window,'L_ED','SHOW'
		/* Enable item L_ED Radio Button */
		CALL VpItem window,'L_ED','ENABLE'
		/* Set item value L_ED Radio Button */
		CALL VpSetItemValue window,'L_ED',Setup.Application.L_ED.NName.1" (Latex editor)"
		CALL MULT_APP_POSITIONS
		/* Uncheck the item L_ED Radio Button */
		CALL VpSelect window,'L_ED',0
	END	/*Ends "IF Setup.Application.L_ED.NName.0 > 0 & Application_SelectFlag = 4 THEN DO" Section*/

	IF Setup.Application.R_R.NName.0 > 0 & Application_SelectFlag = 5 THEN DO
		yPPositionNew = yPPosition + Total_Apps*30
		/* Set item position/size R_R Radio Button */
		CALL VpItem window,'R_R','SETITEMPOS',xPPosition,yPPositionNew,xSSize,ySSize
		/* Show item R_R Radio Button */
		CALL VpItem window,'R_R','SHOW'
		/* Enable item R_R Radio Button */
		CALL VpItem window,'R_R','ENABLE'
		/* Set item value R_R Radio Button */
		CALL VpSetItemValue window,'R_R',"REXX Execution Applications:"
		CALL MULT_APP_POSITIONS
		/* Uncheck the item R_R Radio Button */
		CALL VpSelect window,'R_R',0
	END	/*Ends "IF Setup.Application.R_R.NName.0 > 0 & Application_SelectFlag = 5 THEN DO" Section*/

	IF Setup.Application.SS.NName.0 > 0 & Application_SelectFlag = 6 THEN DO
		yPPositionNew = yPPosition + Total_Apps*30
		/* Set item position/size SS Radio Button */
		CALL VpItem window,'SS','SETITEMPOS',xPPosition,yPPositionNew,xSSize,ySSize
		/* Show item SS Radio Button */
		CALL VpItem window,'SS','SHOW'
		/* Enable item SS Radio Button */
		CALL VpItem window,'SS','ENABLE'
		/* Set item value SS Radio Button */
		CALL VpSetItemValue window,'SS',Setup.Application.SS.NName.1
		CALL MULT_APP_POSITIONS
		/* Uncheck the item SS Radio Button */
		CALL VpSelect window,'SS',0
	END	/*Ends "IF Setup.Application.SS.NName.0 > 0 & Application_SelectFlag = 6 THEN DO" Section*/

	IF Setup.Application.FIN.NName.0 > 0 & Application_SelectFlag = 7 THEN DO
		yPPositionNew = yPPosition + Total_Apps*30
		/* Set item position/size FIN Radio Button */
		CALL VpItem window,'FIN','SETITEMPOS',xPPosition,yPPositionNew,xSSize,ySSize
		/* Show item FIN Radio Button */
		CALL VpItem window,'FIN','SHOW'
		/* Enable item FIN Radio Button */
		CALL VpItem window,'FIN','ENABLE'
		/* Set item value FIN Radio Button */
		CALL VpSetItemValue window,'FIN',Setup.Application.FIN.NName.1" Finance"
		CALL MULT_APP_POSITIONS
		/* Uncheck the item FIN Radio Button */
		CALL VpSelect window,'FIN',0
	END	/*Ends "IF Setup.Application.FIN.NName.0 > 0 & Application_SelectFlag = 7 THEN DO" Section*/

	IF Setup.Application.WB.NName.0 > 0 & Application_SelectFlag = 8 THEN DO
		yPPositionNew = yPPosition + Total_Apps*30
		/* Set item position/size WB Radio Button */
		CALL VpItem window,'WB','SETITEMPOS',xPPosition,yPPositionNew,xSSize,ySSize
		/* Show item WB Radio Button */
		CALL VpItem window,'WB','SHOW'
		/* Enable item WB Radio Button */
		CALL VpItem window,'WB','ENABLE'
		/* Set item value WB Radio Button */
		CALL VpSetItemValue window,'WB',"Web Browsers:"
		CALL MULT_APP_POSITIONS
		/* Uncheck the item WB Radio Button */
		CALL VpSelect window,'WB',0
	END	/*Ends "IF Setup.Application.WB.NName.0 > 0 & Application_SelectFlag = 8 THEN DO" Section*/

	IF Setup.Application.PDF.NName.0 > 0 & Application_SelectFlag = 9 THEN DO
		yPPositionNew = yPPosition + Total_Apps*30
		/* Set item position/size PDF Radio Button */
		CALL VpItem window,'PDF','SETITEMPOS',xPPosition,yPPositionNew,xSSize,ySSize
		/* Show item PDF Radio Button */
		CALL VpItem window,'PDF','SHOW'
		/* Enable item PDF Radio Button */
		CALL VpItem window,'PDF','ENABLE'
		/* Set item value PDF Radio Button */
		CALL VpSetItemValue window,'PDF',"PDF Readers:"
		CALL MULT_APP_POSITIONS
		/* Uncheck the item PDF Radio Button */
		CALL VpSelect window,'PDF',0
	END	/*Ends "IF Setup.Application.PDF.NName.0 > 0 & Application_SelectFlag = 9 THEN DO" Section*/

	IF Setup.Application.PS.NName.0 > 0 & Application_SelectFlag = 10 THEN DO
		yPPositionNew = yPPosition + Total_Apps*30
		/* Set item position/size PS Radio Button */
		CALL VpItem window,'PS','SETITEMPOS',xPPosition,yPPositionNew,xSSize,ySSize
		/* Show item PS Radio Button */
		CALL VpItem window,'PS','SHOW'
		/* Enable item PS Radio Button */
		CALL VpItem window,'PS','ENABLE'
		/* Set item value PS Radio Button */
		CALL VpSetItemValue window,'PS',"PS and EPS Readers:"
		CALL MULT_APP_POSITIONS
		/* Uncheck the item PS Radio Button */
		CALL VpSelect window,'PS',0
	END	/*Ends "IF Setup.Application.PS.NName.0 > 0 & Application_SelectFlag = 10 THEN DO" Section*/

	IF Setup.Application.Graphics.NName.0 > 0 & Application_SelectFlag = 11 THEN DO
		yPPositionNew = yPPosition + Total_Apps*30
		/* Set item position/size GRAPHICS Radio Button */
		CALL VpItem window,'GRAPHICS','SETITEMPOS',xPPosition,yPPositionNew,xSSize,ySSize
		/* Show item GRAPHICS Radio Button */
		CALL VpItem window,'GRAPHICS','SHOW'
		/* Enable item GRAPHICS Radio Button */
		CALL VpItem window,'GRAPHICS','ENABLE'
		/* Set item value GRAPHICS Radio Button */
		CALL VpSetItemValue window,'GRAPHICS',Setup.Application.Graphics.NName.1
		CALL MULT_APP_POSITIONS
		/* Uncheck the item GRAPHICS Radio Button */
		CALL VpSelect window,'GRAPHICS',0
	END	/*Ends "IF Setup.Application.Graphics.NName.0 > 0 & Application_SelectFlag = 11 THEN DO" Section*/

	IF Setup.Application.Drafting.NName.0 > 0 & Application_SelectFlag = 12 THEN DO
		yPPositionNew = yPPosition + Total_Apps*30
		/* Set item position/size DRAFTING Radio Button */
		CALL VpItem window,'DRAFTING','SETITEMPOS',xPPosition,yPPositionNew,xSSize,ySSize
		/* Show item DRAFTING Radio Button */
		CALL VpItem window,'DRAFTING','SHOW'
		/* Enable item DRAFTING Radio Button */
		CALL VpItem window,'DRAFTING','ENABLE'
		/* Set item value DRAFTING Radio Button */
		CALL VpSetItemValue window,'DRAFTING',Setup.Application.Drafting.NName.1
		CALL MULT_APP_POSITIONS
		/* Uncheck the item DRAFTING Radio Button */
		CALL VpSelect window,'DRAFTING',0
	END	/*Ends "IF Setup.Application.Drafting.NName.0 > 0 & Application_SelectFlag = 12 THEN DO" Section*/

	IF Setup.Application.User_Defined.NName.0 > 0 & Application_SelectFlag = 13 THEN DO
		yPPositionNew = yPPosition + Total_Apps*30
		/* Set item position/size USER_DEFINED Radio Button */
		CALL VpItem window,'USER_DEFINED','SETITEMPOS',xPPosition,yPPositionNew,xSSize,ySSize
		/* Show item USER_DEFINED Radio Button */
		CALL VpItem window,'USER_DEFINED','SHOW'
		/* Enable item USER_DEFINED Radio Button */
		CALL VpItem window,'USER_DEFINED','ENABLE'
		/* Set item value USER_DEFINED Radio Button */
		CALL VpSetItemValue window,'USER_DEFINED',"User Defined Applications:"
		CALL MULT_APP_POSITIONS
		/* Uncheck the item USER_DEFINED Radio Button */
		CALL VpSelect window,'USER_DEFINED',0
	END	/*Ends "IF Setup.Application.User_Defined.NName.0 > 0 & Application_SelectFlag = 13 THEN DO" Section*/

	CALL VpSelect window,File_Category,0
	/* Hide item AUTO Radio Button */
	CALL VpItem window,'AUTO','HIDE'
	/* Show item AUTO Radio Button */
	CALL VpItem window,'AUTO','SHOW'
	/* Hide item MANUAL Radio Button */
	CALL VpItem window,'MANUAL','HIDE'
	/* Show item MANUAL Radio Button */
	CALL VpItem window,'MANUAL','SHOW'
	CALL VpSelect window,'MANUAL',1

	Mult_AppsFlag = 1
	/*End setting the positions and sizes of the LAUNCH form and all its controls to their original positions and sizes*/
END	/*Ends "IF ManualFlag = 1" Section*/
RETURN









MULT_APP_POSITIONS:
xxPPosition = xPPosition + 30
DO I = 1 TO Total_Apps BY 1
	Radio_Button = "APP"I
	yyPPositionNew = yPPositionNew - I*30
	/* Set item position/size Radio_Button Radio Button */
	CALL VpItem window,Radio_Button,'SETITEMPOS',xxPPosition,yyPPositionNew,xSSize,ySSize
	/* Show item Radio_Button Radio Button */
	CALL VpItem window,Radio_Button,'SHOW'
	/* Enable item Radio_Button Radio Button */
	CALL VpItem window,Radio_Button,'ENABLE'
	/* Set item value Radio_Button Radio Button */
	CALL VpSetItemValue window,Radio_Button,Setup.Application.File_Category.NName.I
END I
RETURN

/* ##SUB_PRESORTT */
PRESORTT: /*Procedure to presort the found SYSFILETREE data for file size, data date, data time and/or data attributes*/



/*Begin presorting*/
DateLength = 0
TimeLength = 0
SizeLength = 0



/*Begin creating the temporary array, PreSortFiles, to use as working data*/
PreSortFiles. = ""
DO N = 1 TO DesiredFiles.0 BY 1
	PreSortFiles.N = DesiredFiles.N
END N	/*Ends "DO N = 1 TO DesiredFiles.0 BY 1" Section*/
PreSortFiles.0 = DesiredFiles.0
DesiredFiles. = ""
/*End creating the temporary array, PreSortFiles, to use as working data*/



/*Begin separating out the date, time, file size and attribute data from the PreSortFiles array*/
DO N = 1 TO PreSortFiles.0 BY 1
	/*Begin getting the date portion of the data and converting it into the "Sorting", or "Standard", format for use in the REXX UTILITY DATE() function*/
	Data = STRIP(PreSortFiles.N,"B")
	PARSE VAR Data Date.N Remainder
	IF SUBSTR(Date.N,2,1) = "/" THEN Date.N = "0"Date.N
	PARSE VAR Date.N Month "/" Day "/" Year
	SELECT
		WHEN Year > 50 THEN Year = "19"Year

		OTHERWISE Year = "20"Year
	END	/*Ends "SELECT" Section*/
	Date.N = Year||Month||Day
	Date.N = DATE("B", Date.N, "S")
	IF LENGTH(Date.N) > DateLength THEN DateLength = LENGTH(Date.N)
	/*End getting the date portion of the data and converting it into the "Sorting", or "Standard", format for use in the REXX UTILITY DATE() function*/

	/*Begin getting the time portion of the data and converting it into minutes*/
	Data = STRIP(Remainder,"B")
	PARSE VAR Data Time.N Remainder
	PARSE VAR Time.N Hours ":" Minutes
	AMPM = RIGHT(Minutes,1)
	Minutes = LEFT(Minutes,2)
	Digit = LEFT(Minutes,1)
	IF Digit = 0 THEN Minutes = RIGHT(Minutes,1)
	SELECT
		WHEN Hours = 12 & AMPM = "a" THEN Hours = 0

		WHEN Hours = 12 & AMPM = "p" THEN Hours = 12

		WHEN Hours \= 12 & AMPM = "p" THEN Hours = Hours + 12

		OTHERWISE
	END	/*Ends "SELECT" Section*/
	Time.N = Hours + Minutes/60
	IF LENGTH(Time.N) > TimeLength THEN TimeLength = LENGTH(Time.N)
	/*End getting the time portion of the data and converting it into minutes*/

	/*Begin getting the file size portion of the data*/
	Data = STRIP(Remainder,"B")
	PARSE VAR Data Size.N Remainder
	IF LENGTH(Size.N) > SizeLength THEN SizeLength = LENGTH(Size.N)
	/*End getting the file size portion of the data*/

	/*Begin getting the attribute portion of the data*/
	Data = STRIP(Remainder,"B")
	PARSE VAR Data Attributes.N Remainder
	/*End getting the attribute portion of the data*/
END N	/*Ends "DO N = 1 TO PreSortFiles.0 BY 1" Section*/
/*End separating out the date, time, file size and attribute data from the PreSortFiles array*/



/*Begin trimming the found data to match the file size presort criteria*/
IF SizeCheckBoxFlag = 1 THEN DO
	PPreSortFiles. = ""
	PPDate. = ""
	PPTime. = ""
	PPAttributes. = ""
	Q = 0
	DO N = 1 TO PreSortFiles.0 BY 1
		IF Size.N >= MinFileSize & Size.N <= MaxFileSize THEN DO
			Q = Q + 1
			PPreSortFiles.Q = PreSortFiles.N
			PPDate.Q = Date.N
			PPTime.Q = Time.N
			PPAttributes.Q = Attributes.N
		END	/*Ends "IF Size.N >= MinFileSize & Size.N <= MaxFileSize THEN DO" Section*/
	END	/*Ends "DO N = 1 TO PreSortFiles.0 BY 1" Section*/

	PPreSortFiles.0 = Q
	PreSortFiles. = ""
	Date. = ""
	Time. = ""
	Attributes. = ""
	IF Q > 0 THEN DO
		DO N = 1 TO PPreSortFiles.0 BY 1
			PreSortFiles.N = PPreSortFiles.N
			Date.N = PPDate.N
			Time.N = PPTime.N
			Attributes.N = PPAttributes.N
		END	/*Ends "DO N = 1 TO PPreSortFiles.0 BY 1" Section*/
		PreSortFiles.0 = PPreSortFiles.0
	END	/*Ends "IF Q > 0 THEN DO" Section*/
	ELSE PreSortFiles.0 = 0
END	/*Ends "IF SizeCheckBoxFlag = 1 THEN DO" Section*/
/*End trimming the found data to match the file size presort criteria*/



/*Begin trimming the found data to match the date presort criteria*/
IF DateCheckBoxFlag = 1 & PreSortFiles.0 > 0 THEN DO
	PPreSortFiles. = ""
	PPTime. = ""
	PPAttributes. = ""
	Q = 0
	DO N = 1 TO PreSortFiles.0 BY 1
		IF Date.N >= MinDateSerialNumber & Date.N <= MaxDateSerialNumber THEN DO
			Q = Q + 1
			PPreSortFiles.Q = PreSortFiles.N
			PPTime.Q = Time.N
			PPAttributes.Q = Attributes.N
		END	/*Ends "IF Date.N >= MinDateSerialNumber & Date.N <= MaxDateSerialNumber THEN DO" Section*/
	END	/*Ends "DO N = 1 TO PreSortFiles.0 BY 1" Section*/

	PPreSortFiles.0 = Q
	PreSortFiles. = ""
	Time. = ""
	Attributes. = ""
	IF Q > 0 THEN DO
		DO N = 1 TO PPreSortFiles.0 BY 1
			PreSortFiles.N = PPreSortFiles.N
			Time.N = PPTime.N
			Attributes.N = PPAttributes.N
		END	/*Ends "DO N = 1 TO PPreSortFiles.0 BY 1" Section*/
		PreSortFiles.0 = PPreSortFiles.0
	END	/*Ends "IF Q > 0 THEN DO" Section*/
	ELSE PreSortFiles.0 = 0
END	/*Ends "IF DateCheckBoxFlag = 1 & PreSortFiles.0 > 0 THEN DO" Section*/
/*End trimming the found data to match the date presort criteria*/



/*Begin trimming the found data to match the time presort criteria*/
IF TimeCheckBoxFlag = 1 & PreSortFiles.0 > 0 THEN DO
	PPreSortFiles. = ""
	PPAttributes. = ""
	Q = 0
	DO N = 1 TO PreSortFiles.0 BY 1
		IF Time.N >= MinTimeSerialNumber & Time.N <= MaxTimeSerialNumber THEN DO
			Q = Q + 1
			PPreSortFiles.Q = PreSortFiles.N
			PPAttributes.Q = Attributes.N
		END	/*Ends "IF Time.N >= MinTimeSerialNumber & Time.N <= MaxTimeSerialNumber THEN DO" Section*/
	END	/*Ends "DO N = 1 TO PreSortFiles.0 BY 1" Section*/

	PPreSortFiles.0 = Q
	PreSortFiles. = ""
	Attributes. = ""
	IF Q > 0 THEN DO
		DO N = 1 TO PPreSortFiles.0 BY 1
			PreSortFiles.N = PPreSortFiles.N
			Attributes.N = PPAttributes.N
		END	/*Ends "DO N = 1 TO PPreSortFiles.0 BY 1" Section*/
		PreSortFiles.0 = PPreSortFiles.0
	END	/*Ends "IF Q > 0 THEN DO" Section*/
	ELSE PreSortFiles.0 = 0
END	/*Ends "IF TimeCheckBoxFlag = 1 & PreSortFiles.0 > 0 THEN DO" Section*/
/*End trimming the found data to match the time presort criteria*/



/*Begin trimming the found data to match the attributes presort criteria*/
IF AttributesCheckBoxFlag = 1 & PreSortFiles.0 > 0 THEN DO
	PPreSortFiles. = ""
	Q = 0
	DO N = 1 TO PreSortFiles.0 BY 1
		IF Attributes.N = AttributesMask THEN DO
			Q = Q + 1
			PPreSortFiles.Q = PreSortFiles.N
		END	/*Ends "IF Attributes.N = AttributesMask THEN DO" Section*/
	END	/*Ends "DO N = 1 TO PreSortFiles.0 BY 1" Section*/

	PPreSortFiles.0 = Q
	PreSortFiles. = ""
	IF Q > 0 THEN DO
		DO N = 1 TO PPreSortFiles.0 BY 1
			PreSortFiles.N = PPreSortFiles.N
		END	/*Ends "DO N = 1 TO PPreSortFiles.0 BY 1" Section*/
		PreSortFiles.0 = PPreSortFiles.0
	END	/*Ends "IF Q > 0 THEN DO" Section*/
	ELSE PreSortFiles.0 = 0
END	/*Ends "IF AttributesCheckBoxFlag = 1 & PreSortFiles.0 > 0 THEN DO" Section*/
/*End trimming the found data to match the attributes presort criteria*/



/*Begin recreating the array, DesiredFiles, to use in the remainder of this REXX program*/
IF PreSortFiles.0 > 0 THEN DO
	DO N = 1 TO PreSortFiles.0 BY 1
		DesiredFiles.N = PreSortFiles.N
	END N	/*Ends "DO N = 1 TO PreSortFiles.0 BY 1" Section*/
END	/*Ends "IF PreSortFiles.0 > 0 THEN DO" Section*/
DesiredFiles.0 = PreSortFiles.0
/*End recreating the array, DesiredFiles, to use in the remainder of this REXX program*/
RETURN
/*End presorting*/
return

/* ##SUB_REATTBMK */
REATTBMK: /*Procedure to reset the AttributeMask*/


/*Begin procedure*/
/*Begin getting all the values of the five (5) attribute set flags*/
/* Get button state SETARCHIVE Radio Button */
SetArchiveFlag = VpIsSelected(window,'SETARCHIVE')
/* Get button state SETDIRECTORY Radio Button */
SetDirectoryFlag = VpIsSelected(window,'SETDIRECTORY')
/* Get button state SETHIDDEN Radio Button */
SetHiddenFlag = VpIsSelected(window,'SETHIDDEN')
/* Get button state SETREADONLY Radio Button */
SetReadOnly = VpIsSelected(window,'SETREADONLY')
/* Get button state SETSYSTEM Radio Button */
SetSystemFlag = VpIsSelected(window,'SETSYSTEM')
/*End getting all the values of the five (5) attribute set flags*/



/*Begin setting the AttributeMask*/
AttributesMask = ""
IF SetArchiveFlag = 1 THEN AttributesMask = AttributesMask"A"
ELSE AttributesMask = AttributesMask"-"
IF SetDirectoryFlag = 1 THEN AttributesMask = AttributesMask"D"
ELSE AttributesMask = AttributesMask"-"
IF SetHiddenFlag = 1 THEN AttributesMask = AttributesMask"H"
ELSE AttributesMask = AttributesMask"-"
IF SetReadOnly = 1 THEN AttributesMask = AttributesMask"R"
ELSE AttributesMask = AttributesMask"-"
IF SetSystemFlag = 1 THEN AttributesMask = AttributesMask"S"
ELSE AttributesMask = AttributesMask"-"
/* Set item value ATTRIBUTES Entry Field */
CALL VpSetItemValue window,'ATTRIBUTES',AttributesMask
/*End setting the AttributeMask*/
RETURN
/*End procedure*/

return

/* ##SUB_REMAXDTE */
REMAXDTE: /*Procedure to reset the MAXMONTH, MAXDAY and MAXYEAR Spin Button values, as necessary*/



/*Begin resetting the MAXMONTH, MAXDAY and/ MAXYEAR values, if necessary*/
/* Get item value MINMONTH Spin Button */
MinMonth = RIGHT(VpGetItemValue(window,'MINMONTH'), 2)
/* Get item value MINDAY Spin Button */
MinDay = RIGHT(VpGetItemValue(window,'MINDAY'), 2)
/* Get item value MINYEAR Spin Button */
MinYear = VpGetItemValue(window,'MINYEAR')
MinDate = MinYear||MinMonth||MinDay
MinDateSerialNumber = DATE("B", MinDate, "S")

/* Get item value MAXMONTH Spin Button */
MaxMonth = RIGHT(VpGetItemValue(window,'MAXMONTH'), 2)
/* Get item value MAXDAY Spin Button */
MaxDay = RIGHT(VpGetItemValue(window,'MAXDAY'), 2)
/* Get item value MAXYEAR Spin Button */
MaxYear = VpGetItemValue(window,'MAXYEAR')
MaxDate = MaxYear||MaxMonth||MaxDay
MaxDateSerialNumber = DATE("B", MaxDate, "S")
IF MaxDateSerialNumber < MinDateSerialNumber THEN DO
	/* Set item value MAXMONTH Spin Button */
	CALL VpSetItemValue window,'MAXMONTH',MinMonth
	/* Set item value MAXDAY Spin Button */
	CALL VpSetItemValue window,'MAXDAY',MinDay
	/* Set item value MAXYEAR Spin Button */
	CALL VpSetItemValue window,'MAXYEAR',MinYear
	MaxDateSerialNumber = MinDateSerialNumber
END	/*Ends "IF MaxDateSerialNumber < MinDateSerialNumber THEN DO" Section*/
RETURN
/*End resetting the MAXMONTH, MAXDAY and/ MAXYEAR values, if necessary*/

return

/* ##SUB_REMAXTME */
REMAXTME: /*Procedure to reset the MAXHOURS, MAXMINUTES, MAXSECONDS, MAXAMPM Spin Button and MAXAMPMENTRY Entry field values, as necessary*/



/* Get button state TIMECHECKBOX Check Box */
TimeCheckBoxFlag = VpIsSelected(window,'TIMECHECKBOX')
MinHours = RIGHT(VpGetItemValue(window,'MINHOURS'), 2)
/* Get item value MINMINUTES Spin Button */
MinMinutes = RIGHT(VpGetItemValue(window,'MINMINUTES'), 2)
/* Get item value MINSECONDS Spin Button */
MinSeconds = VpGetItemValue(window,'MINSECONDS')


/* Get item value MAXHOURS Spin Button */
MaxHours = RIGHT(VpGetItemValue(window,'MAXHOURS'), 2)
/* Get item value MAXMINUTES Spin Button */
MaxMinutes = RIGHT(VpGetItemValue(window,'MAXMINUTES'), 2)
/* Get item value MAXSECONDS Spin Button */
MaxSeconds = VpGetItemValue(window,'MAXSECONDS')


IF Setup.Presort_Time_Format = "HH MM SS AMPM" THEN DO
	MinAMPM = VpGetItemValue(window,'MINAMPM')
	MinAMPMEntry = VpGetItemValue(window,'MINAMPMENTRY')
	MaxAMPM = VpGetItemValue(window,'MAXAMPM')
	MaxAMPMEntry = VpGetItemValue(window,'MAXAMPMENTRY')
	SELECT
		WHEN MinAMPM = 1 & MinHours = 12 THEN MMinHours = 0
		WHEN MinAMPM = 1 & MinHours \= 12 THEN MMinHours = MinHours
		WHEN MinAMPM = 2 & MinHours = 12 THEN MMinHours = MinHours
		WHEN MinAMPM = 2 & MinHours \= 12 THEN MMinHours = MinHours + 12
		OTHERWISE NOP
	END	/*Ends "SELECT" Section*/
	SELECT
		WHEN MaxAMPM = 1 & MaxHours = 12 THEN MMaxHours = 0
		WHEN MaxAMPM = 1 & MaxHours \= 12 THEN MMaxHours = MaxHours
		WHEN MaxAMPM = 2 & MaxHours = 12 THEN MMaxHours = MaxHours
		WHEN MaxAMPM = 2 & MaxHours \= 12 THEN MMaxHours = MaxHours + 12
		OTHERWISE NOP
	END	/*Ends "SELECT" Section*/
END	/*Ends "IF Setup.Presort_Time_Format = "HH MM SS AMPM" THEN DO" Section*/
MinTimeSerialNumber = 3600*MMinHours + 60*MinMinutes + MinSeconds
MaxTimeSerialNumber = 3600*MMaxHours + 60*MaxMinutes + MaxSeconds



/*Begin resetting the MaxHours, MaxMinutes, MaxSeconds, MaxAMPM, if required*/
IF MaxTimeSerialNumber < MinTimeSerialNumber THEN DO
	/* Set item value MAXHOURS Spin Button */
	CALL VpSetItemValue window,'MAXHOURS',MinHours
	/* Set item value MAXMINUTES Spin Button */
	CALL VpSetItemValue window,'MAXMINUTES',MinMinutes
	/* Set item value MAXSECONDS Spin Button */
	CALL VpSetItemValue window,'MAXSECONDS',MinSeconds
	IF Setup.Presort_Time_Format = "HH MM SS AMPM" THEN DO
		/* Set item value MAXAMPM Spin Button */
		CALL VpSetItemValue window,'MAXAMPM',MinAMPM
		/* Set item value MAXAMPMENTRY Entry Field */
		CALL VpSetItemValue window,'MAXAMPMENTRY',MinAMPMEntry
	END	/*Ends "IF Setup.Presort_Time_Format = "HH MM SS AMPM" THEN DO" Section*/
	MaxTimeSerialNumber = MinTimeSerialNumber
END	/*Ends "IF MaxTimeSerialNumber < MinTimeSerialNumber THEN DO" Section*/

RETURN
/*End resetting the MaxHours, MaxMinutes, MaxSeconds, MaxAMPM, if required*/

return

/* ##SUB_REMINDTE */
REMINDTE: /*Procedure to reset the MINMONTH, MINDAY and MINYEAR Spin Button values, as necessary*/



/*Begin resetting the MINMONTH, MINDAY and/ MINYEAR values, if necessary*/
/* Get item value MINMONTH Spin Button */
MinMonth = RIGHT(VpGetItemValue(window,'MINMONTH'), 2)
/* Get item value MINDAY Spin Button */
MinDay = RIGHT(VpGetItemValue(window,'MINDAY'), 2)
/* Get item value MINYEAR Spin Button */
MinYear = VpGetItemValue(window,'MINYEAR')
MinDate = MinYear||MinMonth||MinDay
MinDateSerialNumber = DATE("B", MinDate, "S")

/* Get item value MAXMONTH Spin Button */
MaxMonth = RIGHT(VpGetItemValue(window,'MAXMONTH'), 2)
/* Get item value MAXDAY Spin Button */
MaxDay = RIGHT(VpGetItemValue(window,'MAXDAY'), 2)
/* Get item value MAXYEAR Spin Button */
MaxYear = VpGetItemValue(window,'MAXYEAR')
MaxDate = MaxYear||MaxMonth||MaxDay
MaxDateSerialNumber = DATE("B", MaxDate, "S")
IF MaxDateSerialNumber < MinDateSerialNumber THEN DO
	/* Set item value MINMONTH Spin Button */
	CALL VpSetItemValue window,'MINMONTH',MaxMonth
	/* Set item value MINDAY Spin Button */
	CALL VpSetItemValue window,'MINDAY',MaxDay
	/* Set item value MINYEAR Spin Button */
	CALL VpSetItemValue window,'MINYEAR',MaxYear
	MinDateSerialNumber = MaxDateSerialNumber
END	/*Ends "IF MaxDateSerialNumber < MinDateSerialNumber THEN DO" Section*/
RETURN
/*End resetting the MINMONTH, MINDAY and/ MINYEAR values, if necessary*/

return

/* ##SUB_REMINTME */
REMINTME: /*Procedure to reset the MINHOURS, MINMINUTES, MINSECONDS, MINAMPM Spin Button and MINAMPMENTRY Entry field values, as necessary*/



/* Get button state TIMECHECKBOX Check Box */
TimeCheckBoxFlag = VpIsSelected(window,'TIMECHECKBOX')
MinHours = RIGHT(VpGetItemValue(window,'MINHOURS'), 2)
/* Get item value MINMINUTES Spin Button */
MinMinutes = RIGHT(VpGetItemValue(window,'MINMINUTES'), 2)
/* Get item value MINSECONDS Spin Button */
MinSeconds = VpGetItemValue(window,'MINSECONDS')


/* Get item value MAXHOURS Spin Button */
MaxHours = RIGHT(VpGetItemValue(window,'MAXHOURS'), 2)
/* Get item value MAXMINUTES Spin Button */
MaxMinutes = RIGHT(VpGetItemValue(window,'MAXMINUTES'), 2)
/* Get item value MAXSECONDS Spin Button */
MaxSeconds = VpGetItemValue(window,'MAXSECONDS')


IF Setup.Presort_Time_Format = "HH MM SS AMPM" THEN DO
	MinAMPM = VpGetItemValue(window,'MINAMPM')
	MinAMPMEntry = VpGetItemValue(window,'MINAMPMENTRY')
	MaxAMPM = VpGetItemValue(window,'MAXAMPM')
	MaxAMPMEntry = VpGetItemValue(window,'MAXAMPMENTRY')
	SELECT
		WHEN MinAMPM = 1 & MinHours = 12 THEN MMinHours = 0
		WHEN MinAMPM = 1 & MinHours \= 12 THEN MMinHours = MinHours
		WHEN MinAMPM = 2 & MinHours = 12 THEN MMinHours = MinHours
		WHEN MinAMPM = 2 & MinHours \= 12 THEN MMinHours = MinHours + 12
		OTHERWISE NOP
	END	/*Ends "SELECT" Section*/
	SELECT
		WHEN MaxAMPM = 1 & MaxHours = 12 THEN MMaxHours = 0
		WHEN MaxAMPM = 1 & MaxHours \= 12 THEN MMaxHours = MaxHours
		WHEN MaxAMPM = 2 & MaxHours = 12 THEN MMaxHours = MaxHours
		WHEN MaxAMPM = 2 & MaxHours \= 12 THEN MMaxHours = MaxHours + 12
		OTHERWISE NOP
	END	/*Ends "SELECT" Section*/
END	/*Ends "IF Setup.Presort_Time_Format = "HH MM SS AMPM" THEN DO" Section*/
MinTimeSerialNumber = 3600*MMinHours + 60*MinMinutes + MinSeconds
MaxTimeSerialNumber = 3600*MMaxHours + 60*MaxMinutes + MaxSeconds



/*Begin resetting the MinHours, MinMinutes, MinSeconds, MinAMPM, if required*/
IF MaxTimeSerialNumber < MinTimeSerialNumber THEN DO
	/* Set item value MINHOURS Spin Button */
	CALL VpSetItemValue window,'MINHOURS', MaxHours
	/* Set item value MINMINUTES Spin Button */
	CALL VpSetItemValue window,'MINMINUTES',MaxMinutes
	/* Set item value MINSECONDS Spin Button */
	CALL VpSetItemValue window,'MINSECONDS',MaxSeconds
	IF Setup.Presort_Time_Format = "HH MM SS AMPM" THEN DO
		/* Set item value MINAMPM Spin Button */
		CALL VpSetItemValue window,'MINAMPM',MaxAMPM
		/* Set item value MINAMPMENTRY Entry Field */
		CALL VpSetItemValue window,'MINAMPMENTRY',MaxAMPMEntry
	END	/*Ends "IF Setup.Presort_Time_Format = "HH MM SS AMPM" THEN DO" Section*/
	MaxTimeSerialNumber = MinTimeSerialNumber
END	/*Ends "IF MaxTimeSerialNumber < MinTimeSerialNumber THEN DO" Section*/

RETURN
/*End resetting the MinHours, MinMinutes, MinSeconds, MinAMPM, if required*/

return

/* ##SUB_SCANEA */
SCANEA: /*This REXX script finds all of the extended attribute data for a given file*/

/*The script incorporates three (3) separate methods to find the extended attribute data:*/
/*	1. It uses the SYSGETEA() function from the REXX Utilities */
/*	2. It uses the FETCHEA() function from the REXX EA Utilities*/
/*	3. It uses the DOSEALIST() function from the REXX Library Utilities*/
/*You can use SYSGETEA(), only when you know the name of the extended attribute for which you are looking. There are twelve (12)*/
/*standard extended attribute names. However, new extended attributes with user defined names appear all the time. The names are hidden in the*/
/*extended attributes and are not readily accessible, using normal OS/2 and REXX tools. Curiously, SYSGETEA() does not seem to work, when using*/
/*the ".LONGNAME" standard extended attribute name. The FETCHEA() function appears to work with all extended attribute names, standard and user*/
/*defined, except for the ".LONGNAME" attribute. Just like the SYSGETEA() function, FETCHEA() does not work with ".LONGNAME". Therefore, finally*/
/*the script uses the DOSEALIST() function for the ".LONGNAME" attribute. DOSEASLIST() does not find several extended attribute names that*/
/*SYSGETEA() and FETCHEA() do*/



/*Begin defining the extended attribute data types*/
ExtendedAttributeDataType. = ""
ExtendedAttributeDataType.ASCII = "FFFD"x
ExtendedAttributeDataType.ASN1 = "FFDD"x
ExtendedAttributeDataType.BINARY = "FFFE"x
ExtendedAttributeDataType.BITMAP = "FFFB"x
ExtendedAttributeDataType.EA = "FFEE"x
ExtendedAttributeDataType.ICON = "FFF9"x
ExtendedAttributeDataType.METAFILE = "FFFA"x
ExtendedAttributeDataType.MVMT = "FFDF"x
ExtendedAttributeDataType.MVST = "FFDE"x
/*End defining the extended attribute data types*/



/*Begin defining the standard extended attributes*/
ExtendedAttributeNames. = ""
ExtendedAttributeNames.0 = 16
ExtendedAttributeNames.1 = ".APPTYPE"
ExtendedAttributeNames.2 = ".ASSOCTABLE"
ExtendedAttributeNames.3 = ".CLASSINFO"
ExtendedAttributeNames.4 = ".CODEPAGE"
ExtendedAttributeNames.5 = ".COMMENTS"
ExtendedAttributeNames.6 = ".HISTORY"
ExtendedAttributeNames.7 = ".ICON"
ExtendedAttributeNames.8 = ".KEYPHRASES"
ExtendedAttributeNames.9 = ".LONGNAME"
ExtendedAttributeNames.10 = "REXX.METACONTROL"
ExtendedAttributeNames.11 = "REXX.PROGRAMDATA"
ExtendedAttributeNames.12 = ".SUBJECT"
ExtendedAttributeNames.13 = "TMF.FILEINFO"
ExtendedAttributeNames.14 = "TMF.MSGTABLE"
ExtendedAttributeNames.15 = ".TYPE"
ExtendedAttributeNames.16 = ".VERSION"
/*End defining the standard extended attributes*/



/*Begin finding the extended attributions for both the known and unknown extended attribute names*/
M = 0
ToSpace = XRange("7F"x, "1F"x)
ScanLineResults. = ""
ScanFilePathResults. = ""
ScanFileNameResults. = ""
ScanSysFileTreeResults. = ""
DO J = 1 TO OtherServicesFilePath.0 BY 1
	ScanPath = OtherServicesFilePath.J
	ScanPathFlag = "NO"
	Q = 0


	/*Begin finding the extended attributions for known extended attribute names*/
	DO K = 1 TO ExtendedAttributeNames.0 BY 1
		ExtendedAttributeName = ExtendedAttributeNames.K


		/*Begin assigning the extended attribute results to the array variable, ScanLineResults.M.Q*/
		IF GETANDFORMATEXTENDEDATTRIBUTES(ScanPath, ExtendedAttributeName) = 1 THEN DO
			SELECT
				WHEN ScanPathFlag = "NO" THEN DO
					ScanPathFlag = "YES"
					M = M + 1
					ScanFilePathResults.M = ScanPath
					ScanSysFileTreeResults.M = OtherServicesFileDirectory.J
					Remainder = ScanFilePathResults.M
					Data = Remainder
					DO UNTIL Remainder = ""
						PARSE VAR Data First "\" Remainder
						Data = Remainder
					END	/*Ends "DO UNTIL Remainder = """ Section*/
					ScanFileNameResults.M = First
				END	/*Ends "WHEN ScanPathFlag = "NO" THEN DO" Section*/

				OTHERWISE NOP
			END	/*Ends "SELECT" Section*/

			Q = Q + 1
			ScanLineResults.M.Q = ExtendedAttributeNames.K":"
			DO L = 1 TO EABreakout.0 BY 1
				Q = Q + 1
				IF EABreakout.L.Type = "BINARY" | EABreakout.L.Type = "UNKNOWN" THEN DO
					EABreakout.L.Dataa = TRANSLATE(EABreakout.L.Dataa, "^", '0A'x)	/*Remove all lines feeds and make one continuous line*/
					EABreakout.L.Dataa = TRANSLATE(EABreakout.L.Dataa, Copies('00'x, 256), ToSpace)	/*Translate unprintable characters to spaces so that PARSE can separate printable data from binary data*/
					EABreakout.L.Dataa = TRANSLATE(TRANSLATE(EABreakout.L.Dataa, 'FF'x, " "), " ", '00'x)	/*Translate spaces to "FF"x so that PARSE will not break up Titles with spaces, then translate all '00'x characters to spaces*/
					Stuff = EABreakout.L.Dataa
					EABreakout.L.Dataa = ""
					DO WHILE Stuff \= ""
						PARSE VAR Stuff Dataaa Stuff
						Dataaa = STRIP(Dataaa, "B")
						SELECT
							WHEN EABreakout.L.Dataa = "" THEN EABreakout.L.Dataa = Dataaa
							WHEN EABreakout.L.Dataa \= "" THEN EABreakout.L.Dataa = EABreakout.L.Dataa"		"Dataaa
							OTHERWISE NOP
						END	/*Ends "SELECT" Section*/
					END	/*Ends "DO WHILE Stuff \= """ Section*/
					ScanLineResults.M.Q = "    "EABreakout.L.Type": "EABreakout.L.Dataa
				END	/*Ends "IF EABreakout.L.Type = "BINARY" | EABreakout.L.Type = "UNKNOWN" THEN DO" Section*/

				ELSE
				ScanLineResults.M.Q = "    "EABreakout.L.Type":" EABreakout.L.Dataa
			END L	/*Ends "DO L = 1 TO EA.0 BY 1" Section*/	
		END	/*Ends "IF GETANDFORMATEXTENDEDATTRIBUTES(ScanPath, ExtendedAttributeName) = 1 THEN DO" Section*/
		/*End assigning the extended attribute results to the array variable, ScanLineResults.M.Q*/
	END K	/*Ends "DO L = 1 TO ExtendedAttributeNames.0 BY 1" Section*/
	/*End finding the extended attributions for known extended attribute names*/


	/*Begin using the REXX Library and REXX EA Utilities to find any possible non standard, or unknown, extend attribute names, and also to .LONGNAME*/
	FetchNames. = ""
	FetchNames.0 = 0
	FetchStrings. = ""
	DOSEAListNames. = ""
	DOSEAListNames.0 = 0
	DOSEAListValue. = ""
	DOSEAListFlag. = ""
	IF Setup.Use_REXXEA = "YES" THEN RC = FETCHEA(ScanPath,"FetchNames","FetchStrings")
	IF Setup.Use_REXXLIB = "YES" THEN RC = DOSEALIST(ScanPath,DOSEAListNames,DOSEAListValue,DOSEAListFlag)


	IF FetchNames.0 > 0 | DOSEAListNames.0 > 0 THEN DO
		DO K = 1 TO MAX(FetchNames.0, DOSEAListNames.0) BY 1
			SELECT
				WHEN K <= FetchNames.0 & (FetchNames.K = ".APPTYPE" | FetchNames.K = ".ASSOCTABLE" | FetchNames.K = ".CLASSINFO" | FetchNames.K = ".CODEPAGE") THEN NOP

				WHEN K <= FetchNames.0 & (FetchNames.K = ".COMMENTS" | FetchNames.K = ".HISTORY" | FetchNames.K = ".ICON" | FetchNames.K = ".KEYPHRASES") THEN NOP

				WHEN K <= FetchNames.0 & (FetchNames.K = ".LONGNAME" | FetchNames.K = "REXX.METACONTROL" | FetchNames.K = "REXX.PROGRAMDATA" | FetchNames.K = ".SUBJECT") THEN NOP

				WHEN K <= FetchNames.0 & (FetchNames.K = "TMF.FILEINFO" | FetchNames.K = "TMF.MSGTABLE" | FetchNames.K = ".TYPE" | FetchNames.K = ".VERSION") THEN NOP

				/*Begin assigning the extended attribute results to the array variable, ScanLineResults.M.Q*/
				WHEN DOSEAListNames.K = ".LONGNAME" THEN DO
					SELECT
						WHEN ScanPathFlag = "NO" THEN DO
							ScanPathFlag = "YES"
							M = M + 1
							ScanFilePathResults.M = ScanPath
							ScanSysFileTreeResults.M = OtherServicesFileDirectory.J
							Remainder = ScanFilePathResults.M
							Data = Remainder
							DO UNTIL Remainder = ""
								PARSE VAR Data First "\" Remainder
								Data = Remainder
							END	/*Ends "DO UNTIL Remainder = """ Section*/
							ScanFileNameResults.M = First
						END

						OTHERWISE NOP
					END	/*Ends "SELECT" Section*/

					SysGetEAResults = DOSEAListValue.K
					CALL FORMATEA SysGetEAResults, 1
					Q = Q + 1
					ScanLineResults.M.Q = ".LONGNAME:"
					DO L = 1 TO EABreakout.0 BY 1
						Q = Q + 1
						IF EABreakout.L.Type = "BINARY" | EABreakout.L.Type = "UNKNOWN" THEN DO
							EABreakout.L.Dataa = TRANSLATE(EABreakout.L.Dataa, "^", '0A'x)	/*Remove all lines feeds and make one continuous line*/
							EABreakout.L.Dataa = TRANSLATE(EABreakout.L.Dataa, Copies('00'x, 256), ToSpace)	/*Translate unprintable characters to spaces so that PARSE can separate printable data from binary data*/
							EABreakout.L.Dataa = TRANSLATE(TRANSLATE(EABreakout.L.Dataa, 'FF'x, " "), " ", '00'x)	/*Translate spaces to "FF"x so that PARSE will not break up Titles with spaces, then translate all '00'x characters to spaces*/
							Stuff = EABreakout.L.Dataa
							EABreakout.L.Dataa = ""
							DO WHILE Stuff \= ""
								PARSE VAR Stuff Dataaa Stuff
								Dataaa = STRIP(Dataaa, "B")
								SELECT
									WHEN EABreakout.L.Dataa = "" THEN EABreakout.L.Dataa = Dataaa
									WHEN EABreakout.L.Dataa \= "" THEN EABreakout.L.Dataa = EABreakout.L.Dataa"		"Dataaa
									OTHERWISE NOP
								END	/*Ends "SELECT" Section*/
							END	/*Ends "DO WHILE Stuff \= """ Section*/
							ScanLineResults.M.Q = "    "EABreakout.L.Type": "EABreakout.L.Dataa
						END	/*Ends "IF EABreakout.L.Type = "BINARY" | EABreakout.L.Type = "UNKNOWN" THEN DO" Section*/

						ELSE
						ScanLineResults.M.Q = "    "EABreakout.L.Type":" EABreakout.L.Dataa
					END L	/*Ends "DO L = 1 TO EA.0 BY 1" Section*/
				END	/*Ends "WHEN DOSEAListNames.K = ".LONGNAMES" THEN DO" Section*/

				OTHERWISE DO
					SELECT
						WHEN ScanPathFlag = "NO" THEN DO
							ScanPathFlag = "YES"
							M = M + 1
							ScanFilePathResults.M = ScanPath
							ScanSysFileTreeResults.M = OtherServicesFileDirectory.J
							Remainder = ScanFilePathResults.M
							Data = Remainder
							DO UNTIL Remainder = ""
								PARSE VAR Data First "\" Remainder
								Data = Remainder
							END	/*Ends "DO UNTIL Remainder = """ Section*/
							ScanFileNameResults.M = First
						END

						OTHERWISE NOP
					END	/*Ends "SELECT" Section*/

					ExtendedAttributeName = FetchNames.K
					CALL FINDNONSTANDARDRESULTS
				END	/*Ends "OTHERWISE DO" Section*/
			END	/*Ends "SELECT" Section*/
			/*End assigning the extended attribute results to the array variable, ScanLineResults.M.Q*/
		END K	/*Ends "DO K = 1 TO MAX(FetchNames.0, DOSEAListNames.0) BY 1" Section*/
	END	/*Ends "IF FetchNames.0 > 0 | DOSEAListNames.0 > 0 THEN DO" Section*/

	IF ScanPathFlag = "YES" THEN ScanLineResults.M.0 = Q
	/*End using the REXX Library and REXX EA Utilities to find any possible non standard, or unknown, extend attribute names, and also to .LONGNAME*/

END J	/*Ends "DO J = 1 TO OtherServicesFilePath.0 BY 1" Section*/
/*End finding the extended attributions for both the known and unknown extended attribute names*/



/*Begin ending this subprocedure and returning to the SCANTEXT form*/
ScanFilePathResults.0 = M
RETURN
/*End ending this subprocedure and returning to the SCANTEXT form*/









/*Begin assigning the extended attribute results for any possible non standard, or unknown, extended attribute names to the array variable, ScanLineResults.M.Q*/
FINDNONSTANDARDRESULTS:
IF GETANDFORMATEXTENDEDATTRIBUTES(ScanPath, ExtendedAttributeName) = 1 THEN DO
	Q = Q + 1
	ScanLineResults.M.Q = ExtendedAttributeName":"
	DO L = 1 TO EABreakout.0 BY 1
		Q = Q + 1
		IF EABreakout.L.Type = "BINARY" | EABreakout.L.Type = "UNKNOWN" THEN DO
			EABreakout.L.Dataa = TRANSLATE(EABreakout.L.Dataa, "^", '0A'x)	/*Remove all lines feeds and make one continuous line*/
			EABreakout.L.Dataa = TRANSLATE(EABreakout.L.Dataa, Copies('00'x, 256), ToSpace)	/*Translate unprintable characters to spaces so that PARSE can separate printable data from binary data*/
			EABreakout.L.Dataa = TRANSLATE(TRANSLATE(EABreakout.L.Dataa, 'FF'x, " "), " ", '00'x)	/*Translate spaces to "FF"x so that PARSE will not break up Titles with spaces, then translate all '00'x characters to spaces*/
			Stuff = EABreakout.L.Dataa
			EABreakout.L.Dataa = ""
			DO WHILE Stuff \= ""
				PARSE VAR Stuff Dataaa Stuff
				Dataaa = STRIP(Dataaa, "B")
				SELECT
					WHEN EABreakout.L.Dataa = "" THEN EABreakout.L.Dataa = Dataaa
					WHEN EABreakout.L.Dataa \= "" THEN EABreakout.L.Dataa = EABreakout.L.Dataa"		"Dataaa
					OTHERWISE NOP
				END	/*Ends "SELECT" Section*/
			END	/*Ends "DO WHILE Stuff \= """ Section*/
			ScanLineResults.M.Q = "    "EABreakout.L.Type": "EABreakout.L.Dataa
		END	/*Ends "IF EABreakout.L.Type = "BINARY" | EABreakout.L.Type = "UNKNOWN" THEN DO" Section*/

		ELSE
		ScanLineResults.M.Q = "    "EABreakout.L.Type":" EABreakout.K.Dataa
	END L	/*Ends "DO L = 1 TO EA.0 BY 1" Section*/	
END	/*Ends "IF GETANDFORMATEXTENDEDATTRIBUTES(ScanPath, ExtendedAttributeName) = 1 THEN DO" Section*/
RETURN
/*End assigning the extended attribute results for any possible non standard, or unknown, extended attribute names to the array variable, ScanLineResults.M.Q*/









/*Begin getting the extended attribute data and parsing it*/
GETANDFORMATEXTENDEDATTRIBUTES:
SysGetEAResults = ""
RC = SYSGETEA(ScanPath, ExtendedAttributeName, "SysGetEAResults")
IF RC = 0 & SysGetEAResults \= "" THEN DO
	EABreakout. = ""
	CALL FORMATEA SysGetEAResults, 1
	RETURN 1
END	/*Ends "IF RC = 0 & SysGetEAResults \= "" THEN DO" Section*/

ELSE RETURN 0
/*End getting the extended attribute data and parsing it*/









/*Begin recursive procedure to parse the extended attribute data*/
FORMATEA:
SysGetEAResults = ARG(1)
Count = ARG(2)
ExtendedAttributeDataType = ""
PARSE VAR SysGetEAResults ExtendedAttributeDataType 3 .
ExtendedAttributeDataType = REVERSE(ExtendedAttributeDataType)

SELECT
	WHEN ExtendedAttributeDataType = ExtendedAttributeDataType.ASCII THEN DO
		CALL SINGLEPASSPARSE
		EABreakout.Count.Type = "ASCII"
	END	/*Ends "WHEN ExtendedAttributeDataType = ExtendedAttributeDataType.ASCII THEN DO" Section*/


	WHEN ExtendedAttributeDataType = ExtendedAttributeDataType.ASN1 THEN DO
		CALL SINGLEPASSPARSE
		EABreakout.Count.Type = "ASN1"
	END	/*Ends "WHEN ExtendedAttributeDataType = ExtendedAttributeDataType.ASN1 THEN DO" Section*/


	WHEN ExtendedAttributeDataType = ExtendedAttributeDataType.BINARY THEN DO
		CALL SINGLEPASSPARSE
		EABreakout.Count.Type = "BINARY"
	END	/*Ends "WHEN ExtendedAttributeDataType = ExtendedAttributeDataType.BINARY THEN DO" Section*/


	WHEN ExtendedAttributeDataType = ExtendedAttributeDataType.BITMAP THEN DO
		CALL SINGLEPASSPARSE
		EABreakout.Count.Type = "BITMAP"
	END	/*Ends "WHEN ExtendedAttributeDataType = ExtendedAttributeDataType.BITMAP THEN DO" Section*/


	WHEN ExtendedAttributeDataType = ExtendedAttributeDataType.EA THEN DO
		CALL SINGLEPASSPARSE
		EABreakout.Count.Type = "EA"
	END	/*Ends "WHEN ExtendedAttributeDataType = ExtendedAttributeDataType.EA THEN DO" Section*/


	WHEN ExtendedAttributeDataType = ExtendedAttributeDataType.ICON THEN DO
		CALL SINGLEPASSPARSE
		EABreakout.Count.Type = "ICON"
	END	/*Ends "WHEN ExtendedAttributeDataType = ExtendedAttributeDataType.ICON THEN DO" Section*/


	WHEN ExtendedAttributeDataType = ExtendedAttributeDataType.METAFILE THEN DO
		CALL SINGLEPASSPARSE
		EABreakout.Count.Type = "METAFILE"
	END	/*Ends "WHEN ExtendedAttributeDataType = ExtendedAttributeDataType.METAFILE THEN DO" Section*/


	WHEN ExtendedAttributeDataType = ExtendedAttributeDataType.MVMT THEN CALL MULTIPLEPASSPARSE

	WHEN ExtendedAttributeDataType = ExtendedAttributeDataType.MVST THEN CALL MULTIPLEPASSPARSE

	OTHERWISE DO
		EABreakout.0 = Count
		EABreakout.Count.Type = "UNKNOWN"
		EABreakout.Count.Dataa = SysGetEAResults
	END	/*Ends "OTHERWISE DO" Section*/
END	/*Ends "SELECT" Section*/
RETURN SysGetEAResults
/*End recursive procedure to parse the extended attribute data*/









/*Begin the single pass parse routine*/
SINGLEPASSPARSE:
EABreakout.0 = Count
PARSE VAR SysGetEAResults 3 DataLength 5
DataLength = C2D(REVERSE(DataLength))
PARSE VAR SysGetEAResults 5 EABreakout.Count.Dataa +(DataLength) SysGetEAResults
RETURN
/*End the single pass parse routine*/









/*Begin the multiple pass parse routine*/
MULTIPLEPASSPARSE:
PARSE VAR SysGetEAResults 5 DataLength 7 SysGetEAResults
DataLength = C2D(REVERSE(DataLength))
DO P = 0 TO (DataLength - 1)
	SysGetEAResults = FORMATEA(SysGetEAResults, (Count + 1))
	IF ExtendedAttributeDataType = ExtendedAttributeDataType.MVST THEN SysGetEAResults = REVERSE(ExtendedAttributeDataType.ASCII) || SysGetEAResults
END P	/*Ends "DO P = 0 TO (DataLength - 1)" Section*/
RETURN
/*End the multiple pass parse routine*/

return

/* ##SUB_SCANTEXT */
SCANTEXT: /*Subprocedure to scan selected files for a desired text string*/



/*Begin scanning each selected file for the desired text*/
M = 0
ScanLineResults. = ""
ScanFilePathResults. = ""
ScanFileNameResults. = ""
ScanSysFileTreeResults. = ""
FileType. = ""
DO J = 1 TO OtherServicesFilePath.0 BY 1
	/*Begin scanning each file for the desired text*/

	/*Begin scanning under the assumption that the file type is ASCII*/
	BinaryFlag = 0
	ScanPath = OtherServicesFilePath.J
	Start = LENGTH(ScanPath) - 3
	IF Start > 0 THEN DOSExtensionTest = SUBSTR(ScanPath,Start,1)
	IF DOSExtensionTest = "." THEN FileExtension = TRANSLATE(RIGHT(ScanPath,3))
	IF FileExtension = "HLP" | FileExtension = "INF" | FileExtension = "HTM" | FileExtension = "HTML" THEN DO
		CALL BINARY
		ITERATE	/*After returning from the BINARY routine, go to the next iteration of this do loop*/
	END	/*Ends "IF FileExtension = "HLP" | FileExtension = "INF" | FileExtension = "HTM" | FileExtension = "HTML" THEN DO" Section*/

	LineResults. = ""
	CALL ON ERROR NAME BINARY	/*Go to the BINARY routine, if an error occurs, using SYSFILESEARCH*/
	CALL ON NOTREADY NAME BINARY	/*Go to the BINARY routine, if a syntax problem occurs, using SYSFILESEARCH*/
	RC = SYSFILESEARCH(SearchString,ScanPath,LineResults,N)
	IF BinaryFlag = 1 THEN DO
		CALL OFF ERROR
		CALL OFF NOTREADY
		ITERATE	/*After returning from the BINARY routine, go to the next iteration of this do loop*/
	END	/*Ends "IF BinaryFlag = 1 THEN DO" Section*/
		
	IF LineResults.0 > 0 THEN DO
		M = M + 1
		DO K = 1 TO LineResults.0 BY 1
			ScanLineResults.M.K = LineResults.K
		END K	/*Ends "DO K = 1 TO LineResults.0 BY 1" Section*/
		ScanFilePathResults.M = ScanPath
		ScanLineResults.M.0 = LineResults.0
		ScanSysFileTreeResults.M = OtherServicesFileDirectory.J

		Remainder = ScanFilePathResults.M
		Data = Remainder
		DO UNTIL Remainder = ""
			PARSE VAR Data First "\" Remainder
			Data = Remainder				
		END	/*Ends "DO UNTIL Remainder = """ Section*/
		ScanFileNameResults.M = First
		FileType.M = "ASCII"
		ITERATE
	END	/*Ends "F LineResults.0 > 0 THEN DO" Section*/
	/*End scanning under the assumption that the file type is ASCII*/


	IF LineResults.0 > 0 THEN DO
		CALL OFF ERROR
		CALL OFF NOTREADY
		ITERATE	/*If the file, above, is read, go to the next iteration of this do loop*/
			/*Note RC = 3 means that a file openning error occurred (the file is probably binary)*/
	END	/*Ends "IF LineResults.0 > 0 THEN DO" Section*/

	ELSE DO
		CALL BINARY
		ITERATE	/*After returning from the BINARY routine, go to the next iteration of this do loop*/
	END	/*Ends "ELSE DO" Section*/


	BINARY:
	/*Begin scanning under the assumption that the file type is binary*/
	BinaryFlag = 1
	ToSpace = XRange("7F"x, "1F"x)	/*These are non printing characters*/

	P = 0
	/*Begin specifying the path and filename of the binary file to read*/
	FilePathToRead = OtherServicesFilePath.J
	Remainder = FilePathToRead
	Data = Remainder
	DO UNTIL Remainder = ""
		PARSE VAR Data First "\" Remainder
		Data = Remainder
	END	/*Ends "DO UNTIL Remainder = """ Section*/
	FileName = First
	/*End specifying the path and filename of the binary file to read*/

	/*Begin reading the file, 256 characters at a time, and creating a temporary ASCII equivalent of it*/
	ReadLine. = ""
	Start = 1
	ReadLength = MIN(CHARS(FilePathToRead),256)
	DO WHILE ReadLength > 0
		P = P + 1
		ReadLine.P = CHARIN(FilePathToRead,Start,ReadLength)
		
		ReadLine.P = TRANSLATE(ReadLine.P, "^", '0A'x)	/*Remove all lines feeds and make one continuous line*/
		ReadLine.P = TRANSLATE(ReadLine.P, Copies('00'x, ReadLength), ToSpace)	/*Translate unprintable characters to spaces so that PARSE can separate printable data from binary data*/
		ReadLine.P = TRANSLATE(TRANSLATE(ReadLine.P, 'FF'x, " "), " ", '00'x)	/*Translate spaces to "FF"x so that PARSE will not break up Titles with spaces, then translate all '00'x characters to spaces*/
		Stuff = ReadLine.P
		ReadLine.P = ""
		DO WHILE Stuff \= ""
			PARSE VAR Stuff Data Stuff
			Data = STRIP(Data, "B")
			SELECT
				WHEN ReadLine.P = "" THEN ReadLine.P = Data
				WHEN ReadLine.P \= "" THEN ReadLine.P = ReadLine.P" "Data
				OTHERWISE NOP
			END	/*Ends "SELECT" Section*/
		END	/*Ends "DO WHILE Stuff \= """ Section*/
		Start = Start + ReadLength
		ReadLength = MIN(CHARS(FilePathToRead),256)
	END
	RC = STREAM(FilePathToRead,"COMMAND","CLOSE")
	ReadLine.0 = P
	TemporaryASCIIFileToWrite = ProgramLocation"\SeekTemp\"FileName" (ASCII)"
	RC = WRITE_DATA(ReadLine, TemporaryASCIIFileToWrite)
	/*End reading the file, 256 characters at a time, and creating a temporary ASCII equivalent of it*/

	/*Begin scanning the temporary ASCII equivalent file*/
	ScanPath = TemporaryASCIIFileToWrite
	LineResults. = ""
	RC = SYSFILESEARCH(SearchString,ScanPath,LineResults,N)
	IF LineResults.0 > 0 THEN DO
		M = M + 1
		DO K = 1 TO LineResults.0 BY 1
			ScanLineResults.M.K = LineResults.K
		END K	/*Ends "DO K = 1 TO LineResults.0 BY 1" Section*/
		ScanFilePathResults.M = FilePathToRead
		ScanLineResults.M.0 = LineResults.0
		ScanSysFileTreeResults.M = OtherServicesFileDirectory.J

		Remainder = ScanFilePathResults.M
		Data = Remainder
		DO UNTIL Remainder = ""
			PARSE VAR Data First "\" Remainder
			Data = Remainder				
		END	/*Ends "DO UNTIL Remainder = """ Section*/
		ScanFileNameResults.M = First
		FileType.M = "binary"
	END	/*Ends "F LineResults.0 > 0 THEN DO" Section*/
	RC = SYSFILEDELETE(TemporaryASCIIFileToWrite)
	/*End scanning under the assumption that the file type is binary*/
	RETURN
	/*End scanning each file for the desired text*/
END J	/*End "DO J = 1 TO OtherServicesFilePath.0 BY 1" Section*/
ScanFilePathResults.0 = M
/*End scanning each selected file for the desired text*/
RETURN
/* ##SUB_SEEKENDS */
SEEKENDS: /*Procedure to enable or disable the "Continue/Seek" button*/



/* Get item value FILENAME Entry Field */
FileName = VpGetItemValue(window,'FILENAME')
/* Get button state SELECTONERADIOBUTTON Radio Button */
SelectOneFlag = VpIsSelected(window,'SELECTONERADIOBUTTON')
/* Get button state SELECTMULTIPLERADIOBUTTON Radio Button */
SelectMultipleFlag = VpIsSelected(window,'SELECTMULTIPLERADIOBUTTON')



SELECT
	WHEN SelectOneFlag = 1 THEN DO
		Total1 = 0
		DO I = 1 TO MaxDriveNumber BY 1
			SubjectDriveRadioButton = "DRIVE"I"RADIOBUTTON"
			Total1 = Total1 + VpIsSelected(window,SubjectDriveRadioButton)
		END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
	END	/*Ends "WHEN SelectOneFlag = 1 THEN DO" Section*/

	WHEN SelectMultipleFlag = 1 THEN DO
		Total2 = 0
		DO I = 1 TO MaxDriveNumber BY 1
			SubjectDriveCheckBox = "DRIVE"I"CHECKBOX"
			Total2 = Total2 + VpIsSelected(window,SubjectDriveCheckBox)
		END I	/*Ends "DO I = 1 TO MaxDriveNumber BY 1" Section*/
	END	/*Ends "WHEN SelectMultipleFlag = 1 THEN DO" Section*/

	OTHERWISE NOP
END	/*Ends "SELECT" Section*/



IF FileName \= "" THEN DO
	SELECT
		WHEN SelectOneFlag = 1 & Total1 > 0 THEN
			/* Enable item CONTINUE Push Button */
			CALL VpItem window,'CONTINUE','ENABLE'


		WHEN SelectMultipleFlag = 1 & Total2 > 0 THEN
			/* Enable item CONTINUE Push Button */
			CALL VpItem window,'CONTINUE','ENABLE'

		OTHERWISE NOP
	END	/*Ends "SELECT" Section*/
END	/*Ends "IF FileName \= "" THEN DO" Section*/


ELSE DO
	/* Disable item CONTINUE Push Button */
	CALL VpItem window,'CONTINUE','DISABLE'
	/* Give item focus FILENAME Entry Field */
	CALL VpItem window,'FILENAME','FOCUS'
END	/*Ends "ELSE DO" Section*/
RETURN

/* ##SUB_SELAPP */
SELAPP: /*Manual selection of a desired application*/



/*Begin determining what Radio Button was clicked/selected*/
SELECT
	WHEN Mult_AppsFlag = 1 THEN Radio_Button = APP||App_Num
	OTHERWISE Radio_Button = File_Category
END	/*Ends "SELECT" Section*/
/*End determining what Radio Button was clicked/selected*/



/*Begin launching the selected file into the selected application, or alternatively, sending an instruction message*/
SELECT
	WHEN File_SelectFlag = 1 THEN DO
		IF Setup.Application.File_Category.PPath.App_Num = Command_Processor_Path THEN App_Path = OtherServicesFilePath.Index	/*Different way to start and use OS/2 command processor for launching REXX programs*/
		ELSE App_Path = Setup.Application.File_Category.PPath.App_Num
		/* Get index of first selected item LAUNCH List Box */
		Index=VpGetIndex(window,'LAUNCH','SELECTED',0)
		RC = .DTTOOLS~FIND_MANUAL_ASSOCIATION(File_Association., App_Path, Index)
		CALL FLAUNCH
		/* Uncheck the item Radio_Button Radio Button */
		CALL VpSelect window,Radio_Button,0
		IF Auto_to_ManualFlag = 1 THEN DO
			/* Uncheck the item MANUAL Radio Button */
			CALL VpSelect window,'MANUAL',0
			/* Check the item  AUTO Radio Button */
			CALL VpSelect window,'AUTO',1
			Auto_to_ManualFlag = 0
			CALL AUTOLNCH
		END	/*Ends "IF Auto_to_ManualFlag = 1 THEN DO" Section*/
		ELSE DO
			Instruction = "Highlight (single click on) the desired filename. Next, select the application to launch."
			/* Set item value INSTRUCT Text */
			CALL VpSetItemValue window,'INSTRUCT',Instruction
			/* Check the item  MANUAL Radio Button */
			CALL VpSelect window,'MANUAL',1
		END	/*Ends "ELSE DO" Section*/
	END	/*Ends "WHEN File_SelectFlag = 1 THEN DO" Section*/

	OTHERWISE DO
		Instruction = "You have selected an application. Now, select a file, immediately below, to manually launch it."
		/* Set item value INSTRUCT Text */
		CALL VpSetItemValue window,'INSTRUCT',Instruction
	END	/*Ends "OTHERWISE DO" Section*/
END	/*Ends "SELECT" Section*/
/*End launching the selected file into the selected application, or alternatively, sending an instruction message*/
RETURN

/* ##SUB_SORT */
SORT: /*Sorts the list of matching files by date, time, size, alphabethically by path and filename or alphabethically by filename*/



/*Begin skipping some of the code of this procedure, SORT, if the data has been previously sorted*/
IF SortFlag = 1 THEN SIGNAL PREVIOUSLYSORTED
/*End skipping some of the code of this procedure, SORT, if the data has been previously sorted*/



/*Begin separating the date, time, file size and file path data from the matched files data in the LISTFILES List Box*/
MatchedFiles. = ""
SortedFiles. = .STEM~NEW
SortedFiles. = ""
Date. = ""
Time. = ""
Size. = ""
Attributes. = ""
MatchedPathandFileName. = ""
MatchedFileName. = ""
DateLength = 0
TimeLength = 0
SizeLength = 0
AttributesLength = 0
MatchedPathandFileNameLength = 0
MatchedFileNameLength = 0
SortedResults. = ""
SortedResultsPathandFileName. = ""
Results. = ""
/* Get all items LISTFILES List Box */
CALL VpGetItemValue window, 'LISTFILES', 'ALL', 'VALUE.'
DO N = 1 TO VALUE.[0] BY 1
	MatchedFiles.[N] = VALUE.[N]
END N	/*Ends "DO N = 1 TO VALUE.[0] BY 1" Section*/
MatchedFiles.[0] = VALUE.[0]


DO N = 1 TO MatchedFiles.[0] BY 1
	/*Begin getting the date portion of the data (no need to convert it to a specific format; the STEMSORT() function does that)*/
	Data = STRIP(MatchedFiles.[N],"B")
	PARSE VAR Data Date.N Remainder
	IF LENGTH(Date.[N]) > DateLength THEN DateLength = LENGTH(Date.[N])
	/*End getting the date portion of the data (no need to convert it to a specific format; the STEMSORT() function does that)*/

	/*Begin getting the time portion of the data (no need to convert it to a specific format; the STEMSORT() function does that)*/
	Data = STRIP(Remainder,"B")
	PARSE VAR Data Time.N Remainder
	IF LENGTH(Time.[N]) > TimeLength THEN TimeLength = LENGTH(Time.[N])
	/*End getting the time portion of the data (no need to convert it to a specific format; the STEMSORT() function does that)*/

	/*Begin getting the file size portion of the data*/
	Data = STRIP(Remainder,"B")
	PARSE VAR Data Size.N Remainder
	IF LENGTH(Size.[N]) > SizeLength THEN SizeLength = LENGTH(Size.[N])
	/*End getting the file size portion of the data*/

	/*Begin getting the attribute portion of the data*/
	Data = STRIP(Remainder,"B")
	PARSE VAR Data Attributes.N Remainder
	IF LENGTH(Attributes.[N]) > AttributesLength THEN AttributesLength = LENGTH(Attributes.[N])
	/*End getting the attribute portion of the data*/

	/*Begin getting the file path portion of the data and converting it all to lower case alphabeth*/
	MatchedPathandFileName.[N] = STRIP(Remainder,"B")
	IF LENGTH(MatchedPathandFileName.[N]) > MatchedPathandFileNameLength THEN MatchedPathandFileNameLength = LENGTH(MatchedPathandFileName.[N])
	/*End getting the file path portion of the data and converting it all to lower case alphabeth*/

	/*Begin getting the filename portion of the data*/
	Data = MatchedPathandFileName.[N]
	Remainder = Data
	DO UNTIL Remainder = ""
		PARSE VAR Data FirstPart "\" Remainder
		Data = Remainder
	END	/*Ends "DO UNTIL Remainder = """ Section*/
	MatchedFileName.[N] = FirstPart
	IF LENGTH(MatchedFileName.[N]) > MatchedFileNameLength THEN MatchedFileNameLength = LENGTH(MatchedFileName.[N])
	/*End getting the filename portion of the data*/
END N	/*Ends "DO N = 1 TO MatchedFiles.[0] BY 1" Section*/



/*Begin recreating the data in the MatchedFiles. records so I can effectively use my STEMSORT() function*/
/*Begin creating the SortedFiles. compound variable*/
DO N = 1 TO MatchedFiles.[0] BY 1
	SortedFiles.[N] = Date.[N]

	Position = DateLength + 2
	SortedFiles.[N] = INSERT(Time.[N], SortedFiles.[N], Position)

	Position = Position + TimeLength + 2
	SortedFiles.[N] = INSERT(Size.[N], SortedFiles.[N], Position)

	Position = Position + SizeLength + 2
	SortedFiles.[N] = INSERT(MatchedPathandFileName.[N], SortedFiles.[N], Position)"#::#"

	Position = Position + MatchedPathandFileNameLength + 6
	SortedFiles.[N] = INSERT(MatchedFileName.[N], SortedFiles.[N], Position)"#::#"

	Position = Position + MatchedFileNameLength + 6
	SortedFiles.[N] = INSERT(Attributes.[N], SortedFiles.[N], Position)
END N	/*Ends "DO N = 1 TO MatchedFiles.[0] BY 1" Section*/
SortedFiles.[0] = MatchedFiles.[0]
/*End creating the SortedFiles. compound variable*/
/*End recreating the data in the MatchedFiles. records so I can effectively use my STEMSORT() function*/



/*Begin sorting the SortedFiles. array based on the value of the SortType variable*/
DateStart = 1
TimeStart = DateStart + DateLength + 2
SizeStart = TimeStart + TimeLength + 2
MatchedPathandFileNameStart = SizeStart + SizeLength + 2
MatchedFileNameStart = MatchedPathandFileNameStart + MatchedPathandFileNameLength + 6

PREVIOUSLYSORTED:
SELECT
	WHEN SortType = "Sort by Date" THEN DO
		Command = 'SortedFiles. = .LSB~STEMSORT(SortedFiles., 1, MatchedFiles.[0], DateStart, DateLength,SortOrder, "D", TimeStart, TimeLength, SortOrder, "T", MatchedFileNameStart, MatchedFileNameLength, SortOrder, "I")'
		AscendingFlag = DateSortAscendingFlag
		DescendingFlag = DateSortDescendingFlag
	END	/*Ends "WHEN SortType = "Sort by Date" THEN DO" Section*/

	WHEN SortType = "Sort by Time" THEN DO
		Command = 'SortedFiles. = .LSB~STEMSORT(SortedFiles., 1, MatchedFiles.[0], TimeStart, TimeLength, SortOrder, "T", DateStart, DateLength, SortOrder, "D", MatchedFileNameStart, MatchedFileNameLength, SortOrder, "I")'
		AscendingFlag = TimeSortAscendingFlag
		DescendingFlag = TimeSortDescendingFlag
	END	/*Ends "WHEN SortType = "Sort by Time" THEN DO" Section*/

	WHEN SortType = "Sort by File Size" THEN DO
		Command = 'SortedFiles. = .LSB~STEMSORT(SortedFiles., 1, MatchedFiles.[0], SizeStart, SizeLength, SortOrder, "N")'
		AscendingFlag = SizeSortAscendingFlag
		DescendingFlag = SizeSortDescendingFlag
	END	/*Ends "WHEN SortType = "Sort by File Size" THEN DO" Section*/

	WHEN SortType = "Sort by File Path" THEN DO
		Command = 'SortedFiles. = .LSB~STEMSORT(SortedFiles., 1, MatchedFiles.[0], MatchedPathandFileNameStart, MatchedPathandFileNameLength, SortOrder, "I")'
		AscendingFlag = FilePathSortAscendingFlag
		DescendingFlag = FilePathSortDescendingFlag
	END	/*Ends "WHEN SortType = "Sort by File Path" THEN DO" Section*/

	WHEN SortType = "Sort by FileName" THEN DO
		Command = 'SortedFiles. = .LSB~STEMSORT(SortedFiles., 1, MatchedFiles.[0], MatchedFileNameStart, MatchedFileNameLength, SortOrder, "I")'
		AscendingFlag = FileNameSortAscendingFlag
		DescendingFlag = FileNameSortDescendingFlag
	END	/*Ends "WHEN SortType = "Sort by FileName" THEN DO" Section*/

	OTHERWISE NOP
END	/*Ends "SELECT" Section*/


SELECT
	WHEN AscendingFlag = 0 & DescendingFlag = 0 THEN DO
		INTERPRET Command
		SELECT
			WHEN SortOrder = "A" THEN DO
				IF SortType = "Sort by Date" THEN DO
					DateSortAscendingFlag = 1
					DateSortedFilesAscending. = SortedFiles.~COPY
				END	/*Ends "IF SortType = "Sort by Date" THEN DO" Section*/
				IF SortType = "Sort by Time" THEN DO
					TimeSortAscendingFlag = 1
					TimeSortedFilesAscending. = SortedFiles.~COPY
				END	/*Ends "IF SortType = "Sort by Time" THEN DO" Section*/
				IF SortType = "Sort by File Size" THEN DO
					SizeSortAscendingFlag = 1
					SizeSortedFilesAscending. = SortedFiles.~COPY
				END	/*Ends "IF SortType = "Sort by File Size" THEN DO" Section*/
				IF SortType = "Sort by File Path" THEN DO
					FilePathSortAscendingFlag = 1
					FilePathSortedFilesAscending. = SortedFiles.~COPY
				END	/*Ends "IF SortType = "Sort by File Path" THEN DO" Section*/
				IF SortType = "Sort by FileName" THEN DO
					FileNameSortAscendingFlag = 1
					FileNameSortedFilesAscending. = SortedFiles.~COPY
				END	/*Ends "IF SortType = "Sort by FileName" THEN DO" Section*/
			END	/*Ends "WHEN SortOrder = "A" THEN DO" Section*/

			WHEN SortOrder = "D" THEN DO
				IF SortType = "Sort by Date" THEN DO
					DateSortDescendingFlag = 1
					DateSortedFilesDescending. = SortedFiles.~COPY
				END	/*Ends "WHEN SortOrder = "D" THEN DO" Section*/
				IF SortType = "Sort by Time" THEN DO
					TimeSortDescendingFlag = 1
					TimeSortedFilesDescending. = SortedFiles.~COPY
				END	/*Ends "IF SortType = "Sort by Time" THEN DO" Section*/
				IF SortType = "Sort by File Size" THEN DO
					SizeSortDescendingFlag = 1
					SizeSortedFilesDescending. = SortedFiles.~COPY
				END	/*Ends "IF SortType = "Sort by File Size" THEN DO" Section*/
				IF SortType = "Sort by File Path" THEN DO
					FilePathSortDescendingFlag = 1
					FilePathSortedFilesDescending. = SortedFiles.~COPY
				END	/*Ends "IF SortType = "Sort by File Path" THEN DO" Section*/
				IF SortType = "Sort by FileName" THEN DO
					FileNameSortDescendingFlag = 1
					FileNameSortedFilesDescending. = SortedFiles.~COPY
				END	/*Ends "IF SortType = "Sort by FileName" THEN DO" Section*/
			END	/*Ends "WHEN SortOrder = "D" THEN DO" Section*/

			OTHERWISE NOP
		END	/*Ends "SELECT" Section*/
	END	/*Ends "WHEN AscendingFlag = 0 & DescendingFlag = 0 THEN DO" Section*/

	WHEN AscendingFlag = 0 & SortOrder = "A" THEN DO
		IF SortType = "Sort by Date" THEN DO
			SortedFiles. = .STEM~FLIP(DateSortedFilesDescending., MatchedFiles.[0])
			DateSortAscendingFlag = 1
			DateSortedFilesAscending. = SortedFiles.~COPY
		END	/*Ends "IF SortType = "Sort by Date" THEN DO" Section*/
		IF SortType = "Sort by Time" THEN DO
			SortedFiles. = .STEM~FLIP(TimeSortedFilesDescending., MatchedFiles.[0])
			TimeSortAscendingFlag = 1
			TimeSortedFilesAscending. = SortedFiles.~COPY
		END	/*Ends "IF SortType = "Sort by Time" THEN DO" Section*/
		IF SortType = "Sort by File Size" THEN DO
			SortedFiles. = .STEM~FLIP(SizeSortedFilesDescending., MatchedFiles.[0])
			SizeSortAscendingFlag = 1
			SizeSortedFilesAscending. = SortedFiles.~COPY
		END	/*Ends "IF SortType = "Sort by File Size" THEN DO" Section*/
		IF SortType = "Sort by File Path" THEN DO
			SortedFiles. = .STEM~FLIP(FilePathSortedFilesDescending., MatchedFiles.[0])
			FilePathSortAscendingFlag = 1
			FilePathSortedFilesAscending. = SortedFiles.~COPY
		END	/*Ends "IF SortType = "Sort by File Path" THEN DO" Section*/
		IF SortType = "Sort by FileName" THEN DO
			SortedFiles. = .STEM~FLIP(FileNameSortedFilesDescending., MatchedFiles.[0])
			AscendingFlag = FileNameSortAscendingFlag = 1
			FileNameSortedFilesAscending. = SortedFiles.~COPY
		END	/*Ends "IF SortType = "Sort by FileName" THEN DO" Section*/
	END	/*Ends "WHEN AscendingFlag = 0 & SortOrder = "A" THEN DO" Section*/

	WHEN DescendingFlag = 0 & SortOrder = "D" THEN DO
		IF SortType = "Sort by Date" THEN DO
			SortedFiles. = .STEM~FLIP(DateSortedFilesAscending., MatchedFiles.[0])
			DateSortDescendingFlag = 1
			DateSortedFilesDescending. = SortedFiles.~COPY
		END	/*Ends "WHEN SortOrder = "D" THEN DO" Section*/
		IF SortType = "Sort by Time" THEN DO
			SortedFiles. = .STEM~FLIP(TimeSortedFilesAscending., MatchedFiles.[0])
			TimeSortDescendingFlag = 1
			TimeSortedFilesDescending. = SortedFiles.~COPY
		END	/*Ends "IF SortType = "Sort by Time" THEN DO" Section*/
		IF SortType = "Sort by File Size" THEN DO
			SortedFiles. = .STEM~FLIP(SizeSortedFilesAscending., MatchedFiles.[0])
			SizeSortDescendingFlag = 1
			SizeSortedFilesDescending. = SortedFiles.~COPY
		END	/*Ends "IF SortType = "Sort by File Size" THEN DO" Section*/
		IF SortType = "Sort by File Path" THEN DO
			SortedFiles. = .STEM~FLIP(FilePathSortedFilesAscending., MatchedFiles.[0])
			FilePathSortDescendingFlag = 1
			FilePathSortedFilesDescending. = SortedFiles.~COPY
		END	/*Ends "IF SortType = "Sort by File Path" THEN DO" Section*/
		IF SortType = "Sort by FileName" THEN DO
			SortedFiles. = .STEM~FLIP(FileNameSortedFilesAscending., MatchedFiles.[0])
			FileNameSortDescendingFlag = 1
			FileNameSortedFilesDescending. = SortedFiles.~COPY
		END	/*Ends "IF SortType = "Sort by FileName" THEN DO" Section*/
	END	/*Ends "WHEN DescendingFlag = 0 & SortOrder = "D" THEN DO" Section*/

	WHEN SortOrder = "A" THEN DO
		IF SortType = "Sort by Date" THEN SortedFiles. = DateSortedFilesAscending.~COPY
		IF SortType = "Sort by Time" THEN SortedFiles. = TimeSortedFilesAscending.~COPY
		IF SortType = "Sort by File Size" THEN SortedFiles. = SizeSortedFilesAscending.~COPY
		IF SortType = "Sort by File Path" THEN SortedFiles. = FilePathSortedFilesAscending.~COPY
		IF SortType = "Sort by FileName" THEN SortedFiles. = FileNameSortedFilesAscending.~COPY
	END	/*Ends "WHEN SortOrder = "A" THEN DO" Section*/

	WHEN SortOrder = "D" THEN DO
		IF SortType = "Sort by Date" THEN SortedFiles. = DateSortedFilesDescending.~COPY
		IF SortType = "Sort by Time" THEN SortedFiles. = TimeSortedFilesDescending.~COPY
		IF SortType = "Sort by File Size" THEN SortedFiles. = SizeSortedFilesDescending.~COPY
		IF SortType = "Sort by File Path" THEN SortedFiles. = FilePathSortedFilesDescending.~COPY
		IF SortType = "Sort by FileName" THEN SortedFiles. = FileNameSortedFilesDescending.~COPY
	END	/*Ends "WHEN SortOrder = "D" THEN DO" Section*/

	OTHERWISE NOP
END	/*Ends "SELECT" Section*/
/*End sorting the SortedFiles. array based on the value of the SortType variable*/



/*Begin comparing creating the sorted data for the list, using data from SortedFiles.[N],*/
DO N = 1 TO MatchedFiles.[0] BY 1
	PARSE VAR SortedFiles.N DateVar TimeVar SizeVar PathandFileNameVar "#::#" FileNameVar "#::#" AttributesVar
	DateVar = STRIP(DateVar, "B")
	AttributesVar = STRIP(AttributesVar, "B")
	Results.[N] = " "DateVar

	Position = DateLength + 3 + (TimeLength - LENGTH(TimeVar))
	Results.[N] = INSERT(TimeVar, Results.[N], Position)

	Position = DateLength + TimeLength + 5 + (SizeLength - LENGTH(SizeVar))
	Results.[N] = INSERT(SizeVar, Results.[N], Position)

	Position = DateLength + TimeLength + SizeLength + 7 + (AttributesLength - LENGTH(AttributesVar))
	Results.[N] = INSERT(AttributesVar, Results.[N], Position)

	Results.[N] = Results.[N]"  "PathandFileNameVar
END N	/*Ends "DO N = 1 TO MatchedFiles.[0] BY 1" Section*/
Results.[0] = MatchedFiles.[0]



/*Begin rewritting the list of matched files, now sorted as desired*/
/* Delete all items LISTFILES List Box */
CALL VpDeleteItem window,'LISTFILES','ALL'
SELECT
	WHEN Results.[0] > 0 THEN DO
		/* Add items from list LISTFILES List Box */
		index=VpAddItem(window, 'LISTFILES', 'LIST', 'Results.')
		NOP
	END	/*Ends "WHEN Results.[0] > 0 THEN DO" Section*/

	OTHERWISE NOP
END	/*Ends "SELECT" Section*/
/*End rewritting the list of matched files, now sorted as desired*/

return

/* ##SUB_UNCKAPPS */
UNCKAPPS: /*Unchecks the Radio Button of all the various applications*/
/* Uncheck the item WP Radio Button */
CALL VpSelect window,'WP',0
/* Uncheck the item N_ED Radio Button */
CALL VpSelect window,'N_ED',0
/* Uncheck the item R_ED Radio Button */
CALL VpSelect window,'R_ED',0
/* Uncheck the item L_ED Radio Button */
CALL VpSelect window,'L_ED',0
/* Uncheck the item R_R Radio Button */
CALL VpSelect window,'R_R',0
/* Uncheck the item SS Radio Button */
CALL VpSelect window,'SS',0
/* Uncheck the item FIN Radio Button */
CALL VpSelect window,'FIN',0
/* Uncheck the item WB Radio Button */
CALL VpSelect window,'WB',0
/* Uncheck the item PDF Radio Button */
CALL VpSelect window,'PDF',0
/* Uncheck the item PS Radio Button */
CALL VpSelect window,'PS',0
/* Uncheck the item GRAPHICS Radio Button */
CALL VpSelect window,'GRAPHICS',0
/* Uncheck the item DRAFTING Radio Button */
CALL VpSelect window,'DRAFTING',0
/* Uncheck the item USER_DEFINED Radio Button */
CALL VpSelect window,'USER_DEFINED',0

DO I = 1 TO 20 BY 1
	Radio_Button = "APP"I
	/* Uncheck the item Radio_Button Radio Button */
	CALL VpSelect window,'APP1',0
END I	/*Ends "DO I = 1 TO 20 BY 1" Section*/
RETURN

/* ##SUB_zDirectives */
zDirectives: /*Directives*/

::CLASS DESKTOP
::CLASS DTTOOLS SUBCLASS DESKTOP
::METHOD STEM_INIT CLASS
	EXPOSE OutputStem.
	USE ARG InitializeValue
	OutputStem. = .STEM~NEW
	OutputStem. = InitializeValue
	RETURN OutputStem.

::METHOD GET_SETUP CLASS
	USE ARG Location, Command_Processor_Path, InputStem., Msg.
	NotFound_Flag = .DTTOOLS~FIND_STREAM("SETUP", Location, Msg.)
	IF NotFound_Flag = 0 THEN DO
		Setup_Lines. = .IO~READ_DATA_2(Location"SETUP", " = ", "=")
		DO I = 1 TO Setup_Lines.[0] BY 1
			Assignment = Setup_Lines.[I]
			INTERPRET Assignment
		END I	/*Ends "DO I = 1 TO Setup_Lines.[0] BY 1" Sections*/
		InputStem.File_Type.0.0 = 0
		InputStem.File_Filter.0.0 = 0
		RC = .DTTOOLS~VERIFY_COUNT(Command_Processor_Path, InputStem., "WP", 1, 1, 3, InputStem.File_Type.0.0, InputStem.File_Filter.0.0)
		RC = .DTTOOLS~VERIFY_COUNT(Command_Processor_Path, InputStem., "N_ED", 4, 1, 3, InputStem.File_Type.0.0, InputStem.File_Filter.0.0)
		RC = .DTTOOLS~VERIFY_COUNT(Command_Processor_Path, InputStem., "R_ED", 2, 1, 3, InputStem.File_Type.0.0, InputStem.File_Filter.0.0)
		RC = .DTTOOLS~VERIFY_COUNT(Command_Processor_Path, InputStem., "L_ED", 1, 1, 2, InputStem.File_Type.0.0, InputStem.File_Filter.0.0)
		RC = .DTTOOLS~VERIFY_COUNT(Command_Processor_Path, InputStem., "R_R", 2, 1, 2, InputStem.File_Type.0.0, InputStem.File_Filter.0.0)
		RC = .DTTOOLS~VERIFY_COUNT(Command_Processor_Path, InputStem., "SS", 1, 1, 3, InputStem.File_Type.0.0, InputStem.File_Filter.0.0)
		RC = .DTTOOLS~VERIFY_COUNT(Command_Processor_Path, InputStem., "FIN", 1, 1, 3, InputStem.File_Type.0.0, InputStem.File_Filter.0.0)
		RC = .DTTOOLS~VERIFY_COUNT(Command_Processor_Path, InputStem., "WB", 2, 1, 3, InputStem.File_Type.0.0, InputStem.File_Filter.0.0)
		RC = .DTTOOLS~VERIFY_COUNT(Command_Processor_Path, InputStem., "PDF", 3, 1, 3, InputStem.File_Type.0.0, InputStem.File_Filter.0.0)
		RC = .DTTOOLS~VERIFY_COUNT(Command_Processor_Path, InputStem., "PS", 1, 1, 3, InputStem.File_Type.0.0, InputStem.File_Filter.0.0)
		RC = .DTTOOLS~VERIFY_COUNT(Command_Processor_Path, InputStem., "GRAPHICS", 1, 1, 50, InputStem.File_Type.0.0, InputStem.File_Filter.0.0)
		RC = .DTTOOLS~VERIFY_COUNT(Command_Processor_Path, InputStem., "DRAFTING", 1, 1, 3, InputStem.File_Type.0.0, InputStem.File_Filter.0.0)
		RC = .DTTOOLS~VERIFY_COUNT(Command_Processor_Path, InputStem., "USER_DEFINED", 20, 1, 3, InputStem.File_Type.0.0, InputStem.File_Filter.0.0)
	END	/*Ends "IF NotFound_Flag = 0 THEN DO" Section*/
	ELSE RC = .DTTOOLS~CONSTRUCT_SETUP0(Location)
	RETURN NotFound_Flag

::METHOD VERIFY_COUNT CLASS
	USE ARG Command_Processor_Path, InputStem., File_Category, Maximum_Allowable, Type_Maximum, Filter_Maximum, Type_Count, Filter_Count
	Count = 0
	Trap_Call = 0
	CALL ON ERROR NAME VERIFY_COUNT_TRAP
	CALL ON FAILURE NAME VERIFY_COUNT_TRAP
	DO I = 1 TO Maximum_Allowable BY 1
		SearchPath = InputStem.Application.File_Category.PPath.I
		IF SearchPath \= "" THEN DO
			Found_Application. = ""
			RC = SYSFILETREE(SearchPath,"Found_Application","FO")
			SELECT
				WHEN Found_Application.0 = 1 THEN DO
					Count = Count + 1
					DO J = 1 TO Type_Maximum BY 1
						Type_Count = Type_Count + 1
						InputStem.File_Type.Type_Count.1 = InputStem.Application.File_Category.AAssociation_File_Type.I
						InputStem.File_Type.Type_Count.2 = InputStem.Application.File_Category.PPath.I
						InputStem.File_Type.0.0 = Type_Count
					END J	/*Ends "DO J = 1 TO Type_Maximum BY 1" Section*/

					DO K = 1 TO Filter_Maximum BY 1
						Filter_Count = Filter_Count + 1
						InputStem.File_Filter.Filter_Count.1 = InputStem.Application.File_Category.AAssociation_File_Filter.I.K
						InputStem.File_Filter.Filter_Count.2 = InputStem.Application.File_Category.PPath.I
						InputStem.File_Filter.0.0 = Filter_Count
					END K	/*Ends "DO K = 1 TO Filter_Maximum BY 1" Section*/
				END	/*Ends "WHEN Found_Application.0 = 1 THEN DO" Section*/

				WHEN Found_Application.0 = 0 | Trap_Call = 1 THEN DO
					RC = .IO~APPLICATION_NOT_FOUND(InputStem., File_Category, Maximum_Allowable, SearchPath, Count)
					LEAVE I
				END	/*Ends "WHEN Found_Application.0 = 0 | Trap_Call = 1 THEN DO" Section*/

				OTHERWISE NOP
			END	/*Ends "SELECT" Section*/
		END	/*Ends "IF SearchPath \= "" THEN DO" Section*/
		ELSE LEAVE I
	END I	/*Ends "DO I = 1 TO Maximum_Allowable BY 1" Section*/
	InputStem.Application.File_Category.NName.0 = Count
	CALL OFF ERROR
	CALL OFF FAILURE
	RETURN 0
	VERIFY_COUNT_TRAP:
	Trap_Call = 1
	RETURN

::METHOD CONSTRUCT_SETUP0 CLASS
	USE ARG Location
	Setup0_Line.[1] = '/*This ASCII (text) file, SETUP, provides the setup function for the REXX SEEK application (it assigns values to several SEEK setup variables).*/'
	Setup0_Line.[2] = '/*It provides time and date formats in the SEEK presort facility, file associations for launching files into applications and user choice on whether or not to use REXXLIB and REXXEA*/'
	Setup0_Line.[3] = 'NOTES:'
	Setup0_Line.[4] = '	1.	You can add your own notes to this setup file anywhere you like. IMPORTANT: Do not use an "equal sign" (ASCII control sequence of 61) anywhere in this file, unless you are using it to assign'
	Setup0_Line.[5] = '		a value to a setup/options variable that the SEEK program uses.'
	Setup0_Line.[6] = ''
	Setup0_Line.[7] = '	2.	The SEEK program knows the location of this file, among others, via the SEEK variable, "ProgramLocation", which has a value assigned to it via the REXX "PARSE SOURCE" code. On my computer'
	Setup0_Line.[8] = '		ProgramLocation is assigned the value of "C:\Development\REXX\VisProREXX\PROJECTS\Seek_Gold\LSB_Radix_Sort\Seek\".'
	Setup0_Line.[9] = ''
	Setup0_Line.[10] = '	3.	The SEEK program does a REXX SYSFILESEARCH() operation to find this file, "SETUP". It then uses the "equal sign" (ASCII control sequence of 61) as the item to search for to find all of the'
	Setup0_Line.[11] = '		SEEK SETUP variable assignments.'
	Setup0_Line.[12] = ''
	Setup0_Line.[13] = '	4.	Below, use the "equal sign" (ASCII control sequence of 61) to establish SETUP parameters for the SEEK program. If a particular parameter is to have no value, then just'
	Setup0_Line.[14] = '		use an "equal sign" (ASCII control sequence of 61) with nothing at all to the right of it, or with a set of double quotation marks to the right.'
	Setup0_Line.[15] = '		NOTE: You can use a space to the left and to the right of the "equal sign" (ASCII control sequence of 61), or not (your choice).'
	Setup0_Line.[16] = ''
	Setup0_Line.[17] = ''
	Setup0_Line.[18] = ''
	Setup0_Line.[19] = '/*Section: 1: Begin establishing SEEK program specific variables, such as for the date and time formats*/'
	Setup0_Line.[20] = 'These formats establish how SEEK displays dates and times in its "Presort" facility'
	Setup0_Line.[21] = 'To set the desired date or time format, do the following:'
	Setup0_Line.[22] = '	1.	Copy and the desired format from the date or time explanation section, immediately below (example: InputStem.Presort_Date_Format?"MM DD YYYY")'
	Setup0_Line.[23] = ''
	Setup0_Line.[24] = '	2.	Note that these formats have a question mark ("?") near the right-hand side'
	Setup0_Line.[25] = ''
	Setup0_Line.[26] = '	3.	Paste that format in the first line or second line right after the line: "/*Begin setting the date and time formats*/"'
	Setup0_Line.[27] = ''
	Setup0_Line.[28] = '	4.	Replace the question mark, "?", with an "equal sign" (ASCII control sequence 61)'
	Setup0_Line.[29] = ''
	Setup0_Line.[30] = ''
	Setup0_Line.[31] = '/*Begin explanation of allowed date formats (to use one of the formats, replace the "?" with an "equal sign")*/'
	Setup0_Line.[32] = 'InputStem.Presort_Date_Format?"MM DD YYYY"		"equivalent to the USA format, except that the years are 4 digits, not 2"'
	Setup0_Line.[33] = 'InputStem.Presort_Date_Format?"DD MM YYYY"		"equivalent to the European date format, except that the years are 4 digits, not 2"'
	Setup0_Line.[34] = 'InputStem.Presort_Date_Format?"YYYY MM DD"		"equivalent to the Standard format"'
	Setup0_Line.[35] = '/*End explanation of allowed date formats (to use one of the formats, replace the "?" with an "equal sign")*/'
	Setup0_Line.[36] = ''
	Setup0_Line.[37] = '/*Begin explanation of allowed time formats (to use one of the formats, replace the "?" with an "equal sign")*/'
	Setup0_Line.[38] = 'InputStem.Presort_Time_Format?"HH MM SS AMPM"		"hours, minutes and seconds of the day, based on a 12 hour clock with AM and PM designations"'
	Setup0_Line.[39] = 'InputStem.Presort_Time_Format?"HH MM SS"		"hours, minutes and seconds of the day, based on a 24 hour clock"'
	Setup0_Line.[40] = '/*End explanation of allowed time formats (to use one of the formats, replace the "?" with an "equal sign")*/'
	Setup0_Line.[41] = ''
	Setup0_Line.[42] = '/*Begin setting the date and time formats*/'
	Setup0_Line.[43] = 'InputStem.Presort_Date_Format = "MM DD YYYY"'
	Setup0_Line.[44] = 'InputStem.Presort_Time_Format = "HH MM SS AMPM"'
	Setup0_Line.[45] = '/*End setting the date and time formats*/'
	Setup0_Line.[46] = '/*Section: 1: End establishing SEEK program specific variables, such as for the date and time formats*/'
	Setup0_Line.[47] = ''
	Setup0_Line.[48] = ''
	Setup0_Line.[49] = ''
	Setup0_Line.[50] = ''
	Setup0_Line.[51] = ''
	Setup0_Line.[52] = '/*Sections 2 through 14: Begin setting up and establishing the user file associations for applications (programs) used on this computer*/'
	Setup0_Line.[53] = '/*Begin explanation of the of how the file associations work*/'
	Setup0_Line.[54] = 'These sections of SETUP establish the file/application associations that SEEK will use to open, or launch, requested files.'
	Setup0_Line.[55] = 'When you request SEEK to launch (open) a file into an application, you can do so in one of two (2) ways:'
	Setup0_Line.[56] = '	1.	Select the specific application to use for opening the file'
	Setup0_Line.[57] = '	2.	Allow SEEK to select the application, based on your established file-to-application associations (associating by file types and/or file filters)'
	Setup0_Line.[58] = ''
	Setup0_Line.[59] = 'You can establish an association to an application in either or both of the usual OS/2 (ECS) ways:'
	Setup0_Line.[60] = '	A.	Association by "file type" (examples: "Describe Document" or "Mesa Workbook File")'
	Setup0_Line.[61] = '	B.	Association by "file filter (examples: "*.TXT", for an ASCII file associated with a text editor program, or "*.M2", for a file associated with the Mesa2 spreadsheet program).'
	Setup0_Line.[62] = ''
	Setup0_Line.[63] = 'SEEK uses the extended attributes of a file to establish it's file type. It attempts to match one of the file's extended attributes to any of the listed file type associations listed here in SETUP'
	Setup0_Line.[64] = ''
	Setup0_Line.[65] = 'Except for the graphics program, you can use up to three (3) file filters to associate files to given program (application). For the graphics program you can associate up to 50 graphics file filters.'
	Setup0_Line.[66] = 'When a particular file filter has two (2) or more applications associated with it, SEEK will use the first listed application as the default for launching these files.'
	Setup0_Line.[67] = '/*End explanation of the of how the file associations work*/'
	Setup0_Line.[68] = ''
	Setup0_Line.[69] = ''
	Setup0_Line.[70] = '/*Section 2: Begin establishing the word processor data file - only one (1) application allowed*/'
	Setup0_Line.[71] = 'WORDPROCESSORS:'
	Setup0_Line.[72] = 'InputStem.Application.WP.NName.1 = "Describe"'
	Setup0_Line.[73] = 'InputStem.Application.WP.PPath.1 = "C:\Describe\OS2\Describe.exe"'
	Setup0_Line.[74] = 'InputStem.Application.WP.AAssociation_File_Type.1 = "DeScribe Document"'
	Setup0_Line.[75] = 'InputStem.Application.WP.AAssociation_File_Filter.1.1 = ""'
	Setup0_Line.[76] = 'InputStem.Application.WP.AAssociation_File_Filter.1.2 = ""'
	Setup0_Line.[77] = 'InputStem.Application.WP.AAssociation_File_Filter.1.3 = ""'
	Setup0_Line.[78] = 'InputStem.Application.WP.NName.0 = 1'
	Setup0_Line.[79] = '/*Section 2: End establishing the word processor data file - only one (1) application allowed*/'
	Setup0_Line.[80] = ''
	Setup0_Line.[81] = ''
	Setup0_Line.[82] = ''
	Setup0_Line.[83] = '/*Section 3: Begin establishing data files for normally used text editors -  up to four (4) applications allowed*/'
	Setup0_Line.[84] = 'NORMAL_TEXTEDITORS:'
	Setup0_Line.[85] = 'InputStem.Application.N_ED.NName.1 = "Future Wave Editor"'
	Setup0_Line.[86] = 'InputStem.Application.N_ED.PPath.1 = "C:\UTILITIES\TEXT_EDITORS\FWE\FWE.EXE"'
	Setup0_Line.[87] = 'InputStem.Application.N_ED.NName.2 = "The OS/2 System Editor"'
	Setup0_Line.[88] = 'InputStem.Application.N_ED.PPath.2 = "E:\OS2\E.EXE"'
	Setup0_Line.[89] = 'InputStem.Application.N_ED.NName.3 = "Enhanced E Editor"'
	Setup0_Line.[90] = 'InputStem.Application.N_ED.PPath.3 = "C:\UTILITIES\TEXT_EDITORS\EEENHANCED_EDITOR\EE.EXE"'
	Setup0_Line.[91] = 'InputStem.Application.N_ED.NName.4 = "Enhanced EE Editor"'
	Setup0_Line.[92] = 'InputStem.Application.N_ED.PPath.4 = "C:\UTILITIES\TEXT_EDITORS\EEENHANCED_EDITOR\EEE.EXE"'
	Setup0_Line.[93] = 'InputStem.Application.N_ED.AAssociation_File_Type.1.1 = "ASCII"'
	Setup0_Line.[94] = 'InputStem.Application.N_ED.AAssociation_File_Filter.1.1 = ".TXT"'
	Setup0_Line.[95] = 'InputStem.Application.N_ED.AAssociation_File_Filter.1.2 = ""'
	Setup0_Line.[96] = 'InputStem.Application.N_ED.AAssociation_File_Filter.1.3 = ""'
	Setup0_Line.[97] = 'InputStem.Application.N_ED.AAssociation_File_Type.2.1 = "ASCII"'
	Setup0_Line.[98] = 'InputStem.Application.N_ED.AAssociation_File_Filter.2.1 = ".TXT"'
	Setup0_Line.[99] = 'InputStem.Application.N_ED.AAssociation_File_Filter.2.2 = ""'
	Setup0_Line.[100] = 'InputStem.Application.N_ED.AAssociation_File_Filter.2.3 = ""'
	Setup0_Line.[101] = 'InputStem.Application.N_ED.AAssociation_File_Type.3.1 = "ASCII"'
	Setup0_Line.[102] = 'InputStem.Application.N_ED.AAssociation_File_Filter.3.1 = ".TXT"'
	Setup0_Line.[103] = 'InputStem.Application.N_ED.AAssociation_File_Filter.3.2 = ""'
	Setup0_Line.[104] = 'InputStem.Application.N_ED.AAssociation_File_Filter.3.3 = ""'
	Setup0_Line.[105] = 'InputStem.Application.N_ED.AAssociation_File_Type.4.1 = "ASCII"'
	Setup0_Line.[106] = 'InputStem.Application.N_ED.AAssociation_File_Filter.4.1 = ".TXT"'
	Setup0_Line.[107] = 'InputStem.Application.N_ED.AAssociation_File_Filter.4.2 = ""'
	Setup0_Line.[108] = 'InputStem.Application.N_ED.AAssociation_File_Filter.4.3 = ""'
	Setup0_Line.[109] = 'InputStem.Application.N_ED.NName.0 = 4'
	Setup0_Line.[110] = '/*Section 3: End establishing data files for normally used text editors -  up to four (4) applications allowed*/'
	Setup0_Line.[111] = ''
	Setup0_Line.[112] = ''
	Setup0_Line.[113] = ''
	Setup0_Line.[114] = '/*Section 4: Begin establishing data files for REXX programming text editors -  up to two (2) applications allowed*/'
	Setup0_Line.[115] = 'REXX_TEXTEDITORS:'
	Setup0_Line.[116] = 'InputStem.Application.R_ED.NName.1 = "Future Wave Editor"'
	Setup0_Line.[117] = 'InputStem.Application.R_ED.PPath.1 = "C:\UTILITIES\TEXT_EDITORS\FWE\FWE.EXE"'
	Setup0_Line.[118] = 'InputStem.Application.R_ED.NName.2 = ""'
	Setup0_Line.[119] = 'InputStem.Application.R_ED.PPath.2 = ""'
	Setup0_Line.[120] = 'InputStem.Application.R_ED.AAssociation_File_Type.1.1 = "ASCII"'
	Setup0_Line.[121] = 'InputStem.Application.R_ED.AAssociation_File_Filter.1.1 = "*.CMD"'
	Setup0_Line.[122] = 'InputStem.Application.R_ED.AAssociation_File_Filter.1.2 = ""'
	Setup0_Line.[123] = 'InputStem.Application.R_ED.AAssociation_File_Filter.1.3 = ""'
	Setup0_Line.[124] = 'InputStem.Application.R_ED.AAssociation_File_Type.2.1 = ""'
	Setup0_Line.[125] = 'InputStem.Application.R_ED.AAssociation_File_Filter.2.1 = ""'
	Setup0_Line.[126] = 'InputStem.Application.R_ED.AAssociation_File_Filter.2.2 = ""'
	Setup0_Line.[127] = 'InputStem.Application.R_ED.AAssociation_File_Filter.2.3 = ""'
	Setup0_Line.[128] = 'InputStem.Application.R_ED.NName.0 = 1'
	Setup0_Line.[129] = '/*Section 4: End establishing data files for REXX programming text editors -  up to two (2) applications allowed*/'
	Setup0_Line.[130] = ''
	Setup0_Line.[131] = ''
	Setup0_Line.[132] = ''
	Setup0_Line.[133] = '/*Section 5: Begin establishing the data file for the LaTeX text editor - only one (1) application allowed*/'
	Setup0_Line.[134] = 'LATEX_TEXTEDITORS:'
	Setup0_Line.[135] = 'InputStem.Application.L_ED.NName.1 = "The OS/2 Enhanced Editor"'
	Setup0_Line.[136] = 'InputStem.Application.L_ED.PPath.1 = "C:\LaTeX\EmTexTDS\EPM_and_EPM_Front_End\EPM.EXE"'
	Setup0_Line.[137] = 'InputStem.Application.L_ED.AAssociation_File_Type.1.1 = "ASCII"'
	Setup0_Line.[138] = 'InputStem.Application.L_ED.AAssociation_File_Filter.1.1 = "*.TEX"'
	Setup0_Line.[139] = 'InputStem.Application.L_ED.AAssociation_File_Filter.1.2 = ""'
	Setup0_Line.[140] = 'InputStem.Application.L_ED.NName.0 = 0'
	Setup0_Line.[141] = '/*Section 5: End establishing the data file for the LaTeX text editor - only one (1) application allowed*/'
	Setup0_Line.[142] = ''
	Setup0_Line.[143] = ''
	Setup0_Line.[144] = ''
	Setup0_Line.[145] = '/*Section 6: Begin establishing the data file for running REXX programs (scripts) - up to two (2) applications*/'
	Setup0_Line.[146] = 'RUN_REXX:'
	Setup0_Line.[147] = 'InputStem.Application.R_R.NName.1 = "PM REXX"'
	Setup0_Line.[148] = 'InputStem.Application.R_R.PPath.1 = "E:\OS2\PMREXX.EXE"'
	Setup0_Line.[149] = 'InputStem.Application.R_R.NName.2 = "REXX CommandLine"'
	Setup0_Line.[150] = 'InputStem.Application.R_R.PPath.2 = Command_Processor_Path'
	Setup0_Line.[151] = 'InputStem.Application.R_R.AAssociation_File_Type.1.1 = "ASCII"'
	Setup0_Line.[152] = 'InputStem.Application.R_R.AAssociation_File_Filter.1.1 = "*.CMD"'
	Setup0_Line.[153] = 'InputStem.Application.R_R.AAssociation_File_Filter.1.2 = ""'
	Setup0_Line.[154] = 'InputStem.Application.R_R.AAssociation_File_Type.1.1 = "ASCII"'
	Setup0_Line.[155] = 'InputStem.Application.R_R.AAssociation_File_Filter.1.1 = "*.CMD"'
	Setup0_Line.[156] = 'InputStem.Application.R_R.AAssociation_File_Filter.1.2 = ""'
	Setup0_Line.[157] = 'InputStem.Application.R_R.NName.0 = 1'
	Setup0_Line.[158] = '/*Section 6: End establishing the  data file for running REXX programs (scripts)  - up to two (2) applications*/'
	Setup0_Line.[159] = ''
	Setup0_Line.[160] = ''
	Setup0_Line.[161] = ''
	Setup0_Line.[162] = '/*Section 7: Begin establishing the data file for the spreadsheet program - only one (1) application allowed*/'
	Setup0_Line.[163] = 'SPREADSHEETS:'
	Setup0_Line.[164] = 'InputStem.Application.SS.NName.1 = "Mesa 2"'
	Setup0_Line.[165] = 'InputStem.Application.SS.PPath.1 = "C:\Mesa2\Mesa2.exe"'
	Setup0_Line.[166] = 'InputStem.Application.SS.AAssociation_File_Type.1 = "Mesa Workbook File"'
	Setup0_Line.[167] = 'InputStem.Application.SS.AAssociation_File_Filter.1.1 = "*.M2"'
	Setup0_Line.[168] = 'InputStem.Application.SS.AAssociation_File_Filter.1.2 = "*.M2B"'
	Setup0_Line.[169] = 'InputStem.Application.SS.AAssociation_File_Filter.1.3 = ".M2T"'
	Setup0_Line.[170] = 'InputStem.Application.SS.NName.0 = 1'
	Setup0_Line.[171] = '/*Section 7: End establishing the data file for the spreadsheet program - only one (1) application allowed*/'
	Setup0_Line.[172] = ''
	Setup0_Line.[173] = ''
	Setup0_Line.[174] = ''
	Setup0_Line.[175] = '/*Section 8: Begin establishing the financial program data file - only one (1) application allowed*/'
	Setup0_Line.[176] = 'FINANCE:'
	Setup0_Line.[177] = 'InputStem.Application.FIN.NName.1 = ""'
	Setup0_Line.[178] = 'InputStem.Application.FIN.PPath.1 = ""'
	Setup0_Line.[179] = 'InputStem.Application.FIN.AAssociation_File_Filter.1.1 = ""'
	Setup0_Line.[180] = 'InputStem.Application.FIN.AAssociation_File_Filter.1.2 = ""'
	Setup0_Line.[181] = 'InputStem.Application.FIN.AAssociation_File_Filter.1.3 = ""'
	Setup0_Line.[182] = 'InputStem.Application.FIN.NName.0 = 0'
	Setup0_Line.[183] = '/*Section 8: End establishing the financial program data file - only one (1) application allowed*/'
	Setup0_Line.[184] = ''
	Setup0_Line.[185] = ''
	Setup0_Line.[186] = ''
	Setup0_Line.[187] = '/*Section 9: Begin establishing the web brower data files - up to two (2) applications allowed*/'
	Setup0_Line.[188] = 'WEB_BROWERS:'
	Setup0_Line.[189] = 'InputStem.Application.WB.NName.1 = "Mozilla"'
	Setup0_Line.[190] = 'InputStem.Application.WB.PPath.1 = "C:\NETWORK\MOZILLA\MOZILLA_1.76\MOZILLA.EXE"'
	Setup0_Line.[191] = 'InputStem.Application.WB.NName.2 = "Netscape"'
	Setup0_Line.[192] = 'InputStem.Application.WB.PPath.2 = "C:\Network\Netscape\PROGRAM\NETSCAPE.EXE"'
	Setup0_Line.[193] = 'InputStem.Application.WB.AAssociation_File_Type.1 = ""'
	Setup0_Line.[194] = 'InputStem.Application.WB.AAssociation_File_Filter.1.1 = "*.HTM"'
	Setup0_Line.[195] = 'InputStem.Application.WB.AAssociation_File_Filter.1.2 = "*.HTML"'
	Setup0_Line.[196] = 'InputStem.Application.WB.AAssociation_File_Filter.1.3 = "*.XMTL"'
	Setup0_Line.[197] = 'InputStem.Application.WB.AAssociation_File_Type.2 = ""'
	Setup0_Line.[198] = 'InputStem.Application.WB.AAssociation_File_Filter.2.1 = "*.HTM"'
	Setup0_Line.[199] = 'InputStem.Application.WB.AAssociation_File_Filter.2.2 = "*.HTML"'
	Setup0_Line.[200] = 'InputStem.Application.WB.AAssociation_File_Filter.2.3 = "*.XMTL"'
	Setup0_Line.[201] = 'InputStem.Application.WB.NName.0 = 2'
	Setup0_Line.[202] = '/*Section 9: End establishing the web brower data files - up to two (2) applications allowed*/'
	Setup0_Line.[203] = ''
	Setup0_Line.[204] = ''
	Setup0_Line.[205] = ''
	Setup0_Line.[206] = '/*Section 10: Begin establishing the data files for the *.PDF file reader -  up to three (3) applications allowed*/'
	Setup0_Line.[207] = 'PDF_READERS:'
	Setup0_Line.[208] = 'InputStem.Application.PDF.NName.1 = "Acrobat 5"'
	Setup0_Line.[209] = 'InputStem.Application.PDF.PPath.1 = "C:\Acrobat\AcrobatReader51Pre1\ar5os2.exe"'
	Setup0_Line.[210] = 'InputStem.Application.PDF.NName.2 = "Acrobat 4.05"'
	Setup0_Line.[211] = 'InputStem.Application.PDF.PPath.2 = "C:\Acrobat\AcrobatReader405\aros2.exe"'
	Setup0_Line.[212] = 'InputStem.Application.PDF.NName.3 = "Acrobat 3"'
	Setup0_Line.[213] = 'InputStem.Application.PDF.PPath.3 = "C:\Acrobat\Acrobat3\ReadOS2\acroread.exe"'
	Setup0_Line.[214] = 'InputStem.Application.PDF.AAssociation_File_Type.1 = "Acrobat Document"'
	Setup0_Line.[215] = 'InputStem.Application.PDF.AAssociation_File_Filter.1.1 = "*.PDF"'
	Setup0_Line.[216] = 'InputStem.Application.PDF.AAssociation_File_Filter.1.2 = ""'
	Setup0_Line.[217] = 'InputStem.Application.PDF.AAssociation_File_Filter.1.3 = ""'
	Setup0_Line.[218] = 'InputStem.Application.PDF.AAssociation_File_Type.2 = ""'
	Setup0_Line.[219] = 'InputStem.Application.PDF.AAssociation_File_Filter.2.1 = "Acrobat Document"'
	Setup0_Line.[220] = 'InputStem.Application.PDF.AAssociation_File_Filter.2.2 = "*.PDF"'
	Setup0_Line.[221] = 'InputStem.Application.PDF.AAssociation_File_Filter.2.3 = ""'
	Setup0_Line.[222] = 'InputStem.Application.PDF.AAssociation_File_Type.3 = ""'
	Setup0_Line.[223] = 'InputStem.Application.PDF.AAssociation_File_Filter.3.1 = "Acrobat Document"'
	Setup0_Line.[224] = 'InputStem.Application.PDF.AAssociation_File_Filter.3.2 = "*.PDF"'
	Setup0_Line.[225] = 'InputStem.Application.PDF.AAssociation_File_Filter.3.3 = ""'
	Setup0_Line.[226] = 'InputStem.Application.PDF.NName.0 = 1'
	Setup0_Line.[227] = '/*Section 10: End establishing the data files for the *.PDF file reader -  up to three (3) application allowed*/'
	Setup0_Line.[228] = ''
	Setup0_Line.[229] = ''
	Setup0_Line.[230] = ''
	Setup0_Line.[231] = '/*Section 11: Begin establishing the data files for the *.PS and *.EPS file reader - only one (1) application allowed*/'
	Setup0_Line.[232] = 'PS_EPS_READER:'
	Setup0_Line.[233] = 'InputStem.Application.PS.NName.1 = "GSView"'
	Setup0_Line.[234] = 'InputStem.Application.PS.PPath.1 = "C:\GhstView\gsview2\gvpm.exe"'
	Setup0_Line.[235] = 'InputStem.Application.PS.AAssociation_File_Type.1 = ""'
	Setup0_Line.[236] = 'InputStem.Application.PS.AAssociation_File_Filter.1.1 = "*.PS"'
	Setup0_Line.[237] = 'InputStem.Application.PS.AAssociation_File_Filter.1.2 = "*.EPS"'
	Setup0_Line.[238] = 'InputStem.Application.PS.AAssociation_File_Filter.1.3 = ""'
	Setup0_Line.[239] = 'InputStem.Application.PS.NName.0 = 1'
	Setup0_Line.[240] = '/*Section 11: End establishing the data files for the *.PS and *.EPS file reader - only one (1) application allowed*/'
	Setup0_Line.[241] = ''
	Setup0_Line.[242] = ''
	Setup0_Line.[243] = '/*Section 12: Begin establishing the data files for the graphics file reader - only one (1) application allowed*/'
	Setup0_Line.[244] = 'GRAPHICS:'
	Setup0_Line.[245] = 'InputStem.Application.GRAPHICS.NName.1 = "PM View Pro"'
	Setup0_Line.[246] = 'InputStem.Application.GRAPHICS.PPath.1 = "C:\Graphics\PMVIEW\pmview.exe"'
	Setup0_Line.[247] = 'InputStem.Application.GRAPHICS.AAssociation_File_Type.1 = ""'
	Setup0_Line.[248] = 'InputStem.Application.GRAPHICS.AAssociation_File_Filter.1.1 = "*.BMP"'
	Setup0_Line.[249] = 'InputStem.Application.GRAPHICS.AAssociation_File_Filter.1.2 = "*.CUR"'
	Setup0_Line.[250] = 'InputStem.Application.GRAPHICS.AAssociation_File_Filter.1.3 = "*.DCX"'
	Setup0_Line.[251] = 'InputStem.Application.GRAPHICS.AAssociation_File_Filter.1.4 = "*.EPS"'
	Setup0_Line.[252] = 'InputStem.Application.GRAPHICS.AAssociation_File_Filter.1.5 = "*.FIT"'
	Setup0_Line.[253] = 'InputStem.Application.GRAPHICS.AAssociation_File_Filter.1.6 = "*.G3"'
	Setup0_Line.[254] = 'InputStem.Application.GRAPHICS.AAssociation_File_Filter.1.7 = "*.GIF"'
	Setup0_Line.[255] = 'InputStem.Application.GRAPHICS.AAssociation_File_Filter.1.8 = "*.ICO"'
	Setup0_Line.[256] = 'InputStem.Application.GRAPHICS.AAssociation_File_Filter.1.9 = "*.IFF"'
	Setup0_Line.[257] = 'InputStem.Application.GRAPHICS.AAssociation_File_Filter.1.10 = "*.ILBM"'
	Setup0_Line.[258] = 'InputStem.Application.GRAPHICS.AAssociation_File_Filter.1.11 = "*.IMG"'
	Setup0_Line.[259] = 'InputStem.Application.GRAPHICS.AAssociation_File_Filter.1.12 = "*.JPG"'
	Setup0_Line.[260] = 'InputStem.Application.GRAPHICS.AAssociation_File_Filter.1.13 = "*.JPEG"'
	Setup0_Line.[261] = 'InputStem.Application.GRAPHICS.AAssociation_File_Filter.1.14 = "*.JIF"'
	Setup0_Line.[262] = 'InputStem.Application.GRAPHICS.AAssociation_File_Filter.1.15 = "*.JFIF"'
	Setup0_Line.[263] = 'InputStem.Application.GRAPHICS.AAssociation_File_Filter.1.16 = "*.LGO"'
	Setup0_Line.[264] = 'InputStem.Application.GRAPHICS.AAssociation_File_Filter.1.17 = "*.MAC"'
	Setup0_Line.[265] = 'InputStem.Application.GRAPHICS.AAssociation_File_Filter.1.18 = "*.MSP"'
	Setup0_Line.[266] = 'InputStem.Application.GRAPHICS.AAssociation_File_Filter.1.19 = "*.PCD"'
	Setup0_Line.[267] = 'InputStem.Application.GRAPHICS.AAssociation_File_Filter.1.20 = "*.PCX"'
	Setup0_Line.[268] = 'InputStem.Application.GRAPHICS.AAssociation_File_Filter.1.21 = "*.PIC"'
	Setup0_Line.[269] = 'InputStem.Application.GRAPHICS.AAssociation_File_Filter.1.22 = "*.PBM"'
	Setup0_Line.[270] = 'InputStem.Application.GRAPHICS.AAssociation_File_Filter.1.23 = "*.PGM"'
	Setup0_Line.[271] = 'InputStem.Application.GRAPHICS.AAssociation_File_Filter.1.24 = "*.PPM"'
	Setup0_Line.[272] = 'InputStem.Application.GRAPHICS.AAssociation_File_Filter.1.25 = "*.PNM"'
	Setup0_Line.[273] = 'InputStem.Application.GRAPHICS.AAssociation_File_Filter.1.26 = "*.PNG"'
	Setup0_Line.[274] = 'InputStem.Application.GRAPHICS.AAssociation_File_Filter.1.27 = "*.PSD"'
	Setup0_Line.[275] = 'InputStem.Application.GRAPHICS.AAssociation_File_Filter.1.28 = "*.PTR"'
	Setup0_Line.[276] = 'InputStem.Application.GRAPHICS.AAssociation_File_Filter.1.29 = "*.RAS"'
	Setup0_Line.[277] = 'InputStem.Application.GRAPHICS.AAssociation_File_Filter.1.30 = "*.RLE"'
	Setup0_Line.[278] = 'InputStem.Application.GRAPHICS.AAssociation_File_Filter.1.31 = "*.SFF"'
	Setup0_Line.[279] = 'InputStem.Application.GRAPHICS.AAssociation_File_Filter.1.32 = "*.SFW"'
	Setup0_Line.[280] = 'InputStem.Application.GRAPHICS.AAssociation_File_Filter.1.33 = "*.SGI"'
	Setup0_Line.[281] = 'InputStem.Application.GRAPHICS.AAssociation_File_Filter.1.34 = "*.SHW"'
	Setup0_Line.[282] = 'InputStem.Application.GRAPHICS.AAssociation_File_Filter.1.35 = "*.TGA"'
	Setup0_Line.[283] = 'InputStem.Application.GRAPHICS.AAssociation_File_Filter.1.36 = "*.TIF"'
	Setup0_Line.[284] = 'InputStem.Application.GRAPHICS.AAssociation_File_Filter.1.37 = "*.TIFF"'
	Setup0_Line.[285] = 'InputStem.Application.GRAPHICS.AAssociation_File_Filter.1.38 = "*.WBMP"'
	Setup0_Line.[286] = 'InputStem.Application.GRAPHICS.AAssociation_File_Filter.1.39 = "*.WPG"'
	Setup0_Line.[287] = 'InputStem.Application.GRAPHICS.AAssociation_File_Filter.1.40 = "*.XBM"'
	Setup0_Line.[288] = 'InputStem.Application.GRAPHICS.AAssociation_File_Filter.1.41 = "*.XPM"'
	Setup0_Line.[289] = 'InputStem.Application.GRAPHICS.AAssociation_File_Filter.1.42 = "*.XWD"'
	Setup0_Line.[290] = 'InputStem.Application.GRAPHICS.AAssociation_File_Filter.1.43 = ""'
	Setup0_Line.[291] = 'InputStem.Application.GRAPHICS.AAssociation_File_Filter.1.44 = ""'
	Setup0_Line.[292] = 'InputStem.Application.GRAPHICS.AAssociation_File_Filter.1.45 = ""'
	Setup0_Line.[293] = 'InputStem.Application.GRAPHICS.AAssociation_File_Filter.1.46 = ""'
	Setup0_Line.[294] = 'InputStem.Application.GRAPHICS.AAssociation_File_Filter.1.47 = ""'
	Setup0_Line.[295] = 'InputStem.Application.GRAPHICS.AAssociation_File_Filter.1.48 = ""'
	Setup0_Line.[296] = 'InputStem.Application.GRAPHICS.AAssociation_File_Filter.1.49 = ""'
	Setup0_Line.[297] = 'InputStem.Application.GRAPHICS.AAssociation_File_Filter.1.50 = ""'
	Setup0_Line.[298] = 'InputStem.Application.GRAPHICS.NName.0 = 1'
	Setup0_Line.[299] = '/*Section 12: End establishing the  data files for the graphics file reader - only one (1) application allowed*/'
	Setup0_Line.[300] = ''
	Setup0_Line.[301] = ''
	Setup0_Line.[302] = ''
	Setup0_Line.[303] = '/*Section 13: Begin establishing the drafting, or CAD, data file - only one (1) application allowed*/'
	Setup0_Line.[304] = 'CAD:'
	Setup0_Line.[305] = 'InputStem.Application.DRAFTING.NName.1 = "BlueCAD"'
	Setup0_Line.[306] = 'InputStem.Application.DRAFTING.PPath.1 = "C:\Graphics\BLUECAD\PRGM\BlueCAD.exe"'
	Setup0_Line.[307] = 'InputStem.Application.DRAFTING.AAssociation_File_Type.1 = ""'
	Setup0_Line.[308] = 'InputStem.Application.DRAFTING.AAssociation_File_Filter.1.1 = "*.DIS"'
	Setup0_Line.[309] = 'InputStem.Application.DRAFTING.AAssociation_File_Filter.1.2 = ""'
	Setup0_Line.[310] = 'InputStem.Application.DRAFTING.AAssociation_File_Filter.1.3 = ""'
	Setup0_Line.[311] = 'InputStem.Application.DRAFTING.NName.0 = 1'
	Setup0_Line.[312] = '/*Section 13: End establishing the drafting, or CAD, data file - only one (1) application allowed*/'
	Setup0_Line.[313] = ''
	Setup0_Line.[314] = ''
	Setup0_Line.[315] = ''
	Setup0_Line.[316] = '/*Section 14: Begin establishing data files for user defined file associations N 1 - up to twenty (20) applications allowed*/'
	Setup0_Line.[317] = 'USER_DEFINED:'
	Setup0_Line.[318] = 'InputStem.Application.USER_DEFINED.NName.1 = ""'
	Setup0_Line.[319] = 'InputStem.Application.USER_DEFINED.PPath.1 = ""'
	Setup0_Line.[320] = 'InputStem.Application.USER_DEFINED.NName.2 = ""'
	Setup0_Line.[321] = 'InputStem.Application.USER_DEFINED.PPath.2 = ""'
	Setup0_Line.[322] = 'InputStem.Application.USER_DEFINED.NName.3 = ""'
	Setup0_Line.[323] = 'InputStem.Application.USER_DEFINED.PPath.3 = ""'
	Setup0_Line.[324] = 'InputStem.Application.USER_DEFINED.NName.4 = ""'
	Setup0_Line.[325] = 'InputStem.Application.USER_DEFINED.PPath.4 = ""'
	Setup0_Line.[326] = 'InputStem.Application.USER_DEFINED.NName.5 = ""'
	Setup0_Line.[327] = 'InputStem.Application.USER_DEFINED.PPath.5 = ""'
	Setup0_Line.[328] = 'InputStem.Application.USER_DEFINED.NName.6 = ""'
	Setup0_Line.[329] = 'InputStem.Application.USER_DEFINED.PPath.6 = ""'
	Setup0_Line.[330] = 'InputStem.Application.USER_DEFINED.NName.7 = ""'
	Setup0_Line.[331] = 'InputStem.Application.USER_DEFINED.PPath.7 = ""'
	Setup0_Line.[332] = 'InputStem.Application.USER_DEFINED.NName.8 = ""'
	Setup0_Line.[333] = 'InputStem.Application.USER_DEFINED.PPath.8 = ""'
	Setup0_Line.[334] = 'InputStem.Application.USER_DEFINED.NName.9 = ""'
	Setup0_Line.[335] = 'InputStem.Application.USER_DEFINED.PPath.9 = ""'
	Setup0_Line.[336] = 'InputStem.Application.USER_DEFINED.NName.10 = ""'
	Setup0_Line.[337] = 'InputStem.Application.USER_DEFINED.PPath.10 = ""'
	Setup0_Line.[338] = 'InputStem.Application.USER_DEFINED.NName.11 = ""'
	Setup0_Line.[339] = 'InputStem.Application.USER_DEFINED.PPath.11 = ""'
	Setup0_Line.[340] = 'InputStem.Application.USER_DEFINED.NName.12 = ""'
	Setup0_Line.[341] = 'InputStem.Application.USER_DEFINED.PPath.12 = ""'
	Setup0_Line.[342] = 'InputStem.Application.USER_DEFINED.NName.13 = ""'
	Setup0_Line.[343] = 'InputStem.Application.USER_DEFINED.PPath.13 = ""'
	Setup0_Line.[344] = 'InputStem.Application.USER_DEFINED.NName.14 = ""'
	Setup0_Line.[345] = 'InputStem.Application.USER_DEFINED.PPath.14 = ""'
	Setup0_Line.[346] = 'InputStem.Application.USER_DEFINED.NName.15 = ""'
	Setup0_Line.[347] = 'InputStem.Application.USER_DEFINED.PPath.15 = ""'
	Setup0_Line.[348] = 'InputStem.Application.USER_DEFINED.NName.16 = ""'
	Setup0_Line.[349] = 'InputStem.Application.USER_DEFINED.PPath.16 = ""'
	Setup0_Line.[350] = 'InputStem.Application.USER_DEFINED.NName.17 = ""'
	Setup0_Line.[351] = 'InputStem.Application.USER_DEFINED.PPath.17 = ""'
	Setup0_Line.[352] = 'InputStem.Application.USER_DEFINED.NName.18 = ""'
	Setup0_Line.[353] = 'InputStem.Application.USER_DEFINED.PPath.18 = ""'
	Setup0_Line.[354] = 'InputStem.Application.USER_DEFINED.NName.19 = ""'
	Setup0_Line.[355] = 'InputStem.Application.USER_DEFINED.PPath.19 = ""'
	Setup0_Line.[356] = 'InputStem.Application.USER_DEFINED.NName.20 = ""'
	Setup0_Line.[357] = 'InputStem.Application.USER_DEFINED.PPath.20 = ""'
	Setup0_Line.[358] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Type.1 = ""'
	Setup0_Line.[359] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Filter.1.1 = ""'
	Setup0_Line.[360] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Filter.1.2 = ""'
	Setup0_Line.[361] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Filter.1.3 = ""'
	Setup0_Line.[362] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Type.2 = ""'
	Setup0_Line.[363] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Filter.2.1 = ""'
	Setup0_Line.[364] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Filter.2.2 = ""'
	Setup0_Line.[365] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Filter.2.3 = ""'
	Setup0_Line.[366] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Type.3 = ""'
	Setup0_Line.[367] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Filter.3.1 = ""'
	Setup0_Line.[368] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Filter.3.2 = ""'
	Setup0_Line.[369] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Filter.3.3 = ""'
	Setup0_Line.[370] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Type.4 = ""'
	Setup0_Line.[371] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Filter.4.1 = ""'
	Setup0_Line.[372] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Filter.4.2 = ""'
	Setup0_Line.[373] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Filter.4.3 = ""'
	Setup0_Line.[374] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Type.5 = ""'
	Setup0_Line.[375] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Filter.5.1 = ""'
	Setup0_Line.[376] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Filter.5.2 = ""'
	Setup0_Line.[377] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Filter.5.3 = ""'
	Setup0_Line.[378] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Type.6 = ""'
	Setup0_Line.[379] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Filter.6.1 = ""'
	Setup0_Line.[380] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Filter.6.2 = ""'
	Setup0_Line.[381] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Filter.6.3 = ""'
	Setup0_Line.[382] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Type.7 = ""'
	Setup0_Line.[383] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Filter.7.1 = ""'
	Setup0_Line.[384] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Filter.7.2 = ""'
	Setup0_Line.[385] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Filter.7.3 = ""'
	Setup0_Line.[386] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Type.8 = ""'
	Setup0_Line.[387] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Filter.8.1 = ""'
	Setup0_Line.[388] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Filter.8.2 = ""'
	Setup0_Line.[389] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Filter.8.3 = ""'
	Setup0_Line.[390] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Type.9 = ""'
	Setup0_Line.[391] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Filter.3.1 = ""'
	Setup0_Line.[392] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Filter.9.2 = ""'
	Setup0_Line.[393] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Filter.9.3 = ""'
	Setup0_Line.[394] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Type.10 = ""'
	Setup0_Line.[395] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Filter.10.1 = ""'
	Setup0_Line.[396] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Filter.10.2 = ""'
	Setup0_Line.[397] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Filter.10.3 = ""'
	Setup0_Line.[398] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Type.11 = ""'
	Setup0_Line.[399] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Filter.11.1 = ""'
	Setup0_Line.[400] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Filter.11.2 = ""'
	Setup0_Line.[401] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Filter.11.3 = ""'
	Setup0_Line.[402] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Type.12 = ""'
	Setup0_Line.[403] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Filter.12.1 = ""'
	Setup0_Line.[404] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Filter.12.2 = ""'
	Setup0_Line.[405] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Filter.12.3 = ""'
	Setup0_Line.[406] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Type.13 = ""'
	Setup0_Line.[407] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Filter.13.1 = ""'
	Setup0_Line.[408] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Filter.13.2 = ""'
	Setup0_Line.[409] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Filter.13.3 = ""'
	Setup0_Line.[410] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Type.14 = ""'
	Setup0_Line.[411] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Filter.14.1 = ""'
	Setup0_Line.[412] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Filter.14.2 = ""'
	Setup0_Line.[413] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Filter.14.3 = ""'
	Setup0_Line.[414] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Type.15 = ""'
	Setup0_Line.[415] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Filter.15.1 = ""'
	Setup0_Line.[416] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Filter.15.2 = ""'
	Setup0_Line.[417] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Filter.15.3 = ""'
	Setup0_Line.[418] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Type.16 = ""'
	Setup0_Line.[419] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Filter.16.1 = ""'
	Setup0_Line.[420] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Filter.16.2 = ""'
	Setup0_Line.[421] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Filter.16.3 = ""'
	Setup0_Line.[422] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Type.17 = ""'
	Setup0_Line.[423] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Filter.17.1 = ""'
	Setup0_Line.[424] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Filter.17.2 = ""'
	Setup0_Line.[425] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Filter.17.3 = ""'
	Setup0_Line.[426] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Type.18 = ""'
	Setup0_Line.[427] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Filter.18.1 = ""'
	Setup0_Line.[428] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Filter.18.2 = ""'
	Setup0_Line.[429] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Filter.18.3 = ""'
	Setup0_Line.[430] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Type.19 = ""'
	Setup0_Line.[431] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Filter.13.1 = ""'
	Setup0_Line.[432] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Filter.19.2 = ""'
	Setup0_Line.[433] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Filter.19.3 = ""'
	Setup0_Line.[434] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Type.20 = ""'
	Setup0_Line.[435] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Filter.20.1 = ""'
	Setup0_Line.[436] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Filter.20.2 = ""'
	Setup0_Line.[437] = 'InputStem.Application.USER_DEFINED.AAssociation_File_Filter.20.3 = ""'
	Setup0_Line.[438] = 'InputStem.Application.USER_DEFINED.NName.0 = 0'
	Setup0_Line.[439] = '/*Section 14: End establishing data files for user defined file associations  - up to twenty (20) applications allowed*/'
	Setup0_Line.[440] = '/*Sections 2 through 14: End setting up and the user file associations for applications (programs) used on this computer*/'
	Setup0_Line.[441] = ''
	Setup0_Line.[442] = ''
	Setup0_Line.[443] = ''
	Setup0_Line.[444] = '/*Section 15: Begin setting the two (2) variables for using, or not using the REXX Library (REXXLIB) and REXXEA)*/'
	Setup0_Line.[445] = 'SEEK uses the following three (3) facilities to provide extended attributes (EA) search capabilities:'
	Setup0_Line.[446] = ''
	Setup0_Line.[447] = '	1.	The SYSGETEA funtion within the REXX Utilities (the REXX Utilities are part of the REXX package included in OS/2 or ECS).'
	Setup0_Line.[448] = '	2.	The DOSEALIST() function from the REXX Library (REXXLIB) by Quercus Systems.'
	Setup0_Line.[449] = '	3.	The FETCHEA() function from REXXEA, Ammonoosuc Technology, Inc., 131 Ridge Road, Franconia, New Hampshire 03580.'
	Setup0_Line.[450] = ''
	Setup0_Line.[451] = 'No one facility by itself provides a complete source for finding the EA. Nevertheless, if you do not have one or both of the REXXLIB and REXXEA'
	Setup0_Line.[452] = 'installed on your system, you can have SEEK use the REXX Utilities and which ever other facility, REXXLIB or REXXEA, if any, installed. I recommend that SEEK use REXXLIB and/or REXXEA, if'
	Setup0_Line.[453] = 'one or both is installed on your system.'
	Setup0_Line.[454] = ''
	Setup0_Line.[455] = 'Please set the the two (2) variables for using, or not using REXXLIB and REXXEA, below. Replace the "?" with an "equal sign" (ASCII control sequence 61) on the "YES" or "NO" selection of choice.'
	Setup0_Line.[456] = 'InputStem.Use_REXXLIB?"YES"'
	Setup0_Line.[457] = 'InputStem.Use_REXXLIB?"NO"'
	Setup0_Line.[458] = 'InputStem.Use_REXXEA?"YES"'
	Setup0_Line.[459] = 'InputStem.Use_REXXEA?"NO"'
	Setup0_Line.[460] = ''
	Setup0_Line.[461] = 'InputStem.Use_REXXLIB = "YES"'
	Setup0_Line.[462] = 'InputStem.Use_REXXEA = "YES"'
	Setup0_Line.[463] = '/*Section 15: End setting the two (2) variables for using, or not using the REXX Library (REXXLIB) and REXXEA)*/'
	Setup0_Line.[0] = 463
	RETURN O

::METHOD FIND_STREAM CLASS
	USE ARG File, Location, Msg.
	Flag = 0
	Path = Location"\"File
	StreamName = .STREAM~NEW(Path)
	RC = StreamName~QUERY("EXISTS")
	IF RC = .NIL | RC = "" THEN DO
		Flag = 1
		Msg.[1] = 'Sorry, the "'File'" ASCII file does not exist, or does not reside, in the following folder:'
		Msg.[2] = '     '
		Msg.[3] = '    'Location
		Msg.[4] = '     '
		Msg.[5] = 'This file is necessary for the execution of this VisProREXX program. It lists the setup infor-'
		Msg.[6] = 'mation for the program.'
		Msg.[7] = '     '
		Msg.[8] = 'A template, called "'File'0", has now been created for you and placed in the'
		Msg.[9] = '     '
		Msg.[10] = '     'Location
		Msg.[11] = '     '
		Msg.[12] = 'folder. It contains sample information, which should enable you to properly reconstruct the'
		Msg.[13] = '"'File'" file for this REXX program.'
		Msg.[14] = '     '
		Msg.[15] = 'Please consult "'File'0". Then, reconstruct the "'File'" ASCII file  and save it in the'
		Msg.[16] = '     '
		Msg.[17] = '     'Location
		Msg.[18] = '     '
		Msg.[19] = 'folder.'
		Msg.[20] = '     '
		Msg.[21] = 'Finally, restart this program.'
		Msg.[22] = '     '
		Msg.[23] ='Press the '"CANCEL"' button now (below) to end the program and begin the reconstruction.'
		Msg.[0] = 23
	END	/*Ends "WHEN RC = .NIL | RC = "" THEN DO" Section*/
	RETURN Flag

::METHOD FIND_FILE_ASSOCIATIONS CLASS
	USE ARG InputStem., OtherServicesFilePath., ScanFilePathResults., ScanLineResults., Command_Processor_Path
	OutputStem. = .STEM~NEW
	Start = 1
	DO I = 1 TO OtherServicesFilePath.0 BY 1
		OutputStem.I.1 = ""
		OutputStem.I.2 = ""
		DO J = Start TO ScanFilePathResults.0 BY 1
			IF TRANSLATE(ScanFilePathResults.J) = TRANSLATE(OtherServicesFilePath.I) THEN DO
				DO K = 1 TO InputStem.File_Type.0.0 BY 1
					IF InputStem.File_Type.K.1 = "" THEN ITERATE
					DO L = 1 TO ScanLineResults.J.0 BY 1
						IF POS(TRANSLATE(InputStem.File_Type.K.1), TRANSLATE(ScanLineResults.J.L), 1) > 0 THEN DO
							IF InputStem.File_Type.K.2 = Command_Processor_Path THEN OutputStem.I.1 = OtherServicesFilePath.I	/*Different way to start OS/2 command processor and use it for running REXX programs*/
							ELSE OutputStem.I.1 = InputStem.File_Type.K.2
							CALL FIND_FILE_ASSOCIATIONS_2
							ITERATE I
						END	/*Ends "IF POS(TRANSLATE(InputStem.File_Type.K.1), TRANSLATE(ScanLineResults.J.L), 1) > 0 THEN DO" Section*/
					END L	/*Ends "DO L = 1 TO ScanLineResults.J.0 BY 1" Section*/
				END K	/*Ends "DO K = 1 TO InputStem.File_Type.0.0 BY 1" Section*/
				Start = J + 1
			END	/*Ends "IF TRANSLATE(ScanFilePathResults.J) = TRANSLATE(OtherServicesFilePath.I) THEN DO" Section*/
		END J	/*Ends "DO J = Start TO ScanFilePathResults.0 BY 1" Section*/
		IF OutputStem.I.1 = "" THEN DO
			Question = "FALSE"
			Test_Start = 1
			Prior_Test_Start = 1
			Prior_Test_Result = 0
			DO UNTIL Question = "TRUE"
				Test_Result = POS(".", OtherServicesFilePath.I, Test_Start)
				SELECT
					WHEN Test_Result = 0 THEN Question = "TRUE"

					WHEN Test_Result > 0 THEN DO
						IF Test_Result < LENGTH(OtherServicesFilePath.I) THEN DO
							Prior_Test_Result = Test_Result
							Test_Start = Test_Result + 1
						END	/*Ends "IF Test_Result < LENGTH(OtherServicesFilePath.I) THEN DO" Section*/
						ELSE DO
							Question = "TRUE"
							Prior_Test_Start = 1
						END	/*Ends "ELSE DO" Section*/
					END	/*Ends "WHEN Test_Result > 0 THEN DO" Section*/

					OTHERWISE NOP
				END	/*Ends "SELECT" Section*/
			END	/*Ends "DO UNTIL Question = "TRUE"" Section*/
			IF Prior_Test_Result > 1 THEN DO
				Test_Start = Prior_Test_Result + 1
				Desired_Length = LENGTH(OtherServicesFilePath.I) - Test_Start + 1
				File_Extension = SUBSTR(OtherServicesFilePath.I, Test_Start,Desired_Length)
				DO M = 1 TO InputStem.File_Filter.0.0 BY 1
					IF InputStem.File_Filter.M.1 = "" THEN ITERATE
					IF POS(TRANSLATE(File_Extension), TRANSLATE(InputStem.File_Filter.M.1), 1) > 0 THEN DO
						IF InputStem.File_Type.K.2 = Command_Processor_Path THEN OutputStem.I.1 = OtherServicesFilePath.I	/*Different way to start OS/2 command processor and use it for running REXX programs*/
						ELSE OutputStem.I.1 = InputStem.File_Filter.M.2
						CALL FIND_FILE_ASSOCIATIONS_2
						LEAVE M
					END	/*Ends "IF POS(TRANSLATE(File_Extension), TRANSLATE(InputStem.File_Filter.M.1), 1) > 0 THEN DO" Section*/
				END	/*Ends "DO M = 1 TO InputStem.File_Filter.0.0 BY 1" Section*/
			END	/*Ends "IF Prior_Test_Result > 1 THEN DO" Section*/
		END	/*Ends "IF OutputStem.I.1 = "" THEN DO" Section*/
	END I	/*Ends "DO I = 1 TO OtherServicesFilePath.0 BY 1" Section*/
	OutputStem.0.0 = OtherServicesFilePath.0
	RETURN OutputStem.

	FIND_FILE_ASSOCIATIONS_2:
	Test_Position = 1
	Test_Start = 1
	DO UNTIL Test_Position = 0
		Test_Position = POS("\", OutputStem.I.1, Test_Start)
		IF Test_Position > 0 THEN DO
			Prior_Test_Position = Test_Position
			Test_Start = Test_Position + 1
			OutputStem.I.2 = SUBSTR(OutputStem.I.1, 1, (Test_Position - 1))
		END	/*Ends "IF Test_Position > 0 THEN DO" Section*/
	END	/*Ends "DO UNTIL Test_Position = 0" Section*/
	DesiredLength = LENGTH(OutputStem.I.1) - Prior_Test_Position
	OutputStem.I.1 = SUBSTR(OutputStem.I.1, (Prior_Test_Position + 1), DesiredLength)
	RETURN

::METHOD FIND_MANUAL_ASSOCIATION CLASS
	USE ARG InputStem., App_Path, IIndex
	Test_Position = 1
	Test_Start = 1
	DO UNTIL Test_Position = 0
		Test_Position = POS("\", App_Path, Test_Start)
		IF Test_Position > 0 THEN DO
			Prior_Test_Position = Test_Position
			Test_Start = Test_Position + 1
			InputStem.IIndex.2 = SUBSTR(App_Path, 1, (Test_Position - 1))
		END	/*Ends "IF Test_Position > 0 THEN DO" Section*/
	END	/*Ends "DO UNTIL Test_Position = 0" Section*/
	DesiredLength = LENGTH(App_Path) - Prior_Test_Position
	InputStem.IIndex.1 = SUBSTR(App_Path, (Prior_Test_Position + 1), DesiredLength)
	RETURN 0





::CLASS IO
::METHOD READ_DATA CLASS	/*Reads the lines in an ASCII file, supplied by the path information in the variable, ReadFile. Outputs that result to a stem variable, ReadFile_Lines.*/
	USE ARG ReadFile
	ReadFile_Lines. = .DTTOOLS~STEM_INIT("")
	I = 0
	DO WHILE LINES(ReadFile)
		I = I + 1
		ReadFile_Lines.I = LINEIN(ReadFile)
	END	/*Ends "DO WHILE LINES(ReadFile)" Section*/
	ReadFile_Lines.0 = I
	RC = LINEOUT(ReadFile)
	RETURN ReadFile_Lines.

::METHOD READ_DATA_1 CLASS	/*Reads the lines in an ASCII file, supplied by the path information in the variable, ReadFile. Removes any blank lines and outputs that result to a stem variable, ReadFile_Lines.*/
	USE ARG ReadFile
	ReadFile_Lines. = .DTTOOLS~STEM_INIT("")
	I = 0
	DO WHILE LINES(ReadFile)
		TestReadLine = LINEIN(ReadFile)
		IF TestReadLine \= "" THEN DO
			I = I + 1
			ReadFile_Lines.I = TestReadLine
		END	/*Ends "IF TestReadLine \= "" THEN DO" Section*/
	END	/*Ends "DO WHILE LINES(ReadFile)" Section*/
	ReadFile_Lines.0 = I
	RC = LINEOUT(ReadFile)
	RETURN ReadFile_Lines.

::METHOD READ_DATA_2 CLASS	/*Reads the lines in an ASCII file, supplied by the path information in the variable, ReadFile. Removes any lines that do not contain the desired "Needle1" or "Needle2" within the "Haystack" and outputs the result to a stem variable, ReadFile_Lines.*/
	USE ARG ReadFile, Needle1, Needle2
	ReadFile_Lines. = .DTTOOLS~STEM_INIT("")
	I = 0
	DO WHILE LINES(ReadFile)
		Haystack = LINEIN(ReadFile)
		IF POS(Needle1, Haystack) > 0 | POS(Needle2, Haystack) > 0 THEN DO
			I = I + 1
			ReadFile_Lines.I = Haystack
		END	/*Ends "IF POS(Needle1, Haystack) > 0 | POS(Needle2, Haystack) > 0 THEN DO" Section*/
	END	/*Ends "DO WHILE LINES(ReadFile)" Section*/
	ReadFile_Lines.0 = I
	RC = LINEOUT(ReadFile)
	RETURN ReadFile_Lines.

::METHOD WRITE_DATA CLASS	/*Writes the data, supplied by a stem variable, OutputStem., to a given file, supplied path information in the variable, WriteFilePath*/
	USE ARG OutputStem., WriteFilePath
	RC = SYSFILEDELETE(WriteFilePath)
	DO I = 1 TO OutputStem.[0] BY 1
		RC = LINEOUT(WriteFilePath, OutputStem.I)
	END I	/*Ends "DO I = 1 TO OutputStem.[0] BY 1" Section*/
	RC = LINEOUT(WriteFilePath)
	RETURN 0

::METHOD DIRECTORY_LIST_SIZE CLASS
	USE ARG SSize
	Title = "DIRECTORY LIST TOO LARGE!"
	Message1 = "You are attempting to list "SSize" directories. The maximum allowable list size is 32,000. "
	Message2 = 'Please use the "Presort" facility, or some other method, to reduce the size of the directory list. '
	Message3 = 'Press the "OK" button to reset and start another search. Or, press the "Cancel" button to close out the SEEK program.'
	Message = Message1||Message2||Message3
	RC = VpMessageBox(window,Title,Message,'OKCNCL')
	RETURN RC

::METHOD FILE_LIST_SIZE CLASS
	USE ARG SSize
	Title = "FILE LIST TOO LARGE!"
	Message1 = "You are attempting to list "SSize" files. The maximum allowable list size is 32,000. "
	Message2 = 'Please use the "Presort" facility, or some other method, to reduce the size of the files list. '
	Message3 = 'Press the "OK" button to reset and start another search. Or, press the "Cancel" button to close out the SEEK program.'
	Message = Message1||Message2||Message3
	RC = VpMessageBox(window,Title,Message,'OKCNCL')
	RETURN RC

::METHOD APPLICATION_NOT_FOUND CLASS
	USE ARG InputStem., File_Category, Maximum_Allowable, SearchPath, Count
	Title = "APPLICATION NOT FOUND!"
	SELECT
		WHEN File_Category = "WP" THEN File_Category = "word processor"
		WHEN File_Category = "N_ED" THEN File_Category = "text editor"
		WHEN File_Category = "R_ED" THEN File_Category = "REXX code editor"
		WHEN File_Category = "L_ED" THEN File_Category = "Latex text editor"
		WHEN File_Category = "R_R" THEN File_Category = "REXX script execution"
		WHEN File_Category = "SS" THEN File_Category = "spreadsheet"
		WHEN File_Category = "FIN" THEN File_Category = "financial"
		WHEN File_Category = "WB" THEN File_Category = "web browser"
		WHEN File_Category = "PDF" THEN File_Category = "PDF file reader"
		WHEN File_Category = "PS" THEN File_Category = "PS and EPS file reader"
		WHEN File_Category = "GRAPHICS" THEN File_Category = "graphics"
		WHEN File_Category = "DRAFTING" THEN File_Category = "drafting/CAD"
		WHEN File_Category = "USER_DEFINED" THEN File_Category = "user defined"
		OTHERWISE NOP
	END	/*Ends "SELECT" Section*/
	Message1 = "Sorry, SEEK cannot find your desired "File_Category" application, which you specified at the following path:"D2C(13)||D2C(13)
	Message2 = "	"SearchPath||D2C(13)||D2C(13)
	IF File_Category = "REXX script execution" | File_Category = "financial" | File_Category = "graphics" | File_Category = "drafting/CAD" File_Category = "user defined" THEN File_Category = File_Category" application"
	Message3 = "Therefore, SEEK will stop searching for any more "File_Category"s, having found "Count". Please fix the specified path "
	Message4 = "for this application in the SETUP file. After doing so, rerun SEEK. SEEK will then process any remaining "
	Message5 = File_Category"s, specified by you, up to the maximum allowable of "Maximum_Allowable"."
	Message = Message1||Message2||Message3||Message4||Message5
	RC = VpMessageBox(window,Title,Message)
	RETURN RC





::CLASS Timing
::METHOD Delay CLASS
	use arg DelayTime
	ElapsedTime = SYSELAPSEDTIME("R")
	DO UNTIL ElapsedTime >= DelayTime
		x = (DelayTime - ElapsedTime)%2
		SELECT
			WHEN x >= 1 THEN RC = SYSSLEEP(x)
			OTHERWISE NOP
		END	/*Ends "SELECT" Section*/
		ElapsedTime = SYSELAPSEDTIME("E")
	END	/*Ends "DO UNTIL ElapsedTime >= DelayTime" Section*/
	RETURN .Timing~New









/*Begin methods required to run a LBS Radix sort routine in REXX*/
::CLASS SORT PUBLIC
::CLASS SORTTOOLS SUBCLASS SORT PUBLIC
::CLASS MISCELLANEOUS SUBCLASS SORTTOOLS PUBLIC
::METHOD CREATE_ARRAY_FROM_STEM CLASS
	USE ARG InputStem., FirstStemNumber, StemSize
	Array = .ARRAY~NEW(StemSize)
	J = 0
	DO I = FirstStemNumber TO (FirstStemNumber + StemSize - 1) BY 1
		J = J + 1
   		Array[J] = InputStem.I
	END I	/*Ends "DO I = FirstStemNumber TO (FirstStemNumber + StemSize - 1) BY 1" Section*/
	RETURN Array

::METHOD STEM_FROM_ARRAY CLASS
	USE ARG Array, ArraySize
	DO I = 1 TO ArraySize BY 1
   		StemFromArray.I = Array[I]
	END I	/*Ends "DO I = 1 TO StemSize BY 1" Section*/
	StemFromArray.0 = ArraySize
	RETURN StemFromArray.





::CLASS BUCKET SUBCLASS SORTTOOLS PUBLIC
::CLASS ASCIIBUCKET SUBCLASS BUCKET PUBLIC
::CLASS ASCII256QUEUE SUBCLASS ASCIIBUCKET PUBLIC
::METHOD NEW CLASS
	USE ARG BucketName.
	DO I = 1 TO 256 BY 1
		BucketName.I = .QUEUE~NEW
	END I	/*Ends "DO I = 1 TO 256 BY 1" Section*/
	RETURN BucketName.

::CLASS NUMBUCKET SUBCLASS BUCKET PUBLIC
::METHOD SIZEBUCKET CLASS
	USE ARG NumLength
	Remainder = NumLength//2
	Constant1 = 1
	Constant2 = 3.1622776601684	/*(= 10**0.5)*/
	Exponent1 = NumLength/2
	Exponent2 = (NumLength - 1)/2
	SELECT
		WHEN Remainder = 0 THEN NumberOfBuckets = Constant1*10**Exponent1
		OTHERWISE NumberOfBuckets = (Constant2*10**Exponent2%1 + 1)
	END	/*Ends "SELECT" Section*/
	RETURN NumberOfBuckets

::CLASS NUMBUCKETQUEUE SUBCLASS NUMBUCKET PUBLIC
::METHOD NEW CLASS
	USE ARG BucketName., NumberOfBuckets
	DO I = 0 TO NumberOfBuckets BY 1
		BucketName.I = .QUEUE~NEW
	END I	/*Ends "DO I = 0 TO NumberOfBuckets BY 1" Section*/
	RETURN BucketName.





::CLASS RADIX SUBCLASS SORTTOOLS PUBLIC
::METHOD QUEUEBUCKET_C_DISTRIBUTE CLASS
	USE ARG BucketName., SortArray, SortArraySize, Position
	DO I = 1 TO SortArraySize BY 1
		ASCII = C2D(SUBSTR(SortArray[I], Position, 1))
		BucketName.ASCII~QUEUE(SortArray[I])
	END I		/*Ends "DO I = 1 TO SortArraySize BY 1" Section*/
	RETURN BucketName.

::METHOD QUEUEBUCKET_I_DISTRIBUTE CLASS
	USE ARG BucketName., SortArray, SortArraySize, Position
	DO I = 1 TO SortArraySize BY 1
		ASCII = C2D(TRANSLATE(SUBSTR(SortArray[I], Position, 1)))
		BucketName.ASCII~QUEUE(SortArray[I])
	END I		/*Ends "DO I = 1 TO SortArraySize BY 1" Section*/
	RETURN BucketName.

::METHOD QUEUEBUCKET_N_DISTRIBUTE CLASS
	USE ARG BucketName., NumberOfBuckets, SortArray, SortArraySize, Start, MaxLength, Count
	DO I = 1 TO SortArraySize BY 1
		NNumber = STRIP(SUBSTR(SortArray[I], Start, MaxLength), "B")
		SELECT
			WHEN Count = 1 THEN NUM = NNumber//NumberOfBuckets
			OTHERWISE NUM = NNumber%NumberOfBuckets
		END	/*Ends "SELECT" Section*/
		BucketName.NUM~QUEUE(SortArray[I])
	END I		/*Ends "DO I = 1 TO SortArraySize BY 1" Section*/
	RETURN BucketName.

::METHOD QUEUEBUCKET_D_DISTRIBUTE CLASS
	USE ARG BucketName., NumberOfBuckets, SortArray, SortArraySize, Start, MaxLength, Count
	DO I = 1 TO SortArraySize BY 1
		IF SUBSTR(STRIP(SUBSTR(SortArray[I], Start, MaxLength), "B"), 2, 1) = "/" THEN DNumber = DATE("B", "0"STRIP(SUBSTR(SortArray[I], Start, MaxLength), "B"), "U")
		ELSE DNumber = DATE("B", STRIP(SUBSTR(SortArray[I], Start, MaxLength), "B"), "U")
		SELECT
			WHEN Count = 1 THEN NUM = DNumber//NumberOfBuckets
			OTHERWISE NUM = DNumber%NumberOfBuckets
		END	/*Ends "SELECT" Section*/
		BucketName.NUM~QUEUE(SortArray[I])
	END I		/*Ends "DO I = 1 TO SortArraySize BY 1" Section*/
	RETURN BucketName.

::METHOD QUEUEBUCKET_T_DISTRIBUTE CLASS
	USE ARG BucketName., NumberOfBuckets, SortArray, SortArraySize, Start, MaxLength, Count
	DO I = 1 TO SortArraySize BY 1
		Data = STRIP(SUBSTR(SortArray[I], Start, MaxLength), "B")
		SELECT
			WHEN TRANSLATE(RIGHT(Data, 1)) = "A" | TRANSLATE(RIGHT(Data, 1)) = "P" THEN TNumber = TIME("M", Data"m", "C")
			OTHERWISE TNumber = TIME("M", Data, "C")
		END	/*Ends "SELECT" Section*/
		SELECT
			WHEN Count = 1 THEN NUM = TNumber//NumberOfBuckets
			OTHERWISE NUM = TNumber%NumberOfBuckets
		END	/*Ends "SELECT" Section*/
		BucketName.NUM~QUEUE(SortArray[I])
	END I		/*Ends "DO I = 1 TO SortArraySize BY 1" Section*/
	RETURN BucketName.

::METHOD PULL_QUEUE_DATA CLASS
	USE ARG BucketName., Start, NumberOfBuckets, SortArray
	J = 0
	DO I = Start TO NumberOfBuckets BY 1
		BucketSupplier = BucketName.I~SUPPLIER
		DO WHILE BucketSupplier~AVAILABLE
			J = J + 1
	    		SortArray[J] = BucketName.I~PULL
	  		BucketSupplier~NEXT
		END	/*Ends "DO WHILE BucketSupplier~AVAILABLE" Section*/
	END I	/*Ends "DO I = Start TO NumberOfBuckets BY 1" Section*/
	RETURN SortArray





::CLASS SORT_PROCEDURES SUBCLASS SORT PUBLIC
::CLASS RADIXSORT SUBCLASS SORT_PROCEDURES PUBLIC
::CLASS LSB SUBCLASS RADIXSORT PUBLIC
::METHOD STEMSORT CLASS
	USE ARG Stem., FirstStemNumber, StemSize, S.1, L.1, O.1, T.1, S.2, L.2, O.2, T.2, S.3, L.3, O.3, T.3, S.4, L.4, O.4, T.4, S.5, L.5, O.5, T.5, S.6, L.6, O.6, T.6, S.7, L.7, O.7, T.7, S.8, L.8, O.8, T.8, S.9, L.9, O.9, T.9, S.10, L.10, O.10, T.10
/*"Stem" is the name of the stem variable that has the data to be sorted*/
/*"FirstStemNumber" is the number of the first stem variable upon which to start the sort (usually = 1)*/
/*"StemSize" equals the total number of stem variables (usually = Stem.[0], or similar)*/
/*S.I (I = 1, 2 ..., 10) is the starting character position of the data assignments of the stem variables to be sorted*/
/*L.I (I = 1, 2 ..., 10) is the data length (number of characters) to be sorted within the data assignments of the stem variables*/
/*O.I (I = 1, 2 ..., 10) is the order of the sort: "A" for ascending order ("A" then "B" then "C", etc.); "D" for descending order ("Z" then "Y" then "W", etc.)*/
/*T.I (I = 1, 2 ..., 10) is the type of sort: "C" for case sensitive; "I" for case insensitive; "N" for numerical; "D" for date; and "T" for a time sort*/
	SELECT
		WHEN TRANSLATE(LEFT(T.1, 1)) = "C" | TRANSLATE(LEFT(T.1, 1)) = "I" THEN Stem. = .LSB~CHAR_STEMSORT(Stem., FirstStemNumber, StemSize, S.1, L.1, O.1, T.1)
		WHEN TRANSLATE(LEFT(T.1, 1)) = "N" THEN Stem. = .LSB~NUM_STEMSORT(Stem., FirstStemNumber, StemSize, S.1, L.1, O.1, T.1)
		WHEN TRANSLATE(LEFT(T.1, 1)) = "D" THEN Stem. = .LSB~DATE_STEMSORT(Stem., FirstStemNumber, StemSize, S.1, L.1, O.1, T.1)
		WHEN TRANSLATE(LEFT(T.1, 1)) = "T" THEN Stem. = .LSB~TIME_STEMSORT(Stem., FirstStemNumber, StemSize, S.1, L.1, O.1, T.1)
		OTHERWISE NOP
	END	/*Ends "SELECT" Section*/
	OriginalStemSize = StemSize
	Question = "FALSE"
	DO I = 2 TO 10 BY 1
		SELECT
			WHEN S.I = "S."I THEN LEAVE I
			WHEN Question = "TRUE" THEN LEAVE I

			OTHERWISE DO
				Question = "TRUE"
				J = 0
				DO UNTIL J >= (OriginalStemSize - 1)
					TwinFlag = 1
					J = J + 1
					K = J + 1
					DO L = 1 TO (I - 1) BY 1
						IF SUBSTR(Stem.J, S.L, L.L) = SUBSTR(Stem.K, S.L, L.L) THEN TwinFlag = TwinFlag*1
						ELSE TwinFlag = TwinFlag*0
					END L	/*End "DO L = 1 TO (I - 1) BY 1" Section*/
					IF TwinFlag = 1 THEN DO
						Question = "FALSE"
						FFirstStemNumber = J
						DO UNTIL TwinFlag = 0 | K = OriginalStemSize
							K = K + 1
							DO L = 1 TO (I - 1) BY 1
								IF SUBSTR(Stem.J, S.L, L.L) = SUBSTR(Stem.K, S.L, L.L) THEN TwinFlag = TwinFlag*1
								ELSE TwinFlag = TwinFlag*0
							END L	/*End "DO L = 1 T	O (I - 1) BY 1" Section*/
						END	/*Ends "DO UNTIL TwinFlag = 0 | K = OriginalStemSize" Section*/
						IF TwinFlag = 0 THEN SStemSize = (K - J)
						ELSE SStemSize = (K - J + 1)
						SecondarySortStart = S.I
						SecondarySortLength = L.I
						SecondarySortOrder = O.I
						SecondarySortType = T.I
						SELECT
							WHEN TRANSLATE(LEFT(SecondarySortType, 1)) = "C" | TRANSLATE(LEFT(SecondarySortType, 1)) = "I" THEN MiniStem. = .LSB~CHAR_STEMSORT(Stem., FFirstStemNumber, SStemSize, SecondarySortStart, SecondarySortLength, SecondarySortOrder, SecondarySortType)
							WHEN TRANSLATE(LEFT(SecondarySortType, 1)) = "N" THEN MiniStem. = .LSB~NUM_STEMSORT(Stem., FFirstStemNumber, SStemSize, SecondarySortStart, SecondarySortLength, SecondarySortOrder, SecondarySortType)
							WHEN TRANSLATE(LEFT(SecondarySortType, 1)) = "D" THEN MiniStem. = .LSB~DATE_STEMSORT(Stem., FFirstStemNumber, SStemSize, SecondarySortStart, SecondarySortLength, SecondarySortOrder, SecondarySortType)
							WHEN TRANSLATE(LEFT(SecondarySortType, 1)) = "T" THEN MiniStem. = .LSB~TIME_STEMSORT(Stem., FFirstStemNumber, SStemSize, SecondarySortStart, SecondarySortLength, SecondarySortOrder, SecondarySortType)
							OTHERWISE NOP
						END	/*Ends "SELECT" Section*/
						N = (J - 1)
						DO M = 1 TO MiniStem.0 BY 1
							N = N + 1
							Stem.N = MiniStem.M
						END M	/*Ends "DO M = 1 TO MiniStem.0 BY 1" Section*/
						J = (J + SStemSize - 1)
					END	/*Ends "IF TwinFlag = 1 THEN DO" Section*/
				END	/*Ends "DO UNTIL J >= (OriginalStemSize - 1)" Section*/
			END	/*Ends "OTHERWISE DO" Section*/
		END	/*Ends "SELECT" Section*/
	END I	/*Ends "DO I = 2 TO 10 BY 1" Section*/
	Stem.0 = OriginalStemSize
	RETURN Stem.

::METHOD CHAR_STEMSORT CLASS
	USE ARG InputStem., FirstStemNumber, StemSize, Start, LLength, Order, Type
	DataArray = .MISCELLANEOUS~CREATE_ARRAY_FROM_STEM(InputStem., FirstStemNumber, StemSize)
	SortBucket. = .ASCII256QUEUE~NEW(SortBucket.)
	KeyPosition = Start + LLength
	DO UNTIL KeyPosition = Start
		KeyPosition = KeyPosition - 1
		SELECT
			WHEN TRANSLATE(LEFT(Type, 1)) = "C" THEN RC = .RADIX~QUEUEBUCKET_C_DISTRIBUTE(SortBucket., DataArray, StemSize, KeyPosition)
			WHEN TRANSLATE(LEFT(Type, 1)) = "I" THEN RC = .RADIX~QUEUEBUCKET_I_DISTRIBUTE(SortBucket., DataArray, StemSize, KeyPosition)
			OTHERWISE NOP
		END	/*Ends "SELECT" Section*/
		DataArray = .RADIX~PULL_QUEUE_DATA(SortBucket., 1, 256, DataArray)
	END	/*Ends "DO UNTIL KeyPosition = Start" Section*/
	SortedStem. = .MISCELLANEOUS~STEM_FROM_ARRAY(DataArray, StemSize)
	IF TRANSLATE(LEFT(Order, 1)) = "D" THEN DO
		FlippedStem. = .STEM~FLIP(SortedStem., StemSize)
		RETURN FlippedStem.
	END	/*Ends "IF TRANSLATE(LEFT(Order, 1)) = "D" THEN DO" Section*/
	ELSE RETURN SortedStem.

::METHOD NUM_STEMSORT CLASS
	USE ARG InputStem., FirstStemNumber, StemSize, Start, LLength, Order, Type
	DataArray = .MISCELLANEOUS~CREATE_ARRAY_FROM_STEM(InputStem., FirstStemNumber, StemSize)
	BucketSize = .NUMBUCKET~SIZEBUCKET(LLength)
	SortBucket. = .NUMBUCKETQUEUE~NEW(SortBucket., BucketSize)
	DO Kount = 1 TO 2 BY 1
		RC = .RADIX~QUEUEBUCKET_N_DISTRIBUTE(SortBucket., BucketSize, DataArray, StemSize, Start, LLength, Kount)
		RC = .RADIX~PULL_QUEUE_DATA(SortBucket., 0, BucketSize, DataArray)
	END	/*Ends "DO Kount = 1 TO 2 BY 1" Section*/
	SortedStem. = .MISCELLANEOUS~STEM_FROM_ARRAY(DataArray, StemSize)
	IF TRANSLATE(LEFT(Order, 1)) = "D" THEN DO
		FlippedStem. = .STEM~FLIP(SortedStem., StemSize)
		RETURN FlippedStem.
	END	/*Ends "IF TRANSLATE(LEFT(Order, 1)) = "D" THEN DO" Section*/
	ELSE RETURN SortedStem.

::METHOD DATE_STEMSORT CLASS
	USE ARG InputStem., FirstStemNumber, StemSize, Start, LLength, Order, Type
	DataArray = .MISCELLANEOUS~CREATE_ARRAY_FROM_STEM(InputStem., FirstStemNumber, StemSize)
	BucketSize = 1000	/*Based on REXX DATE function returning upto six (6) digits in base format*/
	SortBucket. = .NUMBUCKETQUEUE~NEW(SortBucket., BucketSize)
	DO Kount = 1 TO 2 BY 1
		RC = .RADIX~QUEUEBUCKET_D_DISTRIBUTE(SortBucket., BucketSize, DataArray, StemSize, Start, LLength, Kount)
		RC = .RADIX~PULL_QUEUE_DATA(SortBucket., 0, BucketSize, DataArray)
	END	/*Ends "DO Kount = 1 TO 2 BY 1" Section*/
	SortedStem. = .MISCELLANEOUS~STEM_FROM_ARRAY(DataArray, StemSize)
	IF TRANSLATE(LEFT(Order, 1)) = "D" THEN DO
		FlippedStem. = .STEM~FLIP(SortedStem., StemSize)
		RETURN FlippedStem.
	END	/*Ends "IF TRANSLATE(LEFT(Order, 1)) = "D" THEN DO" Section*/
	ELSE RETURN SortedStem.

::METHOD TIME_STEMSORT CLASS
	USE ARG InputStem., FirstStemNumber, StemSize, Start, LLength, Order, Type
	DataArray = .MISCELLANEOUS~CREATE_ARRAY_FROM_STEM(InputStem., FirstStemNumber, StemSize)
	BucketSize = 100	/*Based on REXX TIME function returning upto four (4) digits in minute format*/
	SortBucket. = .NUMBUCKETQUEUE~NEW(SortBucket., BucketSize)
	DO Kount = 1 TO 2 BY 1
		RC = .RADIX~QUEUEBUCKET_T_DISTRIBUTE(SortBucket., BucketSize, DataArray, StemSize, Start, LLength, Kount)
		RC = .RADIX~PULL_QUEUE_DATA(SortBucket., 0, BucketSize, DataArray)
	END	/*Ends "DO Kount = 1 TO 2 BY 1" Section*/
	SortedStem. = .MISCELLANEOUS~STEM_FROM_ARRAY(DataArray, StemSize)
	IF TRANSLATE(LEFT(Order, 1)) = "D" THEN DO
		FlippedStem. = .STEM~FLIP(SortedStem., StemSize)
		RETURN FlippedStem.
	END	/*Ends "IF TRANSLATE(LEFT(Order, 1)) = "D" THEN DO" Section*/
	ELSE RETURN SortedStem.





::CLASS STEM  PUBLIC
::METHOD FLIP CLASS
	USE ARG InputStem., InputStemSize
	OutputStem. = .STEM~NEW
	DO I = 1 TO InputStemSize BY 1
		J = (InputStemSize + 1 - I)
		OutputStem.J = InputStem.I
	END I	/*Ends "DO I = 1 TO InputStemSize BY 1" Section*/
	OutputStem.0 = InputStemSize
	RETURN OutputStem.
/*End methods required to run a LBS Radix sort routine in REXX*/









::CLASS DUMMY
::METHOD DUMMY CLASS
return
