/* REXX: Install FONT19 */

Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysloadFuncs'
Call SysLoadFuncs
Call SysCls

tmp=value('TMP',,'OS2ENVIRONMENT')
if tmp=='' then
  tmp=value('TEMP',,'OS2ENVIRONMENT')
if tmp=='' then
  tmp=Directory()
if Right(tmp,1,' ')=='\' then
  tmp=SubStr(tmp,1,Length(tmp)-1)

os2_dll=SysBootDrive()'\os2\dll\'
ccf=SysBootDrive()'\config.sys'
viotbl_dcp_default=SysBootDrive()'\os2\boot\viotbl.dcp'
if Stream(viotbl_dcp_default, 'c', 'query exist')=='' then
  viotbl_dcp_default=SysBootDrive()'\os2\vitbl.dcp'

Say 'This program installs the FONT19 package.'
Say 'it assumes that You did copy the files to a hard disk directory.'
Say ''
Say 'Do you want'
Say ' - Configure for 9x19 font - use SNAP 80x60 mode (80x25:720x475)'
Say ' - Configure for 9x20 font - VGA table patch     (80x25:720x500)'
Say ' - Configure for 9x19 font - VGA table patch     (80x25:720x475)'
Say ' - Uninstall                                     (80x25:720x400)'
Say ' - Quit'
do until (fontsize==16) | (fontsize==19) | (fontsize==20)
  Call CharOut ,'(s|19|20|u|q)? '
  pull fontsize
  snap_mode=0
  fontsize=lower(fontsize)
  if fontsize=='q' then Return 1
  if fontsize=='u' then fontsize='16'
  if fontsize=='s' then
    do
      snap_mode=1
      fontsize=19
    end
end

Say '* patching \os2\dll\bvhvga.dll AccessFont function'
'@if not exist' os2_dll||'bvhvga.org copy' os2_dll||'bvhvga.dll' os2_dll||'bvhvga.org'
Call exec 'patchdll.exe fix_AccessFont' os2_dll||'bvhvga.dll'

Say '* patching \os2\dll\bvhvga.dll SetHWFontRegs function'
Call exec 'patchdll.exe fix_SetHWFontRegs' os2_dll||'bvhvga.dll'

Say '* changing \os2\dll\bvhsvga.dll INITENV default values'
'@if not exist' os2_dll||'bvhsvga.org copy' os2_dll||'bvhsvga.dll' os2_dll||'bvhsvga.org'
if fontsize==16 then Call exec 'patchdll.exe patch_INITENV_80x25_720x400' os2_dll||'bvhsvga.dll'
if fontsize==19 then 
  do
    if snap_mode==0 then 
      Call exec 'patchdll.exe patch_INITENV_80x25_720x475' os2_dll||'bvhsvga.dll'
    else
      Call exec 'patchdll.exe patch_INITENV_80x25_720x480' os2_dll||'bvhsvga.dll'
  end
if fontsize==20 then Call exec 'patchdll.exe patch_INITENV_80x25_720x500' os2_dll||'bvhsvga.dll'

Say '* processing \os2\dll\viocalls.dll'
Call exec 'patchdll.exe unlock' os2_dll||'viocalls.dll'
if fontsize==16 then
  '@copy' os2_dll||'viocalls.org' os2_dll||'viocalls.dll' 
else
  do
    '@if not exist' os2_dll||'viocalls.org copy' os2_dll||'viocalls.dll' os2_dll||'viocalls.org' 
    Call exec 'copy .\viocalls.dll' os2_dll||'viocalls.dll'
    Call exec 'copy .\viocalls.sym' os2_dll||'viocalls.sym'
  end

if fontsize==16 then
  do
    Say '* removing config.sys changes'
    call Edit_Config_Sys
    Return 0
  end

Say '* searching primary/secondary codepage in config.sys'
cp1='850'
cp2=''
viotbl_dcp=viotbl_dcp_default

do while lines(ccf)
  ibuf=Strip(linein(ccf),,)
  ibuf=lower(ibuf)
  if Abbrev(ibuf,'codepage=') then
    Parse Var ibuf 'codepage=' cp1 ',' cp2
  /* did user prefer viotbl.dcp or viotbl.iso? */
  if Abbrev(ibuf,'devinfo=scr,vga,') | Abbrev(ibuf,'rem font19 install devinfo=scr,vga,') then
    do
      Parse Var ibuf dummy 'devinfo=scr,vga,' viotbl_dcp_config_sys
      if Left(Right(viotbl_dcp_config_sys,Length('\viotbl.dcp')),Length('\viotbl.'))=='\viotbl.' then
        viotbl_dcp=viotbl_dcp_config_sys
    end
end
Call Stream ccf, 'c', 'close'

if cp1==cp2 then cp2='NO'

if cp2=='' then cp2='NO'
Say '  'cp1','cp2

Say '* decoding 'viotbl_dcp
Call exec 'dcp_x' viotbl_dcp tmp'\'

Say '* extracting OS/2 "System VIO" 8x8,10,12,14,16,18'
Call exec 'dspresx.exe' os2_dll'dspres.dll' tmp
Say '* creating raw fonts from OS/2 font'
Call exec 'os2fnt_x' tmp'\vio_8_10.fon' tmp'\viotbl.ext\'Int2StrZ(cp1,5)'_10.fn8' cp1
Call exec 'os2fnt_x' tmp'\vio_8_12.fon' tmp'\viotbl.ext\'Int2StrZ(cp1,5)'_12.fn8' cp1
Call exec 'os2fnt_x' tmp'\vio_8_18.fon' tmp'\viotbl.ext\'Int2StrZ(cp1,5)'_18.fn8' cp1
if cp2<>'NO' then
  do
    Call exec 'os2fnt_x' tmp'\vio_8_10.fon' tmp'\viotbl.ext\'Int2StrZ(cp2,5)'_10.fn8' cp2
    Call exec 'os2fnt_x' tmp'\vio_8_12.fon' tmp'\viotbl.ext\'Int2StrZ(cp2,5)'_12.fn8' cp2
    Call exec 'os2fnt_x' tmp'\vio_8_18.fon' tmp'\viotbl.ext\'Int2StrZ(cp2,5)'_18.fn8' cp2
  end
Say '* deriving 8x'fontsize' from 8x18 font'
Call exec 'sfont' tmp'\viotbl.ext\'Int2StrZ(cp1,5)'_18.fn8' tmp'\viotbl.ext\'Int2StrZ(cp1,5)'_'fontsize'.fn8' fontsize
if cp2<>'NO' then
  Call exec 'sfont' tmp'\viotbl.ext\'Int2StrZ(cp2,5)'_18.fn8' tmp'\viotbl.ext\'Int2StrZ(cp2,5)'_'fontsize'.fn8' fontsize

Say '* creating viotbl build script'

viotbl_dir_name=tmp'\vt'cp1||cp2'.dir'
viotbl_dcp_name=SysBootDrive()||'\os2\boot\vt'cp1||cp2'.dcp'


'@if exist' viotbl_dir_name 'del' viotbl_dir_name
Call Stream  viotbl_dir_name, 'c', 'open write'
Call LineOut viotbl_dir_name, '# VIOTBL.DCP build script for cp1='cp1', cp2='cp2', font' fontsize
Call LineOut viotbl_dir_name, 'O' viotbl_dcp_name
Call LineOut viotbl_dir_name, 'T created' Date() 'for 'cp1'/'cp2

Call list_font cp1,8, 8
Call list_font cp1,8,14
Call list_font cp1,8,16
Call list_font cp1,9,14
Call list_font cp1,9,16
Call list_font cp1,8,10
if fontsize==19 then
  do /* 480:12=40 */
    Call list_font cp1,8,12
  end
if fontsize==20 then
  do /* 504:18=28 */
    Call list_font cp1,8,18
  end
Call list_font cp1,8,fontsize
Call list_font cp1,9,fontsize

if cp2<>'NO' then
  do
    Call list_font cp2,8, 8
    Call list_font cp2,8,14
    Call list_font cp2,8,16
    Call list_font cp2,9,14
    Call list_font cp2,9,16
    Call list_font cp2,8,fontsize
  end

Call Stream  viotbl_dir_name, 'c', 'close'

Say '* building new' viotbl_dcp_name
Call exec 'dcp_a' viotbl_dir_name

Say '* adding lines to config.sys to enable new' viotbl_dcp_name
Call Edit_Config_Sys

Say '------------- done. please shutdown and reboot. -------------'
Call SysSleep 5
Return 0

/*-----------------------------------------------------------------*/

list_font:
  Parse ARG cp,fx,fy


  fontfilename=tmp'\viotbl.ext\'Int2StrZ(cp,5)'_'Int2StrZ(fy,2)'.fn'fx
  if Stream(fontfilename, 'c', 'query exist') == '' then
    fontfilename=tmp'\viotbl.ext\'Int2StrZ(cp,5)'_'Int2StrZ(fy,2)'.fn8'

  /* could use other font file...
  if (fy=19 | fy=20) & (cp=437 | cp=850) then
    fontfilename='CP'Int2StrZ(cp,3)'_'Int2Str(fy,2)'.FNT' */

  Call LineOut viotbl_dir_name, 'F 'fontfilename cp fx
  Return

/*-----------------------------------------------------------------*/

Int2StrZ:
  Parse ARG number,decimals
  Return Right(number,decimals,'0')

/*-----------------------------------------------------------------*/

Directory2:
  dir=Directory()
  if Right(dir,1,' ')<>'\' then
    dir=dir'\'
  Return dir

/*-----------------------------------------------------------------*/

lower:
  Parse ARG zk
  Return Translate(zk,'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ')

/*-----------------------------------------------------------------*/
Edit_Config_Sys:
  os2csm_path=''

  /* config.sys aufrumen */
  config_sys_len=0
  viotbl_dcp=viotbl_dcp_default
  do while lines(ccf)
    ibuf=Strip(linein(ccf),,)
    jbuf=lower(ibuf)
    if Abbrev(jbuf,'rem font19 install ') then
      do
        ibuf=SubStr(ibuf,Length('rem font19 install ')+1)
        jbuf=lower(ibuf)    
      end
    if Pos('\font19en.exe',jbuf)<>0 then Iterate
    if Abbrev(jbuf,'devinfo=scr,vga,') then
      do
        Parse Var jbuf 'devinfo=scr,vga,' viotbl_dcp_config_sys
        if Left(Right(viotbl_dcp_config_sys,Length('\viotbl.dcp')),Length('\viotbl.'))=='\viotbl.' then
          viotbl_dcp=viotbl_dcp_config_sys
        Iterate
      end

    if Pos('\checkcsm.exe ',jbuf)<>0 then
      Parse Var jbuf 'call=' os2csm_path '\checkcsm.exe ' dummy

    if Abbrev(jbuf,'rem v.k. * os2cfg *') | Abbrev(jbuf,'rem 512conf*') then
      Iterate

    config_sys_len=config_sys_len+1
    config_sys.config_sys_len=ibuf
  end
  Call Stream ccf, 'c', 'close'

  /* bei Bedarf neue Zeilen hinzufgen */
  if fontsize==19 | fontsize==20 then
    do
      /* rem font19 install DevInfo=Scr,VGA,e:\os2\boot\viotbl.iso */
      config_sys_len=config_sys_len+1
      config_sys.config_sys_len='rem font19 install DevInfo=Scr,VGA,'viotbl_dcp
      /* DevInfo=Scr,VGA,E:\os2\boot\vt850437.dcp */
      config_sys_len=config_sys_len+1
      config_sys.config_sys_len='DevInfo=Scr,VGA,'viotbl_dcp_name
      if snap_mode==0 then
        do
          /* Call=C:\V\FONT19\FONT19.VK\font19en.exe 20 */
          config_sys_len=config_sys_len+1
          config_sys.config_sys_len='Call='Directory2()'font19en.exe' fontsize
        end
    end

  if fontsize==16 then
    do
      /* DevInfo=Scr,VGA,E:\os2\boot\viotbl.dcp */
      config_sys_len=config_sys_len+1
      config_sys.config_sys_len='DevInfo=Scr,VGA,'viotbl_dcp
    end


  /* neue config.sys schreiben */
  '@del' ccf
  do i=1 to config_sys_len
    Call LineOut ccf, config_sys.i
  end
  Call Stream ccf, 'c', 'close'

  /* mit OS2CSM bearbeiten */
  if os2csm_path<>'' then
    Call exec os2csm_path'\align512.exe' ccf
  
  Return

/*-----------------------------------------------------------------*/
exec:
  Parse ARG command
  '@'command
  exec_rc=rc
  if exec_rc=0 then Return
  Say 'command "'command'" faild, rc='exec_rc
  if exec_rc<>1 then
    Say SysGetMessage(rc)
  Call Beep 1000,1000
  Call SysSleep 4
  Exit rc
/*-----------------------------------------------------------------*/
