/*
 * font.h - definitions for X font informations
 *
 *	Font Info. structures are based on X11R4.
 */

#ifndef	_FONT_H
#define	_FONT_H

#include <os2.h>

#ifndef BOOL
#define BOOL    int
#endif

#ifndef TRUE
#define TRUE    1
#endif
#ifndef FALSE
#define FALSE   0
#endif

#ifndef min
#define min(x, y)   ((x) < (y) ? (x) : (y))
#endif

#ifndef max
#define max(x, y)   ((x) > (y) ? (x) : (y))
#endif

/*
 * Common types, taken from X11R4
 */

typedef long            INT32  ;
typedef short           INT16  ;
typedef unsigned long   CARD32 ;
typedef unsigned short  CARD16 ;
typedef unsigned char   CARD8  ;

#define MAXSHORT    32767
#define MINSHORT    -MAXSHORT

/*
 * CharInfoRec, CharInfoPtr
 *      Contains Character's metrics info. and its glyph bitmap
 *      Originally taken from X11R4, but slightly modified.
 */

typedef struct {
    INT16   leftSideBearing  ;
    INT16   rightSideBearing ;
    INT16   characterWidth   ;
    INT16   ascent           ;
    INT16   descent          ;
    CARD16  attributes       ;
} xCharInfo ;

typedef struct _CharInfoRec *CharInfoPtr ;

typedef struct _CharInfoRec {
    xCharInfo   metrics ;
    char        *glyph  ;
} CharInfoRec ;

/*
 * FontPropRec, FontPropPtr
 *      Contains font property. Modified for XFONT.
 */

typedef struct _FontProp {
    char    *name ;     /* Name of Property */
    char    *str  ;     /* String Value, IF NULL then use INT value */
    long    val   ;     /* INT Value    */
} FontPropRec;

typedef FontPropRec *FontPropPtr ;

/*
 * FontRec, FontPtr
 *      Contains all info. about a font.
 */

typedef struct _Font *FontPtr ;

typedef struct _Font {
    char            *fontname ;     // Font Name
    int             firstCol  ;     // MIN COL of char codes
    int             lastCol   ;     // MAX COL of char codes
    int             firstRow  ;     // MIN ROW of char codes
    int             lastRow   ;     // MAX ROW of char codes
    xCharInfo       minbound  ;     // MIN bouding
    xCharInfo       maxbound  ;     // MAX bouding
    int             sizProp   ;     // # of allocated props
    int             numProp   ;     // # of registered props
    FontPropPtr     pFP       ;     // Ptr to Props Area
    CharInfoPtr     pCI[256]  ;     // Link to CharInfo Arrays
} FontRec ;

/*
 * Length of String Buffers
 */

#define	MAXNAM	256

/*
 * Function Prototypes for Font Utilities
 */

void FreeFontInfo(FontPtr pFont);
FontPtr CreateFontInfo(void);
void DumpFontInfo(FontPtr pFont);

char *SetFontName(FontPtr pFont, char *name) ;
FontPropPtr AllocFontProp(FontPtr pFont, int nprops) ;
FontPropPtr AddStrProp(FontPtr pFont, char *name, char *str) ;
FontPropPtr AddIntProp(FontPtr pFont, char *name, long  val) ;
FontPropPtr GetFontProp(FontPtr pFont, char *name) ;
char *AllocCharInfo(FontPtr pFont, int row, int col,
            int left, int right, int ascent, int descent,
	    int width, int attr) ;
CharInfoPtr GetCharInfo(FontPtr pFont, int row, int col);

void ComputeBoundings(FontPtr pFont) ;
long ComputeWeight(FontPtr pFont) ;

#endif	/* _FONT_H */
