/*
 * xfont.h - Global Definitions for "xfont" program
 */

#ifndef _XFONT_H
#define _XFONT_H

#include "font.h"

#define MAXNAM  256

/*
 * Local Messages
 */

#define WM_LOAD_FONT    (WM_USER + 1)
    /*
     * Request to Load Font Data
     *      mp1     LISTPTR for Loading Font File
     *      mp2     NULL
     */

#define WM_LOAD_DONE    (WM_USER + 2)
    /*
     * Notify Load Complete
     *      mp1     LISTPTR for Loaded Font File
     *      mp2     NULL
     */

#define WM_MAGN_INIT    (WM_USER + 3)
    /*
     * Request to Magnify Glyph
     *      mp1     Magnify Control Block
     *      mp2     NULL
     */

/*
 * List of Fonts
 *      Associates Font File Name with Font Info.
 */

typedef struct _LIST    *LISTPTR ;

typedef struct _LIST {
    LISTPTR     next   ;
    char        *full  ;    /* Allocate for area    */
    char        *base  ;    /* Point to above       */
    int         ftype  ;    /* BDF/PCF              */
    int         status ;    /* Status of "finfo"    */
    FontPtr     finfo  ;    /* Font Info            */
    void    (*fnDone) (LISTPTR ptr) ;
} LISTREC ;

#define FTYPE_NON   0       /* Unknown Type */
#define FTYPE_PCF   1       /* PCF file     */
#define FTYPE_BDF   2       /* BDF file     */

#define FSTAT_NONE  0       /* No Info Yet  */
#define FSTAT_LOAD  1       /* Loading now  */
#define FSTAT_DONE  2       /* Ready        */

LISTPTR initFontList(void) ;
void    freeFontList(LISTPTR top) ;

LISTPTR putFontFile(LISTPTR top, char *fname) ;
LISTPTR getFontList(LISTPTR top) ;
LISTPTR getFontNext(LISTPTR ptr) ;

LISTPTR loadFontInfo(LISTPTR ptr, void (*fnDone) (LISTPTR ptr)) ;

FontPtr ReadPcfFont(FILE *fp) ;
FontPtr ReadBdfFont(FILE *fp) ;

/*
 * Common Variables
 */

extern  UCHAR   XfdProgName[] ;
extern  UCHAR   XfdInitPath[] ;
extern  LISTPTR XfdFontList   ;
extern  SWP     XfdSwpInit    ;

void    positionRestore(HAB hab) ;
void    positionSave(HWND hwnd)  ;

/*
 * Glyph Viewer
 */

HWND    initViewer(HAB  hab)   ;
void    termViewer(HWND frame) ;

extern  LISTPTR curFile ;
extern  FontPtr curFont ;
extern  int     curRow, curCol ;

extern  SIZEL   szChar ;        /* Max Extent           */
extern  SIZEL   szCell ;        /* Glyph Cell           */
extern  SIZEL   szFont ;        /* Size of Glyph Area   */
extern  SIZEL   szName ;        /* Size of Name  Area   */
extern  SIZEL   szCode ;        /* Size of Code  Area   */
extern  SIZEL   szArea ;        /* Size of Client Area  */

/*
 * Dialogs
 */

void    dialogLoadFile(HWND hwnd)   ;
void    dialogSelectFont(HWND hwnd) ;

/*
 * Operations for Character Glyphs
 */

void    glyphMagnify(HWND hwnd, CharInfoPtr pci) ;
void    glyphClipon(HWND hwnd, CharInfoPtr pci, BOOL revs) ;

#endif  /* _XFONT_H */
