/*--------------------------------------------------------------*/
/*  rxDeMime.cmd v0.16 release (07/12/1999)                     */
/*  Decoder MIME (UUE, Base64) attaches from e-mail messages.   */
/*  Analyze Quoted-Printable, 7bit and 8bit attaches and save   */
/*  them into files.                                            */
/*  Also decode some multisection UUE files from Fidonet.       */
/*  Usage: rxDeMime.cmd MessageFile                             */
/*                                                              */
/*  All rights reserved. Copyright (C) 1999 by Alex A. Porollo  */
/*  AS IS. Freeware. Noncommercial distribution.                */
/*  Contact: ap@tax.mari.ru, 2:5052/5@fidonet                   */
/*                                                              */
/*  Needs some RxFuncs, rxDCplus (loaded automatically)         */
/*  rxDCplus   Copyright (C) 1998-99 by Joseph L. Shrago        */
/*                                                              */
/*  Requires hpfs or another longname FS for correct work.      */
/*                                                              */
/*  Special thanks to Aleksey Peshkov for some ideas.           */
/*--------------------------------------------------------------*/

say; say 'rxDeMime v0.16 release by Alex Porollo, 1999.'


/*--------------------------------------------------------------*/
/* User settings                                                */
/*--------------------------------------------------------------*/

/* Error loging. Set LogFile to '' for disabling loging.        */
LogFile='rxDeMime.Log'

/* Different directory for decoded files. Set '' for disabling. */
DecodeDir=''

/* Progress indicator (yes/no). "yes" gets some time resource.  */
ProgressIndicator='Yes'


/*--------------------------------------------------------------*/
/* Load system libraries                                        */
/*--------------------------------------------------------------*/
signal on Halt
if RxFuncQuery('SysLoadFuncs') then
  do
    call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
    call SysLoadFuncs 
  end
if RxFuncQuery('DCLoadFuncs') then
  do
    call RxFuncAdd 'DCLoadFuncs','rxDCplus','DCLoadFuncs'
    call DCLoadFuncs
  end


/*--------------------------------------------------------------*/
/* Parse command line                                           */
/*--------------------------------------------------------------*/
parse arg MessageFile
if Length(Space(MessageFile))=0 then
  do
    say 'Usage: rxDeMime.cmd MessageFile'; say
    exit
  end
if Right(MessageFile,1)='"' then MessageFile=Left(MessageFile,Length(MessageFile)-1)
if Left(MessageFile,1)='"' then MessageFile=Right(MessageFile,Length(MessageFile)-1)
call SysFileTree MessageFile,file,'FO'
if \file.0 then
  do
    msg='File "'FileSpec('name',MessageFile)'" not found!'
    say msg; say; call ToLog msg
    exit
  end


/*--------------------------------------------------------------*/
/* Program constants                                            */
/*--------------------------------------------------------------*/
NoNameFile='Noname'; AttachName=''; MimeFormat=''
ABCBase64='ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/='
ABCUUE=' !"#$%&'d2c(39)'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`'
Base64=0; UUE=0; OkLines=0; UUESections=0; SectionsCount=0; SingleUUE=1; WriteUUE=0; QPWrite=0; notEof=1
B64str='Base64'; UpB64str=Translate(B64str)
XUUEstr='x-uuencode'; UpXUUEstr=Translate(XUUEstr)
UUEstr='UUE'
QPstr='Quoted-Printable'; UpQPstr=Translate(QPstr)
Bit8str='8bit'; UpBit8str='8BIT'
Bit7str='7bit'; UpBit7str='7BIT'
Unknown='Unknown mime format for rxDeMime'
PartStr='--'
ProgressIndicator=Translate(ProgressIndicator)
if DecodeDir\='' & Right(DecodeDir,1)\='\' then DecodeDir=DecodeDir'\'


/*--------------------------------------------------------------*/
/* Analyse a body of an input file                              */
/*--------------------------------------------------------------*/
rc=Stream(MessageFile,'C','OPEN READ')
if rc\='READY:' then
  do
    msg='Unable to open file "'MessageFile'" !'
    say msg; call ToLog msg
    exit
  end
say 'Proceeding file "'MessageFile'"...'
do while notEof
  notEof=Lines(MessageFile)
  LastFPos=Stream(MessageFile,'C','SEEK')
  s=LineIn(MessageFile)
  if QPWrite then
    do
      call ProgressIndicator
      Ups=Translate(s)
      if (Abbrev(Ups,PartStr) & Pos(' ',s)=0) | \notEof then
        do
          Buffer=CharIn(MessageFile,StartBlockFPos,LastFPos-StartBlockFPos)
          select
            when Abbrev(MimeFormat,UpQPstr) then msg=QPstr
            when Abbrev(MimeFormat,UpBit7str) then msg=Bit7str
            when Abbrev(MimeFormat,UpBit8str) then msg=Bit8str
            otherwise
          end
          call SaveFile msg
          MimeFormat=''; QPWrite=0
        end
      iterate
    end
  s=Strip(s,'T'); if s='' then s=' '
  if Abbrev(MimeFormat,UpQPstr) | Abbrev(MimeFormat,UpBit7str) | Abbrev(MimeFormat,UpBit8str) then
    if s=' ' & AttachName\='' & \UUE & SingleUUE then
      do
        StartBlockFPos=Stream(MessageFile,'C','SEEK')
        call Time('R')
        QPWrite=1
        iterate
      end
  if UUE then
    do
      if UUESections & \SingleUUE then
        do
          select
            when Abbrev(s,'sum -r/size') | Abbrev(s,'section end') | Abbrev(s,'-- end of') then
              do
                SectionsCount=SectionsCount+1
                SectionStart.SecNumber=StartBlockFPos
                SectionEnd.SecNumber=LastFPos
                UUE=0
                if SectionsCount=SecQuantity then WriteUUE=1
              end
            when Abbrev(s,'begin') then StartBlockFPos=Stream(MessageFile,'C','SEEK')
            when Abbrev(s,'table') | Abbrev(s,'filetime') | Pos('UUEAttr',s)>0 then
              do forever
                s=LineIn(MessageFile)
                if Abbrev(s,'begin') then
                  do
                    StartBlockFPos=Stream(MessageFile,'C','SEEK')
                    leave
                  end
              end
            when Abbrev(s,'end') then
              do
                if SecNumber=1 then
                  do
                    SectionStart.SecNumber=StartBlockFPos
                    SectionEnd.SecNumber=LastFPos
                    SectionsCount=1;WriteUUE=1
                  end
                else nop
              end
            otherwise
              if Verify(s,ABCUUE)=0 | Space(s)' '=' ' then call ProgressIndicator
              else
                do
                  if OkLines>999 then say
                  msg='Corrupted UUE code in file "'AttachName'" section 'SecNumber' !'
                  say msg; say; call ToLog msg
                  drop SectionStart. SectionEnd.
                  UUE=0; OkLines=0; UUESections=0; SectionsCount=0; WriteUUE=0
                end
          end
          if WriteUUE then call funcWriteUUE
        end
      else
        if s='end' then
          do
            Buffer=CharIn(MessageFile,StartBlockFPos,LastFPos-StartBlockFPos)
            call SaveFile UUEstr
            SingleUUE=0; UUE=0; OkLines=0
          end
        else
          if Verify(s,ABCUUE)=0 then call ProgressIndicator
          else
            do
              if OkLines>999 then say
              msg='Corrupted UUE code in file "'AttachName'" !'
              say msg; say; call ToLog msg
              SingleUUE=0; UUE=0; OkLines=0
            end
      iterate
    end
  else
    if \Base64 then
      do
        parse var s Begin' 'Number' 'FName' 'tmp
        if Begin='begin' then
          do
            SingleUUE=1; UUE=1
          end
        if Begin='section' & FName='of' then
          do
            parse var s 'section 'SecNumber' of 'SecQuantity' of file 'FName' 'tmp
            if \Datatype(FName,'n') then
              do
                i=Pos('of file',s)
                if i>0 then FName=Strip(Right(s,Length(s)-i-7))
                if Left(FName,1)\='"' & Right(FName,1)\='"' & Pos(' ',FName)>0 then parse var FName FName' 'tmp
                else
                  if Left(FName,1)='"' then FName=Left(FName,Pos('"',FName,2))
                if FName='' then
                  do
                    i=Pos('file:',s)
                    FName=Strip(Right(s,Length(s)-i-5))
                    parse var FName FName','tmp
                  end
              end
            UUESections=1; UUE=1; SingleUUE=0
          end
        FName=Strip(Translate(FName,' ','"'))
        if UUE then
          do
            push UUESections
            if SectionsCount>0 & \DataType(SecQuantity,'N') & AttachName\=FileSpec('NAME',FName) then call funcWriteUUE
            pull UUESections
            StartBlockFPos=Stream(MessageFile,'C','SEEK')
            OldAttachName=AttachName
            AttachName=FileSpec('NAME',FName)
            if SectionsCount=0 then
              do
                if AttachName\=OldAttachName then
                  do
                    call FoundFile; call FileFormat(UUEstr)
                  end
                if \DataType(SecQuantity,'N') & \SingleUUE then
                  do
                    say 'UUE file "'AttachName'" has no total section count.'
                    say 'And it may be corrupted after decoding in some mixed cases!'
                  end
                call Time('R')
              end
            OkLines=0; UUE=1
            iterate
          end
      end
  if Verify(s,ABCBase64)=0 then
    do
      if \Base64 then
        if (Length(s)>40) | (AttachName\='') then
          do
            StartBlockFPos=LastFPos; Base64=1; call Time('R')
          end
      call ProgressIndicator
      if notEof then iterate
    end
  if Base64 then
    do
      if AttachName\='' then SaveB64=1
      else
        if OkLines>1 then SaveB64=1
        else SaveB64=0
      if SaveB64 then
        do
          Buffer=CharIn(MessageFile,StartBlockFPos,LastFPos-StartBlockFPos)
          call SaveFile B64str
        end
      Base64=0; OkLines=0
    end
  else
    do
      do while Right(s,1)=';'
        if Lines(MessageFile)=0 then leave
        s=s''LineIn(MessageFile)
      end
      Ups=Strip(Translate(s)); p1=Pos('NAME=',Ups)
      if Abbrev(Ups,'CONTENT-TYPE: MULTIPART/MIXED') then
        do
          boundary=''
          parse var Ups tmp'BOUNDARY="'boundary'"'
          if boundary\='' then PartStr='--'boundary
          iterate
        end
      if (Abbrev(Ups,'CONTENT-TYPE:') | Abbrev(Ups,'CONTENT-DISPOSITION: ATTACHMENT')) & p1>0 then
        do
          OldAttachName=AttachName
          AttachName=Right(s,Length(s)-p1-4)
          if Pos('"',AttachName)>0 then parse var AttachName '"'AttachName'"'tmp
          if Pos('?',AttachName)>0 then
            do
              parse var AttachName tmp'?'CodePage'?'Type'?'AttachName'?'tmp
              CodePage=Translate(CodePage)
              select
                when Type='Q' then AttachName=RXdeQuoted(AttachName)
                when Type='B' then AttachName=RXB64decode(AttachName)
                when Type='U' then AttachName=RXUUdecode(AttachName)
                otherwise
              end
              if Pos('1251',CodePage)>0 then AttachName=RXreCode(3,1,AttachName)
              if Pos('878',CodePage)>0 | Pos('KOI8-R',CodePage)>0 then AttachName=RXreCode(4,1,AttachName)
            end
          AttachName=FileSpec('NAME',AttachName)
          if OldAttachName\=AttachName then call FoundFile
          iterate
        end
      if Abbrev(Ups,'CONTENT-TRANSFER-ENCODING:') & SingleUUE then
        do
          parse var Ups tmp': 'MimeFormat
          select
            when MimeFormat=UpB64str then call FileFormat(B64str)
            when MimeFormat=UpXUUEstr then call FileFormat(UUEstr)
            when MimeFormat=UpQPstr then call FileFormat(QPstr)
            when MimeFormat=UpBit7str then call FileFormat(Bit7str)
            when MimeFormat=UpBit8str then call FileFormat(Bit8str)
            otherwise call FileFormat(Unknown)
          end
          iterate
        end
      if Abbrev(Ups,PartStr) & Pos(' ',s)=0 then
        do
          MimeFormat=''; AttachName=''
        end
    end
end
call Stream MessageFile,'C','CLOSE'

if UUESections then
  if SectionsCount>0 & \DataType(SecQuantity,'N') then call funcWriteUUE
  else
    do
      if OkLines>999 then say
      msg='Some UUE sections are absent in file "'AttachName'" !'
      say msg; say; call ToLog msg
    end

say 'Done.'
exit


/*--------------------------------------------------------------*/
/* Internal program functions                                   */
/*--------------------------------------------------------------*/

CheckIsFile:
parse arg infile
p=''; ext='';file.0=1
do until \file.0
  call SysFileTree infile''p''ext,file,'BO'
  if file.0 then
    do
      p='.'
      if ext='' then ext=1
      else ext=ext+1
    end
end
return infile''p''ext

funcWriteUUE:
CanSave=1
do i=1 to SectionsCount
  if \DataType(SectionStart.i,'N') | \DataType(SectionEnd.i,'N') then
    do
      CanSave=0
      leave
    end
end
if CanSave then
  do
    LastFPos=Stream(MessageFile,'C','SEEK')
    Buffer=''
    do i=1 to SectionsCount
      Buffer=Buffer''CharIn(MessageFile,SectionStart.i,SectionEnd.i-SectionStart.i)
    end
    call SaveFile UUEstr
    if LastFPos\='' then call Stream MessageFile,'C','SEEK ='LastFPos
  end
drop SectionStart. SectionEnd.
UUE=0; OkLines=0; UUESections=0; SectionsCount=0; WriteUUE=0; SingleUUE=0
return

SaveFile:
parse arg CodeType
if AttachName='' then AttachName=CheckIsFile(DecodeDir''NoNameFile)
else AttachName=CheckIsFile(DecodeDir''AttachName)
if CodeType=B64str then Buffer=RXB64decode(Buffer)
if CodeType=UUEstr then Buffer=RXUUdecode(Buffer)
if CodeType=QPstr then Buffer=RXdeQuoted(Buffer)
if Buffer\='' then
  do
    if OkLines>999 then say
    call CharOut ,'Saving file ('CodeType'): "'AttachName'"'
    call CharOut AttachName,Buffer; Buffer=''
    if result>0 then
      do
        msg='Unable to write file "'AttachName'" !'
        say; say msg; call ToLog msg
      end
    else 
      do
        if CodeType=B64str | CodeType=UUEstr then decstr=' for decoding'
        else decstr=''
        say '  Ok! ('Format(Time('R'),,2)' sec.'decstr')'
      end
    call Stream AttachName,C,'CLOSE'
  end
AttachName=''
if UUE then UUESections=0
say
return

ProgressIndicator:
OkLines=OkLines+1
if ProgressIndicator='YES' then if Format(OkLines/1000,,0)*1000=OkLines then call CharOut ,'.'
return

FoundFile:
say 'Found file "'AttachName'".'
return

FileFormat:
parse arg format
if AttachName\='' then say 'File format "'format'".'
return

ToLog:
parse arg args
if Space(LogFile)='' then return
str=date('E')' 'time()'  'MessageFile': 'args
call LineOut LogFile,str
return

Halt:
say; say 'Program has been terminated by pressing Ctrl-C ...'
exit
