#define INCL_DOS
#define INCL_DOSERRORS
#include <os2.h>

#ifndef HF_STDERR
#define HF_STDERR 2
#endif

static const char szLaunch[] = "nkf.exe";

#define MYSTRLEN_MAX 65536
static int
mystrlen(const char *s)
{
  int n;
  for(n=0 ;s[n] && n < MYSTRLEN_MAX ;n++);
  return n;
}

#define myCharNext(p) ((p) + 1)
static char *
mystrrchr(const char *s, int c)
{
  char *p;
  for(p = 0; s && *s; s = myCharNext(s)) {
    if ((int)*s == c) p = (char *)s;
  }
  return p;
}

static char *
mystrcpy(char *d, const char *s)
{
  int n;
  for(n=0; (d[n] = s[n]) != '\0'; n++);
  return d;
}


void
puterr(const char *s)
{
  ULONG ul;
  APIRET rc;
  
  rc = DosWrite(HF_STDERR, (PVOID)s, mystrlen(s), &ul);
}


void
puterrn()
{
  puterr("\r\n");
}

#if 1
void
puterr_dec(int n)
{
  char s[32];
  char *p = &s[sizeof(s)-1];
  int m;
  for(*p = '\0'; p>&s[0];) {
    m = n % 10;
    n /= 10;
    if (m == 0 && n == 0) break;
    *--p = '0' + m;
  }
  puterr( *p ? p : "0");
}
#endif

int APIENTRY os2_myAppEntry(HMODULE hm, ULONG ulReserved, PSZ pszEnv, PSZ pszCmd)
{
  char szexe[260];
  char szerr[260];
  char *fn;
  RESULTCODES exrc;
  APIRET rc;
  
  szexe[0] = '\0';
  DosQueryModuleName(hm, sizeof(szexe), (PCHAR)szexe);
  fn = mystrrchr(szexe, '\\');
  mystrcpy(fn ? fn+1 : szexe, szLaunch);
  
  rc = DosExecPgm(szerr, sizeof(szerr), EXEC_SYNC, pszCmd, 0, &exrc, szexe);
  if (rc != 0) {
    puterr("Can't load ");
    puterr(szerr);
    puterr(" (DosExecPgm rc=");
    puterr_dec(rc);
    puterr(")\r\n");
    exrc.codeTerminate = 0;
    exrc.codeResult = rc;
  }
  else {
    if (exrc.codeTerminate != 0) exrc.codeResult = 127;
  }
  DosExit(EXIT_PROCESS, exrc.codeResult);
  
  return 0;
}
