/*
 * tablet.h - definitions for 'tablet' program
 */

#ifndef _TABLET_H
#define _TABLET_H

#ifdef  DEBUG
#define TRACE   printf
#else
#define TRACE
#endif

/*
 * program's path, name and profile
 */

extern  UCHAR   ProgramPath[] ;
extern  UCHAR   ProgramName[] ;
extern  UCHAR   ProfilePath[] ;

void    errMessage(PSZ msg) ;   /* notify error with MessageBox */

/*
 * read/save profile data
 */
 
void    profileRead(HAB hab, PSWP pswp, PUCHAR pfnt, PULONG pclr) ;
void    profileSave(HAB hab, PSWP pswp, PUCHAR pfnt, PULONG pclr) ;

/*
 * internal representation of tables
 */

typedef struct _LINE    *LINEPTR ;

typedef struct _LINE {
    LINEPTR     next ;
    PUCHAR      data ;
} LINEREC ;

typedef struct _TABL    *TABLPTR ;

typedef struct _TABL {
    TABLPTR     prev ;
    TABLPTR     next ;
    PUCHAR      name ;
    LINEPTR     line ;
} TABLREC ;

/*
 * functions to build/access to table
 */

BOOL    tableLoad(PUCHAR name) ;
void    tableDone(void) ;

TABLPTR tableOpen(void) ;
TABLPTR tableName(PUCHAR name) ;
TABLPTR tablePrev(TABLPTR tab) ;
TABLPTR tableNext(TABLPTR tab) ;

TABLPTR tableSelect(HWND hwnd, TABLPTR cur) ;

/*
 * functions to create/destory window
 */

BOOL    winCreate(HAB hab, TABLPTR tab, PSWP swp, PUCHAR fnt, PULONG clr) ;
void    winDestroy(void) ;

void    winQueryCharSize(PSIZEL sz) ;

/*
 * managing target of operation
 */

BOOL    targetInit(HWND hwnd) ;
void    targetDone(HWND hwnd) ;

void    targetPlace(SHORT cx, SHORT cy, SHORT height) ; 
void    targetChange(SHORT target, HWND frame, HWND client) ;

void    targetTrackStart(HWND hwnd) ;
BOOL    targetTrackTrace(HWND hwnd, SHORT x, SHORT y) ;
BOOL    targetTrackDone(HWND hwnd) ;

void    targetSendChar(PUCHAR pch) ;
void    targetEdit(SHORT op) ;

SHORT   targetQueryType(void)      ;
SHORT   targetQuerySelection(void) ;

/*
 * managing tablet display
 */

BOOL    dispInit(HWND hwnd) ;
void    dispDone(HWND hwnd) ;

void    dispChangeSize(SHORT cx, SHORT cy, SHORT height) ;
void    dispCalcSize(TABLPTR tab) ;

BOOL    dispScrollHorz(USHORT cmd, SHORT pos) ;
BOOL    dispScrollVert(USHORT cmd, SHORT pos) ;

void    dispPaintTablet(HPS hps, TABLPTR tab, PRECTL rct) ;
BOOL    dispHitChar(HPS hps, TABLPTR tab, SHORT x, SHORT y, PUCHAR buff) ;

/*
 * magnify character
 */

void    magnifyChar(HWND hwnd, PUCHAR ch, PUCHAR fnt, PULONG clr) ;

/*
 * manages font to use
 */

BOOL    fontSetFont(HPS hps, PUCHAR fnt) ;

/*
 * manages color setting
 */

BOOL    colorInit(HPS hps) ;
BOOL    colorSetForeIndex(HPS hps, PULONG clr) ;
BOOL    colorSetBackIndex(HPS hps, PULONG clr) ;
BOOL    colorSetForeColor(HPS hps, PULONG clr) ;
BOOL    colorSetBackColor(HPS hps, PULONG clr) ;

#endif  /* _TABLET_H */
