/* Install/UnInstall script for Translation tool */

PARSE ARG action
IF RxFuncQuery('SysLoadFuncs') THEN DO
    CALL RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
    CALL SysLoadFuncs
END
CALL SysCls
action = TRANSLATE(LEFT(action,1))
SELECT
    WHEN action = 'I' THEN CALL InstallMe
    WHEN action = 'U' THEN CALL UnInstallMe
    OTHERWISE CALL WhatAction
END
Exit

/* End of Install.cmd */

/* WhatAction - no action selected */

WhatAction:     PROCEDURE

CALL SysCls
SAY ' '
SAY 'Please enter installation parameter (I=Install, U=UnInstall, other=Exit):'
ans = TRANSLATE(SysGetKey('ECHO'))
SELECT
    WHEN ans = 'I' THEN CALL InstallMe
    WHEN ans = 'U' THEN CALL UnInstallMe
    OTHERWISE CALL NoAction 'Installation failed.'
END
RETURN

/* End of WhatAction */

/* NoAction - abort Install */

NoAction:   PROCEDURE

PARSE ARG noinstmsg
SAY ' '
SAY noinstmsg
SAY 'Press any key to exit ...'
ans = SysGetKey('NOECHO')
Exit

/* End of NoAction */

/* InstallMe - install Translation tool */

InstallMe:  PROCEDURE

progname = 'Translation tool'
IF RIGHT(Directory(),2) = ':\' THEN DO
    SAY 'Problem! '||progname||' can not be installed in root directory.'
    SAY 'Create directory for '||progname||', copy files there and start this procedure again.'
    SAY 'Press any key to exit ...'
    ans = SysGetKey('NOECHO')
    Exit
END

CALL SysCls
SAY 'Welcome to '||progname||' Installation procedure!'
SAY 'This procedure will create Program object for '||progname||','
SAY 'Press "Y" to start Installation, any other key to exit...'
ans = TRANSLATE(SysGetKey('ECHO'))
SELECT
    WHEN ans = 'Y' THEN NOP
    OTHERWISE CALL NoAction 'Installation aborted.'
END
SAY ' '
IF STREAM('Translat.exe','C','QUERY EXISTS') = '' THEN DO
    CALL NoAction 'Translat.exe is missing! Installation failed.'
END
SAY ' '
InstallDir = Directory()
ProgTitle = progname||' 2.12.10'
Setup = 'OBJECTID=<TRANSLAT_PROG>;EXENAME='InstallDir'\Translat.exe;ICONFILE='InstallDir'\Translat.ico;STARTUPDIR='InstallDir''
Action = 'U'
dummy = SysCreateObject('WPProgram',ProgTitle,'<WP_DESKTOP>',Setup,Action)
SAY progname||' Program object - '||rc1(dummy)

SAY ' '
SAY 'Installation finished. Press Y to read Translat.txt, any other key to exit ...'
ans = TRANSLATE(SysGetKey('ECHO'))
IF ans = 'Y' THEN DO
    CALL SysOpenObject(Directory()||'\Translat.txt')
END
Exit

/* End of InstallMe */

/* UnInstallMe - uninstall Translation tool */

UnInstallMe: PROCEDURE

progname = 'Translation tool'
CALL SysCls
SAY 'This is '||progname||' UnInstallation procedure!'
SAY 'This procedure will destroy '||progname||' Program object'
SAY 'Press "Y" to start UnInstall, any other key to exit...'
ans = TRANSLATE(SysGetKey('ECHO'))
SELECT
    WHEN ans = 'Y' THEN NOP
    OTHERWISE CALL NoAction 'UnInstall aborted.'
END
SAY ' '
SAY 'Destroying Program object'
CALL SysDestroyObject '<TRANSLAT_PROG>'

SAY ' '
SAY 'UnInstallation complete.'
SAY 'You can delete files in directory '||Directory()
SAY 'To install '||progname||' again, start Install I. Press any key to exit...'
ans = SysGetKey('NOECHO')
Exit

/* End of UnInstallMe */

/* rc1 - return code - SysCreateObject */

rc1:        PROCEDURE

PARSE ARG rcSysCreateObject
SELECT
    WHEN rcSysCreateObject = 0 THEN rc1 = 'Error'
    OTHERWISE rc1 = 'OK'
END
RETURN rc1

/* End of rc1 */
