/* FansControl.CMD */

/* Dirty REXX script to control CPU & CASE Fans speed on W83627 equipped MoBos.
   This script isn't object oriented SOM compliant and CORBA based piece of 
   code. It is simple, dirty REXX written within few hours. If You have better
   ideas - feel free to add them here, but please don't use my name to firm 
   Yours ideas ;-).
   This software might be used at user own risks. Original author is not 
   responsible for any hardware damages or other undesired effect by using this 
   software. 
   Ok, that's all, and now feel free to contact me at "warpme@o2.pl"
*/


/* User provided parameters - START */

/* Server features */
SupportXcenterWidgets 		= 1
SupportWatchdog			= 1

/* Temperatures */
cbCPUTemp4MaxCpuFanSpeed 	= 65
cbCPUTemp4MinCpuFanSpeed 	= 40
cbCPUTemp4MaxCaseFanSpeed 	= 65
cbCPUTemp4MinCaseFanSpeed 	= 45

/* User provided parameters - END */


/* Hardware dependent user provided parameters - START */

/* PWM values for CPU FAN percentage power to PWM conversion/linearization */
cbPwmFor5CpuFanPower  = 7		/* 1250 */
cbPwmFor10CpuFanPower = 7		/* 1300 */
cbPwmFor15CpuFanPower = 7		/* 1400 */
cbPwmFor20CpuFanPower = 8		/* 1500 */
cbPwmFor25CpuFanPower = 8		/* 1600 */
cbPwmFor30CpuFanPower = 9		/* 1700 */
cbPwmFor35CpuFanPower = 10		/* 1800 */
cbPwmFor40CpuFanPower = 11		/* 1900 */
cbPwmFor45CpuFanPower = 12		/* 2000 */
cbPwmFor50CpuFanPower = 14		/* 2100 */
cbPwmFor55CpuFanPower = 16		/* 2200 */
cbPwmFor60CpuFanPower = 18		/* 2300 */
cbPwmFor65CpuFanPower = 20		/* 2400 */
cbPwmFor70CpuFanPower = 24		/* 2500 */
cbPwmFor75CpuFanPower = 30		/* 2600 */
cbPwmFor80CpuFanPower = 40		/* 2700 */
cbPwmFor85CpuFanPower = 65		/* 2800 */
cbPwmFor90CpuFanPower = 128		/* 2900 */
cbPwmFor95CpuFanPower = 192		/* 2950 */
cbPwmFor100CpuFanPower = 255		/* 3000 */

/* PWM values for CASE FAN percentage power to PWM conversion/linearization */
cbPwmFor10CaseFanPower = 1		/* 1300 */
cbPwmFor20CaseFanPower = 2		/* 1500 */
cbPwmFor30CaseFanPower = 4		/* 1700 */
cbPwmFor40CaseFanPower = 6 		/* 1900 */
cbPwmFor50CaseFanPower = 8 		/* 2100 */
cbPwmFor60CaseFanPower = 10		/* 2300 */
cbPwmFor70CaseFanPower = 14		/* 2500 */
cbPwmFor80CaseFanPower = 16		/* 2700 */
cbPwmFor90CaseFanPower = 20		/* 2900 */
cbPwmFor100CaseFanPower = 255		/* 3000 */

/* Hardware dependent user provided parameters - END */
















/* Initialize REXXUTIL.DLL */
call RxFuncAdd 'SysLoadFuncs', 'rexxutil', 'SysLoadFuncs'
call 'SysLoadFuncs'

/* Initialize RXPORTIO.DLL */
CALL RXFuncAdd 'PIOLoadFuncs', 'RXPORTIO', 'PIOLoadFuncs'
CALL PIOLoadFuncs 

/* Initialize StHealth.DLL */
Call RxFuncAdd 'StHealthLoadFuncs', 'StHealth', 'StHealthLoadFuncs'
Call StHealthLoadFuncs


/* Hardware adresses & constant definitions */

cbW83627_BankSelIndex = X2D('4e')
cbW83627_Bank0Selector = 0
cbW83627_Bank1Selector = 1
cbW83627_TempHiByteIndex = X2D('50')
cbW83627_TempLoByteIndex = X2D('51')
cbW83627_PWM1CtrlIndex = X2D('5A')
cbW83627_PWM2CtrlIndex = X2D('5B')
cbW83627_FAN1Index = X2D('28')
cbW83627_FAN2Index = X2D('29')
cbW83627_TempIndex = X2D('27')
cbW83627_IndexPort = X2D('295')
cbW83627_DataPort = X2D('296')
Ht = cbCPUTemp4MaxCpuFanSpeed
Lt = cbCPUTemp4MinCpuFanSpeed
Ht1 = cbCPUTemp4MaxCaseFanSpeed
Lt1 = cbCPUTemp4MinCaseFanSpeed

/* Main program */ 

If SupportXcenterWidgets = 1 then
  do
    /* Deleting Queues if previous VIO seesion with this script was killed */
    newq = RXQUEUE('Delete',CpuFanMonitor)
    newq = RXQUEUE('Delete',CaseFanMonitor)
    /* Creating quesues for Watchdog & Xcenter GAUGE widgets */
    newq = RXQUEUE('Create',CpuFanMonitor)
    newq = RXQUEUE('Create',CaseFanMonitor)
  end

If SupportWatchdog = 1 then
  do 
    /* Deleting Queues if previous VIO seesion with this script was killed */
    newq = RXQUEUE('Delete',WatchDog)
    /* Creating quesues for Watchdog & Xcenter GAUGE widgets */
    newq = RXQUEUE('Create',WatchDog)
  end

/* Here is script's main loop */
DO Forever

/* Reading CPU temperature from hardware */
Ct=StHealthValue(TEMP,2,TRUE)

/* Computing percentage power for FAN CPU */ 
bCurrentCpuFanPower = ((Ct-Lt)/(Ht-Lt))*100
if bCurrentCpuFanPower < 0 then bCurrentCpuFanPower = 0
if bCurrentCpuFanPower > 100 then bCurrentCpuFanPower = 100

/* Computing percentage power for CASE CPU */ 
bCurrentCaseFanPower = ((Ct-Lt1)/(Ht1-Lt1))*100
if bCurrentCaseFanPower < 0 then bCurrentCaseFanPower = 0
if bCurrentCaseFanPower > 100 then bCurrentCaseFanPower = 100

/* Conversion percentage power to PWM for CPU FAN MoBo output */ 
Select
	When bCurrentCpuFanPower < 5 then bPwm1Value = cbPwmFor5CpuFanPower
	When bCurrentCpuFanPower < 10 then bPwm1Value = cbPwmFor10CpuFanPower
	When bCurrentCpuFanPower < 15 then bPwm1Value = cbPwmFor15CpuFanPower
	When bCurrentCpuFanPower < 20 then bPwm1Value = cbPwmFor20CpuFanPower
	When bCurrentCpuFanPower < 25 then bPwm1Value = cbPwmFor25CpuFanPower
	When bCurrentCpuFanPower < 30 then bPwm1Value = cbPwmFor30CpuFanPower
	When bCurrentCpuFanPower < 35 then bPwm1Value = cbPwmFor35CpuFanPower
	When bCurrentCpuFanPower < 40 then bPwm1Value = cbPwmFor40CpuFanPower
	When bCurrentCpuFanPower < 45 then bPwm1Value = cbPwmFor45CpuFanPower
	When bCurrentCpuFanPower < 50 then bPwm1Value = cbPwmFor50CpuFanPower
	When bCurrentCpuFanPower < 55 then bPwm1Value = cbPwmFor55CpuFanPower
	When bCurrentCpuFanPower < 60 then bPwm1Value = cbPwmFor60CpuFanPower
	When bCurrentCpuFanPower < 65 then bPwm1Value = cbPwmFor65CpuFanPower
	When bCurrentCpuFanPower < 70 then bPwm1Value = cbPwmFor70CpuFanPower
	When bCurrentCpuFanPower < 75 then bPwm1Value = cbPwmFor75CpuFanPower
	When bCurrentCpuFanPower < 80 then bPwm1Value = cbPwmFor80CpuFanPower
	When bCurrentCpuFanPower < 85 then bPwm1Value = cbPwmFor85CpuFanPower
	When bCurrentCpuFanPower < 90 then bPwm1Value = cbPwmFor90CpuFanPower
	When bCurrentCpuFanPower < 95 then bPwm1Value = cbPwmFor95CpuFanPower
	When bCurrentCpuFanPower < 100 then bPwm1Value = cbPwmFor100CpuFanPower

  Otherwise
	bPwm1Value=255
End

/* Setting Winbond83627 PWM1 registers to desired PWM */
if bPwm1Value <> vOldPwm1Value then 
  do
    call rW83627_SetPWM 'PWM1',bPwm1Value
    vOldPwm1Value = bPwm1Value
    Beep(2000,1)
  end

/* Conversion percentage power to PWM for CPU FAN MoBo output */  
Select
	When bCurrentCaseFanPower < 10 then bPwm2Value = cbPwmFor10CaseFanPower
	When bCurrentCaseFanPower < 20 then bPwm2Value = cbPwmFor20CaseFanPower
	When bCurrentCaseFanPower < 30 then bPwm2Value = cbPwmFor30CaseFanPower
	When bCurrentCaseFanPower < 40 then bPwm2Value = cbPwmFor40CaseFanPower
	When bCurrentCaseFanPower < 50 then bPwm2Value = cbPwmFor50CaseFanPower
	When bCurrentCaseFanPower < 60 then bPwm2Value = cbPwmFor60CaseFanPower
	When bCurrentCaseFanPower < 70 then bPwm2Value = cbPwmFor70CaseFanPower
	When bCurrentCaseFanPower < 80 then bPwm2Value = cbPwmFor80CaseFanPower
	When bCurrentCaseFanPower < 90 then bPwm2Value = cbPwmFor90CaseFanPower
	When bCurrentCaseFanPower < 100 then bPwm2Value = cbPwmFor100CaseFanPower

    Otherwise
	bPwm2Value=255
End

/* Setting Winbond83627 PWM2 registers to desired PWM */
if bPwm2Value <> vOldPwm2Value then 
  do
    call rW83627_SetPWM 'PWM2',bPwm2Value
    vOldPwm2Value = bPwm2Value
  end

/* Reading CPU Fan speed form W83627 */
Fan1Speed=StHealthValue(FAN,1,TRUE)

/* Reading CASE Fan speed form W83627 */
Fan2Speed=StHealthValue(FAN,2,TRUE)

/* Saying some unimportant infos */
Call SysCls
SAY '                                          '
SAY '   Current CPU Temperature settings:      '
SAY '                                          '
SAY '    For Max CPU FAN speed:       ' || Ht  ||' C     '
SAY '    For Max CASE FAN speed:      ' || Ht1 ||' C     '
SAY '    For Min CPU FAN speed:       ' || Lt  ||' C     '
SAY '    For Min CASE FAN speed:      ' || Lt1 ||' C     '
SAY '                                          '
SAY '                                          '
SAY '                                          '
SAY '   Current parameters:                    '
SAY '                                          '
SAY '    Current CPU Temp:            ' || Ct  ||' C     '
SAY '                                          '
SAY '    Current CPU FAN power:       ' ||  Format(bCurrentCpuFanPower,,0) ||' %     '
SAY '    Current CPU FAN RPM:         ' ||  Format(Fan1Speed,,0) ||' RPM '
SAY '    PWM1:                        ' || bPwm1Value
SAY '                                          '
SAY '    Current CASE FAN power:      ' ||  Format(bCurrentCaseFanPower,,0) ||' %     '
if Fan2Speed <> -1 then
SAY '    Current CASE FAN RPM:        ' ||  Format(Fan2Speed,,0) ||' RPM '
SAY '    PWM2:                        ' || bPwm2Value
SAY '                                          '
SAY '_________________________________         '
SAY '(c) Piotr Oniszczuk, warpme@o2.pl         '

/* Xcenter widgets server functions support */
If SupportXcenterWidgets = 1 then
  do
    /* Push in Cpu Xcenter widget queue info about curr. temp, power and spped */
    oq = RXQUEUE('Set',CpuFanMonitor)
    push Ct 'C | CPU:' Format(bCurrentCpuFanPower,,0)'%(' Format(Fan1Speed,,0) ' RPM)'
    /* Push in Case Xcenter widget queue info about curr. power and spped */
    if Fan2Speed = -255 then 
      CaseGaugeSteem = ' Case:' Format(bCurrentCaseFanPower,,0)'%'
    else
      CaseGaugeSteem = ' Case:' Format(bCurrentCaseFanPower,,0)'%('Format(Fan2Speed,,0) 'RPM)'
    oq = RXQUEUE('Set',CaseFanMonitor)
    push CaseGaugeSteem
  end

/* Watchdog widgets server functions support */
If SupportWatchdog = 1 then
  do 
    /* Push in Watchdog queue refresh message */
    oq = RXQUEUE('Set',WatchDog)
    push 'Alive'
  end

/* Well, now do nothing by some time */
Call SysSleep(5)

End /* Main program loop */

Exit

















/* ------------------------------------Help Routines--------------------------*/

rW83627_SetPWM:
/* Routine for setting PWM.
   Calling:
     rW83627_SetPWM 'PWM1'[PWM2]
*/
	PwmValue=Arg(2)

	/* Saving IndexReg and CurrBankSel */
	sReturnData = PIORead( cbW83627_IndexPort)
	PARSE VAR sReturnData . ': ' temp1 . ': ' temp2 
	sReturnData = PIOWrite( cbW83627_IndexPort, cbW83627_BankSelIndex)
	sReturnData = PIORead( cbW83627_DataPort)
	PARSE VAR sReturnData . ': ' temp1 . ': ' temp3 

	/* Writing nwe PWM value to chip */
	sReturnData = PIOWrite( cbW83627_IndexPort, cbW83627_BankSelIndex)
	sReturnData = PIOWrite( cbW83627_DataPort, cbW83627_Bank0Selector)
	if Arg(1) = 'PWM2' 
	  then
	    sReturnData = PIOWrite( cbW83627_IndexPort, cbW83627_PWM2CtrlIndex)
	  else
	    sReturnData = PIOWrite( cbW83627_IndexPort, cbW83627_PWM1CtrlIndex)
        sReturnData = PIOWrite( cbW83627_DataPort, PwmValue)

	/* Restoring CurrBankSel and IndexReg */
	sReturnData = PIOWrite( cbW83627_IndexPort, cbW83627_BankSelIndex)
	sReturnData = PIOWrite( cbW83627_DataPort, temp3)
	sReturnData = PIOWrite( cbW83627_IndexPort, temp2)
return

rW83627_ReadFAN:
/* Routine for reading FAN speed.
   Calling:
     rW83627_ReadFAN 'FAN1'[FAN2]
   Result:
     variable FanSpeed has current fan speed.
   For unreliable levels of FAN techometer line (speeds below 1350 RPM and 
   above 8000) function returns -1	
*/

	/* Saving IndexReg */
	sReturnData = PIORead( cbW83627_IndexPort)
	PARSE VAR sReturnData . ': ' temp1 . ': ' temp2 

	/* Reading FAN value from chip */
	if Arg(1)= "FAN2"
	 then 
	   sReturnData = PIOWrite( cbW83627_IndexPort, cbW83627_FAN2Index)
	 else
	   sReturnData = PIOWrite( cbW83627_IndexPort, cbW83627_FAN1Index)
	sReturnData = PIORead( cbW83627_DataPort )
	PARSE VAR sReturnData . ': ' temp1 . ': ' temp3 

	/* Restoring IndexReg */
	sReturnData = PIOWrite( cbW83627_IndexPort, temp2)

	/* if chip is receiv. to low signal, temp3 is usual below above 250 */
	if temp3 > 250 then temp3 = -337500 /* below 1350 */
	if temp3 < 37 then temp3 = -337500 /* above 9000 */; 

	FanSpeed = 1350000 / (temp3*4)
return

rW83627_ReadTemp:
/* Routine for reading Temperature.
   Calling:
     rW83627_ReadTemp 'TEMP1'[TEMP2]
   Result:
     variable Temperature has current temperature.
*/

	/* Saving IndexReg and CurrBankSel */
	sReturnData = PIORead( cbW83627_IndexPort)
	PARSE VAR sReturnData . ': ' temp1 . ': ' temp2 
	sReturnData = PIOWrite( cbW83627_IndexPort, cbW83627_BankSelIndex)
	sReturnData = PIORead( cbW83627_DataPort)
	PARSE VAR sReturnData . ': ' temp1 . ': ' temp3 

	/* Reading FAN value from chip */
	if Arg(1)= "TEMP2"
	 then 
	   do 
             sReturnData = PIOWrite( cbW83627_IndexPort, cbW83627_TempIndex)
	     sReturnData = PIORead( cbW83627_DataPort )
	     PARSE VAR sReturnData . ': ' temp1 . ': ' Temperature
	   end	
	 else
	   do			
	     sReturnData = PIOWrite( cbW83627_IndexPort, cbW83627_BankSelIndex)
	     sReturnData = PIOWrite( cbW83627_DataPort, cbW83627_Bank1Selector)
	     sReturnData = PIOWrite( cbW83627_IndexPort, cbW83627_TempHiByteIndex)
	     sReturnData = PIORead( cbW83627_DataPort )
	     PARSE VAR sReturnData . ': ' temp1 . ': ' Temperature 
	     sReturnData = PIOWrite( cbW83627_IndexPort, cbW83627_TempLoByteIndex)
	     sReturnData = PIORead( cbW83627_DataPort )
	     PARSE VAR sReturnData . ': ' temp1 . ': ' Temp4 
	     Temperature = Temperature + (Temp4/256)
	   end

	/* Restoring CurrBankSel and IndexReg */
	sReturnData = PIOWrite( cbW83627_IndexPort, cbW83627_BankSelIndex)
	sReturnData = PIOWrite( cbW83627_DataPort, temp3)
	sReturnData = PIOWrite( cbW83627_IndexPort, temp2)
return

