/* Change the date/time stamp for a file  */

/* First, make sure the additional rexx utilities are loaded */
if RxFuncQuery("SysLoadFuncs") then do
   call RxFuncAdd "SysLoadFuncs", RexxUtil, "SysLoadFuncs"
   call SysLoadFuncs
end

arg fileid fdate ftime indicator . '(' option
option = translate(strip(option))
if fileid = "" | fileid = "?" then do
   say 'Fixes the date/time stamp of a file or list of files'
   say 'For individual file:'
   say '   fileName month/day/year hour:minute:second <AM/PM>'
   say '      where AM/PM indicator is optional,  24 hour clock assumed'
   say '      defaults to current date and time if both date/time missing'
   say '      defaults to 12:00:00 if date given but time is not given'
   say '   Note, fileName can be a file mask and all files matching that'
   say '     pattern in a directory will be set to the specified date/time.'
   say 'For list of files:'
   say '   list_fileName  ( list'
   exit 100
end

count = 0

If pos('LIST',option) <> 0 Then Do
   list = fileid
   Do until substr(stream(list,"D"),1,8) = 'NOTREADY'
      data_line = linein(list)

      If left(data_line,1) = '*' Then iterate

      If pos('"',data_line) > 0 Then Do
         parse var data_line '"' fileid '"' .'"' fdate ftime indicator . '"' .
      End
      Else Do
         parse var data_line fileid fdate ftime indicator .
      End
      If fdate = "" & length(word(data_line,1)) = 10 & length(word(data_line,4)) = 5 Then Do
         parse var data_line fdate ftime fsize fattr .
         indicator = ""
      End
      if words(fileid) = 1
         then call ChangeIt fileid fdate ftime indicator
      if trunc(count/150) * 150 = count
         then say "processed" count "files"
   End
End
Else Do
   if pos("*",fileid) > 0 Then Do
      rc = SysFileTree(fileid, list, 'FO')
      Do i = 1 to list.0
         parse var list.i fileid .
         call ChangeIt fileid fdate ftime indicator
      End
   End
   Else call ChangeIt fileid fdate ftime indicator
End

say count 'files changed'

exit

ChangeIt: procedure expose count
   arg fileid fdate ftime indicator
   if fdate = '' then do
      fdate = date('US')
      ftime = time();
   end

   If pos('-',fdate) > 0 then do
      parse var fdate mm "-" dd "-" yyyy
      if mm > 12
         then parse var fdate yyyy "-" mm "-" dd
   End
      Else parse var fdate mm "/" dd "/" yyyy

   If yyyy < "1980" Then Do
      if yyyy < "80"
         then yyyy = "20"||yyyy
         else yyyy = "19"||yyyy
   End

   if ftime = "" then ftime= "12:00:00"
   parse var ftime hr ":" min ":" sec
   if min = '' then min = 0
   if sec = '' then sec = 0
   if translate(strip(indicator)) = 'PM' & hr < 12 then hr = hr + 12
   if translate(strip(indicator)) = 'AM' & hr = 12 then hr = 0

   nDate = yyyy||"-"||mm||"-"||dd
   nTime = hr||":"||min||":"sec
   x= SysSetFileDateTime(fileid,nDate,nTime)
   if x  <> 0 then do;
      say "Return code from SysSetFileDateTime is" x "for" fileid nDate nTime
      say "Press ENTER to resume..."
      pull ok
   end
   else count = count + 1
return
