/* $Id: asm2code.c,v 1.2 2001/07/18 21:30:13 root Exp $ */

#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define INCL_BASE
#include <os2.h>

#include "patchtkt.h"

#define LINESIZE                 512

/* External symbol structure that we don't care about */

struct extsym
{
 char *name;
 struct extsym *next;
};

/* Relocation job */

struct job
{
 char *vp;
 char *refarea;
 unsigned long vpofs;
 unsigned int vps;
 unsigned int refarea_ofs;
 unsigned int refarea_s;
};

/* Work files */

#define TMP_FILE           "tmp_asm"
#define TMP_ASM      TMP_FILE ".asm"
#define TMP_OBJ      TMP_FILE ".obj"
#define TMP_COM      TMP_FILE ".com"

/* Shift-outs to reveal relocations */

static unsigned short pregap_size[]={0x0101, 0x0202};
static unsigned short postgap_size[]={0x0404, 0x0808};

/* Program launcher */

int exec_pgm(char *cmdline)
{
 char tmp_cmd[256+CCHMAXPATH];
 char *params;
 int p_pos;
 RESULTCODES rc;
 struct job j[2];

 printf("--- %s\n", cmdline);
 memset(tmp_cmd, 0, sizeof(tmp_cmd));
 if((params=strchr(cmdline, ' '))!=NULL)
 {
  p_pos=params-cmdline;
  if(p_pos>0)
   memcpy(tmp_cmd, cmdline, p_pos);
  strcpy(tmp_cmd+p_pos+1, params);
 }
 else
  strcpy(tmp_cmd, cmdline);
 if(!DosExecPgm(NULL, 0, EXEC_SYNC, tmp_cmd, NULL, &rc, tmp_cmd))
 {
  if(rc.codeResult!=0)
   printf("!!! Return code was %d\n", rc.codeResult);
  return(rc.codeResult);
 }
 else
 {
  printf("Can't execute!");
  return(-1);
 }
}

/* External symbol lookup */

static struct extsym *find_esym(struct extsym *first, char *name)
{
 struct extsym *tmp;

 for(tmp=first; tmp!=NULL; tmp=tmp->next)
 {
  if(!strcmp(name, tmp->name))
   break;
 }
 return(tmp);
}

/* Main routine */

int main(int argc, char **argv)
{
 FILE *istream, *ostream, *tstream;
 static char buf[LINESIZE], expr[LINESIZE];
 struct extsym *esym=NULL, *esym_tmp;
 char *p, *ep;
 /* Pass 1 / pass 2 data */
 int pass;
 int s;
 int rc=0;
 short r1, r2;
 int reloc;
 struct job j[2];

 printf("ASM2CODE v 1.01 on " __DATE__ ", " __TIME__ "\n\n");
 if(argc<3)
 {
  printf("Usage: %s <filename.asm> <filename.c>\n"
         "\n"
         "Where: <filename.asm> is the source piece of code to be translated\n"
         "       <filename.c>   is a resulting piece of C code\n",
         argv[0]);
  exit(1);
 }
 istream=file_open(argv[1], "r");
 /* Browse the source code and create extsyms from EX_ */
 while(fgets(buf, LINESIZE, istream)!=NULL)
 {
  p=buf+1;                               /* Allow for safe isalnum(p-1) */
  while((p=strstr(p, "EX_"))!=NULL)
  {
   for(ep=p; iscsym(*ep); ep++);
   if(!iscsym(*(p-1)))
   {
    memcpy(expr, p, ep-p);
    expr[ep-p]='\0';
    /* New symbol? */
    if(find_esym(esym, expr)==NULL)
    {
     esym_tmp=(struct extsym *)malloc(sizeof(struct extsym));
     esym_tmp->name=strdup(expr);
     esym_tmp->next=esym;
     esym=esym_tmp;
    }
   }
   p=ep;
  }
 }
 /* Compilation passes */
 for(pass=0; pass<2; pass++)
 {
  printf("*** PASS %d\n", pass+1);
  /* Create header */
  ostream=file_open(TMP_ASM, "w");
  fprintf(ostream,
          ".386\n\n"
          "            CODE        SEGMENT USE16\n"
          "            ASSUME      CS:CODE, DS:CODE\n\n"
          "            ORG         256\n\n"
          "start:\n"
          "            DW offset hookpoint-256\n"
          "            DW offset endpoint-offset hookpoint\n");
  fprintf(ostream,
          "            DB %u dup (0)\n", pregap_size[pass]);
  /* Dump the located symbols */
  for(esym_tmp=esym; esym_tmp!=NULL; esym_tmp=esym_tmp->next)
   fprintf(ostream, "%s:\ndb \"%s\", 0\n", esym_tmp->name, esym_tmp->name);
  /* Slack area */
  fprintf(ostream,
          "            DB %u dup (0)\n", postgap_size[pass]);
  fprintf(ostream,
          "hookpoint:\n");
  /* [re]insert the source code */
  fprintf(ostream,
          "; User code ---------------------------------------------------\n");
  fseek(istream, 0L, SEEK_SET);
  while(fgets(buf, LINESIZE, istream)!=NULL)
   fputs(buf, ostream);
  fprintf(ostream,
          "; End of user code --------------------------------------------\n");
  /* Finalize it */
  fprintf(ostream,
          "endpoint:\n\n"
          "CODE        ENDS\n"
          "END         start\n");
  fclose(ostream);
  /* Try to compile it */
  if(exec_pgm("ml.exe -c " TMP_ASM)||
     exec_pgm("link.exe /TINY " TMP_OBJ "," TMP_COM ";"))
  {
   printf("*** Compile failed\n");
   rc=1;
   break;
  }
  tstream=file_open(TMP_COM, "rb");
  j[pass].vpofs=j[pass].vps=0;
  fread(&j[pass].vpofs, 2, 1, tstream);
  fread(&j[pass].vps, 2, 1, tstream);
  /* Fill reference areas (used for sanity checking - must match) */
  j[pass].refarea=NULL;
  j[pass].refarea_ofs=pregap_size[pass]+4;
  fseek(tstream, j[pass].refarea_ofs, SEEK_SET);
  j[pass].refarea_s=j[pass].vpofs-j[pass].refarea_ofs-postgap_size[pass];
  if(j[pass].refarea_s>0)
  {
   j[pass].refarea=(char *)malloc(j[pass].refarea_s);
   fread(j[pass].refarea, 1, j[pass].refarea_s, tstream);
  }
  /* Get the raw code */
  j[pass].vp=(char *)malloc(j[pass].vps);
  fseek(tstream, j[pass].vpofs, SEEK_SET);
  fread(j[pass].vp, 1, j[pass].vps, tstream);
  fclose(tstream);
  unlink(TMP_COM);
  unlink(TMP_ASM);
  unlink(TMP_OBJ);
 }
 fclose(istream);
 if(rc)
  return(rc);
 /* Check integrity of the binary file */
 if((j[0].refarea==NULL||j[1].refarea==NULL)&&j[0].refarea!=j[1].refarea||
    j[0].refarea_s!=j[1].refarea_s||
    (j[0].refarea!=NULL&&memcmp(j[0].refarea, j[1].refarea, j[0].refarea_s)))
 {
  printf("Reference areas mismatch\n");
  return(2);
 }
 if(j[0].vps!=j[1].vps)
 {
  printf("Code size mismatch: pass 1 = %u bytes, pass 2 = %u bytes\n",
         j[0].vps, j[1].vps);
  return(3);
 }
 /* Prepare relocations and flush the data stream */
 ostream=file_open(argv[2], "w");
 s=0;
 while(s<j[0].vps)
 {
  if(j[0].vp[s]!=j[1].vp[s])
  {
   if(s==j[0].vps-1)
    fprintf(ostream, " fc(0); /* Invalid relocation (the last byte in chunk)! */\n");
   else if(j[0].vp[s+1]==j[1].vp[s+1])
    fprintf(ostream, " fc(0); /* Incomplete relocation (1 byte only) */\n");
   else
   {
    r1=*(unsigned short *)&j[0].vp[s];
    r2=*(unsigned short *)&j[1].vp[s];
    reloc=(int)(r2-r1);
    /* Guess what kind of relocation might it be */
    if(reloc==pregap_size[1]-pregap_size[0])
    {
     /* This must be an absolute reference to extsym */
     fprintf(ostream, " fw(%s);\n", &j[0].refarea[r1-j[0].refarea_ofs-256]);
    }
    else if(reloc==postgap_size[0]-postgap_size[1])
    {
     /* This is a backward relative reference to extsym (e.g. jmp or call) */
     fprintf(ostream, " fw(%s-ftell(stream)-2);\n", &j[0].refarea[(j[0].vpofs+s)+r1-259]);
    }
    else if(reloc==(pregap_size[1]+postgap_size[1])-
                   (pregap_size[0]+postgap_size[0]))
    {
     /* Local reference */
     fprintf(ostream, " fw(ftell(stream)+(%d));\n", r1-(j[0].vpofs+s)-256);
    }
    else
     fprintf(ostream, " fw(0); /* Unknown relocation for 0x%08x */\n", reloc);
    s++;
   }
  }
  else
   fprintf(ostream, " fc(0x%02x);\n", j[0].vp[s]);
  s++;
 }
 fclose(ostream);
 return(rc);
}
