/* REXX */
/* MULTIPLE DIGITS OF FACTORIAL */
/* (C) Copyright 1997 kyo */
ARG N '@' TR
IF N = '' THEN N = 30    /* DIGITS */
DGT = 5
LIM = 10 ** DGT
F.1 = 1
DO I = 2 TO N; F.I = 0; END
TRACE VALUE TR
PS = 1
PE = 1
DO J = 2 TO N
    C = 0
    DO I = PS TO PE
        F.I = F.I * J + C
        IF F.I >= LIM THEN
            DO
                C = F.I % LIM
                F.I = F.I // LIM
            END
        ELSE C = 0
    END
    IF C > 0 THEN DO; PE = PE + 1; F.PE = C; END
    IF F.PS = 0 THEN PS = PS + 1
    CALL PRTANS
END
EXIT

PRTANS:
ANS = FORMAT(J, 4) '! ='
DO K = PE TO 1 BY -10
    DO L = K TO MAX(1, K - 9) BY -1
        IF L = PE THEN
            ANS = ANS RIGHT(F.L, DGT)
        ELSE
            ANS = ANS RIGHT(F.L, DGT, '0')
    END
    SAY ANS
    ANS = '        '
END
RETURN