/* REXX */
/* ディレクトリ及びアーカイブファイルからファイル名を検索する
 */
/* (C) Copyright 2000 kyo */
/* パラメータ
ディレクトリ名（オプション）
検索ファイル名（必須、ワイルドカード可）
再帰スイッチ（オプション、dirコマンドに合わせて/s）
 */

options 'ETMODE'; options 'EXMODE';
parse arg prm '@' tr
trace value tr;

/* OSとコマンド名取得 */
parse source os . cmdname

/* コマンド名取得 */
/* 文字列を反転して'.'と最初の'\'で分解 */
rvcmdname = reverse(cmdname)
parse var rvcmdname rvcmdext '.' rvcmdbody '\' rvcmddir
cmdname = reverse(rvcmdbody) || '.' || reverse(rvcmdext)

/* ヘルプ */
if pos("HELP", translate(prm)) > 0 then signal usage

/* get current directory */
cur = directory()

/* Parameters */
/* (Defaults) */
parse var prm dn fn recur .
select
	when dn = '' then			/* パラメータなし */
	do
		signal usage
	end
	when translate(recur) = "/S" then	/* ディレクトリ名 検索ファイル名 /S */
	do
		recur = 'Y'
	end
	when recur <> '' then			/* パラメータ多過ぎる */
	do
		signal usage
	end
	when translate(fn) = "/S" then		/* 検索ファイル名 /S */
	do
		fn = dn
		dn = cur
		recur = 'Y'
	end
	when fn <> '' then			/* ディレクトリ名 検索ファイル名 */
	do
		recur = 'N'
	end
	when fn = '' then			/* 検索ファイル名 */
	do
		fn = dn
		dn = cur
		recur = 'N'
	end
	otherwise
	do
		signal usage
	end
end

/* Load functions */
if RxFuncQuery('SysLoadFuncs') then call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

/* ディレクトリの末尾に'\'を付加 */
if right(dn, 1) <> '\' then dn = dn || '\'
/* ディレクトリの存在確認 */
if length(dn) = 3 & right(dn, 2) = ":\" then		/* ルートはstream関数使用 */
do
	rc = stream(dn, "C", "query exists")
	if rc = "" then
	do
		signal nodir
	end
end
else					/* それ以外はSysFileTree関数 */
do
	rc = SysFileTree(left(dn, length(dn) - 1), 'rslt', 'D')
	if rslt.0 = 0 then
	do
		signal nodir
	end
end

/* Constants */
templlbl = "$$templ$"
sepchar = '|'
thmimghd = "$$"

/* Temp files */
tempdir = value("TEMP", , "OS2ENVIRONMENT")
if tempdir = '' then tempdir = directory()
rc = SysFileTree(tempdir, "tempext", 'D')
if tempext.0 = 0 then tempdir = directory()
if right(tempdir, 1) <> '\' then tempdir = tempdir||'\'

tempfn1 = tempdir||SysTempFileName("$$temp1.???")
do while stream(tempfn1, 'C', "QUERY EXISTS") <> ''
	tempfn1 = tempdir||SysTempFileName("$$temp1.???")
end

/* Initialization */
dmy = setlocal()

/* Search 1: dir */
if recur = 'Y' then
do
	opt = "/S /O /N"
end
else
do
	opt = "/O /N"
end

"@set dircmd="||opt
"@dir" dn||fn ">" tempfn1

dmy = endlocal()

/* 必要部分だけ出力 */
rc = stream(tempfn1, 'C', "OPEN READ")

dn1 = dn
do while lines(tempfn1) > 0
	ln = linein(tempfn1)
	if substr(ln, 2, 1) = 'デ' then
	do
		dn1 = word(ln, 2)
	end
	else if (substr(ln, 3, 1) = '-' & substr(ln, 6, 1) = '-') then
	do
		if dn1 <> '' then
		do
			say dn1
			dn1 = ''
		end
		say ln
	end
end

rc = stream(tempfn1, 'C', "CLOSE")

/* Search 2: lha */
/* 圧縮ファイル検索 */
if recur = 'Y' then
do
	opt = "FOS"
end
else
do
	opt = "FO"
end
rc = SysFileTree(dn||"*.lzh", "rslt", opt)

do i = 1 to rslt.0
	"@lha v" rslt.i fn ">" tempfn1
	rc = stream(tempfn1, 'C', "OPEN READ")
	dmy = linein(tempfn1)
	afn = linein(tempfn1)
	do 3
		dmy = linein(tempfn1)
	end
	ln = linein(tempfn1)
	if substr(ln, 3, 7) <> "no file" then
	do
		say afn
		say ln
		do while lines(tempfn1) > 0
			ln = linein(tempfn1)
			if left(ln, 1) <> ' ' & left(ln, 1) <> '-' then say ln
		end
	end
	rc = stream(tempfn1, 'C', "CLOSE")
end

/* Search 3: unzip */
/* 圧縮ファイル検索 */
if recur = 'Y' then
do
	opt = "FOS"
end
else
do
	opt = "FO"
end
rc = SysFileTree(dn||"*.zip", "rslt", opt)

do i = 1 to rslt.0
	"@unzip -l" rslt.i fn ">" tempfn1
	rc = stream(tempfn1, 'C', "OPEN READ")
	afn = linein(tempfn1)
	do 2
		dmy = linein(tempfn1)
	end
	do while lines(tempfn1) > 0
		ln = linein(tempfn1)
		if substr(ln, 10, 1) <> ' ' then
		do
			if afn <> ' ' then
			do
				say afn
				afn = ''
			end
			say ln
		end
	end
	rc = stream(tempfn1, 'C', "CLOSE")
end

/* end */
if stream(tempfn1, 'C', "QUERY EXISTS") <> '' then
do
	"@del" tempfn1
end

exit

usage:
say "Usage:"
say cmdname "[ディレクトリ名] 検索ファイル名 [/S]"
do i = 1 to sourceline()
	if pos("パラメータ", sourceline(i)) > 0 then
	do
		i = i + 1
		n = 1
		do while pos("*/", sourceline(i)) = 0
			say n||': '||sourceline(i)
			i = i + 1
			n = n + 1
		end
		exit
	end
end
exit

nodir:
say dn "は存在しません。"
exit