/* Installation script for OS2MT */
/* 2005.12.10: ZKA               */

parse arg option

if option <> 'Q' then do
	'@cls'
	Say
	Say 'This program will (re)create the OS2MT objects.'
	Say
	Say 'Press any key to continue or CTRL-C to abort.'
	Say
	'@pause'
end

/* get ini */
call RxFuncAdd 'SysIni', 'RexxUtil', 'SysIni'
d_dir = SysIni(, 'OS2MT', 'DOWNDR')
if d_dir = 'ERROR:' then do
	d_dir = directory()"\download"
	call SysIni, 'OS2MT', 'DOWNDR', d_dir
end
call RxFuncAdd 'SysMkDir', 'RexxUtil', 'SysMkDir'
call SysMkDir d_dir

/* objects */
call RxFuncAdd 'SysCreateObject', 'RexxUtil', 'SysCreateObject'
call SysCreateObject 'WPFolder',  'OS2MT','<WP_DESKTOP>', 'OBJECTID=<OS2MT_FOLDER>;','R'
call SysCreateObject 'WPProgram', 'Readme','<OS2MT_FOLDER>', 'EXENAME=E.EXE;PARAMETERS=Readme.txt;STARTUPDIR='directory()';','R'
call SysCreateObject 'WPProgram', 'OS2MT', '<OS2MT_FOLDER>', 'EXENAME='directory()'\OS2MT.CMD;STARTUPDIR='directory()';','R'
call RxFuncAdd 'SysCreateShadow', 'RexxUtil', 'SysCreateShadow'
call SysCreateshadow d_dir, '<OS2MT_FOLDER>'
if option <> 'Q' then do
	Say
	Say 'The objects are created.'
end

/* config */
if option <> 'Q' then do
	Say
	record  = translate(value('PATH',,'OS2ENVIRONMENT'))
	os2_pos = pos(':\OS2;',record)
	if os2_pos = 0 then bootdrive = 'C'
	else bootdrive = substr(record,os2_pos-1,1)':'
	updcd_cfg = bootdrive'\ibminst\tables\addons.cfg'
	if stream(updcd_cfg,'C','query exists') <> '' then do
		Say 'UpdCD 3rd party configuration exists: 'updcd_cfg
		Say 'Would you like OS2MT to use this file? (Y/N)'
		parse upper pull response
		if response = 'Y' then '@copy 'updcd_cfg' .'
	end
	Say 'Finished. Enjoy using OS2MT!'
end
