/* Fixpak installation script */
/* Created: 05.11.2005        */

/* env */
product_log	= value("PRODUCT_LOG"      , ,"OS2ENVIRONMENT")
inst_dir	= value("INST_DIR"         , ,"OS2ENVIRONMENT")
return_code	= 0

/* start */
Say
Say 'Starting fixpak installation...'
cdir = directory()
target = value("PRODUCT_DRV",,"OS2ENVIRONMENT")
call directory inst_dir

/* fixtool */
Say
Say 'Unzipping fixtool...'
if stream('fservice.exe','c','query exists') = '' then
	'@unzip -o cs.exe -d . >> 'product_log' 2>>&1'

/* unpack diskettes */
if stream('csf_disk','c','query exists') = '' then do
	call RxFuncAdd 'SysFileTree', 'RexxUtil', 'SysFileTree'
	call SysFileTree '*.?dk', 'dsk1.', 'FO'
	if dsk1.0 > 0 then do
		Say
		Say 'Unpacking DSK files...'
		'@dskxtrct /s:*.?dk /t:. /ra /lr >> 'product_log' 2>>&1'
	end
	call SysFileTree '*.dsk', 'dsk2.', 'FO'
	if dsk2.0 > 0 then do
		Say
		Say 'Unpacking DSK files...'
		'@dskxtrct /s:*.dsk /t:. /ra /lr >> 'product_log' 2>>&1'
	end
end

/* start install */
call SysFileTree 'csf_disk', 'dsk.', 'FSO'
if dsk.0 > 1 then do
	Say
	Say 'Error: There is more than one fixpak found. Exiting...'
end
else 
	if stream('CID.flg', 'C', 'Query Exists') = '' then do
		'@set csfutilpath='inst_dir
		'@set csfcdromdir='strip(filespec('drive', dsk.1)||filespec('path', dsk.1),'T','\')
		'@service >> 'product_log' 2>>&1'
	end
	else do
		/* find out fpk type */
		l = charin(dsk.1, 1, stream(dsk.1,'c','query size'))
		call lineout dsk.1
		if pos('D003', l) > 0 then fpk_type = 'ddk3'
		if pos('D002', l) > 0 then fpk_type = 'ddk2'
		if pos('UN',   l) > 0 then fpk_type = 'tcp'
		if pos('WR',   l) > 0 then fpk_type = 'mtp'
		if pos('W042', l) > 0 then fpk_type = 'wsrv'
		if pos('W043', l) > 0 then fpk_type = 'wsrv'

		/* find out os major version */
		tempfile = '$tmp$.txt'
		'@ver > 'tempfile' 2>>&1'
		call linein(tempfile)
		parse value linein(tempfile) with . . . . . os_version
		call lineout tempfile
		'@del 'tempfile' >nul 2>>&1'

		/* create rsp file and archive dir */
		sdir = strip(filespec('drive', dsk.1)||filespec('path', dsk.1),'T','\')
		if fpk_type = 'ddk3' | fpk_type = 'ddk2' then do
			'@echo :FLAGS REPLACE_PROTECTED REPLACE_NEWER EXIT_WHEN_DONE > default.rsp'
			'@echo :SOURCE 'sdir'			 		     >>default.rsp'
			'@echo :SERVICE						     >>default.rsp'
			'@echo :SYSLEVEL 'target'\OS2\INSTALL\SYSLEVEL.BDD	     >>default.rsp'
			'@echo :ARCHIVE 'target'\fparch1			     >>default.rsp'
		end
		else if fpk_type = 'tcp' then do
			'@echo :FLAGS REPLACE_PROTECTED REPLACE_NEWER EXIT_WHEN_DONE > default.rsp'
			'@echo :SOURCE 'sdir'                                        >>default.rsp'
			'@echo :SERVICE                                              >>default.rsp'
			'@echo :SYSLEVEL 'target'\TCPIP\BIN\SYSLEVEL.TCP             >>default.rsp'
		end
		else if fpk_type = 'mtp' then do
			'@echo :FLAGS REPLACE_PROTECTED REPLACE_NEWER EXIT_WHEN_DONE > default.rsp'
			'@echo :SOURCE 'sdir'                                        >>default.rsp'
			'@echo :SERVICE                                              >>default.rsp'
			'@echo :SYSLEVEL 'target'\MPTN\SYSLEVEL.DHC                  >>default.rsp'
			'@echo :SERVICE                                              >>default.rsp'
			'@echo :SYSLEVEL 'target'\MPTN\SYSLEVEL.MPT                  >>default.rsp'
			'@echo :SERVICE                                              >>default.rsp'
			'@echo :SYSLEVEL 'target'\IBMCOM\SYSLEVEL.TRP                >>default.rsp'
		end
		else do
			'@echo :FLAGS REPLACE_PROTECTED REPLACE_NEWER EXIT_WHEN_DONE > default.rsp'
			'@echo :SOURCE 'sdir'                                        >>default.rsp'
			'@echo :SERVICE                                              >>default.rsp'
			'@echo :SYSLEVEL 'target'\OS2\INSTALL\SYSLEVEL.OS2           >>default.rsp'
			'@echo :ARCHIVE 'target'\fparch1                             >>default.rsp'
			if os_version = '3.00' then do
				'@echo :SERVICE                                              >>default.rsp'
				'@echo :SYSLEVEL 'target'\MMOS2\INSTALL\SYSLEVEL.MPM         >>default.rsp'
				'@echo :ARCHIVE 'target'\fparch2                             >>default.rsp'
			end
		end
		'@mkdir 'target'\fparch1 >nul 2>>&1'
		'@mkdir 'target'\fparch2 >nul 2>>&1'

		/* replace syslevel if wsrv */
		if fpk_type = 'wsrv' & os_version = '3.00' then do
			'@attrib -r -s -h 'target'\os2\install\syslevel.os2 >nul 2>>&1'
			'@attrib -r -s -h 'target'\mmos2\install\syslevel.mpm >nul 2>>&1'
			call ReadSysLevel target'\os2\install\syslevel.os2'
			if pos('3005', st.achCsdPrev) = 0 & pos('3006', st.achCsdPrev) = 0 then do
				st.achCsdPrev = substr(st.achCsdPrev,1,3)'3005_'
				st.achCompId = '562274700'
				call WriteSysLevel target'\os2\install\syslevel.os2'
			end
			call ReadSysLevel target'\mmos2\install\syslevel.mpm'
			if pos('3005', st.achCsdPrev) = 0 & pos('3006', st.achCsdPrev) = 0 then do
				st.achCsdPrev = substr(st.achCsdPrev,1,3)'3005_'
				st.achCompId = '562274700'
				call WriteSysLevel target'\mmos2\install\syslevel.mpm'
			end
		end

		/* replace syslevel if device driver fp 3 */
		if fpk_type = 'ddk3' then do
			if os_version = '3.00' then do
				'@attrib -r -s -h 'target'\os2\install\syslevel.os2 >nul 2>>&1'
				'@copy 'target'\os2\install\syslevel.os2 'target'\os2\install\syslevel._os >> 'product_log' 2>>&1'
				'@del 'target'\os2\install\syslevel.os2 >nul 2>>&1'
				l1 = 'FFFF5359534C4556454C00000000000100000000000000000000000000000000002500000000100F400000005852304D3030355F585230343030305F49424D204F532F322042617365204F7065726174696E672053797374656D0000000000000000000'
				l2 = '00000000000000000000000000000000000000000000000000000000000000000000000000000000035363339413631303000304300000000000000000000000000'
				l = x2c(l1||l2)
				do while length(l) > 0
					c = substr(l,1,1)
					l=substr(l,2)
					call charout target'\os2\install\syslevel.os2', c
				end
				call charout target'\os2\install\syslevel.os2'
			end
			if stream(target'\os2\install\syslevel.bdd','c','query exists') = '' then do
				/* wseb */
				if os_version = '4.50' then do
					l1 = 'FFFF5359534C4556454C00000000000100000000000000000000000000000000002500000000100F45000000585230443030315F585230343530305F49424D204F532F32204261736520446576696365204472697665727300000000000000000000000'
					l2 = '00000000000000000000000000000000000000000000000000000000000000000000000000000000035363339413631353000305300000000000000000000000000'
				end
				/* wrp4 */
				else do
					l1 = 'FFFF5359534C4556454C00000000000100000000000000000000000000000000002500000000100F40000000585230443030315F585230343030305F49424D204F532F32204261736520446576696365204472697665727300000000000000000000000'
					l2 = '00000000000000000000000000000000000000000000000000000000000000000000000000000000035363339413631303000304300000000000000000000000000'
				end
				l  = x2c(l1||l2)
				do while length(l) > 0
					c = substr(l,1,1)
					l=substr(l,2)
					call charout target'\os2\install\syslevel.bdd', c
				end
				call charout target'\os2\install\syslevel.bdd'
			end
		end

		/* run service */
		'@fservice /R:default.rsp /CID >> 'product_log
		return_code = rc

		/* restore syslevel files */
		if fpk_type = 'ddk3' & os_version = '3.00' then do
			'@attrib -r -s -h 'target'\os2\install\syslevel.os2 >nul 2>>&1'
			'@copy 'target'\os2\install\syslevel._os 'target'\os2\install\syslevel.os2 >> 'product_log' 2>>&1'
			'@del 'target'\os2\install\syslevel._os >nul 2>>&1'
		end

	end

/* restore dir */
call directory cdir

return return_code

/**********************/
/* Read SysLevel file */
/**********************/
ReadSysLevel: procedure expose slfh. st.  msg.
call Trace OFF
parse arg fs

   res = 0
   if stream(fs,"C","Query Exists") <> "" then do
      data = charin(fs,1,chars(fs))
			call stream fs,"C","Close"

      slfh.usSignature   = c2x(reverse(substr(data,1,2)))     /* special # for id of syslevel file */
      slfh.achSignature  = substr(data,3,8)                   /* string to id slf file, must be 'SYSLEVEL' */

			/* check if it is a real syslevel file */
			if slfh.achSignature <> 'SYSLEVEL' then return 2

      slfh.achJulian     = substr(data,11,5)                  /* date of version */
      slfh.usSlfVersion  = c2x(reverse(substr(data,16,2)))    /* version of syslevel file, must be 1 */
      slfh.ausReserved   = c2x(substr(data,18,16))            /* reserved */
      slfh.ulTableOffset = c2d(reverse(substr(data,34,4)))    /* offset of SYSTABLE */

      /* Calculate table start */
      tblst = slfh.ulTableOffset+1

      st.usSysId       = c2x(reverse(substr(data, tblst+0,2))) /* identifies system /subsytem */
      st.bSysEdition   = c2x(substr(data, tblst+2,1))          /* edition of system, eg SE=00, EE=01 */
      st.bSysVersion   = c2x(substr(data, tblst+3,1))          /* version, eg 1.00=10, 1.10=11 */
      st.bSysModify    = c2x(substr(data, tblst+4,1))          /* modify, eg 1.00=00, 1.01=01 */
      st.usSysDate     = c2x(reverse(substr(data, tblst+5,2))) /* date of system */
      st.achCsdLevel   = substr(data, tblst+7,8)               /* subsytem CSD level, eg, XR?0000_ */
      st.achCsdPrev    = substr(data, tblst+15,8)              /* as above, except for prev system */
      st.achSysName    = substr(data, tblst+23,80)             /* Title of system / subsytem (ASCIIZ) */
      st.achCompId     = substr(data, tblst+103,9)             /* component ID of subsytem */
      st.bRefreshLevel = c2x(substr(data, tblst+112,1))
      st.achType       = substr(data, tblst+113,9)             /* Null terminated type (8 chars +'\0') */
      st.usReserved    = substr(data, tblst+122,12)            /* reserved, must be 0 */
      res = 1
   end
return res

/***********************/
/* Write SysLevel file */
/***********************/
WriteSysLevel: procedure expose slfh. st.  msg.
call Trace OFF
parse arg fs

   res = 0
   if stream(fs,"C","Query Exists") <> "" then do

      data = charin(fs,1,chars(fs))
			call stream fs,"C","Close"

      rc = overlay(reverse(x2c(slfh.usSignature)), data, 1)        /* special # for id of syslevel file */
      rc = overlay(slfh.achSignature, data, 3)                     /* string to id slf file, must be 'SYSLEVEL' */
      rc = overlay(slfh.achJulian, data, 11)                       /* date of version */
      rc = overlay(reverse(x2c(slfh.usSlfVersion)), data, 16)      /* version of syslevel file, must be 1 */
      rc = overlay(x2c(slfh.ausReserved), data, 18)                /* reserved */
      rc = overlay(reverse(d2c(slfh.ulTableOffset)), data, 34)     /* offset of SYSTABLE */

      /* Calculate table start */
      tblst = slfh.ulTableOffset+1

      data = overlay(reverse(x2c(st.usSysId)), data, tblst+0)         /* identifies system /subsytem */
      data = overlay(x2c(st.bSysEdition), data, tblst+2)              /* edition of system, eg SE=00, EE=01 */
      data = overlay(x2c(st.bSysVersion), data, tblst+3)              /* version, eg 1.00=10, 1.10=11 */
      data = overlay(x2c(st.bSysModify), data,  tblst+4)              /* modify, eg 1.00=00, 1.01=01 */
      data = overlay(reverse(x2c(st.usSysDate)), data, tblst+5)       /* date of system */
      data = overlay(st.achCsdLevel, data, tblst+7)                   /* subsytem CSD level, eg, XR?0000_ */
      data = overlay(st.achCsdPrev, data, tblst+15)                   /* as above, except for prev system */
      data = overlay(st.achSysName, data, tblst+23)                   /* Title of system / subsytem (ASCIIZ) */
      data = overlay(st.achCompId, data,  tblst+103)                  /* component ID of subsytem */
      data = overlay(x2c(st.bRefreshLevel), data, tblst+112)
      data = overlay(st.achType, data, tblst+113)                     /* Null terminated type (8 chars +'\0') */
      data = overlay(st.usReserved, data, tblst+122)                  /* reserved, must be 0 */

      rc = charout(fs,data,1)
			if rc = 0 then res = 1
			call stream fs,"C","Close"
   end
return res
