#include <stdio.h>
#include <io.h>
#include <fcntl.h>
#include <memory.h>

#include "pipe.h"

int main(int argc,char *argv[])
{
        struct PipeMessage pm;
        int pipe;
        int ch,i;
        unsigned bytes;
        char buf[512],*p;
        long ret;

        if(argc<2) {
          puts("\n" ProgBanner "\n(DOS command module)\n\n"
                 "Syntax: SO [-k] [<cmdline>]\n"
                 "\t  -k  terminate OS/2 pipe server");
          return 255;
        }

        pm.ID=ID_EXEC;                  /* default: execute a command */
        pm.cmd[0]=0;
        _getcwd(pm.path,PIPE_MAX_PATH);

        for(i=1;i<argc;i++) {           /* evaluate all arguments */
          if(!pm.cmd[0] && (argv[i][0]=='/' || argv[i][0]=='-'))
            switch(tolower(argv[1][1])) {
            case 'k': pm.ID=ID_KILL;    /* terminate server */
                      i=argc;           /* force abort */
                      break;
            default:  fputs("SO: Invalid option.\n",stderr);
            }
          else {
            if(i>1) strcat(pm.cmd," ");
            strcat(pm.cmd,argv[i]);
          }
        }

        if((pipe = _open("\\PIPE\\" PIPE_CTRLNAME, _O_BINARY | _O_RDWR))==-1) {
                                        /* lowlevel open avoids buffering... */
          fputs("SO: Cannot connect to OS2 side of pipe.\n",stderr);
          return 255;
        }

        _setmode(_fileno(stdout),_O_BINARY); /* no translation on stdout */
        _write(pipe,&pm,sizeof(pm));         /* send command packet via pipe */

        i=0;
        do {
          bytes = _read(pipe,buf,sizeof(buf));
          p=buf-1;
          while((p+1-buf)<bytes
                && (p=memchr(p+1,'\x1A',bytes-(p+1-buf)))
                && memcmp(p,"\x1A" ENDMARK,ENDMARK_LEN+1))
            ;                           /* scan for end of stream signature */
          if(p)                         /* signature found: */
            bytes=p-buf;                /* clip signature */
          fwrite(buf,bytes,1,stdout);
        } while(!p);                    /* until end signature found */

        if(_read(pipe,&ret,sizeof(ret))!=sizeof(ret)) {
          fputs("SO: Error getting return code.\n",stderr);
          return 255;
        }
        _close(pipe);
        return (int)ret;
}
