#define INCL_DOSNMPIPES   /* Named-pipe includes */
#define INCL_DOSFILEMGR   /* File system includes */
#include <os2.h>

#include <stdio.h>
#include <stdlib.h>
#include <process.h>
#include <fcntl.h>

#include "pipe.h"

ULONG   OpenMode = NP_ACCESS_DUPLEX | NP_INHERIT;    
ULONG   PipeMode1 = NP_WAIT | NP_TYPE_MESSAGE | NP_READMODE_MESSAGE | 0x01;
ULONG   PipeMode2 = NP_NOWAIT | NP_TYPE_BYTE | NP_READMODE_BYTE | 0x01;
ULONG   OutBufSize = 4096;
ULONG   InBufSize = sizeof(struct PipeMessage);
ULONG   TimeOut = 500;

int main(void)
{
   HPIPE   PipeHandle;          /* Pipe handle (returned) */
   APIRET  rc;                  /* Return code */
   struct  PipeMessage pm;
   ULONG   bytesrw,ret;
   HFILE   copy_stdout,default_stdout=STDOUT,
           copy_stderr,default_stderr=STDERR,
           copy_stdin, default_stdin =STDIN;
   CHAR    *comspec;

   puts("\n" ProgBanner "\n(OS/2 pipe server module)\n");
   if(rc = DosCreateNPipe("\\PIPE\\" PIPE_CTRLNAME,
                          &PipeHandle, OpenMode, PipeMode1,
                          OutBufSize, InBufSize, TimeOut)) {
     fprintf(stderr,"SO: DosCreateNPipe error %d.\n");
     return 1;
   }
   comspec=getenv("COMSPEC");           /* to execute command processor */

   do {
     puts("Waiting..."); fflush(stdout);
     while(rc = DosConnectNPipe(PipeHandle)) {
       DosDisConnectNPipe(PipeHandle);	/* play it safe... */
       fprintf(stderr,"Error %d: bad packet.\n",rc); 
     }

     DosRead(PipeHandle,&pm,sizeof(pm),&bytesrw);

     DosSetNPHState(PipeHandle,PipeMode2);
     switch(pm.ID) {
       case ID_EXEC:
         printf("Execute: <%s>\n",pm.cmd);	/* report command */
         DosSetDefaultDisk(pm.path[0]-'A'+1);
         DosSetCurrentDir(pm.path+2);
         copy_stdout = -1;
         DosDupHandle(default_stdout,&copy_stdout);
         DosDupHandle(PipeHandle,&default_stdout);
         copy_stderr = -1;
         DosDupHandle(default_stderr,&copy_stderr);
         DosDupHandle(PipeHandle,&default_stderr);
/*
         copy_stdin = -1;
         DosDupHandle(default_stdin,&copy_stdin);
         DosDupHandle(PipeHandle,&default_stdin);
*/         

         ret = spawnl(P_WAIT,comspec,comspec,"/C",pm.cmd,NULL);

/*
         DosDupHandle(copy_stdin,&default_stdin);
         DosClose(copy_stdin);
*/         
         DosDupHandle(copy_stderr,&default_stderr);
         DosClose(copy_stderr);
         DosDupHandle(copy_stdout,&default_stdout);
         DosClose(copy_stdout);
         break;

       case ID_KILL:
         puts("Terminate pipe server.");
         DosWrite(PipeHandle,"Goodbye.\r\n",10,&bytesrw);
         ret=0;                         /* no error */
         break;
     }
     DosWrite(PipeHandle,"\x1A" ENDMARK,ENDMARK_LEN+1,&bytesrw);
     DosWrite(PipeHandle,&ret,sizeof(ret),&bytesrw);
     DosResetBuffer(PipeHandle);
     DosSetNPHState(PipeHandle,PipeMode1);

     DosDisConnectNPipe(PipeHandle);
   } while(pm.ID != ID_KILL);

   DosClose(PipeHandle);
   return 0;
}
