/*
	iLFG2.c
	
	define:
	DISP_MESSAGE_BOX		put_msg ŃbZ[W{bNXo
	LOAD_IMAGE_BY_MYSELF	摜C[WłOŃ[h
*/

#define INCL_DOS
#define INCL_WINDIALOGS
#define INCL_GPI
#include <os2.h>
#include <string.h>
#include "waterplg.h"
#include "ilfg2.h"

#ifdef LOAD_IMAGE_BY_MYSELF
#undef LOAD_IMAGE_BY_MYSELF
#define LOAD_IMAGE_BY_MYSELF	(1)
#else
#define LOAD_IMAGE_BY_MYSELF	(0)
#endif



int  islfg2(BYTE *pb, ULONG len);
BOOL  lf2_hdr(PBITMAPINFORMATION pbi, PBYTE pb);
BOOL  lf2_decode(PBYTE d, PBYTE psrc, ULONG cbsrc);
BOOL  lfg_hdr(PBITMAPINFORMATION pbi, PBYTE pb);
BOOL  lfg_decode(PBYTE d, PBYTE psrc, ULONG cbsrc);

BOOL  lfg2_hdr(int type, PBITMAPINFORMATION pbi, PBYTE pb);
BOOL  lfg2_decode(int type, PBYTE d, PBYTE psrc, ULONG cbsrc);


/*
	helper
*/

#define water_debug_out(s)	
#define zero_clr(p, len)	memset(p, 0, len)

void *
water_alloc(ULONG size)
{
	PVOID	m = NULL;
	
	if (PLUGIN_MALLOC(m, size) == 0) {
		zero_clr(m, size);
	} else {
		m = NULL;
	}
	
	return m;
}

void
water_free(void * m)
{
	PLUGIN_FREE(m);
}

void *
water_alloc_bmpinfo(WATER * pw)
{
	void *	bmpi;
	ULONG	size;
	
	size = pw->ulcntBitmapInfo * sizeof(BITMAPINFORMATION);
	bmpi = water_alloc(size);
	pw->pBitmapInfo = (PBITMAPINFORMATION)bmpi;
	
	return bmpi;
}

ULONG *
water_alloc_palettes(PBITMAPINFORMATION pbi)
{
	pbi->pulPalette = (ULONG *)water_alloc(pbi->ulcntPalette * sizeof(ULONG));
	return pbi->pulPalette;
}

ULONG
water_calc_line_bytes(PBITMAPINFORMATION pbi)
{
	return (pbi->ulWidth * pbi->ulBitcount + 31) >> 3;
}

ULONG
water_calc_bmp(PBITMAPINFORMATION pbi)
{
	return ((pbi->ulWidth * pbi->ulBitcount + 31) >> 3) * pbi->ulHeight;
}

PBYTE
water_alloc_bmp(PBITMAPINFORMATION pbi)
{
	PBYTE	pb;
	
	pb = water_alloc(water_calc_bmp(pbi));
	pbi->pbBitmap = pb;
	
	return pb;
}

#ifdef DISP_MESSAGE_BOX
ULONG
put_msg(PSZ msg)
{
	return WinMessageBox(HWND_DESKTOP, (HWND)NULL, msg, 
	                     "iLFG2 report", 0, MB_OK);
}
#else
#define put_msg(s)	
#endif

ULONG
load_file(PSZ name, BYTE **mem, ULONG *length)
{
	ULONG		err_val;
	APIRET		ra;
	HFILE		hf;
	ULONG		ulAction;
	FILESTATUS3		sf;
	
	*mem = NULL;
	hf = (HFILE)(-1L);
	ra = DosOpen(name, &hf, &ulAction, 0,
	             FILE_NORMAL,
	             OPEN_ACTION_OPEN_IF_EXISTS,
	             OPEN_FLAGS_SEQUENTIAL | \
	             OPEN_SHARE_DENYWRITE | \
	             OPEN_ACCESS_READONLY,
	             NULL );
	
	if (ra == 0) {
		ra = DosQueryFileInfo(hf, FIL_STANDARD, &sf, sizeof(sf));
		if (*length > sf.cbFile) *length = sf.cbFile;
		if ((*mem = water_alloc(*length)) != NULL) {
			ULONG ul = *length;
			ra = DosRead(hf, *mem, ul, length);
			if (ra == 0 && ul == *length) {
				err_val = 0;
			} else {
				err_val = ERROR_PLUGIN_FILEREAD;
				put_msg("Can't load a image...read err");
				water_free(*mem); *mem = NULL;
			}
		} else {
			err_val = ERROR_PLUGIN_ALLOCATEMEMORY;
			put_msg("Can't load a image...Memory err");
		}
		DosClose(hf);
	} else {
		err_val = ERROR_PLUGIN_FILEOPEN;
		put_msg("Can't open a image...");
	}
	
	return err_val;
}


/*
=============================================================================
	INITWATERPLUGIN
	
	Query Plugin Information
=============================================================================
*/

BOOL  EXPENTRY INITWATERPLUGIN2( WATER *pw )
{
	if (!pw) return FALSE;
	
	pw->ulLoadAbility = 1UL;	/* 1 ... can load LF2 image */
	pw->ulSaveAbility = 0UL;	/* 0 ... can not save image as LF2 */
	pw->ulPluginType = PLUGIN_TYPE_PICTURE;	/* bitmap */
	strcpy(pw->pszCopyright, COPYRIGHT);
	strcpy(pw->pszFileExt, FILEEXT);
	
	pw->ulErrorCode = 0;
	
	return TRUE;
}



/*
=============================================================================
	WATERPLUGINLOADCHECK2
	
	Query whether plugin supports the image.
=============================================================================
*/

BOOL  EXPENTRY WATERPLUGINLOADCHECK2( WATER *pw )
{
	PBYTE		pimg;
	ULONG		size_img;
	BOOL		isfromfile;
	
	if (!pw) return FALSE;
	
	pw->ulErrorCode = 0;
	if ((pw->ulFileSize == 0 && pw->pbData == NULL) || LOAD_IMAGE_BY_MYSELF) {
		pimg = NULL;
		size_img = 2048UL;
		pw->ulErrorCode = load_file( pw->pszFilename, &pimg, &size_img);
		if (pw->ulErrorCode != 0) {
			return FALSE;
		}
		isfromfile = TRUE;
	} else {
		pimg = pw->pbData;
		size_img = pw->ulFileSize;
		isfromfile = FALSE;
	}
	
	pw->fSupport = (islfg2(pimg, size_img) != 0);
	
	if (isfromfile && pimg != NULL) water_free(pimg); 
	return TRUE;
}


/*
=============================================================================
	WATERPLUGINLOAD2
	
	decode image(s) to bitmap(s).
=============================================================================
*/



BOOL  EXPENTRY WATERPLUGINLOAD2( WATER *pw )
{
	BOOL		result = FALSE;
	PBYTE		pimg;
	ULONG		size_img;
	BOOL		isfromfile;
	int			flfg2;
	PBITMAPINFORMATION	pbi;
	
	if (!pw) return FALSE;
	
	pw->ulErrorCode = 0;
	if ((pw->ulFileSize == 0 && pw->pbData == NULL) || LOAD_IMAGE_BY_MYSELF) {
		/* load from file... */
		pimg = NULL;
		size_img = (ULONG)(-1L);
		pw->ulErrorCode = load_file( pw->pszFilename, &pimg, &size_img);
		if (pw->ulErrorCode != 0) {
			return FALSE;
		}
		isfromfile = TRUE;
	} else {
		pimg = pw->pbData;
		size_img = pw->ulFileSize;
		isfromfile = FALSE;
	}
	
	flfg2 = islfg2(pimg, size_img);
	if (!flfg2) {
		if (isfromfile) { water_free(pimg); }
		pw->ulErrorCode = ERROR_PLUGIN_ILLEGALFORMAT;
		return FALSE;
	}
	
	pw->ulAll = 1;
	pw->ulProgress = 0;
	pw->fUserStop = FALSE;
	
	pw->ulcntBitmapInfo = 1;
	pbi = water_alloc_bmpinfo(pw);
	if (pbi == NULL) {
		pw->ulErrorCode = ERROR_PLUGIN_ALLOCATEMEMORY;
	} else {
		if (lfg2_hdr(flfg2, pbi, pimg) && water_alloc_bmp(pbi)) {
			lfg2_decode(flfg2, pbi->pbBitmap, pimg, size_img);
			pw->ulProgress = 1;
			result = TRUE;
		} else {
			pw->ulErrorCode = ERROR_PLUGIN_ALLOCATEMEMORY;
		}
	}
	
	if (!result) { put_msg("decode err"); }
	if (isfromfile) { water_free(pimg); }	
	
	return result;
}


/*
=============================================================================
	WATERPLUGINSAVECHECK2
=============================================================================
*/

BOOL  EXPENTRY WATERPLUGINSAVECHECK2( WATER *pw )
{
	if (!pw) return FALSE;
	return FALSE;
}


/*
=============================================================================
	WATERPLUGINSAVE2
=============================================================================
*/

BOOL  EXPENTRY WATERPLUGINSAVE2( WATER *pw )
{
	if (!pw) return FALSE;
	return FALSE;
}




/*
=============================================================================

=============================================================================
*/

ULONG
validate_lfg(PLFGHDR lfg, ULONG len)
{
	int		result = 0;
	int		cbx, cy;
	
	cbx = (lfg->x1 - lfg->x0 + 1) *8 / 2;
	cy = lfg->y1 - lfg->y0 + 1;
	
	
	if ((long)cbx * (long)cy != lfg->bitmap_size) {
		put_msg("Broken LFG");
		result = ERROR_PLUGIN_ILLEGALFORMAT;
	}
	
	return result;
}

int
islfg2(BYTE *pb, ULONG len)
{
	int		result = 0;
	
	if (len >= sizeof(LFGHDR) && memcmp(pb, IDSTR_LFG, 8) == 0) {
		if (validate_lfg((PLFGHDR)pb, len) == 0) {
			result = 1;
		}
	} else if (len > sizeof(LF2HDR) && memcmp(pb, IDSTR_LF2, 7) == 0) {
		result = 2;
	}
	return result;
}


BOOL  lfg2_hdr(int type, PBITMAPINFORMATION pbi, PBYTE pb)
{
	BOOL		result;
	
	switch(type) {
		case 1:
			result = lfg_hdr(pbi, pb);
			break;
		case 2:
			result = lf2_hdr(pbi, pb);
			break;
		
		default:
			result = FALSE;
	}
	
	return result;
}


BOOL  lfg2_decode(int type, PBYTE d, PBYTE psrc, ULONG cbsrc)
{
	BOOL		result;
	
	switch(type) {
		case 1:
			result = lfg_decode(d, psrc, cbsrc);
			break;
		case 2:
			result = lf2_decode(d, psrc, cbsrc);
			break;
		
		default:
			result = FALSE;
	}
	
	return result;
}



/*
=============================================================================
	lf2 decode
	
	قƂɂł̂ǂ͒mȂ 
	iނ˂悳ȋC͂łǁj 
=============================================================================
*/




BOOL
lf2_hdr(PBITMAPINFORMATION pbi, PBYTE pb)
{
	int		result = FALSE;
	PLF2HDR	lf2;
	
	lf2 = (PLF2HDR)pb;
	
	pbi->ulMode = PLUGIN_BITMAP_MODE_NORMAL;
	pbi->ulWidth = lf2->width;
	pbi->ulHeight = lf2->height;
	pbi->dAspect = 0.0;
	pbi->ulBitcount = 8;
	pbi->ulcntPalette = lf2->num_of_palettes;
	pbi->ulTransparentColorNo = \
		(lf2->color_transparent == 0xffff) ? 0 : lf2->color_transparent;
	
	if (water_alloc_palettes(pbi)) {
		int		i;
		
		for(i=0; i< pbi->ulcntPalette; i++) {
			pbi->pulPalette[i] = MakePalette( \
				lf2->pal[i].r, lf2->pal[i].g, lf2->pal[i].b );
		}
		result = TRUE;
	}
	
	return result;
}


BOOL
lf2_decode(PBYTE d, PBYTE psrc, ULONG cbsrc)
{
	BYTE			buf[4096];
	PLF2HDR			lf2;
	PBYTE			s;
	int				bpos, btop, bcnt;
	int				lmax;
	long			line_cnt;
	long			size_data;
	BYTE			xbit, mbit;
	USHORT			ref, cnt;
	
	zero_clr(buf, sizeof(buf));
	bpos = (-18) & 0xfff;
	btop = bpos;
	bcnt = 0;
	
	lf2 = (PLF2HDR)psrc;
	s = psrc + (ULONG)(lf2->data_pos);
	if (cbsrc <= lf2->data_pos) return FALSE;
	cbsrc -= (ULONG)(lf2->data_pos);
	
	lmax = (int)(lf2->width);
	size_data = (long)(lf2->width) * (long)(lf2->height);
	line_cnt = (long)(lf2->width + 3) & (~3L);
	
	mbit = xbit = 0;
	
	while(size_data > 0) {
		if (mbit == 0) {
			mbit = 0x80;
			xbit = *s++;
		}
		if (xbit & mbit) {
			ref = ~(*((USHORT *)s));
			s += 2;
			cnt = (ref & 15) + 3;
			ref = (ref >> 4);
			bcnt += cnt;
			size_data -= cnt;
			while(cnt--) {
				buf[bpos++] = buf[ref++];
				bpos &= 0xfff;
				ref &= 0xfff;
			}
		} else {
			buf[bpos++] = ~(*s++);
			bpos &= 0xfff;
			bcnt++;
			--size_data;
		}
		
		if (bcnt >= lmax) {
			if (btop + lmax > 0x1000) {
				int bcnt2 = (btop + lmax) - 0x1000;
				memcpy(d, buf + btop, lmax - bcnt2);
				memcpy(d + lmax - bcnt2, buf, bcnt2);
			} else {
				memcpy(d, buf + btop, lmax);
			}
			d += line_cnt;
			btop = (btop + lmax) & 0xfff;
			bcnt -= lmax;
		}
		
		mbit >>= 1;
	}
	
	return TRUE;
}


/*
=============================================================================
	lfg decode
	
	قƂɂł̂ǂ͒mȂ 
=============================================================================
*/


/* 2bits x 4planes -> 16colors x 2pixels */

const BYTE		gxlat[256] = {
	0x00, 0x01, 0x10, 0x11, 0x02, 0x03, 0x12, 0x13,
	0x20, 0x21, 0x30, 0x31, 0x22, 0x23, 0x32, 0x33,
	0x04, 0x05, 0x14, 0x15, 0x06, 0x07, 0x16, 0x17,
	0x24, 0x25, 0x34, 0x35, 0x26, 0x27, 0x36, 0x37,
	0x40, 0x41, 0x50, 0x51, 0x42, 0x43, 0x52, 0x53,
	0x60, 0x61, 0x70, 0x71, 0x62, 0x63, 0x72, 0x73,
	0x44, 0x45, 0x54, 0x55, 0x46, 0x47, 0x56, 0x57,
	0x64, 0x65, 0x74, 0x75, 0x66, 0x67, 0x76, 0x77,
	0x08, 0x09, 0x18, 0x19, 0x0a, 0x0b, 0x1a, 0x1b,
	0x28, 0x29, 0x38, 0x39, 0x2a, 0x2b, 0x3a, 0x3b,
	0x0c, 0x0d, 0x1c, 0x1d, 0x0e, 0x0f, 0x1e, 0x1f,
	0x2c, 0x2d, 0x3c, 0x3d, 0x2e, 0x2f, 0x3e, 0x3f,
	0x48, 0x49, 0x58, 0x59, 0x4a, 0x4b, 0x5a, 0x5b,
	0x68, 0x69, 0x78, 0x79, 0x6a, 0x6b, 0x7a, 0x7b,
	0x4c, 0x4d, 0x5c, 0x5d, 0x4e, 0x4f, 0x5e, 0x5f,
	0x6c, 0x6d, 0x7c, 0x7d, 0x6e, 0x6f, 0x7e, 0x7f,
	0x80, 0x81, 0x90, 0x91, 0x82, 0x83, 0x92, 0x93,
	0xa0, 0xa1, 0xb0, 0xb1, 0xa2, 0xa3, 0xb2, 0xb3,
	0x84, 0x85, 0x94, 0x95, 0x86, 0x87, 0x96, 0x97,
	0xa4, 0xa5, 0xb4, 0xb5, 0xa6, 0xa7, 0xb6, 0xb7,
	0xc0, 0xc1, 0xd0, 0xd1, 0xc2, 0xc3, 0xd2, 0xd3,
	0xe0, 0xe1, 0xf0, 0xf1, 0xe2, 0xe3, 0xf2, 0xf3,
	0xc4, 0xc5, 0xd4, 0xd5, 0xc6, 0xc7, 0xd6, 0xd7,
	0xe4, 0xe5, 0xf4, 0xf5, 0xe6, 0xe7, 0xf6, 0xf7,
	0x88, 0x89, 0x98, 0x99, 0x8a, 0x8b, 0x9a, 0x9b,
	0xa8, 0xa9, 0xb8, 0xb9, 0xaa, 0xab, 0xba, 0xbb,
	0x8c, 0x8d, 0x9c, 0x9d, 0x8e, 0x8f, 0x9e, 0x9f,
	0xac, 0xad, 0xbc, 0xbd, 0xae, 0xaf, 0xbe, 0xbf,
	0xc8, 0xc9, 0xd8, 0xd9, 0xca, 0xcb, 0xda, 0xdb,
	0xe8, 0xe9, 0xf8, 0xf9, 0xea, 0xeb, 0xfa, 0xfb,
	0xcc, 0xcd, 0xdc, 0xdd, 0xce, 0xcf, 0xde, 0xdf,
	0xec, 0xed, 0xfc, 0xfd, 0xee, 0xef, 0xfe, 0xff   };



BOOL
lfg_hdr(PBITMAPINFORMATION pbi, PBYTE pb)
{
	int		result = FALSE;
	PLFGHDR	lfg;
	
	lfg = (PLFGHDR)pb;
	
	pbi->ulMode = PLUGIN_BITMAP_MODE_NORMAL;
	pbi->ulWidth = (lfg->x1 - lfg->x0 + 1) << 3;
	pbi->ulHeight = (lfg->y1 - lfg->y0 + 1);
	pbi->dAspect = 0.0;
	pbi->ulBitcount = 4;
	pbi->ulcntPalette = 16;
	pbi->ulTransparentColorNo = \
		(lfg->color_transparent > 15) ? 0 : lfg->color_transparent;
	
	if (water_alloc_palettes(pbi)) {
		int		i;
		BYTE	r, g, b;
		
		for (i=0; i< 8; i++) {
			r = (lfg->paldata[i * 3] >> 4) * 0x11;
			g = (lfg->paldata[i * 3] & 0x0f) * 0x11;
			b = (lfg->paldata[i * 3 + 1] >> 4) * 0x11;
			pbi->pulPalette[i * 2] = MakePalette( r, g, b );
			r = (lfg->paldata[i * 3 + 1] & 0x0f) * 0x11;
			g = (lfg->paldata[i * 3 + 2] >> 4) * 0x11;
			b = (lfg->paldata[i * 3 + 2] & 0x0f) * 0x11;
			pbi->pulPalette[i * 2 + 1] = MakePalette( r, g, b );
		}
		result = TRUE;
	}
	
	return result;
}


BOOL
lfg_decode(PBYTE d, PBYTE psrc, ULONG cbsrc)
{
	BYTE			buf[4096];
	PLFGHDR			lfg;
	int				is_scanh;
	PBYTE			s;
	PBYTE			dline;
	int				bcx, cy;
	int				bpos, btop, bcnt;
	int				lmax;
	long			line_cnt;
	long			size_data;
	BYTE			xbit, mbit;
	USHORT			ref, cnt;
	
	zero_clr(buf, sizeof(buf));
	bpos = (-18) & 0xfff;
	btop = bpos;
	bcnt = 0;
	
	lfg = (PLFGHDR)psrc;
	s = psrc + sizeof(LFGHDR);
	if (cbsrc <= sizeof(LFGHDR)) return FALSE;
	cbsrc -= sizeof(LFGHDR);
	
	bcx = (lfg->x1 - lfg->x0 + 1) << 2;
	cy = lfg->y1 - lfg->y0 + 1;
	is_scanh = (lfg->scan_mode != 0);
	
	lmax = (is_scanh) ? bcx : cy;
	size_data = (long)bcx * (long)cy;
	line_cnt = (long)(bcx + 3) & (~3L);
	dline = d + (line_cnt * (cy - 1));
	
	mbit = xbit = 0;
	
	while(size_data > 0) {
		if (mbit == 0) {
			mbit = 0x80;
			xbit = *s++;
		}
		if (xbit & mbit) {
			buf[bpos++] = gxlat[(*s++)];
			bpos &= 0xfff;
			bcnt++;
			--size_data;
		} else {
			ref = *((USHORT *)s);
			s += 2;
			cnt = (ref & 15) + 3;
			ref = (ref >> 4);
			bcnt += cnt;
			size_data -= cnt;
			while(cnt--) {
				buf[bpos++] = buf[ref++];
				bpos &= 0xfff;
				ref &= 0xfff;
			}
		}
		
		if (bcnt >= lmax) {
			if (is_scanh) {
				if (btop + lmax > 0x1000) {
					int bcnt2 = (btop + lmax) - 0x1000;
					memcpy(dline, buf + btop, lmax - bcnt2);
					memcpy(dline + lmax - bcnt2, buf, bcnt2);
				} else {
					memcpy(dline, buf + btop, lmax);
				}
				btop = (btop + lmax) & 0xfff;
				dline -= line_cnt;
			} else {
				BYTE *	dpos = dline;
				int		y = lmax;
				
				do {
					*dpos = buf[btop++];
					btop &= 0xfff;
					dpos -= line_cnt;
					--y;
				} while(y > 0);
				dline++;
			}
			bcnt -= lmax;
		}
		
		mbit >>= 1;
	}
	
	return TRUE;

}

