/* obtain Samsung Slate7 stylus events from usbecd.sys */
rc=RxFuncAdd('SysGetMessage','RexxUtil','SysGetMessage')

/* obtain device driver name */
parse upper arg ddName SuperfluousArguments
if ddName = '' then ddName = '$STYLUS$'

/* verify that the direct control driver exists in config.sys */
if stream(ddName,'command','query exists') \= '\DEV\' || ddName
then do
  say 'DEVICE=?:\OS2\BOOT\USBECD.SYS required in CONFIG.SYS'
/*'@pause'*/
  exit
  end

/* acquire the device driver */
rc=stream(ddName,'command','open')
if rc \= 'READY:'
then do
  /* obtain and issue error message */
  parse value rc with sState ':' mNumber
  say SysGetMessage(mNumber,,ddName)
  say 'acquire driver failed!'
/*'@pause'*/
  exit
  end

/* set configuration */
rc=charout(ddName,x2c(00 09 01 00 00 00 00 00))
rc=stream(ddName,'description')
if rc \= 'READY:'
then do
  /* obtain and issue error message */
  parse value rc with sState ':' mNumber
  say SysGetMessage(mNumber,,ddName)
  say 'set configuration failed!'
/*'@pause'*/
  exit
  end

/* set hid device protocol */
rc=charout(ddName,x2c(21 0B 01 00 00 00 00 00))
rc=stream(ddName,'description')
if rc \= 'READY:'
then do
  /* obtain and issue error message */
  parse value rc with sState ':' mNumber
  say SysGetMessage(mNumber,,ddName)
  say 'set protocol failed!'
/*'@pause'*/
  exit
  end

/* get input data */
oiBuffer = substr(x2c(EC 00 00 00 81 03 0C 00),1,20,x2c(EE))
do forever
  call IssueWriteFunction
  say c2x(oiBuffer)
  end

/*'@pause'*/

/* release the device driver */
rc=stream(ddName,'command','close')
if rc \= 'READY:'
then do
  /* obtain and issue error message */
  parse value rc with sState ':' mNumber
  say SysGetMessage(mNumber,,ddName)
/*'@pause'*/
  end
exit

IssueWriteFunction:
rc=charout(ddName,oiBuffer)
rc=stream(ddName,'description')
if rc \= 'READY:'
then do
  /* obtain error message */
  parse value rc with sState ':' mNumber
  if mNumber == 95 /* character i/o call interrupted */
  then rc=stream(ddName,'command','open') /* restart */
  else do
    /* issue error message */
    say SysGetMessage(mNumber,,ddName)
  /*'@pause'*/
    exit
    end
  end
return
