#include <dnpap.h>
#include <message.h>
#include <memory.h>
#include <mibsup.h>
#include <stdlib.h>

#include "alarm_d.h"
#include "alarm_c.h"
#include "alarm.h"


static CHAR MODULE[] = "AlarmM";


static MIB_LOCAL*       RmonAlarmInstance = NULL;


static BOOLEAN AlarmMibNext(SNMP_OBJECT* obj, MIB_LOCAL** local, WORD idlen, WORD indexsize);



BOOLEAN AlarmMInit(VOID)
{
    MessageConfig(ALARM_ERROR, "Alarm");
    return TRUE;
}


BOOLEAN AlarmMibNext(SNMP_OBJECT* obj, MIB_LOCAL** local, WORD idlen, WORD indexsize)
{
    if (*local == NULL || indexsize < 1)
        return FALSE;

    if (obj->IdLen == idlen || (*local)->Index > obj->Id[idlen] ||
        (*local = (*local)->Next) != NULL)
    {
        obj->Id[idlen] = (*local)->Index;
        obj->IdLen = idlen + indexsize;
        return TRUE;
    }

    return FALSE;
}


WORD AlarmIndex(SNMP_OBJECT* obj, WORD idlen)
{
MIB_LOCAL* local = NULL;
			
    if ((local = MibRmon(obj, RmonAlarmInstance, idlen, 1)) == NULL)
		return SNMP_NOSUCHNAME;
		
	switch (obj->Request)
	{
	case SNMP_PDU_NEXT:
        if (AlarmMibNext(obj, &local, idlen, 1) == FALSE)
			return SNMP_NOSUCHNAME;
	case SNMP_PDU_GET:
		obj->Syntax.LngInt = local->Index;
		return SNMP_NOERROR;
	case SNMP_PDU_SET:
		return SNMP_READONLY;
	}
}


WORD AlarmInterval(SNMP_OBJECT* obj, WORD idlen)
{
MIB_LOCAL* local = NULL;
RmonAlarm* data = NULL;
			
    if ((local = MibRmon(obj, RmonAlarmInstance, idlen, 1)) == NULL)
		return SNMP_NOSUCHNAME;
		
	switch (obj->Request)
	{
	case SNMP_PDU_NEXT:
        if (AlarmMibNext(obj, &local, idlen, 1) == FALSE)
			return SNMP_NOSUCHNAME;
	case SNMP_PDU_GET:
        data = (RmonAlarm*)local->Data;
        obj->Syntax.LngInt = data->Interval;
		return SNMP_NOERROR;
	case SNMP_PDU_SET:
        data = (RmonAlarm*)local->Data;
        if (data->Status != SNMP_UNDERCREATION)
            return SNMP_READONLY;
        if (obj->Syntax.LngInt <= 0 || obj->Syntax.LngInt > 2000000L)
            return SNMP_BADVALUE;
        data->Interval = obj->Syntax.LngInt;
        return SNMP_NOERROR;
	}
}


WORD AlarmVariable(SNMP_OBJECT* obj, WORD idlen)
{
MIB_LOCAL* local = NULL;
SNMP_OBJECT tmpobj = { SNMP_PDU_GET, { 0, 0 }, 2, SNMP_INTEGER };
RmonAlarm* data = NULL;
LONG value;
			
    if ((local = MibRmon(obj, RmonAlarmInstance, idlen, 1)) == NULL)
		return SNMP_NOSUCHNAME;
		
	switch (obj->Request)
	{
	case SNMP_PDU_NEXT:
        if (AlarmMibNext(obj, &local, idlen, 1) == FALSE)
			return SNMP_NOSUCHNAME;
	case SNMP_PDU_GET:
        data = (RmonAlarm*)local->Data;
        memcpy(obj->Syntax.BufInt, data->Variable, (obj->SyntaxLen = data->VarLen)*sizeof(data->Variable[0]));
		return SNMP_NOERROR;
	case SNMP_PDU_SET:
        data = (RmonAlarm*)local->Data;
		if (data->Status != SNMP_UNDERCREATION)
			return SNMP_READONLY;
        if (AlarmSample(obj->Syntax.BufInt, obj->SyntaxLen, &value, &tmpobj) != SNMP_NOERROR)
            return SNMP_BADVALUE;
        memcpy(data->Variable, obj->Syntax.BufInt, (data->VarLen = obj->SyntaxLen)*sizeof(data->Variable[0]));
		return SNMP_NOERROR;
	}
}


WORD AlarmSampleType(SNMP_OBJECT* obj, WORD idlen)
{
MIB_LOCAL* local = NULL;
RmonAlarm* data = NULL;
			
    if ((local = MibRmon(obj, RmonAlarmInstance, idlen, 1)) == NULL)
		return SNMP_NOSUCHNAME;
		
	switch (obj->Request)
	{
	case SNMP_PDU_NEXT:
        if (AlarmMibNext(obj, &local, idlen, 1) == FALSE)
			return SNMP_NOSUCHNAME;
	case SNMP_PDU_GET:
        data = (RmonAlarm*)local->Data;
        obj->Syntax.LngInt = data->SampleType;
		return SNMP_NOERROR;
	case SNMP_PDU_SET:
        data = (RmonAlarm*)local->Data;
        if (data->Status != SNMP_UNDERCREATION)
            return SNMP_READONLY;
        if (obj->Syntax.LngInt < ALARMTYPE_MIN || obj->Syntax.LngInt > ALARMTYPE_MAX)
            return SNMP_BADVALUE;
        data->SampleType = obj->Syntax.LngInt;
        return SNMP_NOERROR;
	}
}


WORD AlarmValue(SNMP_OBJECT* obj, WORD idlen)
{
MIB_LOCAL* local = NULL;
RmonAlarm* data = NULL;
			
    if ((local = MibRmon(obj, RmonAlarmInstance, idlen, 1)) == NULL)
		return SNMP_NOSUCHNAME;
		
	switch (obj->Request)
	{
	case SNMP_PDU_NEXT:
        if (AlarmMibNext(obj, &local, idlen, 1) == FALSE)
			return SNMP_NOSUCHNAME;
	case SNMP_PDU_GET:
        data = (RmonAlarm*)local->Data;
        obj->Syntax.LngInt = data->Value;
		return SNMP_NOERROR;
	case SNMP_PDU_SET:
        return SNMP_READONLY;
	}
}


WORD AlarmStartupAlarm(SNMP_OBJECT* obj, WORD idlen)
{
MIB_LOCAL* local = NULL;
RmonAlarm* data = NULL;
			
    if ((local = MibRmon(obj, RmonAlarmInstance, idlen, 1)) == NULL)
		return SNMP_NOSUCHNAME;
		
	switch (obj->Request)
	{
	case SNMP_PDU_NEXT:
        if (AlarmMibNext(obj, &local, idlen, 1) == FALSE)
			return SNMP_NOSUCHNAME;
	case SNMP_PDU_GET:
        data = (RmonAlarm*)local->Data;
        obj->Syntax.LngInt = data->StartupAlarm;
		return SNMP_NOERROR;
	case SNMP_PDU_SET:
        data = (RmonAlarm*)local->Data;
        if (data->Status != SNMP_UNDERCREATION)
            return SNMP_READONLY;
        if (obj->Syntax.LngInt < ALARMSTARTUP_MIN || obj->Syntax.LngInt > ALARMSTARTUP_MAX)
            return SNMP_BADVALUE;
        data->StartupAlarm = obj->Syntax.LngInt;
        return SNMP_NOERROR;
	}
}


WORD AlarmRisingThreshold(SNMP_OBJECT* obj, WORD idlen)
{
MIB_LOCAL* local = NULL;
RmonAlarm* data = NULL;
			
    if ((local = MibRmon(obj, RmonAlarmInstance, idlen, 1)) == NULL)
		return SNMP_NOSUCHNAME;
		
	switch (obj->Request)
	{
	case SNMP_PDU_NEXT:
        if (AlarmMibNext(obj, &local, idlen, 1) == FALSE)
			return SNMP_NOSUCHNAME;
	case SNMP_PDU_GET:
        data = (RmonAlarm*)local->Data;
        obj->Syntax.LngInt = data->RisingThreshold;
		return SNMP_NOERROR;
	case SNMP_PDU_SET:
        data = (RmonAlarm*)local->Data;
        if (data->Status != SNMP_UNDERCREATION)
            return SNMP_READONLY;
        data->RisingThreshold = obj->Syntax.LngInt;
        return SNMP_NOERROR;
	}
}


WORD AlarmFallingThreshold(SNMP_OBJECT* obj, WORD idlen)
{
MIB_LOCAL* local = NULL;
RmonAlarm* data = NULL;
			
    if ((local = MibRmon(obj, RmonAlarmInstance, idlen, 1)) == NULL)
		return SNMP_NOSUCHNAME;
		
	switch (obj->Request)
	{
	case SNMP_PDU_NEXT:
        if (AlarmMibNext(obj, &local, idlen, 1) == FALSE)
			return SNMP_NOSUCHNAME;
	case SNMP_PDU_GET:
        data = (RmonAlarm*)local->Data;
        obj->Syntax.LngInt = data->FallingThreshold;
		return SNMP_NOERROR;
	case SNMP_PDU_SET:
        data = (RmonAlarm*)local->Data;
        if (data->Status != SNMP_UNDERCREATION)
            return SNMP_READONLY;
        data->FallingThreshold = obj->Syntax.LngInt;
        return SNMP_NOERROR;
	}
}


WORD AlarmRisingEventIndex(SNMP_OBJECT* obj, WORD idlen)
{
MIB_LOCAL* local = NULL;
RmonAlarm* data = NULL;
			
    if ((local = MibRmon(obj, RmonAlarmInstance, idlen, 1)) == NULL)
		return SNMP_NOSUCHNAME;
		
	switch (obj->Request)
	{
	case SNMP_PDU_NEXT:
        if (AlarmMibNext(obj, &local, idlen, 1) == FALSE)
			return SNMP_NOSUCHNAME;
	case SNMP_PDU_GET:
        data = (RmonAlarm*)local->Data;
        obj->Syntax.LngInt = data->RisingEventIndex;
		return SNMP_NOERROR;
	case SNMP_PDU_SET:
        data = (RmonAlarm*)local->Data;
        if (data->Status != SNMP_UNDERCREATION)
            return SNMP_READONLY;
        data->RisingEventIndex = obj->Syntax.LngInt;
        return SNMP_NOERROR;
	}
}


WORD AlarmFallingEventIndex(SNMP_OBJECT* obj, WORD idlen)
{
MIB_LOCAL* local = NULL;
RmonAlarm* data = NULL;
			
    if ((local = MibRmon(obj, RmonAlarmInstance, idlen, 1)) == NULL)
		return SNMP_NOSUCHNAME;
		
	switch (obj->Request)
	{
	case SNMP_PDU_NEXT:
        if (AlarmMibNext(obj, &local, idlen, 1) == FALSE)
			return SNMP_NOSUCHNAME;
	case SNMP_PDU_GET:
        data = (RmonAlarm*)local->Data;
        obj->Syntax.LngInt = data->FallingEventIndex;
		return SNMP_NOERROR;
	case SNMP_PDU_SET:
        data = (RmonAlarm*)local->Data;
        if (data->Status != SNMP_UNDERCREATION)
            return SNMP_READONLY;
        data->FallingEventIndex = obj->Syntax.LngInt;
        return SNMP_NOERROR;
	}
}


WORD AlarmOwner(SNMP_OBJECT* obj, WORD idlen)
{
MIB_LOCAL* local = NULL;
RmonAlarm* data = NULL;
			
    if ((local = MibRmon(obj, RmonAlarmInstance, idlen, 1)) == NULL)
		return SNMP_NOSUCHNAME;
		
	switch (obj->Request)
	{
	case SNMP_PDU_NEXT:
        if (AlarmMibNext(obj, &local, idlen, 1) == FALSE)
			return SNMP_NOSUCHNAME;
	case SNMP_PDU_GET:
        data = (RmonAlarm*)local->Data;
		memcpy(obj->Syntax.BufChr, data->Owner, obj->SyntaxLen = data->OwnerLen);
		return SNMP_NOERROR;
	case SNMP_PDU_SET:
        data = (RmonAlarm*)local->Data;
		if (data->Status != SNMP_UNDERCREATION)
			return SNMP_READONLY;
		memcpy(data->Owner, obj->Syntax.BufChr, data->OwnerLen = obj->SyntaxLen);
		return SNMP_NOERROR;
	}
}


WORD AlarmStatus(SNMP_OBJECT* obj, WORD idlen)
{
MIB_LOCAL *local = NULL;
RmonAlarm *data;

    local = MibRmon(obj, RmonAlarmInstance, idlen, 1);

    switch (obj->Request)
    {
        case SNMP_PDU_GET:
            if (local == NULL)
            {
                obj->Syntax.LngInt = SNMP_INVALID;
                return SNMP_NOSUCHNAME;
            }
            data = (RmonAlarm*)local->Data;
            obj->Syntax.LngInt = data->Status;
            return SNMP_NOERROR;
        case SNMP_PDU_NEXT:
            if (AlarmMibNext(obj, &local, idlen, 1) == FALSE)
            {
                obj->Syntax.LngInt = SNMP_INVALID;
                return SNMP_NOSUCHNAME;
            }
            data = (RmonAlarm*)local->Data;
            obj->Syntax.LngInt = data->Status;
            return SNMP_NOERROR;
        case SNMP_PDU_SET:
            if (local == NULL)
            {
                switch (obj->Syntax.LngInt)
                {
                    case SNMP_CREATEREQUEST:
                        if ((local = MibInsert(obj, &RmonAlarmInstance, idlen, 1)) == NULL)
                            return SNMP_GENERROR;
                        if ((local->Data = NewRmonAlarm(1)) == NULL)
                            return SNMP_GENERROR;
                        data = (RmonAlarm*) local->Data;
                        if (AlarmCInit(data) == TRUE)
                        {
                            data->Index = local->Index;
                            data->Status = SNMP_UNDERCREATION;
                            return SNMP_NOERROR;
                        }
                        DelRmonAlarm(local->Data);
                        MibRemove(obj, &RmonAlarmInstance, idlen, 1);
                        return SNMP_GENERROR;
                    default:
                        return SNMP_NOSUCHNAME;
                }
            }
            data = (RmonAlarm*)local->Data;
            switch (data->Status)
            {
                case SNMP_UNDERCREATION:
                    switch (obj->Syntax.LngInt)
                    {
                        case SNMP_VALID:
                            if (AlarmCStart(data) == TRUE)
                            {
                                data->Status = SNMP_VALID;
                                return SNMP_NOERROR;
                            }
                            return SNMP_GENERROR;
                        case SNMP_INVALID:
                            if (AlarmCStop(data) == TRUE)
                            {
                                DelRmonAlarm(local->Data);
                                if (MibRemove(obj, &RmonAlarmInstance, idlen, 1) == TRUE)
                                    return SNMP_NOERROR;
                            }
                            return SNMP_GENERROR;
                        default:
                            return SNMP_BADVALUE;
                    }
                case SNMP_VALID:
                    switch (obj->Syntax.LngInt)
                    {
                        case SNMP_INVALID:
                            if (AlarmCStop(data) == TRUE)
                            {
                                DelRmonAlarm(local->Data);
                                if (MibRemove(obj, &RmonAlarmInstance, idlen, 1) == TRUE)
                                    return SNMP_NOERROR;
                            }
                            return SNMP_GENERROR;
                        case SNMP_VALID:
                            return SNMP_NOERROR;
                        default:
                            return SNMP_BADVALUE;
                    }
            }
    }
}


