#ifndef _NEURO_C_H
#define _NEURO_C_H


#include <dnpap.h>
#include <mib.h>
#include <timer.h>

#include "neuro_k.h"


enum AVERAGEMETHODS  { SIMPLE_DIFF, SIMPLE_VALUE, 
       		       MEAN_DIFF, MEAN_VALUE, 
	               HARMONIC_DIFF, HARMONIC_VALUE 
                     };

enum THRESHOLDCHECKS  { NO_THRESHOLD, 
       			LESS_THAN, GREATER_THAN, 
			IN_RANGE, OUT_RANGE,
            		EQUAL, NOT_EQUAL 
                      };

			
		      
#define MAXNRLAYERS	5
#define MAXNRNEURONS	100
#define MAXNRSTEPS	5
#define MAXNRTHRESHOLDVALUES	2	


typedef struct Owner_
{	     
	BYTE	Name[MIB_SZEBUFCHR];
	WORD	NameLen;
} OWNER;

		
typedef struct InOutData_
{
	LONG	Id[MIB_SZEOBJECTID];
	WORD	IdLen;		
	FLOAT	TheValue;
	FLOAT	Value[MAXNRSTEPS];
	FLOAT	MaxValue;
	FLOAT	MinValue;
	LONG	AverageMethod;
	LONG	AverageSteps;
	BOOLEAN	Trap;
	BYTE	TrapComm[MIB_SZECOMM];
	WORD	TrapCommLen;
	LONG	ThresholdCheck;
	FLOAT	ThresholdValue[MAXNRTHRESHOLDVALUES];
} InOutData;


typedef struct NeuroData_  NeuroData;
struct NeuroData_
{
	OWNER		Owner;
	LONG		Status;
				     
	LONG		NrLayers;
	LONG		NrNeurons[MAXNRLAYERS];    							 
	NeuronNet	*Net;		/*  pointer to neural network  */
	ULONG		NetRefresh;
	BYTE		Comm[MIB_SZECOMM];
	WORD		CommLen;
	InOutData	*InputData;
	InOutData	*TargetData;
	FLOAT		*OutputValue;
	BOOLEAN		Train;
	FLOAT		LearningRate;
	FLOAT		Momentum;
	ULONG		TotalSteps;
	ULONG		TrainSteps;
        FLOAT           Error;
			      
	TIMER_DESCR	*Timer;
};


BOOLEAN		NeuroCInit(NeuroData* data);
BOOLEAN		NeuroCStart(NeuroData* data, TIMER_CALLBACK callback, VOID* param, ULONG msecs);
BOOLEAN		NeuroCStop(NeuroData* data);

BOOLEAN		NeuroCChangeTimer(NeuroData* data, ULONG msecs);

NeuroData*	NewNeuroData(VOID);
VOID		DelNeuroData(NeuroData* data);

InOutData*  NewInOutData(LONG nrinouts);
InOutData*  ReNewInOutData(InOutData* data, LONG nrinouts, LONG prvnrinouts);
VOID        InOutDataInit(InOutData* data);
VOID        DelInOutData(InOutData* data);


#endif
