#ifndef _NEURO_E_H
#define _NEURO_E_H


#include <dnpap.h>
#include <stdarg.h>
#include <message.h>

#include "neuro_d.h"


#ifndef NDEBUG
#  include <stdio.h>
extern int tracing_;
extern int debugging_;
#  define TRACE(expr)	if (tracing_) { expr; }
#  define DEBUG(expr)	if (debugging_ && expr) fprintf(stderr, "Debug expression: \"%s\", file %s, line %d\n", #expr, __FILE__, __LINE__)
#else
#  define TRACE(expr)
#  define DEBUG(expr)
#endif


#ifndef NMESSAGES		
#  define TRACEMSG(message)	{ \
				DnpapMessage(DMC_TRACE, NEURO_TRACE, message); \
				}
#  define WARNING(module, code)	{ \
				DnpapMessage(DMC_WARNING, code, "%s: %s, file %s, line %d\n", module, NeuronErrorMsg(code), __FILE__, __LINE__); \
				}
#  define ERROR(module, code)	{ \
				DnpapMessage(DMC_ERROR, code, "%s: %s, file %s, line %d\n", module, NeuronErrorMsg(code), __FILE__, __LINE__); \
				}
#  define ERROR1(module, code, arg)	{ \
				DnpapMessage(DMC_ERROR, code, "%s: %s (%d), file %s, line %d\n", module, NeuronErrorMsg(code), arg, __FILE__, __LINE__); \
				}
#  define ERROR2(module, code, arg, arg2)	{ \
				DnpapMessage(DMC_ERROR, code, "%s: %s (%d, %d), file %s, line %d\n", module, NeuronErrorMsg(code), arg, arg2, __FILE__, __LINE__); \
				}
#  define ERROR3(module, code, arg, arg2, arg3)	{ \
				DnpapMessage(DMC_ERROR, code, "%s: %s (%d, %d, %d), file %s, line %d\n", module, NeuronErrorMsg(code), arg, arg2, arg3, __FILE__, __LINE__); \
				}
#  define ERROR4(module, code, arg, arg2, arg3, arg4)	{ \
				DnpapMessage(DMC_ERROR, code, "%s: %s (%d,%d,%d,%d), file %s, line %d\n", module, NeuronErrorMsg(code), arg, arg2, arg3, arg4, __FILE__, __LINE__); \
				}
#  define FATAL(module, code)	{ \
				DnpapMessage(DMC_FATAL, code, "%s: %s, file %s, line %d\n", module, NeuronErrorMsg(code), __FILE__, __LINE__); \
				}
#else
#  define WARNING(module, code)
#  define ERROR(module, code)
#  define FATAL(module, code)	exit(-1);
#endif



#define NEURO_ERROFFSET     NEURO_ERROR

enum NeuronErrors	/*  error codes  */
{
        NEURO_OK = 0, NEURO_TRACE = NEURO_ERROFFSET,
	NEURO_NETNULL, 
	NEURO_LINDEX, NEURO_NINDEX, NEURO_WINDEX,
	NEURO_SMALL, NEUROC_ALLOCATE, NEUROC_TIMERREG,
	NEURO_NOSTATUS, NEURO_CALCERR, NEURO_NOINPUT, NEURO_NORESULT,
	NEURO_NOTARGET, NEURO_WRONGTYPE,
        NEURO_DATASRC, NEURO_ALLOCATE, NEURO_TIMERREG,
        NEURO_ERRINIT, NEURO_CONFIGINIT,
        NEURO_MCREATE,NEURO_MOWNER, NEURO_MNRLAYERS, NEURO_MNRNEURONS,
        NEURO_MLRATE, NEURO_MMOMENTUM,
        NEURO_MSETNEURONS,
        NEURO_MSTART, NEURO_MSTOP,
        NEURO_INVDATASRC, NEURO_NOSUCHDATASRC,
        NEURO_MDATASRCNAME, NEURO_MSETDATASRC, 
        NEURO_MDATASRCMAX, NEURO_MDATASRCMIN,
        NEURO_MSETDATASRCMAX, NEURO_MSETDATASRCMIN,
        NEURO_MDATASRCAVERAGEMETHOD, NEURO_MSETDATASRCAVERAGEMETHOD,
        NEURO_MDATASRCSTEPS, NEURO_MSETDATASRCSTEPS,
        NEURO_MDATASRCTRAP, NEURO_MSETDATASRCTRAP,
        NEURO_MDATASRCCHECK, NEURO_MSETDATASRCCHECK,
        NEURO_MDATASRCTHRESHOLDVALUE, NEURO_MSETDATASRCTHRESHOLDVALUE,
        NEURO_THRESHOLD, 
	NEURO_LASTERR
};



BOOLEAN NeuroErrorInit(VOID);
CHAR*	NeuronErrorMsg(LONG code);


#endif
