#ifndef _TOPN_C_H
#define _TOPN_C_H


#include <dnpap.h>
#include <hash.h>
#include <mibsup.h>
#include <timer.h>

#include "topn_d.h"


typedef struct _TOPN_ENTRY
{
	BYTE  Address[HOST_SZEADDR];
    ULONG PrevValue;        /*  statistics in host structure are ULONG's too  */
	ULONG Rate;

    struct _TOPN_ENTRY  *Prev;
    struct _TOPN_ENTRY  *Next;
	
} TOPN_ENTRY;


typedef struct _TOPN_CONTROL
{
    LONG  HostIndex;
    LONG  RateBase;
    LONG  TimeRemaining;
    LONG  Duration;
    LONG  RequestedSize;
    ULONG StartTime;
    BYTE  Owner[SNMP_SIZE_BUFCHR];
    WORD  OwnerLen;
    WORD  Status;

    LONG  TableSize;
    HashTable *Table;
    
    TOPN_ENTRY  *TopNEntries;
    TOPN_ENTRY  *TopNLast;
    TOPN_ENTRY **TopNArray;
    
    TIMER_DESCR *Timer;

} TOPN_CONTROL;


BOOLEAN TopNCInit(TOPN_CONTROL *topncontrol);
BOOLEAN TopNCStart(TOPN_CONTROL *topncontrol);
BOOLEAN TopNCStop(TOPN_CONTROL *topncontrol);

BOOLEAN EntryAddList(TOPN_CONTROL *topncontrol, TOPN_ENTRY *entry);
BOOLEAN EntryUpdateList(TOPN_CONTROL *topncontrol, TOPN_ENTRY *entry);
TOPN_ENTRY* TopNEntrySearch(TOPN_CONTROL *topncontrol, SNMP_OBJECT *obj, WORD idlen);
      
BOOLEAN FillEntryTable(TOPN_CONTROL *topncontrol, LONG reqsize);


#endif
