#include <dnpap.h>
#include <memory.h>
#include <mibsup.h>
#include <stdlib.h>
#include <sys.h>
#include <timer.h>

#include "dtopn_d.h"
#include "dtopn_e.h"
#include "dtopn_c.h"


static VOID DelEntries(DNPAP_TOPN_CONTROL *topncontrol);

static VOID TopNTimerCallback(TIMER_DESCR *timer, ULONG now, VOID *param);



BOOLEAN DnpapTopNCInit(DNPAP_TOPN_CONTROL *topncontrol)
{
    topncontrol->HostIndex = 1;
    topncontrol->RateBase = 1;
    topncontrol->TimeRemaining = 0;
    topncontrol->Duration = 0;
    topncontrol->RequestedSize = 10;
    topncontrol->StartTime = 0;
    topncontrol->Owner[0] = '\0';
    topncontrol->OwnerLen = 0;
    topncontrol->Status = SNMP_INVALID;

    topncontrol->TableSize = 0;
    topncontrol->Table = NULL;
    
    topncontrol->TopNEntries = NULL;
    topncontrol->TopNLast = NULL;
    topncontrol->TopNArray = NULL;
    
    topncontrol->Timer = NULL;

    return TRUE;
}


BOOLEAN TopNCStart(DNPAP_TOPN_CONTROL *topncontrol)
{
    if (topncontrol->TimeRemaining > 0)
    {
        if ((topncontrol->Table = NewHash(2011, NULL)) == NULL)
        {
                DnpapMessage(DMC_ERROR, DTOPN_TIMER, "dtopN: can not create hashtable");
                return FALSE;
        }
        
        if ((topncontrol->Timer = TimerRegister(TopNTimerCallback, topncontrol, 1000, TIMER_FOREVER, TIMER_TYPE_RECOVER)) == NULL)
        {
                DnpapMessage(DMC_ERROR, DTOPN_TIMER, "dtopN: can not register a timer");
                return FALSE;
        }
        
        topncontrol->StartTime = SysTime();
    }

    return TRUE;
}


BOOLEAN TopNCStop(DNPAP_TOPN_CONTROL *topncontrol)
{   
    TimerRemove(topncontrol->Timer);
        
    DelHash(topncontrol->Table);
    
    DelEntries(topncontrol);      
    
    DnpapFree(topncontrol->TopNArray);
    topncontrol->TopNArray = NULL;
    
    return TRUE;
}


VOID TopNTimerCallback(TIMER_DESCR *timer, ULONG now, VOID *param)
{
DNPAP_TOPN_CONTROL *topncontrol = param;

    topncontrol->TimeRemaining--;
    if (topncontrol->TimeRemaining <= 0)
    {
        if (FillEntryTable(topncontrol, topncontrol->RequestedSize) != TRUE)
            DnpapMessage(DMC_WARNING, DTOPN_FILLFAIL, "dtopN: creation of entry array failed");
        TimerRemove(topncontrol->Timer);
        topncontrol->Timer = NULL;
    }
}


DNPAP_TOPN_ENTRY* TopNEntrySearch(DNPAP_TOPN_CONTROL *topncontrol, SNMP_OBJECT *obj, WORD idlen)
{
    if (topncontrol->Status == SNMP_VALID && topncontrol->TimeRemaining == 0 &&
        topncontrol->TopNArray != NULL)
        return topncontrol->TopNArray[obj->Id[idlen+1]-1];
    return NULL;
}


BOOLEAN FillEntryTable(DNPAP_TOPN_CONTROL *topncontrol, LONG reqsize)
{
DNPAP_TOPN_ENTRY *entry;
DNPAP_TOPN_ENTRY **array;
LONG count;
LONG arraysize = min(reqsize, topncontrol->TableSize);

	if ((array = (DNPAP_TOPN_ENTRY**)DnpapRealloc(topncontrol->TopNArray, arraysize*sizeof(DNPAP_TOPN_ENTRY*))) == NULL)
	{
	    DnpapMessage(DMC_ERROR, DTOPN_ARRAY, "dtopN: can not create entry array");
	    return FALSE;
	}
	memset(topncontrol->TopNArray = array, 0, (size_t)arraysize*sizeof(DNPAP_TOPN_ENTRY*));
	
    for (entry = topncontrol->TopNEntries, count = 0; 
         entry != NULL && count < arraysize;
         entry = entry->Next, count++)
        topncontrol->TopNArray[count] = entry;

    return TRUE;
}


VOID DelEntries(DNPAP_TOPN_CONTROL *topncontrol)
{
DNPAP_TOPN_ENTRY *entry1, *entry2;

    for (entry2 = topncontrol->TopNEntries; entry2 != NULL; entry2 = entry1)
    {                                             
        entry1 = entry2->Next;
        DnpapFree(entry2);
        topncontrol->TableSize--;
    }
    topncontrol->TopNEntries = NULL;
    topncontrol->TopNLast = NULL;
}


BOOLEAN EntryAddList(DNPAP_TOPN_CONTROL *topncontrol, DNPAP_TOPN_ENTRY *entry)
{
    if (topncontrol->TopNEntries == NULL)
    {
        topncontrol->TopNEntries = entry;
        topncontrol->TopNLast = entry;
        entry->Prev = NULL;
        entry->Next = NULL;
        return TRUE;
    }

    entry->Prev = topncontrol->TopNLast;
    entry->Next = NULL;
    topncontrol->TopNLast->Next = entry;
    topncontrol->TopNLast = entry;

    return EntryUpdateList(topncontrol, entry);
}


BOOLEAN EntryUpdateList(DNPAP_TOPN_CONTROL *topncontrol, DNPAP_TOPN_ENTRY *entry)
{
DNPAP_TOPN_ENTRY *p;
BOOLEAN update = FALSE;

    if (topncontrol->TopNEntries == entry)
        return TRUE;

    for (p = entry->Prev; p != NULL; p = p->Prev)
    {
        if (p->Rate >= entry->Rate)
            break;
        update = TRUE;
    }

    if (update == FALSE)
        return TRUE;

    entry->Prev->Next = entry->Next;
    if (entry->Next != NULL)
        entry->Next->Prev = entry->Prev;
    else
        topncontrol->TopNLast = entry->Prev;

    if (p != NULL)
    {
        entry->Prev = p;
        entry->Next = p->Next;
        p->Next->Prev = entry;
        p->Next = entry;
    }
    else
    {
        entry->Prev = p;
        entry->Next = topncontrol->TopNEntries;
        topncontrol->TopNEntries->Prev = entry;
        topncontrol->TopNEntries = entry;
    }

    return TRUE;
}
