#ifndef _DTOPN_C_H
#define _DTOPN_C_H


#include <dnpap.h>
#include <hash.h>
#include <mibsup.h>
#include <timer.h>

#include "dtopn_d.h"


typedef struct _DNPAP_TOPN_ENTRY
{
	BYTE  Address[HOST_SZEADDR];
    ULONG PrevValue;        /*  statistics in host structure are ULONG's too  */
	ULONG Rate;

    struct _DNPAP_TOPN_ENTRY  *Prev;
    struct _DNPAP_TOPN_ENTRY  *Next;
	
} DNPAP_TOPN_ENTRY;


typedef struct _DNPAP_TOPN_CONTROL
{
    LONG  HostIndex;
    LONG  RateBase;
    LONG  TimeRemaining;
    LONG  Duration;
    LONG  RequestedSize;
    ULONG StartTime;
    BYTE  Owner[SNMP_SIZE_BUFCHR];
    WORD  OwnerLen;
    WORD  Status;

    LONG  TableSize;
    HashTable *Table;
    
    DNPAP_TOPN_ENTRY  *TopNEntries;
    DNPAP_TOPN_ENTRY  *TopNLast;
    DNPAP_TOPN_ENTRY **TopNArray;
    
    TIMER_DESCR *Timer;

} DNPAP_TOPN_CONTROL;


BOOLEAN TopNCInit(DNPAP_TOPN_CONTROL *topncontrol);
BOOLEAN TopNCStart(DNPAP_TOPN_CONTROL *topncontrol);
BOOLEAN TopNCStop(DNPAP_TOPN_CONTROL *topncontrol);

BOOLEAN EntryAddList(DNPAP_TOPN_CONTROL *topncontrol, DNPAP_TOPN_ENTRY *entry);
BOOLEAN EntryUpdateList(DNPAP_TOPN_CONTROL *topncontrol, DNPAP_TOPN_ENTRY *entry);
DNPAP_TOPN_ENTRY* TopNEntrySearch(DNPAP_TOPN_CONTROL *topncontrol, SNMP_OBJECT *obj, WORD idlen);
      
BOOLEAN FillEntryTable(DNPAP_TOPN_CONTROL *topncontrol, LONG reqsize);


#endif
