/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       npclient.c
**     SYSTEM   NAME:       namepipe
**     ORIGINAL AUTHOR(S):  Jan van Oorschot
**     VERSION  NUMBER:     1.00
**     CREATION DATE:       1990/9/9
**
** DESCRIPTION: Client part op a named-pipe application.
**              Openss a named pipe and writes a request.
**              Waits for the server to answer, and then closes
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision$
** WORKFILE:    $Workfile$
** LOGINFO:     $Log$
*************************************************************************/
#if ! defined(PRD)
static char _pvcs_hdr[] =
"$Header$";
#endif

#include    <os2.h>

#include    <stdio.h>
#include    <stdlib.h>
#include    <string.h>
#include    <memory.h>

#include    <dnpap.h>

#define     BUFLEN  1024
USHORT  clientprotocol(USHORT usHndl);

/* "namepipe.h" */

int         main( int argc, char **argv);

/**************************************************************
** NAME:        main
** SYNOPSIS:    int main(int argc, char **argv);
** DESCRIPTION: driver routine client <namepipe> application
**              should be called as
**              argv[1] =   <name pipe name>
** RETURNS:     0 -->   no error
**              else    error code
**************************************************************/
int     main( int argc, char **argv)
{
    USHORT  usHndl;
    USHORT  uRet;
    USHORT  usAction;


    /* opens the named pipe  as a normal file */
    uRet = DosOpen(
        "\\pipe\\nptest",
        &usHndl,                        /* address of file handle */
        &usAction,                      /* action taken           */
        100L,                           /* size of new file       */
        FILE_NORMAL,                    /* file attribute         */
        FILE_OPEN,                      /* create the file        */
        OPEN_ACCESS_READWRITE |
        OPEN_SHARE_DENYNONE |
        OPEN_FLAGS_WRITE_THROUGH,     /* open mode */
        0L);                            /* reserved          */

    if (uRet != 0)
    {
        fprintf(stderr," Can't open pipe <%d,%d>\n",uRet,errno);
        exit(2);
    }

    /* perform the client protocol */
    uRet = clientprotocol( usHndl);

    /* DosBufReset(usHndl); */
    /* close the pipe connection */
    uRet = DosClose(usHndl);

    return 0;
}

/**************************************************************
** NAME:        clientprotocol
** SYNOPSIS:    USHORT  clientprotocol(USHORT usHndl);
** DESCRIPTION: Perform the client protocol on
**              the opened and connected named pipe.
** RETURNS:     0 -->   no error
**              else    error code
**************************************************************/
USHORT  clientprotocol(USHORT usHndl)
{
    char    wBuf[BUFLEN];
    char    rBuf[BUFLEN];
    USHORT  uRead;
    USHORT  uWrite;
    USHORT  uRet;

    while(1)
    {
    printf("give your string: \n");
    gets(wBuf);
    printf("Sending <%s>\n",wBuf);
    uRet = DosWrite(
            usHndl,
            wBuf,
            strlen(wBuf)+1,
            &uWrite);
    printf("Return code: %d\n",uRet);

    uRet = DosRead(       
            usHndl,
            rBuf,
            BUFLEN,
            &uRead);
    printf("Received <%s>\n",rBuf);
    printf("Return code: %d\n",uRet);
    }

    return 0;
}
