#include <stddef.h> 
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <dnpap.h>
#include <snmp.h>
#include "protocol.h"
#include "prot.h"

BYTE *protIPString[] =
{
    "VERS",                      
    "HLEN",                  
    "SERVICE_TYPE",          
    "TOTAL_LENGTH",          
    "IDENTIFICATION",        
    "FLAGS",
    "FRAGMENT_OFFSET",       
    "TIME_TO_LIVE",          
    "PROTOCOL",              
    "HEADER_CHECKSUM",       
    "SOURCE_IP_ADDRESS",     
    "DESTINATION_IP_ADDRESS",
    "IP_OPTIONS"            
};

static WORD HLen;

BOOLEAN ProtIPHeader (PROT_PKT *Pkt)
{
    if (Pkt->DataLen < 20)
        return (FALSE);
    if ((Pkt->Frame = DnpapMalloc (sizeof(PROT_IP))) == NULL)
        return (FALSE);
    Pkt->Frame->Ip.Vers = Pkt->Ptr;
    Pkt->Frame->Ip.HLen = Pkt->Ptr;

    HLen = 4 * (WORD)(*(Pkt->Frame->Ip.HLen) & 0x0F);
    if (Pkt->DataLen < HLen)
        return (FALSE);

    Pkt->Frame->Ip.Service = Pkt->Ptr + 1;
    Pkt->Frame->Ip.TLen = Pkt->Ptr + 2;
    Pkt->Frame->Ip.ID = Pkt->Ptr + 4;
    Pkt->Frame->Ip.Flags = Pkt->Ptr + 6;
    Pkt->Frame->Ip.Fragment = Pkt->Ptr + 6;
    Pkt->Frame->Ip.Time = Pkt->Ptr + 8;
    Pkt->Frame->Ip.Type = Pkt->Ptr + 9;
    Pkt->Frame->Ip.ChkSum = Pkt->Ptr + 10;
    Pkt->Frame->Ip.IPSrc = Pkt->Ptr + 12;
    Pkt->Frame->Ip.IPDst = Pkt->Ptr + 16;
    Pkt->Frame->Ip.IPOption = Pkt->Ptr + 20;
    Pkt->Frame->Ip.Data = Pkt->Ptr + HLen;

    switch (*(Pkt->Frame->Ip.Type))
    {
        case 1:
            Pkt->ChildProt = PROT_PKTICMP;
            break;
        case 6:
            Pkt->ChildProt = PROT_PKTTCP;
            break;
        case 17:
            Pkt->ChildProt = PROT_PKTUDP;
            break;
        default:
            Pkt->ChildProt = PROT_PKTUNKNOWN;
    }
    return (TRUE);
}

BOOLEAN ProtIPField (PROT_PKT *Pkt, PROT_OBJ *Obj)
{
    BYTE t[2];

    if (Obj->Level == 0 && Obj->Id[1] == PROT_TYPE)
    {
        Obj->Type = SNMP_GAUGE;
        Obj->Syntax.LngUns = (LWORD) Pkt->ChildProt;
        return (TRUE);
    }

    if (Obj->Id[0] == PROT_PKTIP)
    {
        switch (Obj->Id[1])
        {
            case 1:
                Obj->Type = SNMP_GAUGE;
                Obj->Syntax.LngUns = (LWORD) *(Pkt->Frame->Ip.Vers);
                Obj->Syntax.LngUns >>= 4;
                memset(&Obj->Id[2], 0, SNMP_SIZE_OBJECTID - 4);
                return (TRUE);
            case 2:
                Obj->Type = SNMP_GAUGE;
                Obj->Syntax.LngUns = (LWORD) (*(Pkt->Frame->Ip.HLen) & 0x0F);
                memset(&Obj->Id[2], 0, SNMP_SIZE_OBJECTID - 4);
                return (TRUE);
            case 3:
                Obj->Type = SNMP_GAUGE;
                Obj->Syntax.LngUns = (LWORD) *(Pkt->Frame->Ip.Service);
                memset(&Obj->Id[2], 0, SNMP_SIZE_OBJECTID - 4);
                return (TRUE);
            case 4:
                Obj->Type = SNMP_GAUGE;
                PROT_NETWORD(Obj->Syntax.LngUns, Pkt->Frame->Ip.TLen)
                memset(&Obj->Id[2], 0, SNMP_SIZE_OBJECTID - 4);
                return (TRUE);
            case 5:                    
                Obj->Type = SNMP_GAUGE;
                PROT_NETWORD(Obj->Syntax.LngUns, Pkt->Frame->Ip.ID)
                memset(&Obj->Id[2], 0, SNMP_SIZE_OBJECTID - 4);
                return (TRUE);
            case 6:
                Obj->Type = SNMP_GAUGE;
                Obj->Syntax.LngUns = (LWORD) *(Pkt->Frame->Ip.Flags);
                Obj->Syntax.LngUns >>= 5;
                memset(&Obj->Id[2], 0, SNMP_SIZE_OBJECTID - 4);
                return (TRUE);
            case 7:
                Obj->Type = SNMP_GAUGE;
                t[0] = (BYTE) (*(Pkt->Frame->Ip.Fragment) & 0x1F);
                t[1] = *(Pkt->Frame->Ip.Fragment + 1);
                PROT_NETWORD(Obj->Syntax.LngUns, t)
                memset(&Obj->Id[2], 0, SNMP_SIZE_OBJECTID - 4);
                return (TRUE);
            case 8:
                Obj->Type = SNMP_TIMETICKS;
                Obj->Syntax.LngUns = (LWORD) *(Pkt->Frame->Ip.Time);
                memset(&Obj->Id[2], 0, SNMP_SIZE_OBJECTID - 4);
                return (TRUE);
            case 9:
                Obj->Type = SNMP_GAUGE;
                Obj->Syntax.LngUns = (LWORD) *(Pkt->Frame->Ip.Type);
                memset(&Obj->Id[2], 0, SNMP_SIZE_OBJECTID - 4);
                return (TRUE);
            case 10:
                Obj->Type = SNMP_GAUGE;
                PROT_NETWORD(Obj->Syntax.LngUns, Pkt->Frame->Ip.ChkSum)
                memset(&Obj->Id[2], 0, SNMP_SIZE_OBJECTID - 4);
                return (TRUE);
            case 11:
                Obj->Type = SNMP_IPADDR;
                Obj->Syntax.LngUns = *((LWORD*) Pkt->Frame->Ip.IPSrc);
                memset(&Obj->Id[2], 0, SNMP_SIZE_OBJECTID - 4);
                return (TRUE);
            case 12:
                Obj->Type = SNMP_IPADDR;
                Obj->Syntax.LngUns = *((LWORD*)Pkt->Frame->Ip.IPDst);
                memset(&Obj->Id[2], 0, SNMP_SIZE_OBJECTID - 4);
                return (TRUE);
            case 13:
                Obj->Type = SNMP_OCTETSTR;           /* only total option field */
                Obj->SyntaxLen = 4 * (*(Pkt->Frame->Ip.HLen) & 0x0F) - 20;
                memcpy (Obj->Syntax.BufChr, Pkt->Frame->Ip.IPOption, Obj->SyntaxLen);
                memset(&Obj->Id[2], 0, SNMP_SIZE_OBJECTID - 4);
                return (TRUE);
            case 14:
                Obj->Type = SNMP_NULL;
                if (Pkt->DataLen <= HLen)
                    Obj->SyntaxLen = 0;
                else
                    Obj->SyntaxLen = Pkt->DataLen - HLen;
                Obj->Syntax.Ptr = Pkt->Frame->Ip.Data;
                memset(&Obj->Id[2], 0, SNMP_SIZE_OBJECTID - 4);
                return (TRUE);
            default:
                return (FALSE);
        }
    }

    if (Obj->Level > 0 && Pkt->ChildProt != PROT_PKTUNKNOWN)
    {
        if (Pkt->Child == NULL)
        {
            if ((Pkt->Child = DnpapMalloc (sizeof(PROT_PKT))) == NULL)
                return (FALSE);
            Pkt->Child->Ptr = Pkt->Frame->Ip.Data;
            Pkt->Child->Child = NULL;
            Pkt->Child->DataLen = Pkt->DataLen - HLen;
            if ((ProtPtr[Pkt->ChildProt].Header(Pkt->Child)) == FALSE)
            {
                DnpapFree(Pkt->Child);
                return (FALSE);
            }
        }
        Obj->Level--;
        return (ProtPtr[Pkt->ChildProt].Field (Pkt->Child, Obj));
    }
    return (FALSE);
}

BOOLEAN ProtIPPrint (PROT_OBJ *Obj, BYTE **StrPtr)
{
    WORD Ind;
    BYTE Char[4];

    switch (Obj->Id[1])
    {
        case 1:                             /* Vers */
        case 2:                             /* HLen */
        case 9:                             /* Type */
            sprintf(protocolString, "%2lu", Obj->Syntax.LngUns);
            *StrPtr = protocolString;
            return (TRUE);
        case 8:                             /* Time to Live */
            sprintf(protocolString, "%4lu", Obj->Syntax.LngUns);
            *StrPtr = protocolString;
            return (TRUE);
        case 3:                             /* Service */
            sprintf(protocolString, "%02lx", Obj->Syntax.LngUns);
            *StrPtr = protocolString;
            return (TRUE);
        case 4:                             /* Total Len */
            sprintf(protocolString, "%6lu", Obj->Syntax.LngUns);
            *StrPtr = protocolString;
            return (TRUE);
        case 5:                             /* Identification */
        case 7:                             /* Fragment */
        case 10:                            /* Check Sum */
            sprintf(protocolString, "%04lx", Obj->Syntax.LngUns);
            *StrPtr = protocolString;
            return (TRUE);
        case 6:                             /* Flags */
            sprintf(protocolString, "%01lx", Obj->Syntax.LngUns);
            *StrPtr = protocolString;
            return (TRUE);
        case 11:                            /* IP Src */
        case 12:                            /* IP Dst */
            sprintf(protocolString, "%u.%u.%u.%u",
                ((BYTE*) &Obj->Syntax.LngUns)[0],
                ((BYTE*) &Obj->Syntax.LngUns)[1],
                ((BYTE*) &Obj->Syntax.LngUns)[2],
                ((BYTE*) &Obj->Syntax.LngUns)[3]);
            *StrPtr = protocolString;
            return (TRUE);
        case 13:                            /* IP Options */
            *protocolString = '\0';
            for (Ind = 0; Ind < Obj->SyntaxLen; Ind++)
            {
                sprintf(Char, "%02x",Obj->Syntax.BufChr[Ind]);
                strcat(protocolString, Char);
            }
            *StrPtr = protocolString;
            return (TRUE);
        default:
            return (FALSE);
    }
}
