#include <limits.h>
#include <dnpap.h>
#include <message.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dstring.h>

#include "bitbyte.h"


INT Txt2Bits(BYTE **data, WORD offset, BOOLEAN *bytes, BYTE *string, WORD len)
{
WORD i, n, bitsize, bytesize;
CHAR* p;
CHAR* eptr;
LONG lval;
BYTE *ptr;

    if (strspn(string, "01") == strlen(string))
    {
        /*  assume bit string  */  
        bitsize = len;
        bytesize = (offset+bitsize+BITS(BYTE)-1)/BITS(BYTE);
        if ((ptr = DnpapRealloc(*data, bytesize)) == NULL)   /*  as much bits as characters  */
        {
            DnpapMessage(DMC_ERROR, FILTER_ERROR, "bitbyte: text to bit conversion failed");
            return -1;
        }
        for (i = 0; i < len; i++)
            if (SetBit(ptr, bitsize, offset, i, (BYTE)(string[i] == '1')) == FALSE)
            {
                DnpapMessage(DMC_ERROR, FILTER_ERROR, "bitbyte: text to bit conversion failed");
                return -1;
            }
        *bytes = FALSE;
    }
    else
    {
        /*  assume byte string  */
        string[len] = '\0';     /*  make sure string is null-terminated  */
        bitsize = BITS(BYTE)*(strcnt(string, ':') + 1);
        bytesize = (offset+bitsize+BITS(BYTE)-1)/BITS(BYTE);
        if ((ptr = DnpapRealloc(*data, bytesize)) == NULL)    /*  as much bytes as ':' characters + 1  */
        {
            DnpapMessage(DMC_ERROR, FILTER_ERROR, "bitbyte: text to bit conversion failed");
            return -1;
        }
        n = 0;
	    p = strtok(string, ":");
	    while (p != NULL)
	    {
		    if ((lval = strtol(p, &eptr, 0)) < 0 || lval > UCHAR_MAX || strlen(eptr) > 0)
            {
                DnpapMessage(DMC_ERROR, FILTER_ERROR, "bitbyte: text to bit conversion failed");
			    return -1;
            }
		    SetByte(ptr, bitsize, offset, n++*BITS(BYTE), (BYTE)lval);
		    p = strtok(NULL, ":");
	    }
        for (i = 0; i < offset; i++)
            SetBit(ptr, n*BITS(BYTE), 0, i, 0);
        for (i = offset+bitsize; i < n*BITS(BYTE); i++)
            SetBit(ptr, n*BITS(BYTE), 0, i, 0);
        *bytes = TRUE;
    }
    *data = ptr;
    return bitsize;
}

INT Bits2Txt(BYTE *string, BYTE *data, WORD len, WORD offset, BOOLEAN bytes)
{
WORD i, c, n;
BYTE b, value;

    if (bytes == TRUE && (len % BITS(BYTE)) == 0)
    {
        n = 0;
        for (i = 0; i < len; i += BITS(BYTE))
        {
            if (GetByte(data, len, offset, i, &b) == FALSE)
            {
                DnpapMessage(DMC_ERROR, FILTER_ERROR, "bitbyte: bit to text conversion failed");
			    return -1;
            }
            if (b == 0)
            {
                sprintf(string+n, "0x");
                n += 2;
            }
            sprintf(string+n, "%#02.2x%n", b, &c);
            n += c;
            if (i < len-BITS(BYTE))
                sprintf(string+n++, ":");
        }
        return n;
    }
    else
    {
        for (i = 0; i < len; i++)
            if (GetBit(data, len, offset, i, &value) ==  FALSE)
            {
                DnpapMessage(DMC_ERROR, FILTER_ERROR, "bitbyte: bit to text conversion failed");
			    return -1;
            }
            else
                string[i] = (BYTE)(value != 0 ? '1' : '0');
        string[i] = '\0';
        return i;
    }
}

BOOLEAN SetBit(BYTE *data, WORD bitsize, WORD offset, WORD bitindex, BYTE value)
{
WORD nbytes = (offset+bitindex+BITS(BYTE))/BITS(BYTE);
WORD bitoffset = (offset+bitindex) % BITS(BYTE);
BYTE b;
	    
    if (bitindex < bitsize)
    {
	    b = data[nbytes-1];
	    if (value != 0)
		    b |= ((1 << BITS(BYTE)) >> (bitoffset+1));
	    else
		    b &= ~((1 << BITS(BYTE)) >> (bitoffset+1));
	    data[nbytes-1] = b;
        return TRUE;
    }
    else
        return FALSE;
}

BOOLEAN GetBit(BYTE *data, WORD bitsize, WORD offset, WORD bitindex, BYTE *value)
{
WORD nbytes = (offset+bitindex+BITS(BYTE))/BITS(BYTE);
WORD bitoffset = (offset+bitindex) % BITS(BYTE);
BYTE b;
			      
	if (bitindex < bitsize)
	{
		b = data[nbytes-1];
		*value = b & ((1 << BITS(BYTE)) >> (bitoffset+1));
        return TRUE;
	}
	else
        return FALSE;
}

BOOLEAN SetByte(BYTE *data, WORD len, WORD offset, WORD index, BYTE value)
{
WORD bindex, boffset;

    if (index >= len)
        return FALSE;
    bindex = (offset+index)/BITS(BYTE);
    boffset = (offset+index) - bindex*BITS(BYTE);
    if (boffset == 0)
        data[bindex] = value;
    else
    {
        data[bindex] = data[bindex] & (-1 << (BITS(BYTE)-boffset)) | (value >> boffset);
        if (bindex*BITS(BYTE) < len)
            data[bindex+1] = data[bindex+1] & (((BYTE)-1) >> boffset) | (value << (BITS(BYTE)-boffset));
    }
}

BOOLEAN GetByte(BYTE *data, WORD len, WORD offset, WORD index, BYTE *byte)
{
WORD bindex, boffset;

    if (index >= len)
        return FALSE;
    bindex = (offset+index)/BITS(BYTE);
    boffset = (offset+index) - bindex*BITS(BYTE);
    if (boffset == 0)
        *byte = data[bindex];
    else
    {
        *byte = (data[bindex] << boffset) | ((bindex*BITS(BYTE) < len) ? (data[bindex+1] >> (BITS(BYTE)-boffset)) : 0);
        if (index+BITS(BYTE) > len)
            *byte = *byte & (-1 << index+BITS(BYTE)-len);
    }
    return TRUE;
}

BYTE* ShiftBits(BYTE *data, WORD len, WORD offset, WORD newlen, WORD newoffset, WORD extend)
{
BYTE *ptr;
BYTE value;
INT i;
WORD nbytes = (offset+len+BITS(BYTE)-1)/BITS(BYTE);
WORD newnbytes = (newoffset+newlen+BITS(BYTE)-1)/BITS(BYTE);

    if (offset == newoffset && len == newlen)
        return data;

    if ((ptr = DnpapMalloc(newnbytes)) == NULL)
        return NULL;

    for (i = 0; i < len && i < newlen; i++)
    {
        GetBit(data, len, offset, i, &value);
        SetBit(ptr, newlen, newoffset, i, value);
    }

    for (i = len; i < newlen; i++)
        SetBit(ptr, newlen, newoffset, i, (BYTE)(extend != 0 ? 1 : 0));

    /*  set first offset bits to 0  */
    for (i = 0; i < newoffset; i++)
        SetBit(ptr, newoffset, 0, i, 0);
    /*  set last 'unused' bits to 0  */
    for (i = newoffset+newlen; i < newnbytes*BITS(BYTE); i++)
        SetBit(ptr, newnbytes*BITS(BYTE), 0, i, 0);
    DnpapFree(data);
    return ptr;
}

BOOLEAN BitsZero(BYTE *data, WORD len, WORD offset)
{
BYTE value;
WORD i;

    for (i = 0; i < len; i++)
    {
        GetBit(data, len, offset, i, &value);
        if (value != 0)
            return FALSE;
    }
    return TRUE;
}



#ifdef TEST

int main(int argc, char *argv[])
{
BYTE *buffer;
BOOLEAN bytes;
BYTE b;
WORD len;
CHAR line[256];

    len = Txt2Bits(&buffer, 3, &bytes, "11010101100101", strlen("11010101100101"));
    Bits2Txt(line, buffer, len, 3, bytes);
    printf("%s\n", line);

    SetBit(buffer, len, 3, 7, 1);
    Bits2Txt(line, buffer, len, 3, bytes);
    printf("%s\n", line);

    SetBit(buffer, len, 3, 7, 0);
    Bits2Txt(line, buffer, len, 3, bytes);
    printf("%s\n", line);

    GetByte(buffer, len, 3, 0, &b);
    printf("%d\n", b);
    GetByte(buffer, len, 3, BITS(BYTE), &b);
    printf("%d\n", b);

    SetByte(buffer, len, 3, 0, 0xf3);
    GetByte(buffer, len, 3, 0, &b);
    Bits2Txt(line, buffer, len, 3, bytes);
    printf("%s\n", line);
    printf("%d\n", b);

    SetBit(buffer, len, 3, 7, 1);
    SetByte(buffer, len, 3, 0, 0x00);
    SetByte(buffer, len, 3, BITS(BYTE), 0xff);
    SetByte(buffer, len, 3, 2*BITS(BYTE), 0x00);
    GetByte(buffer, len, 3, BITS(BYTE), &b);
    Bits2Txt(line, buffer, len, 3, bytes);
    printf("%s\n", line);
    printf("%d\n", b);

    buffer = ShiftBits(buffer, len, 3, len, 5, 1);
    Bits2Txt(line, buffer, len, 5, bytes);
    printf("%s\n", line);

    buffer = ShiftBits(buffer, len, 5, len+10, 7, 1);
    Bits2Txt(line, buffer, len+10, 7, bytes);
    printf("%s\n", line);

    len = Txt2Bits(&buffer, 3, &bytes, "11010101100101", strlen("11010101100101"));
    Bits2Txt(line, buffer, len, 3, bytes);
    printf("%s\n", line);

    printf("bits all zero: %s\n", BitsZero(buffer, len, 3) == TRUE ? "TRUE" : "FALSE");

    len = Txt2Bits(&buffer, 3, &bytes, "0000000000000000", strlen("0000000000000000"));
    Bits2Txt(line, buffer, len, 3, bytes);
    printf("%s\n", line);

    printf("bits all zero: %s\n", BitsZero(buffer, len, 3) == TRUE ? "TRUE" : "FALSE");

    DnpapFree(buffer);

    return 0;
}

#endif
