!include ..\..\include\standard.mak

SYS     = config
SYSLIB  = dnpap

OBJ = high.obj low.obj value.obj

all: obj doc

install: all $(INCDIR)\$(SYS).h $(MANDIR)\$(SYS).man $(LIBDIR)\$(SYSLIB).lib

$(INCDIR)\$(SYS).h: $(SYS).h 
	$(CP) $(SYS).h $(INCDIR)\$(SYS).h

$(MANDIR)\$(SYS).man: $(SYS).man 
	$(CP) $(SYS).man $(MANDIR)\$(SYS).man 

$(LIBDIR)\$(SYSLIB).lib: high.obj low.obj value.obj
	$(AR) $(LIBDIR)\$(SYSLIB).lib -+high.obj -+low.obj -+value.obj;

obj: $(OBJ)

doc: $(SYS).man

clean:
    - $(RM) *.exe
    - $(RM) *.obj
    - $(RM) *.i
    - $(RM) *.lib
    - $(RM) *.man
    - $(RM) *.err
    - $(RM) *.bak

$(SYS).man: high.c low.c value.c
    $(MAN) high.c low.c value.c > $(SYS).man

high.obj: high.c $(SYS).h

low.obj: low.c $(SYS).h

value.obj: value.c $(SYS).h

test: test.exe

test.exe: test.obj $(OBJ)
	$(LINK) test.obj $(OBJ) dnpap.lib

