#ifdef MSC
/* these are needed by the OS/2 TCP/IP implementation */
#define  BSD_SELECT 1
typedef unsigned long u_long;
typedef unsigned short u_short;
#include <netinet/in.h>
#include <types.h>
#include <sys/select.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <errno.h>
#include <netdb.h>
#else
/* these are needed by the normal TCP/IP implementation */
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <errno.h>
#include <netdb.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#endif


#include <stdio.h>
#include <stdlib.h>
#include <memory.h>

#include <dnpap.h>
#include "mgmt.h"

extern int h_errno;

int select(int nfds, fd_set *readfds, fd_set *writefds,
    fd_set *exceptfds, struct timeval *timeout);

BOOLEAN UdpOpen(MGMT *mgmt, char *name)
{
    struct hostent      *ent;
    struct sockaddr_in  server;
    int                 s;
    unsigned long       adr;
    int ret;
           
#ifdef MSC
/*    sock_init(); */
#endif

    ent=gethostbyname(name);
    if (ent==NULL)
    {
        DnpapMessage(DMC_WARNING, MGMT_ERROR+4,
            "Error in gethostbyname(%s) <%d>\n",
            name,
            h_errno);
    	adr=inet_addr(name);            
    	ent=gethostbyaddr((char *)&adr,4,2);
    }

    if (ent==NULL)
        return FALSE;

    s=socket(AF_INET, SOCK_DGRAM, 0);
    if (s<0)
        return FALSE;

    server.sin_family       = AF_INET;
    server.sin_port         = htons(161);
    server.sin_addr.s_addr  = ((struct in_addr *)(ent->h_addr))->s_addr;

    if ((ret=connect(s, (struct sockaddr *)&server, sizeof(server)))!=0)
    {

        DnpapMessage(DMC_WARNING, MGMT_ERROR+5,
            "Error in connect <%d><%d>\n",
            ret,
            h_errno);
        return FALSE;
    }

    mgmt->medium.udp.socket = s;

    return TRUE;
}


BOOLEAN UdpClose(MGMT *mgmt)
{     
#ifdef MSC
    soclose(mgmt->medium.udp.socket);
#endif
    return TRUE;
}


BOOLEAN UdpSend(MGMT *mgmt, BYTE *buffer, WORD length)
{
    int s, ret;
    
    s = mgmt->medium.udp.socket;

    ret = send(s, buffer, length, 0);
    
    return (ret >= 0);
}



BOOLEAN UdpRecv(MGMT *mgmt, BYTE **buffer, WORD *length, ULONG timeout)
{
    int                 s, ret;
    fd_set              mask;
    struct timeval      t;
    BYTE                data[1514];
    BOOLEAN             success = FALSE;
    
    
    s = mgmt->medium.udp.socket;

    t.tv_sec  = timeout / 1000000L;
    t.tv_usec = timeout % 1000000L;
   
    ret=-1;
    FD_ZERO(&mask);
    FD_SET(s,&mask);
    ret = select(s+1,&mask,NULL,NULL,&t);
   
    if (ret>0)
    {
        /* socket has been released */
        ret = recv(s, data, sizeof(data), 0);
        if (ret >= 0)
        {
            *buffer = data;
            *length = ret;
            success = TRUE;
        }
    }
    return success;
}

