#!/usr/local/bin/perl

# this program is a demonstration of the Tricklet 
# perl interface made by the DNPAP group of
# the Technical University Delft, The Netherlands.
# 
require "spook.pl";
#
# handle the arguments
#
if( @ARGV != 3 )
{
	die "call as:  demo.pl <host> <community> <medium>\n";
}
($iniHost , $iniComm , $iniMed , @rest) = @ARGV;
printf("Communicating with %s through medium %s, community %s\n",
	$iniHost,
	$iniComm,
	$iniMed);
#
# open a SNMP connection 
#
&snmp_open(1) || die "cant open\n";
&snmp_host(1,$iniHost);
&snmp_medium(1,$iniMed);
&snmp_community(1,$iniComm);
&snmp_connect(1) || die "could't connect";
#
# get the table of system group. The snmp_tbl command
# needs a call-back function which will be called 
# for each line of the resulting table as:
#
#	demoFun( rowNr , colNr , ((valName1,valIndex1,valValue1)(...) ...) )
#
sub demoFun
{
	local($i,$j,@repl) = @_;
	
	print "<$i><$j> --> $repl[0]\[$repl[1]\]\=$repl[2]\n";
}

&snmp_tbl(1,main'demoFun,("system[]"));
#
# close the SNMP connection
#
&snmp_disconnect(1);
&snmp_close(1);

