#ifndef _ASN1_H_
#define _ASN1_H_

                             /* Class       */
#define ASN1_UNI       0     /* Universal   */
#define ASN1_APL       1     /* Application */
#define ASN1_CTX       2     /* Context     */
#define ASN1_PRV       3     /* Private     */

                             /* Tag                */
#define ASN1_EOC       0     /* End Of Contents    */
#define ASN1_BOL       1     /* Boolean            */
#define ASN1_INT       2     /* Integer            */
#define ASN1_BTS       3     /* Bit String         */
#define ASN1_OTS       4     /* Octet String       */
#define ASN1_NUL       5     /* Null               */
#define ASN1_OJI       6     /* Object Identifier  */
#define ASN1_OJD       7     /* Object Description */
#define ASN1_EXT       8     /* External           */
#define ASN1_SEQ       16    /* Sequence           */
#define ASN1_SET       17    /* Set                */
#define ASN1_NUMSTR    18    /* Numerical String   */
#define ASN1_PRNSTR    19    /* Printable String   */
#define ASN1_TEXSTR    20    /* Teletext String    */
#define ASN1_VIDSTR    21    /* Video String       */
#define ASN1_IA5STR    22    /* IA5 String         */
#define ASN1_UNITIM    23    /* Universal Time     */
#define ASN1_GENTIM    24    /* General Time       */
#define ASN1_GRASTR    25    /* Graphical String   */
#define ASN1_VISSTR    26    /* Visible String     */
#define ASN1_GENSTR    27    /* General String     */

                             /* Primitie / Constructed */
#define ASN1_PRI     0       /* Primitive              */
#define ASN1_CON     1       /* Constructed            */

                             /* Mode to open ASN11 */
#define ASN1_ENC     0       /* Encoding          */
#define ASN1_DEC     1       /* Decoding          */
 

typedef struct _ASN1_SCK ASN1_SCK;

struct _ASN1_SCK
{                            /* ASN1 socket                         */
    char    *Pointer;        /* Octet just encoded or to be decoded */
    char    *Begin;          /* First octet                         */
    char    *End;            /* Octet after last octet              */
};


void Asn1Opn __((ASN1_SCK *Asn1, char *Buf, unsigned Len, unsigned Mde));
void Asn1Cls __((ASN1_SCK *Asn1, char **Buf, unsigned *Len));
BOOLEAN Asn1OctEnc __((ASN1_SCK *Asn1, unsigned char Chr));
BOOLEAN Asn1OctDec __((ASN1_SCK *Asn1, unsigned char *Chr));
BOOLEAN Asn1TagEnc __((ASN1_SCK *Asn1, unsigned Tag));
BOOLEAN Asn1TagDec __((ASN1_SCK *Asn1, unsigned *Tag));
BOOLEAN Asn1IdrEnc __((ASN1_SCK *Asn1, unsigned Cls, unsigned Con, unsigned Tag));
BOOLEAN Asn1IdrDec __((ASN1_SCK *Asn1, unsigned *Cls, unsigned *Con, unsigned *Tag));
BOOLEAN Asn1LenEnc __((ASN1_SCK *Asn1, unsigned Def, unsigned Len));
BOOLEAN Asn1LenDec __((ASN1_SCK *Asn1, unsigned *Def, unsigned *Len));
BOOLEAN Asn1HdrEnc __((ASN1_SCK *Asn1, char *Eoc, unsigned Cls, unsigned Con, unsigned Tag));
BOOLEAN Asn1HdrDec __((ASN1_SCK *Asn1, char **Eoc, unsigned *Cls, unsigned *Con, unsigned *Tag));
BOOLEAN Asn1Eoc __((ASN1_SCK *Asn1, char *Eoc));
BOOLEAN Asn1EocEnc __((ASN1_SCK *Asn1, char **Eoc));
BOOLEAN Asn1EocDec __((ASN1_SCK *Asn1, char *Eoc));
BOOLEAN Asn1NulEnc __((ASN1_SCK *Asn1, char **Eoc));
BOOLEAN Asn1NulDec __((ASN1_SCK *Asn1, char *Eoc));
BOOLEAN Asn1BolEnc __((ASN1_SCK *Asn1, char **Eoc, BOOLEAN Bol));
BOOLEAN Asn1BolDec __((ASN1_SCK *Asn1, char *Eoc, BOOLEAN *Bol));
BOOLEAN Asn1IntEnc __((ASN1_SCK *Asn1, char **Eoc, int Int));
BOOLEAN Asn1IntDec __((ASN1_SCK *Asn1, char *Eoc, int *Int));
BOOLEAN Asn1IntEncLng __((ASN1_SCK *Asn1, char **Eoc, long Int));
BOOLEAN Asn1IntDecLng __((ASN1_SCK *Asn1, char *Eoc, long *Int));
BOOLEAN Asn1IntEncUns __((ASN1_SCK *Asn1, char **Eoc, unsigned Int));
BOOLEAN Asn1IntDecUns __((ASN1_SCK *Asn1, char *Eoc, unsigned *Int));
BOOLEAN Asn1IntEncLngUns __((ASN1_SCK *Asn1, char **Eoc, unsigned long Int));
BOOLEAN Asn1IntDecLngUns __((ASN1_SCK *Asn1, char *Eoc, unsigned long *Int));
BOOLEAN Asn1BtsEnc __((ASN1_SCK *Asn1, char **Eoc, char *Bts, unsigned BtsLen, unsigned char BtsUnu));
BOOLEAN Asn1BtsDec __((ASN1_SCK *Asn1, char *Eoc, char *Bts, unsigned BtsSze, unsigned *BtsLen, unsigned char *BtsUnu));
BOOLEAN Asn1OtsEnc __((ASN1_SCK *Asn1, char **Eoc, char *Ots, unsigned OtsLen));
BOOLEAN Asn1OtsDec __((ASN1_SCK *Asn1, char *Eoc, char *Ots, unsigned OtsSze, unsigned *OtsLen));
BOOLEAN Asn1SbiEnc __((ASN1_SCK *Asn1, unsigned long Sbi));
BOOLEAN Asn1SbiDec __((ASN1_SCK *Asn1, unsigned long *Sbi));
BOOLEAN Asn1OjiEnc __((ASN1_SCK *Asn1, char **Eoc, unsigned long *Oji, unsigned OjiLen));
BOOLEAN Asn1OjiDec __((ASN1_SCK *Asn1, char *Eoc, unsigned long *Oji, unsigned OjiSze, unsigned *OjiLen));


#endif


