/* global constants */
#define STRLEN	256
/* finit state machine state structure */

typedef struct _spook_obj SPOOK_OBJ;

struct _spook_obj
{
	/* state machine */
	int             have_list;	/* != 0 if a list is ready to be send */
	int             quit;	/* != 0 if want to quit */
	int		repeat;	/* 1 iff command should repeat (Table) */
	/* attributes */
	int             medium;	/* current mgmt medium */
	char            comm[STRLEN];	/* current community */
	int             commLen;
	char            host[STRLEN];	/* current target host */
	unsigned long   timeout;/* time out */
	unsigned short  retries;/* number of retries */
	MGMT           *handle;	/* management handle */
	SNMP_OBJECT	list[LIST_SIZE];
	unsigned	listLen;
	int             table[256];
	int             tableLen;
	int		tag;
};


int             SpookMessage(SPOOK_OBJ * spook, char *request, char *answer);
extern int      printf(const char *,...);
int             SpookMacro(SPOOK_OBJ * spook, char *request, char *answer);
int             SpookRequest(SPOOK_OBJ * spook, char *answer);
int             SpookGet(SPOOK_OBJ * spook, char *request, char *answer);
int             SpookSet(SPOOK_OBJ * spook, char *request, char *answer);
int             SpookTbl(SPOOK_OBJ * spook, char *request, char *answer);
int             SpookInfo(char *request, char *answer);

