/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE	NAME:	        stdspook.c
**     SYSTEM	NAME:	    tricklet
**     ORIGINAL AUTHOR(S):  Jan van Oorschot
**     VERSION	NUMBER:
**     CREATION DATE:
**
** DESCRIPTION: This module implemets the stdin/stdout interface
**              to Spook.
**
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION: $Revision$
** AUTHOR:   $Author$
** DATE:     $Date$
** LOG:	     $Log$
*************************************************************************/
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <stdarg.h>
#include <signal.h>
#include <ctype.h>

#include <dnpap.h>
#include <snmp.h>
#include <mibdf.h>
#include <dnpap.h>
#include <mgmt.h>
#include <config.h>
#include "exec.h"
#include "parse.h"
#include "spook.h"

static void handler(int signal)
{
	/* do nothing */
	return;
}

int             main(int argc, char *argv[])
{

	SPOOK_OBJ      *spook;
	char            request[STRLEN];
	char            answer[STRLEN];
							 
	/* see to it stdpook keeps running */
	DnpapSignal(SIGTERM,handler);
	DnpapSignal(SIGABRT,handler);
	DnpapSignal(SIGINT,handler);

	/* create a spool object to store th status in */

	spook = DnpapMalloc(sizeof(SPOOK_OBJ));
	if (spook == NULL)
	{
		DnpapMessage(DMC_ERROR, TRICKLET_ERROR, "Malloc Failed\n");
		DnpapExit(1);
	}
	if (argc >= 2)
	{
		strcpy(spook->host, argv[1]);
	} else
	{
		strcpy(spook->host, "nowhere");
	}
	if (argc >= 3)
	{
		if (argv[2][0] == 'U' || argv[2][0] == 'u')
			spook->medium = MGMT_TYPE_UDP;
		else if (argv[2][0] == 'P' || argv[2][0] == 'p')
			spook->medium = MGMT_TYPE_PIPE;
		else
			spook->medium = MGMT_TYPE_DEFAULT;
	} else
	{
		spook->medium = MGMT_TYPE_DEFAULT;
	}
	if (argc >= 4)
	{
		strcpy(spook->comm, argv[3]);
		spook->commLen = strlen(argv[3]);
	} else
	{
		strcpy(spook->comm, "public");
		spook->commLen = strlen(spook->comm);
	}
	if (argc >= 5)
		spook->timeout = atol(argv[4]);
	else
		spook->timeout = 0;
	if (argc >= 6)
		spook->retries = atoi(argv[5]);
	else
		spook->retries = 0;

	if (ConfigInit(argc, argv) == FALSE || ConfigLoad() == FALSE)
	{
		DnpapMessage(DMC_ERROR, TRICKLET_ERROR, "ConfigInit failed\n");
		DnpapExit(1);
	}
	if (MgmtInit() == FALSE)
	{
		DnpapMessage(DMC_ERROR, TRICKLET_ERROR, "MgmtInit failed\n");
		DnpapExit(1);
	}
	if (MibInit() != 0 || MibFullMib() != 0)
	{
		DnpapMessage(DMC_ERROR, TRICKLET_ERROR, "MibInit failed\n");
		DnpapExit(1);
	}
	/* try to begin with an open medium */

	spook->handle = NULL;

	/* Initialise the state machine */
	spook->have_list = 0;	/* you have no request */

	/* OK, start receiving requests and send answers back */
    spook->quit = 0;
	while (gets(request)!= NULL)
	{
		if (SpookMessage(spook, request, answer) != 0)
		{
			DnpapMessage(DMC_ERROR, TRICKLET_ERROR, "MibInit failed\n");
			DnpapExit(1);
		}
		puts(answer);
		fflush(stdout);
		if (spook->quit)
			break;
	}
	if (spook->handle != NULL)
		MgmtClose(spook->handle);

	return 0;
}

