#ifndef PROT_H
#define PROT_H

#include <dnpap.h>

#define PROT_TYPE          0

#define PROT_PKTUNKNOWN    0
#define PROT_PKTBEHOLDER   1
#define PROT_PKTETHERNET   2
#define PROT_PKTIP         3
#define PROT_PKTTCP        4
#define PROT_PKTUDP        5
#define PROT_PKTICMP       6
#define PROT_PKTARP        7
#define PROT_PKTRARP       8
#define PROT_PKTDNS        9
#define PROT_PKTDEC        10

typedef struct _PROT_BEHOLDER
{
    WORD        Type;                       /*  1 : MIB_GAUGE */
    WORD        IfIndex;                    /*  2 : MIB_GAUGE */
    LONG        ID;                         /*  2 : ID */
    WORD        Len;                        /*  3 : MIB_GAUGE */    
    LWORD       Time;                       /*  4 : MIB_TIMETICKS */
    BYTE FAR    *Data;                      /*  5 : MIB_NULL */
} PROT_BEHOLDER;                                

typedef struct _PROT_ETHERNET
{
    BYTE        *DstAdr;                    /*  1  : MIB_OCTETSTR */
    BYTE        *SrcAdr;                    /*  2  : MIB_OCTETSTR */
    BYTE        *Type;                      /*  3  : MIB_GAUGE */
    BYTE FAR    *Data;                      /*  4  : MIB_NULL */
} PROT_ETHERNET;

typedef struct _PROT_IP
{
    BYTE        *Vers;                      /*  1  : MIB_GAUGE */
    BYTE        *HLen;                      /*  2  : MIB_GAUGE */
    BYTE        *Service;                   /*  3  : MIB_GAUGE */
    BYTE        *TLen;                      /*  4  : MIB_GAUGE */
    BYTE        *ID;                        /*  5  : MIB_GAUGE */
    BYTE        *Flags;                     /*  6  : MIB_GAUGE */
    BYTE        *Fragment;                  /*  7  : MIB_GAUGE */
    BYTE        *Time;                      /*  8  : MIB_TIMETICKS */
    BYTE        *Type;                      /*  9  : MIB_GAUGE */
    BYTE        *ChkSum;                    /*  10 : MIB_GAUGE */
    BYTE        *IPSrc;                     /*  11 : MIB_IPADDR */
    BYTE        *IPDst;                     /*  12 : MIB_IPADDR */
    BYTE        *IPOption;                  /*  13 : MIB_OCTETSTR */
    BYTE FAR    *Data;                      /*  14 : MIB_NULL */
} PROT_IP;

typedef struct _PROT_ARP
{
    BYTE        *Hardw;                     /*  1  : MIB_GAUGE */
    BYTE        *Type;                      /*  2  : MIB_GAUGE */
    BYTE        *HLen;                      /*  3  : MIB_GAUGE */
    BYTE        *PLen;                      /*  4  : MIB_GAUGE */
    BYTE        *Operation;                 /*  5  : MIB_GAUGE */
    BYTE        *HwSender;                  /*  6  : MIB_OCTETSTR */
    BYTE        *ProtSender;                /*  7  : MIB_OCTETSTR */
    BYTE        *HwTarget;                  /*  8  : MIB_OCTETSTR */
    BYTE        *ProtTarget;                /*  9  : MIB_OCTETSTR */
    BYTE FAR    *Data;                      /*  10 : MIB_NULL */
} PROT_ARP;                                         

typedef struct _PROT_UDP
{
    BYTE        *SrcPort;                   /*  1  : MIB_GAUGE */
    BYTE        *DstPort;                   /*  2  : MIB_GAUGE */
    BYTE        *MLen;                      /*  3  : MIB_GAUGE */
    BYTE        *ChkSum;                    /*  4  : MIB_GAUGE */
    BYTE FAR    *Data;                      /*  5  : MIB_NULL */
} PROT_UDP;

typedef struct _PROT_TCP
{
    BYTE        *SrcPort;                   /*  1  : MIB_GAUGE */
    BYTE        *DstPort;                   /*  2  : MIB_GAUGE */
    BYTE        *SeqNr;                     /*  3  : MIB_GAUGE */
    BYTE        *AckNr;                     /*  4  : MIB_GAUGE */
    BYTE        *HLen;                      /*  5  : MIB_GAUGE */
    BYTE        *Reserved;                  /*  6  : MIB_GAUGE */
    BYTE        *Code;                      /*  7  : MIB_GAUGE */
    BYTE        *Window;                    /*  8  : MIB_GAUGE */
    BYTE        *ChkSum;                    /*  9  : MIB_GAUGE */
    BYTE        *UrgePtr;                   /*  10 : MIB_GAUGE */
    BYTE        *Option;                    /*  11 : MIB_OCTETSTR */
    BYTE FAR    *Data;                      /*  12 : MIB_NULL */
} PROT_TCP;

typedef struct _PROT_ICMP
{
    BYTE        *Type;                      /*  1  : MIB_GAUGE */
    BYTE        *Code;                      /*  2  : MIB_GAUGE */
    BYTE        *ChkSum;                    /*  3  : MIB_GAUGE */
    BYTE FAR    *Data;                      /*  4  : MIB_NULL */
} PROT_ICMP;

typedef struct _PROT_DNS
{
    BYTE        *ID;                        /*  1  : MIB_GAUGE */
    BYTE        *Parameter;                 /*  2  : MIB_GAUGE */
    BYTE        *NroQuest;                  /*  3  : MIB_GAUGE */
    BYTE        *NroAnsw;                   /*  4  : MIB_GAUGE */
    BYTE        *NroAuth;                   /*  5  : MIB_GAUGE */
    BYTE        *NroAdd;                    /*  6  : MIB_GAUGE */
    BYTE        *Entry;                     /*  7,8,9,10  : variable */
    BYTE FAR    *Data;                      /* 11  : MIB_NULL */
} PROT_DNS;

typedef struct _PROT_DEC PROT_DEC;

#include "dec.h"

struct _PROT_DEC
{
 BYTE *Len;
 BYTE *Type;
 BYTE *NextData;
 DEC_PROT *Data;
 int nsp;
};

BOOLEAN ProtBeholderPrint (PROT_OBJ *Obj, BYTE **StrPtr);
BOOLEAN ProtEthernetHeader (PROT_PKT *Pkt);
BOOLEAN ProtEthernetField (PROT_PKT *Pkt, PROT_OBJ *Obj);
BOOLEAN ProtEthernetPrint (PROT_OBJ *Obj, BYTE **StrPtr);
BOOLEAN ProtIPHeader (PROT_PKT *Pkt);
BOOLEAN ProtIPField (PROT_PKT *Pkt, PROT_OBJ *Obj);
BOOLEAN ProtIPPrint (PROT_OBJ *Obj, BYTE **StrPtr);
BOOLEAN ProtTCPHeader (PROT_PKT *Pkt);
BOOLEAN ProtTCPField (PROT_PKT *Pkt, PROT_OBJ *Obj);
BOOLEAN ProtTCPPrint (PROT_OBJ *Obj, BYTE **StrPtr);
BOOLEAN ProtUDPHeader (PROT_PKT *Pkt);
BOOLEAN ProtUDPField (PROT_PKT *Pkt, PROT_OBJ *Obj);
BOOLEAN ProtUDPPrint (PROT_OBJ *Obj, BYTE **StrPtr);
BOOLEAN ProtICMPHeader (PROT_PKT *Pkt);
BOOLEAN ProtICMPField (PROT_PKT *Pkt, PROT_OBJ *Obj);
BOOLEAN ProtICMPPrint (PROT_OBJ *Obj, BYTE **StrPtr);
BOOLEAN ProtARPHeader (PROT_PKT *Pkt);
BOOLEAN ProtARPField (PROT_PKT *Pkt, PROT_OBJ *Obj);
BOOLEAN ProtARPPrint (PROT_OBJ *Obj, BYTE **StrPtr);
BOOLEAN ProtDNSHeader (PROT_PKT *Pkt);
BOOLEAN ProtDNSField (PROT_PKT *Pkt, PROT_OBJ *Obj);
BOOLEAN ProtDNSPrint (PROT_OBJ *Obj, BYTE **StrPtr);
BOOLEAN ProtDECHeader (PROT_PKT *Pkt);

extern BYTE *protocolString;
extern BYTE *protBeholderString[];
extern BYTE *protEthernetString[];
extern BYTE *protIPString[];
extern BYTE *protTCPString[];
extern BYTE *protUDPString[];
extern BYTE *protICMPString[];
extern BYTE *protARPString[];
extern BYTE *protDNSString[];
extern BYTE *protDECString[];

union _PROT_FRAME
{
    PROT_BEHOLDER    Beholder;
    PROT_ETHERNET    Ethernet;
    PROT_IP          Ip;
    PROT_TCP         Tcp;
    PROT_UDP         Udp;
    PROT_ICMP        Icmp;
    PROT_ARP         Arp;
    PROT_DNS         Dns;
    PROT_DEC         Dec;
};

static PROT_PTR ProtPtr[] =
{
    {"UNKNOWN"},
    {"BEHOLDER", NULL, NULL, ProtBeholderPrint, protBeholderString, 5},
    {"ETHERNET", ProtEthernetHeader, ProtEthernetField, ProtEthernetPrint, protEthernetString, 3},
    {"IP", ProtIPHeader, ProtIPField, ProtIPPrint, protIPString, 13},
    {"TCP", ProtTCPHeader, ProtTCPField, ProtTCPPrint, protTCPString, 11},
    {"UDP", ProtUDPHeader, ProtUDPField, ProtUDPPrint, protUDPString, 4},
    {"ICMP", ProtICMPHeader, ProtICMPField, ProtICMPPrint, protICMPString, 3},
    {"ARP", ProtARPHeader, ProtARPField, ProtARPPrint, protARPString, 9},
    {"RARP", ProtARPHeader, ProtARPField, ProtARPPrint, protARPString, 9},
    {"DNS", ProtDNSHeader, ProtDNSField, ProtDNSPrint, protDNSString, 10},
    {"DEC", ProtDECHeader, NULL,NULL,protDECString, 23}
};

BOOLEAN UdpFill(PROT_UDP Udp);
BOOLEAN IpFill(PROT_IP Ip);
BOOLEAN ArpFill(PROT_ARP Arp);
BOOLEAN DnsFill(PROT_DNS Dns);
BOOLEAN DecFill(PROT_DEC Dec);
BOOLEAN TcpFill(PROT_TCP Tcp);
BOOLEAN IcmpFill(PROT_ICMP Icmp);
BOOLEAN EtherPrintHeader(BYTE **String, int flag);
BOOLEAN IPPrintHeader(BYTE **String,int flag);
BOOLEAN UDPPrintHeader(BYTE **String,int flag);
BOOLEAN DNSPrintHeader(BYTE **String,int flag);
BOOLEAN DECPrintHeader(BYTE **String,int flag);
BOOLEAN ARPPrintHeader(BYTE **String,int flag);
BOOLEAN TCPPrintHeader(BYTE **String,int flag);
BOOLEAN ICMPPrintHeader(BYTE **String,int flag);

typedef struct _PROT_FUN
{
    BYTE            *Name;
    BOOLEAN         (*PrintHeader) (BYTE **String,int flag);
} PROT_FUN;

static PROT_FUN ProtFun[] =
{   
    {"UNKNOWN"},
    {"UNKNOWN"},
    {"ETHER", EtherPrintHeader},
    {"IP", IPPrintHeader},
    {"TCP", TCPPrintHeader},
    {"UDP", UDPPrintHeader},
    {"ICMP", ICMPPrintHeader},
    {"ARP", ARPPrintHeader},
    {"RARP", ARPPrintHeader},
    {"DNS", DNSPrintHeader},
    {"DEC",DECPrintHeader}
};


#endif
