#include <stddef.h> 
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <dnpap.h>
#include <snmp.h>
#include "protocol.h"
#include "prot.h"

BYTE *protDNSString[] =
{
    "IDENTIFICATION",
    "PARAMETER",
    "NUMBER_OF_QUESTIONS",
    "NUMBER_OF_ANSWERS",
    "NUMBER_OF_AUTHORITY",
    "NUMBER_OF_ADDITIONAL",
    "QUESTION_SECTION",
    "ANSWER_SECTION",
    "AUTHORITY_SECTION",
    "ADDITIONAL_INFORMATION_SECTION"
};

#define ENTRYSIZE   10                 /* max nr of entries in each section */

static WORD HLen;
static BYTE *EntryPtr[4][ENTRYSIZE];
static LWORD EntryLen[4];

BOOLEAN ProtDNSHeader (PROT_PKT *Pkt)
{
    LWORD Entry, PtrFlag;
    LWORD Number, Ind;
    BYTE *Ptr;

    if (Pkt->DataLen < 12)
        return FALSE;
    if ((Pkt->Frame = DnpapMalloc (sizeof(PROT_DNS))) == NULL)
        return (FALSE);
    Pkt->Frame->Dns.ID = Pkt->Ptr;
    Pkt->Frame->Dns.Parameter = Pkt->Ptr + 2;
    Pkt->Frame->Dns.NroQuest = Pkt->Ptr + 4;
    Pkt->Frame->Dns.NroAnsw = Pkt->Ptr+ 6;
    Pkt->Frame->Dns.NroAuth = Pkt->Ptr+ 8;
    Pkt->Frame->Dns.NroAdd = Pkt->Ptr + 10;
    Pkt->Frame->Dns.Entry = Ptr = Pkt->Ptr + 12;

    PROT_NETWORD(EntryLen[0], Pkt->Frame->Dns.NroQuest)
    PROT_NETWORD(EntryLen[1], Pkt->Frame->Dns.NroAnsw)
    PROT_NETWORD(EntryLen[2], Pkt->Frame->Dns.NroAuth)
    PROT_NETWORD(EntryLen[3], Pkt->Frame->Dns.NroAdd)

    for (Entry = 0; Entry < 4; Entry++)
    {
        if (EntryLen[Entry] > ENTRYSIZE)
            return (FALSE);
        for (Ind = 0; Ind < EntryLen[Entry]; Ind++)
        {
            EntryPtr[Entry][Ind] = Ptr;
            PtrFlag = 0;
            while (!PtrFlag && *Ptr)
            {
                if ((WORD)(Ptr - Pkt->Ptr) > Pkt->DataLen + sizeof (BYTE))
                    return FALSE;
                if (*Ptr & 0xC0)
                {
                    Ptr+= 1;
                    PtrFlag = 1;
                }
                else
                    Ptr += *Ptr + 1;
            }
            Ptr++;
            if (Entry == 0)
                Ptr += 4;
            else
            {
                Ptr += 8;
                if ((WORD)(Ptr - Pkt->Ptr) > Pkt->DataLen + sizeof (WORD))
                    return FALSE;
                PROT_NETWORD(Number, Ptr)
                Ptr += Number + 2;
            }
        }
    }

    HLen = (WORD) (Ptr - Pkt->Ptr);
    Pkt->Frame->Dns.Data = Ptr;
    
    Pkt->ChildProt = PROT_PKTUNKNOWN;
    return (TRUE);
}

BOOLEAN ProtDNSField (PROT_PKT *Pkt, PROT_OBJ *Obj)
{
    BYTE *Ptr, t[2];
    LWORD Offset, Len;

    if (Obj->Level == 0 && Obj->Id[1] == PROT_TYPE)
    {
        Obj->Type = SNMP_GAUGE;
        Obj->Syntax.LngUns = (LWORD) Pkt->ChildProt;
        memset(&Obj->Id[2], 0, SNMP_SIZE_OBJECTID - 4);
        return (TRUE);
    }

    if (Obj->Id[0] == PROT_PKTDNS)
    {
        switch (Obj->Id[1])
        {
            case 1:
                Obj->Type = SNMP_GAUGE;
                PROT_NETWORD(Obj->Syntax.LngUns, Pkt->Frame->Dns.ID)
                memset(&Obj->Id[2], 0, SNMP_SIZE_OBJECTID - 4);
                return (TRUE);
            case 2:
                Obj->Type = SNMP_GAUGE;
                PROT_NETWORD(Obj->Syntax.LngUns, Pkt->Frame->Dns.Parameter)
                memset(&Obj->Id[2], 0, SNMP_SIZE_OBJECTID - 4);
                return (TRUE);
            case 3:                             /* Nr of Quest */
            case 4:                             /* Nr of Answ */
            case 5:                             /* Nr of Auth */
            case 6:                             /* Nr of Add */
                Obj->Type = SNMP_GAUGE;
                Obj->Syntax.LngUns = EntryLen[Obj->Id[1]-3]; 
                memset(&Obj->Id[2], 0, SNMP_SIZE_OBJECTID - 4);
                return (TRUE);
            case 7:                             /* Quest Sect */
            case 8:                             /* Answ Sect */
            case 9:                             /* Auth Sect */
            case 10:                            /* Add Sect */
                if (EntryLen[Obj->Id[1]-7] == 0 || Obj->Id[2] == 0 || Obj->Id[2] > (LONG) EntryLen[Obj->Id[1]-7])
                    return (FALSE);

                Obj->SyntaxLen = 0;
                memset(&Obj->Id[4], 0, SNMP_SIZE_OBJECTID - 8);
                switch (Obj->Id[3])
                {
                    case 1:                                 /* name */
                        Obj->Type = SNMP_OCTETSTR;
                        Ptr = EntryPtr[Obj->Id[1]-7][Obj->Id[2] - 1];
                        while (*Ptr)
                        {
                            if (*Ptr & 0xC0)
                            {
                                t[0] = (BYTE) (*Ptr & 0x3F);
                                t[1] = *(Ptr + 1);
                                PROT_NETWORD (Offset, t)
                                Ptr = Pkt->Ptr + Offset;
                            }
                            else
                            {
                                Ptr++;
                                memcpy(&Obj->Syntax.BufChr[Obj->SyntaxLen], Ptr, *(Ptr-1));
                                Obj->SyntaxLen += *(Ptr-1);
                                Obj->Syntax.BufChr[Obj->SyntaxLen++]='.';
                                Ptr += *(Ptr-1);
                            }
                        }
                        return (TRUE);
                    case 4:                                 /* time to live */
                    case 5:                                 /* data len */
                        if (Obj->Id[1] == 7)
                            return (FALSE);
                    case 2:                                 /* type */
                    case 3:                                 /* class */
                        Obj->Type = SNMP_GAUGE;
                        Ptr = EntryPtr[Obj->Id[1]-7][Obj->Id[2] - 1];
                        if (*Ptr & 0xC0)
                            Ptr += 2;
                        else
                        {
                            while (*Ptr)
                                Ptr += *Ptr + 1;
                            Ptr++;
                        }
                        switch (Obj->Id[3])
                        {
                            case 2:
                                PROT_NETWORD (Obj->Syntax.LngUns,Ptr)
                                break;
                            case 3:
                                Ptr += 2;
                                PROT_NETWORD (Obj->Syntax.LngUns,Ptr)
                                break;
                            case 4:
                                Ptr += 4;
                                Obj->Type = SNMP_TIMETICKS;
                                PROT_NETLWORD (Obj->Syntax.LngUns,Ptr)
                                break;
                            case 5:
                                Ptr += 8;
                                PROT_NETWORD (Obj->Syntax.LngUns,Ptr)
                                break;
                        }
                        return (TRUE);
                    case 6:                                 /* data */
                        if (Obj->Id[1] == 7)
                            return (FALSE);
                        Obj->Type = SNMP_NULL;
                        Ptr = EntryPtr[Obj->Id[1] - 7][Obj->Id[2] - 1];
                        if (*Ptr & 0xC0)
                            Ptr += 2;
                        else
                        {
                            while (*Ptr)
                                Ptr += *Ptr + 1;
                            Ptr++;
                        }
                        Ptr += 8;
                        PROT_NETWORD (Len, Ptr)
                        Obj->SyntaxLen = (WORD) Len;
                        Ptr += 2;
                        Obj->Syntax.Ptr = Ptr;
                        return (TRUE);
                    default:
                        return (FALSE);
                }
            case 11:
                Obj->Type = SNMP_NULL;
                if (Pkt->DataLen <= HLen)
                    Obj->SyntaxLen = 0;
                else
                    Obj->SyntaxLen = Pkt->DataLen - HLen;
                Obj->Syntax.Ptr = Pkt->Frame->Dns.Data;
                memset(&Obj->Id[2], 0, SNMP_SIZE_OBJECTID - 4);
                return (TRUE);
            default:        
                return (FALSE);
        }
    }

    if (Obj->Level > 0 && Pkt->ChildProt != PROT_PKTUNKNOWN)
    {
        if (Pkt->Child == NULL)
        {
            if ((Pkt->Child = DnpapMalloc (sizeof(PROT_PKT))) == NULL)
                return (FALSE);
            Pkt->Child->Ptr = Pkt->Frame->Dns.Data;
            Pkt->Child->Child = NULL;
            Pkt->Child->DataLen = Pkt->DataLen - HLen;
            if ((ProtPtr[Pkt->ChildProt].Header(Pkt->Child)) == FALSE)
            {
                DnpapFree(Pkt->Child);
                return (FALSE);
            }
        }
        Obj->Level--;
        return (ProtPtr[Pkt->ChildProt].Field (Pkt->Child, Obj));
    }
    return (FALSE);
}

BOOLEAN ProtDNSPrint (PROT_OBJ *Obj, BYTE **StrPtr)
{
    WORD Ind;
    BYTE Char[4];

    switch (Obj->Id[1])
    {
        case 1:                             /* ID */
        case 2:                             /* Parameter */
            sprintf(protocolString, "%4lx", Obj->Syntax.LngUns);
            *StrPtr = protocolString;
            return (TRUE);
        case 3:                             /* NroQuest */
        case 4:                             /* NroAnsw */
        case 5:                             /* NroAuth */
        case 6:                             /* NroAdd */
            sprintf(protocolString, "%4lu", Obj->Syntax.LngUns);
            *StrPtr = protocolString;
            return (TRUE);
        case 7:                             /* Quest Sect */
        case 8:                             /* Answ Sect */
        case 9:                             /* Auth Sect */
        case 10:                            /* Add Sect */
            switch (Obj->Id[3])
            {
                case 1:                     /* domain name */
                    *protocolString = '\0';
                    for (Ind = 0; Ind < Obj->SyntaxLen; Ind++)
                    {
                        sprintf(Char, "%c",Obj->Syntax.BufChr[Ind]);
                        strcat(protocolString, Char);
                    }
                    *StrPtr = protocolString;
                    return (TRUE);
                case 2:                     /* type */
                case 3:                     /* class */
                    sprintf(protocolString, "%4lx", Obj->Syntax.LngUns);
                    *StrPtr = protocolString;
                    return (TRUE);
                case 4:                     /* time to live */
                    sprintf(protocolString, "%10lu", Obj->Syntax.LngUns);
                    *StrPtr = protocolString;
                    return (TRUE);
                case 5:                     /* data len */
                    sprintf(protocolString, "%6lu", Obj->Syntax.LngUns);
                    *StrPtr = protocolString;
                    return (TRUE);
                default:
                    return (FALSE);
            }
        default:
            return (FALSE);
    }
}

