#include <stddef.h> 
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <dnpap.h>
#include <snmp.h>
#include "protocol.h"
#include "prot.h"

BYTE *protUDPString[]=
{
    "UDP_SOURCE_PORT",     
    "UDP_DESTINATION_PORT",
    "UDP_MESSAGE_LENGTH",  
    "UDP_CHECKSUM"        
};                                           

BOOLEAN ProtUDPHeader (PROT_PKT *Pkt)
{
    LWORD  Child;

    if (Pkt->DataLen < 8)
        return (FALSE);
    if ((Pkt->Frame = DnpapMalloc (sizeof(PROT_UDP))) == NULL)
        return (FALSE);
    Pkt->Frame->Udp.SrcPort = Pkt->Ptr;
    Pkt->Frame->Udp.DstPort = Pkt->Ptr + 2;
    Pkt->Frame->Udp.MLen = Pkt->Ptr + 4;
    Pkt->Frame->Udp.ChkSum = Pkt->Ptr + 6;
    Pkt->Frame->Udp.Data = Pkt->Ptr + 8;
 
    PROT_NETWORD (Child,Pkt->Frame->Udp.DstPort)

    switch(Child)
    {
        case 53:
            Pkt->ChildProt = PROT_PKTDNS;
            break;
        default:
            Pkt->ChildProt = PROT_PKTUNKNOWN;
    }
    return (TRUE);
}

BOOLEAN ProtUDPField (PROT_PKT *Pkt, PROT_OBJ *Obj)
{
    if (Obj->Level == 0 && Obj->Id[1] == PROT_TYPE)
    {
        Obj->Type = SNMP_GAUGE;
        Obj->Syntax.LngUns = Pkt->ChildProt;
        return (TRUE);
    }

    if (Obj->Id[0] == PROT_PKTUDP)
    {
        switch (Obj->Id[1])
        {
            case 1:
                Obj->Type = SNMP_GAUGE;
                PROT_NETWORD(Obj->Syntax.LngUns, Pkt->Frame->Udp.SrcPort)
                memset(&Obj->Id[2], 0, SNMP_SIZE_OBJECTID - 4);
                return (TRUE);
            case 2:
                Obj->Type = SNMP_GAUGE;
                PROT_NETWORD(Obj->Syntax.LngUns, Pkt->Frame->Udp.DstPort)
                memset(&Obj->Id[2], 0, SNMP_SIZE_OBJECTID - 4);
                return (TRUE);
            case 3:
                Obj->Type = SNMP_GAUGE;
                PROT_NETWORD(Obj->Syntax.LngUns, Pkt->Frame->Udp.MLen)
                memset(&Obj->Id[2], 0, SNMP_SIZE_OBJECTID - 4);
                return (TRUE);
            case 4:
                Obj->Type = SNMP_GAUGE;
                PROT_NETWORD(Obj->Syntax.LngUns, Pkt->Frame->Udp.ChkSum)
                memset(&Obj->Id[2], 0, SNMP_SIZE_OBJECTID - 4);
                return (TRUE);
            case 5:
                Obj->Type = SNMP_NULL;
                if (Pkt->DataLen <= 8)
                    Obj->SyntaxLen = 0;
                else
                    Obj->SyntaxLen = Pkt->DataLen - 8;
                Obj->Syntax.Ptr = Pkt->Frame->Tcp.Data;
                memset(&Obj->Id[2], 0, SNMP_SIZE_OBJECTID - 4);
                return (TRUE);
            default:
                return (FALSE);
        }
    }

    if (Obj->Level > 0 && Pkt->ChildProt != PROT_PKTUNKNOWN)
    {
        if (Pkt->Child == NULL)
        {
            if ((Pkt->Child = DnpapMalloc (sizeof(PROT_PKT))) == NULL)
                return (FALSE);
            Pkt->Child->Ptr = Pkt->Frame->Udp.Data;
            Pkt->Child->Child = NULL;
            Pkt->Child->DataLen = Pkt->DataLen - 8;
            if ((ProtPtr[Pkt->ChildProt].Header(Pkt->Child)) == FALSE)
            {
                DnpapFree(Pkt->Child);
                return (FALSE);
            }
        }
        Obj->Level--;
        return (ProtPtr[Pkt->ChildProt].Field (Pkt->Child, Obj));
    }
    return (FALSE);
}

BOOLEAN ProtUDPPrint (PROT_OBJ *Obj, BYTE **StrPtr)
{
    switch (Obj->Id[1])
    {
        case 1:                                 /* Src Port */
        case 2:                                 /* Dst Port */
        case 3:                                 /* Message Len */
            sprintf(protocolString, "%6lu", Obj->Syntax.LngUns);
            *StrPtr = protocolString;
            return (TRUE);
        case 4:                                 /* ChkSum */
            sprintf(protocolString, "%4lx", Obj->Syntax.LngUns);
            *StrPtr = protocolString;
            return (TRUE);
        default:
            return (FALSE);
    }
}
