/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       vipdial.c
**     SYSTEM   NAME:       VIP
**     ORIGINAL AUTHOR(S):  Alfred Kayser
**     VERSION  NUMBER:     1.00
**     CREATION DATE:       1992/5/29
**
** DESCRIPTION: Dial Module.
**              
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision$
** WORKFILE:    $Workfile$
** LOGINFO:     $Log$
*************************************************************************/
#define LIBRARY
#include "vipinc.h"
#include "vipdial.h"

PRIVAT void VipUpdateDial(VIPINFO *wip, HPS hps, BOOLEAN all);

/**************************************************************
** NAME:        VipOpenDial                               [API]
** SYNOPSIS:    VIPINFO * VipOpenDial(VIPINFO *parent,
**                  int x, int y, int w, int h)
** DESCRIPTION: Opens a round dial window.
** RETURNS:     void
**************************************************************/
VIPINFO *
VipOpenDial(VIPINFO *parent, int x, int y, int w, int h)
{
    VIPINFO *wip;
    struct _dialdata *data;

    if (!(data = VipMalloc(sizeof(struct _dialdata))))
        return NULL;
    if (!(wip = VipOpenSimple(parent, x,y,w,h)))
    {
        VipFree(data);
        return wip;
    }
    
    data->lab2 = VipOpenLabel(wip, 50, 750, 0, 0);
    data->lab1 = VipOpenLabel(wip, 50, 50, 0, 0);
    data->stripes=10;
    data->min=0;
    data->max=100;
    data->current=0;
    data->prev=0;

    wip->dialdata=data;
    wip->type=T_DIAL;
    wip->border=2;
    wip->btype=VIP_DEPTH;

    /* Change Update function to a dial draw function... */
    wip->update=VipUpdateDial;
    return wip;
}


/**************************************************************
** NAME:        VipSetDialCurrent                         [API]
** SYNOPSIS:    void VipSetDialCurrent(VIPINFO *wip,
**                    LONG current)
** DESCRIPTION: Sets the current value of the dial.
**              As with all VipSet functions the corresponding
**              view is not updated until a 'VipUpdate' or
**              'VipShow' forces a redraw or refresh.
** RETURNS:     void
**************************************************************/
void
VipSetDialCurrent(VIPINFO *wip, LONG current)
{
    TYPETEST(wip,T_DIAL,return);
    DIALDATA(wip,current)=current;
}


/**************************************************************
** NAME:        VipSetDialRange                           [API]
** SYNOPSIS:    void VipSetDialRange(VIPINFO *wip,
**                  LONG min, LONG max, int stripes)
** DESCRIPTION: Sets the range and stripes of the dial.
** RETURNS:     void
**************************************************************/
void 
VipSetDialRange(VIPINFO *wip, LONG min, LONG max, int stripes)
{
    TYPETEST(wip,T_DIAL,return);
    DIALDATA(wip,min)=min;
    DIALDATA(wip,max)=max;
    DIALDATA(wip,stripes)=stripes;
}


PRIVAT void
VipUpdateDial(VIPINFO *wip, HPS hps, BOOLEAN all)
{
    char buf[14];
    LONG i;
    LONG st, s, t, x, y, WID, HID;
    POINTL pp;
        
    WID = wip->cx;
    HID = wip->cy;
    s = WID;
    if (s>HID) s=HID;
    s -= 2*wip->border;
    t = HID/2 - (s*3/8);

/*  This function is not supported yet, but it will on os/2 2.0? */
    GpiSetLineWidth(hps, MAKEFIXED(s,0)/40);
    if (all)
    {
        VipBorder(wip, hps);

        GpiSetLineWidth(hps, MAKEFIXED(s,0)/40);
        GpiSetColor(hps, BACKGROUND2(wip));
        MOVE(WID/2, HID/2);
        GpiFullArc(hps, DRO_FILL, MAKEFIXED(s,0)*9/20);

        GpiSetColor(hps, FOREGROUND(wip));
        MOVE(WID/2, HID/2);
        GpiFullArc(hps, DRO_OUTLINE, MAKEFIXED(s,0)*9/20);

        GpiSetLineWidth(hps, MAKEFIXED(s,0)/40);
        st = DIALDATA(wip,stripes);
        for (i=0; i<=st; i++) 
        {
            x = (s*convertX[i*STEP/st])/1000;
            y = (s*convertY[i*STEP/st])/1000;
            MOVE(WID/2 + (x*5)/8, t + (y*5)/8);
            LINE(WID/2 + x/2, t + y/2);
        }

        GpiSetLineWidth(hps, MAKEFIXED(s,0)/40);
        if (DIALDATA(wip, lab1))
        {
            if (!wip->title)
                VipHide(DIALDATA(wip, lab1));
            else
            {
                DIALDATA(wip, lab1)->font = wip->font;
                VipSetTitle(DIALDATA(wip, lab1), wip->title);
                VipShow(DIALDATA(wip, lab1));
                WinSendMsg(DIALDATA(wip, lab1)->win, UM_SCALE,
                    (MPARAM)TRUE, NULL);
            }
        }
    }
    GpiSetMix(hps, FM_INVERT); 
    if (!all)
    {
        st = (STEP * DIALDATA(wip,prev)) / (DIALDATA(wip,max)-DIALDATA(wip,min));
        x = s*convertX[st]/1000;
        y = s*convertY[st]/1000;
        MOVE(WID/2 + x/8, t + y/8);
        LINE(WID/2 + (x*5)/8, t + (y*5)/8);
    }
    st=DIALDATA(wip, current);
    if (st>DIALDATA(wip,max)) st=DIALDATA(wip,max);
    if (st<DIALDATA(wip,min)) st=DIALDATA(wip,min);
    DIALDATA(wip, prev) = st;
    st = ((LONG)STEP * st) / (DIALDATA(wip,max)-DIALDATA(wip,min));
    x = (s*convertX[st])/1000;
    y = (s*convertY[st])/1000;
    MOVE(WID/2 + x/8, t + y/8);
    LINE(WID/2 + (x*5)/8, t + (y*5)/8);
    GpiSetMix(hps, FM_OVERPAINT);

    GpiSetColor(hps,
        DIALDATA(wip,current)>DIALDATA(wip,max) ? RED(wip) : BACKGROUND2(wip));
    MOVE(WID/2, HID/2 - s/3);
    GpiFullArc(hps, DRO_FILL, MAKEFIXED(s,0)/20);

    if (DIALDATA(wip, lab2))
    {
        DIALDATA(wip, lab2)->font = wip->font;
        sprintf(buf,"%ld",DIALDATA(wip, current));
        VipSetTitle(DIALDATA(wip, lab2), buf);
        WinSendMsg(DIALDATA(wip, lab2)->win, UM_SCALE,
            (MPARAM)TRUE, NULL);
    }
    GpiSetLineWidth(hps, LINEWIDTH_NORMAL);
}
