@ECHO OFF
REM IAPPS  - install common app files
REM ITRMON - install trmon
REM IENMON - install enmon
REM IDGPA  - install dgpa
REM IDOCS  - install user's guide
REM ISAMP  - install sample data files
REM SRCPATH  - source path      - where installation files are stored i.e. A:
REM DGNAPATH - destination path - target directory for files i.e. C:\DGNA
REM TARGETDRIVE - target drive i.e. C:
REM OS2DRIV     - drive that OS/2 is installed on
REM ASSUMES TARGET DIRECTORY EXISTS WHEN THIS CMD FILE IS RUN!

CLS
ECHO 
ECHO The installation program will now install the DatagLANce Network
ECHO Analyzer demo in the %DGNAPATH% directory.  Press Ctrl-C now to abort.
ECHO 
ECHO Note: if you are re-installing the DatagLANce demo, drag the icons
ECHO created during the last DatagLANce demo installation into the shredder
ECHO before proceeding (Press Ctrl-Esc now to go to the OS/2 desktop).
ECHO 
:INSERT1ADISK
ECHO Please ensure that installation diskette 1 is still in drive %SRCPATH%
PAUSE
REM MAKE SURE THAT DISK WAS INSERTED (LOOK FOR FILE WE KNOW SHOULD BE THERE)
IF NOT EXIST %SRCPATH%\INCLUP.CMD GOTO INSERT1ADISK
SET DISKETTE=1

%TARGETDRIVE%
CD %DGNAPATH%
IF EXIST %DGNAPATH%\INSTALL.LOG DEL %DGNAPATH%\INSTALL.LOG
ECHO COPY %SRCPATH%\LOADRAM2.EXE   >>%DGNAPATH%\INSTALL.LOG
COPY %SRCPATH%\LOADRAM2.EXE   >>%DGNAPATH%\INSTALL.LOG
IF ERRORLEVEL 1 GOTO ERROR
ECHO COPY %SRCPATH%\CRGROUP.EXE    >>%DGNAPATH%\INSTALL.LOG
COPY %SRCPATH%\CRGROUP.EXE    >>%DGNAPATH%\INSTALL.LOG
IF ERRORLEVEL 1 GOTO ERROR
ECHO COPY %SRCPATH%\CRPROG.EXE     >>%DGNAPATH%\INSTALL.LOG
COPY %SRCPATH%\CRPROG.EXE     >>%DGNAPATH%\INSTALL.LOG
IF ERRORLEVEL 1 GOTO ERROR
IF EXIST CLEANUP.CMD DEL CLEANUP.CMD
ECHO @ECHO OFF >> CLEANUP.CMD
ECHO SET DGNAPATH=%DGNAPATH% >>CLEANUP.CMD
ECHO SET TARGETDRIVE=%TARGETDRIVE% >>CLEANUP.CMD
TYPE %SRCPATH%\TMPCL.CMD >>CLEANUP.CMD

REM TEMPORARY FIX FOR VIEW.EXE FIND PROBLEM
IF NOT EXIST %OS2DRIV%\OS2\VIEW.EXE GOTO NOVIEW
IF NOT EXIST C:\OS2 MD C:\OS2
IF NOT EXIST C:\OS2\VIEW.EXE COPY %OS2DRIV%\OS2\VIEW.EXE C:\OS2
:NOVIEW

REM Install the Online Documentation

IF "%IDOCS%"=="" GOTO NODOCSINSTALL

ECHO Unpacking on-line documentation...
ECHO COPY %SRCPATH%\ICONS\BOOK.ICO           >>%DGNAPATH%\INSTALL.LOG
COPY %SRCPATH%\ICONS\BOOK.ICO           >>%DGNAPATH%\INSTALL.LOG
ECHO COPY %SRCPATH%\ICONS\INFO.ICO           >>%DGNAPATH%\INSTALL.LOG
COPY %SRCPATH%\ICONS\INFO.ICO           >>%DGNAPATH%\INSTALL.LOG
IF ERRORLEVEL 1 GOTO ERROR
%DGNAPATH%\LOADRAM2 %SRCPATH%\DGNAUSER.FLS /D  >>%DGNAPATH%\INSTALL.LOG
IF ERRORLEVEL 1 GOTO ERROR

:NODOCSINSTALL

IF "%IAPPS%"=="" GOTO NOAPPSINSTALL

ECHO Copying files...
ECHO COPY %SRCPATH%\ICONS\*.ICO          >>%DGNAPATH%\INSTALL.LOG
COPY %SRCPATH%\ICONS\*.ICO          >>%DGNAPATH%\INSTALL.LOG
IF ERRORLEVEL 1 GOTO ERROR
ECHO COPY %SRCPATH%\STATDEF.SYM    >>%DGNAPATH%\INSTALL.LOG
COPY %SRCPATH%\STATDEF.SYM    >>%DGNAPATH%\INSTALL.LOG
IF ERRORLEVEL 1 GOTO ERROR
ECHO COPY %SRCPATH%\MANUDEF.SYM    >>%DGNAPATH%\INSTALL.LOG
COPY %SRCPATH%\MANUDEF.SYM    >>%DGNAPATH%\INSTALL.LOG
IF ERRORLEVEL 1 GOTO ERROR
REM KEEP OLD NAMES IF THEY ARE THERE
IF EXIST DGNAMANU.OLD DEL DGNAMANU.OLD
IF EXIST DGNASTAT.OLD DEL DGNASTAT.OLD
IF EXIST DGNAMANU.SYM RENAME DGNAMANU.SYM DGNAMANU.OLD
IF EXIST DGNASTAT.SYM RENAME DGNASTAT.SYM DGNASTAT.OLD
ECHO COPY MANUDEF.SYM DGNAMANU.SYM >>%DGNAPATH%\INSTALL.LOG
COPY MANUDEF.SYM DGNAMANU.SYM >>%DGNAPATH%\INSTALL.LOG
IF ERRORLEVEL 1 GOTO ERROR
ECHO COPY %SRCPATH%\DGNASTAT.SYM DGNASTAT.SYM >>%DGNAPATH%\INSTALL.LOG
COPY %SRCPATH%\DGNASTAT.SYM DGNASTAT.SYM >>%DGNAPATH%\INSTALL.LOG
IF ERRORLEVEL 1 GOTO ERROR

IF NOT EXIST ERROR MD ERROR
CD ERROR
ECHO Unpacking error files...
%DGNAPATH%\LOADRAM2 %SRCPATH%\DGNAERR.FLS    /D  >>%DGNAPATH%\INSTALL.LOG
IF ERRORLEVEL 1 GOTO ERROR
CD ..

ECHO Unpacking program executables...
%DGNAPATH%\LOADRAM2 %SRCPATH%\MIRDLL.FLS   /D  >>%DGNAPATH%\INSTALL.LOG
IF ERRORLEVEL 1 GOTO ERROR
%DGNAPATH%\LOADRAM2 %SRCPATH%\DGNADLL.FLS  /D  >>%DGNAPATH%\INSTALL.LOG
IF ERRORLEVEL 1 GOTO ERROR

IF "%IDGPA%"=="" GOTO NODGPAINSTALL

ECHO Unpacking DatagLANce Protocol Analysis Demo executables...
%DGNAPATH%\LOADRAM2 %SRCPATH%\DGPADEMO.FLS /D  >>%DGNAPATH%\INSTALL.LOG
IF ERRORLEVEL 1 GOTO ERROR

:NODGPAINSTALL

:INSERT2DISK
ECHO Please insert installation diskette 2 in drive %SRCPATH%
PAUSE
REM MAKE SURE THAT DISK WAS INSERTED (LOOK FOR FILE WE KNOW SHOULD BE THERE)
IF NOT EXIST %SRCPATH%\DGPI.FLS GOTO INSERT2DISK
SET DISKETTE=2

ECHO Copying softcopy DatagLANce brochure (BROCHURE.TXT)...
COPY %SRCPATH%\BROCHURE.TXT >>%DGNAPATH%\INSTALL.LOG
ECHO Unpacking more program executables...
%DGNAPATH%\LOADRAM2 %SRCPATH%\DGPI.FLS     /D  >>%DGNAPATH%\INSTALL.LOG
IF ERRORLEVEL 1 GOTO ERROR
%DGNAPATH%\LOADRAM2 %SRCPATH%\DGLAUNCH.FLS /D  >>%DGNAPATH%\INSTALL.LOG
IF ERRORLEVEL 1 GOTO ERROR


IF "%IDGPA%"=="" GOTO NOCDGPAINSTALL

%DGNAPATH%\LOADRAM2 %SRCPATH%\DGPACFG.FLS /D  >>%DGNAPATH%\INSTALL.LOG
IF ERRORLEVEL 1 GOTO ERROR

:NOCDGPAINSTALL

IF "%ITRMON%"=="" GOTO NOTRMONINSTALL
ECHO Unpacking Token-Ring Network Analyzer Demo executables...
%DGNAPATH%\LOADRAM2 %SRCPATH%\RINGMAP.FLS /D  >>%DGNAPATH%\INSTALL.LOG
IF ERRORLEVEL 1 GOTO ERROR
%DGNAPATH%\LOADRAM2 %SRCPATH%\TRMONDEM.FLS /D  >>%DGNAPATH%\INSTALL.LOG
IF ERRORLEVEL 1 GOTO ERROR
%DGNAPATH%\LOADRAM2 %SRCPATH%\TRDEFCFG.FLS /D  >>%DGNAPATH%\INSTALL.LOG
IF ERRORLEVEL 1 GOTO ERROR
:NOTRMONINSTALL

IF "%IENMON%"=="" GOTO NOENMONINSTALL
ECHO Unpacking Ethernet Network Analyzer Demo executables...
%DGNAPATH%\LOADRAM2 %SRCPATH%\ENMONDEM.FLS /D  >>%DGNAPATH%\INSTALL.LOG
IF ERRORLEVEL 1 GOTO ERROR
%DGNAPATH%\LOADRAM2 %SRCPATH%\ENDEFCFG.FLS /D  >>%DGNAPATH%\INSTALL.LOG
IF ERRORLEVEL 1 GOTO ERROR
:NOENMONINSTALL

:NOAPPSINSTALL

IF "%ISAMP%"=="" GOTO NOSAMPINSTALL

ECHO Unpacking DatagLANce Protocol Analysis Demo sample capture data files...
%DGNAPATH%\LOADRAM2 %SRCPATH%\DGPASAMP.FLS /D  >>%DGNAPATH%\INSTALL.LOG
IF ERRORLEVEL 1 GOTO ERROR

:NOSAMPINSTALL

IF "%ITRMON%"=="" GOTO NOTRMONCFGS
ECHO Unpacking DatagLANce Token-Ring Network Analyzer Demo extended configurations...
%DGNAPATH%\LOADRAM2 %SRCPATH%\TRCONFIG.FLS /D  >>%DGNAPATH%\INSTALL.LOG
IF ERRORLEVEL 1 GOTO ERROR
:NOTRMONCFGS

IF "%IENMON%"=="" GOTO NOENMONCFGS
ECHO Unpacking DatagLANce Ethernet Network Analyzer Demo extended configurations...
%DGNAPATH%\LOADRAM2 %SRCPATH%\ENCONFIG.FLS /D  >>%DGNAPATH%\INSTALL.LOG
IF ERRORLEVEL 1 GOTO ERROR
:NOENMONCFGS

IF "%IDOCS%"=="" GOTO NODOCICONS
ECHO Creating desktop icons for on-line documentation...
CRGROUP "DatagLANce Demo" >>%DGNAPATH%\INSTALL.LOG
CRPROG "DatagLANce Demo"             "User's Guide"                        "%OS2DRIV%\OS2\VIEW.EXE" "DGETUSER.INF"                                   "%DGNAPATH%" "%DGNAPATH%\BOOK.ICO" >>%DGNAPATH%\INSTALL.LOG
CRGROUP "DatagLANce Demo Information" >>%DGNAPATH%\INSTALL.LOG
CRPROG "DatagLANce Demo Information" "User's Guide"                        "%OS2DRIV%\OS2\VIEW.EXE" "DGETUSER.INF"                                   "%DGNAPATH%" "%DGNAPATH%\BOOK.ICO" >>%DGNAPATH%\INSTALL.LOG
CRPROG "DatagLANce Demo Information" "Using the User's Guide"              "%OS2DRIV%\OS2\VIEW.EXE" "DGETUSER.INF Introduction"                      "%DGNAPATH%" "%DGNAPATH%\INFO.ICO" >>%DGNAPATH%\INSTALL.LOG
CRPROG "DatagLANce Demo Information" "Overview of the DatagLANce Analyzer" "%OS2DRIV%\OS2\VIEW.EXE" "DGETUSER.INF Introduction"                      "%DGNAPATH%" "%DGNAPATH%\INFO.ICO" >>%DGNAPATH%\INSTALL.LOG
CRPROG "DatagLANce Demo Information" "Using the DatagLANce Analyzer"       "%OS2DRIV%\OS2\VIEW.EXE" "DGETUSER.INF Scenarios"                         "%DGNAPATH%" "%DGNAPATH%\INFO.ICO" >>%DGNAPATH%\INSTALL.LOG
CRPROG "DatagLANce Demo Information" "Monitoring the Network"              "%OS2DRIV%\OS2\VIEW.EXE" "DGETUSER.INF Monitoring the Network"            "%DGNAPATH%" "%DGNAPATH%\INFO.ICO" >>%DGNAPATH%\INSTALL.LOG
CRPROG "DatagLANce Demo Information" "Capturing Frames from the Network"   "%OS2DRIV%\OS2\VIEW.EXE" "DGETUSER.INF Capturing Frames from the network" "%DGNAPATH%" "%DGNAPATH%\INFO.ICO" >>%DGNAPATH%\INSTALL.LOG
CRPROG "DatagLANce Demo Information" "Analyzing Captured Frames"           "%OS2DRIV%\OS2\VIEW.EXE" "DGETUSER.INF Analyzing Captured Frames"         "%DGNAPATH%" "%DGNAPATH%\INFO.ICO" >>%DGNAPATH%\INSTALL.LOG
:NODOCICONS

IF "%IAPPS%"=="" GOTO NOICONS

:HANDLECFGS

IF "%IDGPA%"=="" GOTO NODGPAICONS
ECHO Creating desktop icons for DatagLANce Protocol Analysis...
CRGROUP "DatagLANce Demo" >>%DGNAPATH%\INSTALL.LOG
CRPROG "DatagLANce Demo" "Protocol Analysis Demo" "%DGNAPATH%\DGPADEMO.EXE" "/CSTARTUP" "%DGNAPATH%" "%DGNAPATH%\DGPA.ICO" >>%DGNAPATH%\INSTALL.LOG
:NODGPAICONS

IF "%ITRMON%"=="" GOTO NOTRMONICONS
ECHO Creating desktop icons for the Token-Ring DatagLANce Network Analyzer...
CRGROUP "DatagLANce Demo" >>%DGNAPATH%\INSTALL.LOG
CRPROG "DatagLANce Demo"            "Token-Ring Network Analyzer Demo" "%DGNAPATH%\TRMONDEM.EXE" "/CSTARTUP" "%DGNAPATH%"                 "%DGNAPATH%\DGMON.ICO"    >>%DGNAPATH%\INSTALL.LOG
CRGROUP "Token-Ring DatagLANce Demo" >>%DGNAPATH%\INSTALL.LOG
CRPROG "Token-Ring DatagLANce Demo" "Capture Frames"              "%DGNAPATH%\DGLAUNCH.EXE" "TRMONDEM /CCAPTURE" "%DGNAPATH%"        "%DGNAPATH%\CAPTURE.ICO"  >>%DGNAPATH%\INSTALL.LOG
CRPROG "Token-Ring DatagLANce Demo" "Traffic Analysis"            "%DGNAPATH%\DGLAUNCH.EXE" "TRMONDEM /CTRAFANAL" "%DGNAPATH%"       "%DGNAPATH%\TRAFFIC.ICO"  >>%DGNAPATH%\INSTALL.LOG
CRPROG "Token-Ring DatagLANce Demo" "Traffic Matrix"              "%DGNAPATH%\DGLAUNCH.EXE" "TRMONDEM /CTRAMATRX" "%DGNAPATH%"       "%DGNAPATH%\TRAMATRX.ICO" >>%DGNAPATH%\INSTALL.LOG
CRPROG "Token-Ring DatagLANce Demo" "Protocol Matrix"             "%DGNAPATH%\DGLAUNCH.EXE" "TRMONDEM /CPROMATRX" "%DGNAPATH%"       "%DGNAPATH%\PROMATRX.ICO" >>%DGNAPATH%\INSTALL.LOG
CRPROG "Token-Ring DatagLANce Demo" "Monitor Frame Sizes"         "%DGNAPATH%\DGLAUNCH.EXE" "TRMONDEM /CSIZEDIST" "%DGNAPATH%"       "%DGNAPATH%\DISTRIB.ICO"  >>%DGNAPATH%\INSTALL.LOG
CRPROG "Token-Ring DatagLANce Demo" "Monitor SAP Protocols"       "%DGNAPATH%\DGLAUNCH.EXE" "TRMONDEM /CLSAPDIST" "%DGNAPATH%"       "%DGNAPATH%\DISTRIB.ICO"  >>%DGNAPATH%\INSTALL.LOG
CRPROG "Token-Ring DatagLANce Demo" "Monitor Ethertype Protocols" "%DGNAPATH%\DGLAUNCH.EXE" "TRMONDEM /CETYPDIST" "%DGNAPATH%"       "%DGNAPATH%\DISTRIB.ICO"  >>%DGNAPATH%\INSTALL.LOG
CRPROG "Token-Ring DatagLANce Demo" "Monitor Protocol Suites"     "%DGNAPATH%\DGLAUNCH.EXE" "TRMONDEM /CSUITDIST" "%DGNAPATH%"       "%DGNAPATH%\DISTRIB.ICO"  >>%DGNAPATH%\INSTALL.LOG
CRPROG "Token-Ring DatagLANce Demo" "Monitor IP Protocols"        "%DGNAPATH%\DGLAUNCH.EXE" "TRMONDEM /CIPDIST" "%DGNAPATH%"         "%DGNAPATH%\DISTRIB.ICO"  >>%DGNAPATH%\INSTALL.LOG
CRPROG "Token-Ring DatagLANce Demo" "Monitor Routing "            "%DGNAPATH%\DGLAUNCH.EXE" "TRMONDEM /CRTYPDIST" "%DGNAPATH%"       "%DGNAPATH%\DISTRIB.ICO"  >>%DGNAPATH%\INSTALL.LOG
CRPROG "Token-Ring DatagLANce Demo" "Monitor Routing Hops"        "%DGNAPATH%\DGLAUNCH.EXE" "TRMONDEM /CRHOPDIST" "%DGNAPATH%"       "%DGNAPATH%\DISTRIB.ICO"  >>%DGNAPATH%\INSTALL.LOG
CRPROG "Token-Ring DatagLANce Demo" "Monitor Ring Map"            "%DGNAPATH%\DGLAUNCH.EXE" "TRMONDEM /CRINGMAP" "%DGNAPATH%"        "%DGNAPATH%\TOKNRING.ICO" >>%DGNAPATH%\INSTALL.LOG
CRPROG "Token-Ring DatagLANce Demo" "Learn IBM NetBIOS Names"     "%DGNAPATH%\DGLAUNCH.EXE" "TRMONDEM /CNETBNAME" "%DGNAPATH%"       "%DGNAPATH%\NAMES.ICO"    >>%DGNAPATH%\INSTALL.LOG
CRPROG "Token-Ring DatagLANce Demo" "Learn TCP/IP Names"          "%DGNAPATH%\DGLAUNCH.EXE" "TRMONDEM /CIPNAME" "%DGNAPATH%"         "%DGNAPATH%\NAMES.ICO"    >>%DGNAPATH%\INSTALL.LOG
CRPROG "Token-Ring DatagLANce Demo" "Learn IPX Names"             "%DGNAPATH%\DGLAUNCH.EXE" "TRMONDEM /CIPXNAME" "%DGNAPATH%"        "%DGNAPATH%\NAMES.ICO"    >>%DGNAPATH%\INSTALL.LOG
CRPROG "Token-Ring DatagLANce Demo" "Learn DEC Names"             "%DGNAPATH%\DGLAUNCH.EXE" "TRMONDEM /CDECNAME" "%DGNAPATH%"        "%DGNAPATH%\NAMES.ICO"    >>%DGNAPATH%\INSTALL.LOG
CRPROG "Token-Ring DatagLANce Demo" "Learn AppleTalk Names"       "%DGNAPATH%\DGLAUNCH.EXE" "TRMONDEM /CAPPLNAME" "%DGNAPATH%"       "%DGNAPATH%\NAMES.ICO"    >>%DGNAPATH%\INSTALL.LOG
:NOXTRMON
CRPROG "Token-Ring DatagLANce Demo" "Default Configuration"       "%DGNAPATH%\DGLAUNCH.EXE" "TRMONDEM /CDEFAULT" "%DGNAPATH%"        "%DGNAPATH%\DGMON.ICO"    >>%DGNAPATH%\INSTALL.LOG
CRPROG "Token-Ring DatagLANce Demo" "File Server Template"        "%DGNAPATH%\DGLAUNCH.EXE" "TRMONDEM /CFILESERV" "%DGNAPATH%"       "%DGNAPATH%\DGMON.ICO"    >>%DGNAPATH%\INSTALL.LOG
CRPROG "Token-Ring DatagLANce Demo" "Distribution Template"       "%DGNAPATH%\DGLAUNCH.EXE" "TRMONDEM /CEVNTDIST" "%DGNAPATH%"       "%DGNAPATH%\DGMON.ICO"    >>%DGNAPATH%\INSTALL.LOG
CRPROG "Token-Ring DatagLANce Demo" "Template"                    "%DGNAPATH%\DGLAUNCH.EXE" "TRMONDEM /Cyourconfighere" "%DGNAPATH%" "%DGNAPATH%\DGMON.ICO"    >>%DGNAPATH%\INSTALL.LOG
:NOTRMONICONS

IF "%IENMON%"=="" GOTO NOENMONICONS
ECHO Creating desktop icons for the Ethernet DatagLANce Network Analyzer...
CRGROUP "DatagLANce Demo" >>%DGNAPATH%\INSTALL.LOG
CRPROG "DatagLANce Demo"            "Ethernet Network Analyzer Demo" "%DGNAPATH%\ENMONDEM.EXE" "/CSTARTUP" "%DGNAPATH%"                 "%DGNAPATH%\DGMON.ICO"    >>%DGNAPATH%\INSTALL.LOG
CRGROUP "Ethernet DatagLANce Demo" >>%DGNAPATH%\INSTALL.LOG
CRPROG "Ethernet DatagLANce Demo" "Capture Frames"              "%DGNAPATH%\DGLAUNCH.EXE" "ENMONDEM /CCAPTURE" "%DGNAPATH%"        "%DGNAPATH%\CAPTURE.ICO"  >>%DGNAPATH%\INSTALL.LOG
CRPROG "Ethernet DatagLANce Demo" "Traffic Analysis"            "%DGNAPATH%\DGLAUNCH.EXE" "ENMONDEM /CTRAFANAL" "%DGNAPATH%"       "%DGNAPATH%\TRAFFIC.ICO"  >>%DGNAPATH%\INSTALL.LOG
CRPROG "Ethernet DatagLANce Demo" "Traffic Matrix"              "%DGNAPATH%\DGLAUNCH.EXE" "ENMONDEM /CTRAMATRX" "%DGNAPATH%"       "%DGNAPATH%\TRAMATRX.ICO" >>%DGNAPATH%\INSTALL.LOG
CRPROG "Ethernet DatagLANce Demo" "Protocol Matrix"             "%DGNAPATH%\DGLAUNCH.EXE" "ENMONDEM /CPROMATRX" "%DGNAPATH%"       "%DGNAPATH%\PROMATRX.ICO" >>%DGNAPATH%\INSTALL.LOG
CRPROG "Ethernet DatagLANce Demo" "Monitor Frame Sizes"         "%DGNAPATH%\DGLAUNCH.EXE" "ENMONDEM /CSIZEDIST" "%DGNAPATH%"       "%DGNAPATH%\DISTRIB.ICO"  >>%DGNAPATH%\INSTALL.LOG
CRPROG "Ethernet DatagLANce Demo" "Monitor SAP Protocols"       "%DGNAPATH%\DGLAUNCH.EXE" "ENMONDEM /CLSAPDIST" "%DGNAPATH%"       "%DGNAPATH%\DISTRIB.ICO"  >>%DGNAPATH%\INSTALL.LOG
CRPROG "Ethernet DatagLANce Demo" "Monitor Ethertype Protocols" "%DGNAPATH%\DGLAUNCH.EXE" "ENMONDEM /CETYPDIST" "%DGNAPATH%"       "%DGNAPATH%\DISTRIB.ICO"  >>%DGNAPATH%\INSTALL.LOG
CRPROG "Ethernet DatagLANce Demo" "Monitor Protocol Suites"     "%DGNAPATH%\DGLAUNCH.EXE" "ENMONDEM /CSUITDIST" "%DGNAPATH%"       "%DGNAPATH%\DISTRIB.ICO"  >>%DGNAPATH%\INSTALL.LOG
CRPROG "Ethernet DatagLANce Demo" "Monitor IP Protocols"        "%DGNAPATH%\DGLAUNCH.EXE" "ENMONDEM /CIPDIST" "%DGNAPATH%"         "%DGNAPATH%\DISTRIB.ICO"  >>%DGNAPATH%\INSTALL.LOG
CRPROG "Ethernet DatagLANce Demo" "Learn IBM NetBIOS Names"     "%DGNAPATH%\DGLAUNCH.EXE" "ENMONDEM /CNETBNAME" "%DGNAPATH%"       "%DGNAPATH%\NAMES.ICO"    >>%DGNAPATH%\INSTALL.LOG
CRPROG "Ethernet DatagLANce Demo" "Learn TCP/IP Names"          "%DGNAPATH%\DGLAUNCH.EXE" "ENMONDEM /CIPNAME" "%DGNAPATH%"         "%DGNAPATH%\NAMES.ICO"    >>%DGNAPATH%\INSTALL.LOG
CRPROG "Ethernet DatagLANce Demo" "Learn IPX Names"             "%DGNAPATH%\DGLAUNCH.EXE" "ENMONDEM /CIPXNAME" "%DGNAPATH%"        "%DGNAPATH%\NAMES.ICO"    >>%DGNAPATH%\INSTALL.LOG
CRPROG "Ethernet DatagLANce Demo" "Learn DEC Names"             "%DGNAPATH%\DGLAUNCH.EXE" "ENMONDEM /CDECNAME" "%DGNAPATH%"        "%DGNAPATH%\NAMES.ICO"    >>%DGNAPATH%\INSTALL.LOG
CRPROG "Ethernet DatagLANce Demo" "Learn AppleTalk Names"       "%DGNAPATH%\DGLAUNCH.EXE" "ENMONDEM /CAPPLNAME" "%DGNAPATH%"       "%DGNAPATH%\NAMES.ICO"    >>%DGNAPATH%\INSTALL.LOG
:NOXENMON
CRPROG "Ethernet DatagLANce Demo" "Default Configuration"       "%DGNAPATH%\DGLAUNCH.EXE" "ENMONDEM /CDEFAULT" "%DGNAPATH%"        "%DGNAPATH%\DGMON.ICO"    >>%DGNAPATH%\INSTALL.LOG
CRPROG "Ethernet DatagLANce Demo" "File Server Template"        "%DGNAPATH%\DGLAUNCH.EXE" "ENMONDEM /CFILESERV" "%DGNAPATH%"       "%DGNAPATH%\DGMON.ICO"    >>%DGNAPATH%\INSTALL.LOG
CRPROG "Ethernet DatagLANce Demo" "Distribution Template"       "%DGNAPATH%\DGLAUNCH.EXE" "ENMONDEM /CEVNTDIST" "%DGNAPATH%"       "%DGNAPATH%\DGMON.ICO"    >>%DGNAPATH%\INSTALL.LOG
CRPROG "Ethernet DatagLANce Demo" "Template"                    "%DGNAPATH%\DGLAUNCH.EXE" "ENMONDEM /Cyourconfighere" "%DGNAPATH%" "%DGNAPATH%\DGMON.ICO"    >>%DGNAPATH%\INSTALL.LOG
:NOENMONICONS

:NOICONS



GOTO DONE

:ERROR
ECHO ***********************************************************************
ECHO AN INSTALLATION ERROR OCCURRED. PRESS ANY KEY TO VIEW INSTALLATION LOG.
ECHO ***********************************************************************
PAUSE
E %DGNAPATH%\INSTALL.LOG
GOTO EXIT

:DONE
REM Have user insert disk 1 again so we can cleanup any temp files
IF "%DISKETTE%"=="1" GOTO NOCLEANDISK
:INSERT1BDISK
ECHO Please insert installation diskette 1 in drive %SRCPATH%
PAUSE
REM MAKE SURE THAT DISK WAS INSERTED (LOOK FOR FILE WE KNOW SHOULD BE THERE)
IF NOT EXIST %SRCPATH%\INCLUP.CMD GOTO INSERT1BDISK
SET DISKETTE=1
:NOCLEANDISK

REM DELETE TEMPORARY FILES (INCLUDING THIS ONE)
%SRCPATH%\INCLUP

:EXIT
