/* REXX installation script for LanScan */

  Call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
  Call SysLoadFuncs

  parse source ResPath
  ResPath=space(ResPath, 1)
  ResPath=subword(ResPath, 3)
  lPos=lastpos("\", ResPath)
  ResPath=substr(ResPath, 1, lPos)

  say "Create LanScan object on desktop? Y/N"
  say " ꥪ LanScan  ⮯? /"
  pull Ans
  if \ ( (Ans="Y") | (Ans="y") | (Ans="") | (Ans="") ) then exit

  FolderId = '<LanScan_Folder>'
  setup = 'OBJECTID='FolderId';ICONFILE='||ResPath||,
          'LanScan1.ico;ICONNFILE=1,'||ResPath||'LanScan2.ico'
  rc = SysCreateObject('WPFolder', 'LanScan', '<WP_DESKTOP>', setup, 'R')
  if rc = 0 then do
    say 'LanScan folder object did not created'
    say '訡  ᮧ  LanScan'
    exit
  end

  PgmSetup = 'OBJECTID=<LanScan>;EXENAME='||ResPath||'LanScan.exe;'||,
             'STARTUPDIR='||ResPath||';PROGTYPE=PM'
  rc = SysCreateObject("WPProgram", 'LanScan', FolderId, PgmSetup, 'R')
  if rc = 0 then do
    say 'Program object <'PgmTitle'> did not created'
    say '訡  ᮧ ணࠬ ꥪ <'PgmTitle'>'
    exit
  end


  ObjSetup = 'OBJECTID=<LanScan Info>;'||'SHADOWID='||ResPath||'LanScan.INF'
  rc = SysCreateObject("WPShadow", 'LanScan Info', FolderId, ObjSetup, 'R')
  if rc = 0 then do
    say 'Object <LanScan Info> did not created'
    say '訡  ᮧ ꥪ <LanScan Info>'
    exit
  end

  say ""
  say "Successful creation of object LanScan"
  say "ᯥ譮 ᮧ ꥪ LanScan"