  var MSG_CONFIRM_DELETE_RULE = "Do you wish to delete rule with all subrules?";
  var MSG_CONFIRM_DELETE_SUBRULES = "Do you wish to delete all subrules of rule?";
  var MSG_ERROR_ADDRESS = "Invalid address.";
  var MSG_ERROR_PORTS = "Error in list of ports.";
  var MSG_ERROR_PATH = "Invalid path.";
  var MSG_ASK_NEW = "Create a new filter?";
  var MSG_UNKNOWN_ANSWER = "Unknown answer.";

  var IMG_SRC_BTN_HIDE = "img/btn-hide.gif";
  var IMG_SRC_BTN_SHOW = "img/btn-show.gif";

  var xmlDoc;
  var PROTOCOLS = new Array('icmp','tcp','udp','other');

  // cb_action
  var CB_NONE		= 0;
  var CB_COPY		= 1;
  var CB_CUT		= 2;
  // clipboard
  var cb_id		= null;
  var cb_action		= CB_NONE;

  var LOC_BEFORE	= 0;
  var LOC_AFTER		= 1;
  var LOC_INTO		= 2;

  var last_id		= 0;


// ---------------------------------------------------------------
// |                        Build filter                         |
// ---------------------------------------------------------------

  function LoadFilter()
  {
    if ( !(http_request = HTTPMakeRequest()) )
      return;

    http_request.onreadystatechange = show_filter;
    http_request.open('POST', 'filter', true);
    http_request.send(null);
  }

  function TV3Rule(el, tree)
  {
    var sub_element;
    var src = new Array(), dst = new Array();
    var proto = new Array();
    var path = "", sent = 0, recv = 0;
    var el_attr;

    if ( !el )
    {
      this.id		= last_id;
      this.stop		= false;
      this.dataonly	= false;
      this.src		= null;
      this.dst		= null;
      this.proto	= null;
      this.path		= 'new';
      this.sent		= 0;
      this.recv		= 0;
      this.rules	= null;
      return;
    }

    if ( tree )
      var rules = new Array();

    for (var i=0;i<el.childNodes.length;i++)
    { 
      sub_element = el.childNodes[i];

      if ( sub_element.nodeType==1 )
        switch ( sub_element.nodeName )
        {
          case "path":
            path = sub_element.firstChild.nodeValue;
            break;
          case "src":
            src[src.length] = sub_element.firstChild.nodeValue;
            break;
          case "dst":
            dst[dst.length] = sub_element.firstChild.nodeValue;
            break;
          case "proto":
            proto[proto.length] =
              new Array( sub_element.attributes.getNamedItem('name').nodeValue,
                         sub_element.firstChild.nodeValue );
            break;
          case "sent":
            sent = sub_element.firstChild.nodeValue;
            break;
          case "recv":
            recv = sub_element.firstChild.nodeValue;
            break;
          case "rule":
            if ( tree )
              rules[rules.length++] = ReadRules(sub_element);
            break;
        }
    }

    this.id		= parseInt( el.attributes.getNamedItem('id').nodeValue );
    el_attr = el.attributes.getNamedItem('stop');
    this.stop		= el_attr ? el_attr.nodeValue=='Y' : false;
    el_attr = el.attributes.getNamedItem('dataonly');
    this.dataonly	= el_attr ? el_attr.nodeValue=='Y' : false;
    this.src		= src;
    this.dst		= dst;
    this.proto		= proto;
    this.path		= path;
    this.sent		= sent;
    this.recv		= recv;
    if ( tree )
      this.rules	= rules;
  }

  function show_rules(html_rule,visible)
  {
    if ( document.getElementById('editor') ) return;

    var attr_class = html_rule.attributes.getNamedItem('class');
    if ( !attr_class || attr_class.nodeValue != 'rule' ) return;

    var html_rule_components = html_rule.childNodes;
    var html_img_btn = html_rule_components[1];
    if ( html_rule_components[2].childNodes.length==0 )
    {
      HTMLSetStyle(html_img_btn, 'height:1px');
      return;
    }

    html_img_btn.setAttribute( 'src', 
                               visible ? IMG_SRC_BTN_HIDE : IMG_SRC_BTN_SHOW );
    HTMLSetStyle(html_img_btn, '');
    HTMLSetOnClick(html_img_btn,
      'show_rules(this.parentNode,'+(visible ? 'false':'true')+');');

    HTMLSetStyle(html_rule_components[2],
      visible ? 'overflow:visible;' : 'height:1px;overflow:hidden;');
  }

  function fill_conditions(html_div_cond,R)
  {
    while( html_div_cond.childNodes.length )
      html_div_cond.removeChild( html_div_cond.firstChild );

    var html_span = document.createElement('span');
    HTMLSetClass(html_span, 'rule_hdr');
    var html_img = document.createElement('img');
    html_img.setAttribute('src', R.stop ? 'img/stop-Y.gif' : 'img/stop-N.gif');
    HTMLSetOnClick(html_img, 'RuleMenu('+R.id+');');
    html_span.appendChild(html_img);
    html_span.appendChild(document.createTextNode(R.path));
    html_div_cond.appendChild(html_span);

    if ( R.src )
      for(i=0; i<R.src.length; i++)
      {
        html_div_cond.appendChild(document.createTextNode('src: '+R.src[i]));
        html_div_cond.appendChild(document.createElement('br'));
      }
    if ( R.dst )
      for(i=0; i<R.dst.length; i++)
      {
        html_div_cond.appendChild(document.createTextNode('dst: '+R.dst[i]));
        html_div_cond.appendChild(document.createElement('br'));
      }
    if ( R.proto )
      for(i=0; i<R.proto.length; i++)
      {
        html_div_cond.appendChild(document.createTextNode('proto '+R.proto[i][0]+' ('+R.proto[i][1]+')'));
        html_div_cond.appendChild(document.createElement('br'));
      }
    html_div_cond.appendChild(document.createTextNode('sent: '+R.sent+' recv: '+R.recv));
    html_div_cond.appendChild(document.createElement('br'));
  }

  function ReadRules(xml_el)
  {
    var R = new TV3Rule(xml_el,true);
    var html_div_rule = document.createElement('div');
    html_div_rule.setAttribute('id', R.id);
    HTMLSetClass(html_div_rule, 'rule');
    if ( R.id > last_id )
      last_id = R.id;

    var html_div_cont = document.createElement('div');
    HTMLSetClass(html_div_cont, 'conditions');
    fill_conditions(html_div_cont,R);
    html_div_rule.appendChild(html_div_cont);

    var html_btn = document.createElement('img');
    HTMLSetClass(html_btn, 'subrule_btn');
    HTMLSetStyle(html_btn, 'height:1px');
    html_div_rule.appendChild(html_btn);

    var html_div_cont = document.createElement('div');
    HTMLSetClass(html_div_cont, 'subrules');
    if ( R.rules )
      for(i=0; i<R.rules.length; i++)
        html_div_cont.appendChild(R.rules[i]);
    html_div_rule.appendChild(html_div_cont);

    delete R;

    show_rules(html_div_rule,true);
    return html_div_rule;
  }

  function show_filter()
  {
    if ( http_request.readyState != 4 ) return;

    html_clear();

    var ResXML = http_request.responseXML;
    var el = ResXML.documentElement;

    if ( el.nodeName=='filter' )
    {
      xmlDoc = ResXML;
      var rules = ResXML.documentElement.childNodes;
      var output = document.getElementById('filter');

      for (var i=0; i<rules.length; i++)
        if ( rules[i].nodeType==1 && rules[i].nodeName=='rule')
          output.appendChild( ReadRules(rules[i]) );
    }
    else if ( el.nodeName=='message' )
      MessageBoxXML(ResXML);
    else
      alert(MSG_UNKNOWN_ANSWER);
    return;
  }

// ---------------------------------------------------------------
// |                           Editor                            |
// ---------------------------------------------------------------

  function strip(str,character)
  {
    for(var i = 1; i<str.length; i++)
      str = str.replace(character, '');
    return str;
  }

  function trim_path(sString)
  {
    var ch;
    while (true)
    {
      ch = sString.substring(0,1);
      if (ch != ' ' && ch != '/') break;
      sString = sString.substring(1, sString.length);
    }
    while (true)
    {
      ch = sString.substring(sString.length-1, sString.length);
      if (ch != ' ' && ch != '/') break;
      sString = sString.substring(0,sString.length-1);
    }
    return sString;
  }

  var reg_keys=/^(host|other)$/i;
  var reg_ip=/^([0-9]|[0-9][0-9]|[01][0-9][0-9]|2[0-4][0-9]|25[0-5])(\.([0-9]|[0-9][0-9]|[01][0-9][0-9]|2[0-4][0-9]|25[0-5])){3}$/;
  var reg_ip_dot_mask=/^([0-9]|[0-9][0-9]|[01][0-9][0-9]|2[0-4][0-9]|25[0-5])(\.([0-9]|[0-9][0-9]|[01][0-9][0-9]|2[0-4][0-9]|25[0-5])){3}\/([0-9]|[0-9][0-9]|[01][0-9][0-9]|2[0-4][0-9]|25[0-5])(\.([0-9]|[0-9][0-9]|[01][0-9][0-9]|2[0-4][0-9]|25[0-5])){3}$/;
  var reg_ip_num_mask=/^([0-9]|[0-9][0-9]|[01][0-9][0-9]|2[0-4][0-9]|25[0-5])(\.([0-9]|[0-9][0-9]|[01][0-9][0-9]|2[0-4][0-9]|25[0-5])){3}\/([0-9]|[0-2][0-9]|3[0-2])$/;
  var reg_mac=/^([0-9,A-F]|[0-9,A-F][0-9,A-F])((\:|\-)([0-9,A-F]|[0-9,A-F][0-9,A-F])){5}$/i;
  var reg_port=/^\s*((any|\*)|!{0,1}\s*((lt|gt){0,1}\s*([0-9]{1,4}|[0-6][0-9]{4})|([0-9]{1,4}|[0-6][0-9]{4})-([0-9]{1,4}|[0-6][0-9]{4})))\s*$/i;
  var reg_path=/^.*\/\/.*$/;

  function valid_addr(str)
  {
    return ( reg_mac.test( str ) || reg_keys.test( str ) ||
             reg_ip.test( str ) || reg_ip_dot_mask.test( str ) ||
             reg_ip_num_mask.test( str ) );
  }

  function valid_ports_list(str)
  {
    var ports = str.split(",");

    if ( !ports.length ) return false;
    for(var i=0; i<ports.length; i++)
      if ( !reg_port.test(ports[i]) )
        return false;
    return true;
  }

  function valid_ports(str)
  {
    var ports = str.split(":");
    var src_ports = ports[0], dst_ports = ports[1];
    if ( !ports[0] ) src_ports = "any"
    else if ( ports.length==1 ) dst_ports = "any";

    return valid_ports_list(src_ports) && valid_ports_list(dst_ports);
  }

  function valid_path(str)
  {
    return !reg_path.test( str );
  }

  function get_xml_rule(id)
  {
    var rules = xmlDoc.getElementsByTagName('rule');
    var rule = null;

    for(var i=0; i<rules.length; i++)
      if ( rules[i].attributes.getNamedItem('id').nodeValue == id )
      {
        rule = rules[i];
        break;
      }
    return rule;
  }

  function editor_add_addr(list_id)
  {
    var addr_list = document.getElementById(list_id);
    addr_list.appendChild( el_addr('') );
    return false;
  }

  function editor_add_proto(list_id)
  {
    var addr_list = document.getElementById(list_id);
    addr_list.appendChild( el_proto('','') );
    return false;
  }

  function el_addr(str_addr)
  {
    var html_div_addr = document.createElement('div');

    var el = document.createElement('input');
    el.setAttribute('type', 'text');
    el.setAttribute('value', str_addr);
    el.setAttribute('maxlength', '31');
    el.setAttribute('size', '35');
    html_div_addr.appendChild(el);

    var html_btn_del = document.createElement('img');
    html_btn_del.setAttribute('src', 'img/editor-btn-del.gif');
    html_btn_del.setAttribute('height', '16');
    html_btn_del.setAttribute('width', '14');
    html_btn_del.setAttribute('align', 'center');
    html_btn_del.setAttribute(document.all ? 'alt' : 'title', 'remove item');
    HTMLSetOnClick(html_btn_del, 'delete_el(this.parentNode);');
    html_div_addr.appendChild(html_btn_del);

    return html_div_addr;
  }

  function el_proto(str_name,str_ports)
  {
    var html_select_name, html_option_name, html_input_ports;
    var html_div_proto = document.createElement('div');

    html_select_name = document.createElement('select');
    for(var i=0; i<PROTOCOLS.length; i++)
    {
      html_option_name = document.createElement('option');
      html_option_name.appendChild(document.createTextNode(PROTOCOLS[i]));
      html_option_name.setAttribute('value', PROTOCOLS[i]);
      if ( str_name == PROTOCOLS[i] )
        html_option_name.setAttribute('selected', '1');
      html_select_name.appendChild(html_option_name);
    }
    html_div_proto.appendChild(html_select_name);
      
    html_input_ports = document.createElement('input');
    html_input_ports.setAttribute('type', 'text');
    html_input_ports.setAttribute('size', 30);
    html_input_ports.setAttribute('maxlength', 320);
    html_input_ports.setAttribute('value', str_ports);
    html_div_proto.appendChild(html_input_ports);

    var html_btn_del = document.createElement('img');
    html_btn_del.setAttribute('src', 'img/editor-btn-del.gif');
    html_btn_del.setAttribute('height', '16');
    html_btn_del.setAttribute('width', '14');
    html_btn_del.setAttribute('align', 'center');
    html_btn_del.setAttribute(document.all ? 'alt' : 'title', 'remove item');
    HTMLSetOnClick(html_btn_del, 'delete_el(this.parentNode);');
    html_div_proto.appendChild(html_btn_del);

    return html_div_proto;
  }

  function editor_apply(id)
  {
    var xml_rule, xml_el;
    var html_el, editor_el_list, editor_el_list2;
    var src_list = new Array(), dst_list = new Array(), port_list = new Array();
    var path, i, str;

    xml_rule = get_xml_rule(id);
    if ( !xml_rule ) return;

    html_el = document.getElementById('editor_path');
    path = trim_path(html_el.value);
    if ( !valid_path(path) )
    {
      html_el.focus();
      alert(MSG_ERROR_PATH);
      return;
    }

    html_el = document.getElementById('src_list');
    html_el_list = html_el.getElementsByTagName('input');
    for(i=0; i<html_el_list.length; i++)
    {
      str = strip(html_el_list[i].value, ' ');
      if ( !valid_addr(str) ) {
        html_el_list[i].focus();
        alert(MSG_ERROR_ADDRESS);
        return;
      }
      src_list[i] = str;
    }

    html_el = document.getElementById('dst_list');
    html_el_list = html_el.getElementsByTagName('input');
    for(i=0; i<html_el_list.length; i++)
    {
      str = strip(html_el_list[i].value, ' ');
      if ( !valid_addr(str) ) {
        html_el_list[i].focus();
        alert(MSG_ERROR_ADDRESS);
        return;
      }
      dst_list[i] = str;
    }

    html_el = document.getElementById('proto_list');
    html_el_list = html_el.getElementsByTagName('input') ;
    for(i=0; i<html_el_list.length; i++)
    {
      str = html_el_list[i].value;
      if ( !valid_ports(str) ) {
        html_el_list[i].focus();
        alert(MSG_ERROR_PORTS);
        return;
      }
      port_list[i] = str;
    }

    // - - - clear - - -
    for(i=xml_rule.childNodes.length-1; i >= 0; i--)
     if ( xml_rule.childNodes[i].nodeName!='rule' &&
          xml_rule.childNodes[i].nodeName!='sent' &&
          xml_rule.childNodes[i].nodeName!='recv' )
       xml_rule.removeChild(xml_rule.childNodes[i]);

    html_el = document.getElementById('editor_stop');
    xml_rule.setAttribute('stop', html_el.checked ? 'Y' : 'N');
    html_el = document.getElementById('editor_dataonly');
    xml_rule.setAttribute('dataonly', html_el.checked ? 'Y' : 'N');

    xml_el = xmlDoc.createElement('path');
    xml_el.appendChild( xmlDoc.createTextNode(path) );
    xml_rule.appendChild( xml_el );

    for(i=0; i<src_list.length; i++)
    {
      xml_el = xmlDoc.createElement('src');
      xml_el.appendChild( xmlDoc.createTextNode(src_list[i]) );
      xml_rule.appendChild( xml_el );
    }

    html_el = document.getElementById('dst_list');
    html_el_list = html_el.getElementsByTagName('input') ;
    for(i=0; i<dst_list.length; i++)
    {
      xml_el = xmlDoc.createElement('dst');
      xml_el.appendChild( xmlDoc.createTextNode(dst_list[i]) );
      xml_rule.appendChild( xml_el );
    }

    html_el = document.getElementById('proto_list');
    html_el_list = html_el.getElementsByTagName('select');
    for(i=0; i<port_list.length; i++)
    {
      xml_el = xmlDoc.createElement('proto');
      xml_el.setAttribute('name', html_el_list[i].value);
      xml_el.appendChild( xmlDoc.createTextNode(port_list[i]) );
      xml_rule.appendChild( xml_el );
    }

    var html_div_cond = document.getElementById(id).firstChild;

    var R = new TV3Rule(xml_rule,false);
    fill_conditions(html_div_cond,R);
    delete R;

    delete_el_byId("editor");
  }

  function rule_delete(id)
  {
    var html_rule = document.getElementById(id);
    var html_rule_parent = html_rule.parentNode.parentNode;

    delete_el(get_xml_rule(id));
    delete_el(html_rule);

    show_rules(html_rule_parent,true);
  }

  function Editor(id,newRule,X,Y)
  {
    var rule;
    var label, div_flags, input;

    rule = get_xml_rule(id);
    if ( !rule )
      { alert("Editor(): xml ID not found."); return; }

    if ( document.getElementById('editor') ) return;

    var div = document.createElement('form');
    div.setAttribute('name', 'editor');
    div.setAttribute('id', 'editor');
    div.setAttribute('action', '/filter');
    HTMLSetStyle(div, 'left:'+X+'px;top:'+Y+'px');
    HTMLSetOnSubmit(div, 'editor_apply('+id+'); return false;');

    var div_hdr = document.createElement('div');
    HTMLSetClass(div_hdr, 'hdr');
    div_hdr.appendChild( document.createTextNode('Editor') );
    div.appendChild(div_hdr);

    var R = new TV3Rule(rule,false);
    var i, btn_add, btn_dlg, div_btn;

    var div_client = document.createElement('div');
    HTMLSetClass(div_client, 'client');

    div_flags = document.createElement('div');
    HTMLSetStyle(div_flags, 'margin-bottom: 0.5em');

    var el_stop = document.createElement('input');
    el_stop.setAttribute('id', 'editor_stop');
    el_stop.setAttribute('type', 'checkbox');
    div_flags.appendChild(el_stop);
    label = document.createElement('label');
    label.setAttribute('for', 'editor_stop');
    label.appendChild(document.createTextNode('stop scanning if the rule has worked '));
    div_flags.appendChild(label);

    var el_dataonly = document.createElement('input');
    el_dataonly.setAttribute('id', 'editor_dataonly');
    el_dataonly.setAttribute('type', 'checkbox');
    div_flags.appendChild(el_dataonly);
    label = document.createElement('label');
    label.setAttribute('for', 'editor_dataonly');
    label.appendChild(document.createTextNode('data only'));
    div_flags.appendChild(label);

    div_client.appendChild(div_flags);

    div_client.appendChild(document.createTextNode('Path: '));
    var el_path = document.createElement('input');
    el_path.setAttribute('maxlength', '255');
    el_path.setAttribute('size', '35');
    el_path.setAttribute('id', 'editor_path');
    el_path.setAttribute('type', 'text');
    el_path.setAttribute('value', R.path);
    div_client.appendChild(el_path);

    var div_src = document.createElement('div');
    HTMLSetClass(div_src, 'list');
    div_src.appendChild(document.createTextNode('Source'));
    div_src.setAttribute('id', 'src_list');
    for(i=0; i<R.src.length; i++)
      div_src.appendChild( el_addr(R.src[i]) );
    div_client.appendChild(div_src);

    btn_add = document.createElement('img');
    btn_add.setAttribute('src', 'img/editor-btn-add.gif');
    btn_add.setAttribute('height', '13');
    btn_add.setAttribute('width', '59');
    btn_add.setAttribute(document.all ? 'alt' : 'title', 'new item');
    HTMLSetOnClick(btn_add, 'editor_add_addr("src_list");');
    div_client.appendChild(btn_add);

    var div_dst = document.createElement('div');
    HTMLSetClass(div_dst, 'list');
    div_dst.setAttribute('id', 'dst_list');
    div_dst.appendChild(document.createTextNode('Destination'));
    for(i=0; i<R.dst.length; i++)
      div_dst.appendChild( el_addr(R.dst[i]) );
    div_client.appendChild(div_dst);

    btn_add = document.createElement('img');
    btn_add.setAttribute('src', 'img/editor-btn-add.gif');
    btn_add.setAttribute('height', '13');
    btn_add.setAttribute('width', '59');
    btn_add.setAttribute(document.all ? 'alt' : 'title', 'new item');
    HTMLSetOnClick(btn_add, 'editor_add_addr("dst_list");');
    div_client.appendChild(btn_add);

    var div_proto = document.createElement('div');
    HTMLSetClass(div_proto, 'list');
    div_proto.setAttribute('id', 'proto_list');
    div_proto.appendChild(document.createTextNode('Protocols'));
    for(i=0; i<R.proto.length; i++)
      div_proto.appendChild( el_proto(R.proto[i][0], R.proto[i][1]) );
    div_client.appendChild(div_proto);

    btn_add = document.createElement('img');
    btn_add.setAttribute('src', 'img/editor-btn-add.gif');
    btn_add.setAttribute('height', '13');
    btn_add.setAttribute('width', '59');
    btn_add.setAttribute(document.all ? 'alt' : 'title', 'new item');
    HTMLSetOnClick(btn_add, 'editor_add_proto("proto_list");');
    div_client.appendChild(btn_add);

    div.appendChild(div_client);

    btn_dlg = document.createElement('input');
    HTMLSetClass(btn_dlg, 'button');
    btn_dlg.setAttribute('type', 'submit');
    btn_dlg.setAttribute('value', 'Ok');
    div.appendChild(btn_dlg);
    btn_dlg = document.createElement('input');
    HTMLSetClass(btn_dlg, 'button');
    btn_dlg.setAttribute('type', 'button');
    btn_dlg.setAttribute('value', 'Cancel');
    HTMLSetOnClick(btn_dlg, newRule ?
      'delete_el_byId("editor"); rule_delete('+id+');' :
      'delete_el_byId("editor");');
    div.appendChild(btn_dlg);

    var output = document.getElementById('filter');
    output.appendChild(div);

    if ( R.stop )
      el_stop.setAttribute('checked', '1');
    if ( R.dataonly )
      el_dataonly.setAttribute('checked', '1');

    delete R;

    if ( newRule ) scroll(X,div.offsetTop-8);
  }

// ---------------------------------------------------------------
// |                         Popup menu                          |
// ---------------------------------------------------------------

  var rule_menu_id;

  function menu_item(caption,action)
  {
    var item = document.createElement('a');
    item.setAttribute('href', '/');
    HTMLSetOnClick(item, action+'return delete_el_byId("rule_menu");');
    item.appendChild(document.createTextNode(caption));
    return item;
  }

  function menu_space()
  {
    var item = document.createElement('hr');
    HTMLSetStyle(item, 'margin: 2px 5px 2px 5px; height: 1px; border: solid 1px gray');
    return item;
  }

  function SetClipboard(id, action)
  {
    var html_rule;

    ClearClipboard();

    cb_id = id;
    cb_action = action;

    if ( cb_action==CB_CUT )
    {
      html_rule = document.getElementById(id);
      HTMLSetStyle(html_rule, 'border: dotted 1px #FF9A45');
    }
  }

  function ClearClipboard()
  {
    if ( cb_action==CB_CUT )
    {
      var html_rule = document.getElementById(cb_id);
      HTMLSetStyle(html_rule, '');
    }

    cb_id = null;
    cb_action = CB_NONE;
  }

  function can_be_pasted(id)
  {
    var xml_rule, xml_attr;

    if ( cb_action!=CB_CUT )
      return cb_action==CB_COPY;

    for(xml_rule = get_xml_rule(id); xml_rule; xml_rule = xml_rule.parentNode)
    {
      xml_attr = xml_rule.attributes.getNamedItem('id');
      if ( !xml_attr ) return true;
      if ( xml_attr.nodeValue==cb_id )
        return false;
    }
    return true;
  }

  function set_new_id(xml_rule)
  {
    last_id++;
    xml_rule.setAttribute('id', last_id);

    for (var i=0;i<xml_rule.childNodes.length;i++)
      if ( xml_rule.childNodes[i].nodeType==1 )
       set_new_id( xml_rule.childNodes[i] );
  }

  function have_subrules(id)
  {
    return get_xml_rule(id).getElementsByTagName('rule').length != 0;
  }

  function RuleMenu(id)
  {
    var div;
    if ( document.getElementById('editor') ) return;

    if ( div = document.getElementById('rule_menu') )
    {
      delete_el(div);
      if ( rule_menu_id==id )
        return;
    }

    CloseAllPopups();

    var div = document.createElement('div');
    div.setAttribute('id', 'rule_menu');

    var Pos = new HTMLGetPos( document.getElementById(id) );
    Pos.X += 2; Pos.Y += 19;
    HTMLSetStyle(div, 'left:'+Pos.X+'px;top:'+Pos.Y+'px');
    Pos.X += 8; Pos.Y -= 8;

    div.appendChild( menu_item('Properties...','Editor('+id+',false,'+Pos.X+','+Pos.Y+');') );
    delete Pos;
    div.appendChild( menu_item('Cut','Cut('+id+');') );
    div.appendChild( menu_item('Copy','Copy('+id+');') );
    div.appendChild( menu_item('Delete','Delete('+id+');') );
    if ( have_subrules(id) )
      div.appendChild( menu_item('Delete rules','DeleteRules('+id+');') );
    div.appendChild( menu_space() );
    if ( can_be_pasted(id) )
    {
      div.appendChild( menu_item('Paste into','Paste('+id+',LOC_INTO);') );
      div.appendChild( menu_item('Paste before','Paste('+id+',LOC_BEFORE);') );
      div.appendChild( menu_item('Paste after','Paste('+id+',LOC_AFTER);') );
      div.appendChild( menu_space() );
    }
    div.appendChild( menu_item('New into','New('+id+',LOC_INTO);') );
    div.appendChild( menu_item('New before','New('+id+',LOC_BEFORE);') );
    div.appendChild( menu_item('New after','New('+id+',LOC_AFTER);') );

    var output = document.getElementById('filter');
    output.appendChild(div);
    rule_menu_id = id;
  }

  function Delete(id)
  {
    if ( !confirm(MSG_CONFIRM_DELETE_RULE) )
      return;
    rule_delete(id);
    ClearClipboard();
  }

  function DeleteRules(id)
  {
    var xml_rule = get_xml_rule(id);
    var html_rule;
    var i;

    if ( !confirm(MSG_CONFIRM_DELETE_SUBRULES) )
      return;

    for(i=xml_rule.childNodes.length-1; i >= 0; i--)
     if ( xml_rule.childNodes[i].nodeName=='rule' )
       xml_rule.removeChild(xml_rule.childNodes[i]);

    html_rule = document.getElementById(id);
    html_rule.parentNode.replaceChild(ReadRules(xml_rule), html_rule);
  }

  function Copy(id) { SetClipboard(id,CB_COPY); }

  function Cut(id) { SetClipboard(id,CB_CUT); }

  function New(id, loc)
  {
    var xml_rule = get_xml_rule(id);
    var html_rule = document.getElementById(id);

    last_id++;
    var xml_rule_new = xmlDoc.createElement('rule');
    xml_rule_new.setAttribute('id', last_id);
    var html_rule_new = ReadRules(null);

    switch ( loc )
    {
      case LOC_BEFORE:
        xml_rule.parentNode.insertBefore(xml_rule_new, xml_rule);
        html_rule.parentNode.insertBefore(html_rule_new, html_rule);
        break;
      case LOC_AFTER:
        xml_rule.parentNode.insertBefore(xml_rule_new, xml_rule.nextSibling);
        html_rule.parentNode.insertBefore(html_rule_new, html_rule.nextSibling);
        break;
      case LOC_INTO:
        xml_rule.appendChild(xml_rule_new);
        html_rule.childNodes[2].appendChild(html_rule_new);
        show_rules(html_rule,true);
        break;
    }
    var Pos = new HTMLGetPos(html_rule_new);
    Editor(last_id, true, Pos.X+8, Pos.Y+8);
    delete Pos;
  }

  function Paste(id, loc)
  {
    if ( cb_action == CB_NONE )
      return;

    var xml_rule_cb = get_xml_rule(cb_id);
    var xml_rule = get_xml_rule(id);
    var html_rule_cb = document.getElementById(cb_id);
    var html_rule = document.getElementById(id);

    if ( cb_action == CB_COPY )
    {
      xml_rule_cb = xml_rule_cb.cloneNode(true);
      set_new_id(xml_rule_cb);
      html_rule_cb = ReadRules(xml_rule_cb);
    }
    else
      var old_parent = html_rule_cb.parentNode.parentNode;

    switch ( loc )
    {
      case LOC_BEFORE:
        xml_rule.parentNode.insertBefore(xml_rule_cb, xml_rule);
        html_rule.parentNode.insertBefore(html_rule_cb, html_rule);
        break;
      case LOC_AFTER:
        xml_rule.parentNode.insertBefore(xml_rule_cb, xml_rule.nextSibling);
        html_rule.parentNode.insertBefore(html_rule_cb, html_rule.nextSibling);
        break;
      case LOC_INTO:
        xml_rule.appendChild(xml_rule_cb);
        html_rule.childNodes[2].appendChild(html_rule_cb);
        show_rules(html_rule,true);
        break;
    }

    if ( cb_action == CB_CUT )
      show_rules(old_parent,true);
    ClearClipboard();
  }

// ---------------------------------------------------------------
// |                       Expand/Collapse                       |
// ---------------------------------------------------------------

  function show_all_rules(visible)
  {
    var html_divs = document.getElementsByTagName('div');

    for(var i=0; i<html_divs.length; i++)
    {
      attr = html_divs[i].attributes.getNamedItem('class');
      if (attr && attr.nodeValue=='rule')
        show_rules(html_divs[i], visible);
    }
  }

  function ExpandAll() { show_all_rules(true); }

  function CollapseAll() { show_all_rules(false); }

// ---------------------------------------------------------------
// |                         Set Filter                          |
// ---------------------------------------------------------------

  var http_style;

  function SetFilter()
  {
    var txt_filter = XMLSourseText(xmlDoc);

    if ( !(http_request = HTTPMakeRequest()) )
      return;

    var boundary = '-------------------------24815163842';
    http_request.onreadystatechange = set_filter_done;
    http_request.open('POST', 'filter', true);
    http_request.setRequestHeader("Content-Type", "multipart/form-data; boundary="+boundary);
    http_request.setRequestHeader("Connection", "close");
    http_request.setRequestHeader("Content-Length", txt_filter.length);

    var txt_body = '--'+boundary+'\n'
      + 'Content-Disposition: form-data; name="filter.xml"\n\n'
      + txt_filter + '\n\n'
      + '--' + boundary + '--\n';

    http_request.send(txt_body);
  }

  function CloseAllPopups()
  {
    CloseMsgBox();
    delete_el(document.getElementById('editor'));
    delete_el(document.getElementById('rule_menu'));
  }
 
  function set_filter_done()
  {
    if ( http_request.readyState != 4 /*|| http_request.status != 200*/ )
      return;

    MessageBoxXML(http_request.responseXML);
  }


  function getQueryVariables()
  {
    var query = window.location.search.substring(1);  
    var vars = query.split("&");
    var arr = new Array(); 
    for (var i=0;i<vars.length;i++) {
        var pair = vars[i].split("=");
           arr[pair[0]] = pair[1];
      }
    return arr;
  }

// ---------------------------------------------------------------
// |                         New filter                          |
// ---------------------------------------------------------------

  function html_clear()
  {
    var html_el = document.getElementById('filter');
    while (html_el.firstChild)
      html_el.removeChild(html_el.firstChild);
  }

  function xml_clear()
  {
    delete xmlDoc;

    var xmlString = "<?xml version=\"1.0\" encoding=\"utf-8\"?><filter timestamp=\"1177665795\"><rule id=\"0\" dataonly=\"N\" stop=\"N\"><path>New</path></rule></filter>"; 
  
    if ( document.implementation.createDocument )
    { 
      var parser = new DOMParser(); 
      xmlDoc = parser.parseFromString(xmlString, "text/xml"); 
    }
    else { 
      xmlDoc = new ActiveXObject("Microsoft.XMLDOM") 
      xmlDoc.async = "false"; 
      xmlDoc.loadXML(xmlString);   
    } 
    last_id = 0;
  }

  function NewFilter()
  {
    if ( !confirm(MSG_ASK_NEW) ) return;
    CloseAllPopups();
    html_clear();
    xml_clear();

    var output = document.getElementById('filter');
    var rules = xmlDoc.documentElement.childNodes;
    output.appendChild( ReadRules(rules[0]) );
  }
