/* ----------------------------------------------------------------------
   cimon - a UNIX command line client for the fli4l imon daemon.            

   Public domain, 2001-2002, Rene Herman <rene.herman@mail.com>         
---------------------------------------------------------------------- */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <limits.h>

#include <unistd.h>

#include "cimon.h"

#define HELP "\
Usage: %s [OPTION]... HOST [COMMAND]\n\
Communicate with the IMON daemon at HOST.\n\
\n\
  -f FILE         read commands from file FILE\n\
  -p PASSWORD     login with password PASSWORD\n\
  -t PORT         connect to HOST at port number PORT\n\
  -h              display this help and exit\n\
  -V              output version information and exit\n\
\n\
When COMMAND is absent and FILE is absent or - read commands from stdin.\n"

#define VERSION "0.9.6"

int main(int argc, char *argv[])
{
    int         i;
    const char *filename = NULL;
    
    program_name = argv[0];
    while ((i = getopt(argc, argv, "f:p:t:hV")) != -1)
        switch (i) {
        case 'f':
            filename = optarg;
            break;
        case 'p':
            password = optarg;
            break;
        case 't': {
            char *s;
            long  l = strtol(optarg, &s, 0);
            if (*s || l < 1 || l > (long)USHRT_MAX)
                exit_error("Invalid port number `%s'", optarg);
            port = l;
            break;
        }
        case 'h':
            printf(HELP, program_name);
            return EXIT_SUCCESS;
        case 'V':
            puts(VERSION);
            return EXIT_SUCCESS;
        default:
            exit_usage(NULL);
        }
        
    if (!(argc -= optind)) 
        exit_usage("No host argument supplied");
    if (--argc && filename)
        exit_usage("Cannot read from file and command line at the same time");

    imon_open(*(argv += optind));
    if (argc) /* get commands from command line */
        for (;;) {
            imon_puts(*++argv);
            if (!--argc)
                break;
            imon_putc(' ');
        }
    else { /* get commands from stdin or file */
        if (!filename || !strcmp(filename, "-"))
            filename = "stdin";
        else if (!freopen(filename, "r", stdin))
            exit_errno(filename);
        while ((i = getchar()) != EOF)
            imon_putc(i);
        if (ferror(stdin))
            exit_errno(filename);
    }
    imon_quit();

    return EXIT_SUCCESS;
}
