/* --------------------------------------------------------------------- */
/*  REXX - START OF SCRIPT - Last modified June 17 995                   */
/*                                                                       */
/*  Program: Small REXX script to copy entries for SlipPM, within        */
/*           TCPOS2.INI, either via command line parameters, or          */
/*           Interactively.                                              */
/*                                                                       */
/*  Author:  Ethan Hall-Beyer                                            */
/*           eahallbe@undergrad.math.uwaterloo.ca                        */
/*                                                                       */
/* --------------------------------------------------------------------- */


/* take two arguments, source and target. */

parse arg source target

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

                       
say ''
say ''
say 'COPY-IAK ver 1.01 - Ethan Hall-Beyer, Team OS/2 Canada, June 1995'
say '(Use, copy, modify, distribute as you wish!)'
say ''
say '    Syntax:    copy-iak [<sourceentry> <targetentry>]'
say ''


/* verify whether arguments are given */
ParMode = 'true'
if target = '' then do
   ParMode = 'false'
   if source <> '' then
      say 'COPY-IAK requires two parameters. See syntax.'
end


/* Get the ETC global OS/2 environment, which is set by IAK installation */
TcpipEtc = translate(value('etc',,'OS2ENVIRONMENT'))
if TcpipEtc = '' then do
   say 'OS/2 ETC= environment variable not defined. IAK not properly installed!'
   exit 9
end
SourceINI = tcpipEtc || '\TCPOS2.INI'


/* verify file exists. */
'@attrib -s ' || SourceINI || ' > nul'
if stream(SourceINI,'c','query exists') = '' then do
   say 'Can''t find system source file ' || SourceINI || '! Exiting.'
   exit 9
end
'@attrib +s ' || SourceINI || ' > nul'


/* Back up original file */
say '--'
say 'Backing up ' || SourceINI || ' as ' || tcpipEtc || '\TCPOS2.BKP.'
'@attrib -s ' || SourceINI
'@copy ' || SourceINI || ' ' || tcpipEtc || '\TCPOS2.BKP >nul'
'@attrib +s ' || SourceINI





/* MAIN LOOP */

/* loop forever. Means to exit are provided in loop, user input. */
do forever

   /* first do the stuff needed when there are no parameters. */
   if ParMode = 'false' then do

      /* Now get a list of all the current applications in TCPOS2.INI */
      rc = SysIni(SourceINI,'ALL:',CurrentIAK)
      say ''
      say 'Current IAK entries in ' || SourceINI || ':'
      say ''


      /* got through an display all but 'CONNECTION' and see which entry is */
      /* the offset. */
      Offset = 0
      WhereOffset = 0
      do i = 1 to CurrentIAK.0
         /* test to see if not the application */
/*       say 'Current iak for ' || i || ' is ' || CurrentIAK.i
         say 'Offset is ' || WhereOffset
*/       if CurrentIAK.i <> 'CONNECTION' then do
            say '   ' || i-offset || ')  ' || CurrentIAK.i
         if offset <> 1 then
            WhereOffset = WhereOffset + 1
      end
      else
         offset = 1
      end
      say ''


      /* Get in target name. */
      do forever until IAKEntry = 'good'
         say 'Copy which entry? (1 - ' || CurrentIAK.0 - offset || ', or ''quit'' to exit.)'
         parse upper pull CopyChoice
         if CopyChoice = 'QUIT' then
            exit 0
         else
         if (CopyChoice < 1) | (CopyChoice > (CurrentIAK.0 - offset)) then do
            IAKEntry = 'nogood'
            say ' - Invalid input, try again'
         end /* if */
         else
            IAKEntry = 'good'
      end
      if CopyChoice > WhereOffset then
         CopyChoice = CopyChoice + Offset
      say 'Choice is ' || CopyChoice

      /* Now get the name for the new entry. */
      say '--'
      say 'Enter name for copy of ' || CurrentIAK.CopyChoice || '.'
      say 'Entry will be truncated to 10 characters. Do not included non-alphanumeric'
      say 'characters (ie !, /, @, etc.)'
      parse pull NewName
      NewName = strip(substr(NewName,1,10))

   end /* if parmode false, get user info, etc. */


   /* now do the step is parmode is true - verify source exists. */
   if ParMode = 'true' then do
      SourceEntry = source
      TargetEntry = target
      /* check the first key of any valid entry. */
      if SysIni(SourceINI,SourceEntry,'AUTOSTART') = 'ERROR:' then do
         say 'The specified source ''' || SourceEntry || ''' is invalid. Exiting.'
         say ''
         exit 9
      end
   end
   else do
      /* now define SourceEntry, TargetEntry for non-parmode. */
      SourceEntry = CurrentIAK.CopyChoice
      TargetEntry = NewName
   end /* if parmode = true. */



   /* Now go through and and read/write all the new values. */
   /* First get the keys for source entry, and trap if not 41. */
   rc = SysIni(SourceINI,SourceEntry,'ALL:',SourceKey)
   say '--'
   say 'Copying ' || SourceKey.0 || ' entry keys...'
   say ''

   /* cycle through and read/write them. */
   do i = 1 to SourceKey.0
      say 'Copying ' || SourceKey.i || '...'
      readvalue = SysIni(SourceINI,SourceEntry,SourceKey.i)
      if readvalue = 'ERROR:' then do
         say 'An error occured reading key ' || SourceKey.i ||'. Exiting.'
         exit 9
      end
      rc = SysIni(SourceINI,TargetEntry,SourceKey.i,readvalue)
      if rc = 'ERROR:' then do
         say 'An error occured writing key ' || SourceKey.i ||'. Exiting.'
         exit 9
      end

   end

   /* Now write the main CONNECTION key. */
   say ''
   say 'Updating CONNECTION with new entry...'
   ConnectValue = SysIni(SourceINI,'CONNECTION',SourceEntry)
   if ConnectValue = 'ERROR:' then do
         say 'An error occured reading CONNECTION key. Exiting.'
         exit 9
   end
   rc = SysIni(SourceINI,'CONNECTION',TargetEntry,ConnectValue)
   if rc = 'ERROR:' then do
      say 'An error occured writing CONNECTION key. Exiting.'
      exit 9
   end


   /* add some blank space... */
   say ''
   say 'Done!'
   say ''
   say ''

   /* exit if it was via parameters. */
   if ParMode = 'true' then
      exit 0

end  /* do forever */


/* --------------------------------------------------------------------- */
/*  END OF SCRIPT.                                                       */
/* --------------------------------------------------------------------- */
