/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Vector;

public class Isdnpm {
    private Socket isdnpmSocket;
    private PrintWriter out;
    private BufferedReader in;

    public Isdnpm() {
    }

    public Isdnpm(String string, int n) throws IOException {
        this.openSocket(string, n);
    }

    public void openSocket(String string, int n) throws IOException {
        this.isdnpmSocket = new Socket(InetAddress.getByName(string), n);
        this.out = new PrintWriter(this.isdnpmSocket.getOutputStream(), true);
        this.in = new BufferedReader(new InputStreamReader(this.isdnpmSocket.getInputStream()));
    }

    public void exit() throws ISDNPMCommandException, IOException {
        this.sendCommand("EXIT");
    }

    public void closeSocket() throws IOException, IOException {
        this.isdnpmSocket.close();
    }

    protected void finalize() throws Throwable {
        try {
            this.exit();
            this.closeSocket();
        }
        catch (ISDNPMCommandException iSDNPMCommandException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        super.finalize();
    }

    private String parseStringValue(String string, String string2) {
        StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(string));
        streamTokenizer.quoteChar(34);
        while (streamTokenizer.ttype != -1) {
            try {
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype != -3 || !streamTokenizer.sval.equalsIgnoreCase(string2) || streamTokenizer.nextToken() != 61 || streamTokenizer.nextToken() != 34) continue;
                return streamTokenizer.sval;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private int parseIntValue(String string, String string2) {
        return (int)this.parseLongValue(string, string2);
    }

    private long parseLongValue(String string, String string2) {
        StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(string));
        streamTokenizer.quoteChar(34);
        while (streamTokenizer.ttype != -1) {
            try {
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype != -3 || !streamTokenizer.sval.equalsIgnoreCase(string2) || streamTokenizer.nextToken() != 61 || streamTokenizer.nextToken() != -2) continue;
                return (long)streamTokenizer.nval;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return -1L;
    }

    public boolean getDialInmode() throws ISDNPMCommandException, IOException {
        return 1 == this.parseIntValue(this.sendCommand("DIALINMODE"), "DIALINMODE");
    }

    public boolean getAutomode() throws ISDNPMCommandException, IOException {
        return 1 == this.parseIntValue(this.sendCommand("AUTOMODE"), "AUTOMODE");
    }

    public boolean getMultimode() throws ISDNPMCommandException, IOException {
        return 1 == this.parseIntValue(this.sendCommand("MULTIMODE"), "MULTIMODE");
    }

    public void update() throws ISDNPMCommandException, IOException {
        this.sendCommand("UPDATE");
    }

    public void shutdown() throws ISDNPMCommandException, IOException {
        this.sendCommand("SHUTDOWN");
    }

    public void restart(int n) throws ISDNPMCommandException, IOException {
        this.sendCommand("RESTART VAL=" + String.valueOf(n));
    }

    public void setDialInmode(boolean bl) throws ISDNPMCommandException, IOException {
        if (bl) {
            this.sendCommand("DIALINMODE LEVEL=1");
        } else {
            this.sendCommand("DIALINMODE LEVEL=0");
        }
    }

    public void setAutomode(boolean bl) throws ISDNPMCommandException, IOException {
        if (bl) {
            this.sendCommand("AUTOMODE LEVEL=1");
        } else {
            this.sendCommand("AUTOMODE LEVEL=0");
        }
    }

    public void setMultimode(boolean bl) throws ISDNPMCommandException, IOException {
        if (bl) {
            this.sendCommand("MULTIMODE LEVEL=1");
        } else {
            this.sendCommand("MULTIMODE LEVEL=0");
        }
    }

    public void setAutodial(String string, boolean bl) throws ISDNPMCommandException, IOException {
        if (bl) {
            this.sendCommand("SETUAUTODIAL NAME=\"" + string + "\"");
        } else {
            this.sendCommand("RESETUAUTODIAL NAME=\"" + string + "\"");
        }
    }

    public void setMultilink(String string, boolean bl) throws ISDNPMCommandException, IOException {
        if (bl) {
            this.sendCommand("SETUMULTILINK NAME=\"" + string + "\"");
        } else {
            this.sendCommand("RESETUMULTILINK NAME=\"" + string + "\"");
        }
    }

    public void callByCall(CallByCallEntry callByCallEntry) throws ISDNPMCommandException, IOException {
        this.sendCommand("CALLBYCALL CONN=\"NAME:" + callByCallEntry.getName() + "\\n" + "CPN:" + callByCallEntry.getNumber() + "\\n" + "PROFILE:" + callByCallEntry.getProfile() + "\\n" + "USERID:" + callByCallEntry.getUserID() + "\\n" + "PASSWORD:" + callByCallEntry.getPassword() + "\"");
    }

    public String getVersion() throws ISDNPMCommandException, IOException {
        return this.parseStringValue(this.sendCommand("VERSION"), "VERSION");
    }

    public int getChannels() throws ISDNPMCommandException, IOException {
        return this.parseIntValue(this.sendCommand("CHANNELS"), "CHANNELS");
    }

    public User[] getUsers() throws ISDNPMCommandException, IOException {
        String string = this.sendCommand("USERLIST");
        Vector<User> vector = new Vector<User>();
        User user = null;
        StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(string));
        streamTokenizer.quoteChar(34);
        while (streamTokenizer.ttype != -1) {
            try {
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == -3 && streamTokenizer.sval.equalsIgnoreCase("CN") && streamTokenizer.nextToken() == 61 && streamTokenizer.nextToken() == 34) {
                    user = new User();
                    user.setName(streamTokenizer.sval);
                }
                if (streamTokenizer.ttype == -3 && streamTokenizer.sval.equalsIgnoreCase("CI") && streamTokenizer.nextToken() == 61 && streamTokenizer.nextToken() == 34) {
                    user.setInfo(streamTokenizer.sval);
                }
                if (streamTokenizer.ttype == -3 && streamTokenizer.sval.equalsIgnoreCase("ON") && streamTokenizer.nextToken() == 61 && streamTokenizer.nextToken() == 34) {
                    user.setNumber(streamTokenizer.sval);
                    if (user != null) {
                        vector.addElement(user);
                    }
                }
                if (streamTokenizer.ttype != -3 || !streamTokenizer.sval.equalsIgnoreCase("DM") || streamTokenizer.nextToken() != 61 || streamTokenizer.nextToken() != 34) continue;
                if (streamTokenizer.sval.indexOf(65) != -1) {
                    user.setAutodial(true);
                } else {
                    user.setAutodial(false);
                }
                if (streamTokenizer.sval.indexOf(77) != -1) {
                    user.setMultilink(true);
                } else {
                    user.setMultilink(false);
                }
                user.setInfo(streamTokenizer.sval);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        Object[] objectArray = new User[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void logon(String string, String string2) throws ISDNPMCommandException, IOException {
        this.sendCommand("AUTH UID=" + string + " PWD=" + string2);
    }

    public Status getISDNStatus(int n) throws ISDNPMCommandException, IOException {
        return this.getISDNStatus(n, new Status());
    }

    public void callByCall(String string, String string2, String string3, String string4, String string5) {
    }

    public Status getISDNStatus(int n, Status status) throws ISDNPMCommandException, IOException {
        String string = this.sendCommand("STATUSLOW CHANNEL=" + String.valueOf(n));
        status.setStatus(this.parseIntValue(string, "STAT"));
        status.setName(this.parseStringValue(string, "NAME"));
        status.setMessage(this.parseStringValue(string, "MSG"));
        status.setError(this.parseStringValue(string, "ERR"));
        status.setBytes(this.parseLongValue(string, "TXB"), this.parseLongValue(string, "RXB"));
        status.setPackets(this.parseLongValue(string, "TXP"), this.parseLongValue(string, "RXP"));
        status.setRates(this.parseIntValue(string, "TXR"), this.parseIntValue(string, "RXR"));
        status.setTime(this.parseIntValue(string, "TT"));
        return status;
    }

    public Status getIPStatus(int n) throws ISDNPMCommandException, IOException {
        return this.getIPStatus(n, new Status());
    }

    public Status getIPStatus(int n, Status status) throws ISDNPMCommandException, IOException {
        String string = this.sendCommand("STATUSHIGH CHANNEL=" + String.valueOf(n));
        status.setStatus(this.parseIntValue(string, "STAT"));
        status.setName(this.parseStringValue(string, "NAME"));
        status.setMessage(this.parseStringValue(string, "MSG"));
        status.setBytes(this.parseLongValue(string, "TXB"), this.parseLongValue(string, "RXB"));
        status.setPackets(this.parseLongValue(string, "TXP"), this.parseLongValue(string, "RXP"));
        status.setRates(this.parseIntValue(string, "TXR"), this.parseIntValue(string, "RXR"));
        status.setAddress(this.parseStringValue(string, "IPA"));
        return status;
    }

    public void ConnectUser(User user) throws ISDNPMCommandException, IOException {
        this.sendCommand("CONNECT NAME=\"" + user.getName() + "\"");
    }

    public void DisconnectUser(User user) throws ISDNPMCommandException, IOException {
        this.sendCommand("DISCONNECT NAME=\"" + user.getName() + "\"");
    }

    public void DisconnectChannel(int n) throws ISDNPMCommandException, IOException {
        this.sendCommand("DISCONNECT CHANNEL=" + String.valueOf(n));
    }

    public synchronized String sendCommand(String string) throws ISDNPMCommandException, IOException {
        String string2 = "";
        this.out.println("CMD=" + string);
        string2 = this.in.readLine();
        if (!string2.startsWith("RC=0")) {
            throw new ISDNPMCommandException("Command: \"" + string + "\"" + " Result: \"" + string2 + "\"");
        }
        string2 = string2.length() > 5 ? string2.substring(5) : "";
        System.out.println(string2);
        return string2;
    }
}

