/***************************************************************************
 * configm.fnc
 *
 * Sample for T-DSL-Connection 
 *       the command syntax is for TCP/IP 4.1 and later
 *
 *       WICHTIG: Abweichende MTU-Size (1492) bei PPPoE notwendig!
****************************************************************************/

 call RxFuncAdd 'SysSleep','RexxUtil','SysSleep'
 call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
 call SysLoadFuncs

 /* read parameter */
 PARSE ARG  action ifname ifnumber txt1 local txt2 remote txt3 dns1 txt4 dns2 txt5 nbdns1 txt6 nbdns2 txt7 netmask txt8 name txt9 default txt10 mmode txt11 doresolve txt12 lineoutname .

 /* display parameters in more readable form */
 PARSE SOURCE . . CallName
 PARSE ARG . . . MoreParms;
 CALL LOGSAY CallName 'started for' action 'of interface' ifname'/'ifnumber;

 DO WHILE (MoreParms \= '')
    PARSE VAR MoreParms ThisName ThisValue MoreParms;
    CALL LOGSAY  ' ' ThisName ThisValue;
 END;


/****************************************************************/
/*   CALLED WHEN ISDNPM IS STARTED FOR A SPECIFIC INTERFACE     */
/****************************************************************/

 if ACTION = 'START'  then do

    say 'START FOR INTERFACE ' ifname  ' NUMBER ' ifnumber

    'route delete default'
    'ifconfig sl0  192.168.254.1 netmask 255.255.255.0 mtu 1492'
    'ifconfig sl0  mtu 1492'
    'route add net default 192.168.254.1'
    'ifconfig lo 127.0.0.1'

 end

/****************************************************************/
/*   CALLED WHEN ISDNPM IS STOPPED FOR A SPECIFIC INTERFACE     */
/****************************************************************/

 if ACTION = 'STOP' then do

    'route delete default'

    'route add default 192.168.5.103 -hopcount 1'

/*  say 'STOP FOR INTERFACE ' ifname   ' NUMBER ' ifnumber
*/
 end


/****************************************************************/
/* CALLED WHEN ISDNPM OPENS A 'PPP-LINK' FOR A INTERFACE        */
/****************************************************************/

 if ACTION = 'OPEN' then do

    say 'CONFIG FOR INTERFACE ' ifname   ' NUMBER ' ifnumber
    say 'CONFIG ' txt1 local
    say 'CONFIG ' txt2 remote
    say 'CONFIG ' txt9 default

    say "Nameserver1="||dns1
    say "Nameserver2="||dns2

 end

/****************************************************************/
/* CALLED WHEN ISDNPM CLOSE A 'PPP-LINK' FOR A INTERFACE        */
/****************************************************************/

 if ACTION = 'CLOSE' then do
/*
    say 'RESET FOR INTERFACE ' ifname   ' NUMBER ' ifnumber
*/
 end

exit 0


/* ------------------------------------------------------------------------- */
/* write a line to console and logfile                                       */
/* name and place of the logfile is the same as of the script, but with      */
/* extension .log, The file must exist in order to be written.               */
/* ------------------------------------------------------------------------- */
LOGSAY: PROCEDURE

 LogId       = '[#]';
 TimeStamp   = TRANSLATE( 'abcd/ef/gh', DATE('S'), 'abcdefgh') TIME()':';

 PARSE ARG Line;
 PARSE SOURCE . . CallName;
 LogFile = OVERLAY( '.log', CallName, LASTPOS( '.', CallName));
 IF (FileExist( LogFile)) THEN
 DO
    rc = LINEOUT( LogFile, TimeStamp Line);
    rc = LINEOUT( LogFile);
 END;

 SAY LogId Line;
 RETURN( 0);

/* ------------------------------------------------------------------------- */
/* determines if a given file exists                                         */
/* ------------------------------------------------------------------------- */
FileExist: PROCEDURE
 PARSE ARG FileName
 RETURN(STREAM(Filename, 'C', 'QUERY EXISTS') > '');

/* ------------------------------------------------------------------------- */
/* determines filesize                                                       */
/* ------------------------------------------------------------------------- */
FileSize: PROCEDURE
 PARSE ARG FileName
 RETURN(STREAM(Filename, 'C', 'QUERY SIZE'));

