/***************************************************************************
 * 
 * SOCK.CMD  - Modifizierte PIPE.CMD fr Socket-Schnittstelle
 * Stand: 26.10.2001
 *
 * Aenderungen: 06.09.2000  - Tobias.Grimm@gmx.de 
 *              28.09.2000  - Tobias.Grimm@gmx.de (Neue Kommandos)
 *              27.08.2001  - K. Schmidthaus
 *              26.10.2001  - Tobias.Grimm@gmx.de (DIALINMODE)
 *
 ****************************************************************************/

signal on HALT

signal on FAILURE
signal on ERROR
signal on SYNTAX

call RxFuncAdd 'SysSleep','RexxUtil','SysSleep'
call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
call SysLoadFuncs

/* Configuration */
lcHostAddr = "127.0.0.1"
lnPort    = 4000
lcAuthLine = "cmd=auth uid=LocalUser pwd=Local"
lcConnectionName = "SAMPLE1"
lnCount = 60

/* load socket-lib: */

If RxFuncQuery("SockLoadFuncs") Then
Do
  Call RxFuncAdd "SockLoadFuncs","RXSOCK","SockLoadFuncs"
  Call SockLoadFuncs
End


/* socket variable for the connection: */

Socket = SockSocket("AF_INET", "SOCK_STREAM", "0")


/******************************************************************************/
/*                                                                            */
/*      there are some commands which can be send to 'isdnPm' over            */
/*      a named PIPE ("\PIPE\ISDNPM30\CPIPE                                   */
/*                                                                            */
/*      'CMD=AUTH UID=User Pwd=password': Authentificate connection           */
/*                                        must be the first command after     */
/*                                        connection                          */
/*                                                                            */
/*      'CMD=VERSION'                   : query for Version                   */
/*      'CMD=CHANNELS'                  : query numer of channels             */
/*      'CMD=USERLIST                   : query users (only outgoing)         */
/*                                                                            */
/*      'CMD=CONNECT NAME="onnx"'       : connect to 'connx'                  */
/*      'CMD=CALLBYCALL' CONN="xxx"'    : connect to xxx                      */
/*      'CMD=DISCONNECT NAME="connx"'   : disconnect 'connx'                  */
/*      'CMD=DISCONNECT CHANNEL=n'      : disconnect channel n (1,2...)       */
/*      'CMD=DISCONNECT CHANNEL=0'      : disconnect all channels             */
/*      'CMD=STATUSLOW  CHANNEL=n'      : query status of ISDN-Channel n      */
/*      'CMD=STATUSHIGH CHANNEL=n'      : query status of IP-Channel   n      */
/*                                                                            */
/*      'CMD=AUTOMODE'                  : query AUTODIALMODE                  */
/*      'CMD=AUTOMODE LEVEL=0'          : set AUTODIALMODE OFF                */
/*      'CMD=AUTOMODE LEVEL=1'          : set AUTODIALMODE ON                 */
/*      'CMD=MULTIMODE                  : query MULTILINKMODE                 */
/*      'CMD=MULTIMODE LEVEL=0'         : set MULTILINKMODE OFF               */
/*      'CMD=MULTIMODE LEVEL=1'         : set MULTILINKMODE ON                */
/*      'CMD=DIALINMODE                 : query DIALINMODE                    */
/*      'CMD=DIALINMODE LEVEL=0'        : set DIALINMODE OFF                  */
/*      'CMD=DIALINMODE LEVEL=1'        : set DIALINMODE ON                   */
/*                                                                            */
/*      'CMD=SETUMULTILINK NAME=XXX'    : aktivate Multilink for User XXX     */
/*                                        until it is updated from file       */
/*      'CMD=RESETUMULTILINK NAME=XXX'  : turn off Multilink for User XXX     */
/*                                        until it is updated from file       */
/*      'CMD=SETUAUTODIAL NAME=XXX'     : aktivate AutoDial for User XXX      */
/*                                        until it is updated from file       */
/*      'CMD=RESETUAUTODIAL NAME=XXX'   : turn off AutoDial for User XXX      */
/*                                        until it is updated from file       */
/*                                                                            */
/*      'CMD=UPDATE'                    : update all connections from file    */
/*                                                                            */
/*      'CMD=EXIT'                      : disconnect from PIPE                */
/*                                                                            */
/*      'CMD=SHUTDOWN'                  : shutdown Isdnpm (with ExitCode 1)   */
/*      'CMD=RESTART VAL=n'             : shutdown Isdnpm (with 1 + val)      */
/*                                        VAL=1 is ExitCode 2 for example     */
/*                                                                            */
/*      all unknown commands return 'RC=1'                                    */
/*                                                                            */
/*      Version is returned with :                                            */
/*                                                                            */
/*          'RC=0 VERSION="xxxxxxxxx"'                                        */
/*                                                                            */
/*      Channels are returned with :                                          */
/*                                                                            */
/*          'RC=0 CHANNELS=n'                                                 */
/*                                                                            */
/*      Userlist is returned with :                                           */
/*          'RC=0  CN="Name" CI="Info" ON="Number" CN=........'               */
/*                                                                            */
/*      Autodialmode is returned with :                                       */
/*                                                                            */
/*          'RC=0 AUTOMODE=n'                                                 */
/*                                                                            */
/*      Multilinkmode is returned with :                                      */
/*                                                                            */
/*          'RC=0 MULTIMODE=n'                                                */
/*                                                                            */
/*      Channelstatus is returned with :                                      */
/*                                                                            */
/*          'RC=0 STATUS=s NAME="name" MSG="msg" ERR="err"      ...           */
/*          ...     TxB=transbytes RxB=recbytes ....                          */
/*          ...     TxP=transpaket RxP=recpaket ....                          */
/*          ...     TxR=transrate  RxR=recrate  ....                          */
/*          ...     TT=connectiontime                                         */
/*                  IPA="ipaddress"                                           */
/*                                                                            */
/*          Stat 's'  : 0 means DOWN                                          */
/*          Stat 's'  : 1 means CONNECTED (isdn)                              */
/*          Stat 's'  : 2 means OPEN (ip)                                     */
/*          Stat 's'  : 3 means connection established                        */
/*                                                                            */
/******************************************************************************/

CRLF='0d0a'x

    CALL SysCls

    Pos = SysCurPos(2,0)
    say "  ISDNPM-Control via IP-Socket " 
    say

    /* Open Socket Connection: */

    rc = Connect(lcHostAddr,lnPort); 
    if rc < 0 then
    do
        say
        say "Socket Connect Error !!!"
        call SysSleep(5)
        exit 0
    end

    RC = SendCommandAndWait(lcAuthLine||CRLF)
    if rc < 0 then
    do
        say
        say "Authentification Error !!!"
        call SysSleep(5)
        exit 0
    end

    /* request version information */
    say SendCommandAndWait("cmd=version"||CRLF)
    say

    /* Create Call by Call commandstring */
    cbc = 'CMD=CALLBYCALL CONN="'
    cbc = cbc || ' \n'
    cbc = cbc || ' Name : c1\n'
    cbc = cbc || ' Cpn  : 076129876543\n'
    cbc = cbc || ' Profile  : PPP_SYNC\n'
    cbc = cbc || ' Userid   : xxxx\n'
    cbc = cbc || ' Password : xxxxxxxx\n'
    cbc = cbc || ' \n"'

    /* Start Call by Call connection */
/*
    say SendCommandAndWAit(cbc||CRLF)
*/

    /* Create commandstring for Call by name */
    cbn = 'CMD=CONNECT NAME='||lcConnectionName

    /* Start Call by Call connection */
/*
    say SendCommandAndWAit(cbn||CRLF)
*/

    count = 0
    do while count < lnCount
        Pos = SysCurPos(12,0)
        say "Channel-Status HIGH/LOW"
        say SendCommandAndWAit("CMD=STATUSHIGH CHANNEL=1"||CRLF)
        say SendCommandAndWAit("CMD=STATUSLOW  CHANNEL=1"||CRLF)
        count = count + 1
        call SysSleep(1)
    end

    say SendCommandAndWAit("CMD=EXIT"||CRLF)


    /* Close Socket Connection: */

    rc= Disconnect()

exit 0

/**************************************************************************/
/* connect the socket                                                     */
/**************************************************************************/
Connect:
parse arg ip, port
  Socket = SockSocket("AF_INET", "SOCK_STREAM", "0")
  Call SockGetHostByAddr ip, "Host.!" 
  Host.!family = "AF_INET"
  Host.!port = port
  rc=SockConnect( Socket, "Host.!")
return rc

/**************************************************************************/
/* disconnect the socket                                                  */
/**************************************************************************/
DisConnect:
    Call SockShutDown Socket, 2
    Call SockClose Socket
return 0

/**************************************************************************/
/* send a command to the socket and wait for an answer                    */
/**************************************************************************/
SendCommandAndWait:
parse arg Command
    rc=SockSend(Socket, COMMAND)
    if rc > 0 then
        rc=SockRecv(Socket, "in", 256)
    if rc <= 0 then in =TIMEOUT
return in

