/*  Install.CMD
 *  -----------
 *  Copyright (c) Cornelis Bockemuehl, 1998
 *
 *  Install InjoyPB program:
 *  - Create desktop objects
 *  - Start automatic configuration
 */

'@echo off'

/* Load RexxUtil functions */
if RxFuncQuery('SysLoadFuncs') then do
   call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
   call SysLoadFuncs
end
crlf=d2c(13)||d2c(10)

/* Greeting */
say "***********************"
say "Installation of InjoyPB"
say "***********************"

/* Get the Injoy directory */
dirlist.0=0
do until 1=dirlist.0
  say ""
  say "Enter INJOY program directory as <drive>:\<path>,"
  say "(e.g. D:\Injoy)"
  say "Note: InjoyPB will be installed into the new subdirectory IJPB."
  ijdir=linein()
  rc=SysFileTree(ijdir,dirlist,"D")
  if 0=dirlist.0 then do
    do until (aa="Y") | (aa="N")
      say ""
      say "Directory "ijdir" not found:"
      say "Create and use anyway? (y/n)"
      pull aa .
    end
    if aa="Y" then do
      rc=SysMkDir(ijdir)
      if 0<>rc then do
        say ""
        say "Error creating subdirectory "ijpbdir
        exit
      end
      dirlist.0=1
    end
  end
  else do
    rc=SysFileTree(ijdir'\in-joy.exe',dirlist,"F")
    if 0=dirlist.0 then do
      do until (aa="Y") | (aa="N")
        say ""
        say "In-joy.exe not found in "ijdir":"
        say "Use anyway? (y/n)"
        pull aa .
      end
      if aa="Y" then
        dirlist.0=1
    end
  end
end

/* Create subdirectory */
say "Creating subdirectory..."
ijpbdir=ijdir||'\IJPB'
rc=SysFileTree(ijpbdir,dirlist,"D")
if 1=dirlist.0 then do
  do until (aa="Y") | (aa="N")
    say ""
    say "Directory "ijpbdir" already exists:"
    say "Overwrite existing program files? (y/n)"
    pull aa .
  end
  if aa="N" then do
    say ""
    say "Installation aborted"
    exit
  end
end
else do
  rc=SysMkDir(ijpbdir)
  if 0<>rc then do
    say ""
    say "Error creating subdirectory "ijpbdir
    exit
  end
end

/* Copy files */
say ""
say "Copying files..."
'copy Readme.DOC 'ijpbdir' >nul'
'copy InjoyPB.EXE 'ijpbdir' >nul'
'copy Install.CMD 'ijpbdir' >nul'
'copy Config.CMD 'ijpbdir' >nul'
'copy DeInst.CMD 'ijpbdir' >nul'
'copy CalcMany.CMD 'ijpbdir' >nul'
'copy ConfigA.ICO 'ijpbdir' >nul'
'copy Docs.ICO 'ijpbdir' >nul'
'copy Folder.ICO 'ijpbdir' >nul'
'copy ConfigM.ICO 'ijpbdir' >nul'
'copy InjoyPB.ICO 'ijpbdir' >nul'
rc=SysFileTree(ijpbdir'\InjoyPB.CFG',dirlist,"F")
if 0=dirlist.0 then
  'copy InjoyPB.CFG 'ijpbdir' >nul'
else do
  say "Old configuration file InjoyPB.CFG found:"
  do until (aa="L") | (aa="O")
    say "Leave or overwrite it? (l/o)"
    pull aa .
  end
  if "O"=aa then do
    'if exist 'ijpbdir'\InjoyPB.OLD delete 'ijpbdir'\InjoyPB.OLD >nul'
    'rename 'ijpbdir'\InjoyPB.CFG InjoyPB.OLD >nul'
    'copy InjoyPB.CFG 'ijpbdir' >nul'
    say "Old configuration file renamed as InjoyPB.OLD"
  end
end

/* Change to InjoyPB directory */
rc=SysFileTree(ijpbdir,dirlist,"DO")
substr(dirlist.1,1,2)
'cd 'substr(dirlist.1,3)

/* Ask for desktop object creation */
do until (aa="Y") | (aa="N")
  say ""
  say "Do you want to create desktop objects? (y/n)"
  pull aa .
end
if aa="N" then do
  say ""
  say "No desktop objects created"
  say "Type INJOYPB to create monthly phone bill."
  say "Type CONFIG to configure your tariff system."
  say "Read README.DOC for further information."
end

/* Create desktop objects */
else do
  say ""
  say "Creating folder..."
  call SysCreateObject "WPFolder","InJoy Phone Bill", ,
                       "<WP_DESKTOP>", ,
                       "OBJECTID=<INJOYPBFOLDER>;"|| ,
                       "ICONFILE="||ijpbdir||"\Folder.ICO;"|| ,
                       "ICONVIEW=FLOWED,NORMAL;"|| ,
                       "ALWAYSSORT=NO;"|| ,
                       "DEFAULTVIEW=ICON", ,
                       "REPLACE"
  say "Creating program objects..."
  call SysCreateObject "WPProgram","InjoyPB Documentation", ,
                       "<INJOYPBFOLDER>", ,
                       "OBJECTID=<INJOYPBDOCUMENT>;"|| ,
                       "ICONFILE="||ijpbdir||"\Docs.ICO;"|| ,
                       "EXENAME=E.EXE;"|| ,
                       "PARAMETERS="||ijpbdir||"\Readme.DOC", ,
                       "REPLACE"
  call SysCreateObject "WPProgram","Edit InjoyPB.CFG (Manual config.)", ,
                       "<INJOYPBFOLDER>", ,
                       "OBJECTID=<INJOYPBMANCONF>;"|| ,
                       "ICONFILE="||ijpbdir||"\ConfigM.ICO;"|| ,
                       "EXENAME=E.EXE;"|| ,
                       "PARAMETERS="||ijpbdir||"\InjoyPB.CFG", ,
                       "REPLACE"
  call SysCreateObject "WPProgram","InjoyPB Auto Configuration", ,
                       "<INJOYPBFOLDER>", ,
                       "OBJECTID=<INJOYPBAUTOCONF>;"|| ,
                       "ICONFILE="||ijpbdir||"\ConfigA.ICO;"|| ,
                       "EXENAME="||ijpbdir||"\Config.CMD;"|| ,
                       "STARTUPDIR="||ijpbdir, ,
                       "REPLACE"
  call SysCreateObject "WPProgram", ,
                       "Injoy Phone Bill"||crlf||"default", ,
                       "<INJOYPBFOLDER>", ,
                       "OBJECTID=<INJOYPBPROGRAM>;"|| ,
                       "ICONFILE="||ijpbdir||"\InjoyPB.ICO;"|| ,
                       "EXENAME="||ijpbdir||"\InjoyPB.EXE;"|| ,
                       "STARTUPDIR="||ijpbdir||";"|| ,
                       "PARAMETERS=default [month (1-12)];"|| ,
                       "NOAUTOCLOSE=YES", ,
                       "REPLACE"
  call SysCreateObject "WPProgram", ,
                       "Injoy Phone Bill"||crlf||"all hosts", ,
                       "<INJOYPBFOLDER>", ,
                       "OBJECTID=<INJOYPBALLHOSTS>;"|| ,
                       "ICONFILE="||ijpbdir||"\InjoyPB.ICO;"|| ,
                       "EXENAME="||ijpbdir||"\CalcMany.CMD;"|| ,
                       "STARTUPDIR="||ijpbdir||";"|| ,
                       "PARAMETERS=* [month (1-12)];"|| ,
                       "NOAUTOCLOSE=NO;MINIMIZED=YES", ,
                       "REPLACE"
end

/* Ask for configuration */
do until (aa="Y") | (aa="N")
  say ""
  say "Do you want to configure InjoyPB now? (y/n)"
  say "(If you don't, you can do it any time later using CONFIG.)"
  pull aa .
end

/* Start configuration */
if aa="Y" then do
  "CALL Config.CMD"
end

say ""
say "Installation of InjoyPB done"
