/*---------------------------------------------------------------------------*\
|  GETALL  - Link all GETxxx.CMD & create object on the WorkPlaceShell        |
|                         (C) Alain Rykaert & Dieter Van Besien - JAN96-OCT96 |
\*---------------------------------------------------------------------------*/

    Version = '2.05'

 /*- Start of Variables -----------------------------------------------------*/

    PRGNAME.0 = 8          ; OUTPUT.0 =  PRGNAME.0
    PRGNAME.1 = 'GetSrvs'  ; OUTPUT.1 = 'Servers.CSV'
    PRGNAME.2 = 'GetUsers' ; OUTPUT.2 = 'Users.CSV'
    PRGNAME.3 = 'GetGrps1' ; OUTPUT.3 = 'Groups1.CSV'
    PRGNAME.4 = 'GetGrps2' ; OUTPUT.4 = 'Groups2.CSV'
    PRGNAME.5 = 'GetAlias' ; OUTPUT.5 = 'Alias.CSV'
    PRGNAME.6 = 'GetACL'   ; OUTPUT.6 = 'Acl.CSV'
    PRGNAME.7 = 'GetAssgn' ; OUTPUT.7 = 'Assgn.CSV'
    PRGNAME.8 = 'GetAppl'  ; OUTPUT.8 = 'Appl.CSV'
 /* PRGNAME.9 = 'GetSel'   ; OUTPUT.9 = 'Selector.CSV' */

 /* if the GETSEL procedure is needed, remove the remarks symbols from
    previous line and increment the value of PRGNAME.0 by 1 on line 8    */

 /*- End of Variables -------------------------------------------------------*/

    Parse Arg Option

    Call Init                    /* Initialisation of DLL's and other stuff*/
    Call ChkOpt                                            /* Check Options*/
    Call ChkCSD                  /* Check current CSD levels of PWS and SRV*/
    Call Main                                          /* do the main thing*/
    Call Quit                                         /* Quit the procedure*/

 MAIN:/* ------------------------------------------------------ MAIN: -------*/

    Call ChkServer DCName                /* Check if this is the Primary DC*/

 /* Get the Domain name from the DC-PR */

    Call SysFileSearch 'DOMAIN =', '\\'DCName'\ibmlan$\ibmlan.ini', 'FILE.'
    if FILE.0 > 0
     then do i = 1 to FILE.0
             if POS(';', Translate(FILE.i)) = 0
              then Parse Value FILE.i with . '=' DomainName .
              else Nop
          end
     else do
             say ESC'[0;1;31m Unable to determine the Domains name',
                    'from the Primary Domain Controller' DCName ESC'[0m'
            'Pause'
             Exit
          end

    say
    say '09'x ESC'[0;1;35m The Domains name is' DomainName ESC'[0m'

 /* Check if a directory exist for this domain. If needed, create it */

    TargetDir = Directory()'\'DomainName

    Call ChkDir TargetDir

    do i = 1 to PRGNAME.0
       'Call' PRGNAME.i '/SRV:'DCName '/OUT:'TargetDir'\'OUTPUT.i '/LOG:'TargetDir'\'LOGF '/PIP:'PIPE MUTE
/*      Call MakeShadow OUTPUT.i Location    /* Make Shadow of Output_Files*/
     */
    end

/*  Call MakeShadow 'HOMEACL.CSV' Location    /* Make Shadow of HOMEACL.CSV*/
  */
    Call SysSetObjectData Directory()'\LSMT.LOG', 'ICONFILE='Directory()'\LOG.ICO'
/*
    Call MakeShadow 'LSMT.LOG'    Location       /* Make Shadow of LSMT.LOG*/

    Call MakeShadow 'USERS.PWD'   Location      /* Make Shadow of USERS.PWD*/
  */

 /* Display Get Passwords message */
    Topic_List = 'GETPASSWORDS'
    Call GETANS

    Return

 INIT:/* ------------------------------------------------------ INIT: -------*/

   '@echo off'
    ESC = '1B'x
    Call RgUtil '/M'                                 /* Init Rexx Utilities*/
    Call RgUtils  '/M'                                    /* Rexx Utilities*/
    Call RgLSRXUT '/M'                             /* Lan Server Rexx Utils*/

    BD = Left(SysSearchPath('PATH', 'CMD.EXE'), 2)          /* BOOT   Drive*/

    Parse Upper Source . . P_NAME
    PRGN = Filespec('N', Left(P_NAME, Length(P_NAME) -4))

    Resource_File = 'LSMT.RSC'                 /* Ansi Topics Resource File*/
    Call CHKFILE Resource_File

    Return

 CHKOPT:/* ---------------------------------------------------- CHKOPT: -----*/

    DCNAme = ''
    LOGF   = 'LSMT.LOG'
    PIPE   = ''
    MUTE   = ''

    OPTION = Translate(OPTION)
    do while OPTION <> ''
       Parse value OPTION with ARGUMENT ' ' OPTION
       select
        when Left(ARGUMENT,5) = '/SRV:'  then DCName = Substr(ARGUMENT,6)
        when Left(ARGUMENT,5) = '/LOG:'  then LOGF   = Substr(ARGUMENT,6)
        when Left(ARGUMENT,5) = '/PIP:'  then PIPE   = Substr(ARGUMENT,6)
        when Left(ARGUMENT,2) = '/M'     then MUTE   = '/M'
        otherwise Nop
       end
    end

    if DCName = '',
     | Left(DCName,2) = '\\'
       then signal GETHELP

    Return

 MAKESHADOW:/* --------------------------------------------------------------*/

    Parse Arg Title FileName Location

    if Stream(FileName, 'C', 'QUERY EXISTS') = ''
     then Nop
     else do
             Class    = 'WPShadow'
             Title    =  Title
             Location =  Location
             Setup    = 'SHADOWID='FileName
             Update   = 'Update'

             Call CreateObj

          end

    Return

 CREATEOBJ:/* ------------------------------------------------- CREATEOBJ: --*/

    RC = SysCreateObject(Class, Title, Location, Setup, Update)
    if RC <> 1
       then say ESC'[0;1;41m ErrorCode' RC Title ESC'[0m'
       else Nop

    Return

 GETHELP:/* --------------------------------------------------- GETHELP: ----*/

    Topic1                = 'LSMTHELP'
    Topic_String.Topic1.1 =  PRGN
    Topic_String.Topic1.2 =  PRGN
    Topic_List            =  Topic1
    Call GETANS
    Call Quit

    Return

 GETANS:/* ---------------------------------------------------- GETANS: -----*/

    Vars_List = Ansi_Say(Resource_File Topic_List)
    Parse VALUE SysCurPos() With Old_R Old_C
    Do While Vars_List <> ''
       Parse Value Vars_List With Topic_Id ';' Var_Id ';' Row ';' Column ';' Color ';' Vars_List
       Call SysCurPos Row, Column
       Say X2C(Color) || Topic_String.Topic_Id.Var_Id || '1B'x || '[0m'
    End
    Call SysCurPos Old_R, Old_C

    Return

 CHKFILE:/* --------------------------------------------------- CHKFILE: ----*/

    Parse Arg FILE
    RC = Stream(FILE, 'C', 'QUERY EXIST')
    if RC = ''
     then do
             say ' File' FILE 'not found.'
             Call Quit
          end
     else Nop

    Return

 CHKCSD:/* ---------------------------------------------------- CHKCSD: -----*/

    BD = Left(SysSearchPath('PATH', 'CMD.EXE'), 2)          /* BOOT   Drive*/
    ID = Left(SysSearchPath('PATH', 'NET.EXE'), 2)          /* IBMLAN Drive*/

    if BD = '' | ID = ''
     then do
             say ESC'[0;1;36m Unable to determine the OS/2 Boot Drive' ESC'[0m'
             say ESC'[0;1;36m or the OS/2 Lan Requester Drive.'        ESC'[0m'
             Call Quit
          end

    REQ_CSD = SubStr(LineIn(ID'\IBMLAN\SYSLEVEL.REQ'),48,4)
    Call Stream ID'\IBMLAN\SYSLEVEL.REQ', 'C', 'CLOSE'

    SRV_CSD = SubStr(LineIn('\\'DCName'\IBMLAN$\SYSLEVEL.SRV'),48,4)
    Call Stream '\\'DCName'\IBMLAN$\SYSLEVEL.SRV', 'C', 'CLOSE'

    if MUTE = '/M'
     then Nop
     else do
             say ESC'[0;1;33m +-------------------+'ESC'[0m'
             say ESC'[0;1;33m ! CSD on PWS =' REQ_CSD '!'ESC'[0m'
             say ESC'[0;1;33m ! CSD on SRV =' SRV_CSD '!'ESC'[0m'
             say ESC'[0;1;33m +-------------------+'ESC'[0m'
          end

    if REQ_CSD < '7045' | SRV_CSD < '7045'
     then do
             say ' 'ESC'[0;1;41m    * * * W A R N I N G * * *      ' ESC'[0m'
             say ' 'ESC'[0;41m The minimum Lan Requester & Server'   ESC'[0m'
             say ' 'ESC'[0;41m version must be : 3.0 CSD IPx7045 '   ESC'[0m'
            'pause'
          end
     else Nop

    Return

 CHKSERVER:/* ------------------------------------------------- CHKSERVER: --*/

    Parse Arg Server

    say
    say ESC'[0;1;33m Check if' Server 'is a Primary Domain Controller ...' ESC'[0m'

    Parse value SysCurPos() with ROW COL
    Call SysCurPos ROW -1, 55

    RC = NetGetInfo(370, 'ServerModalInfo', '\\'Server)

    if RC = 0 & ServerModalInfo.Role = 'Primary server in the domain'
     then say ESC'[0;1;42m OK' ESC'[0m'
     else do
             say ESC'[0;1;41m Not OK' ESC'[0m'
            'start popup "This is not a Primary DC" "LSMT Message"'
             Call Quit
          end

    Return

 CHKDIR:/* ---------------------------------------------------- CHKDIR: ---*/

    Parse Arg Dir_Name

    RCode = 0                                      /* Reset the Return Code*/

    if Stream(Dir_Name, 'C', 'QUERY EXIST') <> ''       /* is this a file ?*/
     then RCode = 1    /* Bad RC, there already exist a file with this name*/
     else do
             Call SysFileTree Dir_Name, 'DIREXIST', 'DO'/* does this DIR exist ?*/
             if DIREXIST.0 = 0
              then do
                      RC = SysMKDir(Dir_Name)
                      if RC <> 0
                       then RCode = 1
                       else Nop
                   end
              else Nop
          end

    if RCode = 1
     then do
             Call Beep 1000,100
             say 'Error while creating' Dir_Name
             Pull
             Exit
          end
     else Nop

    Return

 QUIT:/* ------------------------------------------------------ QUIT: -------*/

    say
    say ESC'[0;1;33m Done. Press the [Enter] key to leave' ESC'[0m'

    Pull

    Exit

 /*--------------------------------------------------------------------------*/

